#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Ondrej Vasik <ovasik@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_rpm_to "" ""
COMPONENT="distribution"
#END GENERATED SECTION

grep -q "-debuginfo[[:space:]]" "$VALUE_RPM_RHSIGNED" || exit_pass

log_high_risk "Debuginfo packages are detected on the system, debuginfo repository has to be provided as parameter to redhat-upgrade-tool for proper upgrade."
log_slight_risk "Dependencies can cause incompleteness of the debugging tree after the upgrade, you may need to install additional debuginfos after upgrade."
exit_fail
