#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Ondrej Vasik <ovasik@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_rpm_to "" ""
COMPONENT="distribution"
#END GENERATED SECTION

[ ! -r systemids ] && log_error generic Part of the content is missing! && \
  exit $RESULT_ERROR

founderror=0
rm solution.txt
echo \
"On Red Hat Enterprise Linux 6, system account ids were bellow 500.
This changes on Red Hat Enterprise Linux 7, range reserved for
system account is now 0-999. This may cause troubles for the
migration. In addition, range 0-199 is prohibited to use without
static id reservation in setup package. Id's in this range might
be reserved and used later by some package, thus using them may cause
malfunction of such package.

Following problems were found on your system:
" >solution.txt

# Check for invalid range user ids
for i in `cat $VALUE_PASSWD | cut -d':' -f1-4`
do
  # Is id greater than 999? Nothing to do
  [ `echo $i | cut -d':' -f3` -gt 999 ] && continue

  myname=`echo $i | cut -d':' -f1`
  # RHEL 6 uid user range 500-999
  if [ `echo $i | cut -d':' -f3` -gt 499 ]
  then
  echo " User \"$myname\" uses id `echo $i | cut -d':' -f3` - this is in the range of system accounts." >>solution.txt
  founderror=1
  continue
  fi

  # Reserved system user ID range use
  if [ `echo $i | cut -d':' -f3` -lt 200 ]
  then
    grep " $myname " systemids >/dev/null 2>/dev/null && continue
    echo " System account \"$myname\" uses id `echo $i | cut -d':' -f3` without reservation - this is prohibited and may cause migration issues!" >>solution.txt
    log_slight_risk "System account \"$myname\" uses id `echo $i | cut -d':' -f3` in prohibited range without reservation - potential migration issue!"
    founderror=1
  fi
done

[ $founderror -eq 1 ] && echo >>solution.txt
# Check for invalid range group ids
for i in `cat $VALUE_GROUP | cut -d':' -f1-4`
do
  # Is id greater than 999? Nothing to do
  [ `echo $i | cut -d':' -f3` -gt 999 ] && continue

  myname=`echo $i | cut -d':' -f1`
  # rhel-6 gid user range 500-999
  if [ `echo $i | cut -d':' -f3` -gt 499 ]
  then
  echo " group \"$myname\" uses id `echo $i | cut -d':' -f3` - this is in the range of system accounts." >>solution.txt
  founderror=1
  continue
  fi

  # Reserved system group ID range use
  if [ `echo $i | cut -d':' -f3` -lt 200 ]
  then
    grep " $myname " systemids >/dev/null 2>/dev/null && continue
    echo " System group \"$myname\" uses id `echo $i | cut -d':' -f3` without reservation - this is prohibited and may cause migration issues!" >>solution.txt
    log_slight_risk "System group \"$myname\" uses id `echo $i | cut -d':' -f3` in prohibited range without reservation - potential migration issue!"
    founderror=1
  fi
done

echo \
"

These accounts should be migrated into the \"safe\" zone above 1000!
As an alternative, you can change the default ranges in /etc/login.defs to
the old RHEL 6 values if you require this by your system setup settings.
" >>solution.txt
#FIXME: Provide some solution scripts to change either /etc/login.defs or
#to migrate the users to "safe range"

[ $founderror -eq 1 ] && exit $RESULT_FAIL

#no issues found, so remove solution text
rm solution.txt && touch solution.txt
exit $RESULT_PASS
