#! /usr/bin/env bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Boris Ranto <branto@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "xorg-x11-server-Xorg"
COMPONENT="xorg-x11-server-Xorg"
#END GENERATED SECTION

# We need to have Xorg installed to check for presence of any available gnome sessions

RESULT="$RESULT_PASS"
if test -f /usr/share/xsessions/gnome.desktop; then
	log_extreme_risk "You have GNOME Desktop Environment session as an option in your X11 session manager. GNOME Desktop Environment as a part of the yum group 'Desktop' underwent serious redesign in its user interface as well as underlying technologies in Red Hat Enterprise Linux 7."
	RESULT="$RESULT_FAIL"
fi

PKGS="NetworkManager-gnome control-center gdm gdm-user-switch-applet gnome-panel gnome-power-manager gnome-screensaver gnome-session gnome-terminal gvfs-archive gvfs-fuse gvfs-smb metacity nautilus notification-daemon polkit-gnome xdg-user-dirs-gtk yelp control-center-extra eog gdm-plugin-fingerprint gnome-applets gnome-media gnome-packagekit gnome-vfs2-smb gok orca vino"
DPKGS=""

for pkg in $PKGS; do
	if rpm -q --quiet $pkg; then
		test "$RESULT" = "$RESULT_FAIL" || log_high_risk "You have some of the Desktop group packages installed in your system. GNOME Desktop Environment that was provided by this group of packages underwent serious redesign in its user interface as well as underlying technologies in Red Hat Enterprise Linux 7."
		DPKGS="$DPKGS $pkg"
		RESULT="$RESULT_FAIL"
	fi
done

rm -f solution.txt
# Generate solution.txt
if test "$RESULT" = "$RESULT_FAIL"; then
	echo "GNOME Desktop Environment as a part of the yum group 'Desktop' underwent serious redesign in its user interface as well as underlying technologies in Red Hat Enterprise Linux 7. The users of the desktop environment need to be educated about these changes before upgrade. GNOME classic user interface is provided in Red Hat Enterprise Linux 7 to lower the impact of this change but the interface still contains several discrepancies from the older version and the users need to be warned about them." >> solution.txt
fi

if test -n "$DPKGS"; then
	echo "The following packages from yum group 'Desktop' that provides GNOME Desktop Environment were detected to be installed in your system:$DPKGS" >> solution.txt
fi
exit "$RESULT"
