#!/bin/bash

#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Ondrej Vasik <ovasik@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
COMPONENT="distribution"
#END GENERATED SECTION

cp /proc/partitions $VALUE_TMP_PREUPGRADE/kickstart/
cp /etc/fstab $VALUE_TMP_PREUPGRADE/kickstart/

echo " * partitions - copy of system /proc/partitions file, may be used in kickstart for disk layout" >>"$VALUE_TMP_PREUPGRADE/kickstart/README"
echo " * fstab - copy of automated system mountpoints from /etc/fstab" >>"$VALUE_TMP_PREUPGRADE/kickstart/README"

grep [[:space:]]ext4[[:space:]] /etc/fstab >/dev/null && exit $RESULT_INFORMATIONAL

exit $RESULT_PASS
