#! /usr/bin/env bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Hracek <phracek@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "kernel"
COMPONENT="kernel"
#END GENERATED SECTION

ARCH=`arch`

[ -z $ARCH ] && exit $RESULT_ERROR

if [ $ARCH == 'ppc64' ]; then
    grep '^cpu.*POWER6' /proc/cpuinfo
    if [ $? -eq 0 ]; then
        log_extreme_risk 'POWER6 processors are not supported on ppc and ppc64 architectures on Red Hat Enterprise Linux 7 systems'
        exit $RESULT_FAIL
    fi
fi

exit $RESULT_PASS
