#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Hracek <phracek@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
COMPONENT="distribution"
#END GENERATED SECTION

COMPONENT="kernel-kdump"
myarch=$(arch)
ZIPL_CONF="/etc/zipl.conf"
#strange output of myarch? Bad luck...
[ -z "$myarch" ] && exit $RESULT_ERROR
#Do we have 32 bit architecture?
if [[ x"$myarch" == x"s390x" ]]; then
    grep "kernel-kdump" $VALUE_RPM_RHSIGNED
    if [[ $? -eq 0 ]]; then
        log_high_risk "Package kernel-kdump is installed - must be removed before upgrade."
        grep -q ".kdump]$" $ZIPL_CONF \
          && log_high_risk "Found 'kdump' item from $ZIPL_CONF. Must be removed before upgrade and set right default item."
        exit $RESULT_FAILED
    else
        exit $RESULT_PASS
    fi
fi
exit $RESULT_NOT_APPLICABLE
