#!/bin/bash

#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Stodulka <pstodulk@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
COMPONENT="distribution"
#END GENERATED SECTION

line=$( grep  -nm 1 "^\s*Match" /etc/ssh/sshd_config | cut -d ":" -f 1 )

[[ $line == "" ]] && exit $RESULT_PASS

lines=$[ $( wc -l /etc/ssh/sshd_config | cut -d " " -f 1 ) - $line ]
cat /etc/ssh/sshd_config | tail -n $lines | grep -q "^\s*AuthorizedKeysCommand"

[[ $? -ne 0 ]] && exit $RESULT_PASS


log_medium_risk "Options AuthorizedKeysCommand or AuthorizedKeysCommandUser were detected in Match section."

echo "Options AuthorizedKeysCommand or AuthorizedKeysCommandUser were
detected in Match section. These options possibly will not be accepted inside 
this section. Please check it. Bug will be patched in future. For more
information see https://bugzilla.redhat.com/show_bug.cgi?id=1105119" >> solution.txt

exit $RESULT_FAIL

