#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Hracek <phracek@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
COMPONENT="distribution"
#END GENERATED SECTION

COMPONENT="YABOOT"

myarch=`arch`
yaboot="/usr/bin/yaboot"

[ -z $myarch ] && exit $RESULT_ERROR

if [ x"$myarch" != x"ppc64" ];
then
    exit $RESULT_NOT_APPLICABLE
fi

rpm --quiet -q yaboot

if [ $? -ne 0 ];
then
	log_error "Yaboot rpm not found. You probably do not use yaboot. This is unsupported. Preupgrade Assistant can not know for sure which boot mechanism is in use."
	exit_error
fi

RHELUP_PREUPGRADE_DIR="$VALUE_TMP_PREUPGRADE/preupgrade-scripts"
grub_check="$RHELUP_PREUPGRADE_DIR/yaboot_group.sh"

cat <<EOF >$grub_check
#!/bin/bash

if [ "\$(id -u)" != 0 ]; then
    echo >&2 "please, run this under 'root' user"
    exit 1
fi

log_function () {
	echo "YABOOT preupgrade script: \$1"
}

GRUB2_CONF="/etc/default/grub"
log_function "Check if \$GRUB2_CONF file exists..."
if [ ! -f "\$GRUB2_CONF" ]; then
    log_function "\$GRUB2_CONF does not exist."
    log_function "Create \$GRUB2_CONF for successful inplace upgrade."
    exit 1
fi
log_function "\$GRUB2_CONF exists."

exit 0
EOF

chmod +x "$grub_check"
POSTUPGRADE_DIR="$VALUE_TMP_PREUPGRADE/postupgrade.d/yaboot"
if [[ ! -d "$POSTUPGRADE_DIR" ]]; then
	mkdir -p "$POSTUPGRADE_DIR"
fi
SCRIPT_NAME="postupgrade-yaboot.sh"
POST_SCRIPT="postupgrade.d/$SCRIPT_NAME"
cp -f $POST_SCRIPT $POSTUPGRADE_DIR/$SCRIPT_NAME
if [ ! -f '/etc/default/grub' ]; then
	log_extreme_risk "Yaboot was detected on this system. /etc/default/grub must be created."
	exit_fail
fi
exit_informational
