#!/usr/bin/python

import ConfigParser
import logging
import sys

logging.basicConfig(format='kernel-dump-preupgrade: %(levelname)s: %(message)s',
                    level=logging.INFO)

ZIPL_CONF = "/etc/zipl.conf"


def main():
    try:
        f = open(ZIPL_CONF, 'r')
        lines = f.readlines()
        f.close()
        output = open(ZIPL_CONF, 'w')
        found_kdump = False
        for cnt, line in enumerate(lines):
            if line.strip().endswith('.kdump]'):
                found_kdump = True
                continue
            if line.strip().endswith(']'):
                found_kdump = False
                output.write(line)
                continue
            if found_kdump is False:
                output.write(line)
        output.close()
    except IOError:
        return 1

if __name__ == "__main__":
    sys.exit(main())
