#!/bin/bash
#
# Author: Honza Horak <hhorak@redhat.com>
#
# Description:
# This script checks that there are some users with UID between 500 and 1000,
# which can make problems after upgrading to RHEL 7, because MINUID was changed
# to 1000 in RHEL 7. Users with UID between 500 and 1000 can be excluded from
# lookup results, which is wrong.
# It uses current domainname set and tries to open passwd.byuid map in
# the current domain.


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Honza Horak <hhorak@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "ypserv"
check_rpm_to "python, python-libs" ""
COMPONENT="ypserv"
#END GENERATED SECTION

check_root

. ../common.sh

ypserv_configured || exit $RESULT_NOT_APPLICABLE

get_domainname

 ./dangerous_uid.py "$DOMAINNAME"

UID_RESULT=$?

if [ $UID_RESULT -eq 2 ] ; then
    exit $RESULT_NOT_APPLICABLE
fi

read -r -d '' SOLUTION <<'EOF'
There are some UIDs between 500 and 1000 in passwd.byuid NIS map,
which can make troubles after upgrading, because MINUID/MINGID
are by default 1000 in RHEL 7. Checking for proper MINUID/MINGID
settings or changing UID/GID for such users is advised.
EOF

if [ $UID_RESULT -eq 0 ] ; then
    log_slight_risk "$SOLUTION"
    solution_file "$SOLUTION"
    exit_fail
fi

exit $RESULT_PASS

