#!/bin/bash

#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Stodulka <pstodulk@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
COMPONENT="distribution"
#END GENERATED SECTION

rm -f solution.txt
touch solution.txt

[ -f "/etc/xinetd.d/rsync" ] || exit $RESULT_NOT_APPCLICABLE

grep -qE "^[[:space:]]*disable[[:space:]]*=[[:space:]]*no" /etc/xinetd.d/rsync
[ $? -eq 1 ] && exit $RESULT_PASS

log_high_risk "rsync is activated by socket"
echo "Rsync is activated by socket is not working right on RHEL-7 systems now.
If you want rsync socket activation on RHEL-7 systems, you can use xinetd:
$ mv /etc/xinetd.d/rsync.rpmsave /etc/xinetd.d/rsync
$ systemd enable xinetd

Or you can try create unit file /etc/systemd/system/rsyncd\@.service for systemd:
[Unit]
Description=fast remote file copy program daemon
ConditionPathExists=/etc/rsyncd.conf

[Service]
EnvironmentFile=/etc/sysconfig/rsyncd
ExecStart=/usr/bin/rsync --daemon --no-detach "$OPTIONS"
StandardInput=socket
" > solution.txt

exit $RESULT_FAIL

