#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Ondrej Vasik <ovasik@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_rpm_to "" ""
COMPONENT="distribution"
#END GENERATED SECTION

[ ! -f "$VALUE_RPM_RHSIGNED" ] && \
  log_error generic Common content part is missing! &&
  exit $RESULT_ERROR

[ ! -r SonameBumpInfo ] && \
  log_error generic Part of the content is missing! && \
  exit $RESULT_ERROR

found=0
statuscode=$RESULT_INFORMATIONAL
rm -f solution.txt >/dev/null
echo \
"Application developed in C may use dynamic libraries (.so files) to reuse the
common functions/symbols in the binary. If the library bumped its soname (
changed major version, API/ABI incompatibility), application that depends on
it may not run.
Some of the libraries changed the soname version between Red Hat Enterprise
Linux 6 and Red Hat Enterprise Linux 7.

From your RHEL 6 packages, following libraries changed soname:
" >solution.txt


#Check for soname bumps and report them for RH packages installed on the system
for i in `cat SonameBumpInfo`
do
  for j in `echo $i | cut -d':' -f2 | sed -e 's/|/ /g'`
  do
    #skip non-rh and unavailable packages
    grep -e "^$j[[:space:]]" "$VALUE_RPM_RHSIGNED" >/dev/null || continue
    m=" (required by NonRH signed package(s):"
    for l in `rpm -q --whatrequires $j | grep -v "no package requires" | \
     rev | cut -d'-' -f3- | rev`
    do
      grep -e "^$l[[:space:]]" "$VALUE_RPM_RHSIGNED" >/dev/null || m="$m$l "
    done
    m="$m)"
    [ "$m" == " (required by NonRH signed package(s):)" ] && m=""
    [ -n "$m" ] && log_high_risk "Library $j$m changed soname between RHEL 6 and RHEL 7" && \
      statuscode=$RESULT_FAIL 
    k=`echo $i | cut -d':' -f3`
    echo "`echo $i | cut -d':' -f1` from $j$m changed to $k" >>solution.txt
    found=1
  done
done

grep required solution.txt >>"$VALUE_TMP_PREUPGRADE/kickstart/SonameBumpedLibs-required"
grep -v required solution.txt | grep -v " " | grep -v "^$" >> "$VALUE_TMP_PREUPGRADE/kickstart/SonameBumpedLibs-optional"
grep required "$VALUE_TMP_PREUPGRADE/kickstart/SonameBumpedLibs-required" || rm "$VALUE_TMP_PREUPGRADE/kickstart/SonameBumpedLibs-required"
grep [a-zA-Z] "$VALUE_TMP_PREUPGRADE/kickstart/SonameBumpedLibs-optional" || rm "$VALUE_TMP_PREUPGRADE/kickstart/SonameBumpedLibs-optional"
[ -f "$VALUE_TMP_PREUPGRADE/kickstart/SonameBumpedLibs-required" ] && \
  echo " * SonameBumpedLibs-required - This file contains all RHEL 6 libraries from your system, where soname version changed. As some of your packages depends on it, you will need to rebuild it against this library." >>"$VALUE_TMP_PREUPGRADE/kickstart/README"
[ -f "$VALUE_TMP_PREUPGRADE/kickstart/SonameBumpedLibs-optional" ] && \
  echo " * SonameBumpedLibs-optional - Similar to SonameBumpedLibs-required, but in this case no non-rh package requires this. It is more informational thing for you - so you can deal with potential required rebuild." >>"$VALUE_TMP_PREUPGRADE/kickstart/README"

echo \
"
We checked the requirements in Non-RH signed packages, but for the non
rpm-packaged binaries, you should check the compatibility list yourself
by using e.g. ldd <binary> command.
If some of your application uses the library on the list above, you will
need to rebuild such package/application against new library.
Red Hat Enterprise Linux applications available on the RHEL 7 will handle
these bumps automatically by the update/migration to new Red Hat Enterprise
Linux as they were already built against these libraries.
" >>solution.txt

[ $found -eq 1 ] && log_medium_risk "\
 We detected some soname bumps in the libraries installed on the system. This may break the functionality of some of your 3rd party applications. They may need rebuild. Please check their requirements." && \
 exit $statuscode

rm -f solution.txt && touch solution.txt

exit $RESULT_PASS
