#!/usr/bin/python

import ConfigParser
import logging
import sys

logging.basicConfig(format='kernel-dump-preupgrade: %(levelname)s: %(message)s',
                    level=logging.INFO)

ZIPL_CONF = "/etc/zipl.conf"


def main():
    rhelupconf = ConfigParser.ConfigParser()
    rhelupconf.read(ZIPL_CONF)
    try:
        for section in rhelupconf.sections():
            print section
            if section.endswith('.kdump'):
                rhelupconf.remove_section(section)
        try:
            zipl_ini = open(ZIPL_CONF, 'w')
            rhelupconf.write(zipl_ini)
            zipl_ini.close()
        except IOError:
            logging.fatal("We were not able to store updated % file." % ZIPL_CONF)
    except ValueError:
        logging.fatal("Error while reading %s configuration file, aborting." % ZIPL_CONF)
        return 1

if __name__ == "__main__":
    sys.exit(main())
