#!/bin/bash

#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Tomas Tomecek <ttomecek@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "selinux-policy"
COMPONENT="selinux-policy"
#END GENERATED SECTION

TARGET_DIR="${POSTUPGRADE_DIR}/selinux"

mkdir -p ${TARGET_DIR}

# install selinux-sandbox rules if selinux policies are installed
cp -a ./postupgrade.d/00-selinux-sandbox.sh ${TARGET_DIR} || exit ${RESULT_ERROR}

if [[ $(selinuxenabled) -eq 0 ]] ; then
    log_high_risk "There were changes in SELinux policies between RHEL 6 and RHEL 7. Please, check solution in order to resolve this issue."
    cat >solution.txt <<EOF
We have detected that you are using SELinux. There were changes in policies which require to apply custom command before upgrade process. In order to have working SELinux on Red Hat Enterprise Linux 7, you [bold:HAVE TO] run command prior to running redhat-upgrade-tool:
  semodule -r sandbox
EOF
    exit ${RESULT_FAIL}
fi
exit ${RESULT_FIXED}
