#!/bin/bash

#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Stodulka <pstodulk@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
COMPONENT="distribution"
#END GENERATED SECTION

check_root
AUDIT_FLAG=0
fix_audit65="fix_audit65.sh"

check_audit() {
  # this is special case of /etc/audit/audit.rules
  if [ ! -d /etc/audit/rules.d ]; then
    # RHEL6.5 and older
    cp $fix_audit65 $POSTUPGRADE_DIR/$fix_audit65
  else
    # Handle RHEL 6.6 and later this way. If augenrules is not used (AUGENRULES="no")
    # then they need to migrate to the new setup. Otherwise they have already migrated.
    grep -E "^\s*AUGENRULES=" /etc/sysconfig/auditd | grep -i "no"
    [ $? -ne 0 ] && {
      AUDIT_FLAG=1
      return 1
    }
  fi


  return 0
}

declare -a noreplace_files
truncate -s 0 solution.txt
while read line; do
  # remove begin of line (waste) and get flag value:
  #....L....  c /etc/pam.d/system-auth
  fflags=$(rpm -q --qf '[%{filenames}: %{fileflags}\n]' -f ${line:13} | grep "^${line:13}:" | cut -d ":" -f 2)
  [ $[ $fflags & 16 ] -eq 16 ] && \
    noreplace_files+=("${line:13}")
done < $VALUE_CONFIGCHANGED

[ ${#noreplace_files[@]} -gt 0 ] && {
  log_slight_risk "Some config files are changed and .rpmnew files will be generated."
  echo -e "It's recommended check these config files after upgrade on RHEL7:\n" > solution.txt
  for i in ${noreplace_files[@]}; do
    [ "$i" == "/etc/audit/audit.rules" ] && check_audit || { echo "$i" >> solution.txt; }
  done

  [ $AUDIT_FLAG -eq 1 ] && {
    log_high_risk "Audit: manual intervention recommended before migration."
    echo "
Please, give special attention to /etc/audit/* files! File /etc/audit/audit.rules
is now generated by script /sbin/augenrules and your config files must be in
/etc/audit/rules.d/ with .rules  extension. When you have it prepared, create
/etc/audit/audit.rules by /sbin/augenrules. See man 8 augenrules. 
Do this before migration!"
  }
  exit $RESULT_FAIL
}

exit $RESULT_PASS
