#!/bin/bash

#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Stodulka <pstodulk@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
COMPONENT="distribution"
#END GENERATED SECTION

RESULT=$RESULT_INFORMATIONAL
FSTAB=$( cat /etc/fstab | grep -vE "^[[:space:]]*#" \
         | grep [[:space:]]nfs[[:space:]] | grep "nfsvers=2" )

SYSCONF=$( cat /etc/sysconfig/nfs | grep -vE "^[[:space:]]*#" \
           | grep -E "RPCNFSDARGS|RPCMOUNTDOPTS" \
           | grep -E "(\-V|\-\-nfs\-version)[[:space:]]*2" )

NFSMOUNT=$( cat /etc/nfsmount.conf | grep -vE "^[[:space:]]*#" |grep "vers=2" )

_nice_separator="-----------------------------------------------------"
fix_script_name="fix_nfsv2.sh"

rm -f solution.txt
echo "NFS protocol version 2 is not supported since RHEL7.
$_nice_separator" > solution.txt

if [[ "$FSTAB" != "" ]]; then
  log_slight_risk "/etc/fstab: mounts with unsupported protocol NFSv2"
  echo "/etc/fstab mounts by NFSv2 these filesystems:" >> solution.txt
  echo -e "$FSTAB" | awk '{print "    "$1}' >> solution.txt
  #Change protocol version or remove 'nfsvers' option.
  echo "FIXED: option 'nfsvers' in /etc/fstab will be removed by postupgrade script:
  $POSTUPGRADE_DIR/$fix_script_name
$_nice_separator" >> solution.txt

  RESULT=$RESULT_FIXED
fi

if [[ "$NFSMOUNT" != "" ]]; then
  log_medium_risk "/etc/nfsmount.conf contains setting with NFSv2"
  echo "/etc/nfsmount.conf contains:" >> solution.txt
  echo -e "$NFSMOUNT
FIXED: Lines Nfsvers|Defaultvers with value 2 will be commented.
$_nice_separator\n">> solution.txt
  RESULT=$RESULT_FIXED
fi

[ $RESULT -eq $RESULT_FIXED ] \
  &&  cp $fix_script_name $POSTUPGRADE_DIR/$fix_script_name


if [[ "$SYSCONF" != "" ]]; then
  log_medium_risk "/etc/sysconfig/nfs enables unsupported NFSv2"
  echo "/etc/sysconfig/nfs: enabled NFSv2:" >> solution.txt
  echo -e "$SYSCONF\n
Solution: you should change configuration in this file before migration.
$_nice_separator\n\n" >> solution.txt

  RESULT=$RESULT_FAIL
fi



exit $RESULT

