// automatically generated by stateify.

package udp

import (
	"gvisor.dev/gvisor/pkg/state"
	"gvisor.dev/gvisor/pkg/tcpip/buffer"
)

func (u *udpPacket) StateTypeName() string {
	return "pkg/tcpip/transport/udp.udpPacket"
}

func (u *udpPacket) StateFields() []string {
	return []string{
		"udpPacketEntry",
		"senderAddress",
		"destinationAddress",
		"packetInfo",
		"data",
		"timestamp",
		"tos",
	}
}

func (u *udpPacket) beforeSave() {}

// +checklocksignore
func (u *udpPacket) StateSave(stateSinkObject state.Sink) {
	u.beforeSave()
	var dataValue buffer.VectorisedView = u.saveData()
	stateSinkObject.SaveValue(4, dataValue)
	stateSinkObject.Save(0, &u.udpPacketEntry)
	stateSinkObject.Save(1, &u.senderAddress)
	stateSinkObject.Save(2, &u.destinationAddress)
	stateSinkObject.Save(3, &u.packetInfo)
	stateSinkObject.Save(5, &u.timestamp)
	stateSinkObject.Save(6, &u.tos)
}

func (u *udpPacket) afterLoad() {}

// +checklocksignore
func (u *udpPacket) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &u.udpPacketEntry)
	stateSourceObject.Load(1, &u.senderAddress)
	stateSourceObject.Load(2, &u.destinationAddress)
	stateSourceObject.Load(3, &u.packetInfo)
	stateSourceObject.Load(5, &u.timestamp)
	stateSourceObject.Load(6, &u.tos)
	stateSourceObject.LoadValue(4, new(buffer.VectorisedView), func(y interface{}) { u.loadData(y.(buffer.VectorisedView)) })
}

func (e *endpoint) StateTypeName() string {
	return "pkg/tcpip/transport/udp.endpoint"
}

func (e *endpoint) StateFields() []string {
	return []string{
		"TransportEndpointInfo",
		"DefaultSocketOptionsHandler",
		"waiterQueue",
		"uniqueID",
		"rcvReady",
		"rcvList",
		"rcvBufSize",
		"rcvClosed",
		"state",
		"dstPort",
		"ttl",
		"multicastTTL",
		"multicastAddr",
		"multicastNICID",
		"portFlags",
		"lastError",
		"boundBindToDevice",
		"boundPortFlags",
		"sendTOS",
		"shutdownFlags",
		"multicastMemberships",
		"effectiveNetProtos",
		"owner",
		"ops",
		"frozen",
	}
}

// +checklocksignore
func (e *endpoint) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.TransportEndpointInfo)
	stateSinkObject.Save(1, &e.DefaultSocketOptionsHandler)
	stateSinkObject.Save(2, &e.waiterQueue)
	stateSinkObject.Save(3, &e.uniqueID)
	stateSinkObject.Save(4, &e.rcvReady)
	stateSinkObject.Save(5, &e.rcvList)
	stateSinkObject.Save(6, &e.rcvBufSize)
	stateSinkObject.Save(7, &e.rcvClosed)
	stateSinkObject.Save(8, &e.state)
	stateSinkObject.Save(9, &e.dstPort)
	stateSinkObject.Save(10, &e.ttl)
	stateSinkObject.Save(11, &e.multicastTTL)
	stateSinkObject.Save(12, &e.multicastAddr)
	stateSinkObject.Save(13, &e.multicastNICID)
	stateSinkObject.Save(14, &e.portFlags)
	stateSinkObject.Save(15, &e.lastError)
	stateSinkObject.Save(16, &e.boundBindToDevice)
	stateSinkObject.Save(17, &e.boundPortFlags)
	stateSinkObject.Save(18, &e.sendTOS)
	stateSinkObject.Save(19, &e.shutdownFlags)
	stateSinkObject.Save(20, &e.multicastMemberships)
	stateSinkObject.Save(21, &e.effectiveNetProtos)
	stateSinkObject.Save(22, &e.owner)
	stateSinkObject.Save(23, &e.ops)
	stateSinkObject.Save(24, &e.frozen)
}

// +checklocksignore
func (e *endpoint) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.TransportEndpointInfo)
	stateSourceObject.Load(1, &e.DefaultSocketOptionsHandler)
	stateSourceObject.Load(2, &e.waiterQueue)
	stateSourceObject.Load(3, &e.uniqueID)
	stateSourceObject.Load(4, &e.rcvReady)
	stateSourceObject.Load(5, &e.rcvList)
	stateSourceObject.Load(6, &e.rcvBufSize)
	stateSourceObject.Load(7, &e.rcvClosed)
	stateSourceObject.Load(8, &e.state)
	stateSourceObject.Load(9, &e.dstPort)
	stateSourceObject.Load(10, &e.ttl)
	stateSourceObject.Load(11, &e.multicastTTL)
	stateSourceObject.Load(12, &e.multicastAddr)
	stateSourceObject.Load(13, &e.multicastNICID)
	stateSourceObject.Load(14, &e.portFlags)
	stateSourceObject.Load(15, &e.lastError)
	stateSourceObject.Load(16, &e.boundBindToDevice)
	stateSourceObject.Load(17, &e.boundPortFlags)
	stateSourceObject.Load(18, &e.sendTOS)
	stateSourceObject.Load(19, &e.shutdownFlags)
	stateSourceObject.Load(20, &e.multicastMemberships)
	stateSourceObject.Load(21, &e.effectiveNetProtos)
	stateSourceObject.Load(22, &e.owner)
	stateSourceObject.Load(23, &e.ops)
	stateSourceObject.Load(24, &e.frozen)
	stateSourceObject.AfterLoad(e.afterLoad)
}

func (m *multicastMembership) StateTypeName() string {
	return "pkg/tcpip/transport/udp.multicastMembership"
}

func (m *multicastMembership) StateFields() []string {
	return []string{
		"nicID",
		"multicastAddr",
	}
}

func (m *multicastMembership) beforeSave() {}

// +checklocksignore
func (m *multicastMembership) StateSave(stateSinkObject state.Sink) {
	m.beforeSave()
	stateSinkObject.Save(0, &m.nicID)
	stateSinkObject.Save(1, &m.multicastAddr)
}

func (m *multicastMembership) afterLoad() {}

// +checklocksignore
func (m *multicastMembership) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &m.nicID)
	stateSourceObject.Load(1, &m.multicastAddr)
}

func (l *udpPacketList) StateTypeName() string {
	return "pkg/tcpip/transport/udp.udpPacketList"
}

func (l *udpPacketList) StateFields() []string {
	return []string{
		"head",
		"tail",
	}
}

func (l *udpPacketList) beforeSave() {}

// +checklocksignore
func (l *udpPacketList) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.head)
	stateSinkObject.Save(1, &l.tail)
}

func (l *udpPacketList) afterLoad() {}

// +checklocksignore
func (l *udpPacketList) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.head)
	stateSourceObject.Load(1, &l.tail)
}

func (e *udpPacketEntry) StateTypeName() string {
	return "pkg/tcpip/transport/udp.udpPacketEntry"
}

func (e *udpPacketEntry) StateFields() []string {
	return []string{
		"next",
		"prev",
	}
}

func (e *udpPacketEntry) beforeSave() {}

// +checklocksignore
func (e *udpPacketEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.next)
	stateSinkObject.Save(1, &e.prev)
}

func (e *udpPacketEntry) afterLoad() {}

// +checklocksignore
func (e *udpPacketEntry) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.next)
	stateSourceObject.Load(1, &e.prev)
}

func init() {
	state.Register((*udpPacket)(nil))
	state.Register((*endpoint)(nil))
	state.Register((*multicastMembership)(nil))
	state.Register((*udpPacketList)(nil))
	state.Register((*udpPacketEntry)(nil))
}
