% podman-pod-inspect 1

## NAME
podman\-pod\-inspect - Displays information describing a pod

## SYNOPSIS
**podman pod inspect** [*options*] *pod* ...

## DESCRIPTION
Displays configuration and state information about a given pod.  It also displays information about containers
that belong to the pod.

## OPTIONS

#### **--format**, **-f**=*format*

Change the default output format.  This can be of a supported type like 'json'
or a Go template.
Valid placeholders for the Go template are listed below:

| **Placeholder**      | **Description**                             |
|----------------------|---------------------------------------------|
| .BlkioDeviceReadBps  | Block I/O Device Read, in bytes/sec         |
| .BlkioDeviceWriteBps | Block I/O Device Read, in bytes/sec         |
| .BlkioWeight         | Block I/O Weight                            |
| .BlkioWeightDevice   | Block I/O Device Weight                     |
| .CgroupParent        | Pod cgroup parent                           |
| .CgroupPath          | Pod cgroup path                             |
| .Containers          | Pod containers                              |
| .CPUPeriod           | CPU period                                  |
| .CPUQuota            | CPU quota                                   |
| .CPUSetCPUs          | CPU Set CPUs                                |
| .CPUSetMems          | CPU Set Mems                                |
| .CPUShares           | CPU Shares                                  |
| .CreateCgroup        | Whether cgroup was created                  |
| .CreateCommand       | Create command                              |
| .Created             | Time when the pod was created               |
| .CreateInfra         | Whether infrastructure created              |
| .Devices             | Devices                                     |
| .ExitPolicy          | Exit policy                                 |
| .Hostname            | Pod hostname                                |
| .ID                  | Pod ID                                      |
| .InfraConfig ...     | Infra config (contains further fields)      |
| .InfraContainerID    | Pod infrastructure ID                       |
| .InspectPodData ...  | Nested structure, for experts only          |
| .Labels              | Pod labels                                  |
| .MemoryLimit         | Memory limit, bytes                         |
| .MemorySwap          | Memory swap limit, in bytes                 |
| .Mounts              | Mounts                                      |
| .Name                | Pod name                                    |
| .Namespace           | Namespace                                   |
| .NumContainers       | Number of containers in the pod             |
| .SecurityOpts        | Security options                            |
| .SharedNamespaces    | Pod shared namespaces                       |
| .State               | Pod state                                   |
| .VolumesFrom         | Volumes from                                |

#### **--latest**, **-l**

Instead of providing the pod name or ID, use the last created pod. If you use methods other than Podman
to run pods such as CRI-O, the last started pod could be from either of those methods. (This option is not available with the remote Podman client, including Mac and Windows (excluding WSL2) machines)

## EXAMPLE
```
# podman pod inspect foobar
{

     "Id": "3513ca70583dd7ef2bac83331350f6b6c47d7b4e526c908e49d89ebf720e4693",
     "Name": "foobar",
     "Labels": {},
     "CgroupParent": "/libpod_parent",
     "CreateCgroup": true,
     "Created": "2018-08-08T11:15:18.823115347-05:00"
     "State": "created",
     "Hostname": "",
     "SharedNamespaces": [
          "uts",
          "ipc",
          "net"
     ]
     "CreateInfra": false,
     "InfraContainerID": "1020dd70583dd7ff2bac83331350f6b6e007de0d026c908e49d89ebf891d4699"
     "CgroupPath": ""
     "Containers": [
          {
               "id": "d53f8bf1e9730281264aac6e6586e327429f62c704abea4b6afb5d8a2b2c9f2c",
               "state": "configured"
          }
     ]
}
```

## SEE ALSO
**[podman(1)](podman.1.md)**, **[podman-pod(1)](podman-pod.1.md)**, **[podman-inspect(1)](podman-inspect.1.md)**

## HISTORY
August 2018, Originally compiled by Brent Baude <bbaude@redhat.com>
