// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package proto

import (
	context "context"
	proto "github.com/letsencrypt/boulder/core/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// StorageAuthorityClient is the client API for StorageAuthority service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type StorageAuthorityClient interface {
	// Getters
	GetRegistration(ctx context.Context, in *RegistrationID, opts ...grpc.CallOption) (*proto.Registration, error)
	GetRegistrationByKey(ctx context.Context, in *JSONWebKey, opts ...grpc.CallOption) (*proto.Registration, error)
	GetSerialMetadata(ctx context.Context, in *Serial, opts ...grpc.CallOption) (*SerialMetadata, error)
	GetCertificate(ctx context.Context, in *Serial, opts ...grpc.CallOption) (*proto.Certificate, error)
	GetPrecertificate(ctx context.Context, in *Serial, opts ...grpc.CallOption) (*proto.Certificate, error)
	GetCertificateStatus(ctx context.Context, in *Serial, opts ...grpc.CallOption) (*proto.CertificateStatus, error)
	CountCertificatesByNames(ctx context.Context, in *CountCertificatesByNamesRequest, opts ...grpc.CallOption) (*CountByNames, error)
	CountRegistrationsByIP(ctx context.Context, in *CountRegistrationsByIPRequest, opts ...grpc.CallOption) (*Count, error)
	CountRegistrationsByIPRange(ctx context.Context, in *CountRegistrationsByIPRequest, opts ...grpc.CallOption) (*Count, error)
	CountOrders(ctx context.Context, in *CountOrdersRequest, opts ...grpc.CallOption) (*Count, error)
	// Return a count of authorizations with status "invalid" that belong to
	// a given registration ID and expire in the given time range.
	CountFQDNSets(ctx context.Context, in *CountFQDNSetsRequest, opts ...grpc.CallOption) (*Count, error)
	FQDNSetExists(ctx context.Context, in *FQDNSetExistsRequest, opts ...grpc.CallOption) (*Exists, error)
	PreviousCertificateExists(ctx context.Context, in *PreviousCertificateExistsRequest, opts ...grpc.CallOption) (*Exists, error)
	GetAuthorization2(ctx context.Context, in *AuthorizationID2, opts ...grpc.CallOption) (*proto.Authorization, error)
	GetAuthorizations2(ctx context.Context, in *GetAuthorizationsRequest, opts ...grpc.CallOption) (*Authorizations, error)
	GetPendingAuthorization2(ctx context.Context, in *GetPendingAuthorizationRequest, opts ...grpc.CallOption) (*proto.Authorization, error)
	CountPendingAuthorizations2(ctx context.Context, in *RegistrationID, opts ...grpc.CallOption) (*Count, error)
	GetValidOrderAuthorizations2(ctx context.Context, in *GetValidOrderAuthorizationsRequest, opts ...grpc.CallOption) (*Authorizations, error)
	CountInvalidAuthorizations2(ctx context.Context, in *CountInvalidAuthorizationsRequest, opts ...grpc.CallOption) (*Count, error)
	GetValidAuthorizations2(ctx context.Context, in *GetValidAuthorizationsRequest, opts ...grpc.CallOption) (*Authorizations, error)
	KeyBlocked(ctx context.Context, in *KeyBlockedRequest, opts ...grpc.CallOption) (*Exists, error)
	// Adders
	NewRegistration(ctx context.Context, in *proto.Registration, opts ...grpc.CallOption) (*proto.Registration, error)
	UpdateRegistration(ctx context.Context, in *proto.Registration, opts ...grpc.CallOption) (*emptypb.Empty, error)
	AddCertificate(ctx context.Context, in *AddCertificateRequest, opts ...grpc.CallOption) (*AddCertificateResponse, error)
	AddPrecertificate(ctx context.Context, in *AddCertificateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	AddSerial(ctx context.Context, in *AddSerialRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	DeactivateRegistration(ctx context.Context, in *RegistrationID, opts ...grpc.CallOption) (*emptypb.Empty, error)
	NewOrder(ctx context.Context, in *NewOrderRequest, opts ...grpc.CallOption) (*proto.Order, error)
	NewOrderAndAuthzs(ctx context.Context, in *NewOrderAndAuthzsRequest, opts ...grpc.CallOption) (*proto.Order, error)
	SetOrderProcessing(ctx context.Context, in *OrderRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	SetOrderError(ctx context.Context, in *SetOrderErrorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	FinalizeOrder(ctx context.Context, in *FinalizeOrderRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	GetOrder(ctx context.Context, in *OrderRequest, opts ...grpc.CallOption) (*proto.Order, error)
	GetOrderForNames(ctx context.Context, in *GetOrderForNamesRequest, opts ...grpc.CallOption) (*proto.Order, error)
	RevokeCertificate(ctx context.Context, in *RevokeCertificateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	UpdateRevokedCertificate(ctx context.Context, in *RevokeCertificateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	NewAuthorizations2(ctx context.Context, in *AddPendingAuthorizationsRequest, opts ...grpc.CallOption) (*Authorization2IDs, error)
	FinalizeAuthorization2(ctx context.Context, in *FinalizeAuthorizationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	DeactivateAuthorization2(ctx context.Context, in *AuthorizationID2, opts ...grpc.CallOption) (*emptypb.Empty, error)
	AddBlockedKey(ctx context.Context, in *AddBlockedKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type storageAuthorityClient struct {
	cc grpc.ClientConnInterface
}

func NewStorageAuthorityClient(cc grpc.ClientConnInterface) StorageAuthorityClient {
	return &storageAuthorityClient{cc}
}

func (c *storageAuthorityClient) GetRegistration(ctx context.Context, in *RegistrationID, opts ...grpc.CallOption) (*proto.Registration, error) {
	out := new(proto.Registration)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/GetRegistration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) GetRegistrationByKey(ctx context.Context, in *JSONWebKey, opts ...grpc.CallOption) (*proto.Registration, error) {
	out := new(proto.Registration)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/GetRegistrationByKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) GetSerialMetadata(ctx context.Context, in *Serial, opts ...grpc.CallOption) (*SerialMetadata, error) {
	out := new(SerialMetadata)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/GetSerialMetadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) GetCertificate(ctx context.Context, in *Serial, opts ...grpc.CallOption) (*proto.Certificate, error) {
	out := new(proto.Certificate)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/GetCertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) GetPrecertificate(ctx context.Context, in *Serial, opts ...grpc.CallOption) (*proto.Certificate, error) {
	out := new(proto.Certificate)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/GetPrecertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) GetCertificateStatus(ctx context.Context, in *Serial, opts ...grpc.CallOption) (*proto.CertificateStatus, error) {
	out := new(proto.CertificateStatus)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/GetCertificateStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) CountCertificatesByNames(ctx context.Context, in *CountCertificatesByNamesRequest, opts ...grpc.CallOption) (*CountByNames, error) {
	out := new(CountByNames)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/CountCertificatesByNames", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) CountRegistrationsByIP(ctx context.Context, in *CountRegistrationsByIPRequest, opts ...grpc.CallOption) (*Count, error) {
	out := new(Count)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/CountRegistrationsByIP", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) CountRegistrationsByIPRange(ctx context.Context, in *CountRegistrationsByIPRequest, opts ...grpc.CallOption) (*Count, error) {
	out := new(Count)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/CountRegistrationsByIPRange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) CountOrders(ctx context.Context, in *CountOrdersRequest, opts ...grpc.CallOption) (*Count, error) {
	out := new(Count)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/CountOrders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) CountFQDNSets(ctx context.Context, in *CountFQDNSetsRequest, opts ...grpc.CallOption) (*Count, error) {
	out := new(Count)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/CountFQDNSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) FQDNSetExists(ctx context.Context, in *FQDNSetExistsRequest, opts ...grpc.CallOption) (*Exists, error) {
	out := new(Exists)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/FQDNSetExists", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) PreviousCertificateExists(ctx context.Context, in *PreviousCertificateExistsRequest, opts ...grpc.CallOption) (*Exists, error) {
	out := new(Exists)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/PreviousCertificateExists", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) GetAuthorization2(ctx context.Context, in *AuthorizationID2, opts ...grpc.CallOption) (*proto.Authorization, error) {
	out := new(proto.Authorization)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/GetAuthorization2", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) GetAuthorizations2(ctx context.Context, in *GetAuthorizationsRequest, opts ...grpc.CallOption) (*Authorizations, error) {
	out := new(Authorizations)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/GetAuthorizations2", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) GetPendingAuthorization2(ctx context.Context, in *GetPendingAuthorizationRequest, opts ...grpc.CallOption) (*proto.Authorization, error) {
	out := new(proto.Authorization)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/GetPendingAuthorization2", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) CountPendingAuthorizations2(ctx context.Context, in *RegistrationID, opts ...grpc.CallOption) (*Count, error) {
	out := new(Count)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/CountPendingAuthorizations2", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) GetValidOrderAuthorizations2(ctx context.Context, in *GetValidOrderAuthorizationsRequest, opts ...grpc.CallOption) (*Authorizations, error) {
	out := new(Authorizations)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/GetValidOrderAuthorizations2", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) CountInvalidAuthorizations2(ctx context.Context, in *CountInvalidAuthorizationsRequest, opts ...grpc.CallOption) (*Count, error) {
	out := new(Count)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/CountInvalidAuthorizations2", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) GetValidAuthorizations2(ctx context.Context, in *GetValidAuthorizationsRequest, opts ...grpc.CallOption) (*Authorizations, error) {
	out := new(Authorizations)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/GetValidAuthorizations2", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) KeyBlocked(ctx context.Context, in *KeyBlockedRequest, opts ...grpc.CallOption) (*Exists, error) {
	out := new(Exists)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/KeyBlocked", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) NewRegistration(ctx context.Context, in *proto.Registration, opts ...grpc.CallOption) (*proto.Registration, error) {
	out := new(proto.Registration)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/NewRegistration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) UpdateRegistration(ctx context.Context, in *proto.Registration, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/UpdateRegistration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) AddCertificate(ctx context.Context, in *AddCertificateRequest, opts ...grpc.CallOption) (*AddCertificateResponse, error) {
	out := new(AddCertificateResponse)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/AddCertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) AddPrecertificate(ctx context.Context, in *AddCertificateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/AddPrecertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) AddSerial(ctx context.Context, in *AddSerialRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/AddSerial", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) DeactivateRegistration(ctx context.Context, in *RegistrationID, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/DeactivateRegistration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) NewOrder(ctx context.Context, in *NewOrderRequest, opts ...grpc.CallOption) (*proto.Order, error) {
	out := new(proto.Order)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/NewOrder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) NewOrderAndAuthzs(ctx context.Context, in *NewOrderAndAuthzsRequest, opts ...grpc.CallOption) (*proto.Order, error) {
	out := new(proto.Order)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/NewOrderAndAuthzs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) SetOrderProcessing(ctx context.Context, in *OrderRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/SetOrderProcessing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) SetOrderError(ctx context.Context, in *SetOrderErrorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/SetOrderError", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) FinalizeOrder(ctx context.Context, in *FinalizeOrderRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/FinalizeOrder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) GetOrder(ctx context.Context, in *OrderRequest, opts ...grpc.CallOption) (*proto.Order, error) {
	out := new(proto.Order)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/GetOrder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) GetOrderForNames(ctx context.Context, in *GetOrderForNamesRequest, opts ...grpc.CallOption) (*proto.Order, error) {
	out := new(proto.Order)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/GetOrderForNames", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) RevokeCertificate(ctx context.Context, in *RevokeCertificateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/RevokeCertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) UpdateRevokedCertificate(ctx context.Context, in *RevokeCertificateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/UpdateRevokedCertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) NewAuthorizations2(ctx context.Context, in *AddPendingAuthorizationsRequest, opts ...grpc.CallOption) (*Authorization2IDs, error) {
	out := new(Authorization2IDs)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/NewAuthorizations2", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) FinalizeAuthorization2(ctx context.Context, in *FinalizeAuthorizationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/FinalizeAuthorization2", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) DeactivateAuthorization2(ctx context.Context, in *AuthorizationID2, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/DeactivateAuthorization2", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageAuthorityClient) AddBlockedKey(ctx context.Context, in *AddBlockedKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/sa.StorageAuthority/AddBlockedKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StorageAuthorityServer is the server API for StorageAuthority service.
// All implementations must embed UnimplementedStorageAuthorityServer
// for forward compatibility
type StorageAuthorityServer interface {
	// Getters
	GetRegistration(context.Context, *RegistrationID) (*proto.Registration, error)
	GetRegistrationByKey(context.Context, *JSONWebKey) (*proto.Registration, error)
	GetSerialMetadata(context.Context, *Serial) (*SerialMetadata, error)
	GetCertificate(context.Context, *Serial) (*proto.Certificate, error)
	GetPrecertificate(context.Context, *Serial) (*proto.Certificate, error)
	GetCertificateStatus(context.Context, *Serial) (*proto.CertificateStatus, error)
	CountCertificatesByNames(context.Context, *CountCertificatesByNamesRequest) (*CountByNames, error)
	CountRegistrationsByIP(context.Context, *CountRegistrationsByIPRequest) (*Count, error)
	CountRegistrationsByIPRange(context.Context, *CountRegistrationsByIPRequest) (*Count, error)
	CountOrders(context.Context, *CountOrdersRequest) (*Count, error)
	// Return a count of authorizations with status "invalid" that belong to
	// a given registration ID and expire in the given time range.
	CountFQDNSets(context.Context, *CountFQDNSetsRequest) (*Count, error)
	FQDNSetExists(context.Context, *FQDNSetExistsRequest) (*Exists, error)
	PreviousCertificateExists(context.Context, *PreviousCertificateExistsRequest) (*Exists, error)
	GetAuthorization2(context.Context, *AuthorizationID2) (*proto.Authorization, error)
	GetAuthorizations2(context.Context, *GetAuthorizationsRequest) (*Authorizations, error)
	GetPendingAuthorization2(context.Context, *GetPendingAuthorizationRequest) (*proto.Authorization, error)
	CountPendingAuthorizations2(context.Context, *RegistrationID) (*Count, error)
	GetValidOrderAuthorizations2(context.Context, *GetValidOrderAuthorizationsRequest) (*Authorizations, error)
	CountInvalidAuthorizations2(context.Context, *CountInvalidAuthorizationsRequest) (*Count, error)
	GetValidAuthorizations2(context.Context, *GetValidAuthorizationsRequest) (*Authorizations, error)
	KeyBlocked(context.Context, *KeyBlockedRequest) (*Exists, error)
	// Adders
	NewRegistration(context.Context, *proto.Registration) (*proto.Registration, error)
	UpdateRegistration(context.Context, *proto.Registration) (*emptypb.Empty, error)
	AddCertificate(context.Context, *AddCertificateRequest) (*AddCertificateResponse, error)
	AddPrecertificate(context.Context, *AddCertificateRequest) (*emptypb.Empty, error)
	AddSerial(context.Context, *AddSerialRequest) (*emptypb.Empty, error)
	DeactivateRegistration(context.Context, *RegistrationID) (*emptypb.Empty, error)
	NewOrder(context.Context, *NewOrderRequest) (*proto.Order, error)
	NewOrderAndAuthzs(context.Context, *NewOrderAndAuthzsRequest) (*proto.Order, error)
	SetOrderProcessing(context.Context, *OrderRequest) (*emptypb.Empty, error)
	SetOrderError(context.Context, *SetOrderErrorRequest) (*emptypb.Empty, error)
	FinalizeOrder(context.Context, *FinalizeOrderRequest) (*emptypb.Empty, error)
	GetOrder(context.Context, *OrderRequest) (*proto.Order, error)
	GetOrderForNames(context.Context, *GetOrderForNamesRequest) (*proto.Order, error)
	RevokeCertificate(context.Context, *RevokeCertificateRequest) (*emptypb.Empty, error)
	UpdateRevokedCertificate(context.Context, *RevokeCertificateRequest) (*emptypb.Empty, error)
	NewAuthorizations2(context.Context, *AddPendingAuthorizationsRequest) (*Authorization2IDs, error)
	FinalizeAuthorization2(context.Context, *FinalizeAuthorizationRequest) (*emptypb.Empty, error)
	DeactivateAuthorization2(context.Context, *AuthorizationID2) (*emptypb.Empty, error)
	AddBlockedKey(context.Context, *AddBlockedKeyRequest) (*emptypb.Empty, error)
	mustEmbedUnimplementedStorageAuthorityServer()
}

// UnimplementedStorageAuthorityServer must be embedded to have forward compatible implementations.
type UnimplementedStorageAuthorityServer struct {
}

func (UnimplementedStorageAuthorityServer) GetRegistration(context.Context, *RegistrationID) (*proto.Registration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRegistration not implemented")
}
func (UnimplementedStorageAuthorityServer) GetRegistrationByKey(context.Context, *JSONWebKey) (*proto.Registration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRegistrationByKey not implemented")
}
func (UnimplementedStorageAuthorityServer) GetSerialMetadata(context.Context, *Serial) (*SerialMetadata, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSerialMetadata not implemented")
}
func (UnimplementedStorageAuthorityServer) GetCertificate(context.Context, *Serial) (*proto.Certificate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCertificate not implemented")
}
func (UnimplementedStorageAuthorityServer) GetPrecertificate(context.Context, *Serial) (*proto.Certificate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPrecertificate not implemented")
}
func (UnimplementedStorageAuthorityServer) GetCertificateStatus(context.Context, *Serial) (*proto.CertificateStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCertificateStatus not implemented")
}
func (UnimplementedStorageAuthorityServer) CountCertificatesByNames(context.Context, *CountCertificatesByNamesRequest) (*CountByNames, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountCertificatesByNames not implemented")
}
func (UnimplementedStorageAuthorityServer) CountRegistrationsByIP(context.Context, *CountRegistrationsByIPRequest) (*Count, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountRegistrationsByIP not implemented")
}
func (UnimplementedStorageAuthorityServer) CountRegistrationsByIPRange(context.Context, *CountRegistrationsByIPRequest) (*Count, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountRegistrationsByIPRange not implemented")
}
func (UnimplementedStorageAuthorityServer) CountOrders(context.Context, *CountOrdersRequest) (*Count, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountOrders not implemented")
}
func (UnimplementedStorageAuthorityServer) CountFQDNSets(context.Context, *CountFQDNSetsRequest) (*Count, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountFQDNSets not implemented")
}
func (UnimplementedStorageAuthorityServer) FQDNSetExists(context.Context, *FQDNSetExistsRequest) (*Exists, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FQDNSetExists not implemented")
}
func (UnimplementedStorageAuthorityServer) PreviousCertificateExists(context.Context, *PreviousCertificateExistsRequest) (*Exists, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PreviousCertificateExists not implemented")
}
func (UnimplementedStorageAuthorityServer) GetAuthorization2(context.Context, *AuthorizationID2) (*proto.Authorization, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuthorization2 not implemented")
}
func (UnimplementedStorageAuthorityServer) GetAuthorizations2(context.Context, *GetAuthorizationsRequest) (*Authorizations, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuthorizations2 not implemented")
}
func (UnimplementedStorageAuthorityServer) GetPendingAuthorization2(context.Context, *GetPendingAuthorizationRequest) (*proto.Authorization, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPendingAuthorization2 not implemented")
}
func (UnimplementedStorageAuthorityServer) CountPendingAuthorizations2(context.Context, *RegistrationID) (*Count, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountPendingAuthorizations2 not implemented")
}
func (UnimplementedStorageAuthorityServer) GetValidOrderAuthorizations2(context.Context, *GetValidOrderAuthorizationsRequest) (*Authorizations, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetValidOrderAuthorizations2 not implemented")
}
func (UnimplementedStorageAuthorityServer) CountInvalidAuthorizations2(context.Context, *CountInvalidAuthorizationsRequest) (*Count, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountInvalidAuthorizations2 not implemented")
}
func (UnimplementedStorageAuthorityServer) GetValidAuthorizations2(context.Context, *GetValidAuthorizationsRequest) (*Authorizations, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetValidAuthorizations2 not implemented")
}
func (UnimplementedStorageAuthorityServer) KeyBlocked(context.Context, *KeyBlockedRequest) (*Exists, error) {
	return nil, status.Errorf(codes.Unimplemented, "method KeyBlocked not implemented")
}
func (UnimplementedStorageAuthorityServer) NewRegistration(context.Context, *proto.Registration) (*proto.Registration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NewRegistration not implemented")
}
func (UnimplementedStorageAuthorityServer) UpdateRegistration(context.Context, *proto.Registration) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRegistration not implemented")
}
func (UnimplementedStorageAuthorityServer) AddCertificate(context.Context, *AddCertificateRequest) (*AddCertificateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddCertificate not implemented")
}
func (UnimplementedStorageAuthorityServer) AddPrecertificate(context.Context, *AddCertificateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddPrecertificate not implemented")
}
func (UnimplementedStorageAuthorityServer) AddSerial(context.Context, *AddSerialRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddSerial not implemented")
}
func (UnimplementedStorageAuthorityServer) DeactivateRegistration(context.Context, *RegistrationID) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeactivateRegistration not implemented")
}
func (UnimplementedStorageAuthorityServer) NewOrder(context.Context, *NewOrderRequest) (*proto.Order, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NewOrder not implemented")
}
func (UnimplementedStorageAuthorityServer) NewOrderAndAuthzs(context.Context, *NewOrderAndAuthzsRequest) (*proto.Order, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NewOrderAndAuthzs not implemented")
}
func (UnimplementedStorageAuthorityServer) SetOrderProcessing(context.Context, *OrderRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetOrderProcessing not implemented")
}
func (UnimplementedStorageAuthorityServer) SetOrderError(context.Context, *SetOrderErrorRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetOrderError not implemented")
}
func (UnimplementedStorageAuthorityServer) FinalizeOrder(context.Context, *FinalizeOrderRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FinalizeOrder not implemented")
}
func (UnimplementedStorageAuthorityServer) GetOrder(context.Context, *OrderRequest) (*proto.Order, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOrder not implemented")
}
func (UnimplementedStorageAuthorityServer) GetOrderForNames(context.Context, *GetOrderForNamesRequest) (*proto.Order, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOrderForNames not implemented")
}
func (UnimplementedStorageAuthorityServer) RevokeCertificate(context.Context, *RevokeCertificateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevokeCertificate not implemented")
}
func (UnimplementedStorageAuthorityServer) UpdateRevokedCertificate(context.Context, *RevokeCertificateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRevokedCertificate not implemented")
}
func (UnimplementedStorageAuthorityServer) NewAuthorizations2(context.Context, *AddPendingAuthorizationsRequest) (*Authorization2IDs, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NewAuthorizations2 not implemented")
}
func (UnimplementedStorageAuthorityServer) FinalizeAuthorization2(context.Context, *FinalizeAuthorizationRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FinalizeAuthorization2 not implemented")
}
func (UnimplementedStorageAuthorityServer) DeactivateAuthorization2(context.Context, *AuthorizationID2) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeactivateAuthorization2 not implemented")
}
func (UnimplementedStorageAuthorityServer) AddBlockedKey(context.Context, *AddBlockedKeyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddBlockedKey not implemented")
}
func (UnimplementedStorageAuthorityServer) mustEmbedUnimplementedStorageAuthorityServer() {}

// UnsafeStorageAuthorityServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to StorageAuthorityServer will
// result in compilation errors.
type UnsafeStorageAuthorityServer interface {
	mustEmbedUnimplementedStorageAuthorityServer()
}

func RegisterStorageAuthorityServer(s grpc.ServiceRegistrar, srv StorageAuthorityServer) {
	s.RegisterService(&StorageAuthority_ServiceDesc, srv)
}

func _StorageAuthority_GetRegistration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegistrationID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).GetRegistration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/GetRegistration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).GetRegistration(ctx, req.(*RegistrationID))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_GetRegistrationByKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(JSONWebKey)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).GetRegistrationByKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/GetRegistrationByKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).GetRegistrationByKey(ctx, req.(*JSONWebKey))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_GetSerialMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Serial)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).GetSerialMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/GetSerialMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).GetSerialMetadata(ctx, req.(*Serial))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_GetCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Serial)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).GetCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/GetCertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).GetCertificate(ctx, req.(*Serial))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_GetPrecertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Serial)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).GetPrecertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/GetPrecertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).GetPrecertificate(ctx, req.(*Serial))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_GetCertificateStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Serial)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).GetCertificateStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/GetCertificateStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).GetCertificateStatus(ctx, req.(*Serial))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_CountCertificatesByNames_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CountCertificatesByNamesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).CountCertificatesByNames(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/CountCertificatesByNames",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).CountCertificatesByNames(ctx, req.(*CountCertificatesByNamesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_CountRegistrationsByIP_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CountRegistrationsByIPRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).CountRegistrationsByIP(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/CountRegistrationsByIP",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).CountRegistrationsByIP(ctx, req.(*CountRegistrationsByIPRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_CountRegistrationsByIPRange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CountRegistrationsByIPRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).CountRegistrationsByIPRange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/CountRegistrationsByIPRange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).CountRegistrationsByIPRange(ctx, req.(*CountRegistrationsByIPRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_CountOrders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CountOrdersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).CountOrders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/CountOrders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).CountOrders(ctx, req.(*CountOrdersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_CountFQDNSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CountFQDNSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).CountFQDNSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/CountFQDNSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).CountFQDNSets(ctx, req.(*CountFQDNSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_FQDNSetExists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FQDNSetExistsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).FQDNSetExists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/FQDNSetExists",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).FQDNSetExists(ctx, req.(*FQDNSetExistsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_PreviousCertificateExists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PreviousCertificateExistsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).PreviousCertificateExists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/PreviousCertificateExists",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).PreviousCertificateExists(ctx, req.(*PreviousCertificateExistsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_GetAuthorization2_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AuthorizationID2)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).GetAuthorization2(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/GetAuthorization2",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).GetAuthorization2(ctx, req.(*AuthorizationID2))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_GetAuthorizations2_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAuthorizationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).GetAuthorizations2(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/GetAuthorizations2",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).GetAuthorizations2(ctx, req.(*GetAuthorizationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_GetPendingAuthorization2_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPendingAuthorizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).GetPendingAuthorization2(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/GetPendingAuthorization2",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).GetPendingAuthorization2(ctx, req.(*GetPendingAuthorizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_CountPendingAuthorizations2_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegistrationID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).CountPendingAuthorizations2(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/CountPendingAuthorizations2",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).CountPendingAuthorizations2(ctx, req.(*RegistrationID))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_GetValidOrderAuthorizations2_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetValidOrderAuthorizationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).GetValidOrderAuthorizations2(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/GetValidOrderAuthorizations2",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).GetValidOrderAuthorizations2(ctx, req.(*GetValidOrderAuthorizationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_CountInvalidAuthorizations2_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CountInvalidAuthorizationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).CountInvalidAuthorizations2(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/CountInvalidAuthorizations2",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).CountInvalidAuthorizations2(ctx, req.(*CountInvalidAuthorizationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_GetValidAuthorizations2_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetValidAuthorizationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).GetValidAuthorizations2(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/GetValidAuthorizations2",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).GetValidAuthorizations2(ctx, req.(*GetValidAuthorizationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_KeyBlocked_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KeyBlockedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).KeyBlocked(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/KeyBlocked",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).KeyBlocked(ctx, req.(*KeyBlockedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_NewRegistration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(proto.Registration)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).NewRegistration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/NewRegistration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).NewRegistration(ctx, req.(*proto.Registration))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_UpdateRegistration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(proto.Registration)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).UpdateRegistration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/UpdateRegistration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).UpdateRegistration(ctx, req.(*proto.Registration))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_AddCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).AddCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/AddCertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).AddCertificate(ctx, req.(*AddCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_AddPrecertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).AddPrecertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/AddPrecertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).AddPrecertificate(ctx, req.(*AddCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_AddSerial_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddSerialRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).AddSerial(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/AddSerial",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).AddSerial(ctx, req.(*AddSerialRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_DeactivateRegistration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegistrationID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).DeactivateRegistration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/DeactivateRegistration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).DeactivateRegistration(ctx, req.(*RegistrationID))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_NewOrder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NewOrderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).NewOrder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/NewOrder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).NewOrder(ctx, req.(*NewOrderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_NewOrderAndAuthzs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NewOrderAndAuthzsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).NewOrderAndAuthzs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/NewOrderAndAuthzs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).NewOrderAndAuthzs(ctx, req.(*NewOrderAndAuthzsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_SetOrderProcessing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OrderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).SetOrderProcessing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/SetOrderProcessing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).SetOrderProcessing(ctx, req.(*OrderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_SetOrderError_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetOrderErrorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).SetOrderError(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/SetOrderError",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).SetOrderError(ctx, req.(*SetOrderErrorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_FinalizeOrder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizeOrderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).FinalizeOrder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/FinalizeOrder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).FinalizeOrder(ctx, req.(*FinalizeOrderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_GetOrder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OrderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).GetOrder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/GetOrder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).GetOrder(ctx, req.(*OrderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_GetOrderForNames_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrderForNamesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).GetOrderForNames(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/GetOrderForNames",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).GetOrderForNames(ctx, req.(*GetOrderForNamesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_RevokeCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevokeCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).RevokeCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/RevokeCertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).RevokeCertificate(ctx, req.(*RevokeCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_UpdateRevokedCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevokeCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).UpdateRevokedCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/UpdateRevokedCertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).UpdateRevokedCertificate(ctx, req.(*RevokeCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_NewAuthorizations2_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddPendingAuthorizationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).NewAuthorizations2(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/NewAuthorizations2",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).NewAuthorizations2(ctx, req.(*AddPendingAuthorizationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_FinalizeAuthorization2_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizeAuthorizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).FinalizeAuthorization2(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/FinalizeAuthorization2",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).FinalizeAuthorization2(ctx, req.(*FinalizeAuthorizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_DeactivateAuthorization2_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AuthorizationID2)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).DeactivateAuthorization2(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/DeactivateAuthorization2",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).DeactivateAuthorization2(ctx, req.(*AuthorizationID2))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageAuthority_AddBlockedKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddBlockedKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageAuthorityServer).AddBlockedKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/sa.StorageAuthority/AddBlockedKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageAuthorityServer).AddBlockedKey(ctx, req.(*AddBlockedKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// StorageAuthority_ServiceDesc is the grpc.ServiceDesc for StorageAuthority service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var StorageAuthority_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "sa.StorageAuthority",
	HandlerType: (*StorageAuthorityServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRegistration",
			Handler:    _StorageAuthority_GetRegistration_Handler,
		},
		{
			MethodName: "GetRegistrationByKey",
			Handler:    _StorageAuthority_GetRegistrationByKey_Handler,
		},
		{
			MethodName: "GetSerialMetadata",
			Handler:    _StorageAuthority_GetSerialMetadata_Handler,
		},
		{
			MethodName: "GetCertificate",
			Handler:    _StorageAuthority_GetCertificate_Handler,
		},
		{
			MethodName: "GetPrecertificate",
			Handler:    _StorageAuthority_GetPrecertificate_Handler,
		},
		{
			MethodName: "GetCertificateStatus",
			Handler:    _StorageAuthority_GetCertificateStatus_Handler,
		},
		{
			MethodName: "CountCertificatesByNames",
			Handler:    _StorageAuthority_CountCertificatesByNames_Handler,
		},
		{
			MethodName: "CountRegistrationsByIP",
			Handler:    _StorageAuthority_CountRegistrationsByIP_Handler,
		},
		{
			MethodName: "CountRegistrationsByIPRange",
			Handler:    _StorageAuthority_CountRegistrationsByIPRange_Handler,
		},
		{
			MethodName: "CountOrders",
			Handler:    _StorageAuthority_CountOrders_Handler,
		},
		{
			MethodName: "CountFQDNSets",
			Handler:    _StorageAuthority_CountFQDNSets_Handler,
		},
		{
			MethodName: "FQDNSetExists",
			Handler:    _StorageAuthority_FQDNSetExists_Handler,
		},
		{
			MethodName: "PreviousCertificateExists",
			Handler:    _StorageAuthority_PreviousCertificateExists_Handler,
		},
		{
			MethodName: "GetAuthorization2",
			Handler:    _StorageAuthority_GetAuthorization2_Handler,
		},
		{
			MethodName: "GetAuthorizations2",
			Handler:    _StorageAuthority_GetAuthorizations2_Handler,
		},
		{
			MethodName: "GetPendingAuthorization2",
			Handler:    _StorageAuthority_GetPendingAuthorization2_Handler,
		},
		{
			MethodName: "CountPendingAuthorizations2",
			Handler:    _StorageAuthority_CountPendingAuthorizations2_Handler,
		},
		{
			MethodName: "GetValidOrderAuthorizations2",
			Handler:    _StorageAuthority_GetValidOrderAuthorizations2_Handler,
		},
		{
			MethodName: "CountInvalidAuthorizations2",
			Handler:    _StorageAuthority_CountInvalidAuthorizations2_Handler,
		},
		{
			MethodName: "GetValidAuthorizations2",
			Handler:    _StorageAuthority_GetValidAuthorizations2_Handler,
		},
		{
			MethodName: "KeyBlocked",
			Handler:    _StorageAuthority_KeyBlocked_Handler,
		},
		{
			MethodName: "NewRegistration",
			Handler:    _StorageAuthority_NewRegistration_Handler,
		},
		{
			MethodName: "UpdateRegistration",
			Handler:    _StorageAuthority_UpdateRegistration_Handler,
		},
		{
			MethodName: "AddCertificate",
			Handler:    _StorageAuthority_AddCertificate_Handler,
		},
		{
			MethodName: "AddPrecertificate",
			Handler:    _StorageAuthority_AddPrecertificate_Handler,
		},
		{
			MethodName: "AddSerial",
			Handler:    _StorageAuthority_AddSerial_Handler,
		},
		{
			MethodName: "DeactivateRegistration",
			Handler:    _StorageAuthority_DeactivateRegistration_Handler,
		},
		{
			MethodName: "NewOrder",
			Handler:    _StorageAuthority_NewOrder_Handler,
		},
		{
			MethodName: "NewOrderAndAuthzs",
			Handler:    _StorageAuthority_NewOrderAndAuthzs_Handler,
		},
		{
			MethodName: "SetOrderProcessing",
			Handler:    _StorageAuthority_SetOrderProcessing_Handler,
		},
		{
			MethodName: "SetOrderError",
			Handler:    _StorageAuthority_SetOrderError_Handler,
		},
		{
			MethodName: "FinalizeOrder",
			Handler:    _StorageAuthority_FinalizeOrder_Handler,
		},
		{
			MethodName: "GetOrder",
			Handler:    _StorageAuthority_GetOrder_Handler,
		},
		{
			MethodName: "GetOrderForNames",
			Handler:    _StorageAuthority_GetOrderForNames_Handler,
		},
		{
			MethodName: "RevokeCertificate",
			Handler:    _StorageAuthority_RevokeCertificate_Handler,
		},
		{
			MethodName: "UpdateRevokedCertificate",
			Handler:    _StorageAuthority_UpdateRevokedCertificate_Handler,
		},
		{
			MethodName: "NewAuthorizations2",
			Handler:    _StorageAuthority_NewAuthorizations2_Handler,
		},
		{
			MethodName: "FinalizeAuthorization2",
			Handler:    _StorageAuthority_FinalizeAuthorization2_Handler,
		},
		{
			MethodName: "DeactivateAuthorization2",
			Handler:    _StorageAuthority_DeactivateAuthorization2_Handler,
		},
		{
			MethodName: "AddBlockedKey",
			Handler:    _StorageAuthority_AddBlockedKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "sa.proto",
}
