% podman-image(1)

## NAME
podman\-image - Manage images

## SYNOPSIS
**podman image** *subcommand*

## DESCRIPTION
The image command allows you to manage images

## COMMANDS

| Command  | Man Page                                        | Description                                                                 |
| -------- | ----------------------------------------------- | --------------------------------------------------------------------------- |
| build    | [podman-build(1)](podman-build.1.md)            | Build a container using a Dockerfile.                                       |
| exists   | [podman-image-exists(1)](podman-image-exists.1.md) | Check if an image exists in local storage.                               |
| history  | [podman-history(1)](podman-history.1.md)        | Show the history of an image.                                               |
| import   | [podman-import(1)](podman-import.1.md)          | Import a tarball and save it as a filesystem image.                         |
| inspect  | [podman-inspect(1)](podman-inspect.1.md)        | Display a image or image's configuration.                                   |
| list     | [podman-images(1)](podman-images.1.md)          | List the container images on the system.(alias ls)                          |
| load     | [podman-load(1)](podman-load.1.md)              | Load an image from the docker archive.                                      |
| prune    | [podman-image-prune(1)](podman-image-prune.1.md)| Remove all unused images from the local store.                              |
| pull     | [podman-pull(1)](podman-pull.1.md)              | Pull an image from a registry.                                              |
| push     | [podman-push(1)](podman-push.1.md)              | Push an image from local storage to elsewhere.                              |
| rm       | [podman-rmi(1)](podman-rmi.1.md)                | Removes one or more locally stored images.                                  |
| save     | [podman-save(1)](podman-save.1.md)              | Save an image to docker-archive or oci.                                     |
| sign     | [podman-image-sign(1)](podman-image-sign.1.md)  | Sign an image.                                                              |
| tag      | [podman-tag(1)](podman-tag.1.md)                | Add an additional name to a local image.                                    |
| tree     | [podman-image-tree(1)](podman-image-tree.1.md)  | Prints layer hierarchy of an image in a tree format.                        |
| trust    | [podman-image-trust(1)](podman-image-trust.1.md)| Manage container image trust policy.                                        |

## SEE ALSO
podman
