% crio(8) Open Container Initiative Daemon
% Dan Walsh
% SEPTEMBER 2016
# NAME
crio - OCI Kubernetes Container Runtime daemon

# SYNOPSIS
crio
```
[--apparmor-profile=[value]]
[--cgroup-manager=[value]]
[--cni-config-dir=[value]]
[--cni-plugin-dir=[value]]
[--config=[value]]
[--conmon=[value]]
[--cpu-profile=[value]]
[--default-transport=[value]]
[--help|-h]
[--insecure-registry=[value]]
[--listen=[value]]
[--log=[value]]
[--log-format value]
[--log-level value]
[--pause-command=[value]]
[--pause-image=[value]]
[--registry=[value]]
[--root=[value]]
[--runroot=[value]]
[--runtime=[value]]
[--seccomp-profile=[value]]
[--selinux]
[--signature-policy=[value]]
[--storage-driver=[value]]
[--storage-opt=[value]]
[--version|-v]
```
# DESCRIPTION
OCI-based implementation of Kubernetes Container Runtime Interface Daemon

crio is meant to provide an integration path between OCI conformant runtimes and the kubelet. Specifically, it implements the Kubelet Container Runtime Interface (CRI) using OCI conformant runtimes. The scope of crio is tied to the scope of the CRI.

1. Support multiple image formats including the existing Docker image format.
2. Support for multiple means to download images including trust & image verification.
3. Container image management (managing image layers, overlay filesystems, etc).
4. Container process lifecycle management.
5. Monitoring and logging required to satisfy the CRI.
6. Resource isolation as required by the CRI.

**Usage**:
```
crio [GLOBAL OPTIONS]
crio [GLOBAL OPTIONS] config [OPTIONS]
```
# GLOBAL OPTIONS
**--apparmor_profile**="": Name of the apparmor profile to be used as the runtime's default (default: "crio-default")

**--cgroup-manager**="": cgroup manager (cgroupfs or systemd)

**--config**="": path to configuration file

**--conmon**="": path to the conmon executable (default: "/usr/local/libexec/crio/conmon")

**--cpu-profile**="": set the CPU profile file path

**--default-transport**: A prefix to prepend to image names that can't be pulled as-is.

**--help, -h**: Print usage statement

**--insecure-registry=**: Enable insecure registry communication, i.e., enable un-encrypted and/or untrusted communication.

1. List of insecure registries can contain an element with CIDR notation to specify a whole subnet.
2. Insecure registries accept HTTP or accept HTTPS with certificates from unknown CAs.
3. Enabling `--insecure-registry`  is useful when running a local registry. However, because its use creates security vulnerabilities, **it should ONLY be enabled for testing purposes**. For increased security, users should add their CA to their system's list of trusted CAs instead of using `--insecure-registry`.

**--image-volumes**="": Image volume handling ('mkdir', 'bind' or 'ignore') (default: "mkdir")

1. mkdir: A directory is created inside the container root filesystem for the volumes.
2. bind: A directory is created inside container state directory and bind mounted into the container for the volumes.
3. ignore: All volumes are just ignored and no action is taken.

**--listen**="": Path to CRI-O socket (default: "/var/run/crio/crio.sock")

**--log**="": Set the log file path where internal debug information is written

**--log-format**="": Set the format used by logs ('text' (default), or 'json') (default: "text")

**--log-level**="": log crio messages above specified level: debug, info (default), warn, error, fatal or panic

**--log-size-max**="": Maximum log size in bytes for a container (default: -1 (no limit)). If it is positive, it must be >= 8192 (to match/exceed conmon read buffer).

**--pause-command**="": Path to the pause executable in the pause image (default: "/pause")

**--pause-image**="": Image which contains the pause executable (default: "kubernetes/pause")

**--pids-limit**="": Maximum number of processes allowed in a container (default: 1024)

**--root**="": The crio root dir (default: "/var/lib/containers/storage")

**--registry**="": Registry host which will be prepended to unqualified images, can be specified multiple times

**--runroot**="": The crio state dir (default: "/var/run/containers/storage")

**--runtime**="": OCI runtime path (default: "/usr/bin/runc")

**--selinux**=**true**|**false**: Enable selinux support (default: false)

**--seccomp-profile**="": Path to the seccomp json profile to be used as the runtime's default (default: "/etc/crio/seccomp.json")

**--signature-policy**="": Path to the signature policy json file (default: "", to use the system-wide default)

**--storage-driver**: OCI storage driver (default: "devicemapper")

**--storage-opt**: OCI storage driver option (no default)

**--cni-config-dir**="": CNI configuration files directory (default: "/etc/cni/net.d/")

**--cni-plugin-dir**="": CNI plugin binaries directory (default: "/opt/cni/bin/")

**--cpu-profile**: Set the CPU profile file path

**--version, -v**: Print the version

# COMMANDS
CRI-O's default command is to start the daemon. However, it currently offers a
single additional subcommand.

## config

Outputs a commented version of the configuration file that would've been used
by CRI-O. This allows you to save you current configuration setup and then load
it later with **--config**. Global options will modify the output.

**--default**
  Output the default configuration (without taking into account any configuration options).

# SEE ALSO
crio.conf(5)

# HISTORY
Sept 2016, Originally compiled by Dan Walsh <dwalsh@redhat.com> and Aleksa Sarai <asarai@suse.de>
