package org.codehaus.plexus.component.repository;

/*
 * Copyright 2001-2006 Codehaus Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @author <a href="mailto:jason@maven.org">Jason van Zyl</a>
 * @author <a href="mailto:trygvis@inamo.no">Trygve Laugst&oslash;l</a>
 * @version $Id: ComponentDependency.java 4796 2006-11-23 21:24:11Z jvanzyl $
 */
public class ComponentDependency
{
    private static final String DEAULT_DEPENDENCY_TYPE = "jar";
    
    private String groupId;

    private String artifactId;

    private String type = DEAULT_DEPENDENCY_TYPE;

    private String version;
    
    public String getArtifactId()
    {
        return artifactId;
    }

    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    }

    public String getGroupId()
    {
        return groupId;
    }

    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    }

    public String getType()
    {
        return type;
    }

    public void setType(String type)
    {
        this.type = type;
    }

    public String getVersion()
    {
        return version;
    }

    public void setVersion(String version)
    {
        this.version = version;
    }

    public String toString()
    {
        StringBuffer sb = new StringBuffer();

        sb.append( "groupId = " ).append( groupId ).
            append( ", artifactId = " ).append( artifactId ).
            append( ", version = " ).append( version ).
            append( ", type = " ).append( type );

        return sb.toString();
    }
}
