// --- BEGIN COPYRIGHT BLOCK ---
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//
// (C) 2013 Red Hat, Inc.
// All rights reserved.
// --- END COPYRIGHT BLOCK ---
package com.netscape.cms.profile.constraint;

import java.util.Locale;

import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.profile.def.UserSubjectNameDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;

/**
 * This class implements the user subject name constraint.
 * It copies user encoded subject name into the certificate template.
 *
 * @version $Revision$, $Date$
 */
public class UserSubjectNameConstraint extends EnrollConstraint {

    public static org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(UserSubjectNameConstraint.class);

    public UserSubjectNameConstraint() {
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        return null;
    }

    public String getDefaultConfig(String name) {
        return null;
    }

    /**
     * Validates the request. The request is not modified
     * during the validation. User encoded subject name
     * is copied into the certificate template.
     */
    @Override
    public void validate(Request request, X509CertInfo info)
            throws ERejectException {
        logger.debug("UserSubjectNameConstraint: validate start");
        CertificateSubjectName requestSN = null;

        try {
            requestSN = request.getExtDataInCertSubjectName(
                                Request.REQUEST_SUBJECT_NAME);
            info.set(X509CertInfo.SUBJECT, requestSN);
            logger.debug("UserSubjectNameConstraint: validate user subject=" + requestSN);
        } catch (Exception e) {
            throw new ERejectException(
                    CMS.getUserMessage(getLocale(request),
                        "CMS_PROFILE_SUBJECT_NAME_NOT_FOUND"));
        }
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage(locale,
                   "CMS_PROFILE_CONSTRAINT_USER_SUBJECT_NAME_TEXT");
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        if (def instanceof UserSubjectNameDefault)
            return true;
        return false;
    }
}
