--TEST--
Test for bug #1875: Overflow with large amounts of elements for variadics
--SKIPIF--
<?php
require __DIR__ . '/../utils.inc';
?>
--INI--
xdebug.mode=trace
xdebug.start_with_request=0
xdebug.collect_return=0
xdebug.collect_assignments=0
xdebug.auto_profile=0
xdebug.trace_format=0
--FILE--
<?php
$tf = xdebug_start_trace(sys_get_temp_dir() . '/'. uniqid('xdt', TRUE));

$input = '<!DOCTYPE html><body><svg><altGlyph /><altGlyphDef /><altGlyphItem /><animateColor /><animateMotion /><animateTransform /><clipPath /><feBlend /><feColorMatrix /><feComponentTransfer /><feComposite /><feConvolveMatrix /><feDiffuseLighting /><feDisplacementMap /><feDistantLight /><feFlood /><feFuncA /><feFuncB /><feFuncG /><feFuncR /><feGaussianBlur /><feImage /><feMerge /><feMergeNode /><feMorphology /><feOffset /><fePointLight /><feSpecularLighting /><feSpotLight /><feTile /><feTurbulence /><foreignObject /><glyphRef /><linearGradient /><radialGradient /><textPath /></svg>';
$chars = preg_split('//u', $input, -1, PREG_SPLIT_NO_EMPTY);
$a = [];

array_push($a, ...$chars);

xdebug_stop_trace();
echo file_get_contents($tf);
unlink($tf);
?>
--EXPECTF--
TRACE START [%d-%d-%d %d:%d:%d.%d]
%w%f %w%d     -> preg_split($pattern = '//u', $subject = '<!DOCTYPE html><body><svg><altGlyph /><altGlyphDef /><altGlyphItem /><animateColor /><animateMotion /><animateTransform /><clipPath /><feBlend /><feColorMatrix /><feComponentTransfer /><feComposite /><feConvolveMatrix /><feDiffuseLighting /><feDisplacementMap /><feDistantLight /><feFlood /><feFuncA /><feFuncB /><feFuncG /><feFuncR /><feGaussianBlur /><feImage /><feMerge /><feMergeNode /><feMorphology /><feOffset /><fePointLight /><feSpecularLighting /><feSpotLight /><feTile /><feTurbulence /><foreignObject ', $limit = -1, $flags = 1) %sbug01875-001.php:5
%w%f %w%d     -> array_push($%s = [], ...$%s = variadic(0 => '<', 1 => '!', 2 => 'D', 3 => 'O', 4 => 'C', 5 => 'T', 6 => 'Y', 7 => 'P', 8 => 'E', 9 => ' ', 10 => 'h', 11 => 't', 12 => 'm', 13 => 'l', 14 => '>', 15 => '<', 16 => 'b', 17 => 'o', 18 => 'd', 19 => 'y', 20 => '>', 21 => '<', 22 => 's', 23 => 'v', 24 => 'g', 25 => '>', 26 => '<', 27 => 'a', 28 => 'l', 29 => 't', 30 => 'G', 31 => 'l', 32 => 'y', 33 => 'p', 34 => 'h', 35 => ' ', 36 => '/', 37 => '>', 38 => '<', 39 => 'a', 40 => 'l', 41 => 't', 42 => 'G', 43 => 'l', 44 => 'y', 45 => 'p', 46 => 'h', 47 => 'D', 48 => 'e', 49 => 'f', 50 => ' ', 51 => '/', 52 => '>', 53 => '<', 54 => 'a', 55 => 'l', 56 => 't', 57 => 'G', 58 => 'l', 59 => 'y', 60 => 'p', 61 => 'h', 62 => 'I', 63 => 't', 64 => 'e', 65 => 'm', 66 => ' ', 67 => '/', 68 => '>', 69 => '<', 70 => 'a', 71 => 'n', 72 => 'i', 73 => 'm', 74 => 'a', 75 => 't', 76 => 'e', 77 => 'C', 78 => 'o', 79 => 'l', 80 => 'o', 81 => 'r', 82 => ' ', 83 => '/', 84 => '>', 85 => '<', 86 => 'a', 87 => 'n', 88 => 'i', 89 => 'm', 90 => 'a', 91 => 't', 92 => 'e', 93 => 'M', 94 => 'o', 95 => 't', 96 => 'i', 97 => 'o', 98 => 'n', 99 => ' ', 100 => '/', 101 => '>', 102 => '<', 103 => 'a', 104 => 'n', 105 => 'i', 106 => 'm', 107 => 'a', 108 => 't', 109 => 'e', 110 => 'T', 111 => 'r', 112 => 'a', 113 => 'n', 114 => 's', 115 => 'f', 116 => 'o', 117 => 'r', 118 => 'm', 119 => ' ', 120 => '/', 121 => '>', 122 => '<', 123 => 'c', 124 => 'l', 125 => 'i', 126 => 'p', 127 => 'P', 128 => 'a', 129 => 't', 130 => 'h', 131 => ' ', 132 => '/', 133 => '>', 134 => '<', 135 => 'f', 136 => 'e', 137 => 'B', 138 => 'l', 139 => 'e', 140 => 'n', 141 => 'd', 142 => ' ', 143 => '/', 144 => '>', 145 => '<', 146 => 'f', 147 => 'e', 148 => 'C', 149 => 'o', 150 => 'l', 151 => 'o', 152 => 'r', 153 => 'M', 154 => 'a', 155 => 't', 156 => 'r', 157 => 'i', 158 => 'x', 159 => ' ', 160 => '/', 161 => '>', 162 => '<', 163 => 'f', 164 => 'e', 165 => 'C', 166 => 'o', 167 => 'm', 168 => 'p', 169 => 'o', 170 => 'n', 171 => 'e', 172 => 'n', 173 => 't', 174 => 'T', 175 => 'r', 176 => 'a', 177 => 'n', 178 => 's', 179 => 'f', 180 => 'e', 181 => 'r', 182 => ' ', 183 => '/', 184 => '>', 185 => '<', 186 => 'f', 187 => 'e', 188 => 'C', 189 => 'o', 190 => 'm', 191 => 'p', 192 => 'o', 193 => 's', 194 => 'i', 195 => 't', 196 => 'e', 197 => ' ', 198 => '/', 199 => '>', 200 => '<', 201 => 'f', 202 => 'e', 203 => 'C', 204 => 'o', 205 => 'n', 206 => 'v', 207 => 'o', 208 => 'l', 209 => 'v', 210 => 'e', 211 => 'M', 212 => 'a', 213 => 't', 214 => 'r', 215 => 'i', 216 => 'x', 217 => ' ', 218 => '/', 219 => '>', 220 => '<', 221 => 'f', 222 => 'e', 223 => 'D', 224 => 'i', 225 => 'f', 226 => 'f', 227 => 'u', 228 => 's', 229 => 'e', 230 => 'L', 231 => 'i', 232 => 'g', 233 => 'h', 234 => 't', 235 => 'i', 236 => 'n', 237 => 'g', 238 => ' ', 239 => '/', 240 => '>', 241 => '<', 242 => 'f', 243 => 'e', 244 => 'D', 245 => 'i', 246 => 's', 247 => 'p', 248 => 'l', 249 => 'a', 250 => 'c', 251 => 'e', 252 => 'm', 253 => 'e', 254 => 'n', 255 => 't', 256 => 'M', 257 => 'a', 258 => 'p', 259 => ' ', 260 => '/', 261 => '>', 262 => '<', 263 => 'f', 264 => 'e', 265 => 'D', 266 => 'i', 267 => 's', 268 => 't', 269 => 'a', 270 => 'n', 271 => 't', 272 => 'L', 273 => 'i', 274 => 'g', 275 => 'h', 276 => 't', 277 => ' ', 278 => '/', 279 => '>', 280 => '<', 281 => 'f', 282 => 'e', 283 => 'F', 284 => 'l', 285 => 'o', 286 => 'o', 287 => 'd', 288 => ' ', 289 => '/', 290 => '>', 291 => '<', 292 => 'f', 293 => 'e', 294 => 'F', 295 => 'u', 296 => 'n', 297 => 'c', 298 => 'A', 299 => ' ', 300 => '/', 301 => '>', 302 => '<', 303 => 'f', 304 => 'e', 305 => 'F', 306 => 'u', 307 => 'n', 308 => 'c', 309 => 'B', 310 => ' ', 311 => '/', 312 => '>', 313 => '<', 314 => 'f', 315 => 'e', 316 => 'F', 317 => 'u', 318 => 'n', 319 => 'c', 320 => 'G', 321 => ' ', 322 => '/', 323 => '>', 324 => '<', 325 => 'f', 326 => 'e', 327 => 'F', 328 => 'u', 329 => 'n', 330 => 'c', 331 => 'R', 332 => ' ', 333 => '/', 334 => '>', 335 => '<', 336 => 'f', 337 => 'e', 338 => 'G', 339 => 'a', 340 => 'u', 341 => 's', 342 => 's', 343 => 'i', 344 => 'a', 345 => 'n', 346 => 'B', 347 => 'l', 348 => 'u', 349 => 'r', 350 => ' ', 351 => '/', 352 => '>', 353 => '<', 354 => 'f', 355 => 'e', 356 => 'I', 357 => 'm', 358 => 'a', 359 => 'g', 360 => 'e', 361 => ' ', 362 => '/', 363 => '>', 364 => '<', 365 => 'f', 366 => 'e', 367 => 'M', 368 => 'e', 369 => 'r', 370 => 'g', 371 => 'e', 372 => ' ', 373 => '/', 374 => '>', 375 => '<', 376 => 'f', 377 => 'e', 378 => 'M', 379 => 'e', 380 => 'r', 381 => 'g', 382 => 'e', 383 => 'N', 384 => 'o', 385 => 'd', 386 => 'e', 387 => ' ', 388 => '/', 389 => '>', 390 => '<', 391 => 'f', 392 => 'e', 393 => 'M', 394 => 'o', 395 => 'r', 396 => 'p', 397 => 'h', 398 => 'o', 399 => 'l', 400 => 'o', 401 => 'g', 402 => 'y', 403 => ' ', 404 => '/', 405 => '>', 406 => '<', 407 => 'f', 408 => 'e', 409 => 'O', 410 => 'f', 411 => 'f', 412 => 's', 413 => 'e', 414 => 't', 415 => ' ', 416 => '/', 417 => '>', 418 => '<', 419 => 'f', 420 => 'e', 421 => 'P', 422 => 'o', 423 => 'i', 424 => 'n', 425 => 't', 426 => 'L', 427 => 'i', 428 => 'g', 429 => 'h', 430 => 't', 431 => ' ', 432 => '/', 433 => '>', 434 => '<', 435 => 'f', 436 => 'e', 437 => 'S', 438 => 'p', 439 => 'e', 440 => 'c', 441 => 'u', 442 => 'l', 443 => 'a', 444 => 'r', 445 => 'L', 446 => 'i', 447 => 'g', 448 => 'h', 449 => 't', 450 => 'i', 451 => 'n', 452 => 'g', 453 => ' ', 454 => '/', 455 => '>', 456 => '<', 457 => 'f', 458 => 'e', 459 => 'S', 460 => 'p', 461 => 'o', 462 => 't', 463 => 'L', 464 => 'i', 465 => 'g', 466 => 'h', 467 => 't', 468 => ' ', 469 => '/', 470 => '>', 471 => '<', 472 => 'f', 473 => 'e', 474 => 'T', 475 => 'i', 476 => 'l', 477 => 'e', 478 => ' ', 479 => '/', 480 => '>', 481 => '<', 482 => 'f', 483 => 'e', 484 => 'T', 485 => 'u', 486 => 'r', 487 => 'b', 488 => 'u', 489 => 'l', 490 => 'e', 491 => 'n', 492 => 'c', 493 => 'e', 494 => ' ', 495 => '/', 496 => '>', 497 => '<', 498 => 'f', 499 => 'o', 500 => 'r', 501 => 'e', 502 => 'i', 503 => 'g', 504 => 'n', 505 => 'O', 506 => 'b', 507 => 'j', 508 => 'e', 509 => 'c', 510 => 't', 511 => ' ', 512 => '/', 513 => '>', 514 => '<', 515 => 'g', 516 => 'l', 517 => 'y', 518 => 'p', 519 => 'h', 520 => 'R', 521 => 'e', 522 => 'f', 523 => ' ', 524 => '/', 525 => '>', 526 => '<', 527 => 'l', 528 => 'i', 529 => 'n', 530 => 'e', 531 => 'a', 532 => 'r', 533 => 'G', 534 => 'r', 535 => 'a', 536 => 'd', 537 => 'i', 538 => 'e', 539 => 'n', 540 => 't', 541 => ' ', 542 => '/', 543 => '>', 544 => '<', 545 => 'r', 546 => 'a', 547 => 'd', 548 => 'i', 549 => 'a', 550 => 'l', 551 => 'G', 552 => 'r', 553 => 'a', 554 => 'd', 555 => 'i', 556 => 'e', 557 => 'n', 558 => 't', 559 => ' ', 560 => '/', 561 => '>', 562 => '<', 563 => 't', 564 => 'e', 565 => 'x', 566 => 't', 567 => 'P', 568 => 'a', 569 => 't', 570 => 'h', 571 => ' ', 572 => '/', 573 => '>', 574 => '<', 575 => '/', 576 => 's', 577 => 'v', 578 => 'g', 579 => '>')) %sbug01875-001.php:8
%w%f %w%d     -> xdebug_stop_trace() %sbug01875-001.php:10
%w%f %w%d
TRACE END   [%d-%d-%d %d:%d:%d.%d]
