/******************************************************************************
*
*   Copyright (c) 2022 Intel.
*
*   Licensed under the Apache License, Version 2.0 (the "License");
*   you may not use this file except in compliance with the License.
*   You may obtain a copy of the License at
*
*       http://www.apache.org/licenses/LICENSE-2.0
*
*   Unless required by applicable law or agreed to in writing, software
*   distributed under the License is distributed on an "AS IS" BASIS,
*   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*   See the License for the specific language governing permissions and
*   limitations under the License.
*
*******************************************************************************/

#ifndef __BB_ACC_REG_DUMP_H__
#define __BB_ACC_REG_DUMP_H__

#include "bb_acc.h"

/* reg_dump declaration */
struct acc100_reg_dump_info {
	char *reg_name;
	uint32_t reg_offset;
};

struct acc200_reg_dump_info {
	char *reg_name;
	uint32_t reg_offset;
};

/* reg_dump database. Global rd_db */

/* ACC100 register */
struct acc100_reg_dump_info acc100_rd_db[] = {
	{"qmgr_egress_queues_template                             ", 0x0007FE00},
	{"qmgr_ingress_aq                                         ", 0x00080000},
	{"qmgr_arb_q_avail                                        ", 0x00A00010},
	{"qmgr_arb_q_block                                        ", 0x00A00014},
	{"qmgr_aqueue_drop_notif_en                               ", 0x00A00024},
	{"qmgr_aqueue_disable_notif_en                            ", 0x00A00028},
	{"qmgr_soft_reset                                         ", 0x00A00038},
	{"qmgr_init_status                                        ", 0x00A0003C},
	{"qmgr_aram_watchdog_count                                ", 0x00A00040},
	{"qmgr_aram_watchdog_counter_en                           ", 0x00A00044},
	{"qmgr_axi_watchdog_count                                 ", 0x00A00048},
	{"qmgr_axi_watchdog_counter_en                            ", 0x00A0004C},
	{"qmgr_process_watchdog_count                             ", 0x00A00050},
	{"qmgr_process_watchdog_counter_en                        ", 0x00A00054},
	{"qmgr_process_ul4g_watchdog_counter                      ", 0x00A00058},
	{"qmgr_process_dl4g_watchdog_counter                      ", 0x00A0005C},
	{"qmgr_process_ul5g_watchdog_counter                      ", 0x00A00060},
	{"qmgr_process_dl5g_watchdog_counter                      ", 0x00A00064},
	{"qmgr_process_mld_watchdog_counter                       ", 0x00A00068},
	{"qmgr_msi_overflow_upper_vf                              ", 0x00A00070},
	{"qmgr_msi_overflow_lower_vf                              ", 0x00A00074},
	{"qmgr_msi_watchdog_overflow                              ", 0x00A00078},
	{"qmgr_msi_overflow_enable                                ", 0x00A0007C},
	{"qmgr_debug_aq_pointer_mem_grp                           ", 0x00A00100},
	{"qmgr_debug_output_arb_q_fifo_grp                        ", 0x00A00140},
	{"qmgr_debug_msi_fifo_grp                                 ", 0x00A00180},
	{"qmgr_debug_axi_wd_timeout_msi_fifo                      ", 0x00A001C0},
	{"qmgr_debug_process_wd_timeout_msi_fifo                  ", 0x00A001C4},
	{"qmgr_depth_log2_grp                                     ", 0x00A00200},
	{"qmgr_thold_grp                                          ", 0x00A00300},
	{"qmgr_grp_tmplate_reg0_indx                              ", 0x00A00600},
	{"qmgr_grp_tmplate_reg1_indx                              ", 0x00A00680},
	{"qmgr_grp_tmplate_reg2_indx                              ", 0x00A00700},
	{"qmgr_grp_tmplate_reg3_indx                              ", 0x00A00780},
	{"qmgr_grp_tmplate_reg4_indx                              ", 0x00A00800},
	{"qmgr_vf_base_addr                                       ", 0x00A01000},
	{"qmgr_ul4g_weight_rr_vf                                  ", 0x00A02000},
	{"qmgr_dl4g_weight_rr_vf                                  ", 0x00A02100},
	{"qmgr_ul5g_weight_rr_vf                                  ", 0x00A02200},
	{"qmgr_dl5g_weight_rr_vf                                  ", 0x00A02300},
	{"qmgr_mld_weight_rr_vf                                   ", 0x00A02400},
	{"qmgr_arb_q_depth_grp                                    ", 0x00A02F00},
	{"qmgr_grp_function0                                      ", 0x00A02F40},
	{"qmgr_grp_function1                                      ", 0x00A02F44},
	{"qmgr_grp_priority                                       ", 0x00A02F48},
	{"qmgr_weight_sync                                        ", 0x00A03000},
	{"qmgr_aq_enable_vf                                       ", 0x00A10000},
	{"qmgr_aq_reset_vf                                        ", 0x00A20000},
	{"qmgr_ring_size_vf                                       ", 0x00A20004},
	{"qmgr_grp_depth_log20_vf                                 ", 0x00A20008},
	{"qmgr_grp_depth_log21_vf                                 ", 0x00A2000C},
	{"qmgr_grp_function0_vf                                   ", 0x00A20010},
	{"qmgr_grp_function1_vf                                   ", 0x00A20014},
	{"dma_config0_reg                                         ", 0x00B80000},
	{"dma_config1_reg                                         ", 0x00B80004},
	{"dma_qmgr_addr_reg                                       ", 0x00B80008},
	{"dma_soft_reset_reg                                      ", 0x00B8000C},
	{"dma_axcache_reg                                         ", 0x00B80010},
	{"dma_version_reg                                         ", 0x00B80014},
	{"dma_frame_threshold                                     ", 0x00B80018},
	{"dma_timestamp_lo                                        ", 0x00B8001C},
	{"dma_timestamp_hi                                        ", 0x00B80020},
	{"dma_axi_status                                          ", 0x00B80028},
	{"dma_axi_control                                         ", 0x00B8002C},
	{"dma_no_qmgr                                             ", 0x00B80030},
	{"dma_qos_scale                                           ", 0x00B80034},
	{"dma_qmanen                                              ", 0x00B80040},
	{"dma_qmgr_qos_base                                       ", 0x00B80060},
	{"dma_fec_clk_gating_enable                               ", 0x00B80080},
	{"dma_pm_enable                                           ", 0x00B80084},
	{"dma_qos_enable                                          ", 0x00B80088},
	{"dma_harq_weighted_rr_frame_threshold                    ", 0x00B800B0},
	{"dma_data_small_weighted_rr_frame_thresh                 ", 0x00B800B4},
	{"dma_data_large_weighted_rr_frame_thresh                 ", 0x00B800B8},
	{"dma_inbound_cb_max_size                                 ", 0x00B800BC},
	{"dma_inbound_drain_data_size                             ", 0x00B800C0},
	{"dma_vf_ddr_base_rw                                      ", 0x00B80400},
	{"dma_cmpl_tm_out_cnt                                     ", 0x00B80800},
	{"dma_proc_tm_out_cnt                                     ", 0x00B80804},
	{"dma_status_rresp_bresp                                  ", 0x00B80810},
	{"dma_cfg_rresp_bresp                                     ", 0x00B80814},
	{"dma_status_mem_par_err                                  ", 0x00B80818},
	{"dma_cfg_mem_par_err_en                                  ", 0x00B8081C},
	{"dma_status_dma_hw_err                                   ", 0x00B80820},
	{"dma_cfg_dma_hw_err_en                                   ", 0x00B80824},
	{"dma_status_fec_core_err                                 ", 0x00B80828},
	{"dma_cfg_fec_core_err_en                                 ", 0x00B8082C},
	{"dma_status_fcw_descr_err                                ", 0x00B80830},
	{"dma_cfg_fcw_descr_err_en                                ", 0x00B80834},
	{"dma_status_block_transmit                               ", 0x00B80838},
	{"dma_block_on_err_en                                     ", 0x00B8083C},
	{"dma_status_flush_dma                                    ", 0x00B80840},
	{"dma_flush_dma_on_err_en                                 ", 0x00B80844},
	{"dma_status_sdone_fifo_full                              ", 0x00B80848},
	{"dma_status_descriptor_err_lo_vf                         ", 0x00B8084C},
	{"dma_status_descriptor_err_hi_vf                         ", 0x00B80850},
	{"dma_status_fcw_err_lo_vf                                ", 0x00B80854},
	{"dma_status_fcw_err_hi_vf                                ", 0x00B80858},
	{"dma_status_data_err_lo_vf                               ", 0x00B8085C},
	{"dma_status_data_err_hi_vf                               ", 0x00B80860},
	{"dma_cfg_msi_en_software_err                             ", 0x00B80864},
	{"dma_descriptor_signatuture                              ", 0x00B80868},
	{"dma_fcw_signature                                       ", 0x00B8086C},
	{"dma_error_detection_en                                  ", 0x00B80870},
	{"dma_err_cntrl_fifo_debug                                ", 0x00B8087C},
	{"dma_status_tout_data                                    ", 0x00B80880},
	{"dma_status_tout_desc                                    ", 0x00B80884},
	{"dma_status_tout_unexp_data                              ", 0x00B80888},
	{"dma_status_tout_unexp_desc                              ", 0x00B8088C},
	{"dma_status_tout_process                                 ", 0x00B80890},
	{"dma_config_ctout_out_data_en                            ", 0x00B808A0},
	{"dma_config_ctout_out_descr_en                           ", 0x00B808A4},
	{"dma_config_unexp_compl_data_en                          ", 0x00B808A8},
	{"dma_config_unexp_compl_descr_en                         ", 0x00B808AC},
	{"dma_config_ptout_out_en                                 ", 0x00B808B0},
	{"dma_fec5gul_desc_base_lo_reg_vf                         ", 0x00B88020},
	{"dma_fec5gul_desc_base_hi_reg_vf                         ", 0x00B88024},
	{"dma_fec5gul_resp_ptr_lo_reg_vf                          ", 0x00B88028},
	{"dma_fec5gul_resp_ptr_hi_reg_vf                          ", 0x00B8802C},
	{"dma_fec5gdl_desc_base_lo_reg_vf                         ", 0x00B88040},
	{"dma_fec5gdl_desc_base_hi_reg_vf                         ", 0x00B88044},
	{"dma_fec5gdl_resp_ptr_lo_reg_vf                          ", 0x00B88048},
	{"dma_fec5gdl_resp_ptr_hi_reg_vf                          ", 0x00B8804C},
	{"dma_fec4gul_desc_base_lo_reg_vf                         ", 0x00B88060},
	{"dma_fec4gul_desc_base_hi_reg_vf                         ", 0x00B88064},
	{"dma_fec4gul_resp_ptr_lo_reg_vf                          ", 0x00B88068},
	{"dma_fec4gul_resp_ptr_hi_reg_vf                          ", 0x00B8806C},
	{"dma_fec4gdl_desc_base_lo_reg_vf                         ", 0x00B88080},
	{"dma_fec4gdl_desc_base_hi_reg_vf                         ", 0x00B88084},
	{"dma_fec4gdl_resp_ptr_lo_reg_vf                          ", 0x00B88088},
	{"dma_fec4gdl_resp_ptr_hi_reg_vf                          ", 0x00B8808C},
	{"dma_vf_ddr_base_range_ro                                ", 0x00B880A0},
	{"qosmon_a_cntrl_reg                                      ", 0x00B90000},
	{"qosmon_a_eval_overflow0                                 ", 0x00B90008},
	{"qosmon_a_eval_overflow1                                 ", 0x00B9000C},
	{"qosmon_a_div_term                                       ", 0x00B90010},
	{"qosmon_a_tick_term                                      ", 0x00B90014},
	{"qosmon_a_eval_term                                      ", 0x00B90018},
	{"qosmon_a_ave_term                                       ", 0x00B9001C},
	{"qosmon_a_force_ecc_err                                  ", 0x00B90020},
	{"qosmon_a_ecc_err_detect                                 ", 0x00B90024},
	{"qosmon_a_iteration_config0_low                          ", 0x00B90060},
	{"qosmon_a_iteration_config0_high                         ", 0x00B90064},
	{"qosmon_a_iteration_config1_low                          ", 0x00B90068},
	{"qosmon_a_iteration_config1_high                         ", 0x00B9006C},
	{"qosmon_a_iteration_config2_low                          ", 0x00B90070},
	{"qosmon_a_iteration_config2_high                         ", 0x00B90074},
	{"qosmon_a_iteration_config3_low                          ", 0x00B90078},
	{"qosmon_a_iteration_config3_high                         ", 0x00B9007C},
	{"qosmon_a_eval_mem_addr                                  ", 0x00B90080},
	{"qosmon_a_eval_mem_data                                  ", 0x00B90084},
	{"qosmon_a_rem_thres1_vf                                  ", 0x00B90400},
	{"qosmon_a_thres2_vf                                      ", 0x00B90404},
	{"qosmon_a_wei_frac_vf                                    ", 0x00B90408},
	{"qosmon_a_rr_wei_vf                                      ", 0x00B9040C},
	{"permon_a_cntrl_reg_vf                                   ", 0x00B98000},
	{"permon_a_count_vf                                       ", 0x00B98008},
	{"permon_a_k_cnt_lo_vf                                    ", 0x00B98010},
	{"permon_a_k_cnt_hi_vf                                    ", 0x00B98014},
	{"permon_a_delta_cnt_lo_vf                                ", 0x00B98020},
	{"permon_a_delta_cnt_hi_vf                                ", 0x00B98024},
	{"permon_a_version_reg                                    ", 0x00B9C000},
	{"permon_a_cb_control_fec                                 ", 0x00B9C0F0},
	{"permon_a_dlt_timer_lo_fec                               ", 0x00B9C0F4},
	{"permon_a_dlt_timer_hi_fec                               ", 0x00B9C0F8},
	{"permon_a_cb_count_fec                                   ", 0x00B9C100},
	{"permon_a_acc_exec_timer_lo_fec                          ", 0x00B9C104},
	{"permon_a_acc_exec_timer_hi_fec                          ", 0x00B9C108},
	{"permon_a_exec_timer_min_fec                             ", 0x00B9C200},
	{"permon_a_exec_timer_max_fec                             ", 0x00B9C204},
	{"permon_a_control_bus_mon                                ", 0x00B9C400},
	{"permon_a_config_bus_mon                                 ", 0x00B9C404},
	{"permon_a_skip_count_bus_mon                             ", 0x00B9C408},
	{"permon_a_min_lat_bus_mon                                ", 0x00B9C40C},
	{"permon_a_max_lat_bus_mon                                ", 0x00B9C500},
	{"permon_a_total_lat_low_bus_mon                          ", 0x00B9C504},
	{"permon_a_total_lat_upper_bus_mon                        ", 0x00B9C508},
	{"permon_a_total_req_cnt_bus_mon                          ", 0x00B9C50C},
	{"qosmon_b_cntrl_reg                                      ", 0x00BA0000},
	{"qosmon_b_eval_overflow0                                 ", 0x00BA0008},
	{"qosmon_b_eval_overflow1                                 ", 0x00BA000C},
	{"qosmon_b_div_term                                       ", 0x00BA0010},
	{"qosmon_b_tick_term                                      ", 0x00BA0014},
	{"qosmon_b_eval_term                                      ", 0x00BA0018},
	{"qosmon_b_ave_term                                       ", 0x00BA001C},
	{"qosmon_b_force_ecc_err                                  ", 0x00BA0020},
	{"qosmon_b_ecc_err_detect                                 ", 0x00BA0024},
	{"qosmon_b_iteration_config0_low                          ", 0x00BA0060},
	{"qosmon_b_iteration_config0_high                         ", 0x00BA0064},
	{"qosmon_b_iteration_config1_low                          ", 0x00BA0068},
	{"qosmon_b_iteration_config1_high                         ", 0x00BA006C},
	{"qosmon_b_iteration_config2_low                          ", 0x00BA0070},
	{"qosmon_b_iteration_config2_high                         ", 0x00BA0074},
	{"qosmon_b_iteration_config3_low                          ", 0x00BA0078},
	{"qosmon_b_iteration_config3_high                         ", 0x00BA007C},
	{"qosmon_b_eval_mem_addr                                  ", 0x00BA0080},
	{"qosmon_b_eval_mem_data                                  ", 0x00BA0084},
	{"qosmon_b_rem_thres1_vf                                  ", 0x00BA0400},
	{"qosmon_b_thres2_vf                                      ", 0x00BA0404},
	{"qosmon_b_wei_frac_vf                                    ", 0x00BA0408},
	{"qosmon_b_rr_wei_vf                                      ", 0x00BA040C},
	{"permon_b_cntrl_reg_vf                                   ", 0x00BA8000},
	{"permon_b_count_vf                                       ", 0x00BA8008},
	{"permon_b_k_cnt_lo_vf                                    ", 0x00BA8010},
	{"permon_b_k_cnt_hi_vf                                    ", 0x00BA8014},
	{"permon_b_delta_cnt_lo_vf                                ", 0x00BA8020},
	{"permon_b_delta_cnt_hi_vf                                ", 0x00BA8024},
	{"permon_b_version_reg                                    ", 0x00BAC000},
	{"permon_b_cb_control_fec                                 ", 0x00BAC0F0},
	{"permon_b_dlt_timer_lo_fec                               ", 0x00BAC0F4},
	{"permon_b_dlt_timer_hi_fec                               ", 0x00BAC0F8},
	{"permon_b_cb_count_fec                                   ", 0x00BAC100},
	{"permon_b_acc_exec_timer_lo_fec                          ", 0x00BAC104},
	{"permon_b_acc_exec_timer_hi_fec                          ", 0x00BAC108},
	{"permon_b_exec_timer_min_fec                             ", 0x00BAC200},
	{"permon_b_exec_timer_max_fec                             ", 0x00BAC204},
	{"permon_b_control_bus_mon                                ", 0x00BAC400},
	{"permon_b_config_bus_mon                                 ", 0x00BAC404},
	{"permon_b_skip_count_bus_mon                             ", 0x00BAC408},
	{"permon_b_min_lat_bus_mon                                ", 0x00BAC40C},
	{"permon_b_max_lat_bus_mon                                ", 0x00BAC500},
	{"permon_b_total_lat_low_bus_mon                          ", 0x00BAC504},
	{"permon_b_total_lat_upper_bus_mon                        ", 0x00BAC508},
	{"permon_b_total_req_cnt_bus_mon                          ", 0x00BAC50C},
	{"fab_i2m_arb_cntrl_reg                                   ", 0x00BB0000},
	{"fab_m2i_arb_cntrl_reg                                   ", 0x00BB1000},
	{"fab_i2m_grp0_debug_reg                                  ", 0x00BBF000},
	{"fab_i2m_grp1_debug_reg                                  ", 0x00BBF004},
	{"fab_i2m_grp2_debug_reg                                  ", 0x00BBF008},
	{"fab_i2m_grp3_debug_reg                                  ", 0x00BBF00C},
	{"fab_i2m_buf0_debug_reg                                  ", 0x00BBF010},
	{"fab_i2m_buf1_debug_reg                                  ", 0x00BBF014},
	{"fab_i2m_buf2_debug_reg                                  ", 0x00BBF018},
	{"fab_i2m_buf3_debug_reg                                  ", 0x00BBF01C},
	{"fab_m2i_buf0_grp0_debug_reg                             ", 0x00BBF020},
	{"fab_m2i_buf1_grp0_debug_reg                             ", 0x00BBF024},
	{"fab_m2i_buf0_grp1_debug_reg                             ", 0x00BBF028},
	{"fab_m2i_buf1_grp1_debug_reg                             ", 0x00BBF02C},
	{"fab_m2i_buf0_grp2_debug_reg                             ", 0x00BBF030},
	{"fab_m2i_buf1_grp2_debug_reg                             ", 0x00BBF034},
	{"fab_m2i_buf0_grp3_debug_reg                             ", 0x00BBF038},
	{"fab_m2i_buf1_grp3_debug_reg                             ", 0x00BBF03C},
	{"fec_ul5g_cntrl_reg                                      ", 0x00BC0000},
	{"fec_ul5g_i2m_thresh_reg                                 ", 0x00BC0004},
	{"fec_ul5g_version_reg                                    ", 0x00BC0100},
	{"fec_ul5g_fcw_status_reg                                 ", 0x00BC0104},
	{"fec_ul5g_warn_reg                                       ", 0x00BC0108},
	{"fec_ul5g_ib_debug_reg                                   ", 0x00BC0200},
	{"fec_ul5g_ob_llr_debug_reg                               ", 0x00BC0204},
	{"fec_ul5g_ob_harq_debug_reg                              ", 0x00BC0208},
	{"fec_ul5g_1_cntrl_reg                                    ", 0x00BC1000},
	{"fec_ul5g_1_i2m_thresh_reg                               ", 0x00BC1004},
	{"fec_ul5g_1_version_reg                                  ", 0x00BC1100},
	{"fec_ul5g_1_fcw_status_reg                               ", 0x00BC1104},
	{"fec_ul5g_1_warn_reg                                     ", 0x00BC1108},
	{"fec_ul5g_1_ib_debug_reg                                 ", 0x00BC1200},
	{"fec_ul5g_1_ob_llr_debug_reg                             ", 0x00BC1204},
	{"fec_ul5g_1_ob_harq_debug_reg                            ", 0x00BC1208},
	{"fec_ul5g_2_cntrl_reg                                    ", 0x00BC2000},
	{"fec_ul5g_2_i2m_thresh_reg                               ", 0x00BC2004},
	{"fec_ul5g_2_version_reg                                  ", 0x00BC2100},
	{"fec_ul5g_2_fcw_status_reg                               ", 0x00BC2104},
	{"fec_ul5g_2_warn_reg                                     ", 0x00BC2108},
	{"fec_ul5g_2_ib_debug_reg                                 ", 0x00BC2200},
	{"fec_ul5g_2_ob_llr_debug_reg                             ", 0x00BC2204},
	{"fec_ul5g_2_ob_harq_debug_reg                            ", 0x00BC2208},
	{"fec_ul5g_3_cntrl_reg                                    ", 0x00BC3000},
	{"fec_ul5g_3_i2m_thresh_reg                               ", 0x00BC3004},
	{"fec_ul5g_3_version_reg                                  ", 0x00BC3100},
	{"fec_ul5g_3_fcw_status_reg                               ", 0x00BC3104},
	{"fec_ul5g_3_warn_reg                                     ", 0x00BC3108},
	{"fec_ul5g_3_ib_debug_reg                                 ", 0x00BC3200},
	{"fec_ul5g_3_ob_llr_debug_reg                             ", 0x00BC3204},
	{"fec_ul5g_3_ob_harq_debug_reg                            ", 0x00BC3208},
	{"fec_ul5g_4_cntrl_reg                                    ", 0x00BC4000},
	{"fec_ul5g_4_i2m_thresh_reg                               ", 0x00BC4004},
	{"fec_ul5g_4_version_reg                                  ", 0x00BC4100},
	{"fec_ul5g_4_fcw_status_reg                               ", 0x00BC4104},
	{"fec_ul5g_4_warn_reg                                     ", 0x00BC4108},
	{"fec_ul5g_4_ib_debug_reg                                 ", 0x00BC4200},
	{"fec_ul5g_4_ob_llr_debug_reg                             ", 0x00BC4204},
	{"fec_ul5g_4_ob_harq_debug_reg                            ", 0x00BC4208},
	{"fec_ul5g_5_cntrl_reg                                    ", 0x00BC5000},
	{"fec_ul5g_5_i2m_thresh_reg                               ", 0x00BC5004},
	{"fec_ul5g_5_version_reg                                  ", 0x00BC5100},
	{"fec_ul5g_5_fcw_status_reg                               ", 0x00BC5104},
	{"fec_ul5g_5_warn_reg                                     ", 0x00BC5108},
	{"fec_ul5g_5_ib_debug_reg                                 ", 0x00BC5200},
	{"fec_ul5g_5_ob_llr_debug_reg                             ", 0x00BC5204},
	{"fec_ul5g_5_ob_harq_debug_reg                            ", 0x00BC5208},
	{"fec_ul5g_6_cntrl_reg                                    ", 0x00BC6000},
	{"fec_ul5g_6_i2m_thresh_reg                               ", 0x00BC6004},
	{"fec_ul5g_6_version_reg                                  ", 0x00BC6100},
	{"fec_ul5g_6_fcw_status_reg                               ", 0x00BC6104},
	{"fec_ul5g_6_warn_reg                                     ", 0x00BC6108},
	{"fec_ul5g_6_ib_debug_reg                                 ", 0x00BC6200},
	{"fec_ul5g_6_ob_llr_debug_reg                             ", 0x00BC6204},
	{"fec_ul5g_6_ob_harq_debug_reg                            ", 0x00BC6208},
	{"fec_ul5g_7_cntrl_reg                                    ", 0x00BC7000},
	{"fec_ul5g_7_i2m_thresh_reg                               ", 0x00BC7004},
	{"fec_ul5g_7_version_reg                                  ", 0x00BC7100},
	{"fec_ul5g_7_fcw_status_reg                               ", 0x00BC7104},
	{"fec_ul5g_7_warn_reg                                     ", 0x00BC7108},
	{"fec_ul5g_7_ib_debug_reg                                 ", 0x00BC7200},
	{"fec_ul5g_7_ob_llr_debug_reg                             ", 0x00BC7204},
	{"fec_ul5g_7_ob_harq_debug_reg                            ", 0x00BC7208},
	{"fec_ul5g_8_cntrl_reg                                    ", 0x00BC8000},
	{"fec_ul5g_8_i2m_thresh_reg                               ", 0x00BC8004},
	{"fec_ul5g_8_version_reg                                  ", 0x00BC8100},
	{"fec_ul5g_8_fcw_status_reg                               ", 0x00BC8104},
	{"fec_ul5g_8_warn_reg                                     ", 0x00BC8108},
	{"fec_ul5g_8_ib_debug_reg                                 ", 0x00BC8200},
	{"fec_ul5g_8_ob_llr_debug_reg                             ", 0x00BC8204},
	{"fec_ul5g_8_ob_harq_debug_reg                            ", 0x00BC8208},
	{"fec_dl5g_0_cntrl_reg                                    ", 0x00BCD000},
	{"fec_dl5g_0_i2m_thresh_reg                               ", 0x00BCD004},
	{"fec_dl5g_0_version_reg                                  ", 0x00BCD100},
	{"fec_dl5g_0_fcw_status_reg                               ", 0x00BCD104},
	{"fec_dl5g_0_warn_reg                                     ", 0x00BCD108},
	{"fec_dl5g_0_ib_debug_reg                                 ", 0x00BCD200},
	{"fec_dl5g_0_ob_debug_reg                                 ", 0x00BCD204},
	{"fec_dl5g_1_cntrl_reg                                    ", 0x00BCE000},
	{"fec_dl5g_1_i2m_thresh_reg                               ", 0x00BCE004},
	{"fec_dl5g_1_version_reg                                  ", 0x00BCE100},
	{"fec_dl5g_1_fcw_status_reg                               ", 0x00BCE104},
	{"fec_dl5g_1_warn_reg                                     ", 0x00BCE108},
	{"fec_dl5g_1_ib_debug_reg                                 ", 0x00BCE200},
	{"fec_dl5g_1_ob_debug_reg                                 ", 0x00BCE204},
	{"fec_dl5g_2_cntrl_reg                                    ", 0x00BCF000},
	{"fec_dl5g_2_i2m_thresh_reg                               ", 0x00BCF004},
	{"fec_dl5g_2_version_reg                                  ", 0x00BCF100},
	{"fec_dl5g_2_fcw_status_reg                               ", 0x00BCF104},
	{"fec_dl5g_2_warn_reg                                     ", 0x00BCF108},
	{"fec_dl5g_2_ib_debug_reg                                 ", 0x00BCF200},
	{"fec_dl5g_2_ob_debug_reg                                 ", 0x00BCF204},
	{"fec_ul_0_version_reg                                    ", 0x00BD0000},
	{"fec_ul_0_control_reg                                    ", 0x00BD0004},
	{"fec_ul_0_status_reg                                     ", 0x00BD0008},
	{"fec_ul_1_version_reg                                    ", 0x00BD1000},
	{"fec_ul_1_control_reg                                    ", 0x00BD1004},
	{"fec_ul_1_status_reg                                     ", 0x00BD1008},
	{"fec_ul_2_version_reg                                    ", 0x00BD2000},
	{"fec_ul_2_control_reg                                    ", 0x00BD2004},
	{"fec_ul_2_status_reg                                     ", 0x00BD2008},
	{"fec_ul_3_version_reg                                    ", 0x00BD3000},
	{"fec_ul_3_control_reg                                    ", 0x00BD3004},
	{"fec_ul_3_status_reg                                     ", 0x00BD3008},
	{"fec_ul_4_version_reg                                    ", 0x00BD4000},
	{"fec_ul_4_control_reg                                    ", 0x00BD4004},
	{"fec_ul_4_status_reg                                     ", 0x00BD4008},
	{"fec_ul_5_version_reg                                    ", 0x00BD5000},
	{"fec_ul_5_control_reg                                    ", 0x00BD5004},
	{"fec_ul_5_status_reg                                     ", 0x00BD5008},
	{"fec_dl_4_version_reg                                    ", 0x00BDB000},
	{"fec_dl_4_cluster_config_reg                             ", 0x00BDB004},
	{"fec_dl_4_burst_thres                                    ", 0x00BDB00C},
	{"fec_dl_4_cluster_status_reg0                            ", 0x00BDB040},
	{"fec_dl_4_cluster_status_reg1                            ", 0x00BDB044},
	{"fec_dl_4_cluster_status_reg2                            ", 0x00BDB048},
	{"fec_dl_4_cluster_status_reg3                            ", 0x00BDB04C},
	{"fec_dl_4_cluster_status_reg4                            ", 0x00BDB050},
	{"fec_dl_4_cluster_status_reg5                            ", 0x00BDB054},
	{"fec_dl_3_version_reg                                    ", 0x00BDC000},
	{"fec_dl_3_cluster_config_reg                             ", 0x00BDC004},
	{"fec_dl_3_burst_thres                                    ", 0x00BDC00C},
	{"fec_dl_3_cluster_status_reg0                            ", 0x00BDC040},
	{"fec_dl_3_cluster_status_reg1                            ", 0x00BDC044},
	{"fec_dl_3_cluster_status_reg2                            ", 0x00BDC048},
	{"fec_dl_3_cluster_status_reg3                            ", 0x00BDC04C},
	{"fec_dl_3_cluster_status_reg4                            ", 0x00BDC050},
	{"fec_dl_3_cluster_status_reg5                            ", 0x00BDC054},
	{"fec_dl_2_version_reg                                    ", 0x00BDD000},
	{"fec_dl_2_cluster_config_reg                             ", 0x00BDD004},
	{"fec_dl_2_burst_thres                                    ", 0x00BDD00C},
	{"fec_dl_2_cluster_status_reg0                            ", 0x00BDD040},
	{"fec_dl_2_cluster_status_reg1                            ", 0x00BDD044},
	{"fec_dl_2_cluster_status_reg2                            ", 0x00BDD048},
	{"fec_dl_2_cluster_status_reg3                            ", 0x00BDD04C},
	{"fec_dl_2_cluster_status_reg4                            ", 0x00BDD050},
	{"fec_dl_2_cluster_status_reg5                            ", 0x00BDD054},
	{"fec_dl_1_version_reg                                    ", 0x00BDE000},
	{"fec_dl_1_cluster_config_reg                             ", 0x00BDE004},
	{"fec_dl_1_burst_thres                                    ", 0x00BDE00C},
	{"fec_dl_1_cluster_status_reg0                            ", 0x00BDE040},
	{"fec_dl_1_cluster_status_reg1                            ", 0x00BDE044},
	{"fec_dl_1_cluster_status_reg2                            ", 0x00BDE048},
	{"fec_dl_1_cluster_status_reg3                            ", 0x00BDE04C},
	{"fec_dl_1_cluster_status_reg4                            ", 0x00BDE050},
	{"fec_dl_1_cluster_status_reg5                            ", 0x00BDE054},
	{"fec_dl_0_version_reg                                    ", 0x00BDF000},
	{"fec_dl_0_cluster_config_reg                             ", 0x00BDF004},
	{"fec_dl_0_burst_thres                                    ", 0x00BDF00C},
	{"fec_dl_0_cluster_status_reg0                            ", 0x00BDF040},
	{"fec_dl_0_cluster_status_reg1                            ", 0x00BDF044},
	{"fec_dl_0_cluster_status_reg2                            ", 0x00BDF048},
	{"fec_dl_0_cluster_status_reg3                            ", 0x00BDF04C},
	{"fec_dl_0_cluster_status_reg4                            ", 0x00BDF050},
	{"fec_dl_0_cluster_status_reg5                            ", 0x00BDF054},
	{"hi_vf_to_pf_dbell_vf                                    ", 0x00C80000},
	{"hi_pf_to_vf_dbell_vf                                    ", 0x00C80008},
	{"hi_info_ring_base_lo_vf                                 ", 0x00C80010},
	{"hi_info_ring_base_hi_vf                                 ", 0x00C80014},
	{"hi_info_ring_pointer_vf                                 ", 0x00C80018},
	{"hi_info_ring_int_wr_en_vf                               ", 0x00C80020},
	{"hi_info_ring_pf2_vf_wr_en_vf                            ", 0x00C80024},
	{"hi_msix_vector_mapper_vf                                ", 0x00C80060},
	{"hi_module_version_reg                                   ", 0x00C84000},
	{"hi_iosf2axi_err_log_reg                                 ", 0x00C84004},
	{"hi_hard_reset_reg                                       ", 0x00C84008},
	{"hi_5ghard_reset_reg                                     ", 0x00C8400C},
	{"hi_info_ring_base_lo_reg_pf                             ", 0x00C84010},
	{"hi_info_ring_base_hi_reg_pf                             ", 0x00C84014},
	{"hi_info_ring_pointer_reg_pf                             ", 0x00C84018},
	{"hi_info_ring_int_wr_en_reg_pf                           ", 0x00C84020},
	{"hi_info_ring_vf2pf_lo_wr_en_reg                         ", 0x00C84024},
	{"hi_info_ring_vf2pf_hi_wr_en_reg                         ", 0x00C84028},
	{"hi_log_parity_err_status_reg                            ", 0x00C8402C},
	{"hi_log_data_parity_error_vf_status_lo                   ", 0x00C84030},
	{"hi_log_data_parity_error_vf_status_hi                   ", 0x00C84034},
	{"hi_block_transmit_on_error_en                           ", 0x00C84038},
	{"hi_cfg_msi_int_wr_en_reg_pf                             ", 0x00C84040},
	{"hi_cfg_msi_vf2pf_lo_wr_en_reg                           ", 0x00C84044},
	{"hi_cfg_msi_vf2pf_high_wr_en_reg                         ", 0x00C84048},
	{"hi_msix_vector_mapper_pf                                ", 0x00C84060},
	{"hi_apb_wr_wait_time                                     ", 0x00C84100},
	{"hi_x_counter_max_value                                  ", 0x00C84104},
	{"hi_pf_mode                                              ", 0x00C84108},
	{"hi_clk_gate_hyst_reg                                    ", 0x00C8410C},
	{"hi_snoop_bits_reg                                       ", 0x00C84110},
	{"hi_msi_drop_enable_reg                                  ", 0x00C84114},
	{"hi_msi_stat_reg                                         ", 0x00C84120},
	{"hi_fifo_ofl_stat_reg                                    ", 0x00C84124},
	{"hi_hi_debug_reg                                         ", 0x00C841F4},
	{"hi_debug_mem_snoop_msi_fifo                             ", 0x00C841F8},
	{"hi_debug_mem_snoop_input_fifo                           ", 0x00C841FC},
	{"hi_msix_mapping_config                                  ", 0x00C84200},
	{"hi_junk_reg                                             ", 0x00C8FF00},
	{"pcie_ln_asic_cfgovr                                     ", 0x00D80000},
	{"pcie_ln_aclkmixer                                       ", 0x00D80004},
	{"pcie_ln_txrampfreq                                      ", 0x00D80008},
	{"pcie_ln_lanetest                                        ", 0x00D8000C},
	{"pcie_ln_dcctrl                                          ", 0x00D80010},
	{"pcie_ln_dccmeas                                         ", 0x00D80014},
	{"pcie_ln_dccovr_aclk                                     ", 0x00D80018},
	{"pcie_ln_dccovr_txa                                      ", 0x00D8001C},
	{"pcie_ln_dccovr_txk                                      ", 0x00D80020},
	{"pcie_ln_dccovr_dclk                                     ", 0x00D80024},
	{"pcie_ln_dccovr_eclk                                     ", 0x00D80028},
	{"pcie_ln_dcctrim_aclk                                    ", 0x00D8002C},
	{"pcie_ln_dcctrim_tx                                      ", 0x00D80030},
	{"pcie_ln_dcctrim_dclk                                    ", 0x00D80034},
	{"pcie_ln_dcctrim_eclk                                    ", 0x00D80038},
	{"pcie_ln_quad_ctrl                                       ", 0x00D8003C},
	{"pcie_ln_quad_corr_index                                 ", 0x00D80040},
	{"pcie_ln_quad_corr_status                                ", 0x00D80044},
	{"pcie_ln_asic_rxovr1                                     ", 0x00D80048},
	{"pcie_ln_asic_rxovr2                                     ", 0x00D8004C},
	{"pcie_ln_asic_eqinfovr                                   ", 0x00D80050},
	{"pcie_ln_rxcsr                                           ", 0x00D80054},
	{"pcie_ln_rxfectrl                                        ", 0x00D80058},
	{"pcie_ln_rxtest                                          ", 0x00D8005C},
	{"pcie_ln_escount                                         ", 0x00D80060},
	{"pcie_ln_cdrctrl                                         ", 0x00D80064},
	{"pcie_ln_cdrctrl2                                        ", 0x00D80068},
	{"pcie_ln_cdrcfg0_ctrl0                                   ", 0x00D8006C},
	{"pcie_ln_cdrcfg0_ctrl1                                   ", 0x00D80070},
	{"pcie_ln_cdrcfg0_ctrl2                                   ", 0x00D80074},
	{"pcie_ln_cdrcfg1_ctrl0                                   ", 0x00D80078},
	{"pcie_ln_cdrcfg1_ctrl1                                   ", 0x00D8007C},
	{"pcie_ln_cdrcfg1_ctrl2                                   ", 0x00D80080},
	{"pcie_ln_cdrcfg2_ctrl0                                   ", 0x00D80084},
	{"pcie_ln_cdrcfg2_ctrl1                                   ", 0x00D80088},
	{"pcie_ln_cdrcfg2_ctrl2                                   ", 0x00D8008C},
	{"pcie_ln_cdrcfg3_ctrl0                                   ", 0x00D80090},
	{"pcie_ln_cdrcfg3_ctrl1                                   ", 0x00D80094},
	{"pcie_ln_cdrcfg3_ctrl2                                   ", 0x00D80098},
	{"pcie_ln_cdrphase                                        ", 0x00D8009C},
	{"pcie_ln_cdrfreq                                         ", 0x00D800A0},
	{"pcie_ln_cdrstatus_phase                                 ", 0x00D800A4},
	{"pcie_ln_cdrstatus_freq                                  ", 0x00D800A8},
	{"pcie_ln_cdroffset                                       ", 0x00D800AC},
	{"pcie_ln_rxvosctl                                        ", 0x00D800B0},
	{"pcie_ln_rxvosctl2                                       ", 0x00D800B4},
	{"pcie_ln_rxlosctl                                        ", 0x00D800B8},
	{"pcie_ln_rxlos                                           ", 0x00D800BC},
	{"pcie_ln_rxlosvval                                       ", 0x00D800C0},
	{"pcie_ln_rxvosd0                                         ", 0x00D800C4},
	{"pcie_ln_rxvosd1                                         ", 0x00D800C8},
	{"pcie_ln_rxvosep0                                        ", 0x00D800CC},
	{"pcie_ln_rxvosep1                                        ", 0x00D800D0},
	{"pcie_ln_rxvosen0                                        ", 0x00D800D4},
	{"pcie_ln_rxvosen1                                        ", 0x00D800D8},
	{"pcie_ln_rxvosafe                                        ", 0x00D800DC},
	{"pcie_ln_rxvosa0                                         ", 0x00D800E0},
	{"pcie_ln_rxvosa0_out                                     ", 0x00D800E4},
	{"pcie_ln_rxvosa1                                         ", 0x00D800E8},
	{"pcie_ln_rxvosa1_out                                     ", 0x00D800EC},
	{"pcie_ln_rxmisc                                          ", 0x00D800F0},
	{"pcie_ln_rxbeacon                                        ", 0x00D800F4},
	{"pcie_ln_rxdssout                                        ", 0x00D800F8},
	{"pcie_ln_rxdssout2                                       ", 0x00D800FC},
	{"pcie_ln_alphapctrl                                      ", 0x00D80100},
	{"pcie_ln_alphanctrl                                      ", 0x00D80104},
	{"pcie_ln_adaptctrl                                       ", 0x00D80108},
	{"pcie_ln_adaptctrl1                                      ", 0x00D8010C},
	{"pcie_ln_adaptstatus                                     ", 0x00D80110},
	{"pcie_ln_adaptvga1                                       ", 0x00D80114},
	{"pcie_ln_adaptvga2                                       ", 0x00D80118},
	{"pcie_ln_adaptvga3                                       ", 0x00D8011C},
	{"pcie_ln_adaptvga4                                       ", 0x00D80120},
	{"pcie_ln_adaptboost1                                     ", 0x00D80124},
	{"pcie_ln_adaptboost2                                     ", 0x00D80128},
	{"pcie_ln_adaptboost3                                     ", 0x00D8012C},
	{"pcie_ln_adaptboost4                                     ", 0x00D80130},
	{"pcie_ln_adaptsslms1                                     ", 0x00D80134},
	{"pcie_ln_adaptsslms2                                     ", 0x00D80138},
	{"pcie_ln_adaptvga_status                                 ", 0x00D8013C},
	{"pcie_ln_adaptboost_status                               ", 0x00D80140},
	{"pcie_ln_adaptsslms_status1                              ", 0x00D80144},
	{"pcie_ln_adaptsslms_status2                              ", 0x00D80148},
	{"pcie_ln_afectrl1                                        ", 0x00D8014C},
	{"pcie_ln_afectrl2                                        ", 0x00D80150},
	{"pcie_ln_afectrl3                                        ", 0x00D80154},
	{"pcie_ln_afedefault1                                     ", 0x00D80158},
	{"pcie_ln_afedefault2                                     ", 0x00D8015C},
	{"pcie_ln_dfectrl1                                        ", 0x00D80160},
	{"pcie_ln_dfectrl2                                        ", 0x00D80164},
	{"pcie_ln_dfectrl3                                        ", 0x00D80168},
	{"pcie_ln_dfectrl4                                        ", 0x00D8016C},
	{"pcie_ln_dfectrl5                                        ", 0x00D80170},
	{"pcie_ln_dfectrl6                                        ", 0x00D80174},
	{"pcie_ln_afestatus1                                      ", 0x00D80178},
	{"pcie_ln_afestatus2                                      ", 0x00D8017C},
	{"pcie_ln_dfestatus1                                      ", 0x00D80180},
	{"pcie_ln_dfestatus2                                      ", 0x00D80184},
	{"pcie_ln_dfestatus3                                      ", 0x00D80188},
	{"pcie_ln_dfestatus4                                      ", 0x00D8018C},
	{"pcie_ln_dfestatus5                                      ", 0x00D80190},
	{"pcie_ln_alphastatus                                     ", 0x00D80194},
	{"pcie_ln_fomctrl1                                        ", 0x00D80198},
	{"pcie_ln_fomctrl2                                        ", 0x00D8019C},
	{"pcie_ln_fomctrl3                                        ", 0x00D801A0},
	{"pcie_ln_aclkcal_status                                  ", 0x00D801A4},
	{"pcie_ln_offscorr_status                                 ", 0x00D801A8},
	{"pcie_ln_eyewidth_status                                 ", 0x00D801AC},
	{"pcie_ln_eyeheight_status                                ", 0x00D801B0},
	{"pcie_ln_asic_txovr1                                     ", 0x00D801B4},
	{"pcie_ln_asic_txovr2                                     ", 0x00D801B8},
	{"pcie_ln_asic_txovr3                                     ", 0x00D801BC},
	{"pcie_ln_txbiasadj_ovr                                   ", 0x00D801C0},
	{"pcie_ln_txcsr                                           ", 0x00D801C4},
	{"pcie_ln_txtest                                          ", 0x00D801C8},
	{"pcie_ln_txtestword                                      ", 0x00D801CC},
	{"pcie_ln_txtestword_high                                 ", 0x00D801D0},
	{"pcie_ln_txdrive                                         ", 0x00D801D4},
	{"pcie_ln_mtcs_ln                                         ", 0x00D801D8},
	{"pcie_ln_statsum_ln                                      ", 0x00D801DC},
	{"pcie_ln_rcbus_scratch                                   ", 0x00D801E0},
	{"pcie_ln_rcbus_minorrev                                  ", 0x00D801F0},
	{"pcie_ln_rcbus_majorrev                                  ", 0x00D801F4},
	{"pcie_ln_rcbus_blocktype                                 ", 0x00D801F8},
	{"pcie_sup_pllcsr                                         ", 0x00D80800},
	{"pcie_sup_plldiv                                         ", 0x00D80804},
	{"pcie_sup_pllcal                                         ", 0x00D80808},
	{"pcie_sup_pllcalsts                                      ", 0x00D8080C},
	{"pcie_sup_pllmeas                                        ", 0x00D80810},
	{"pcie_sup_plldactrim                                     ", 0x00D80814},
	{"pcie_sup_pllbiastrim                                    ", 0x00D80818},
	{"pcie_sup_pllbwtrim                                      ", 0x00D8081C},
	{"pcie_sup_pllcaldly                                      ", 0x00D80820},
	{"pcie_sup_refclkonpclkctrl                               ", 0x00D80824},
	{"pcie_sup_pclkdelay                                      ", 0x00D80828},
	{"pcie_sup_phyconfig                                      ", 0x00D8082C},
	{"pcie_sup_rcal_intf                                      ", 0x00D80830},
	{"pcie_sup_auxcsr                                         ", 0x00D80834},
	{"pcie_sup_vref                                           ", 0x00D80838},
	{"pcie_sup_linkmode                                       ", 0x00D8083C},
	{"pcie_sup_rrefcalctl                                     ", 0x00D80840},
	{"pcie_sup_rrefcal                                        ", 0x00D80844},
	{"pcie_sup_rrefcaldly                                     ", 0x00D80848},
	{"pcie_sup_tximpcalctl                                    ", 0x00D8084C},
	{"pcie_sup_tximpcal                                       ", 0x00D80850},
	{"pcie_sup_tximpoffset                                    ", 0x00D80854},
	{"pcie_sup_tximpcaldly                                    ", 0x00D80858},
	{"pcie_sup_rximpcalctl                                    ", 0x00D8085C},
	{"pcie_sup_rximpcal                                       ", 0x00D80860},
	{"pcie_sup_rximpoffset                                    ", 0x00D80864},
	{"pcie_sup_rximpcaldly                                    ", 0x00D80868},
	{"pcie_sup_fence                                          ", 0x00D8086C},
	{"pcie_sup_mtcs                                           ", 0x00D80870},
	{"pcie_sup_statsum                                        ", 0x00D809B8},
	{"pcie_pcs_dp_status0                                     ", 0x00D81000},
	{"pcie_pcs_dp_control0                                    ", 0x00D81004},
	{"pcie_pcs_pma_status_lane0                               ", 0x00D81008},
	{"pcie_pcs_pipe_status_lane0                              ", 0x00D8100C},
	{"pcie_pcs_txdeemph0_lane0                                ", 0x00D81010},
	{"pcie_pcs_txdeemph1_lane0                                ", 0x00D81014},
	{"pcie_pcs_internal_status_lane0                          ", 0x00D81018},
	{"pcie_pcs_dp_status1                                     ", 0x00D8101C},
	{"pcie_pcs_dp_control1                                    ", 0x00D81020},
	{"pcie_pcs_pma_status_lane1                               ", 0x00D81024},
	{"pcie_pcs_pipe_status_lane1                              ", 0x00D81028},
	{"pcie_pcs_txdeemph0_lane1                                ", 0x00D8102C},
	{"pcie_pcs_txdeemph1_lane1                                ", 0x00D81030},
	{"pcie_pcs_internal_status_lane1                          ", 0x00D81034},
	{"pcie_pcs_dp_status2                                     ", 0x00D81038},
	{"pcie_pcs_dp_control2                                    ", 0x00D8103C},
	{"pcie_pcs_pma_status_lane2                               ", 0x00D81040},
	{"pcie_pcs_pipe_status_lane2                              ", 0x00D81044},
	{"pcie_pcs_txdeemph0_lane2                                ", 0x00D81048},
	{"pcie_pcs_txdeemph1_lane2                                ", 0x00D8104C},
	{"pcie_pcs_internal_status_lane2                          ", 0x00D81050},
	{"pcie_pcs_dp_status3                                     ", 0x00D81054},
	{"pcie_pcs_dp_control3                                    ", 0x00D81058},
	{"pcie_pcs_pma_status_lane3                               ", 0x00D8105C},
	{"pcie_pcs_pipe_status_lane3                              ", 0x00D81060},
	{"pcie_pcs_txdeemph0_lane3                                ", 0x00D81064},
	{"pcie_pcs_txdeemph1_lane3                                ", 0x00D81068},
	{"pcie_pcs_internal_status_lane3                          ", 0x00D8106C},
	{"pcie_pcs_eb_status0                                     ", 0x00D81070},
	{"pcie_pcs_eb_status1                                     ", 0x00D81074},
	{"pcie_pcs_eb_status2                                     ", 0x00D81078},
	{"pcie_pcs_eb_status3                                     ", 0x00D8107C},
	{"pcie_pcs_pll_setting_pcie_g1                            ", 0x00D81088},
	{"pcie_pcs_pll_setting_pcie_g2                            ", 0x00D8108C},
	{"pcie_pcs_pll_setting_pcie_g3                            ", 0x00D81090},
	{"pcie_pcs_control                                        ", 0x00D81094},
	{"pcie_pcs_eq_control                                     ", 0x00D81098},
	{"pcie_pcs_eq_timer                                       ", 0x00D8109C},
	{"pcie_pcs_eq_err_status                                  ", 0x00D810A0},
	{"pcie_pcs_eq_err_count                                   ", 0x00D810A4},
	{"pcie_pcs_status                                         ", 0x00D810A8},
	{"pcie_pcs_misc_register                                  ", 0x00D810AC},
	{"pcie_pcs_obs_control                                    ", 0x00D810B0},
	{"pcie_pcs_prbs_count0                                    ", 0x00D81200},
	{"pcie_pcs_bist_control0                                  ", 0x00D81204},
	{"pcie_pcs_bist_static_word00                             ", 0x00D81208},
	{"pcie_pcs_bist_static_word10                             ", 0x00D8120C},
	{"pcie_pcs_bist_static_word20                             ", 0x00D81210},
	{"pcie_pcs_bist_static_word30                             ", 0x00D81214},
	{"pcie_pcs_prbs_count1                                    ", 0x00D81220},
	{"pcie_pcs_bist_control1                                  ", 0x00D81224},
	{"pcie_pcs_bist_static_word01                             ", 0x00D81228},
	{"pcie_pcs_bist_static_word11                             ", 0x00D8122C},
	{"pcie_pcs_bist_static_word21                             ", 0x00D81230},
	{"pcie_pcs_bist_static_word31                             ", 0x00D81234},
	{"pcie_pcs_prbs_count2                                    ", 0x00D81240},
	{"pcie_pcs_bist_control2                                  ", 0x00D81244},
	{"pcie_pcs_bist_static_word02                             ", 0x00D81248},
	{"pcie_pcs_bist_static_word12                             ", 0x00D8124C},
	{"pcie_pcs_bist_static_word22                             ", 0x00D81250},
	{"pcie_pcs_bist_static_word32                             ", 0x00D81254},
	{"pcie_pcs_prbs_count3                                    ", 0x00D81260},
	{"pcie_pcs_bist_control3                                  ", 0x00D81264},
	{"pcie_pcs_bist_static_word03                             ", 0x00D81268},
	{"pcie_pcs_bist_static_word13                             ", 0x00D8126C},
	{"pcie_pcs_bist_static_word23                             ", 0x00D81270},
	{"pcie_pcs_bist_static_word33                             ", 0x00D81274},
	{"pcie_gpex_ltssm_state_cntrl                             ", 0x00D90400},
	{"pcie_gpex_ltssm_state_status                            ", 0x00D90404},
	{"pcie_gpex_skip_freq_timer                               ", 0x00D90408},
	{"pcie_gpex_lane_select                                   ", 0x00D9040C},
	{"pcie_gpex_lane_deskew                                   ", 0x00D90410},
	{"pcie_gpex_rx_error_status                               ", 0x00D90414},
	{"pcie_gpex_lane_num_control                              ", 0x00D90418},
	{"pcie_gpex_n_fst_control                                 ", 0x00D9041C},
	{"pcie_gpex_link_status                                   ", 0x00D90420},
	{"pcie_gpex_ack_replay_timeout                            ", 0x00D90438},
	{"pcie_gpex_seq_number_status                             ", 0x00D9043C},
	{"pcie_gpex_core_clk_ratio                                ", 0x00D90440},
	{"pcie_gpex_dll_thold_control                             ", 0x00D90448},
	{"pcie_gpex_pm_timer                                      ", 0x00D90450},
	{"pcie_gpex_pme_timeout                                   ", 0x00D90454},
	{"pcie_gpex_aspm_l1_timer                                 ", 0x00D90458},
	{"pcie_gpex_aspm_req_timer                                ", 0x00D9045C},
	{"pcie_gpex_aspm_l1_dis                                   ", 0x00D90460},
	{"pcie_gpex_advisory_error_control                        ", 0x00D90468},
	{"pcie_gpex_id                                            ", 0x00D90470},
	{"pcie_gpex_classcode                                     ", 0x00D90474},
	{"pcie_gpex_subsystem_id                                  ", 0x00D90478},
	{"pcie_gpex_device_capabilities                           ", 0x00D9047C},
	{"pcie_gpex_link_capabilities                             ", 0x00D90480},
	{"pcie_gpex_function_number                               ", 0x00D90484},
	{"pcie_gpex_pm_capabilities                               ", 0x00D90488},
	{"pcie_gpex_function_select                               ", 0x00D9048C},
	{"pcie_gpex_error_counter                                 ", 0x00D904AC},
	{"pcie_gpex_config_ready                                  ", 0x00D904B0},
	{"pcie_gpex_fc_update_timeout                             ", 0x00D904B8},
	{"pcie_gpex_fc_update_timer                               ", 0x00D904BC},
	{"pcie_gpex_vc_buffer_load                                ", 0x00D904C8},
	{"pcie_gpex_vc_buffer_size_thold                          ", 0x00D904CC},
	{"pcie_gpex_vc_buffer_select                              ", 0x00D904D0},
	{"pcie_gpex_bar_enable                                    ", 0x00D904D4},
	{"pcie_gpex_bar_dword_lower                               ", 0x00D904D8},
	{"pcie_gpex_bar_dword_upper                               ", 0x00D904DC},
	{"pcie_gpex_bar_select                                    ", 0x00D904E0},
	{"pcie_gpex_credit_counter_select                         ", 0x00D904E4},
	{"pcie_gpex_credit_counter_status                         ", 0x00D904E8},
	{"pcie_gpex_tlp_header_select                             ", 0x00D904EC},
	{"pcie_gpex_tlp_header_dword0                             ", 0x00D904F0},
	{"pcie_gpex_tlp_header_dword1                             ", 0x00D904F4},
	{"pcie_gpex_tlp_header_dword2                             ", 0x00D904F8},
	{"pcie_gpex_tlp_header_dword3                             ", 0x00D904FC},
	{"pcie_gpex_relax_order_control                           ", 0x00D90500},
	{"pcie_gpex_bar_prefetch                                  ", 0x00D90504},
	{"pcie_gpex_fc_check_control                              ", 0x00D90508},
	{"pcie_gpex_fc_update_timer_traffic                       ", 0x00D90518},
	{"pcie_gpex_phy_control0                                  ", 0x00D9053C},
	{"pcie_gpex_phy_control1                                  ", 0x00D90544},
	{"pcie_gpex_phy_control2                                  ", 0x00D9054C},
	{"pcie_gpex_user_control0                                 ", 0x00D9055C},
	{"pcie_gpex_uncorr_error_status                           ", 0x00D905F0},
	{"pcie_gpex_rx_cpl_error                                  ", 0x00D90620},
	{"pcie_gpex_rx_cpl_error_dword0                           ", 0x00D90624},
	{"pcie_gpex_rx_cpl_error_dword1                           ", 0x00D90628},
	{"pcie_gpex_rx_cpl_error_dword2                           ", 0x00D9062C},
	{"pcie_gpex_pab_sw_reset_en                               ", 0x00D90630},
	{"pcie_gpex_gen3_control0                                 ", 0x00D90634},
	{"pcie_gpex_gen3_control1                                 ", 0x00D90638},
	{"pcie_gpex_gen3_control2                                 ", 0x00D9063C},
	{"pcie_gpex_gen2_control_csr                              ", 0x00D90640},
	{"pcie_gpex_total_vf_initial_vf0                          ", 0x00D90644},
	{"pcie_gpex_total_vf_initial_vf1                          ", 0x00D90648},
	{"pcie_gpex_sriov_link_dev_id0                            ", 0x00D90684},
	{"pcie_gpex_sriov_link_dev_id1                            ", 0x00D90688},
	{"pcie_gpex_sriov_page_size0                              ", 0x00D906C4},
	{"pcie_gpex_sriov_page_size1                              ", 0x00D906C8},
	{"pcie_gpex_id_version                                    ", 0x00D906FC},
	{"pcie_gpex_sriov_vf_offset_stride0                       ", 0x00D90704},
	{"pcie_gpex_sriov_vf_offset_stride1                       ", 0x00D90708},
	{"pcie_gpex_gen3_deskew_control                           ", 0x00D907B4},
	{"pcie_gpex_gen3_eq_control                               ", 0x00D907B8},
	{"pcie_gpex_bridge_version                                ", 0x00D90800},
	{"pcie_gpex_bridge_capability                             ", 0x00D90804},
	{"pcie_gpex_bridge_control                                ", 0x00D90808},
	{"pcie_gpex_bridge_status                                 ", 0x00D9080C},
	{"pcie_gpex_engine_activity_status                        ", 0x00D9081C},
	{"pcie_gpex_engine_reset_control                          ", 0x00D90820},
	{"pcie_gpex_axi_pio_control                               ", 0x00D90840},
	{"pcie_gpex_axi_pio_status                                ", 0x00D90844},
	{"pcie_gpex_amba_slave_cmd_status                         ", 0x00D90848},
	{"pcie_gpex_pex_pio_control                               ", 0x00D908C0},
	{"pcie_gpex_pex_pio_status                                ", 0x00D908C4},
	{"pcie_gpex_amba_master_status                            ", 0x00D908C8},
	{"pcie_gpex_csr_slave_cmd_status                          ", 0x00D90920},
	{"pcie_gpex_mailbox_axi_control                           ", 0x00D90A50},
	{"pcie_gpex_mailbox_axi_data                              ", 0x00D90A54},
	{"pcie_gpex_mailbox_pex_control                           ", 0x00D90A90},
	{"pcie_gpex_mailbox_pex_data                              ", 0x00D90A94},
	{"pcie_gpex_pex_interrupt_enable                          ", 0x00D90AD0},
	{"pcie_gpex_pex_interrupt_status                          ", 0x00D90AD4},
	{"pcie_gpex_pex_interrupt_axi_pio_vector                  ", 0x00D90AD8},
	{"pcie_gpex_pex_interrupt_pex_pio_vector                  ", 0x00D90AE0},
	{"pcie_gpex_pex_interrupt_misc_vector                     ", 0x00D90AF8},
	{"pcie_gpex_amba_interrupt_pio_enable                     ", 0x00D90B00},
	{"pcie_gpex_amba_interrupt_misc_enable                    ", 0x00D90B0C},
	{"pcie_gpex_amba_interrupt_pio_status                     ", 0x00D90B10},
	{"pcie_gpex_amba_interrupt_misc_status                    ", 0x00D90B1C},
	{"pcie_gpex_pex_pm_control                                ", 0x00D90B80},
	{"pcie_gpex_slot_misc                                     ", 0x00D90B88},
	{"pcie_gpex_axi_addr_mapping_control                      ", 0x00D90BA0},
	{"pcie_gpex_axi_addr_mapping_window_axi_base              ", 0x00D90BA4},
	{"pcie_gpex_axi_addr_mapping_window_pex_base_low          ", 0x00D90BA8},
	{"pcie_gpex_axi_addr_mapping_window_pex_base_high         ", 0x00D90BAC},
	{"pcie_gpex_pex_bar_addr_func0_bar0                       ", 0x00D91BA0},
	{"pcie_gpex_pex_bar_addr_func0_bar1                       ", 0x00D91BA4},
	{"pcie_gpex_axi_addr_mapping_pcie_hdr_param               ", 0x00D95BA0},
	{"pcie_gpex_ext_axi_addr_mapping_axi_base                 ", 0x00D980A0},
	{"pcie_gpex_pex_ext_bar_addr_func0_bar0                   ", 0x00D984A0},
	{"pcie_gpex_pex_ext_bar_addr_func0_bar1                   ", 0x00D984A4},
	{"pcie_gpex_amba_interrupt_flr_enable                     ", 0x00D9B960},
	{"pcie_gpex_amba_interrupt_flr_status                     ", 0x00D9B9A0},
	{"pcie_gpex_ext_axi_addr_mapping_size                     ", 0x00D9BAF0},
	{"pcie_gpex_pex_pio_awcache_control                       ", 0x00D9C300},
	{"pcie_gpex_pex_pio_arcache_control                       ", 0x00D9C304},
	{"pcie_gpex_pab_ob_size_control_vc0                       ", 0x00D9C310},
};

/* ACC200 register */
struct acc200_reg_dump_info acc200_rd_db[] = {
	{"qmgr_egress_queues_template                             ", 0x0007FC00},
	{"qmgr_ingress_aq                                         ", 0x00080000},
	{"aram_control_status                                     ", 0x00810000},
	{"qmgr_arb_q_avail                                        ", 0x00A00010},
	{"qmgr_arb_q_block                                        ", 0x00A00020},
	{"qmgr_aqueue_drop_notif_en                               ", 0x00A00024},
	{"qmgr_aqueue_disable_notif_en                            ", 0x00A00028},
	{"qmgr_soft_reset                                         ", 0x00A00038},
	{"qmgr_init_status                                        ", 0x00A0003C},
	{"qmgr_aram_watchdog_count                                ", 0x00A00040},
	{"qmgr_aram_watchdog_counter_en                           ", 0x00A00044},
	{"qmgr_axi_watchdog_count                                 ", 0x00A00048},
	{"qmgr_axi_watchdog_counter_en                            ", 0x00A0004C},
	{"qmgr_process_watchdog_count                             ", 0x00A00060},
	{"qmgr_process_watchdog_counter_en                        ", 0x00A00054},
	{"qmgr_process_watchdog_counter                           ", 0x00A00060},
	{"qmgr_msi_overflow_upper_vf                              ", 0x00A00080},
	{"qmgr_msi_overflow_lower_vf                              ", 0x00A00084},
	{"qmgr_msi_watchdog_overflow                              ", 0x00A00088},
	{"qmgr_msi_overflow_enable                                ", 0x00A0008C},
	{"qmgr_debug_aq_pointer_mem_grp                           ", 0x00A00100},
	{"qmgr_debug_output_arb_q_fifo_grp                        ", 0x00A00140},
	{"qmgr_debug_msi_fifo_grp                                 ", 0x00A00180},
	{"qmgr_debug_axi_wd_timeout_msi_fifo                      ", 0x00A001C0},
	{"qmgr_debug_process_wd_timeout_msi_fifo                  ", 0x00A001C4},
	{"qmgr_depth_log2_grp                                     ", 0x00A00200},
	{"qmgr_thold_grp                                          ", 0x00A00300},
	{"qmgr_grp_tmplate_reg0_indx                              ", 0x00A00600},
	{"qmgr_grp_tmplate_reg1_indx                              ", 0x00A00700},
	{"qmgr_grp_tmplate_reg2_indx                              ", 0x00A00800},
	{"qmgr_grp_tmplate_reg3_indx                              ", 0x00A00900},
	{"qmgr_grp_tmplate_reg4_indx                              ", 0x00A00A00},
	{"qmgr_vf_base_addr                                       ", 0x00A01000},
	{"qmgr_ul4g_weight_rr_vf                                  ", 0x00A02000},
	{"qmgr_dl4g_weight_rr_vf                                  ", 0x00A02100},
	{"qmgr_ul5g_weight_rr_vf                                  ", 0x00A02200},
	{"qmgr_dl5g_weight_rr_vf                                  ", 0x00A02300},
	{"qmgr_mld_weight_rr_vf                                   ", 0x00A02400},
	{"qmgr_arb_q_depth_grp                                    ", 0x00A02F00},
	{"qmgr_grp_function0                                      ", 0x00A02F40},
	{"qmgr_grp_function1                                      ", 0x00A02F44},
	{"qmgr_grp_priority                                       ", 0x00A02F48},
	{"qmgr_weight_sync                                        ", 0x00A03000},
	{"qmgr_aq_enable_vf                                       ", 0x00A10000},
	{"qmgr_aq_reset_vf                                        ", 0x00A20000},
	{"qmgr_ring_size_vf                                       ", 0x00A20004},
	{"qmgr_grp_depth_log20_vf                                 ", 0x00A20008},
	{"qmgr_grp_depth_log21_vf                                 ", 0x00A2000C},
	{"qmgr_grp_function0_vf                                   ", 0x00A20010},
	{"qmgr_grp_function1_vf                                   ", 0x00A20014},
	{"fabric_m2i_buffer_status_debug0_g0                      ", 0x00B3F000},
	{"fabric_m2i_buffer_status_debug1_g0                      ", 0x00B3F004},
	{"fabric_m2i_buffer_status_debug2_g0                      ", 0x00B3F008},
	{"fabric_m2i_buffer_status_debug3_g0                      ", 0x00B3F00C},
	{"fabric_m2i_buffer_status_debug4_g0                      ", 0x00B3F010},
	{"fabric_m2i_buffer_status_debug5_g0                      ", 0x00B3F014},
	{"fabric_m2i_buffer_status_debug6_g0                      ", 0x00B3F018},
	{"fabric_m2i_buffer_status_debug7_g0                      ", 0x00B3F01C},
	{"fabric_m2i_buffer_status_debug0_g1                      ", 0x00B3F040},
	{"fabric_m2i_buffer_status_debug1_g1                      ", 0x00B3F044},
	{"fabric_m2i_buffer_status_debug2_g1                      ", 0x00B3F048},
	{"fabric_m2i_buffer_status_debug3_g1                      ", 0x00B3F04C},
	{"fabric_m2i_buffer_status_debug4_g1                      ", 0x00B3F050},
	{"fabric_m2i_buffer_status_debug5_g1                      ", 0x00B3F054},
	{"fabric_m2i_buffer_status_debug6_g1                      ", 0x00B3F058},
	{"fabric_m2i_buffer_status_debug7_g1                      ", 0x00B3F05C},
	{"fabric_m2i_buffer_status_debug0_g2                      ", 0x00B3F080},
	{"fabric_m2i_buffer_status_debug1_g2                      ", 0x00B3F084},
	{"fabric_m2i_buffer_status_debug2_g2                      ", 0x00B3F088},
	{"fabric_m2i_buffer_status_debug3_g2                      ", 0x00B3F08C},
	{"fabric_m2i_buffer_status_debug4_g2                      ", 0x00B3F090},
	{"fabric_m2i_buffer_status_debug5_g2                      ", 0x00B3F094},
	{"fabric_m2i_buffer_status_debug6_g2                      ", 0x00B3F098},
	{"fabric_m2i_buffer_status_debug7_g2                      ", 0x00B3F09C},
	{"fabric_m2i_buffer_status_debug0_g3                      ", 0x00B3F0C0},
	{"fabric_m2i_buffer_status_debug1_g3                      ", 0x00B3F0C4},
	{"fabric_m2i_buffer_status_debug2_g3                      ", 0x00B3F0C8},
	{"fabric_m2i_buffer_status_debug3_g3                      ", 0x00B3F0CC},
	{"fabric_m2i_buffer_status_debug4_g3                      ", 0x00B3F0D0},
	{"fabric_m2i_buffer_status_debug5_g3                      ", 0x00B3F0D4},
	{"fabric_m2i_buffer_status_debug6_g3                      ", 0x00B3F0D8},
	{"fabric_m2i_buffer_status_debug7_g3                      ", 0x00B3F0DC},
	{"fabric_i2m_buffer_status_debug0_g0                      ", 0x00B3F800},
	{"fabric_i2m_buffer_status_debug1_g0                      ", 0x00B3F804},
	{"fabric_i2m_buffer_status_debug2_g0                      ", 0x00B3F808},
	{"fabric_i2m_buffer_status_debug3_g0                      ", 0x00B3F80C},
	{"fabric_i2m_buffer_status_debug0_g1                      ", 0x00B3F810},
	{"fabric_i2m_buffer_status_debug1_g1                      ", 0x00B3F814},
	{"fabric_i2m_buffer_status_debug2_g1                      ", 0x00B3F818},
	{"fabric_i2m_buffer_status_debug3_g1                      ", 0x00B3F81C},
	{"fabric_i2m_buffer_status_debug0_g2                      ", 0x00B3F820},
	{"fabric_i2m_buffer_status_debug1_g2                      ", 0x00B3F824},
	{"fabric_i2m_buffer_status_debug2_g2                      ", 0x00B3F828},
	{"fabric_i2m_buffer_status_debug3_g2                      ", 0x00B3F82C},
	{"fabric_i2m_buffer_status_debug0_g3                      ", 0x00B3F830},
	{"fabric_i2m_buffer_status_debug1_g3                      ", 0x00B3F834},
	{"fabric_i2m_buffer_status_debug2_g3                      ", 0x00B3F838},
	{"fabric_i2m_buffer_status_debug3_g3                      ", 0x00B3F83C},
	{"fabric_i2m_router_s1_status_debug0                      ", 0x00B3F880},
	{"fabric_i2m_router_s1_status_debug1                      ", 0x00B3F884},
	{"fabric_i2m_router_s1_status_debug2                      ", 0x00B3F888},
	{"fabric_i2m_router_s1_status_debug3                      ", 0x00B3F88C},
	{"fabric_i2m_router_s2_status_debug0_g0                   ", 0x00B3FC80},
	{"fabric_i2m_router_s2_status_debug1_g0                   ", 0x00B3FC84},
	{"fabric_i2m_router_s2_status_debug2_g0                   ", 0x00B3FC88},
	{"fabric_i2m_router_s2_status_debug3_g0                   ", 0x00B3FC8C},
	{"fabric_i2m_router_s2_status_debug0_g1                   ", 0x00B3FC90},
	{"fabric_i2m_router_s2_status_debug1_g1                   ", 0x00B3FC94},
	{"fabric_i2m_router_s2_status_debug2_g1                   ", 0x00B3FC98},
	{"fabric_i2m_router_s2_status_debug3_g1                   ", 0x00B3FC9C},
	{"fabric_i2m_router_s2_status_debug0_g2                   ", 0x00B3FCA0},
	{"fabric_i2m_router_s2_status_debug1_g2                   ", 0x00B3FCA4},
	{"fabric_i2m_router_s2_status_debug2_g2                   ", 0x00B3FCA8},
	{"fabric_i2m_router_s2_status_debug3_g2                   ", 0x00B3FCAC},
	{"fabric_i2m_router_s2_status_debug0_g3                   ", 0x00B3FCB0},
	{"fabric_i2m_router_s2_status_debug1_g3                   ", 0x00B3FCB4},
	{"fabric_i2m_router_s2_status_debug2_g3                   ", 0x00B3FCB8},
	{"fabric_i2m_router_s2_status_debug3_g3                   ", 0x00B3FCBC},
	{"fabric_i2m_axi_slv_s2_status_debug0_c0                  ", 0x00B3FE00},
	{"fabric_i2m_axi_slv_s2_status_debug1_c0                  ", 0x00B3FE04},
	{"fabric_i2m_axi_slv_s2_status_debug0_c1                  ", 0x00B3FE10},
	{"fabric_i2m_axi_slv_s2_status_debug1_c1                  ", 0x00B3FE14},
	{"fabric_i2m_axi_slv_s2_status_debug0_c2                  ", 0x00B3FE20},
	{"fabric_i2m_axi_slv_s2_status_debug1_c2                  ", 0x00B3FE24},
	{"fabric_i2m_axi_slv_s2_status_debug0_c3                  ", 0x00B3FE30},
	{"fabric_i2m_axi_slv_s2_status_debug1_c3                  ", 0x00B3FE34},
	{"fabric_i2m_axi_slv_s2_status_debug0_c4                  ", 0x00B3FE40},
	{"fabric_i2m_axi_slv_s2_status_debug1_c4                  ", 0x00B3FE44},
	{"fabric_i2m_axi_slv_s2_status_debug0_c5                  ", 0x00B3FE50},
	{"fabric_i2m_axi_slv_s2_status_debug1_c5                  ", 0x00B3FE54},
	{"fabric_i2m_axi_slv_s2_status_debug0_c6                  ", 0x00B3FE60},
	{"fabric_i2m_axi_slv_s2_status_debug1_c6                  ", 0x00B3FE64},
	{"fabric_i2m_axi_slv_s2_status_debug0_c7                  ", 0x00B3FE70},
	{"fabric_i2m_axi_slv_s2_status_debug1_c7                  ", 0x00B3FE74},
	{"fabric_i2m_axi_slv_s2_status_debug0_c8                  ", 0x00B3FE80},
	{"fabric_i2m_axi_slv_s2_status_debug1_c8                  ", 0x00B3FE84},
	{"fabric_i2m_axi_slv_s2_status_debug0_c9                  ", 0x00B3FE90},
	{"fabric_i2m_axi_slv_s2_status_debug1_c9                  ", 0x00B3FE94},
	{"fabric_i2m_axi_slv_s2_status_debug0_c10                 ", 0x00B3FEA0},
	{"fabric_i2m_axi_slv_s2_status_debug1_c10                 ", 0x00B3FEA4},
	{"fabric_i2m_axi_slv_s2_status_debug0_c11                 ", 0x00B3FEB0},
	{"fabric_i2m_axi_slv_s2_status_debug1_c11                 ", 0x00B3FEB4},
	{"fabric_i2m_axi_slv_s2_status_debug0_c13                 ", 0x00B3FED0},
	{"fabric_i2m_axi_slv_s2_status_debug1_c13                 ", 0x00B3FED4},
	{"fabric_i2m_axi_slv_s2_status_debug0_c14                 ", 0x00B3FEE0},
	{"fabric_i2m_axi_slv_s2_status_debug1_c14                 ", 0x00B3FEE4},
	{"fabric_i2m_axi_slv_s2_status_debug0_c15                 ", 0x00B3FEF0},
	{"fabric_i2m_axi_slv_s2_status_debug1_c15                 ", 0x00B3FEF4},
	{"fabric_i2m_axi_slv_s2_status_debug0_c18                 ", 0x00B3FF20},
	{"fabric_i2m_axi_slv_s2_status_debug1_c18                 ", 0x00B3FF24},
	{"fec_ul5g_cntrl_reg                                      ", 0x00B40000},
	{"fec_ul5g_i2m_thresh_reg                                 ", 0x00B40004},
	{"fec_ul5g_version_reg                                    ", 0x00B40100},
	{"fec_ul5g_fcw_status_reg                                 ", 0x00B40104},
	{"fec_ul5g_warn_reg                                       ", 0x00B40108},
	{"fec_ul5g_ib_debug_reg                                   ", 0x00B40200},
	{"fec_ul5g_ob_llr_debug_reg                               ", 0x00B40204},
	{"fec_ul5g_ob_harq_debug_reg                              ", 0x00B40208},
	{"fec_ul5g_1__cntrl_reg                                   ", 0x00B41000},
	{"fec_ul5g_1_i2m_thresh_reg                               ", 0x00B41004},
	{"fec_ul5g_1_version_reg                                  ", 0x00B41100},
	{"fec_ul5g_1_fcw_status_reg                               ", 0x00B41104},
	{"fec_ul5g_1_warn_reg                                     ", 0x00B41108},
	{"fec_ul5g_1_ib_debug_reg                                 ", 0x00B41200},
	{"fec_ul5g_1_ob_llr_debug_reg                             ", 0x00B41204},
	{"fec_ul5g_1_ob_harq_debug_reg                            ", 0x00B41208},
	{"fec_ul5g_2_cntrl_reg                                    ", 0x00B42000},
	{"fec_ul5g_2_i2m_thresh_reg                               ", 0x00B42004},
	{"fec_ul5g_2_version_reg                                  ", 0x00B42100},
	{"fec_ul5g_2_fcw_status_reg                               ", 0x00B42104},
	{"fec_ul5g_2_warn_reg                                     ", 0x00B42108},
	{"fec_ul5g_2_ib_debug_reg                                 ", 0x00B42200},
	{"fec_ul5g_2_ob_llr_debug_reg                             ", 0x00B42204},
	{"fec_ul5g_2_ob_harq_debug_reg                            ", 0x00B42208},
	{"fec_ul5g_3_cntrl_reg                                    ", 0x00B43000},
	{"fec_ul5g_3_i2m_thresh_reg                               ", 0x00B43004},
	{"fec_ul5g_3_version_reg                                  ", 0x00B43100},
	{"fec_ul5g_3_fcw_status_reg                               ", 0x00B43104},
	{"fec_ul5g_3_warn_reg                                     ", 0x00B43108},
	{"fec_ul5g_3_ib_debug_reg                                 ", 0x00B43200},
	{"fec_ul5g_3_ob_llr_debug_reg                             ", 0x00B43204},
	{"fec_ul5g_3_ob_harq_debug_reg                            ", 0x00B43208},
	{"fec_ul5g_4_cntrl_reg                                    ", 0x00B44000},
	{"fec_ul5g_4_i2m_thresh_reg                               ", 0x00B44004},
	{"fec_ul5g_4_version_reg                                  ", 0x00B44100},
	{"fec_ul5g_4_fcw_status_reg                               ", 0x00B44104},
	{"fec_ul5g_4_warn_reg                                     ", 0x00B44108},
	{"fec_ul5g_4_ib_debug_reg                                 ", 0x00B44200},
	{"fec_ul5g_4_ob_llr_debug_reg                             ", 0x00B44204},
	{"fec_ul5g_4_ob_harq_debug_reg                            ", 0x00B44208},
	{"fec_ul5g_5_cntrl_reg                                    ", 0x00B45000},
	{"fec_ul5g_5_i2m_thresh_reg                               ", 0x00B45004},
	{"fec_ul5g_5_version_reg                                  ", 0x00B45100},
	{"fec_ul5g_5_fcw_status_reg                               ", 0x00B45104},
	{"fec_ul5g_5_warn_reg                                     ", 0x00B45108},
	{"fec_ul5g_5_ib_debug_reg                                 ", 0x00B45200},
	{"fec_ul5g_5_ob_llr_debug_reg                             ", 0x00B45204},
	{"fec_ul5g_5_ob_harq_debug_reg                            ", 0x00B45208},
	{"fec_ul5g_6_cntrl_reg                                    ", 0x00B46000},
	{"fec_ul5g_6_i2m_thresh_reg                               ", 0x00B46004},
	{"fec_ul5g_6_version_reg                                  ", 0x00B46100},
	{"fec_ul5g_6_fcw_status_reg                               ", 0x00B46104},
	{"fec_ul5g_6_warn_reg                                     ", 0x00B46108},
	{"fec_ul5g_6_ib_debug_reg                                 ", 0x00B46200},
	{"fec_ul5g_6_ob_llr_debug_reg                             ", 0x00B46204},
	{"fec_ul5g_6_ob_harq_debug_reg                            ", 0x00B46208},
	{"fec_ul5g_7_cntrl_reg                                    ", 0x00B47000},
	{"fec_ul5g_7_i2m_thresh_reg                               ", 0x00B47004},
	{"fec_ul5g_7_version_reg                                  ", 0x00B47100},
	{"fec_ul5g_7_fcw_status_reg                               ", 0x00B47104},
	{"fec_ul5g_7_warn_reg                                     ", 0x00B47108},
	{"fec_ul5g_7_ib_debug_reg                                 ", 0x00B47200},
	{"fec_ul5g_7_ob_llr_debug_reg                             ", 0x00B47204},
	{"fec_ul5g_7_ob_harq_debug_reg                            ", 0x00B47208},
	{"fec_ul5g_8_cntrl_reg                                    ", 0x00B48000},
	{"fec_ul5g_8_i2m_thresh_reg                               ", 0x00B48004},
	{"fec_ul5g_8_version_reg                                  ", 0x00B48100},
	{"fec_ul5g_8_fcw_status_reg                               ", 0x00B48104},
	{"fec_ul5g_8_warn_reg                                     ", 0x00B48108},
	{"fec_ul5g_8_ib_debug_reg                                 ", 0x00B48200},
	{"fec_ul5g_8_ob_llr_debug_reg                             ", 0x00B48204},
	{"fec_ul5g_8_ob_harq_debug_reg                            ", 0x00B48208},
	{"fec_dl5g_1_cntrl_reg                                    ", 0x00B4A000},
	{"fec_dl5g_1_version_reg                                  ", 0x00B4A100},
	{"fec_dl5g_1_fcw_status_reg                               ", 0x00B4A104},
	{"fec_dl5g_1_warn_reg                                     ", 0x00B4A108},
	{"fec_dl5g_1_ib_debug_reg                                 ", 0x00B4A200},
	{"fec_dl5g_1_ob_debug_reg                                 ", 0x00B4A204},
	{"fec_dl5g_1_rf_parity_reg                                ", 0x00B4A20C},
	{"fec_dl5g_1_m2i_snoop_reg                                ", 0x00B4A300},
	{"fec_dl5g_1_i2m_snoop_reg                                ", 0x00B4A400},
	{"fec_dl5g_0_cntrl_reg                                    ", 0x00B4B000},
	{"fec_dl5g_0_version_reg                                  ", 0x00B4B100},
	{"fec_dl5g_0_fcw_status_reg                               ", 0x00B4B104},
	{"fec_dl5g_0_warn_reg                                     ", 0x00B4B108},
	{"fec_dl5g_0_ib_debug_reg                                 ", 0x00B4B200},
	{"fec_dl5g_0_ob_debug_reg                                 ", 0x00B4B204},
	{"fec_dl5g_0_rf_parity_reg                                ", 0x00B4B20C},
	{"fec_dl5g_0_m2i_snoop_reg                                ", 0x00B4B300},
	{"fec_dl5g_0_i2m_snoop_reg                                ", 0x00B4B400},
	{"fec_ul_version_reg                                      ", 0x00B50000},
	{"fec_ul_control_reg                                      ", 0x00B50004},
	{"fec_ul_status_reg                                       ", 0x00B50008},
	{"fec_dl_version_reg                                      ", 0x00B57000},
	{"fec_dl_cluster_config_reg                               ", 0x00B57004},
	{"fec_dl_burst_thres                                      ", 0x00B5700C},
	{"fec_dl_cluster_status_reg0                              ", 0x00B57040},
	{"fec_dl_cluster_status_reg1                              ", 0x00B57044},
	{"fec_dl_cluster_status_reg2                              ", 0x00B57048},
	{"fec_dl_cluster_status_reg3                              ", 0x00B5704C},
	{"fec_dl_cluster_status_reg4                              ", 0x00B57050},
	{"fec_dl_cluster_status_reg5                              ", 0x00B57054},
	{"fft_version                                             ", 0x00B58000},
	{"fft_config0                                             ", 0x00B58004},
	{"fft_config1                                             ", 0x00B58008},
	{"fft_ramPageAccess                                       ", 0x00B5800C},
	{"fft_parityMaskBuffer	                                  ", 0x00B5801C},
	{"fft_parityMask_reg0	                                  ", 0x00B58020},
	{"fft_parityMask_reg1	                                  ", 0x00B58024},
	{"fft_parityMask_reg2	                                  ", 0x00B58028},
	{"fft_parityMask_reg3	                                  ", 0x00B5802C},
	{"fft_parityMask_reg4	                                  ", 0x00B58030},
	{"fft_parityMask_reg5	                                  ", 0x00B58034},
	{"fft_parityMask_reg6	                                  ", 0x00B58038},
	{"fft_parityMask_reg7	                                  ", 0x00B5803C},
	{"fft_status_reg0	                                  ", 0x00B58040},
	{"fft_status_reg1	                                  ", 0x00B58044},
	{"fft_status_reg2	                                  ", 0x00B58048},
	{"fft_status_reg3	                                  ", 0x00B5804C},
	{"fft_status_reg4	                                  ", 0x00B58050},
	{"fft_status_reg5	                                  ", 0x00B58054},
	{"fft_status_reg6	                                  ", 0x00B58058},
	{"fft_status_reg7	                                  ", 0x00B5805C},
	{"fft_status_reg8	                                  ", 0x00B58060},
	{"fft_status_reg9	                                  ", 0x00B58064},
	{"fft_status_reg10	                                  ", 0x00B58068},
	{"fft_status_reg11	                                  ", 0x00B5806C},
	{"fft_status_reg12	                                  ", 0x00B58070},
	{"fft_status_reg13	                                  ", 0x00B58074},
	{"fft_status_reg14	                                  ", 0x00B58078},
	{"fft_status_reg15	                                  ", 0x00B5807C},
	{"fft_parityStatus_reg0	                                  ", 0x00B58080},
	{"fft_parityStatus_reg1	                                  ", 0x00B58084},
	{"fft_parityStatus_reg2	                                  ", 0x00B58088},
	{"fft_parityStatus_reg3	                                  ", 0x00B5808C},
	{"fft_parityStatus_reg4	                                  ", 0x00B58090},
	{"fft_parityStatus_reg5	                                  ", 0x00B58094},
	{"fft_parityStatus_reg6	                                  ", 0x00B58098},
	{"fft_parityStatus_reg7	                                  ", 0x00B5809C},
	{"fft_parityStatus_reg8	                                  ", 0x00B580A0},
	{"dma_config0_reg                                         ", 0x00B80000},
	{"dma_config1_reg                                         ", 0x00B80004},
	{"dma_qmgr_addr_reg                                       ", 0x00B80008},
	{"dma_soft_reset_reg                                      ", 0x00B8000C},
	{"dma_axcache_reg                                         ", 0x00B80010},
	{"dma_version_reg                                         ", 0x00B80014},
	{"dma_frame_threshold                                     ", 0x00B80018},
	{"dma_timestamp_lo                                        ", 0x00B8001C},
	{"dma_timestamp_hi                                        ", 0x00B80020},
	{"dma_axi_status                                          ", 0x00B80028},
	{"dma_axi_control                                         ", 0x00B8002C},
	{"dma_no_qmgr                                             ", 0x00B80030},
	{"dma_qos_scale                                           ", 0x00B80034},
	{"dma_qmanen                                              ", 0x00B80040},
	{"dma_qmgr_qos_base                                       ", 0x00B80060},
	{"dma_fec_clk_gating_enable                               ", 0x00B80080},
	{"dma_pm_enable                                           ", 0x00B80084},
	{"dma_qos_enable                                          ", 0x00B80088},
	{"dma_harq_weighted_rr_frame_threshold                    ", 0x00B800B0},
	{"dma_data_small_weighted_rr_frame_thresh                 ", 0x00B800B4},
	{"dma_data_large_weighted_rr_frame_thresh                 ", 0x00B800B8},
	{"dma_inbound_cb_max_size                                 ", 0x00B800BC},
	{"dma_inbound_drain_data_size                             ", 0x00B800C0},
	{"dma_engine_type_small                                   ", 0x00B800C4},
	{"dma_5gdl_ib_thld                                        ", 0x00B800C8},
	{"dma_4gdl_ib_thld                                        ", 0x00B800CC},
	{"dma_fft_ib_thld                                         ", 0x00B800D0},
	{"dma_debug0                                              ", 0x00B80200},
	{"dma_debug1                                              ", 0x00B80204},
	{"dma_debug2                                              ", 0x00B80208},
	{"dma_debug3                                              ", 0x00B8020C},
	{"dma_debug4                                              ", 0x00B80210},
	{"dma_vf_ddr_base_rw                                      ", 0x00B80400},
	{"dma_cmpl_tm_out_cnt                                     ", 0x00B80800},
	{"dma_proc_tm_out_cnt                                     ", 0x00B80804},
	{"dma_status_rresp_bresp                                  ", 0x00B80810},
	{"dma_cfg_rresp_bresp                                     ", 0x00B80814},
	{"dma_status_mem_par_err                                  ", 0x00B80818},
	{"dma_cfg_mem_par_err_en                                  ", 0x00B8081C},
	{"dma_status_dma_hw_err                                   ", 0x00B80820},
	{"dma_cfg_dma_hw_err_en                                   ", 0x00B80824},
	{"dma_status_fec_core_err                                 ", 0x00B80828},
	{"dma_cfg_fec_core_err_en                                 ", 0x00B8082C},
	{"dma_status_fcw_descr_err                                ", 0x00B80830},
	{"dma_cfg_fcw_descr_err_en                                ", 0x00B80834},
	{"dma_status_block_transmit                               ", 0x00B80838},
	{"dma_block_on_err_en                                     ", 0x00B8083C},
	{"dma_status_flush_dma                                    ", 0x00B80840},
	{"dma_flush_dma_on_err_en                                 ", 0x00B80844},
	{"dma_status_sdone_fifo_full                              ", 0x00B80848},
	{"dma_status_descriptor_err_lo_vf                         ", 0x00B8084C},
	{"dma_status_descriptor_err_hi_vf                         ", 0x00B80850},
	{"dma_status_fcw_err_lo_vf                                ", 0x00B80854},
	{"dma_status_fcw_err_hi_vf                                ", 0x00B80858},
	{"dma_status_data_err_lo_vf                               ", 0x00B8085C},
	{"dma_status_data_err_hi_vf                               ", 0x00B80860},
	{"dma_cfg_msi_en_software_err                             ", 0x00B80864},
	{"dma_descriptor_signatuture                              ", 0x00B80868},
	{"dma_fcw_signature                                       ", 0x00B8086C},
	{"dma_error_detection_en                                  ", 0x00B80870},
	{"dma_err_cntrl_fifo_debug                                ", 0x00B8087C},
	{"dma_status_tout_data                                    ", 0x00B80880},
	{"dma_status_tout_desc                                    ", 0x00B80884},
	{"dma_status_tout_unexp_data                              ", 0x00B80888},
	{"dma_status_tout_unexp_desc                              ", 0x00B8088C},
	{"dma_status_tout_process                                 ", 0x00B80890},
	{"dma_config_ctout_out_data_en                            ", 0x00B808A0},
	{"dma_config_ctout_out_descr_en                           ", 0x00B808A4},
	{"dma_config_unexp_compl_data_en                          ", 0x00B808A8},
	{"dma_config_unexp_compl_descr_en                         ", 0x00B808AC},
	{"dma_config_ptout_out_en                                 ", 0x00B808B0},
	{"dma_fec5gul_desc_base_lo_reg_vf                         ", 0x00B88020},
	{"dma_fec5gul_desc_base_hi_reg_vf                         ", 0x00B88024},
	{"dma_fec5gul_resp_ptr_lo_reg_vf                          ", 0x00B88028},
	{"dma_fec5gul_resp_ptr_hi_reg_vf                          ", 0x00B8802C},
	{"dma_fec5gdl_desc_base_lo_reg_vf                         ", 0x00B88040},
	{"dma_fec5gdl_desc_base_hi_reg_vf                         ", 0x00B88044},
	{"dma_fec5gdl_resp_ptr_lo_reg_vf                          ", 0x00B88048},
	{"dma_fec5gdl_resp_ptr_hi_reg_vf                          ", 0x00B8804C},
	{"dma_fec4gul_desc_base_lo_reg_vf                         ", 0x00B88060},
	{"dma_fec4gul_desc_base_hi_reg_vf                         ", 0x00B88064},
	{"dma_fec4gul_resp_ptr_lo_reg_vf                          ", 0x00B88068},
	{"dma_fec4gul_resp_ptr_hi_reg_vf                          ", 0x00B8806C},
	{"dma_fec4gdl_desc_base_lo_reg_vf                         ", 0x00B88080},
	{"dma_fec4gdl_desc_base_hi_reg_vf                         ", 0x00B88084},
	{"dma_fec4gdl_resp_ptr_lo_reg_vf                          ", 0x00B88088},
	{"dma_fec4gdl_resp_ptr_hi_reg_vf                          ", 0x00B8808C},
	{"dma_fft_desc_base_lo_reg_vf                             ", 0x00B880A0},
	{"dma_fft_desc_base_hi_reg_vf                             ", 0x00B880A4},
	{"dma_fft_resp_ptr_lo_reg_vf                              ", 0x00B880A8},
	{"dma_fft_resp_ptr_hi_reg_vf                              ", 0x00B880AC},
	{"permon_a_cntrl_reg_vf                                   ", 0x00B98000},
	{"permon_a_count_vf                                       ", 0x00B98008},
	{"permon_a_k_cnt_lo_vf                                    ", 0x00B98010},
	{"permon_a_k_cnt_hi_vf                                    ", 0x00B98014},
	{"permon_a_delta_cnt_lo_vf                                ", 0x00B98020},
	{"permon_a_delta_cnt_hi_vf                                ", 0x00B98024},
	{"permon_a_version_reg                                    ", 0x00B9C000},
	{"permon_a_cb_control_fec                                 ", 0x00B9C0F0},
	{"permon_a_dlt_timer_lo_fec                               ", 0x00B9C0F4},
	{"permon_a_dlt_timer_hi_fec                               ", 0x00B9C0F8},
	{"permon_a_cb_count_fec                                   ", 0x00B9C100},
	{"permon_a_acc_exec_timer_lo_fec                          ", 0x00B9C104},
	{"permon_a_acc_exec_timer_hi_fec                          ", 0x00B9C108},
	{"permon_a_exec_timer_min_fec                             ", 0x00B9C200},
	{"permon_a_exec_timer_max_fec                             ", 0x00B9C204},
	{"permon_a_control_bus_mon                                ", 0x00B9C400},
	{"permon_a_config_bus_mon                                 ", 0x00B9C404},
	{"permon_a_skip_count_bus_mon                             ", 0x00B9C408},
	{"permon_a_min_lat_bus_mon                                ", 0x00B9C40C},
	{"permon_a_max_lat_bus_mon                                ", 0x00B9C500},
	{"permon_a_total_lat_low_bus_mon                          ", 0x00B9C504},
	{"permon_a_total_lat_upper_bus_mon                        ", 0x00B9C508},
	{"permon_a_total_req_cnt_bus_mon                          ", 0x00B9C50C},
	{"permon_b_cntrl_reg_vf                                   ", 0x00BA8000},
	{"permon_b_count_vf                                       ", 0x00BA8008},
	{"permon_b_k_cnt_lo_vf                                    ", 0x00BA8010},
	{"permon_b_k_cnt_hi_vf                                    ", 0x00BA8014},
	{"permon_b_delta_cnt_lo_vf                                ", 0x00BA8020},
	{"permon_b_delta_cnt_hi_vf                                ", 0x00BA8024},
	{"permon_b_version_reg                                    ", 0x00BAC000},
	{"permon_b_cb_control_fec                                 ", 0x00BAC0F0},
	{"permon_b_dlt_timer_lo_fec                               ", 0x00BAC0F4},
	{"permon_b_dlt_timer_hi_fec                               ", 0x00BAC0F8},
	{"permon_b_cb_count_fec                                   ", 0x00BAC100},
	{"permon_b_acc_exec_timer_lo_fec                          ", 0x00BAC104},
	{"permon_b_acc_exec_timer_hi_fec                          ", 0x00BAC108},
	{"permon_b_exec_timer_min_fec                             ", 0x00BAC200},
	{"permon_b_exec_timer_max_fec                             ", 0x00BAC204},
	{"permon_b_control_bus_mon                                ", 0x00BAC400},
	{"permon_b_config_bus_mon                                 ", 0x00BAC404},
	{"permon_b_skip_count_bus_mon                             ", 0x00BAC408},
	{"permon_b_min_lat_bus_mon                                ", 0x00BAC40C},
	{"permon_b_max_lat_bus_mon                                ", 0x00BAC500},
	{"permon_b_total_lat_low_bus_mon                          ", 0x00BAC504},
	{"permon_b_total_lat_upper_bus_mon                        ", 0x00BAC508},
	{"permon_b_total_req_cnt_bus_mon                          ", 0x00BAC50C},
	{"permon_c_cntrl_reg_vf                                   ", 0x00BB8000},
	{"permon_c_count_vf                                       ", 0x00BB8008},
	{"permon_c_k_cnt_lo_vf                                    ", 0x00BB8010},
	{"permon_c_k_cnt_hi_vf                                    ", 0x00BB8014},
	{"permon_c_delta_cnt_lo_vf                                ", 0x00BB8020},
	{"permon_c_delta_cnt_hi_vf                                ", 0x00BB8024},
	{"permon_c_version_reg                                    ", 0x00BBC000},
	{"permon_c_cb_control_fec                                 ", 0x00BBC0F0},
	{"permon_c_dlt_timer_lo_fec                               ", 0x00BBC0F4},
	{"permon_c_dlt_timer_hi_fec                               ", 0x00BBC0F8},
	{"permon_c_cb_count_fec                                   ", 0x00BBC100},
	{"permon_c_acc_exec_timer_lo_fec                          ", 0x00BBC104},
	{"permon_c_acc_exec_timer_hi_fec                          ", 0x00BBC108},
	{"permon_c_exec_timer_min_fec                             ", 0x00BBC200},
	{"permon_c_exec_timer_max_fec                             ", 0x00BBC204},
	{"permon_c_control_bus_mon                                ", 0x00BBC400},
	{"permon_c_config_bus_mon                                 ", 0x00BBC404},
	{"permon_c_skip_count_bus_mon                             ", 0x00BBC408},
	{"permon_c_min_lat_bus_mon                                ", 0x00BBC40C},
	{"permon_c_max_lat_bus_mon                                ", 0x00BBC500},
	{"permon_c_total_lat_low_bus_mon                          ", 0x00BBC504},
	{"permon_c_total_lat_upper_bus_mon                        ", 0x00BBC508},
	{"permon_c_total_req_cnt_bus_mon                          ", 0x00BBC50C},
	{"hi_vf_to_pf_dbell_vf                                    ", 0x00C80000},
	{"hi_pf_to_vf_dbell_vf                                    ", 0x00C80008},
	{"hi_info_ring_base_lo_vf                                 ", 0x00C80010},
	{"hi_info_ring_base_hi_vf                                 ", 0x00C80014},
	{"hi_info_ring_pointer_vf                                 ", 0x00C80018},
	{"hi_info_ring_int_wr_en_vf                               ", 0x00C80020},
	{"hi_info_ring_pf2_vf_wr_en_vf                            ", 0x00C80024},
	{"hi_msix_vector_mapper_vf                                ", 0x00C80060},
	{"hi_module_version_reg                                   ", 0x00C84000},
	{"hi_iosf2axi_err_log_reg                                 ", 0x00C84004},
	{"hi_hard_reset_reg                                       ", 0x00C84008},
	{"hi_5ghard_reset_reg                                     ", 0x00C8400C},
	{"hi_info_ring_base_lo_reg_pf                             ", 0x00C84018},
	{"hi_info_ring_base_hi_reg_pf                             ", 0x00C84018},
	{"hi_info_ring_pointer_reg_pf                             ", 0x00C8401C},
	{"hi_info_ring_int_wr_en_reg_pf                           ", 0x00C84020},
	{"hi_info_ring_vf2pf_lo_wr_en_reg                         ", 0x00C84024},
	{"hi_info_ring_vf2pf_hi_wr_en_reg                         ", 0x00C84028},
	{"hi_log_parity_err_status_reg                            ", 0x00C8402C},
	{"hi_log_data_parity_error_vf_status_lo                   ", 0x00C84030},
	{"hi_log_data_parity_error_vf_status_hi                   ", 0x00C84034},
	{"hi_block_transmit_on_error_en                           ", 0x00C84038},
	{"hi_cfg_msi_int_wr_en_reg_pf                             ", 0x00C84040},
	{"hi_cfg_msi_vf2pf_lo_wr_en_reg                           ", 0x00C84044},
	{"hi_cfg_msi_vf2pf_high_wr_en_reg                         ", 0x00C84048},
	{"hi_msix_vector_mapper_pf                                ", 0x00C84060},
	{"hi_apb_wr_wait_time                                     ", 0x00C84100},
	{"hi_x_counter_max_value                                  ", 0x00C84104},
	{"hi_pf_mode                                              ", 0x00C84108},
	{"hi_clk_gate_hyst_reg                                    ", 0x00C8410C},
	{"hi_snoop_bits_reg                                       ", 0x00C84110},
	{"hi_msi_drop_enable_reg                                  ", 0x00C84114},
	{"hi_msi_stat_reg                                         ", 0x00C84120},
	{"hi_fifo_ofl_stat_reg                                    ", 0x00C84124},
	{"hi_hi_debug_reg                                         ", 0x00C841F4},
	{"hi_debug_mem_snoop_msi_fifo                             ", 0x00C841F8},
	{"hi_debug_mem_snoop_input_fifo                           ", 0x00C841FC},
	{"hi_msix_mapping_config                                  ", 0x00C84200},
	{"hi_err_inject_reg                                       ", 0x00C84204},
	{"hi_err_status_reg                                       ", 0x00C84208},
	{"hi_err_mask_reg                                         ", 0x00C8420C},
	{"hi_err_fatal_reg                                        ", 0x00C84210},
	{"hi_junk_reg                                             ", 0x00C8FF00},
	{"hi_msix_base_lo_reg_pf                                  ", 0x00D20000},
	{"hi_msix_base_hi_reg_pf                                  ", 0x00D20004},
	{"hi_msix_base_data_reg_pf                                ", 0x00D20008},
	{"hi_msix_base_mask_reg_pf                                ", 0x00D2000c},
	{"hi_msix_pba_base_lo_reg_pf                              ", 0x00E01000},
};

extern int acc100_reg_dump(hw_device *accel_dev, struct acc100_reg_dump_info *rd_db, int num_regs);
extern int acc200_reg_dump(hw_device *accel_dev, struct acc200_reg_dump_info *rd_db, int num_regs);

#endif /* __BB_ACC_REG_DUMP_H__ */

