import * as t from "io-ts";

import { endpoint } from "./endpoint";

export const getAvailResourceAgents = endpoint({
  url: ({ clusterName }: { clusterName: string }) =>
    `/managec/${clusterName}/get_avail_resource_agents`,
  method: "get",
  params: undefined,
  shape: t.record(
    t.string,
    t.intersection([
      t.type({
        full_name: t.string,
        class: t.string,
        provider: t.union([t.string, t.null]),
        type: t.string,
      }),
      t.partial({
        class_provider: t.string,
      }),
    ]),
  ),
});
