#!/usr/bin/env bash

cat <<EOF
<cib crm_feature_set="3.6.1" validate-with="pacemaker-3.5" epoch="11" num_updates="10" admin_epoch="0" cib-last-written="Tue Jan 12 12:20:10 2021" update-origin="node-1" update-client="cibadmin" update-user="root" have-quorum="1" dc-uuid="2">
  <configuration>
    <crm_config>
      <cluster_property_set id="cib-bootstrap-options">
        <nvpair id="cib-bootstrap-options-have-watchdog" name="have-watchdog" value="false"/>
        <nvpair id="cib-bootstrap-options-dc-version" name="dc-version" value="2.0.5-10.fc33-ba59be7122"/>
        <nvpair id="cib-bootstrap-options-cluster-infrastructure" name="cluster-infrastructure" value="corosync"/>
        <nvpair id="cib-bootstrap-options-cluster-name" name="cluster-name" value="ha-exporter"/>
        <nvpair id="cib-bootstrap-options-stonith-enabled" name="stonith-enabled" value="false"/>
        <nvpair id="cib-bootstrap-options-no-quorum-policy" name="no-quorum-policy" value="ignore"/>
      </cluster_property_set>
    </crm_config>
    <nodes>
      <node id="1" uname="node-1"/>
      <node id="2" uname="node-2"/>
    </nodes>
    <resources>
      <primitive id="my_first_svc" class="ocf" type="Dummy" provider="pacemaker">
        <operations>
          <op name="migrate_from" timeout="20s" interval="0s" id="my_first_svc-migrate_from-interval-0s"/>
          <op name="migrate_to" timeout="20s" interval="0s" id="my_first_svc-migrate_to-interval-0s"/>
          <op name="monitor" interval="120s" id="my_first_svc-monitor-interval-120s"/>
          <op name="reload" timeout="20s" interval="0s" id="my_first_svc-reload-interval-0s"/>
          <op name="start" timeout="20s" interval="0s" id="my_first_svc-start-interval-0s"/>
          <op name="stop" timeout="20s" interval="0s" id="my_first_svc-stop-interval-0s"/>
        </operations>
      </primitive>
    </resources>
    <constraints>
      <rsc_location id="test" rsc="test" role="Started" node="node-1" score="1024"/>
    </constraints>
    <rsc_defaults>
      <meta_attributes id="rsc_defaults-meta_attributes">
        <nvpair id="rsc_defaults-meta_attributes-migration-threshold" name="migration-threshold" value="1"/>
      </meta_attributes>
    </rsc_defaults>
  </configuration>
  <status>
    <node_state id="2" uname="node-2" in_ccm="true" crmd="online" crm-debug-origin="do_state_transition" join="member" expected="member">
      <lrm id="2">
        <lrm_resources>
          <lrm_resource id="my_first_svc" type="Dummy" class="ocf" provider="pacemaker">
            <lrm_rsc_op id="my_first_svc_last_0" operation_key="my_first_svc_monitor_0" operation="monitor" crm-debug-origin="build_active_RAs" crm_feature_set="3.6.1" transition-key="2:0:7:3c9e83a4-99a3-4ab2-ac6e-8e21e1a52771" transition-magic="0:7;2:0:7:3c9e83a4-99a3-4ab2-ac6e-8e21e1a52771" exit-reason="" on_node="node-2" call-id="5" rc-code="7" op-status="0" interval="0" last-rc-change="1610453987" last-run="1610453987" exec-time="19" queue-time="0" op-digest="f2317cad3d54cec5d7d7aa7d0bf35cf8" op-force-restart="  envfile op_sleep passwd state  " op-restart-digest="f2317cad3d54cec5d7d7aa7d0bf35cf8" op-secure-params="  passwd  " op-secure-digest="f2317cad3d54cec5d7d7aa7d0bf35cf8"/>
          </lrm_resource>
        </lrm_resources>
      </lrm>
    </node_state>
    <node_state id="1" uname="node-1" in_ccm="true" crmd="online" crm-debug-origin="do_update_resource" join="member" expected="member">
      <lrm id="1">
        <lrm_resources>
          <lrm_resource id="my_first_svc" type="Dummy" class="ocf" provider="pacemaker">
            <lrm_rsc_op id="my_first_svc_last_0" operation_key="my_first_svc_start_0" operation="start" crm-debug-origin="do_update_resource" crm_feature_set="3.6.1" transition-key="1:1:0:3c9e83a4-99a3-4ab2-ac6e-8e21e1a52771" transition-magic="0:0;1:1:0:3c9e83a4-99a3-4ab2-ac6e-8e21e1a52771" exit-reason="" on_node="node-1" call-id="6" rc-code="0" op-status="0" interval="0" last-rc-change="1610454011" last-run="1610454011" exec-time="21" queue-time="0" op-digest="f2317cad3d54cec5d7d7aa7d0bf35cf8" op-force-restart="  envfile op_sleep passwd state  " op-restart-digest="f2317cad3d54cec5d7d7aa7d0bf35cf8" op-secure-params="  passwd  " op-secure-digest="f2317cad3d54cec5d7d7aa7d0bf35cf8"/>
            <lrm_rsc_op id="my_first_svc_monitor_120000" operation_key="my_first_svc_monitor_120000" operation="monitor" crm-debug-origin="do_update_resource" crm_feature_set="3.6.1" transition-key="2:1:0:3c9e83a4-99a3-4ab2-ac6e-8e21e1a52771" transition-magic="0:0;2:1:0:3c9e83a4-99a3-4ab2-ac6e-8e21e1a52771" exit-reason="" on_node="node-1" call-id="7" rc-code="0" op-status="0" interval="120000" last-rc-change="1610454011" exec-time="15" queue-time="0" op-digest="4811cef7f7f94e3a35a70be7916cb2fd" op-secure-params="  passwd  " op-secure-digest="f2317cad3d54cec5d7d7aa7d0bf35cf8"/>
          </lrm_resource>
        </lrm_resources>
      </lrm>
    </node_state>
  </status>
</cib>
EOF
