/*
 * High Availability (HA) Cluster PMDA
 *
 * Copyright (c) 2020 -2021 Red Hat.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#ifndef PMDAHACLUSTER_H
#define PMDAHACLUSTER_H

#include "pacemaker.h"
#include "corosync.h"
#include "sbd.h"
#include "drbd.h"

enum {
	CLUSTER_PACEMAKER_GLOBAL = 0,	/* 0  -- NULL INDOM */
	CLUSTER_PACEMAKER_FAIL,			/* 1  -- PACEMAKER_FAIL_INDOM */
	CLUSTER_PACEMAKER_CONSTRAINTS,	/* 2  -- PACEMAKER_CONSTRAINTS_INDOM */
	CLUSTER_PACEMAKER_NODES,		/* 3  -- PACEMAKER_NODES_IDOM*/
	CLUSTER_PACEMAKER_NODE_ATTRIB,	/* 4  -- PACEMAKER_NODE_ATRRIB_INDOM */
	CLUSTER_PACEMAKER_RESOURCES,	/* 5  -- PACEMAKER_RESOURCES_INDOM */
	CLUSTER_COROSYNC_NODE,			/* 6  -- COROSYNC_NODE_INDOM */
	CLUSTER_COROSYNC_GLOBAL,		/* 7  -- NULL INDOM */
	CLUSTER_COROSYNC_RING,			/* 8  -- COROSYNC_RING INDOM */
	CLUSTER_SBD_DEVICE,				/* 9  -- SBD_DEVICES_INDOM */
	CLUSTER_DRBD_RESOURCE,			/* 10 -- DRBD_RESOURCE_INDOM */
	CLUSTER_DRBD_PEER_DEVICE,		/* 11 -- DRBD_PEER_DEVICE_INDOM */
	NUM_CLUSTERS
};

enum {
	PACEMAKER_FAIL_INDOM = 0,		/* 0 -- Pacemaker failure/migrations */
	PACEMAKER_CONSTRAINTS_INDOM,	/* 1 -- Pacemaker location constraints */
	PACEMAKER_NODES_INDOM,			/* 2 -- Pacemaker nodes data */
	PACEMAKER_NODE_ATTRIB_INDOM,	/* 3 -- Pacemaker node attributes */
	PACEMAKER_RESOURCES_INDOM,		/* 4 -- Pacemaker resources */
	COROSYNC_NODE_INDOM, 			/* 5 -- Corosync available nodes  */
	COROSYNC_RING_INDOM,			/* 6 -- Corosync available rings */
	SBD_DEVICE_INDOM,		 		/* 7 -- SBD available devices */
	DRBD_RESOURCE_INDOM,	 		/* 8 -- DRBD Resources */
	DRBD_PEER_DEVICE_INDOM,	 		/* 9 -- DRBD Peer Devices */
	NUM_INDOMS
};

struct pacemaker_fail {
	struct fail_count fail_count;
};

struct pacemaker_constraints {
	struct location_constraints location_constraints;
};

struct pacemaker_nodes {
	struct nodes nodes;
};

struct pacemaker_node_attrib {
	struct attributes attributes;
};

struct pacemaker_resources {
	struct resources resources;
};

struct corosync_node {
	struct member_votes	member_votes;
};

struct corosync_ring {
	struct rings rings;
};

struct sbd_device {
	struct sbd sbd;
};

struct drbd_resource {
	struct resource resource;
};

struct drbd_peer_device {
	struct peer_device peer_device;
};

extern pmdaMetric metrictable[];
extern int metrictable_size();

#endif /* PMDACLUSTER_H */
