{-
Copyright (C) 2015 John MacFarlane <jgm@berkeley.edu>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

{- |
   Module      : Text.Pandoc.Emoji
   Copyright   : Copyright (C) 2015 John MacFarlane
   License     : GNU GPL, version 2 or above

   Maintainer  : John MacFarlane <jgm@berkeley.edu>
   Stability   : alpha
   Portability : portable

Emoji symbol lookup from canonical string identifier.
-}
module Text.Pandoc.Emoji ( emojis ) where
import qualified Data.Map as M

emojis :: M.Map String String
emojis = M.fromList
  [("+1","\128077")
  ,("-1","\128078")
  ,("100","\128175")
  ,("1234","\128290")
  ,("8ball","\127921")
  ,("a","\127344\65039")
  ,("ab","\127374")
  ,("abc","\128292")
  ,("abcd","\128289")
  ,("accept","\127569")
  ,("aerial_tramway","\128673")
  ,("airplane","\9992\65039")
  ,("alarm_clock","\9200")
  ,("alien","\128125")
  ,("ambulance","\128657")
  ,("anchor","\9875")
  ,("angel","\128124")
  ,("anger","\128162")
  ,("angry","\128544")
  ,("anguished","\128551")
  ,("ant","\128028")
  ,("apple","\127822")
  ,("aquarius","\9810")
  ,("aries","\9800")
  ,("arrow_backward","\9664\65039")
  ,("arrow_double_down","\9196")
  ,("arrow_double_up","\9195")
  ,("arrow_down","\11015\65039")
  ,("arrow_down_small","\128317")
  ,("arrow_forward","\9654\65039")
  ,("arrow_heading_down","\10549\65039")
  ,("arrow_heading_up","\10548\65039")
  ,("arrow_left","\11013\65039")
  ,("arrow_lower_left","\8601\65039")
  ,("arrow_lower_right","\8600\65039")
  ,("arrow_right","\10145\65039")
  ,("arrow_right_hook","\8618\65039")
  ,("arrow_up","\11014\65039")
  ,("arrow_up_down","\8597\65039")
  ,("arrow_up_small","\128316")
  ,("arrow_upper_left","\8598\65039")
  ,("arrow_upper_right","\8599\65039")
  ,("arrows_clockwise","\128259")
  ,("arrows_counterclockwise","\128260")
  ,("art","\127912")
  ,("articulated_lorry","\128667")
  ,("astonished","\128562")
  ,("athletic_shoe","\128095")
  ,("atm","\127975")
  ,("b","\127345\65039")
  ,("baby","\128118")
  ,("baby_bottle","\127868")
  ,("baby_chick","\128036")
  ,("baby_symbol","\128700")
  ,("back","\128281")
  ,("baggage_claim","\128708")
  ,("balloon","\127880")
  ,("ballot_box_with_check","\9745\65039")
  ,("bamboo","\127885")
  ,("banana","\127820")
  ,("bangbang","\8252\65039")
  ,("bank","\127974")
  ,("bar_chart","\128202")
  ,("barber","\128136")
  ,("baseball","\9918\65039")
  ,("basketball","\127936")
  ,("bath","\128704")
  ,("bathtub","\128705")
  ,("battery","\128267")
  ,("bear","\128059")
  ,("bee","\128029")
  ,("beer","\127866")
  ,("beers","\127867")
  ,("beetle","\128030")
  ,("beginner","\128304")
  ,("bell","\128276")
  ,("bento","\127857")
  ,("bicyclist","\128692")
  ,("bike","\128690")
  ,("bikini","\128089")
  ,("bird","\128038")
  ,("birthday","\127874")
  ,("black_circle","\9899")
  ,("black_joker","\127183")
  ,("black_large_square","\11035")
  ,("black_medium_small_square","\9726")
  ,("black_medium_square","\9724\65039")
  ,("black_nib","\10002\65039")
  ,("black_small_square","\9642\65039")
  ,("black_square_button","\128306")
  ,("blossom","\127804")
  ,("blowfish","\128033")
  ,("blue_book","\128216")
  ,("blue_car","\128665")
  ,("blue_heart","\128153")
  ,("blush","\128522")
  ,("boar","\128023")
  ,("boat","\9973")
  ,("bomb","\128163")
  ,("book","\128214")
  ,("bookmark","\128278")
  ,("bookmark_tabs","\128209")
  ,("books","\128218")
  ,("boom","\128165")
  ,("boot","\128098")
  ,("bouquet","\128144")
  ,("bow","\128583")
  ,("bowling","\127923")
  ,("boy","\128102")
  ,("bread","\127838")
  ,("bride_with_veil","\128112")
  ,("bridge_at_night","\127753")
  ,("briefcase","\128188")
  ,("broken_heart","\128148")
  ,("bug","\128027")
  ,("bulb","\128161")
  ,("bullettrain_front","\128645")
  ,("bullettrain_side","\128644")
  ,("bus","\128652")
  ,("busstop","\128655")
  ,("bust_in_silhouette","\128100")
  ,("busts_in_silhouette","\128101")
  ,("cactus","\127797")
  ,("cake","\127856")
  ,("calendar","\128198")
  ,("calling","\128242")
  ,("camel","\128043")
  ,("camera","\128247")
  ,("cancer","\9803")
  ,("candy","\127852")
  ,("capital_abcd","\128288")
  ,("capricorn","\9809")
  ,("car","\128663")
  ,("card_index","\128199")
  ,("carousel_horse","\127904")
  ,("cat","\128049")
  ,("cat2","\128008")
  ,("cd","\128191")
  ,("chart","\128185")
  ,("chart_with_downwards_trend","\128201")
  ,("chart_with_upwards_trend","\128200")
  ,("checkered_flag","\127937")
  ,("cherries","\127826")
  ,("cherry_blossom","\127800")
  ,("chestnut","\127792")
  ,("chicken","\128020")
  ,("children_crossing","\128696")
  ,("chocolate_bar","\127851")
  ,("christmas_tree","\127876")
  ,("church","\9962")
  ,("cinema","\127910")
  ,("circus_tent","\127914")
  ,("city_sunrise","\127751")
  ,("city_sunset","\127750")
  ,("cl","\127377")
  ,("clap","\128079")
  ,("clapper","\127916")
  ,("clipboard","\128203")
  ,("clock1","\128336")
  ,("clock10","\128345")
  ,("clock1030","\128357")
  ,("clock11","\128346")
  ,("clock1130","\128358")
  ,("clock12","\128347")
  ,("clock1230","\128359")
  ,("clock130","\128348")
  ,("clock2","\128337")
  ,("clock230","\128349")
  ,("clock3","\128338")
  ,("clock330","\128350")
  ,("clock4","\128339")
  ,("clock430","\128351")
  ,("clock5","\128340")
  ,("clock530","\128352")
  ,("clock6","\128341")
  ,("clock630","\128353")
  ,("clock7","\128342")
  ,("clock730","\128354")
  ,("clock8","\128343")
  ,("clock830","\128355")
  ,("clock9","\128344")
  ,("clock930","\128356")
  ,("closed_book","\128213")
  ,("closed_lock_with_key","\128272")
  ,("closed_umbrella","\127746")
  ,("cloud","\9729\65039")
  ,("clubs","\9827\65039")
  ,("cn","\127464\127475")
  ,("cocktail","\127864")
  ,("coffee","\9749")
  ,("cold_sweat","\128560")
  ,("collision","\128165")
  ,("computer","\128187")
  ,("confetti_ball","\127882")
  ,("confounded","\128534")
  ,("confused","\128533")
  ,("congratulations","\12951\65039")
  ,("construction","\128679")
  ,("construction_worker","\128119")
  ,("convenience_store","\127978")
  ,("cookie","\127850")
  ,("cool","\127378")
  ,("cop","\128110")
  ,("copyright","\169\65039")
  ,("corn","\127805")
  ,("couple","\128107")
  ,("couple_with_heart","\128145")
  ,("couplekiss","\128143")
  ,("cow","\128046")
  ,("cow2","\128004")
  ,("credit_card","\128179")
  ,("crescent_moon","\127769")
  ,("crocodile","\128010")
  ,("crossed_flags","\127884")
  ,("crown","\128081")
  ,("cry","\128546")
  ,("crying_cat_face","\128575")
  ,("crystal_ball","\128302")
  ,("cupid","\128152")
  ,("curly_loop","\10160")
  ,("currency_exchange","\128177")
  ,("curry","\127835")
  ,("custard","\127854")
  ,("customs","\128707")
  ,("cyclone","\127744")
  ,("dancer","\128131")
  ,("dancers","\128111")
  ,("dango","\127841")
  ,("dart","\127919")
  ,("dash","\128168")
  ,("date","\128197")
  ,("de","\127465\127466")
  ,("deciduous_tree","\127795")
  ,("department_store","\127980")
  ,("diamond_shape_with_a_dot_inside","\128160")
  ,("diamonds","\9830\65039")
  ,("disappointed","\128542")
  ,("disappointed_relieved","\128549")
  ,("dizzy","\128171")
  ,("dizzy_face","\128565")
  ,("do_not_litter","\128687")
  ,("dog","\128054")
  ,("dog2","\128021")
  ,("dollar","\128181")
  ,("dolls","\127886")
  ,("dolphin","\128044")
  ,("door","\128682")
  ,("doughnut","\127849")
  ,("dragon","\128009")
  ,("dragon_face","\128050")
  ,("dress","\128087")
  ,("dromedary_camel","\128042")
  ,("droplet","\128167")
  ,("dvd","\128192")
  ,("e-mail","\128231")
  ,("ear","\128066")
  ,("ear_of_rice","\127806")
  ,("earth_africa","\127757")
  ,("earth_americas","\127758")
  ,("earth_asia","\127759")
  ,("egg","\127859")
  ,("eggplant","\127814")
  ,("eight","8\65039\8419")
  ,("eight_pointed_black_star","\10036\65039")
  ,("eight_spoked_asterisk","\10035\65039")
  ,("electric_plug","\128268")
  ,("elephant","\128024")
  ,("email","\9993\65039")
  ,("end","\128282")
  ,("envelope","\9993\65039")
  ,("envelope_with_arrow","\128233")
  ,("es","\127466\127480")
  ,("euro","\128182")
  ,("european_castle","\127984")
  ,("european_post_office","\127972")
  ,("evergreen_tree","\127794")
  ,("exclamation","\10071")
  ,("expressionless","\128529")
  ,("eyeglasses","\128083")
  ,("eyes","\128064")
  ,("facepunch","\128074")
  ,("factory","\127981")
  ,("fallen_leaf","\127810")
  ,("family","\128106")
  ,("fast_forward","\9193")
  ,("fax","\128224")
  ,("fearful","\128552")
  ,("feet","\128062")
  ,("ferris_wheel","\127905")
  ,("file_folder","\128193")
  ,("fire","\128293")
  ,("fire_engine","\128658")
  ,("fireworks","\127878")
  ,("first_quarter_moon","\127763")
  ,("first_quarter_moon_with_face","\127771")
  ,("fish","\128031")
  ,("fish_cake","\127845")
  ,("fishing_pole_and_fish","\127907")
  ,("fist","\9994")
  ,("five","5\65039\8419")
  ,("flags","\127887")
  ,("flashlight","\128294")
  ,("flipper","\128044")
  ,("floppy_disk","\128190")
  ,("flower_playing_cards","\127924")
  ,("flushed","\128563")
  ,("foggy","\127745")
  ,("football","\127944")
  ,("footprints","\128099")
  ,("fork_and_knife","\127860")
  ,("fountain","\9970")
  ,("four","4\65039\8419")
  ,("four_leaf_clover","\127808")
  ,("fr","\127467\127479")
  ,("free","\127379")
  ,("fried_shrimp","\127844")
  ,("fries","\127839")
  ,("frog","\128056")
  ,("frowning","\128550")
  ,("fuelpump","\9981")
  ,("full_moon","\127765")
  ,("full_moon_with_face","\127773")
  ,("game_die","\127922")
  ,("gb","\127468\127463")
  ,("gem","\128142")
  ,("gemini","\9802")
  ,("ghost","\128123")
  ,("gift","\127873")
  ,("gift_heart","\128157")
  ,("girl","\128103")
  ,("globe_with_meridians","\127760")
  ,("goat","\128016")
  ,("golf","\9971")
  ,("grapes","\127815")
  ,("green_apple","\127823")
  ,("green_book","\128215")
  ,("green_heart","\128154")
  ,("grey_exclamation","\10069")
  ,("grey_question","\10068")
  ,("grimacing","\128556")
  ,("grin","\128513")
  ,("grinning","\128512")
  ,("guardsman","\128130")
  ,("guitar","\127928")
  ,("gun","\128299")
  ,("haircut","\128135")
  ,("hamburger","\127828")
  ,("hammer","\128296")
  ,("hamster","\128057")
  ,("hand","\9995")
  ,("handbag","\128092")
  ,("hankey","\128169")
  ,("hash","#\65039\8419")
  ,("hatched_chick","\128037")
  ,("hatching_chick","\128035")
  ,("headphones","\127911")
  ,("hear_no_evil","\128585")
  ,("heart","\10084\65039")
  ,("heart_decoration","\128159")
  ,("heart_eyes","\128525")
  ,("heart_eyes_cat","\128571")
  ,("heartbeat","\128147")
  ,("heartpulse","\128151")
  ,("hearts","\9829\65039")
  ,("heavy_check_mark","\10004\65039")
  ,("heavy_division_sign","\10135")
  ,("heavy_dollar_sign","\128178")
  ,("heavy_exclamation_mark","\10071")
  ,("heavy_minus_sign","\10134")
  ,("heavy_multiplication_x","\10006\65039")
  ,("heavy_plus_sign","\10133")
  ,("helicopter","\128641")
  ,("herb","\127807")
  ,("hibiscus","\127802")
  ,("high_brightness","\128262")
  ,("high_heel","\128096")
  ,("hocho","\128298")
  ,("honey_pot","\127855")
  ,("honeybee","\128029")
  ,("horse","\128052")
  ,("horse_racing","\127943")
  ,("hospital","\127973")
  ,("hotel","\127976")
  ,("hotsprings","\9832\65039")
  ,("hourglass","\8987")
  ,("hourglass_flowing_sand","\9203")
  ,("house","\127968")
  ,("house_with_garden","\127969")
  ,("hushed","\128559")
  ,("ice_cream","\127848")
  ,("icecream","\127846")
  ,("id","\127380")
  ,("ideograph_advantage","\127568")
  ,("imp","\128127")
  ,("inbox_tray","\128229")
  ,("incoming_envelope","\128232")
  ,("information_desk_person","\128129")
  ,("information_source","\8505\65039")
  ,("innocent","\128519")
  ,("interrobang","\8265\65039")
  ,("iphone","\128241")
  ,("it","\127470\127481")
  ,("izakaya_lantern","\127982")
  ,("jack_o_lantern","\127875")
  ,("japan","\128510")
  ,("japanese_castle","\127983")
  ,("japanese_goblin","\128122")
  ,("japanese_ogre","\128121")
  ,("jeans","\128086")
  ,("joy","\128514")
  ,("joy_cat","\128569")
  ,("jp","\127471\127477")
  ,("key","\128273")
  ,("keycap_ten","\128287")
  ,("kimono","\128088")
  ,("kiss","\128139")
  ,("kissing","\128535")
  ,("kissing_cat","\128573")
  ,("kissing_closed_eyes","\128538")
  ,("kissing_heart","\128536")
  ,("kissing_smiling_eyes","\128537")
  ,("knife","\128298")
  ,("koala","\128040")
  ,("koko","\127489")
  ,("kr","\127472\127479")
  ,("lantern","\127982")
  ,("large_blue_circle","\128309")
  ,("large_blue_diamond","\128311")
  ,("large_orange_diamond","\128310")
  ,("last_quarter_moon","\127767")
  ,("last_quarter_moon_with_face","\127772")
  ,("laughing","\128518")
  ,("leaves","\127811")
  ,("ledger","\128210")
  ,("left_luggage","\128709")
  ,("left_right_arrow","\8596\65039")
  ,("leftwards_arrow_with_hook","\8617\65039")
  ,("lemon","\127819")
  ,("leo","\9804")
  ,("leopard","\128006")
  ,("libra","\9806")
  ,("light_rail","\128648")
  ,("link","\128279")
  ,("lips","\128068")
  ,("lipstick","\128132")
  ,("lock","\128274")
  ,("lock_with_ink_pen","\128271")
  ,("lollipop","\127853")
  ,("loop","\10175")
  ,("loud_sound","\128266")
  ,("loudspeaker","\128226")
  ,("love_hotel","\127977")
  ,("love_letter","\128140")
  ,("low_brightness","\128261")
  ,("m","\9410\65039")
  ,("mag","\128269")
  ,("mag_right","\128270")
  ,("mahjong","\126980")
  ,("mailbox","\128235")
  ,("mailbox_closed","\128234")
  ,("mailbox_with_mail","\128236")
  ,("mailbox_with_no_mail","\128237")
  ,("man","\128104")
  ,("man_with_gua_pi_mao","\128114")
  ,("man_with_turban","\128115")
  ,("mans_shoe","\128094")
  ,("maple_leaf","\127809")
  ,("mask","\128567")
  ,("massage","\128134")
  ,("meat_on_bone","\127830")
  ,("mega","\128227")
  ,("melon","\127816")
  ,("memo","\128221")
  ,("mens","\128697")
  ,("metro","\128647")
  ,("microphone","\127908")
  ,("microscope","\128300")
  ,("milky_way","\127756")
  ,("minibus","\128656")
  ,("minidisc","\128189")
  ,("mobile_phone_off","\128244")
  ,("money_with_wings","\128184")
  ,("moneybag","\128176")
  ,("monkey","\128018")
  ,("monkey_face","\128053")
  ,("monorail","\128669")
  ,("moon","\127764")
  ,("mortar_board","\127891")
  ,("mount_fuji","\128507")
  ,("mountain_bicyclist","\128693")
  ,("mountain_cableway","\128672")
  ,("mountain_railway","\128670")
  ,("mouse","\128045")
  ,("mouse2","\128001")
  ,("movie_camera","\127909")
  ,("moyai","\128511")
  ,("muscle","\128170")
  ,("mushroom","\127812")
  ,("musical_keyboard","\127929")
  ,("musical_note","\127925")
  ,("musical_score","\127932")
  ,("mute","\128263")
  ,("nail_care","\128133")
  ,("name_badge","\128219")
  ,("necktie","\128084")
  ,("negative_squared_cross_mark","\10062")
  ,("neutral_face","\128528")
  ,("new","\127381")
  ,("new_moon","\127761")
  ,("new_moon_with_face","\127770")
  ,("newspaper","\128240")
  ,("ng","\127382")
  ,("night_with_stars","\127747")
  ,("nine","9\65039\8419")
  ,("no_bell","\128277")
  ,("no_bicycles","\128691")
  ,("no_entry","\9940")
  ,("no_entry_sign","\128683")
  ,("no_good","\128581")
  ,("no_mobile_phones","\128245")
  ,("no_mouth","\128566")
  ,("no_pedestrians","\128695")
  ,("no_smoking","\128685")
  ,("non-potable_water","\128689")
  ,("nose","\128067")
  ,("notebook","\128211")
  ,("notebook_with_decorative_cover","\128212")
  ,("notes","\127926")
  ,("nut_and_bolt","\128297")
  ,("o","\11093")
  ,("o2","\127358\65039")
  ,("ocean","\127754")
  ,("octopus","\128025")
  ,("oden","\127842")
  ,("office","\127970")
  ,("ok","\127383")
  ,("ok_hand","\128076")
  ,("ok_woman","\128582")
  ,("older_man","\128116")
  ,("older_woman","\128117")
  ,("on","\128283")
  ,("oncoming_automobile","\128664")
  ,("oncoming_bus","\128653")
  ,("oncoming_police_car","\128660")
  ,("oncoming_taxi","\128662")
  ,("one","1\65039\8419")
  ,("open_book","\128214")
  ,("open_file_folder","\128194")
  ,("open_hands","\128080")
  ,("open_mouth","\128558")
  ,("ophiuchus","\9934")
  ,("orange_book","\128217")
  ,("outbox_tray","\128228")
  ,("ox","\128002")
  ,("package","\128230")
  ,("page_facing_up","\128196")
  ,("page_with_curl","\128195")
  ,("pager","\128223")
  ,("palm_tree","\127796")
  ,("panda_face","\128060")
  ,("paperclip","\128206")
  ,("parking","\127359\65039")
  ,("part_alternation_mark","\12349\65039")
  ,("partly_sunny","\9925")
  ,("passport_control","\128706")
  ,("paw_prints","\128062")
  ,("peach","\127825")
  ,("pear","\127824")
  ,("pencil","\128221")
  ,("pencil2","\9999\65039")
  ,("penguin","\128039")
  ,("pensive","\128532")
  ,("performing_arts","\127917")
  ,("persevere","\128547")
  ,("person_frowning","\128589")
  ,("person_with_blond_hair","\128113")
  ,("person_with_pouting_face","\128590")
  ,("phone","\9742\65039")
  ,("pig","\128055")
  ,("pig2","\128022")
  ,("pig_nose","\128061")
  ,("pill","\128138")
  ,("pineapple","\127821")
  ,("pisces","\9811")
  ,("pizza","\127829")
  ,("point_down","\128071")
  ,("point_left","\128072")
  ,("point_right","\128073")
  ,("point_up","\9757\65039")
  ,("point_up_2","\128070")
  ,("police_car","\128659")
  ,("poodle","\128041")
  ,("poop","\128169")
  ,("post_office","\127971")
  ,("postal_horn","\128239")
  ,("postbox","\128238")
  ,("potable_water","\128688")
  ,("pouch","\128093")
  ,("poultry_leg","\127831")
  ,("pound","\128183")
  ,("pouting_cat","\128574")
  ,("pray","\128591")
  ,("princess","\128120")
  ,("punch","\128074")
  ,("purple_heart","\128156")
  ,("purse","\128091")
  ,("pushpin","\128204")
  ,("put_litter_in_its_place","\128686")
  ,("question","\10067")
  ,("rabbit","\128048")
  ,("rabbit2","\128007")
  ,("racehorse","\128014")
  ,("radio","\128251")
  ,("radio_button","\128280")
  ,("rage","\128545")
  ,("railway_car","\128643")
  ,("rainbow","\127752")
  ,("raised_hand","\9995")
  ,("raised_hands","\128588")
  ,("raising_hand","\128587")
  ,("ram","\128015")
  ,("ramen","\127836")
  ,("rat","\128000")
  ,("recycle","\9851\65039")
  ,("red_car","\128663")
  ,("red_circle","\128308")
  ,("registered","\174\65039")
  ,("relaxed","\9786\65039")
  ,("relieved","\128524")
  ,("repeat","\128257")
  ,("repeat_one","\128258")
  ,("restroom","\128699")
  ,("revolving_hearts","\128158")
  ,("rewind","\9194")
  ,("ribbon","\127872")
  ,("rice","\127834")
  ,("rice_ball","\127833")
  ,("rice_cracker","\127832")
  ,("rice_scene","\127889")
  ,("ring","\128141")
  ,("rocket","\128640")
  ,("roller_coaster","\127906")
  ,("rooster","\128019")
  ,("rose","\127801")
  ,("rotating_light","\128680")
  ,("round_pushpin","\128205")
  ,("rowboat","\128675")
  ,("ru","\127479\127482")
  ,("rugby_football","\127945")
  ,("runner","\127939")
  ,("running","\127939")
  ,("running_shirt_with_sash","\127933")
  ,("sa","\127490\65039")
  ,("sagittarius","\9808")
  ,("sailboat","\9973")
  ,("sake","\127862")
  ,("sandal","\128097")
  ,("santa","\127877")
  ,("satellite","\128225")
  ,("satisfied","\128518")
  ,("saxophone","\127927")
  ,("school","\127979")
  ,("school_satchel","\127890")
  ,("scissors","\9986\65039")
  ,("scorpius","\9807")
  ,("scream","\128561")
  ,("scream_cat","\128576")
  ,("scroll","\128220")
  ,("seat","\128186")
  ,("secret","\12953\65039")
  ,("see_no_evil","\128584")
  ,("seedling","\127793")
  ,("seven","7\65039\8419")
  ,("shaved_ice","\127847")
  ,("sheep","\128017")
  ,("shell","\128026")
  ,("ship","\128674")
  ,("shirt","\128085")
  ,("shit","\128169")
  ,("shoe","\128094")
  ,("shower","\128703")
  ,("signal_strength","\128246")
  ,("six","6\65039\8419")
  ,("six_pointed_star","\128303")
  ,("ski","\127935")
  ,("skull","\128128")
  ,("sleeping","\128564")
  ,("sleepy","\128554")
  ,("slot_machine","\127920")
  ,("small_blue_diamond","\128313")
  ,("small_orange_diamond","\128312")
  ,("small_red_triangle","\128314")
  ,("small_red_triangle_down","\128315")
  ,("smile","\128516")
  ,("smile_cat","\128568")
  ,("smiley","\128515")
  ,("smiley_cat","\128570")
  ,("smiling_imp","\128520")
  ,("smirk","\128527")
  ,("smirk_cat","\128572")
  ,("smoking","\128684")
  ,("snail","\128012")
  ,("snake","\128013")
  ,("snowboarder","\127938")
  ,("snowflake","\10052\65039")
  ,("snowman","\9924")
  ,("sob","\128557")
  ,("soccer","\9917")
  ,("soon","\128284")
  ,("sos","\127384")
  ,("sound","\128265")
  ,("space_invader","\128126")
  ,("spades","\9824\65039")
  ,("spaghetti","\127837")
  ,("sparkle","\10055\65039")
  ,("sparkler","\127879")
  ,("sparkles","\10024")
  ,("sparkling_heart","\128150")
  ,("speak_no_evil","\128586")
  ,("speaker","\128264")
  ,("speech_balloon","\128172")
  ,("speedboat","\128676")
  ,("star","\11088")
  ,("star2","\127775")
  ,("stars","\127776")
  ,("station","\128649")
  ,("statue_of_liberty","\128509")
  ,("steam_locomotive","\128642")
  ,("stew","\127858")
  ,("straight_ruler","\128207")
  ,("strawberry","\127827")
  ,("stuck_out_tongue","\128539")
  ,("stuck_out_tongue_closed_eyes","\128541")
  ,("stuck_out_tongue_winking_eye","\128540")
  ,("sun_with_face","\127774")
  ,("sunflower","\127803")
  ,("sunglasses","\128526")
  ,("sunny","\9728\65039")
  ,("sunrise","\127749")
  ,("sunrise_over_mountains","\127748")
  ,("surfer","\127940")
  ,("sushi","\127843")
  ,("suspension_railway","\128671")
  ,("sweat","\128531")
  ,("sweat_drops","\128166")
  ,("sweat_smile","\128517")
  ,("sweet_potato","\127840")
  ,("swimmer","\127946")
  ,("symbols","\128291")
  ,("syringe","\128137")
  ,("tada","\127881")
  ,("tanabata_tree","\127883")
  ,("tangerine","\127818")
  ,("taurus","\9801")
  ,("taxi","\128661")
  ,("tea","\127861")
  ,("telephone","\9742\65039")
  ,("telephone_receiver","\128222")
  ,("telescope","\128301")
  ,("tennis","\127934")
  ,("tent","\9978")
  ,("thought_balloon","\128173")
  ,("three","3\65039\8419")
  ,("thumbsdown","\128078")
  ,("thumbsup","\128077")
  ,("ticket","\127915")
  ,("tiger","\128047")
  ,("tiger2","\128005")
  ,("tired_face","\128555")
  ,("tm","\8482\65039")
  ,("toilet","\128701")
  ,("tokyo_tower","\128508")
  ,("tomato","\127813")
  ,("tongue","\128069")
  ,("top","\128285")
  ,("tophat","\127913")
  ,("tractor","\128668")
  ,("traffic_light","\128677")
  ,("train","\128651")
  ,("train2","\128646")
  ,("tram","\128650")
  ,("triangular_flag_on_post","\128681")
  ,("triangular_ruler","\128208")
  ,("trident","\128305")
  ,("triumph","\128548")
  ,("trolleybus","\128654")
  ,("trophy","\127942")
  ,("tropical_drink","\127865")
  ,("tropical_fish","\128032")
  ,("truck","\128666")
  ,("trumpet","\127930")
  ,("tshirt","\128085")
  ,("tulip","\127799")
  ,("turtle","\128034")
  ,("tv","\128250")
  ,("twisted_rightwards_arrows","\128256")
  ,("two","2\65039\8419")
  ,("two_hearts","\128149")
  ,("two_men_holding_hands","\128108")
  ,("two_women_holding_hands","\128109")
  ,("u5272","\127545")
  ,("u5408","\127540")
  ,("u55b6","\127546")
  ,("u6307","\127535")
  ,("u6708","\127543\65039")
  ,("u6709","\127542")
  ,("u6e80","\127541")
  ,("u7121","\127514")
  ,("u7533","\127544")
  ,("u7981","\127538")
  ,("u7a7a","\127539")
  ,("uk","\127468\127463")
  ,("umbrella","\9748")
  ,("unamused","\128530")
  ,("underage","\128286")
  ,("unlock","\128275")
  ,("up","\127385")
  ,("us","\127482\127480")
  ,("v","\9996\65039")
  ,("vertical_traffic_light","\128678")
  ,("vhs","\128252")
  ,("vibration_mode","\128243")
  ,("video_camera","\128249")
  ,("video_game","\127918")
  ,("violin","\127931")
  ,("virgo","\9805")
  ,("volcano","\127755")
  ,("vs","\127386")
  ,("walking","\128694")
  ,("waning_crescent_moon","\127768")
  ,("waning_gibbous_moon","\127766")
  ,("warning","\9888\65039")
  ,("watch","\8986")
  ,("water_buffalo","\128003")
  ,("watermelon","\127817")
  ,("wave","\128075")
  ,("wavy_dash","\12336\65039")
  ,("waxing_crescent_moon","\127762")
  ,("waxing_gibbous_moon","\127764")
  ,("wc","\128702")
  ,("weary","\128553")
  ,("wedding","\128146")
  ,("whale","\128051")
  ,("whale2","\128011")
  ,("wheelchair","\9855")
  ,("white_check_mark","\9989")
  ,("white_circle","\9898")
  ,("white_flower","\128174")
  ,("white_large_square","\11036")
  ,("white_medium_small_square","\9725")
  ,("white_medium_square","\9723\65039")
  ,("white_small_square","\9643\65039")
  ,("white_square_button","\128307")
  ,("wind_chime","\127888")
  ,("wine_glass","\127863")
  ,("wink","\128521")
  ,("wolf","\128058")
  ,("woman","\128105")
  ,("womans_clothes","\128090")
  ,("womans_hat","\128082")
  ,("womens","\128698")
  ,("worried","\128543")
  ,("wrench","\128295")
  ,("x","\10060")
  ,("yellow_heart","\128155")
  ,("yen","\128180")
  ,("yum","\128523")
  ,("zap","\9889")
  ,("zero","0\65039\8419")
  ,("zzz","\128164")
  ]
