// Package v2 provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen version v1.8.2 DO NOT EDIT.
package v2

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

const (
	BearerScopes = "Bearer.Scopes"
)

// Defines values for ComposeStatusValue.
const (
	ComposeStatusValueFailure ComposeStatusValue = "failure"

	ComposeStatusValuePending ComposeStatusValue = "pending"

	ComposeStatusValueSuccess ComposeStatusValue = "success"
)

// Defines values for ImageStatusValue.
const (
	ImageStatusValueBuilding ImageStatusValue = "building"

	ImageStatusValueFailure ImageStatusValue = "failure"

	ImageStatusValuePending ImageStatusValue = "pending"

	ImageStatusValueRegistering ImageStatusValue = "registering"

	ImageStatusValueSuccess ImageStatusValue = "success"

	ImageStatusValueUploading ImageStatusValue = "uploading"
)

// Defines values for ImageTypes.
const (
	ImageTypesAws ImageTypes = "aws"

	ImageTypesAwsHaRhui ImageTypes = "aws-ha-rhui"

	ImageTypesAwsRhui ImageTypes = "aws-rhui"

	ImageTypesAwsSapRhui ImageTypes = "aws-sap-rhui"

	ImageTypesAzure ImageTypes = "azure"

	ImageTypesAzureRhui ImageTypes = "azure-rhui"

	ImageTypesAzureSapRhui ImageTypes = "azure-sap-rhui"

	ImageTypesEdgeCommit ImageTypes = "edge-commit"

	ImageTypesEdgeContainer ImageTypes = "edge-container"

	ImageTypesEdgeInstaller ImageTypes = "edge-installer"

	ImageTypesGcp ImageTypes = "gcp"

	ImageTypesGcpRhui ImageTypes = "gcp-rhui"

	ImageTypesGuestImage ImageTypes = "guest-image"

	ImageTypesImageInstaller ImageTypes = "image-installer"

	ImageTypesIotCommit ImageTypes = "iot-commit"

	ImageTypesIotContainer ImageTypes = "iot-container"

	ImageTypesIotInstaller ImageTypes = "iot-installer"

	ImageTypesIotRawImage ImageTypes = "iot-raw-image"

	ImageTypesVsphere ImageTypes = "vsphere"
)

// Defines values for UploadStatusValue.
const (
	UploadStatusValueFailure UploadStatusValue = "failure"

	UploadStatusValuePending UploadStatusValue = "pending"

	UploadStatusValueRunning UploadStatusValue = "running"

	UploadStatusValueSuccess UploadStatusValue = "success"
)

// Defines values for UploadTypes.
const (
	UploadTypesAws UploadTypes = "aws"

	UploadTypesAwsS3 UploadTypes = "aws.s3"

	UploadTypesAzure UploadTypes = "azure"

	UploadTypesContainer UploadTypes = "container"

	UploadTypesGcp UploadTypes = "gcp"
)

// AWSEC2CloneCompose defines model for AWSEC2CloneCompose.
type AWSEC2CloneCompose struct {
	Region            string    `json:"region"`
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// AWSEC2UploadOptions defines model for AWSEC2UploadOptions.
type AWSEC2UploadOptions struct {
	Region            string   `json:"region"`
	ShareWithAccounts []string `json:"share_with_accounts"`
	SnapshotName      *string  `json:"snapshot_name,omitempty"`
}

// AWSEC2UploadStatus defines model for AWSEC2UploadStatus.
type AWSEC2UploadStatus struct {
	Ami    string `json:"ami"`
	Region string `json:"region"`
}

// AWSS3UploadOptions defines model for AWSS3UploadOptions.
type AWSS3UploadOptions struct {
	// If set to false (the default value), a long, obfuscated URL
	// is returned. Its expiration might be sooner than for other upload
	// targets.
	//
	// If set to true, a shorter URL is returned and
	// its expiration is the same as for the other upload targets.
	Public *bool  `json:"public,omitempty"`
	Region string `json:"region"`
}

// AWSS3UploadStatus defines model for AWSS3UploadStatus.
type AWSS3UploadStatus struct {
	Url string `json:"url"`
}

// AzureUploadOptions defines model for AzureUploadOptions.
type AzureUploadOptions struct {
	// Name of the uploaded image. It must be unique in the given resource group.
	// If name is omitted from the request, a random one based on a UUID is
	// generated.
	ImageName *string `json:"image_name,omitempty"`

	// Location of the provided resource_group, where the image should be uploaded and registered.
	// How to list all locations:
	// https://docs.microsoft.com/en-us/cli/azure/account?view=azure-cli-latest#az_account_list_locations'
	// If the location is not specified, it is deducted from the provided resource_group.
	Location *string `json:"location,omitempty"`

	// Name of the resource group where the image should be uploaded.
	ResourceGroup string `json:"resource_group"`

	// ID of subscription where the image should be uploaded.
	SubscriptionId string `json:"subscription_id"`

	// ID of the tenant where the image should be uploaded.
	// How to find it in the Azure Portal:
	// https://docs.microsoft.com/en-us/azure/active-directory/fundamentals/active-directory-how-to-find-tenant
	TenantId string `json:"tenant_id"`
}

// AzureUploadStatus defines model for AzureUploadStatus.
type AzureUploadStatus struct {
	ImageName string `json:"image_name"`
}

// CloneComposeBody defines model for CloneComposeBody.
type CloneComposeBody interface{}

// CloneComposeResponse defines model for CloneComposeResponse.
type CloneComposeResponse struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// CloneStatus defines model for CloneStatus.
type CloneStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded struct due to allOf(#/components/schemas/UploadStatus)
	UploadStatus `yaml:",inline"`
}

// ComposeId defines model for ComposeId.
type ComposeId struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// ComposeLogs defines model for ComposeLogs.
type ComposeLogs struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageBuilds []interface{} `json:"image_builds"`
	Koji        *KojiLogs     `json:"koji,omitempty"`
}

// ComposeManifests defines model for ComposeManifests.
type ComposeManifests struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Manifests []interface{} `json:"manifests"`
}

// ComposeMetadata defines model for ComposeMetadata.
type ComposeMetadata struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// ID (hash) of the built commit
	OstreeCommit *string `json:"ostree_commit,omitempty"`

	// Package list including NEVRA
	Packages *[]PackageMetadata `json:"packages,omitempty"`
}

// ComposeRequest defines model for ComposeRequest.
type ComposeRequest struct {
	Customizations *Customizations `json:"customizations,omitempty"`
	Distribution   string          `json:"distribution"`
	ImageRequest   *ImageRequest   `json:"image_request,omitempty"`
	ImageRequests  *[]ImageRequest `json:"image_requests,omitempty"`
	Koji           *Koji           `json:"koji,omitempty"`
}

// ComposeStatus defines model for ComposeStatus.
type ComposeStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageStatus   ImageStatus        `json:"image_status"`
	ImageStatuses *[]ImageStatus     `json:"image_statuses,omitempty"`
	KojiStatus    *KojiStatus        `json:"koji_status,omitempty"`
	Status        ComposeStatusValue `json:"status"`
}

// ComposeStatusError defines model for ComposeStatusError.
type ComposeStatusError struct {
	Details *interface{} `json:"details,omitempty"`
	Id      int          `json:"id"`
	Reason  string       `json:"reason"`
}

// ComposeStatusValue defines model for ComposeStatusValue.
type ComposeStatusValue string

// Container defines model for Container.
type Container struct {
	// Name to use for the container from the image
	Name   *string `json:"name,omitempty"`
	Source string  `json:"source"`

	// Control TLS verifification
	TlsVerify *bool `json:"tls_verify,omitempty"`
}

// ContainerUploadOptions defines model for ContainerUploadOptions.
type ContainerUploadOptions struct {
	// Name for the created container image
	Name *string `json:"name,omitempty"`

	// Tag for the created container image
	Tag *string `json:"tag,omitempty"`
}

// ContainerUploadStatus defines model for ContainerUploadStatus.
type ContainerUploadStatus struct {
	// Digest of the manifest of the uploaded container on the registry
	Digest string `json:"digest"`

	// FQDN of the uploaded image
	Url string `json:"url"`
}

// Customizations defines model for Customizations.
type Customizations struct {
	Containers *[]Container  `json:"containers,omitempty"`
	Filesystem *[]Filesystem `json:"filesystem,omitempty"`
	Packages   *[]string     `json:"packages,omitempty"`

	// Extra repositories for packages specified in customizations. These
	// repositories will only be used to depsolve and retrieve packages
	// for the OS itself (they will not be available for the build root or
	// any other part of the build process). The package_sets field for these
	// repositories is ignored.
	PayloadRepositories *[]Repository `json:"payload_repositories,omitempty"`
	Services            *struct {
		// List of services to disable by default
		Disabled *[]string `json:"disabled,omitempty"`

		// List of services to enable by default
		Enabled *[]string `json:"enabled,omitempty"`
	} `json:"services,omitempty"`
	Subscription *Subscription `json:"subscription,omitempty"`
	Users        *[]User       `json:"users,omitempty"`
}

// Error defines model for Error.
type Error struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Code        string       `json:"code"`
	Details     *interface{} `json:"details,omitempty"`
	OperationId string       `json:"operation_id"`
	Reason      string       `json:"reason"`
}

// ErrorList defines model for ErrorList.
type ErrorList struct {
	// Embedded struct due to allOf(#/components/schemas/List)
	List `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Items []Error `json:"items"`
}

// Filesystem defines model for Filesystem.
type Filesystem struct {
	MinSize    uint64 `json:"min_size"`
	Mountpoint string `json:"mountpoint"`
}

// GCPUploadOptions defines model for GCPUploadOptions.
type GCPUploadOptions struct {
	// Name of an existing STANDARD Storage class Bucket.
	Bucket *string `json:"bucket,omitempty"`

	// The name to use for the imported and shared Compute Engine image.
	// The image name must be unique within the GCP project, which is used
	// for the OS image upload and import. If not specified a random
	// 'composer-api-<uuid>' string is used as the image name.
	ImageName *string `json:"image_name,omitempty"`

	// The GCP region where the OS image will be imported to and shared from.
	// The value must be a valid GCP location. See https://cloud.google.com/storage/docs/locations.
	// If not specified, the multi-region location closest to the source
	// (source Storage Bucket location) is chosen automatically.
	Region string `json:"region"`

	// List of valid Google accounts to share the imported Compute Engine image with.
	// Each string must contain a specifier of the account type. Valid formats are:
	//   - 'user:{emailid}': An email address that represents a specific
	//     Google account. For example, 'alice@example.com'.
	//   - 'serviceAccount:{emailid}': An email address that represents a
	//     service account. For example, 'my-other-app@appspot.gserviceaccount.com'.
	//   - 'group:{emailid}': An email address that represents a Google group.
	//     For example, 'admins@example.com'.
	//   - 'domain:{domain}': The G Suite domain (primary) that represents all
	//     the users of that domain. For example, 'google.com' or 'example.com'.
	// If not specified, the imported Compute Engine image is not shared with any
	// account.
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// GCPUploadStatus defines model for GCPUploadStatus.
type GCPUploadStatus struct {
	ImageName string `json:"image_name"`
	ProjectId string `json:"project_id"`
}

// ImageRequest defines model for ImageRequest.
type ImageRequest struct {
	Architecture string       `json:"architecture"`
	ImageType    ImageTypes   `json:"image_type"`
	Ostree       *OSTree      `json:"ostree,omitempty"`
	Repositories []Repository `json:"repositories"`

	// This should really be oneOf but AWSS3UploadOptions is a subset of
	// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
	// are also valid AWSS3UploadOptionas objects which violates the oneOf
	// rules. Therefore, we have to use anyOf here but be aware that it isn't
	// possible to mix and match more schemas together.
	UploadOptions *UploadOptions `json:"upload_options,omitempty"`
}

// ImageStatus defines model for ImageStatus.
type ImageStatus struct {
	Error        *ComposeStatusError `json:"error,omitempty"`
	Status       ImageStatusValue    `json:"status"`
	UploadStatus *UploadStatus       `json:"upload_status,omitempty"`
}

// ImageStatusValue defines model for ImageStatusValue.
type ImageStatusValue string

// ImageTypes defines model for ImageTypes.
type ImageTypes string

// Koji defines model for Koji.
type Koji struct {
	Name    string `json:"name"`
	Release string `json:"release"`
	Server  string `json:"server"`
	TaskId  int    `json:"task_id"`
	Version string `json:"version"`
}

// KojiLogs defines model for KojiLogs.
type KojiLogs struct {
	Import interface{} `json:"import"`
	Init   interface{} `json:"init"`
}

// KojiStatus defines model for KojiStatus.
type KojiStatus struct {
	BuildId *int `json:"build_id,omitempty"`
}

// List defines model for List.
type List struct {
	Kind  string `json:"kind"`
	Page  int    `json:"page"`
	Size  int    `json:"size"`
	Total int    `json:"total"`
}

// OSTree defines model for OSTree.
type OSTree struct {
	// A URL which, if set, is used for fetching content. Implies that `url` is set as well,
	// which will be used for metadata only.
	Contenturl *string `json:"contenturl,omitempty"`

	// Can be either a commit (example: 02604b2da6e954bd34b8b82a835e5a77d2b60ffa), or a branch-like reference (example: rhel/8/x86_64/edge)
	Parent *string `json:"parent,omitempty"`
	Ref    *string `json:"ref,omitempty"`

	// Determines whether a valid subscription manager (candlepin) identity is required to
	// access this repository. Consumer certificates will be used as client certificates when
	// fetching metadata and content.
	Rhsm *bool   `json:"rhsm,omitempty"`
	Url  *string `json:"url,omitempty"`
}

// ObjectReference defines model for ObjectReference.
type ObjectReference struct {
	Href string `json:"href"`
	Id   string `json:"id"`
	Kind string `json:"kind"`
}

// PackageMetadata defines model for PackageMetadata.
type PackageMetadata struct {
	Arch      string  `json:"arch"`
	Epoch     *string `json:"epoch,omitempty"`
	Name      string  `json:"name"`
	Release   string  `json:"release"`
	Sigmd5    string  `json:"sigmd5"`
	Signature *string `json:"signature,omitempty"`
	Type      string  `json:"type"`
	Version   string  `json:"version"`
}

// Repository configuration.
// At least one of the 'baseurl', 'mirrorlist', 'metalink' properties must
// be specified. If more of them are specified, the order of precedence is
// the same as listed above.
type Repository struct {
	Baseurl  *string `json:"baseurl,omitempty"`
	CheckGpg *bool   `json:"check_gpg,omitempty"`

	// GPG key used to sign packages in this repository.
	Gpgkey     *string `json:"gpgkey,omitempty"`
	IgnoreSsl  *bool   `json:"ignore_ssl,omitempty"`
	Metalink   *string `json:"metalink,omitempty"`
	Mirrorlist *string `json:"mirrorlist,omitempty"`

	// Naming package sets for a repository assigns it to a specific part
	// (pipeline) of the build process.
	PackageSets *[]string `json:"package_sets,omitempty"`

	// Determines whether a valid subscription is required to access this repository.
	Rhsm *bool `json:"rhsm,omitempty"`
}

// Subscription defines model for Subscription.
type Subscription struct {
	ActivationKey string `json:"activation_key"`
	BaseUrl       string `json:"base_url"`
	Insights      bool   `json:"insights"`
	Organization  string `json:"organization"`
	ServerUrl     string `json:"server_url"`
}

// This should really be oneOf but AWSS3UploadOptions is a subset of
// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
// are also valid AWSS3UploadOptionas objects which violates the oneOf
// rules. Therefore, we have to use anyOf here but be aware that it isn't
// possible to mix and match more schemas together.
type UploadOptions interface{}

// UploadStatus defines model for UploadStatus.
type UploadStatus struct {
	Options interface{}       `json:"options"`
	Status  UploadStatusValue `json:"status"`
	Type    UploadTypes       `json:"type"`
}

// UploadStatusValue defines model for UploadStatusValue.
type UploadStatusValue string

// UploadTypes defines model for UploadTypes.
type UploadTypes string

// User defines model for User.
type User struct {
	Groups *[]string `json:"groups,omitempty"`
	Key    *string   `json:"key,omitempty"`
	Name   string    `json:"name"`
}

// Page defines model for page.
type Page string

// Size defines model for size.
type Size string

// PostComposeJSONBody defines parameters for PostCompose.
type PostComposeJSONBody ComposeRequest

// PostCloneComposeJSONBody defines parameters for PostCloneCompose.
type PostCloneComposeJSONBody CloneComposeBody

// GetErrorListParams defines parameters for GetErrorList.
type GetErrorListParams struct {
	// Page index
	Page *Page `json:"page,omitempty"`

	// Number of items in each page
	Size *Size `json:"size,omitempty"`
}

// PostComposeJSONRequestBody defines body for PostCompose for application/json ContentType.
type PostComposeJSONRequestBody PostComposeJSONBody

// PostCloneComposeJSONRequestBody defines body for PostCloneCompose for application/json ContentType.
type PostCloneComposeJSONRequestBody PostCloneComposeJSONBody

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// The status of a cloned compose
	// (GET /clones/{id})
	GetCloneStatus(ctx echo.Context, id string) error
	// Create compose
	// (POST /compose)
	PostCompose(ctx echo.Context) error
	// The status of a compose
	// (GET /composes/{id})
	GetComposeStatus(ctx echo.Context, id string) error
	// Clone an existing compose
	// (POST /composes/{id}/clone)
	PostCloneCompose(ctx echo.Context, id string) error
	// Get logs for a compose.
	// (GET /composes/{id}/logs)
	GetComposeLogs(ctx echo.Context, id string) error
	// Get the manifests for a compose.
	// (GET /composes/{id}/manifests)
	GetComposeManifests(ctx echo.Context, id string) error
	// Get the metadata for a compose.
	// (GET /composes/{id}/metadata)
	GetComposeMetadata(ctx echo.Context, id string) error
	// Get a list of all possible errors
	// (GET /errors)
	GetErrorList(ctx echo.Context, params GetErrorListParams) error
	// Get error description
	// (GET /errors/{id})
	GetError(ctx echo.Context, id string) error
	// Get the openapi spec in json format
	// (GET /openapi)
	GetOpenapi(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetCloneStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetCloneStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetCloneStatus(ctx, id)
	return err
}

// PostCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCompose(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCompose(ctx)
	return err
}

// GetComposeStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeStatus(ctx, id)
	return err
}

// PostCloneCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCloneCompose(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCloneCompose(ctx, id)
	return err
}

// GetComposeLogs converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeLogs(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeLogs(ctx, id)
	return err
}

// GetComposeManifests converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeManifests(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeManifests(ctx, id)
	return err
}

// GetComposeMetadata converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeMetadata(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeMetadata(ctx, id)
	return err
}

// GetErrorList converts echo context to params.
func (w *ServerInterfaceWrapper) GetErrorList(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetErrorListParams
	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", ctx.QueryParams(), &params.Page)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter page: %s", err))
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", ctx.QueryParams(), &params.Size)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter size: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetErrorList(ctx, params)
	return err
}

// GetError converts echo context to params.
func (w *ServerInterfaceWrapper) GetError(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetError(ctx, id)
	return err
}

// GetOpenapi converts echo context to params.
func (w *ServerInterfaceWrapper) GetOpenapi(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetOpenapi(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface) {
	RegisterHandlersWithBaseURL(router, si, "")
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/clones/:id", wrapper.GetCloneStatus)
	router.POST(baseURL+"/compose", wrapper.PostCompose)
	router.GET(baseURL+"/composes/:id", wrapper.GetComposeStatus)
	router.POST(baseURL+"/composes/:id/clone", wrapper.PostCloneCompose)
	router.GET(baseURL+"/composes/:id/logs", wrapper.GetComposeLogs)
	router.GET(baseURL+"/composes/:id/manifests", wrapper.GetComposeManifests)
	router.GET(baseURL+"/composes/:id/metadata", wrapper.GetComposeMetadata)
	router.GET(baseURL+"/errors", wrapper.GetErrorList)
	router.GET(baseURL+"/errors/:id", wrapper.GetError)
	router.GET(baseURL+"/openapi", wrapper.GetOpenapi)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+x9eXPiuLb4V1HxflXdXWFfAknV1H1ASEKALEDWoStP2LItsCVHklky1d/9V5IXDJhA",
	"7vTMu/e+nj862JaOjo7OOTqbNH+kNOq4lCAieOr0j5QLGXSQQCx4MpH8qyOuMewKTEnqNHULTQQw0dEi",
	"lU6hBXRcG601n0HbQ6nTVCH140c6hWWfNw+xZSqdItCRX1TLdIprFnKg7CKWrnzPBcPEVN04fk8Y+9pz",
	"xogBagAskMMBJgBBzQIBwDg2IYAIm3x+Jz6q7Uf4/Ag/KtD1x0GrWWzalKCmJB9XA7mMuogJ7A/PkKlQ",
	"3oKVTnELMvQ6x8J6hZpGvYD2AfKp099ThWKpXDmu1k7yhWLqezqlJpsIK3gBGYNLNT2G3jzMkC7BBDh8",
	"j5rR8QRpQvbzp3Dv2hTqN4q6/KM5RLilkJeZIy4yhVT675xZOsUJdLlFxau/ZnGcnGUm/LqNVTJNknHd",
	"R6mBgMJLIBR08DpG0MGZvFYr5asnpWq1Ujmp6OVxEsU+SeKNychx03uWeVDas8quN7ax5suaAT1bpE4N",
	"aHOU3pC9tgE4EkBQoD6Dr8JCIOgClJR9SwMIbErMNKBjw+MaFEgH9/3uiGAOGBIeI0jPgrbgAC1czKAE",
	"DRxsWgKMEeCUEsSAsCABBmWACgsx4Cn0R0RAZiLBsyMyIitcBPOQHJZblAnE5GggNhiARB8RvD4g5kDi",
	"zqGDAORqKPkcHw6sRlutwphSG0Hy59ftsBXbxW0es5N1ZnwI2SgR/rvH0B6OwA40USRnGxpYEo0aimA+",
	"qZAOVAe5rsDxuFpKj+A3T24TqqGJZ4gAhjj1mIaAyajnZtUqykHkelAHC8ksBqOO6iLngriQS8sg0akD",
	"KEFgDDnSASUAgvv79hnAfERMRBCTnOav1ZpaUIglyZ1NNSiCFVyfYDf4Ek7SZXSG5SRD9F8V+mkwtxBD",
	"qokaRXKgZ+tq8iFdIJHdTMwFYgq/SzqXTGtjLgC0bRCiwU9HxBLC5ae5nE41nnWwxiinhshq1MkhkvF4",
	"TrNxDsrlywUK6x8zjOa/qVcZzcYZGwrExX/B91CjvcqBXqNBviiSS4zDV5L0hArAXaRhAyM9DbCQL3Wk",
	"e9raguygwybRpQQgT7JTsrqL9/2Yu9bZ5QByb6IypJ4GST8Ac6FGTNq0vHGEwivWt5Fqn0mU4s3+CWTK",
	"qKLXxkUtA8fFcqZcLpQyJ3mtkjkuFEv5Y1TLn6BiEnYCEUjEB3hJJPxGh2EVsKCBia7W2pdQpRbALWUC",
	"2ofwYsiHAs9QRscMaYKyZc7wiA4dRAS0+dbXjEXnGUEzcuiMj/IGkSpaFRmV8XGmoJWMTFmH+Qw8LhYz",
	"+XH+OF8snehVvbpXua4otr22Wxy4R0XuUsHrGvIQlbOBZAxAEgpx27JB9aUchRJ0Y6ROf/8j9f8YMlKn",
	"qf/KrYz3XGCe5hJs0x/fNyD2EXcp8a1WaNsHQL1RmPWRgRgiGkr9SG9RRF+nRKFYQtLSy6DayThTKOql",
	"DCxXjjPl4vFxpVIu5/P5fCqdMihzoEidpjxPLc8equkJ1Ipmt1qsf35SH7VfYwl/WJ+ebf0/iJL+lLrU",
	"5D91Uorfxx62df95w+4PUEinFhmTZoKXmAjEDKihP34keQRTOlFm90eYdegEq7kkC2CA0Iek6EGCDcTF",
	"T6WHEwf654mxMbkV9I9nhgTUoYA/c2KUC4bQq0YdB4vEPeurBbn1Ldy65AoIEDRP2P9cqE2h6cPejEOo",
	"L74xhYlmezomJrhuPfTrqZhn+dF8AhgRIZIIu5t+fd9G3d4eNI8L6uB3GBnYHyHRXG/9I53SsSTA2BNb",
	"PgazkJ2pJRHKZ2i2QumjIduycYj+Zud1nvwMmH9WQrcYeI0AMYr/DBWfpJh4BHfvdEP9n17rij5JtBWU",
	"JJodiI8k3QrQYX3WCPmgYmObxA8ArU/wY03ig2sxRtm2NOhIQGzLn5JoekzRSZ1mIuZ7BpAnxsu2N66o",
	"8RYC/nykwBDPUVPxNA1xORcDYttj0jBzEZGKQk5oJVerhluC1aREQExQwsw+cJEFBR5HUWxBC4GsHKqd",
	"vqlvoAZwV2AjLlZhjzWYggLkjJG+Zkz7jidbZoNXynpXg54KaCb6GjZ/nSGGjeX2pCQVGLXBsDsAqg02",
	"cOBCxwZV0ZitcMkmf/nzS7R7wyltRSigrmP5AO3b2BIEgaqDVyVaDoZUbGpFQkWYDXeEcmUfJJIKmttD",
	"DKH5yRF8jz3RWttHm5gqPJw0OjaD3WEd8zP1PtyTQ/NhK86zmgwlgY/u81g8SrYiUhCoWh/q/O7sOjmA",
	"tEGbNw8us5jmnGUQzcgF63H6AdU2Q2DpcMqJ3La1TW9s4+F0D1fuK2WRoNoNbCO+5AI5B8M7X3VJABg3",
	"jmJBdpdyYTLEPxdgd+FSrsYrQy7lWFCGk6yu1kIwCOJtFMuHmKwiSQATsG4HZcHQQhyNyFrvObZtQIm9",
	"VHEKjnSpzXTkcmrPUBBBEwyjGYoGGZFQym4GAAuObENFo5c+MEJVCBLOILbh2F5JveIewCgVgLIRgWQZ",
	"xHxdyETcINWBy6jcD74pnMOBXzkSHBgY2XoIc2s6mANsEsrCCNBBq9wPISwTMx+IzbCGPi/rXM4+IXDU",
	"xb5sh4AVxf3WYLwMY/px5FdSaWCG5tBO1ooOJm2/S2F7Goh8Ah2/8V5siCFkO/5JZJLUazxUtG+9BvG2",
	"UtHxz+iIe56kHpJwigyqn2XtalRHicpgzUaTPWAsHJoQxj3MWFPDRc03ACcblGrKkiMOn7ZqnWDZh2tx",
	"0KL4pN7nWPugkjE/X9PuG+4+Jq9hQjri3kK+WF738T1MxHFZMa/c8FyKiVhn+NwMsr0bX6xzejV00g54",
	"0bzdkwsae9oUid2RekgAWmAupOs9GNavz+r9MzAQlEnXXLMh56ChQGQ3czPBQyYYYadLm2zOSbVMEgxt",
	"7LiUiSD3onK8OpA+gicQaBETk8Dwzo7IMAqUK0Abqas5FlYQHL9o3soNQRItDeYW1iyp5uVetb4TKVhB",
	"/lAO7+OSBW1jPckS5bRG5Ivm+y8sA12cGXn5fEnzPKyrX+gL8IkRDgcgj4X3JdafyXmtcpbbpJRT9L/H",
	"sgjRnNS2Oo4RV9A4faVLE9BT5YEjUkL5jHUFPUw5ZcEAIRAmGDSbenrWpNQMHBTus47KPOSizFWQLFzP",
	"VClT1bMFzgSYR1ktzaZc2q+Bo+Q7HCPyNUgohezpM2bU7Zsks2ZRjgiAnqAOFFiDtr3cJDLyPlH8kLzX",
	"BXRR8wZhc4mvgrLOyUnsq9gzOyItqFkhkyiqBzYrgBGlWGjZBMMAiXkWPCgM/KgxB5Ch0xEBIAO+yM3s",
	"9A/kQGxj/ceXU1AnQD0BqOsMccmCUEgTkCEudehqLE2CABvTyoJzykBAvTT4Am2sof+OOaVfssHIgQFQ",
	"9/t9Egd/6ADErrGdZUZZfBnouv8NXZe7VGTNoFPYJ46SyhJ9lhrB/MP8qMRrgwS6gwlPpIFOHYjJ6R/+",
	"XzmgEk8w8LBAwH8LvroMO5Atv20Pbtv+gMq9kmaJv/pQBH03KbISvS+AMvBlA6dkqfuYNcOcsq8cJKMC",
	"SJYjEtJ3XZp+V9bT6RZXpCLDN+SHQxcvlU75y7ZNZukP+gSOv/xLKqyirfXn5RCVhS/hv27miCDXENEh",
	"EZkxg1jPlPKlSqG011CIgUvvS0muxXq3K6CYZmGBNOGxjeksasevx+Xd27v/+oCQ6XDpIhXo9FMM+/rc",
	"DIaylZrxukP7E1wyf5N/pe5BAf51E2uriCtOujWqbKD+PVyFXRyFQnfh4ABwZPV+OgAehI4jUhwGYD2F",
	"mhx33pjmp2K66ZRy3/2fPmb+77AKJwj8bvFijMNiQ8G5HAbOecaCGWZ5OHiK/eTQjR7ffWT8gpz4y3gr",
	"pJsoE+W7gqcwaBS8wIQLaNvqham5/r8hAFNKYKQi1N+1DpiKFXz/YQVePm82ZnAegZtxV5p/iTTqBNmc",
	"5GjrSuLPkU4ZzDSlaZdpQL7DGLUR5Bs9i/liPn+Sr2bziQYWYjM/Cr/qEdqRUzrBWUMNHCi1LGWmem15",
	"47X0OMPJAV0+3VSr5WI6IVMxQ4xv5eVK+4v+AvRXQwXlxyuIK6okKeAolZ2wk8jtOMivEJV23XJcic8O",
	"fstd4HcpFiVUh1AnKYgROvPrIKeYJMcWwirybcKHDvT2F0EFtJM+bVBBDZqOys/9qm+/c3qnb59OBVtJ",
	"YnwYEZEY5q6rSlTlLKYBVuWq6ciNk06jgYRmSbM9gJIFbce1MQoMyv/xmP0/sgNHQrp9c2Tb6RHxvc/Q",
	"H4uAOUECWwVSs8nReBcyRBI8+SYkEhbCKhQKg1w8+Bos9CnIF4/z5XFRh8fopFIe66XyuDauFWGtVEEV",
	"WK3qxfFx3jDgt7S0ICEYM0g0K2PjKQIsSlqt4DEL2blazjcMclLhfdtwsLZbJKsQYzs5fkA3izv7q53P",
	"kEDMwQRx6RAHpPG9trVKQAcSaCIGvmqQ6DZysXQjdUQEFku/ENlnPyCosoB9j0F9CA2MLGhSwj0HMaBJ",
	"5lKJtTAyHq4y5ECzMSJio42FyIhEvBTxgfTOQ8baUcK8s4x4m/834opbgmAFS7Ft4iXL+A7hT0r1BiKr",
	"RkiSzc0KjkTLNBEJ5NIdX8It7aNNa3t3wqajV3Z9IjC0jHc4GAkfYhvNnopH31jcuZukfSJEOEoLK2bf",
	"bmmE1TfJQwY2PT9qmx2RugASplDV2EFc4csYcuQx+4t0sLG0KG3MhXpCAtqYTL+A1ZqoMMWIjNHKqVQR",
	"MoeyEKIDIEObPidluh/KcBnSkK50CuYjEq/kl+NKWRnTWRAZ29jHfESTTQhNJ1mGdAv6da6B9OR0zEVO",
	"apbaSrVIOJTnKM8dYFloFtKmr6ZrxhYyJoama05RwiJc3F6AKVpGKTHJRKs0m4pMrmuRNQ2akf81Whft",
	"a3B7cQtu7xvddhN0Ws+g0b1pdtTnERkR56593bioawONNlr1s65Re76coverY6jbved5FV5ctO0raIva",
	"1aS4yDWKnSOrbbS9xYVwHyZVNCLdvnl2Xz2ewGHFfTirOOe9q5I7RQT1c9rQeXu7m14v77j1VKR3T/PW",
	"+/1gXGhe95pG88KcPtXuiiPy/jJlba3JzvN3xTnrjG3o6db9EX6ApH7GnULtufXGx5X6famqi3vWK909",
	"64/mSf/oCd8aD7X+iHQak2G+NHto3Oi9AX8unXRhkxy33cLNzK21WzTXRq2H58Kb07y5rcNOfnx1WfIM",
	"s9z00JQfDQcjMr97HKJmd+G9dI9vek/05rYzn/XujMXYLDyd1WbeS74jJjnt+rK4gF5+4fC6d3J55aLp",
	"7Oa2v7BHZPkmJssXg9EHjM6X7vzFnN3NBSG9Ws4ctLzc1cOQPecrRad1P6w2tXG1PNUuz4fnRm9qk+lF",
	"bkTyxn253oeVfPmytJjkp2KMSrOOdvtEb2+8TuOBXw5m+fz9xXN9eYu85VGtqt3nnltWrzotDR46kxE5",
	"Ru0Xc4l7N/m5XXi+OOt3NM+eT/lJ/cizp2aBDsdlXnp3Xma3+eoFHS4ey8UJ7FQeB0fX1gtCI1I7zj/R",
	"B2usFTru4GhivNAJZy3xUrsd378cPc/Oa32X6Y91NrkcX02LV26/U18MrQW/q/OGdVEYkXzXWxQfYa+R",
	"N4vtyq3W069y2tuE5muaxiaNJw8vHhmuYO+k9+TW3oY5Y/B+7XC9bZJa7u2lMyK4dufZhletem/WY24u",
	"imNBsDD7/G1iLXre5Pm+/DIuW1NxXrM697mnp2q5+GZ1K515vV+/qzdGRJydX7w89mea0zI7Z71CZ1Cv",
	"vTgP03HpyuoOe4XuU2MJHwuWRux6+F67vJpB52GiNyuzEdEc7QjfXd00Gr1Gs14vn+NWC10eO8w6v6x6",
	"D/yu2+sV888V7cUii+faed1RMtS8mNfOm/Npe0Qa8/bF+R29atZ5s9F4btbnreal2Wqel+v1pjm9W/U+",
	"un6u56qNZ9e0l4P6y/OlNVl2rBHJHRnH77fGw2x8Wcy33krTdvXmvHGdJ92no8Z9wfFmg6O3oTcoPXZZ",
	"o+SULjxbuJ1+66rTFU6ldTYiBXbx/lSnw8LSPXlu17r1M73XbN4sJ/UJp4/3terzvdc8yo3JhA1Rv9jt",
	"3zSN5W2zevx4Uqvgm4cRcSqDozG/O5tXm8Uus/V6r9w78+jypTDA4gK+lDt33QdxNGzBQhnz58FFc/JO",
	"q7fPtYfS1c20kh8R8+3RrBWvc2On2HofVIe10mPrbFywZ5Ny254tzPZbB5mFwvvT88Jhz4OXq6umMXs3",
	"juzrwbG3MC9HZLLIXeWX9kuxi8cX7PiiXl/enNw/svrLYD7o5VvaZFibt5pkMR2cecs353H+MLtuPHmt",
	"9kPtBpWeR6SH7wvG1XWN69Uzl58vKr2jJ530yN3g6JJNhreds5LzyOy6TlpDS39+qE1epu6jdbbkpdzJ",
	"CboZEWuaZ12yzE+u51PoGTl8X7vRjp9mvemk2+9dmZX7k4fO8sp7fBTv8ycy6V1XHvvnjbdOmb9Qp9cb",
	"EUOMh5eFo8py3H/M1Uuzxhgu+o9FUb1/v55o72g6eGlh2L0+6eYutatmu1+4O68d14pnet1unZ/oIzIt",
	"mnf4eXBXh/Aqf3VVf7+c9af9q27X7BSf757x5fXDsihKV8tzgzPoVOaD5uONYd2i9rLbGL5cjciMudf2",
	"7RgZfHhSqQ6NYuO67ZnvL6xZeVicDTrTF7NvFR4uZoP2HWku36d3y+PWffHt1sWPlROpo6zb9tML61Ct",
	"U+p0Byc5/H51N+zbYtKr/zYiv90aw+qIqN2ldX320daTGBBUhROvnNvJW2VoTiTv377pwROiAGG/f8jd",
	"8jf/e6ZUHHn5fPFYmka/RUHKfZv5yr7ZRiLCQX7OaogIytX4/wgMsd9qGS4Ygk5sZCj/PS77bxR+DcjR",
	"zeAAXOJVKYkJWukRBI2AX7qi/LOVzQAgl2YFB1jlylZ5HFURMyJfXewiGxP0LbE6ZiuSH5bL0U+WHv1c",
	"l2zd6wI7nK5UYp3iln8x2CgL2XAuNIFnfkVDYMStn0pGGkMiIz/FltOFnM8pS6ygkZbla6KJum2hHsAi",
	"mHBsWhunsJOLNNMpykxIgmKtzbhcOV8qlncH5bZRjq9IVq5vDPO9iG/4N2uIpTeJvoZDjIKx2Sc5jtsV",
	"pmR58PmqjYh+em+fzVPY+7psFWbsHWP7XO++LjuKbX98T28VCGAeHiZkCNp+rZ46jwbGngDb85MyCJVU",
	"IgGoMSIJZMsCBddBkAQxL2jbIKEh8BeNj4h0C6HNaSD1W+PCqG1QpjHDVBWL+h6kRHhEmGcjvxaRIYMy",
	"lAZzBCw4i0pJFCMAVQUhZzdGAM79pDwU/vFY8kWMiEs5x2NbdXPwQoVcHCg0y3dlAyoDQU2lq6SyjNhu",
	"V6A1llD6zHG/9bTK4dx4YI/NVOYnePHAHsm1zaqs6vOJpSg1dUhq0e8Y5BZ3HYQIAizh6nzfWMdPpqiY",
	"R8iuPFQcnaREVJaXopxQmG9a5XcSIfKkkwsqQb6eDV3pbvUx8YKPrcMqm5se51YG6cVKpXAC6vV6vVm6",
	"fofNgv1y1i5cD1sV+a59zS46LdZ7xke93v3cu4T9+pXT79L2e98ovp0V9bPKe74xXOSOF0lIbGecPI7Y",
	"/gTMjtS22sQ0j2GxHEim8AnUQJD5hBurX+fhhnX1OAyvilH7p98ugiq3av/CGEwMum2WDYICFUEDW0oV",
	"ivkZOb9+gkvTxMYaCk7oBnfU1F2oWQgUVW5MbbeR5Tufz7NQfVbmZtCX57rtZut60MoUs/msJRxbrSAW",
	"imQ3g4YaPkgHM6AqsQB0cSyEeJoqpvx6UCI/nKZK2Xy2oDIowlJkymk2JYjn/sD6D8VXSbWCF0j4dVhK",
	"WlTVIAiEAFAGpFTaSITHAPwTMioPITFThWWYByf8YrYfZarMZFUPp45cSANQiR/SkZ6N15y2dR+V+Fnh",
	"9NqNR78nn7APDtP7yAsKTFWtqO4RknRYXSMUnE0KOc63s1aXCv30I73f1XF2dZRbLUYxn4+lpZRN47p2",
	"cEwnNwlKdlcIfaiRY1RS7LxOmThNJIuUf+LQQVHC9qBt4u/7AWcArPtDF/76oeuesICgU6TcC+wj4o9e",
	"+utHvyfQExZl+N13aVzEJG+AiLd9TMp/ByZTQudkYwkqf8fq3xO0cJG6lEQVugCqaR6TkhZX4UqKQ+X9",
	"+3cpI9xzHMiWQaVrXAkp5RXxk4KT02I3etGks1JNdbILQEDQPOyaBi6VU8fKONYo4UFJtDrWMEMMhspd",
	"6fugRlhdXebXqGIGdCS7BPWuW4rrlnIRXujgKxnERXg1xM+R+PVDzT/Wt0+pzH5s6ZvCzx69rSctffAR",
	"WJDL9WMC6f9rSoetjjv/0jy/NM+BmidQGkma5mcZT5+wl0Ia7jGU1s7cH2QqRYD/jxlLa5RK4KB1uvwy",
	"mH6prX9Tg2mn/vIdwbjVlGC/xG+lOkifxJTVv5AW+Qtsr837vv5u6yvpdrAEllKn7tB8ddBjjFQJo3/Z",
	"QbJeE2ghcq4N8QY+CXfsHqa9yj9rgCTZ/LG2a0uyrB1x/EAA7KA295/ZxQ1MMLdimzj4cA/HYrV1p5VH",
	"oaLiDhIQYOLzMKYEwDH1RHiZomeLj7Z5VVr8a5Pfu8kHt4klioZkgegkqn/paeQgYgIIVXlVrHk2ZMHR",
	"O/BVWNQzrSClcTW4uf6W/Y8TpAt1zNIMM9AhlyeJ0drNaB/KUtTyAHHqq/uAuSpbjK43kcgoHzxQZyR+",
	"82wWqLOVUWONKsHi4aHSYPl0ZGB1z7AA8XBscFWJX34ASXh1SSYEl618IIqrG+d+yeNeeVwRa4dQri33",
	"lmD+Z8raungcIHSx8umPZS46aCBFbkvO/EPgaAE1sbYRRddx68hFROer+4OUrEWhf3U0+SPJCPH8JRj7",
	"BSO61HCHXIRL+Rm5+OWk/nJS/9Wc1C3dlKTvFPC4TbGlYlY3z2wpl6SZrZrk1HmyXSUOsXbqwNlfKvqr",
	"OSRxu39VKjVAQIxfYva/I2Y+o//7CRmMGAjaNojqn0JuWonZ/og2JH7RA9GiY0Q+ZqtLcsZLoLbOZEE9",
	"PH6EguZ/atcv/c17+M6lVB9A/N0vKf4lxZ+RYrTNQVJyoyKf3TvkTdAkme/XkQ3AKXmWnrWkQeAz/zva",
	"Fh9O50dUB52kiXrBjT1U9zT/mqnoJoD1Mi7o4qwch1s4+H9tQBf7N/ZmVPQAsUx4XVhuVlQWx0ZxmYAm",
	"JuZHA3ABTfQnh1FEJOGNQtEw++B8//H/AwAA//+fZZ/4b24AAA==",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
