// Package api provides primitives to interact the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen DO NOT EDIT.
package api

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"encoding/json"
	"fmt"
	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
	"net/http"
	"strings"
)

// Error defines model for Error.
type Error struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference
	// Embedded fields due to inline allOf schema
	Code string `json:"code"`

	// Backward compatibility with workers <= v33, equals reason
	Message     string `json:"message"`
	OperationId string `json:"operation_id"`
	Reason      string `json:"reason"`
}

// GetJobResponse defines model for GetJobResponse.
type GetJobResponse struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference
	// Embedded fields due to inline allOf schema
	Canceled bool `json:"canceled"`
}

// ObjectReference defines model for ObjectReference.
type ObjectReference struct {
	Href string `json:"href"`
	Id   string `json:"id"`
	Kind string `json:"kind"`
}

// RequestJobRequest defines model for RequestJobRequest.
type RequestJobRequest struct {
	Arch  string   `json:"arch"`
	Types []string `json:"types"`
}

// RequestJobResponse defines model for RequestJobResponse.
type RequestJobResponse struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference
	// Embedded fields due to inline allOf schema
	Args             *json.RawMessage   `json:"args,omitempty"`
	ArtifactLocation string             `json:"artifact_location"`
	DynamicArgs      *[]json.RawMessage `json:"dynamic_args,omitempty"`
	Location         string             `json:"location"`
	Type             string             `json:"type"`
}

// StatusResponse defines model for StatusResponse.
type StatusResponse struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference
	// Embedded fields due to inline allOf schema
	Status string `json:"status"`
}

// UpdateJobRequest defines model for UpdateJobRequest.
type UpdateJobRequest struct {
	Result json.RawMessage `json:"result"`
}

// UpdateJobResponse defines model for UpdateJobResponse.
type UpdateJobResponse ObjectReference

// RequestJobJSONBody defines parameters for RequestJob.
type RequestJobJSONBody RequestJobRequest

// UpdateJobJSONBody defines parameters for UpdateJob.
type UpdateJobJSONBody UpdateJobRequest

// RequestJobRequestBody defines body for RequestJob for application/json ContentType.
type RequestJobJSONRequestBody RequestJobJSONBody

// UpdateJobRequestBody defines body for UpdateJob for application/json ContentType.
type UpdateJobJSONRequestBody UpdateJobJSONBody

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Get error description
	// (GET /errors/{id})
	GetError(ctx echo.Context, id string) error
	// Request a job
	// (POST /jobs)
	RequestJob(ctx echo.Context) error
	// Get running job
	// (GET /jobs/{token})
	GetJob(ctx echo.Context, token string) error
	// Update a running job
	// (PATCH /jobs/{token})
	UpdateJob(ctx echo.Context, token string) error
	// Upload an artifact
	// (PUT /jobs/{token}/artifacts/{name})
	UploadJobArtifact(ctx echo.Context, token string, name string) error
	// Get the openapi spec in json format
	// (GET /openapi)
	GetOpenapi(ctx echo.Context) error
	// status
	// (GET /status)
	GetStatus(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetError converts echo context to params.
func (w *ServerInterfaceWrapper) GetError(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameter("simple", false, "id", ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set("Bearer.Scopes", []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetError(ctx, id)
	return err
}

// RequestJob converts echo context to params.
func (w *ServerInterfaceWrapper) RequestJob(ctx echo.Context) error {
	var err error

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.RequestJob(ctx)
	return err
}

// GetJob converts echo context to params.
func (w *ServerInterfaceWrapper) GetJob(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "token" -------------
	var token string

	err = runtime.BindStyledParameter("simple", false, "token", ctx.Param("token"), &token)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter token: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetJob(ctx, token)
	return err
}

// UpdateJob converts echo context to params.
func (w *ServerInterfaceWrapper) UpdateJob(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "token" -------------
	var token string

	err = runtime.BindStyledParameter("simple", false, "token", ctx.Param("token"), &token)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter token: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.UpdateJob(ctx, token)
	return err
}

// UploadJobArtifact converts echo context to params.
func (w *ServerInterfaceWrapper) UploadJobArtifact(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "token" -------------
	var token string

	err = runtime.BindStyledParameter("simple", false, "token", ctx.Param("token"), &token)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter token: %s", err))
	}

	// ------------- Path parameter "name" -------------
	var name string

	err = runtime.BindStyledParameter("simple", false, "name", ctx.Param("name"), &name)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter name: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.UploadJobArtifact(ctx, token, name)
	return err
}

// GetOpenapi converts echo context to params.
func (w *ServerInterfaceWrapper) GetOpenapi(ctx echo.Context) error {
	var err error

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetOpenapi(ctx)
	return err
}

// GetStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetStatus(ctx echo.Context) error {
	var err error

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetStatus(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET("/errors/:id", wrapper.GetError)
	router.POST("/jobs", wrapper.RequestJob)
	router.GET("/jobs/:token", wrapper.GetJob)
	router.PATCH("/jobs/:token", wrapper.UpdateJob)
	router.PUT("/jobs/:token/artifacts/:name", wrapper.UploadJobArtifact)
	router.GET("/openapi", wrapper.GetOpenapi)
	router.GET("/status", wrapper.GetStatus)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/9xY32/bNhD+VwhuDxsgW07TvgjYQ9MNRTp0GZIVK5AFwZk6W0wkUiFPdgxD//tAUv4l",
	"KXaKxg/NkxWJvB/fffzumCUXuii1QkWWJ0tuRYYF+Mc/jNHGPUCeX0x4cr3kPxuc8IT/FG82xc2O+GJ8",
	"h4IucYIGlUBeR0teGl2iIYneoNApul9alMgTbslINeV1xAu0Fqb+W4pWGFmS1Ion/AzE/RxMypw/IDmW",
	"uaQFm0vK2FybezSW/VeNRqfiNzY7PY0YPlSQW2YQrFY86rpy8YCzfivT3liard1P/ttDJQ2mPLkOyayX",
	"twxvUrpZx6A9Pry+qSP+EemTHl+iLbWy+KIYgxKY43ZuY61zBNXNYLW0P8a2r6TtKvOB9kD4BLL3UqWH",
	"cfXo+aVR8NCNLuKX+FChDRj6p250YETWG4Z74VdIwsI+uYQnHIyBRSfAsD8KDg4F9/IFBjP1v4+DqR40",
	"vu+sVsNLmH9uSFe76EhOQNBtrgWE09STaLpQUEhxuzK6huSA9V2AIr7XSXhxqO7+65alvhT6iXpFQJU9",
	"BtbWWz4ce7OuP7wvZQqE+6hq0FY5HYS95bTZ1cfALZcbUL4JCudMqonuSvI/mbRMWgaKvf/7nE20WSsx",
	"aWZCjgxUyjJQaY7sTo/t0EmxpNyFeXF1Vsk8ZR9cGBYNG7B/vQEe8RkaG9ycNGKtoJQ84afD0XDEI14C",
	"ZR6zGF13svFSprX7e4rUjfUjukiYVJac1jE9YZQh81uZLVHIicSUjRfMq85aws/TsDl0QOfVQIGExnpS",
	"7To5/33HLnfA8cRHyiOuoHBJe/ub6pGpMGp6rQsbH6EoPTonp92uVd+4vaGSPvk3o1Hop4pQ+byhLHMZ",
	"Tkl81/Svjfl9pQ851r7ib79+PYrdd0exW0fcoqiMpIUvyxmCQcOT6xsHmK2KAsyiYUEo+Xbh3PbYcdOf",
	"R2176NMcWMvAkXjIPPXXJGHjXIt7yypFMg9L/LmYgcxhnOOww6hNY2jIgJbOdLp4MWy6bTHA1CLPyVEc",
	"NkrjHe7i+MEgEKbuRL8ZvX0x572itev5L+3LMoetukSMzILBFKTiPxrn2/l5Fm+YfrlSX5f1huHxkvQ9",
	"qm2d7EjdipRHUpnWwNuTysWf/IdUoB2ZMZVSUk0D/J2+0dMXfGH2toaeXlAChdl2t4rrrn8kdekMMr3i",
	"MjqGv1dMm5Alg13utI9uvBqGbbx01PFnuayojwW5hvSTHr9vdvDn8ND/fAsNo5ej8/O4qgUhDSwZhGIX",
	"9LbJp0j56ojjCu3m2xU3Am3WQ/PTYn/RLHkOTo05Py4zqZiL3U39BfirxrtjjKLtQ/5F4WOJgjBtBjkt",
	"RGUcv7oS7AbxvTE7jDYXu957w5V00zgLq5p7jGHzTIqMGaTKKMssmpkUq0V9t4er1ZejKWTr5vsa5bGB",
	"t5n2zWylYZXJecIzotImcQylHLqi20xOaCh04d7EsoApDsbutolmEG6p8eyEt0H6DFKxX0qj00q4V7+y",
	"4Mn/R6DryBJM8TvcXRFMndB3nOy10lq29eGm/j8AAP//dP8YvMUVAAA=",
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file.
func GetSwagger() (*openapi3.Swagger, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	swagger, err := openapi3.NewSwaggerLoader().LoadSwaggerFromData(buf.Bytes())
	if err != nil {
		return nil, fmt.Errorf("error loading Swagger: %s", err)
	}
	return swagger, nil
}
