// Package v2 provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen version v1.8.2 DO NOT EDIT.
package v2

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

const (
	BearerScopes = "Bearer.Scopes"
)

// Defines values for ComposeStatusValue.
const (
	ComposeStatusValueFailure ComposeStatusValue = "failure"

	ComposeStatusValuePending ComposeStatusValue = "pending"

	ComposeStatusValueSuccess ComposeStatusValue = "success"
)

// Defines values for ImageStatusValue.
const (
	ImageStatusValueBuilding ImageStatusValue = "building"

	ImageStatusValueFailure ImageStatusValue = "failure"

	ImageStatusValuePending ImageStatusValue = "pending"

	ImageStatusValueRegistering ImageStatusValue = "registering"

	ImageStatusValueSuccess ImageStatusValue = "success"

	ImageStatusValueUploading ImageStatusValue = "uploading"
)

// Defines values for ImageTypes.
const (
	ImageTypesAws ImageTypes = "aws"

	ImageTypesAwsHaRhui ImageTypes = "aws-ha-rhui"

	ImageTypesAwsRhui ImageTypes = "aws-rhui"

	ImageTypesAwsSapRhui ImageTypes = "aws-sap-rhui"

	ImageTypesAzure ImageTypes = "azure"

	ImageTypesEdgeCommit ImageTypes = "edge-commit"

	ImageTypesEdgeContainer ImageTypes = "edge-container"

	ImageTypesEdgeInstaller ImageTypes = "edge-installer"

	ImageTypesGcp ImageTypes = "gcp"

	ImageTypesGuestImage ImageTypes = "guest-image"

	ImageTypesImageInstaller ImageTypes = "image-installer"

	ImageTypesVsphere ImageTypes = "vsphere"
)

// Defines values for UploadStatusValue.
const (
	UploadStatusValueFailure UploadStatusValue = "failure"

	UploadStatusValuePending UploadStatusValue = "pending"

	UploadStatusValueRunning UploadStatusValue = "running"

	UploadStatusValueSuccess UploadStatusValue = "success"
)

// Defines values for UploadTypes.
const (
	UploadTypesAws UploadTypes = "aws"

	UploadTypesAwsS3 UploadTypes = "aws.s3"

	UploadTypesAzure UploadTypes = "azure"

	UploadTypesGcp UploadTypes = "gcp"
)

// AWSEC2UploadOptions defines model for AWSEC2UploadOptions.
type AWSEC2UploadOptions struct {
	Region            string   `json:"region"`
	ShareWithAccounts []string `json:"share_with_accounts"`
	SnapshotName      *string  `json:"snapshot_name,omitempty"`
}

// AWSEC2UploadStatus defines model for AWSEC2UploadStatus.
type AWSEC2UploadStatus struct {
	Ami    string `json:"ami"`
	Region string `json:"region"`
}

// AWSS3UploadOptions defines model for AWSS3UploadOptions.
type AWSS3UploadOptions struct {
	Region string `json:"region"`
}

// AWSS3UploadStatus defines model for AWSS3UploadStatus.
type AWSS3UploadStatus struct {
	Url string `json:"url"`
}

// AzureUploadOptions defines model for AzureUploadOptions.
type AzureUploadOptions struct {
	// Name of the uploaded image. It must be unique in the given resource group.
	// If name is omitted from the request, a random one based on a UUID is
	// generated.
	ImageName *string `json:"image_name,omitempty"`

	// Location where the image should be uploaded and registered.
	// How to list all locations:
	// https://docs.microsoft.com/en-us/cli/azure/account?view=azure-cli-latest#az_account_list_locations'
	Location string `json:"location"`

	// Name of the resource group where the image should be uploaded.
	ResourceGroup string `json:"resource_group"`

	// ID of subscription where the image should be uploaded.
	SubscriptionId string `json:"subscription_id"`

	// ID of the tenant where the image should be uploaded.
	// How to find it in the Azure Portal:
	// https://docs.microsoft.com/en-us/azure/active-directory/fundamentals/active-directory-how-to-find-tenant
	TenantId string `json:"tenant_id"`
}

// AzureUploadStatus defines model for AzureUploadStatus.
type AzureUploadStatus struct {
	ImageName string `json:"image_name"`
}

// ComposeId defines model for ComposeId.
type ComposeId struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// ComposeLogs defines model for ComposeLogs.
type ComposeLogs struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageBuilds []interface{} `json:"image_builds"`
	Koji        *KojiLogs     `json:"koji,omitempty"`
}

// ComposeManifests defines model for ComposeManifests.
type ComposeManifests struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Manifests []interface{} `json:"manifests"`
}

// ComposeMetadata defines model for ComposeMetadata.
type ComposeMetadata struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// ID (hash) of the built commit
	OstreeCommit *string `json:"ostree_commit,omitempty"`

	// Package list including NEVRA
	Packages *[]PackageMetadata `json:"packages,omitempty"`
}

// ComposeRequest defines model for ComposeRequest.
type ComposeRequest struct {
	Customizations *Customizations `json:"customizations,omitempty"`
	Distribution   string          `json:"distribution"`
	ImageRequest   *ImageRequest   `json:"image_request,omitempty"`
	ImageRequests  *[]ImageRequest `json:"image_requests,omitempty"`
	Koji           *Koji           `json:"koji,omitempty"`
}

// ComposeStatus defines model for ComposeStatus.
type ComposeStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageStatus   ImageStatus        `json:"image_status"`
	ImageStatuses *[]ImageStatus     `json:"image_statuses,omitempty"`
	KojiStatus    *KojiStatus        `json:"koji_status,omitempty"`
	Status        ComposeStatusValue `json:"status"`
}

// ComposeStatusValue defines model for ComposeStatusValue.
type ComposeStatusValue string

// Customizations defines model for Customizations.
type Customizations struct {
	Packages            *[]string     `json:"packages,omitempty"`
	PayloadRepositories *[]Repository `json:"payload_repositories,omitempty"`
	Subscription        *Subscription `json:"subscription,omitempty"`
	Users               *[]User       `json:"users,omitempty"`
}

// Error defines model for Error.
type Error struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Code        string `json:"code"`
	OperationId string `json:"operation_id"`
	Reason      string `json:"reason"`
}

// ErrorList defines model for ErrorList.
type ErrorList struct {
	// Embedded struct due to allOf(#/components/schemas/List)
	List `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Items []Error `json:"items"`
}

// GCPUploadOptions defines model for GCPUploadOptions.
type GCPUploadOptions struct {
	// Name of an existing STANDARD Storage class Bucket.
	Bucket string `json:"bucket"`

	// The name to use for the imported and shared Compute Engine image.
	// The image name must be unique within the GCP project, which is used
	// for the OS image upload and import. If not specified a random
	// 'composer-api-<uuid>' string is used as the image name.
	ImageName *string `json:"image_name,omitempty"`

	// The GCP region where the OS image will be imported to and shared from.
	// The value must be a valid GCP location. See https://cloud.google.com/storage/docs/locations.
	// If not specified, the multi-region location closest to the source
	// (source Storage Bucket location) is chosen automatically.
	Region string `json:"region"`

	// List of valid Google accounts to share the imported Compute Engine image with.
	// Each string must contain a specifier of the account type. Valid formats are:
	//   - 'user:{emailid}': An email address that represents a specific
	//     Google account. For example, 'alice@example.com'.
	//   - 'serviceAccount:{emailid}': An email address that represents a
	//     service account. For example, 'my-other-app@appspot.gserviceaccount.com'.
	//   - 'group:{emailid}': An email address that represents a Google group.
	//     For example, 'admins@example.com'.
	//   - 'domain:{domain}': The G Suite domain (primary) that represents all
	//     the users of that domain. For example, 'google.com' or 'example.com'.
	// If not specified, the imported Compute Engine image is not shared with any
	// account.
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// GCPUploadStatus defines model for GCPUploadStatus.
type GCPUploadStatus struct {
	ImageName string `json:"image_name"`
	ProjectId string `json:"project_id"`
}

// ImageRequest defines model for ImageRequest.
type ImageRequest struct {
	Architecture  string         `json:"architecture"`
	ImageType     ImageTypes     `json:"image_type"`
	Ostree        *OSTree        `json:"ostree,omitempty"`
	Repositories  []Repository   `json:"repositories"`
	UploadOptions *UploadOptions `json:"upload_options,omitempty"`
}

// ImageStatus defines model for ImageStatus.
type ImageStatus struct {
	Status       ImageStatusValue `json:"status"`
	UploadStatus *UploadStatus    `json:"upload_status,omitempty"`
}

// ImageStatusValue defines model for ImageStatusValue.
type ImageStatusValue string

// ImageTypes defines model for ImageTypes.
type ImageTypes string

// Koji defines model for Koji.
type Koji struct {
	Name    string `json:"name"`
	Release string `json:"release"`
	Server  string `json:"server"`
	TaskId  int    `json:"task_id"`
	Version string `json:"version"`
}

// KojiLogs defines model for KojiLogs.
type KojiLogs struct {
	Import interface{} `json:"import"`
	Init   interface{} `json:"init"`
}

// KojiStatus defines model for KojiStatus.
type KojiStatus struct {
	BuildId *int `json:"build_id,omitempty"`
}

// List defines model for List.
type List struct {
	Kind  string `json:"kind"`
	Page  int    `json:"page"`
	Size  int    `json:"size"`
	Total int    `json:"total"`
}

// OSTree defines model for OSTree.
type OSTree struct {
	Ref *string `json:"ref,omitempty"`
	Url *string `json:"url,omitempty"`
}

// ObjectReference defines model for ObjectReference.
type ObjectReference struct {
	Href string `json:"href"`
	Id   string `json:"id"`
	Kind string `json:"kind"`
}

// PackageMetadata defines model for PackageMetadata.
type PackageMetadata struct {
	Arch      string  `json:"arch"`
	Epoch     *string `json:"epoch,omitempty"`
	Name      string  `json:"name"`
	Release   string  `json:"release"`
	Sigmd5    string  `json:"sigmd5"`
	Signature *string `json:"signature,omitempty"`
	Type      string  `json:"type"`
	Version   string  `json:"version"`
}

// Repository defines model for Repository.
type Repository struct {
	Baseurl    *string `json:"baseurl,omitempty"`
	CheckGpg   *bool   `json:"check_gpg,omitempty"`
	GpgKey     *string `json:"gpg_key,omitempty"`
	IgnoreSsl  *bool   `json:"ignore_ssl,omitempty"`
	Metalink   *string `json:"metalink,omitempty"`
	Mirrorlist *string `json:"mirrorlist,omitempty"`
	Rhsm       bool    `json:"rhsm"`
}

// Subscription defines model for Subscription.
type Subscription struct {
	ActivationKey string `json:"activation_key"`
	BaseUrl       string `json:"base_url"`
	Insights      bool   `json:"insights"`
	Organization  string `json:"organization"`
	ServerUrl     string `json:"server_url"`
}

// UploadOptions defines model for UploadOptions.
type UploadOptions interface{}

// UploadStatus defines model for UploadStatus.
type UploadStatus struct {
	Options interface{}       `json:"options"`
	Status  UploadStatusValue `json:"status"`
	Type    UploadTypes       `json:"type"`
}

// UploadStatusValue defines model for UploadStatusValue.
type UploadStatusValue string

// UploadTypes defines model for UploadTypes.
type UploadTypes string

// User defines model for User.
type User struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Groups *[]string `json:"groups,omitempty"`
	Key    *string   `json:"key,omitempty"`
	Name   string    `json:"name"`
}

// Page defines model for page.
type Page string

// Size defines model for size.
type Size string

// PostComposeJSONBody defines parameters for PostCompose.
type PostComposeJSONBody ComposeRequest

// GetErrorListParams defines parameters for GetErrorList.
type GetErrorListParams struct {
	// Page index
	Page *Page `json:"page,omitempty"`

	// Number of items in each page
	Size *Size `json:"size,omitempty"`
}

// PostComposeJSONRequestBody defines body for PostCompose for application/json ContentType.
type PostComposeJSONRequestBody PostComposeJSONBody

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Create compose
	// (POST /compose)
	PostCompose(ctx echo.Context) error
	// The status of a compose
	// (GET /composes/{id})
	GetComposeStatus(ctx echo.Context, id string) error
	// Get logs for a compose.
	// (GET /composes/{id}/logs)
	GetComposeLogs(ctx echo.Context, id string) error
	// Get the manifests for a compose.
	// (GET /composes/{id}/manifests)
	GetComposeManifests(ctx echo.Context, id string) error
	// Get the metadata for a compose.
	// (GET /composes/{id}/metadata)
	GetComposeMetadata(ctx echo.Context, id string) error
	// Get a list of all possible errors
	// (GET /errors)
	GetErrorList(ctx echo.Context, params GetErrorListParams) error
	// Get error description
	// (GET /errors/{id})
	GetError(ctx echo.Context, id string) error
	// Get the openapi spec in json format
	// (GET /openapi)
	GetOpenapi(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// PostCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCompose(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCompose(ctx)
	return err
}

// GetComposeStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeStatus(ctx, id)
	return err
}

// GetComposeLogs converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeLogs(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeLogs(ctx, id)
	return err
}

// GetComposeManifests converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeManifests(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeManifests(ctx, id)
	return err
}

// GetComposeMetadata converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeMetadata(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeMetadata(ctx, id)
	return err
}

// GetErrorList converts echo context to params.
func (w *ServerInterfaceWrapper) GetErrorList(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetErrorListParams
	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", ctx.QueryParams(), &params.Page)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter page: %s", err))
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", ctx.QueryParams(), &params.Size)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter size: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetErrorList(ctx, params)
	return err
}

// GetError converts echo context to params.
func (w *ServerInterfaceWrapper) GetError(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetError(ctx, id)
	return err
}

// GetOpenapi converts echo context to params.
func (w *ServerInterfaceWrapper) GetOpenapi(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetOpenapi(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface) {
	RegisterHandlersWithBaseURL(router, si, "")
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.POST(baseURL+"/compose", wrapper.PostCompose)
	router.GET(baseURL+"/composes/:id", wrapper.GetComposeStatus)
	router.GET(baseURL+"/composes/:id/logs", wrapper.GetComposeLogs)
	router.GET(baseURL+"/composes/:id/manifests", wrapper.GetComposeManifests)
	router.GET(baseURL+"/composes/:id/metadata", wrapper.GetComposeMetadata)
	router.GET(baseURL+"/errors", wrapper.GetErrorList)
	router.GET(baseURL+"/errors/:id", wrapper.GetError)
	router.GET(baseURL+"/openapi", wrapper.GetOpenapi)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+xce2/buLL/KoTOBbqLK9mKH2liYLEnTbM92W2bIkn34N4mCGhpbLGRSC1JxXGKfPcL",
	"PiTrQT+ym91zz0H+aWyLnBn+ODOcB9VvXsSynFGgUniTb16OOc5AArff5qD+xiAiTnJJGPUm3ic8B0Ro",
	"DPee78E9zvIUGsPvcFqAN/H2vMdH3yNqzm8F8KXnexRn6oke6XsiSiDDaopc5up3ITmhcz1NkAcH749F",
	"NgWO2AwRCZlAhCLAUYIswbo0JYFKmjBcK48eu0mex/KhJn30z4uT48HnPGU4PtOimfVzlgOXxPDnMNcy",
	"fyul8iYeFMEChAz2PL/NwvdEgjncLIhMbnAUscJuSTX7i7c3GI7G+68PDsO9gXftexoDh7gVccw5Xmra",
	"FOciYfLGLLguU7YMyqddqR59j8NvBeEQKwHsmtyyXlez2fQrRFLxrSN1IbEsHEDhjDQlwhkJwuhgGL4+",
	"HL5+PR4fjuPR1IXYEyFuLUbxrWisEf5i+Ly77MZzC/N1wBU8ddtOnYUa5KT/UHDYsjiS4TlUKtOyRJyB",
	"skOZACo0GYiRntBDpxJlhZBoCqig5LdCuQs9cE7ugCIOghU8AjTnrMh7V/R0hhQTRARiGZESYjTjLNNT",
	"1FpASB9hxDGNWYYYBTTFAmLEKMLo8+fTt4iIKzoHChxLiHtXdOULjIZrwVwqlLIIS7uDzQW+t0/QIgEO",
	"WhZNBYmEFWmsF1euG9MYqb0UErjm/w+2QJKhlAiJcJqiko2YXNFEylxM+v2YRaKXkYgzwWayF7GsDzQo",
	"RD9KSR+r7elb2/rxjsDiB/1TEKUkSLEEIf+GH0rju1GMbiomr1oAKG2EQm2t24rMdtzo7di8082t2wGa",
	"9l5csiLC9NySeac5unxhMa1EuCFxV6jTt0qk+rDfIcwIxvHBdBAFeDoYBaPR3jA4DKNxsL83GIb7cBAe",
	"wsAlnQSKqdwglxLCDNpNKqsuM0JjRGRpLdpE0SfGJU530ZtSZyS5gyAmHCLJ+LI/K2iMM6ASp6LzNEjY",
	"IpAsUKwDI3ILpHH0Gmbj6X6wFw1nwSjGYYD3B4MgnIb74WB4GL+OX291dCvEunvb0cCaVW7xXOs8Y9Nx",
	"7eIJWvLWCLhEOFZBk4BTrQA4Tc9m3uTLN++/OMy8ife3/iqo6tuwoX+mJ5/DDDjQCLxHvyN03BR2bzAE",
	"ddwHcHA4DfYG8TDAo/F+MBrs74/Ho1EYhqHnezPGMyy9iVcUGswtC4sdC7peLek9m4tnXZQGclqQNK5H",
	"KlVgcsu+6tN/E5df2Fei5XLvkiW+cVkfMCUzEPJZ15bViTYX1hJ0NXKzlCBxjCV+TiGZkBzgJmJZRqTT",
	"X32XYJF8X7othaZEdrjD9+U4usVzQ7udF+gn5tAjNEqLmNA5+njy6/mRVwtWN63H0qiA6ISyj5vwOzex",
	"QtcfRIWQLCMPuAp0Nglx3Bz96HsxUQBMC9mJ9XgCaXDgAsooJ1+JtInlqRpcit+ebAxpF/jaZH6vtXUU",
	"uAFADfGVA35ehyEquluXa0WoQDNT4Ymgrai4MNtRHgXditBucxpA/qpz1Tb4llBzgZs9SZ2c0ldaZJpS",
	"EUUgFKkZJmnB1UGYA1V2quit1Ho1sKPXxx1bam5g3UHUctecCTnnIJ6Wt+Z4qc75Gw45E0QyTp6wsefl",
	"pKUzJa6FIdsoXdTHPvpeIWyFZCc5Pgvgu3gy3zvhnPHntKaIxeAEWg3CtejakRVgYYDZHFBoDtXwFmG3",
	"jupVvifGK+62Uj3a4SxK+HfaB4OuayMaQYUm5Zb83fGnLSnztIhuQa5PojBFcE+EVCfjxeXRx7dH52/R",
	"hWRcnZxRioVAbzSJXjuFtV8Cy2HtieNO1y8TMDm2ZKgQgGaM26QkZ1zaFFZXdWKkfEghAZ3QOaE2b+ld",
	"0csqh9GEWhn+gsjE5i3vjj+hnDMFm48WCYkSldkXAuIrWvI9u7C0TBak2RtZeuh0hiiTSOQQkRlRstnU",
	"/4q+iox/4wHOSXBVhOEwUnGv/gSvkAGjZIewqGVeSuqnlAZWpZ0ulGqJ5nktwavWtCBpqqCpwJWsju+M",
	"s8ziqYuTFZRYfSexpl6mQD10AYDK3C9KWRH35ozNU9CZnzCqo5PCflUAsDWVOoi+FjErUkkCK3k5HEUp",
	"EyCkElMNMsnYFf3O5vqlehrFrKZ9r2COEiaAIlxIlmFJIpymyzbIUDyh3NkqwqhYks1KXPS6UTlcyaup",
	"NDXZpb5aPXtX9ARHSakkGvWIUYkJRbhCipeRsGWDlOQ99KuWwCRbAmEOkyuKUIBeqbNg8g0yTFISP76a",
	"oCOK9DeE45iDUCqIJeKQcxDKH614RYoEai2rh35iHFn0fPQKpySCv9vvas9f9SxnAfyORHBk5j1RBsPa",
	"kljHO1sGTCba2vK/4zwXOZO9uZ1UzqmLpBP4p6Jh119WA5VcLQjijFDhxCBmGSZ08s38VQy1eaKLgkhA",
	"5lf0Xc5Jhvny+y7zNDUMdRlTnepm97G0c9uIrEzvFWIcvWrJ5La6zapJhJljnINSVITp8oqW+Dat6YsO",
	"PiYdrfB8r6UPu26e53tm27owe75nAa7/+IQIbl3/wB5irtpKdcY+X3HH9+xxdNOusWARAY0xlcGUYxIH",
	"w3A43hturaLUyPnbakWNnKzb/OBRQiREUgXjDdHuD/Zv9kfrz3nz8w6pzeUyB52QmFLAtjlnF5dqlF7x",
	"swfd5rS/YflOiXgz1ur0b+rQNVBpiX5d7sI6jXpytmnztGo9uxFoqPWaJK8l65MyOGVWJLUfjWTmc9ma",
	"sGleR6FqalJjhReKDV6IgCcFsR8TXP8mcF59fTDCQDyHoCof2W/6jAVe/kCokDhN9Q/zKFf/KuuozFf/",
	"bYy6E7kKs5zS/2KLGs097fqHnyBmHAfHKoQK3mCxJuhLQT1qzByEgzA8DF/3QmcgA/wOeHNGGa/dsq+k",
	"N9OMrc/oMT7XPyfFtFG95amz1YDFbdtrjQbVQEIlzE12eQdcdMpTw+09SCv+ipXtiq8orlBx+beqOutw",
	"1OrY8ybfdNddVx87yRbVamJHriO/zm61uu+CjivXLhPQJslbQt35cHm5oQt8edGg+0QyiVPXoxYKmqlf",
	"3YowlxHMZH9tPup71lM7etKzbpGyf9A3J0pfmaBL1da2k7uMW3WHjgSJFaF7dLnBXYN6t3fhl1hpDi5Q",
	"2hVk54nrFAJytuZJ6Us2eYuuWyDzLB6ve0RxeeKviaAcD2oWvqXbZg7BtWbsGxAqGdWhUzu3u3aGBVjt",
	"6Lq4KKY9DnGCTStSOXugsh8TIftK8Q5WmqfoMNFnor+D54sSiG5v5vm8tt4pYylgXYKb5/ObW1i6tWxO",
	"GYcbIVL33AwkTgm9dS8oI5wzLhxuu5z3owovfjDPg+HgqgjDwb6C9IcqaNu2OsMktT6oKUQlg3rci4BK",
	"JjT/H+0G/nAQqFAOZzXOWP27PzK/aPnUEXd2sYMsPBGZC6h28K6GuUzuolVJbdlbJMmdqQja/WrePYKI",
	"gwzUo5qkORZiwXjsEldp0Y1THbvauMPqCRVknrTuWklegO/QHMbnmNradztGGIXDwWh9gNAVuV6B7il0",
	"a5JvPbYbkvhtlBtMa5DVluvayU5xk1HYoTrrug/36G+d075ctW1Kp/q6lUf3jpMu427OL9kfWX7V/tl5",
	"9TvOaKfFT1h7OeN656ZUfV6V6+yScJqJNuNc18ayx1OJc3tHnpjz8ILSdYlNXRxXZtMTwyoFMQmMk4qA",
	"Z23K6GpLM6NeOQX90Hk/tNOYbHtTIZIA4sF4vHeIjo6Ojo6HHx/w8V76v29P9z5enozVb6cf+btfTviH",
	"/yH//eHD50XxD3x+9HN2/p6dPpzPBr+9HcRvxw/hm8v7/v69S4huWlUI4NuzjDXlkWt9sxaighO5vFAI",
	"GojeAOYG9Kn+9FPpxH/+52V5UVe7ZjOuoqtOAXNdl9AZ69aTL2y9UzJ90cH2HUyiacpxouf5XkoioCau",
	"szeEj3IcJYAGOgXUnryKFxaLRQ/rx/qQtnNF//3p8cnHi5Ng0At7icxSvYdEatDOLt5o9rZdy5Eu7COc",
	"k1rANvEGtlVH1YOJN+yFvT2dKMhEw9S37RDtxJhw9J2OOWAJCCMKC2RH+yhnKkYjOE2XKGJU2IYUmyEB",
	"d8BxiYWGx3Zo9D1r0yEgHMWgpthuQ73tdxp7E+8TE9IuzTN6AEK+YfHS9CR1hKgtKs9TYroJ/a+23bi6",
	"hL1D27y669DUN3V8m5uNOaP2LsAg3Htu7qexYdyC3DxECRZISMwlxGobR2H4bPxtJ7PL+5SaTond6fL2",
	"rOG/9+fzPyqkUpJboIgIRIw0hvvwz+f+meJCJoyTB9Nzy4Gr6A9VymkkGf0VktxStqDVPhgQxn+FCnym",
	"cJ9DJCFGoMYgFkUFV2ZR97X6GCu97Jfrx2vfE0WWYZX+lU6jdC5qXulpRP8biR/1KeZqc78DaVqI+iTX",
	"DW9kD2jEuKaYghLNktNtUK0pUVrEINAiAZkAV4MpM7RKDHUYADHEXX/zDmTzQpLfeJPli/uWbkXYCCsZ",
	"muvGun5DRPnY1Qsi9ppq3b/UXxd59kub1x3nFT6386rq0B0NauLyL/NdpeN4cVsvbmsnt3XZcjzr/Vc/",
	"tQXr3+PEZoQSkdR8GNrowohceS5fB1Q4FQxlIDFSQapyBIRRhKeskOVLFkUqN3k5XW9/8XFbfZy9Nd5R",
	"NqUpSgWqa1DmxaQqPiYUUYZyzCWJihRze+8DfScTVswTex3l54uzj9/33P5Rwr3s5ykmLaEdLxbu5gVH",
	"z8XAZeOPdTN6p+/4WHAqK+q5zKhxA36jLVUjdzCnc5AFp0K/6FXO08LoFMRemqD1t8N6SF/sqQZHTBuW",
	"KG802e2LYUYoxAhLVE/emNC5oCnxYtq334OSXG+8wRRXbxa82ONWe1yBtcYoG9vdMcz/TFtrmscORldr",
	"bW22OTvQmFzHzswNRLjHkWwcRFybH8QohhxorOywbmvla57mXtwmyyjlfDGM7YZRvfCyxi7KrXyKXbzE",
	"6C8x+v+3GL3jm1z+ThOvxxQdF7N6haDjXFwrWw3p60sW65ontXH6FsafavqrNbi03bxGx2bIgvFiZv8a",
	"MzOK/u9nZLhSIJymKGdCkGkKlTatzGx7QQ9T0yKhUfX/ABjJVm9oTJdIH51uQ90tAqjo/tFTf/gXn+HV",
	"Vr7Y6IuNPsVGzdw6aW2XVcNv/fl3Zoe4tboprCWnrVXlzQoDmxH/O0YOG5fzWF23cfmZD/ZlEBYXkXmD",
	"qbr82mzp4pz0FB+REPs/bOCc9M21ZF0bAB6Ub6L17wY6nmg1miWeEzrfxEBIPIc/yEaDSMuXVSo22+hc",
	"P/5fAAAA//8K77R2+UsAAA==",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
