// Package v2 provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen version v1.8.2 DO NOT EDIT.
package v2

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

const (
	BearerScopes = "Bearer.Scopes"
)

// Defines values for ComposeStatusValue.
const (
	ComposeStatusValueFailure ComposeStatusValue = "failure"

	ComposeStatusValuePending ComposeStatusValue = "pending"

	ComposeStatusValueSuccess ComposeStatusValue = "success"
)

// Defines values for ImageStatusValue.
const (
	ImageStatusValueBuilding ImageStatusValue = "building"

	ImageStatusValueFailure ImageStatusValue = "failure"

	ImageStatusValuePending ImageStatusValue = "pending"

	ImageStatusValueRegistering ImageStatusValue = "registering"

	ImageStatusValueSuccess ImageStatusValue = "success"

	ImageStatusValueUploading ImageStatusValue = "uploading"
)

// Defines values for ImageTypes.
const (
	ImageTypesAws ImageTypes = "aws"

	ImageTypesAwsHaRhui ImageTypes = "aws-ha-rhui"

	ImageTypesAwsRhui ImageTypes = "aws-rhui"

	ImageTypesAwsSapRhui ImageTypes = "aws-sap-rhui"

	ImageTypesAzure ImageTypes = "azure"

	ImageTypesAzureRhui ImageTypes = "azure-rhui"

	ImageTypesEdgeCommit ImageTypes = "edge-commit"

	ImageTypesEdgeContainer ImageTypes = "edge-container"

	ImageTypesEdgeInstaller ImageTypes = "edge-installer"

	ImageTypesGcp ImageTypes = "gcp"

	ImageTypesGuestImage ImageTypes = "guest-image"

	ImageTypesImageInstaller ImageTypes = "image-installer"

	ImageTypesVsphere ImageTypes = "vsphere"
)

// Defines values for UploadStatusValue.
const (
	UploadStatusValueFailure UploadStatusValue = "failure"

	UploadStatusValuePending UploadStatusValue = "pending"

	UploadStatusValueRunning UploadStatusValue = "running"

	UploadStatusValueSuccess UploadStatusValue = "success"
)

// Defines values for UploadTypes.
const (
	UploadTypesAws UploadTypes = "aws"

	UploadTypesAwsS3 UploadTypes = "aws.s3"

	UploadTypesAzure UploadTypes = "azure"

	UploadTypesGcp UploadTypes = "gcp"
)

// AWSEC2UploadOptions defines model for AWSEC2UploadOptions.
type AWSEC2UploadOptions struct {
	Region            string   `json:"region"`
	ShareWithAccounts []string `json:"share_with_accounts"`
	SnapshotName      *string  `json:"snapshot_name,omitempty"`
}

// AWSEC2UploadStatus defines model for AWSEC2UploadStatus.
type AWSEC2UploadStatus struct {
	Ami    string `json:"ami"`
	Region string `json:"region"`
}

// AWSS3UploadOptions defines model for AWSS3UploadOptions.
type AWSS3UploadOptions struct {
	Region string `json:"region"`
}

// AWSS3UploadStatus defines model for AWSS3UploadStatus.
type AWSS3UploadStatus struct {
	Url string `json:"url"`
}

// AzureUploadOptions defines model for AzureUploadOptions.
type AzureUploadOptions struct {
	// Name of the uploaded image. It must be unique in the given resource group.
	// If name is omitted from the request, a random one based on a UUID is
	// generated.
	ImageName *string `json:"image_name,omitempty"`

	// Location where the image should be uploaded and registered.
	// How to list all locations:
	// https://docs.microsoft.com/en-us/cli/azure/account?view=azure-cli-latest#az_account_list_locations'
	Location string `json:"location"`

	// Name of the resource group where the image should be uploaded.
	ResourceGroup string `json:"resource_group"`

	// ID of subscription where the image should be uploaded.
	SubscriptionId string `json:"subscription_id"`

	// ID of the tenant where the image should be uploaded.
	// How to find it in the Azure Portal:
	// https://docs.microsoft.com/en-us/azure/active-directory/fundamentals/active-directory-how-to-find-tenant
	TenantId string `json:"tenant_id"`
}

// AzureUploadStatus defines model for AzureUploadStatus.
type AzureUploadStatus struct {
	ImageName string `json:"image_name"`
}

// ComposeId defines model for ComposeId.
type ComposeId struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// ComposeLogs defines model for ComposeLogs.
type ComposeLogs struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageBuilds []interface{} `json:"image_builds"`
	Koji        *KojiLogs     `json:"koji,omitempty"`
}

// ComposeManifests defines model for ComposeManifests.
type ComposeManifests struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Manifests []interface{} `json:"manifests"`
}

// ComposeMetadata defines model for ComposeMetadata.
type ComposeMetadata struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// ID (hash) of the built commit
	OstreeCommit *string `json:"ostree_commit,omitempty"`

	// Package list including NEVRA
	Packages *[]PackageMetadata `json:"packages,omitempty"`
}

// ComposeRequest defines model for ComposeRequest.
type ComposeRequest struct {
	Customizations *Customizations `json:"customizations,omitempty"`
	Distribution   string          `json:"distribution"`
	ImageRequest   *ImageRequest   `json:"image_request,omitempty"`
	ImageRequests  *[]ImageRequest `json:"image_requests,omitempty"`
	Koji           *Koji           `json:"koji,omitempty"`
}

// ComposeStatus defines model for ComposeStatus.
type ComposeStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageStatus   ImageStatus        `json:"image_status"`
	ImageStatuses *[]ImageStatus     `json:"image_statuses,omitempty"`
	KojiStatus    *KojiStatus        `json:"koji_status,omitempty"`
	Status        ComposeStatusValue `json:"status"`
}

// ComposeStatusValue defines model for ComposeStatusValue.
type ComposeStatusValue string

// Customizations defines model for Customizations.
type Customizations struct {
	Filesystem *[]Filesystem `json:"filesystem,omitempty"`
	Packages   *[]string     `json:"packages,omitempty"`

	// Extra repositories for packages specified in customizations. These
	// repositories will only be used to depsolve and retrieve packages
	// for the OS itself (they will not be available for the build root or
	// any other part of the build process). The package_sets field for these
	// repositories is ignored.
	PayloadRepositories *[]Repository `json:"payload_repositories,omitempty"`
	Subscription        *Subscription `json:"subscription,omitempty"`
	Users               *[]User       `json:"users,omitempty"`
}

// Error defines model for Error.
type Error struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Code        string `json:"code"`
	OperationId string `json:"operation_id"`
	Reason      string `json:"reason"`
}

// ErrorList defines model for ErrorList.
type ErrorList struct {
	// Embedded struct due to allOf(#/components/schemas/List)
	List `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Items []Error `json:"items"`
}

// Filesystem defines model for Filesystem.
type Filesystem struct {
	MinSize    int    `json:"min_size"`
	Mountpoint string `json:"mountpoint"`
}

// GCPUploadOptions defines model for GCPUploadOptions.
type GCPUploadOptions struct {
	// Name of an existing STANDARD Storage class Bucket.
	Bucket string `json:"bucket"`

	// The name to use for the imported and shared Compute Engine image.
	// The image name must be unique within the GCP project, which is used
	// for the OS image upload and import. If not specified a random
	// 'composer-api-<uuid>' string is used as the image name.
	ImageName *string `json:"image_name,omitempty"`

	// The GCP region where the OS image will be imported to and shared from.
	// The value must be a valid GCP location. See https://cloud.google.com/storage/docs/locations.
	// If not specified, the multi-region location closest to the source
	// (source Storage Bucket location) is chosen automatically.
	Region string `json:"region"`

	// List of valid Google accounts to share the imported Compute Engine image with.
	// Each string must contain a specifier of the account type. Valid formats are:
	//   - 'user:{emailid}': An email address that represents a specific
	//     Google account. For example, 'alice@example.com'.
	//   - 'serviceAccount:{emailid}': An email address that represents a
	//     service account. For example, 'my-other-app@appspot.gserviceaccount.com'.
	//   - 'group:{emailid}': An email address that represents a Google group.
	//     For example, 'admins@example.com'.
	//   - 'domain:{domain}': The G Suite domain (primary) that represents all
	//     the users of that domain. For example, 'google.com' or 'example.com'.
	// If not specified, the imported Compute Engine image is not shared with any
	// account.
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// GCPUploadStatus defines model for GCPUploadStatus.
type GCPUploadStatus struct {
	ImageName string `json:"image_name"`
	ProjectId string `json:"project_id"`
}

// ImageRequest defines model for ImageRequest.
type ImageRequest struct {
	Architecture  string         `json:"architecture"`
	ImageType     ImageTypes     `json:"image_type"`
	Ostree        *OSTree        `json:"ostree,omitempty"`
	Repositories  []Repository   `json:"repositories"`
	UploadOptions *UploadOptions `json:"upload_options,omitempty"`
}

// ImageStatus defines model for ImageStatus.
type ImageStatus struct {
	Status       ImageStatusValue `json:"status"`
	UploadStatus *UploadStatus    `json:"upload_status,omitempty"`
}

// ImageStatusValue defines model for ImageStatusValue.
type ImageStatusValue string

// ImageTypes defines model for ImageTypes.
type ImageTypes string

// Koji defines model for Koji.
type Koji struct {
	Name    string `json:"name"`
	Release string `json:"release"`
	Server  string `json:"server"`
	TaskId  int    `json:"task_id"`
	Version string `json:"version"`
}

// KojiLogs defines model for KojiLogs.
type KojiLogs struct {
	Import interface{} `json:"import"`
	Init   interface{} `json:"init"`
}

// KojiStatus defines model for KojiStatus.
type KojiStatus struct {
	BuildId *int `json:"build_id,omitempty"`
}

// List defines model for List.
type List struct {
	Kind  string `json:"kind"`
	Page  int    `json:"page"`
	Size  int    `json:"size"`
	Total int    `json:"total"`
}

// OSTree defines model for OSTree.
type OSTree struct {
	Parent *string `json:"parent,omitempty"`
	Ref    *string `json:"ref,omitempty"`
	Url    *string `json:"url,omitempty"`
}

// ObjectReference defines model for ObjectReference.
type ObjectReference struct {
	Href string `json:"href"`
	Id   string `json:"id"`
	Kind string `json:"kind"`
}

// PackageMetadata defines model for PackageMetadata.
type PackageMetadata struct {
	Arch      string  `json:"arch"`
	Epoch     *string `json:"epoch,omitempty"`
	Name      string  `json:"name"`
	Release   string  `json:"release"`
	Sigmd5    string  `json:"sigmd5"`
	Signature *string `json:"signature,omitempty"`
	Type      string  `json:"type"`
	Version   string  `json:"version"`
}

// Repository defines model for Repository.
type Repository struct {
	Baseurl    *string `json:"baseurl,omitempty"`
	CheckGpg   *bool   `json:"check_gpg,omitempty"`
	GpgKey     *string `json:"gpg_key,omitempty"`
	IgnoreSsl  *bool   `json:"ignore_ssl,omitempty"`
	Metalink   *string `json:"metalink,omitempty"`
	Mirrorlist *string `json:"mirrorlist,omitempty"`

	// Naming package sets for a repository assigns it to a specific part
	// (pipeline) of the build process.
	PackageSets *[]string `json:"package_sets,omitempty"`
	Rhsm        bool      `json:"rhsm"`
}

// Subscription defines model for Subscription.
type Subscription struct {
	ActivationKey string `json:"activation_key"`
	BaseUrl       string `json:"base_url"`
	Insights      bool   `json:"insights"`
	Organization  string `json:"organization"`
	ServerUrl     string `json:"server_url"`
}

// UploadOptions defines model for UploadOptions.
type UploadOptions interface{}

// UploadStatus defines model for UploadStatus.
type UploadStatus struct {
	Options interface{}       `json:"options"`
	Status  UploadStatusValue `json:"status"`
	Type    UploadTypes       `json:"type"`
}

// UploadStatusValue defines model for UploadStatusValue.
type UploadStatusValue string

// UploadTypes defines model for UploadTypes.
type UploadTypes string

// User defines model for User.
type User struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Groups *[]string `json:"groups,omitempty"`
	Key    *string   `json:"key,omitempty"`
	Name   string    `json:"name"`
}

// Page defines model for page.
type Page string

// Size defines model for size.
type Size string

// PostComposeJSONBody defines parameters for PostCompose.
type PostComposeJSONBody ComposeRequest

// GetErrorListParams defines parameters for GetErrorList.
type GetErrorListParams struct {
	// Page index
	Page *Page `json:"page,omitempty"`

	// Number of items in each page
	Size *Size `json:"size,omitempty"`
}

// PostComposeJSONRequestBody defines body for PostCompose for application/json ContentType.
type PostComposeJSONRequestBody PostComposeJSONBody

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Create compose
	// (POST /compose)
	PostCompose(ctx echo.Context) error
	// The status of a compose
	// (GET /composes/{id})
	GetComposeStatus(ctx echo.Context, id string) error
	// Get logs for a compose.
	// (GET /composes/{id}/logs)
	GetComposeLogs(ctx echo.Context, id string) error
	// Get the manifests for a compose.
	// (GET /composes/{id}/manifests)
	GetComposeManifests(ctx echo.Context, id string) error
	// Get the metadata for a compose.
	// (GET /composes/{id}/metadata)
	GetComposeMetadata(ctx echo.Context, id string) error
	// Get a list of all possible errors
	// (GET /errors)
	GetErrorList(ctx echo.Context, params GetErrorListParams) error
	// Get error description
	// (GET /errors/{id})
	GetError(ctx echo.Context, id string) error
	// Get the openapi spec in json format
	// (GET /openapi)
	GetOpenapi(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// PostCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCompose(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCompose(ctx)
	return err
}

// GetComposeStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeStatus(ctx, id)
	return err
}

// GetComposeLogs converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeLogs(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeLogs(ctx, id)
	return err
}

// GetComposeManifests converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeManifests(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeManifests(ctx, id)
	return err
}

// GetComposeMetadata converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeMetadata(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeMetadata(ctx, id)
	return err
}

// GetErrorList converts echo context to params.
func (w *ServerInterfaceWrapper) GetErrorList(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetErrorListParams
	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", ctx.QueryParams(), &params.Page)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter page: %s", err))
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", ctx.QueryParams(), &params.Size)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter size: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetErrorList(ctx, params)
	return err
}

// GetError converts echo context to params.
func (w *ServerInterfaceWrapper) GetError(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetError(ctx, id)
	return err
}

// GetOpenapi converts echo context to params.
func (w *ServerInterfaceWrapper) GetOpenapi(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetOpenapi(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface) {
	RegisterHandlersWithBaseURL(router, si, "")
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.POST(baseURL+"/compose", wrapper.PostCompose)
	router.GET(baseURL+"/composes/:id", wrapper.GetComposeStatus)
	router.GET(baseURL+"/composes/:id/logs", wrapper.GetComposeLogs)
	router.GET(baseURL+"/composes/:id/manifests", wrapper.GetComposeManifests)
	router.GET(baseURL+"/composes/:id/metadata", wrapper.GetComposeMetadata)
	router.GET(baseURL+"/errors", wrapper.GetErrorList)
	router.GET(baseURL+"/errors/:id", wrapper.GetError)
	router.GET(baseURL+"/openapi", wrapper.GetOpenapi)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+xce2/buLL/KoTOBdriSrbiRx4GFnvSNNuT3b6QpHtwbxMEtDS22EiklqTiuEW++wUf",
	"kvWgH9nN7rnnIP80tkXODIczP86D6ncvYlnOKFApvMl3L8ccZyCB229zUH9jEBEnuSSMehPvE54DIjSG",
	"e8/34B5neQqN4Xc4LcCbeHvew4PvETXntwL40vM9ijP1RI/0PRElkGE1RS5z9buQnNC5nibINwfvD0U2",
	"BY7YDBEJmUCEIsBRgizBujQlgUqaMFwrjx67SZ6H8qEmffzPi9OTwec8ZTj+qEUz6+csBy6J4c9hrmX+",
	"XkrlTTwoggUIGex5fpuF74kEc7hZEJnc4Chihd2SavYXb28wHI33Dw6Pwr2Bd+17WgcOcSvimHO81LQp",
	"zkXC5I1ZcF2mbBmUT7tSPfgeh98KwiFWAtg1uWW9rmaz6VeIpOJb19SFxLJwKApnpCkRzkgQRofD8OBo",
	"eHAwHh+N49HUpbFHqri1GMW3orFG+Ivh0+6yW59bmK9TXMFTt+/UWahBTvrfCg5bFkcyPIfKZFqeiDNQ",
	"figTQIUmAzHSE3roTKKsEBJNARWU/FYouNAD5+QOKOIgWMEjQHPOirx3Rc9mSDFBRCCWESkhRjPOMj1F",
	"rQWE9BFGHNOYZYhRQFMsIEaMIow+fz57g4i4onOgwLGEuHdFV1hgLFwL5jKhlEVY2h1sLvCdfYIWCXDQ",
	"smgqSCSsSGO9uHLdmMZI7aWQwDX/f7AFkgylREiE0xSVbMTkiiZS5mLS78csEr2MRJwJNpO9iGV9oEEh",
	"+lFK+lhtT9/61o93BBY/6J+CKCVBiiUI+Tf8rXS+G8XopmLyoqUAZY1QqK11e5HZjhu9HZt3url1O6im",
	"vReXrIgwPbdk3mqOLiwsppUINyTuCnX2RolUH/Y7hBnBOD6cDqIATwejYDTaGwZHYTQO9vcGw3AfDsMj",
	"GLikk0AxlRvkUkKYQbtJZc1lRmiMiCy9Rbso+sS4xOkudlPajCR3EMSEQyQZX/ZnBY1xBlTiVHSeBglb",
	"BJIFinVgRG4paRwdwGw83Q/2ouEsGMU4DPD+YBCE03A/HAyP4oP4YCvQrTTW3duOBda8cgtyrUPGJnDt",
	"ggQteWsEXCKcqKBJwJk2AJymH2fe5Mt37784zLyJ97f+Kqjq27Ch/1FPPocZcKAReA9+R+i4KezeYAjq",
	"uA/g8Gga7A3iYYBH4/1gNNjfH49HozAMQ8/3ZoxnWHoTryi0MrcsLHYs6Hq1pHdsLp50UVqR04KkcT1S",
	"qQKTW/ZVn/6buPzCvhItl3uXLPGNy3qPKZmBkE+6tqxOtLmwlqCrkZulBIljLPFTCsmE5AA3EcsyIp14",
	"9TLBInlVwpbSpkR2uAP7chzd4rmh3c4L9BNz6BEapUVM6Bx9OP31/NirBaub1mNpVIrohLIPm/R3bmKF",
	"Lh5EhZAsI99wFehsEuKkOfrB92KiFDAtZCfW4wmkwaFLUcY4+UqkTSzP1OBS/PZk40i7qK9N5vd6W8eA",
	"GwqoaXwFwE8LGKKiu3W5VoRKaWYqPFJpKyoune0oj1LditBucxqK/FXnqm3lW0LNBW5Gkjo5Za+0yDSl",
	"IopAKFIzTNKCq4MwB6r8VNFbmfVqYMeuTzq+1NzAGUlBLIWEbOcd+Gk1xbEBdcSpJcM5E3LOQTwuEc7x",
	"UgUONxxyJohknLig7PRecozqY9CMcVRKgkQOEZkRlfFQ1ASXHrpMQMAVbcxekDRFjKZLHfip3EUyFEMu",
	"WHoHNn2QnMAdVEyuqGKpIPnjBSJSQDpDL2UCS0OMMp1f4TtMUjxNAZWj9XGIOGMSMX5FMV0iJhNQ0nNZ",
	"R/kY5ZypXX6lZS4Z3wiQAs0IpHFJs7McIhCZU8bLkHqnXT4vKSydFYpaVLiN0kV97IPvFcIWrHaS47MA",
	"vsvB4nunnDP+lOAWsRicZqoG4Vqy40jSsDCK2RzfaQ7V8BZhN2ToVb4j5pDabaV6tAO7S/XvtA9Gu66N",
	"aMR4mpRb8p8aUNMKzgi9KUuAFWrshYNRRYlQCXNjCplKonNGqGye7v07zLeG1LXJ/oqtK214e/JpS8Vl",
	"WkS3INfn4JgiuCdCqsDq4vL4w5vj8zfoQjKuAq8oxUKg15pEr10BsV8Cy2FtwOKu9ih80CUayRR8VWBD",
	"spxxaSsguigYI3UEFRLQKZ0TatPe3hW9rFJgTahVIFoQmdi09+3JJ4VMSmk+WiQkShTeKNBsQqKmZZJo",
	"zd7I0kNnMw2OK4wuK0dX9EVkjkce4JwEV0UYDiOVNulP8AIZZZTsEBa1xF1J/ZjK0qoy2FWlWqJ5XqsP",
	"VGvS+D6tKVeyun5nnGVWn7q2XakSq+8k1tTLDLqHLgBQWTqIUlbEvTlj8xR04UAY09E1hX5VP7IluboS",
	"fS1iVqSSBFbycjiKUiZASCWmGmRy+Sv60paKSvM0hllNe6XUHCVMAEW4kCzDkkQ4TZdtJUPxiGp5q4an",
	"UhE2K/Wi143K4UpeTaVpyS7z1ebZu6KnOEpKI9FajxiVmFCEK03x8oi1bJCSvId+1RKYXF0gzGFyRREK",
	"0At1dk2+Q4ZJSuKHFxN0TJH+hnAccxDKBLFUsQgHofBzxStSJFBrWT30E+PIas9HL3BKIvi7/a72/EXP",
	"chbA70gEx2beI2UwrC2JdbyzZaBDjwDn+d9xnoucyd7cTirn1EXS9Z/HasOuvywmK7laKogzQoVTBzHL",
	"MKGT7+avYqjdE10URAIyv6KXOScZ5stXXeZpahjqKriKQszuY2nntjWycr0XiHH0oiWT2+s2myYRZo4B",
	"B2WoCNPlFS312/SmLzpYmnSswvO9lj3sunme75lt66rZ8z2r4PqPj4jX17Wf7CG28Yx9utqg79nj6KZd",
	"osMiAhpjKoMpxyQOhuFwvDfcGjHUyPnbSo2NlL7bO+NRQiREUuVyDdHuD/dv9kfrz3nz8w6Z8eUyB53P",
	"mkrStjkfLy7VKL3iZor1BEmCOe1vWL5THacZa3Xaf3XVNbTSEv263IV1FvXoYoVN86v17EagYdZragQt",
	"WR9VAFBuRVL70UhmPpedLVsl6BhUzUxqrPBCscELEfCkIPZjguvfBM6rr9+MMKbJZX+EeA5BVYq03/SB",
	"C7z8gVAhcZrqH+ZRrv5VrlL5sv7bGHUnchVzOZfyiy2QNTe4CxY/Qcw4Dk5UPBW8xmJNBJiCetSYOQgH",
	"YXgUHvRCZ1QD/A54c0YZvN2yr6Q304wtgPQYn+ufk2La6ATw1Nm2wuK2DWGjgSsfugMuOqXO4fZ+thV/",
	"xcresFhRXGnFBXZVpd+B2uoM9Cbf9Q0OXcnuZIpUm4kduY78OifWtr+LdlyFgjJ7bpK8JdSdzJcXZbqK",
	"LzPW7hPJJE5dj1pa0Ez96oaNudhiJvtrk2nfs7DdWUOOOTSyYlvHUD5ptSWKTEVH3sQ7tn0DdPZGbbm9",
	"eBMO9sPRdBDjfTgaj6bxcDQ9nB4O8OFwDGN8cBAPpvvhbIaNy8zaJKcc0ygJUnILSD1eEeYJpP3Dvjnp",
	"+goN6rtT98NZt2jfmuiYtvZ6RVd5rcJPR4uJFaF7FrsNZI3ldHt5frnfmoNrY9sdFWcI4RQCcrbmSYmH",
	"mxCvC21knsXjdY8oLkOYNSGh40ENpbZ0n82pvhaKfKOESkZ1itYCkS5WYAHWOrowHcW0xyFOsGnNqwML",
	"qOzHRMi+MrzDleUpOkz0mejvgN5RAtHtzTyf19Y7ZSwFrGug83x+cwtLt5XpWu2NEKl7bgYSp4TeuheU",
	"Ec4ZF46jp5z3o4qXfjDPg+HgqgjDwb5S6Q9VFLptdYZJanG0KUQlg3rci4BKJjT/H+0G/nAYqNgUZzXO",
	"WP27PzK/aPnUMf3xYgdZ6oVwZylOpf92EDLVcsZRrV+wRFgomxaI6KrIKmPXRfgr+jInOaSEwitnQb6T",
	"s+mnngrBH9ft4InIXFvezqvUMBd4XLSK8i3kiCS5M8Vla3nNW4UQcZCBelTTeY6FWDAeuxSv/OHG6Vhd",
	"v9phHwkVZJ60blFKXoDv8AHG55jaJk47YhuFw8FofbjWFbnezOgp7dYk3xpENSTx21puMK2prLZc1052",
	"6s6Mwg6FftdN1wd/65z2tcltUzqF8a08urcXdUdgc+rP/sjyq8buzqvfcUa7YvGItZczrnduN9fnVWno",
	"LrUAM9EWA9Y1qO1BW+q5vSOPTEd5Qem6nLMujivp7IlhlRCa3NJJRcCT9vd0IaxZ7FiBgn7ovPnduXLQ",
	"RlMhkgDiwXi8d4SOj4+PT4YfvuGTvfR/35ztfbg8Havfzj7wt7+c8vf/Q/77/fvPi+If+Pz45+z8HTv7",
	"dj4b/PZmEL8ZfwtfX9739+9dQnST3EIA357zralcXes78xAVnMjlhdKgUdFrwNwofao//VSC+M//vCyv",
	"4GtoNuMquuoUMBfxCZ2x7rF8YUvRktmzVLeETNpvKqWi5/leSiKgJkK1d/+PcxwlgAY6IddIXkU+i8Wi",
	"h/VjHW7YuaL/7uzk9MPFaTDohb1EZqneQyK10j5evNbs7UUMjnTPBeGc1ELPiTewXV+qHky8YS/s7em0",
	"TSZaTX3bqdIgxoSjJXjCAUtAGFFYIDvaRzlT0SbBabpEEaPC9grZDAm4A45LXWj12OaZfoPCNG8IRzGo",
	"KbYRVO8gn8XexPvEhLRL84wdgJCvWbw0aaGOdbVH5XlKTKOn/9V2rlevV+xwIaa6xdS0N3V8mzvLOaP2",
	"ls8g3Htq7mexYdxSuXmIEiyQkJhLiNU2jsLwyfjbpniX9xk1TSy70+W9eMN/78/nf1xIZSS3QPXtDyON",
	"4T7887l/priQCePkm2mH5sBV9Icq4zSSjP4KSW4pW9BqH4wSxn+FCXymcJ9DJCFGoMYgFkUFV25Rx1p9",
	"jJUo++X64dqvlVMsaJTgouaVSCP630n8oE8x1w2EtyBNd1ef5PouArIHNGJcU0xBiWbJ6Q61tpQoLWIQ",
	"aJGAvobEuO5XKVqlDnUYADHEXbx5C7J51dBvvKP2xX3/viJshJUMzfWdB/3ul8LY1atf9gJ6HV/qL4I9",
	"+XXs6w54hU8NXlWLoGNBTb38y7CrBI5n2HqGrZ1g67IFPOvxq5/a9sHvAbEZoUQkNQxDGyGMyBVy+Tqg",
	"wqlgKAOJkQpSFRAQRhGeskKWr08VqdyEcrr78YxxWzHOvg/SMTZlKcoEqhtq5pXDKj4mFFGmq3AkKlLM",
	"7ZUc9FImrJgn9qbQzxcfP7zqufFRwr3s5ykmLaEdrwzvhoKjp2Lg8vGHuhu91dev5mW9srRylxs13m3Z",
	"6EvVyB3c6RxkwanQr3CW87QwOgWx91lo/b3PHtJ3rqrBEdOOJcrLZnb7YpgRCjHCEtWTNyZ0LmiK1Zj2",
	"7fegJNcbb3DF1TtDz/641R9XylrjlI3t7jjmf6avNd1jB6erNek2+5wdaFyu42fmcijc40g2DiKu3Q9i",
	"FEMONFZ+WPe18gVuc2Vxk2eUcj47xnbHqF5lW+MX5VY+xi+eY/TnGP3/W4zewSYX3mni9ZiiAzGrt1E6",
	"4OJa2WpIX195Wdc8qY3Td2L+VNdfrcFl7eYFWTZDVhnPbvavcTNj6P9+ToYrA8JpinImBJmmUFnTys22",
	"F/QwNS0SGlX/w4eRbPXyzHSJ9NHpdtTdIoCK7h899Yd/8RlebeWzjz776GN81Mytk9Z+WTX81p9/H+0Q",
	"t1U3hbXktLeqvFnpwGbE/46Rw8blPFTXbVw4896+p8PiIjIvl1VXkZstXZyTnuIjEmL/7xyck765JK5r",
	"A8CD8iXB/t1AxxOtRrPEc0LnmxgIiefwB9loJdLyPaKKzTY61w//FwAA//+ZtdaO008AAA==",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
