# Spec file for Open vSwitch selinux policy.

# Copyright (C) 2018, Red Hat, Inc.
#
# Copying and distribution of this file, with or without modification,
# are permitted in any medium without royalty provided the copyright
# notice and this notice are preserved.  This file is offered as-is,
# without warranty of any kind.
#

%global selinuxtype targeted
%global selinux_policyver 3.13.1-166.9
%global moduletype contrib
%global modulename openvswitch-custom

Name: openvswitch-selinux-extra-policy
Summary: Open vSwitch Extra SELinux Policy
Group: System Environment/Daemons
URL: http://www.openvswitch.org/
Version: 1.0
Source0: http://aconole.bytheb.org/files/openvswitch-selinux-policy.tar.gz

License: ASL 2.0
BuildArch: noarch
Release: 0%{?dist}

BuildRequires: autoconf automake libtool
BuildRequires: systemd-units openssl openssl-devel
BuildRequires: checkpolicy selinux-policy-devel git pkgconfig(systemd)
Requires: selinux-policy-targeted
Requires(post): selinux-policy >= %{selinux_policyver}
Requires(post): libselinux-utils
Requires(post): policycoreutils
%if 0%{?fedora}
Requires(post): policycoreutils-python-utils
%else
Requires(post): policycoreutils-python
%endif

%description
Tailored Open vSwitch SELinux policy for distribution

%prep
%setup -q

%build
make

%install
rm -rf $RPM_BUILD_ROOT
install -d %{buildroot}%{_datadir}/selinux/packages
install -d -p %{buildroot}%{_datadir}/selinux/devel/include/%{moduletype}
# install -p -m 644 %{modulename}.if %{buildroot}%{_datadir}/selinux/devel/include/%{moduletype}
install -m 0644 %{modulename}.pp %{buildroot}%{_datadir}/selinux/packages

%check

%pre
%selinux_relabel_pre -s %{selinuxtype}

%post
%selinux_modules_install -s %{selinuxtype} %{_datadir}/selinux/packages/%{modulename}.pp

%postun
if [ $1 -eq 0 ]; then
    %selinux_modules_uninstall -s %{selinuxtype} %{modulename}
fi

%posttrans
%selinux_relabel_post -s %{selinuxtype}

%files
%defattr(-,root,root,0755)
%attr(0644,root,root) %{_datadir}/selinux/packages/%{modulename}.pp
# %attr(0644,root,root) %{_datadir}/selinux/devel/include/%{moduletype}/%{modulename}.if

%changelog
* Mon Feb 12 2018 Aaron Conole <aconole@redhat.com> - 1.0-0
- First Build
