/* hw_pkcs11_err.h (replace hw_trustway.c) */
/*
 * PKCS#11 engine for the OpenSSL project 2002
 * Developped by Bull Trustway R&D Networking & Security
 * Introduced and tested with Bull TrustWay CC2000 crypto hardware
 * Afchine.Madjlessi@bull.net Bull S.A. France
 * http://www.servers.bull.com/trustway
 */

#ifndef HEADER_PKCS11_ERR_H
#define HEADER_PKCS11_ERR_H

void ERR_load_pkcs11_strings(void);
void ERR_unload_pkcs11_strings(void);
void ERR_pkcs11_error(int function, int reason, char *file, int line);
#define PKCS11err(f,r) ERR_pkcs11_error((f),(r),__FILE__,__LINE__)

/* Error codes for the PKCS11 functions. */

/* Function codes. */

#define PKCS11_F_INIT 100
#define PKCS11_F_FINISH 101
#define PKCS11_F_DESTROY 102
#define PKCS11_F_CTRL 103
#define PKCS11_F_RSA_INIT 104
#define PKCS11_F_RSA_FINISH 105
#define PKCS11_F_FINDORCREATEKEY 106
#define PKCS11_F_RSA_GEN_KEY 107
#define PKCS11_F_RSA_PUB_ENC 108
#define PKCS11_F_RSA_PRIV_ENC 109
#define PKCS11_F_RSA_PUB_DEC 110
#define PKCS11_F_RSA_PRIV_DEC 111
#define PKCS11_F_RSA_SIGN 112
#define PKCS11_F_RSA_VERIFY 113
#define PKCS11_F_RAND_ADD 114
#define PKCS11_F_RAND_BYTES 115
#define PKCS11_F_GETSESSION 116
#define PKCS11_F_FREESESSION 117
#define PKCS11_F_LOAD_PUBKEY 118
#define PKCS11_F_LOAD_PRIVKEY 119
#define PKCS11_F_ADDTOKEN 120
#define PKCS11_F_INITKEY 121
#define PKCS11_F_DIGESTINIT 122
#define PKCS11_F_DIGESTUPDATE 123
#define PKCS11_F_DIGESTFINISH 124
#define PKCS11_F_CIPHER_UPDATE 125
#define PKCS11_F_PREINIT 126
#define PKCS11_F_DIGESTCOPY 127
#define PKCS11_F_ENGINE_DIGESTS 128
#define PKCS11_F_ENGINE_CIPHERS 129
#define PKCS11_F_GET_PKCS11_DIGESTS 130
#define PKCS11_F_GET_PKCS11_CIPHERS 131

/* Reason codes. */
#define PKCS11_R_ALREADY_LOADED 100
#define PKCS11_R_DSO_FAILURE 101
#define PKCS11_R_NOT_LOADED 102
#define PKCS11_R_PASSED_NULL_PARAMETER 103
#define PKCS11_R_COMMAND_NOT_IMPLEMENTED 104
#define PKCS11_R_INITIALIZE 105
#define PKCS11_R_FINALIZE 106
#define PKCS11_R_GETINFO 107
#define PKCS11_R_GETSLOTLIST 108
#define PKCS11_R_NO_MODULUS_OR_NO_EXPONENT 109
#define PKCS11_R_ATTRIBUT_SENSITIVE_OR_INVALID 110
#define PKCS11_R_GETATTRIBUTVALUE 111
#define PKCS11_R_NO_MODULUS 112
#define PKCS11_R_NO_EXPONENT 113
#define PKCS11_R_FINDOBJECTSINIT 114
#define PKCS11_R_FINDOBJECTS 115
#define PKCS11_R_FINDOBJECTSFINAL 116
#define PKCS11_R_OBJECT_NOT_FOUND 117
#define PKCS11_R_CREATEOBJECT 118
#define PKCS11_R_DESTROYOBJECT 119
#define PKCS11_R_OPENSESSION 120
#define PKCS11_R_CLOSESESSION 121
#define PKCS11_R_ENCRYPTINIT 122
#define PKCS11_R_ENCRYPT 123
#define PKCS11_R_SIGNINIT 124
#define PKCS11_R_SIGN 125
#define PKCS11_R_DECRYPTINIT 126
#define PKCS11_R_DECRYPT 127
#define PKCS11_R_VERIFYINIT 128
#define PKCS11_R_VERIFY 129
#define PKCS11_R_VERIFYRECOVERINIT 130
#define PKCS11_R_VERIFYRECOVER 131
#define PKCS11_R_GEN_KEY 132
#define PKCS11_R_SEEDRANDOM 133
#define PKCS11_R_GENERATERANDOM 134
#define PKCS11_R_INVALID_MESSAGE_LENGTH 135
#define PKCS11_R_UNKNOWN_ALGORITHM_TYPE 136
#define PKCS11_R_UNKNOWN_ASN1_OBJECT_ID 137
#define PKCS11_R_UNKNOWN_PADDING_TYPE 138
#define PKCS11_R_DIGEST_TOO_BIG 139
#define PKCS11_R_MALLOC_FAILURE 140
#define PKCS11_R_CTRL_COMMAND_NOT_IMPLEMENTED 141
#define PKCS11_R_GETSLOTINFO 142
#define PKCS11_R_GETMECHANISMLIST 143
#define PKCS11_R_GETMECHANISMINFO 144
#define PKCS11_R_BADMECHANISM 145
#define PKCS11_R_DIGESTINIT 146
#define PKCS11_R_DIGESTUPDATE 147
#define PKCS11_R_DIGESTFINAL 148
#define PKCS11_R_NOTOKENS 149
#define PKCS11_R_NOTOKENFORALGORITHM 150
#define PKCS11_R_DIGEST 151
#define PKCS11_R_TOKEN_NOT_AVAILABLE 152
#define PKCS11_R_NO_SLOT_SELECTED 153
#endif
