# Copyright (C) 2013 Red Hat, Inc.  All rights reserved.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Authors: Jan Safranek <jsafrane@redhat.com>
# -*- coding: utf-8 -*-
"""
Module for FormatProvider.

LMI_PVFormatProvider
--------------------

.. autoclass:: LMI_PVFormatProvider
    :members:

"""

from lmi.storage.FormatProvider import FormatProvider
import blivet.formats.lvmpv
import lmi.providers.cmpi_logging as cmpi_logging

class LMI_PVFormatProvider(FormatProvider):
    """
        Provider of MD RAID format on a device.
    """
    @cmpi_logging.trace_method
    def __init__(self, *args, **kwargs):
        super(LMI_PVFormatProvider, self).__init__(
                "LMI_PVFormat",
                "lvmpv",
                *args, **kwargs)

    @cmpi_logging.trace_method
    def provides_format(self, device, fmt):
        if  isinstance(fmt, blivet.formats.lvmpv.LVMPhysicalVolume):
            return True
        return False

    @cmpi_logging.trace_method
    def get_instance(self, env, model, fmt=None):
        """
            Get instance.
        """
        model = super(LMI_PVFormatProvider, self).get_instance(
                env, model, fmt)
        if not fmt:
            (device, fmt) = self.get_format_for_id(model['Name'])
        if fmt.uuid:
            model['UUID'] = fmt.uuid
        return model
