/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLHelper {
    private static boolean canUseSchemaValidation = true;

    private static SAXParser newSAXParser(URL uRL, InputStream inputStream) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(canUseSchemaValidation && uRL != null);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        if (canUseSchemaValidation && uRL != null) {
            try {
                sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", inputStream);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("WARNING: problem while setting JAXP validating property on SAXParser... XML validation will not be done: " + sAXNotRecognizedException.getMessage());
                canUseSchemaValidation = false;
                sAXParserFactory.setValidating(false);
                sAXParser = sAXParserFactory.newSAXParser();
            }
        }
        sAXParser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        return sAXParser;
    }

    public static void parse(URL uRL, URL uRL2, DefaultHandler defaultHandler) {
        DefaultHandler defaultHandler2 = defaultHandler;
        URL uRL3 = uRL2;
        URL uRL4 = uRL;
        InputStream inputStream = URLHandlerRegistry.getDefault().openStream(uRL4);
        try {
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(uRL4.toExternalForm());
            XMLHelper.parse(inputSource, uRL3, defaultHandler2, null);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void parse$7b13091c(InputStream inputStream, URL uRL, DefaultHandler defaultHandler) {
        XMLHelper.parse(new InputSource(inputStream), uRL, defaultHandler, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parse(InputSource inputSource, URL uRL, DefaultHandler defaultHandler, LexicalHandler lexicalHandler) {
        InputStream inputStream = null;
        try {
            if (uRL != null) {
                inputStream = URLHandlerRegistry.getDefault().openStream(uRL);
            }
            SAXParser sAXParser = XMLHelper.newSAXParser(uRL, inputStream);
            if (lexicalHandler != null) {
                try {
                    sAXParser.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
                }
                catch (SAXException sAXException) {
                    System.err.println("WARNING: problem while setting the lexical handler property on SAXParser: " + sAXException.getMessage());
                }
            }
            sAXParser.parse(inputSource, defaultHandler);
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Document parseToDom(InputStream inputStream, Resource resource, EntityResolver entityResolver) {
        Document document;
        DocumentBuilder documentBuilder = XMLHelper.getDocBuilder(entityResolver);
        try {
            document = documentBuilder.parse(inputStream, resource.getName());
        }
        catch (SAXException sAXException) {
            SAXException sAXException2 = sAXException;
            sAXException.printStackTrace();
            throw sAXException2;
        }
        finally {
            inputStream.close();
        }
        return document;
    }

    private static DocumentBuilder getDocBuilder(EntityResolver entityResolver) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (entityResolver != null) {
                documentBuilder.setEntityResolver(entityResolver);
            }
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    private XMLHelper() {
    }
}

