/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.sort.ModuleInSort;
import org.apache.ivy.core.sort.NonMatchingVersionReporter;
import org.apache.ivy.plugins.version.VersionMatcher;

final class CollectionOfModulesToSort {
    private final List moduleDescriptors;
    private final VersionMatcher versionMatcher;
    private final Map modulesByModuleId;
    private final NonMatchingVersionReporter nonMatchingVersionReporter;

    public CollectionOfModulesToSort(Collection collection, VersionMatcher versionMatcher, NonMatchingVersionReporter nonMatchingVersionReporter) {
        this.versionMatcher = versionMatcher;
        this.nonMatchingVersionReporter = nonMatchingVersionReporter;
        this.modulesByModuleId = new HashMap();
        this.moduleDescriptors = new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)iterator.next();
            ModuleInSort moduleInSort = new ModuleInSort(moduleDescriptor);
            this.moduleDescriptors.add(moduleInSort);
            ModuleInSort moduleInSort2 = moduleInSort;
            ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
            CollectionOfModulesToSort collectionOfModulesToSort = this;
            ModuleId moduleId = moduleDescriptor2.getModuleRevisionId().getModuleId();
            LinkedList<ModuleInSort> linkedList = new LinkedList<ModuleInSort>();
            linkedList.add(moduleInSort2);
            List list = collectionOfModulesToSort.modulesByModuleId.put(moduleId, linkedList);
            if (list == null) continue;
            linkedList.addAll(list);
        }
    }

    public final Iterator iterator() {
        return this.moduleDescriptors.iterator();
    }

    public final int size() {
        return this.moduleDescriptors.size();
    }

    public final ModuleInSort getModuleDescriptorDependency(DependencyDescriptor dependencyDescriptor) {
        Collection collection = (Collection)this.modulesByModuleId.get(dependencyDescriptor.getDependencyId());
        if (collection == null) {
            return null;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModuleInSort moduleInSort = (ModuleInSort)iterator.next();
            if (moduleInSort.match(dependencyDescriptor, this.versionMatcher)) {
                return moduleInSort;
            }
            this.nonMatchingVersionReporter.reportNonMatchingVersion(dependencyDescriptor, moduleInSort.getSortedModuleDescriptor());
        }
        return null;
    }
}

