/*
 * Decompiled with CFR 0.152.
 */
package jline;

public class CursorBuffer {
    public int cursor = 0;
    StringBuffer buffer = new StringBuffer();
    private boolean overtyping = false;

    public int length() {
        return this.buffer.length();
    }

    public char current() {
        if (this.cursor <= 0) {
            return '\u0000';
        }
        return this.buffer.charAt(this.cursor - 1);
    }

    public boolean clearBuffer() {
        if (this.buffer.length() == 0) {
            return false;
        }
        this.buffer.delete(0, this.buffer.length());
        this.cursor = 0;
        return true;
    }

    public void write(char c) {
        this.buffer.insert(this.cursor++, c);
        if (this.isOvertyping() && this.cursor < this.buffer.length()) {
            this.buffer.deleteCharAt(this.cursor);
        }
    }

    public void write(String string) {
        if (this.buffer.length() == 0) {
            this.buffer.append(string);
        } else {
            this.buffer.insert(this.cursor, string);
        }
        this.cursor += string.length();
        if (this.isOvertyping() && this.cursor < this.buffer.length()) {
            this.buffer.delete(this.cursor, this.cursor + string.length());
        }
    }

    public String toString() {
        return this.buffer.toString();
    }

    public boolean isOvertyping() {
        return this.overtyping;
    }

    public void setOvertyping(boolean bl) {
        this.overtyping = bl;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        stringBuffer.append(this.buffer.toString());
        this.buffer = stringBuffer;
    }
}

