/*
 * COPYRIGHT (c) International Business Machines Corp. 2001-2017
 *
 * This program is provided under the terms of the Common Public License,
 * version 1.0 (CPL-1.0). Any use, reproduction or distribution for this
 * software constitutes recipient's acceptance of CPL-1.0 terms which can be
 * found in the file LICENSE file or at
 * https://opensource.org/licenses/cpl1.0.php
 */

/***************************************************************************
                          Change Log
                          ==========
       4/25/03    Kapil Sood (kapil@corrent.com)
                  Added DH key pair generation and DH shared key derivation
                  functions.



****************************************************************************/

#include <pthread.h>
#include <stdlib.h>

#include "pkcs11types.h"
#include "stdll.h"
#include "defs.h"
#include "host_defs.h"
#include "h_extern.h"

struct ST_FCN_LIST function_list;


// OBJECT IDENTIFIERs
//
const CK_BYTE ber_idDSA[] =
    { 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x38, 0x04, 0x01 };
const CK_BYTE ber_idEC[] =
    { 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01 };
const CK_BYTE ber_rsaEncryption[] =
    { 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01 };
#if !(NOMD2)
const CK_BYTE ber_md2WithRSAEncryption[] =
    { 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x02 };
#endif
const CK_BYTE ber_md5WithRSAEncryption[] =
    { 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x04 };
const CK_BYTE ber_sha1WithRSAEncryption[] =
    { 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05 };
const CK_BYTE ber_idDH[] =
    { 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x03, 0x01 };
const CK_BYTE ber_idDilithium[] =
    { 0x06, 0x0B, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x02, 0x82, 0x0B, 0x01, 0x06, 0x05 };

// Algorithm IDs. (Sequence of OID plus parms, usually NULL)
//
#if !(NOMD2)
const CK_BYTE ber_AlgMd2[] = {
    0x30, 0x0C, 0x06, 0x08, 0x2A, 0x86, 0x48,
    0x86, 0xF7, 0x0D, 0x02, 0x02, 0x05, 0x00
};
#endif

const CK_BYTE ber_AlgMd5[] = {
    0x30, 0x0C, 0x06, 0x08, 0x2A, 0x86, 0x48,
    0x86, 0xF7, 0x0D, 0x02, 0x05, 0x05, 0x00
};

const CK_BYTE ber_AlgSha1[] = {
    0x30, 0x09, 0x06, 0x05, 0x2B, 0x0E, 0x03,
    0x02, 0x1A, 0x05, 0x00
};

const CK_BYTE ber_AlgSha224[] = {
    0x30, 0x0D, 0x06, 0x09, 0x60, 0x86, 0x48,
    0x01, 0x65, 0x03, 0x04, 0x02, 0x04, 0x05,
    0x00
};

const CK_BYTE ber_AlgSha256[] = {
    0x30, 0x0D, 0x06, 0x09, 0x60, 0x86, 0x48,
    0x01, 0x65, 0x03, 0x04, 0x02, 0x01, 0x05,
    0x00
};

const CK_BYTE ber_AlgSha384[] = {
    0x30, 0x0D, 0x06, 0x09, 0x60, 0x86, 0x48,
    0x01, 0x65, 0x03, 0x04, 0x02, 0x02, 0x05,
    0x00
};

const CK_BYTE ber_AlgSha512[] = {
    0x30, 0x0D, 0x06, 0x09, 0x60, 0x86, 0x48,
    0x01, 0x65, 0x03, 0x04, 0x02, 0x03, 0x05,
    0x00
};

const CK_BYTE ber_AlgIdRSAEncryption[] = {
    0x30, 0x0D, 0x06, 0x09, 0x2a, 0x86, 0x48,
    0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05,
    0x00
};

const CK_BYTE der_AlgIdECBase[] =
    { 0x30, 0x09, 0x06, 0x07, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x02, 0x01 };

const CK_BYTE ber_AlgIdDilithium[] =
    { 0x30, 0x0F, 0x06, 0x0B, 0x2B, 0x06, 0x01,
      0x04, 0x01, 0x02, 0x82, 0x0B, 0x01, 0x06,
      0x05, 0x05, 0x00
};

// ID Lengths
//
const CK_ULONG ber_idDSALen = sizeof(ber_idDSA);
const CK_ULONG ber_idECLen = sizeof(ber_idEC);
const CK_ULONG ber_rsaEncryptionLen = sizeof(ber_rsaEncryption);
#if !(NOMD2)
const CK_ULONG ber_md2WithRSAEncryptionLen = sizeof(ber_md2WithRSAEncryption);
#endif
const CK_ULONG ber_md5WithRSAEncryptionLen = sizeof(ber_md5WithRSAEncryption);
const CK_ULONG ber_sha1WithRSAEncryptionLen = sizeof(ber_sha1WithRSAEncryption);
const CK_ULONG ber_idDHLen = sizeof(ber_idDH);
const CK_ULONG ber_idDilithiumLen = sizeof(ber_idDilithium);

#if !(NOMD2)
const CK_ULONG ber_AlgMd2Len = sizeof(ber_AlgMd2);
#endif
const CK_ULONG ber_AlgMd5Len = sizeof(ber_AlgMd5);
const CK_ULONG ber_AlgSha1Len = sizeof(ber_AlgSha1);
const CK_ULONG ber_AlgSha224Len = sizeof(ber_AlgSha224);
const CK_ULONG ber_AlgSha256Len = sizeof(ber_AlgSha256);
const CK_ULONG ber_AlgSha384Len = sizeof(ber_AlgSha384);
const CK_ULONG ber_AlgSha512Len = sizeof(ber_AlgSha512);
const CK_ULONG ber_AlgIdRSAEncryptionLen = sizeof(ber_AlgIdRSAEncryption);
const CK_ULONG der_AlgIdECBaseLen = sizeof(der_AlgIdECBase);
const CK_ULONG ber_AlgIdDilithiumLen = sizeof(ber_AlgIdDilithium);

const CK_ULONG des_weak_count = 4;
const CK_ULONG des_semi_weak_count = 12;
const CK_ULONG des_possibly_weak_count = 48;

const CK_BYTE des_weak_keys[4][8] = {
    {0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01},
    {0x1F, 0x1F, 0x1F, 0x1F, 0x0E, 0x0E, 0x0E, 0x0E},
    {0xE0, 0xE0, 0xE0, 0xE0, 0xF1, 0xF1, 0xF1, 0xF1},
    {0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE}
};

const CK_BYTE des_semi_weak_keys[12][8] = {
    {0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE},
    {0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01},
    {0x1F, 0xE0, 0x1F, 0xE0, 0x0E, 0xF1, 0x0E, 0xF1},
    {0xE0, 0x1F, 0xE0, 0x1F, 0xF1, 0x0E, 0xF1, 0x0E},
    {0x01, 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF1},
    {0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF1, 0x01},
    {0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E, 0xFE},
    {0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E},
    {0x01, 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0E},
    {0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0E, 0x01},
    {0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1, 0xFE},
    {0xFE, 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1}
};

const CK_BYTE des_possibly_weak_keys[48][8] = {
    {0x1F, 0x1F, 0x01, 0x01, 0x0E, 0x0E, 0x01, 0x01},
    {0x01, 0x1F, 0x1F, 0x01, 0x01, 0x0E, 0x0E, 0x01},
    {0x1F, 0x01, 0x01, 0x1F, 0x0E, 0x01, 0x01, 0x0E},
    {0x01, 0x01, 0x1F, 0x1F, 0x01, 0x01, 0x0E, 0x0E},
    {0xE0, 0xE0, 0x01, 0x01, 0xF1, 0xF1, 0x01, 0x01},
    {0xFE, 0xFE, 0x01, 0x01, 0xFE, 0xFE, 0x01, 0x01},
    {0xFE, 0xE0, 0x1F, 0x01, 0xFE, 0xF1, 0x0E, 0x01},
    {0xE0, 0xFE, 0x1F, 0x01, 0xF1, 0xFE, 0x0E, 0x01},
    {0xFE, 0xE0, 0x01, 0x1F, 0xFE, 0xF1, 0x01, 0x0E},
    {0xE0, 0xFE, 0x01, 0x1F, 0xF1, 0xFE, 0x01, 0x0E},
    {0xE0, 0xE0, 0x1F, 0x1F, 0xF1, 0xF1, 0x0E, 0x0E},
    {0xFE, 0xFE, 0x1F, 0x1F, 0xFE, 0xFE, 0x0E, 0x0E},
    {0xFE, 0x1F, 0xE0, 0x01, 0xFE, 0x0E, 0xF1, 0x01},
    {0xE0, 0x1F, 0xFE, 0x01, 0xF1, 0x0E, 0xFE, 0x01},
    {0xFE, 0x01, 0xE0, 0x1F, 0xFE, 0x01, 0xF1, 0x0E},
    {0xE0, 0x01, 0xFE, 0x1F, 0xF1, 0x01, 0xFE, 0x0E},
    {0x01, 0xE0, 0xE0, 0x01, 0x01, 0xF1, 0xF1, 0x01},
    {0x1F, 0xFE, 0xE0, 0x01, 0x0E, 0xFE, 0xF0, 0x01},
    {0x1F, 0xE0, 0xFE, 0x01, 0x0E, 0xF1, 0xFE, 0x01},
    {0x01, 0xFE, 0xFE, 0x01, 0x01, 0xFE, 0xFE, 0x01},
    {0x1F, 0xE0, 0xE0, 0x1F, 0x0E, 0xF1, 0xF1, 0x0E},
    {0x01, 0xFE, 0xE0, 0x1F, 0x01, 0xFE, 0xF1, 0x0E},
    {0x01, 0xE0, 0xFE, 0x1F, 0x01, 0xF1, 0xFE, 0x0E},
    {0x1F, 0xFE, 0xFE, 0x1F, 0x0E, 0xFE, 0xFE, 0x0E},
    {0xE0, 0x01, 0x01, 0xE0, 0xF1, 0x01, 0x01, 0xF1},
    {0xFE, 0x1F, 0x01, 0xE0, 0xFE, 0x0E, 0x01, 0xF1},
    {0xFE, 0x01, 0x1F, 0xE0, 0xFE, 0x01, 0x0E, 0xF1},
    {0xE0, 0x1F, 0x1F, 0xE0, 0xF1, 0x0E, 0x0E, 0xF1},
    {0xFE, 0x01, 0x01, 0xFE, 0xFE, 0x01, 0x01, 0xFE},
    {0xE0, 0x1F, 0x01, 0xFE, 0xF1, 0x0E, 0x01, 0xFE},
    {0xE0, 0x01, 0x1F, 0xFE, 0xF1, 0x01, 0x0E, 0xFE},
    {0xFE, 0x1F, 0x1F, 0xFE, 0xFE, 0x0E, 0x0E, 0xFE},
    {0x1F, 0xFE, 0x01, 0xE0, 0x0E, 0xFE, 0x01, 0xF1},
    {0x01, 0xFE, 0x1F, 0xE0, 0x01, 0xFE, 0x0E, 0xF1},
    {0x1F, 0xE0, 0x01, 0xFE, 0x0E, 0xF1, 0x01, 0xFE},
    {0x01, 0xE0, 0x1F, 0xFE, 0x01, 0xF1, 0x0E, 0xFE},
    {0x01, 0x01, 0xE0, 0xE0, 0x01, 0x01, 0xF1, 0xF1},
    {0x1F, 0x1F, 0xE0, 0xE0, 0x0E, 0x0E, 0xF1, 0xF1},
    {0x1F, 0x01, 0xFE, 0xE0, 0x0E, 0x01, 0xFE, 0xF1},
    {0x01, 0x1F, 0xFE, 0xE0, 0x01, 0x0E, 0xFE, 0xF1},
    {0x1F, 0x01, 0xE0, 0xFE, 0x0E, 0x01, 0xF1, 0xFE},
    {0x01, 0x1F, 0xE0, 0xFE, 0x01, 0x0E, 0xF1, 0xFE},
    {0x01, 0x01, 0xFE, 0xFE, 0x01, 0x01, 0xFE, 0xFE},
    {0x1F, 0x1F, 0xFE, 0xFE, 0x0E, 0x0E, 0xFE, 0xFE},
    {0xFE, 0xFE, 0xE0, 0xE0, 0xFE, 0xFE, 0xF1, 0xF1},
    {0xE0, 0xFE, 0xFE, 0xE0, 0xF1, 0xFE, 0xFE, 0xF1},
    {0xFE, 0xE0, 0xE0, 0xFE, 0xFE, 0xF1, 0xF1, 0xFE},
    {0xE0, 0xE0, 0xFE, 0xFE, 0xF1, 0xF1, 0xFE, 0xFE}
};

// default SO pin values
//

const CK_BYTE default_so_pin_md5[MD5_HASH_SIZE] = {
    0x5E, 0x86, 0x67, 0xA4, 0x39, 0xC6, 0x8F, 0x51,
    0x45, 0xDD, 0x2F, 0xCB, 0xEC, 0xF0, 0x22, 0x09
};

const CK_BYTE default_so_pin_sha[SHA1_HASH_SIZE] = {
    0xA7, 0xD5, 0x79, 0xBA, 0x76, 0x39, 0x80, 0x70,
    0xEA, 0xE6, 0x54, 0xC3, 0x0F, 0xF1, 0x53, 0xA4,
    0xC2, 0x73, 0x27, 0x2A
};

/* SHA-1 of "12345678" */
const CK_BYTE default_user_pin_sha[SHA1_HASH_SIZE] = {
    0x7c, 0x22, 0x2f, 0xb2, 0x92, 0x7d, 0x82, 0x8a,
    0xf2, 0x2f, 0x59, 0x21, 0x34, 0xe8, 0x93, 0x24,
    0x80, 0x63, 0x7c, 0x0d
};

