/*
 * COPYRIGHT (c) International Business Machines Corp. 2001-2017
 *
 * This program is provided under the terms of the Common Public License,
 * version 1.0 (CPL-1.0). Any use, reproduction or distribution for this
 * software constitutes recipient's acceptance of CPL-1.0 terms which can be
 * found in the file LICENSE file or at
 * https://opensource.org/licenses/cpl1.0.php
 */

typedef enum {
    no_cmd, gen_key, list_key,
} p11sak_cmd;

/*
 * The first enum items are for SYMMETRIC keys for kt <= 2.
 * The last enum items are for ASYMMETRIC keys for kt >= 3
 */
typedef enum {
    kt_DES,
    kt_3DES,
    kt_AES,
    kt_RSAPKCS,
    kt_EC,
    kt_GENERIC,
    kt_SECRET,
    kt_PUBLIC,
    kt_PRIVATE,
    no_key_type
} p11sak_kt;

#define  KEY_MAX_BOOL_ATTR_COUNT 15
#define  SEC_KEY_MAX_BOOL_ATTR_COUNT 15
#define  PRV_KEY_MAX_BOOL_ATTR_COUNT 12
#define  PUB_KEY_MAX_BOOL_ATTR_COUNT 8

const CK_BYTE brainpoolP160r1[] = { 0x06, 0x09, 0x2B, 0x24, 0x03, 0x03, 0x02,
        0x08, 0x01, 0x01, 0x01 };
const CK_BYTE brainpoolP160t1[] = { 0x06, 0x09, 0x2B, 0x24, 0x03, 0x03, 0x02,
        0x08, 0x01, 0x01, 0x02 };
const CK_BYTE brainpoolP192r1[] = { 0x06, 0x09, 0x2B, 0x24, 0x03, 0x03, 0x02,
        0x08, 0x01, 0x01, 0x03 };
const CK_BYTE brainpoolP192t1[] = { 0x06, 0x09, 0x2B, 0x24, 0x03, 0x03, 0x02,
        0x08, 0x01, 0x01, 0x04 };
const CK_BYTE brainpoolP224r1[] = { 0x06, 0x09, 0x2B, 0x24, 0x03, 0x03, 0x02,
        0x08, 0x01, 0x01, 0x05 };
const CK_BYTE brainpoolP224t1[] = { 0x06, 0x09, 0x2B, 0x24, 0x03, 0x03, 0x02,
        0x08, 0x01, 0x01, 0x06 };
const CK_BYTE brainpoolP256r1[] = { 0x06, 0x09, 0x2B, 0x24, 0x03, 0x03, 0x02,
        0x08, 0x01, 0x01, 0x07 };
const CK_BYTE brainpoolP256t1[] = { 0x06, 0x09, 0x2B, 0x24, 0x03, 0x03, 0x02,
        0x08, 0x01, 0x01, 0x08 };
const CK_BYTE brainpoolP320r1[] = { 0x06, 0x09, 0x2B, 0x24, 0x03, 0x03, 0x02,
        0x08, 0x01, 0x01, 0x09 };
const CK_BYTE brainpoolP320t1[] = { 0x06, 0x09, 0x2B, 0x24, 0x03, 0x03, 0x02,
        0x08, 0x01, 0x01, 0x0A };
const CK_BYTE brainpoolP384r1[] = { 0x06, 0x09, 0x2B, 0x24, 0x03, 0x03, 0x02,
        0x08, 0x01, 0x01, 0x0B };
const CK_BYTE brainpoolP384t1[] = { 0x06, 0x09, 0x2B, 0x24, 0x03, 0x03, 0x02,
        0x08, 0x01, 0x01, 0x0C };
const CK_BYTE brainpoolP512r1[] = { 0x06, 0x09, 0x2B, 0x24, 0x03, 0x03, 0x02,
        0x08, 0x01, 0x01, 0x0D };
const CK_BYTE brainpoolP512t1[] = { 0x06, 0x09, 0x2B, 0x24, 0x03, 0x03, 0x02,
        0x08, 0x01, 0x01, 0x0E };
const CK_BYTE prime192[] = { 0x06, 0x08, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x03,
        0x01, 0x01 };
const CK_BYTE secp224[] = { 0x06, 0x05, 0x2B, 0x81, 0x04, 0x00, 0x21 };
const CK_BYTE prime256v1[] = { 0x06, 0x08, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x03,
        0x01, 0x07 };
const CK_BYTE secp384r1[] = { 0x06, 0x05, 0x2B, 0x81, 0x04, 0x00, 0x22 };
const CK_BYTE secp521r1[] = { 0x06, 0x05, 0x2B, 0x81, 0x04, 0x00, 0x23 };
const CK_BYTE secp256k1[] = { 0x06, 0x05, 0x2B, 0x81, 0x04, 0x00, 0x0A };

CK_BBOOL ckb_true = CK_TRUE;
CK_BBOOL ckb_false = CK_FALSE;
