/*
             Common Public License Version 1.0

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means:
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program.

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program.

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution.


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations.

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive.

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation.

*/

/* (C) COPYRIGHT International Business Machines Corp. 2001,2002,2013      */

/***************************************************************************
                          Change Log
                          ==========
****************************************************************************/
#define _BSD_SOURCE

#include <pthread.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdint.h>

#include "pkcs11types.h"
#include "defs.h"
#include "host_defs.h"
#include "h_extern.h"
#include "errno.h"
#include "tok_specific.h"
#include "tok_struct.h"
#include "stdll.h"
#include "attributes.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <endian.h>
#include <lber.h>
#include <asm/zcrypt.h>
#include <syslog.h>
#include <dlfcn.h>
#include <lber.h>

#include "ep11.h"
#define EP11SHAREDLIB "libep11.so"


/* logging stuff */
static int   EP11Tok_loglevel = 0;
static FILE *EP11Tok_logfile = NULL;

#define EP11TOK_LOGFILEMASK "/var/log/ock_ep11_token.%u.log"

#define EP11TOK_LOG(_loglevel, _format, ...) {                                      \
        if (EP11Tok_loglevel >= _loglevel && EP11Tok_logfile) {                     \
            fprintf(EP11Tok_logfile, "%s " _format "\n", __func__, ## __VA_ARGS__); \
	    ock_logit("EP11_TOK DEBUG %s " _format "\n", __func__, ## __VA_ARGS__); }}

#define EP11TOK_ELOG(_loglevel, _format, ...) {                                            \
        if (EP11Tok_loglevel >= _loglevel && EP11Tok_logfile) {                            \
            fprintf(EP11Tok_logfile, "ERROR: %s " _format "\n", __func__, ## __VA_ARGS__); \
  	    OCK_SYSLOG(LOG_ERR, _format, ## __VA_ARGS__);		                   \
	    ock_logit("EP11_TOK ERROR %s " _format "\n", __func__, ## __VA_ARGS__); }}

#define EP11TOK_DUMP(_loglevel, _text, _buf, _buflen) {                  \
        if (EP11Tok_loglevel >= _loglevel && EP11Tok_logfile) {          \
            int i; char str[1024];                                       \
            for (i=0; i < (_buflen) && 2*i < sizeof(str)-2; i++) {       \
                sprintf(str+2*i, "%02hhx", ((unsigned char*)(_buf))[i]); \
                *(str+2*i+2) = '\0'; }                                   \
            fprintf(EP11Tok_logfile, _text " %s\n", str);                \
	    ock_logit("EP11_TOK DEBUG " _text " %s\n", str); }}


CK_CHAR manuf[] = "IBM Corp.";
CK_CHAR model[] = "IBM EP11Tok ";
CK_CHAR descr[] = "IBM PKCS#11 EP11 token";
CK_CHAR label[] = "IBM OS PKCS#11   ";

/* needed for import of keys:
   an imported key is encrypted by the 'wrap key' and
   then m_UnwrapKey (called with the encrypted key and the 'wrap key') builds the blob */
#define WRAP_TEMPLATE							\
    CK_ULONG len = 16;                                      \
    CK_BBOOL cktrue = 1;                                                \
    CK_MECHANISM mech   = { CKM_AES_KEY_GEN, NULL_PTR, 0 };				\
    CK_ATTRIBUTE wrap_tmpl[] = {{CKA_VALUE_LEN, &len, sizeof(CK_ULONG)}, \
                                {CKA_WRAP,(void *) &cktrue, sizeof(cktrue)} , \
                                {CKA_UNWRAP,(void *) &cktrue, sizeof(cktrue)}, \
                                {CKA_ENCRYPT,(void *) &cktrue, sizeof(cktrue)}, \
                                {CKA_DECRYPT,(void *) &cktrue, sizeof(cktrue)}, \
                                {CKA_EXTRACTABLE,(void *) &cktrue, sizeof(cktrue) }, \
                                {CKA_LABEL,(void *) wrap_key_name, sizeof(wrap_key_name)}, \
                                {CKA_TOKEN,(void *) &cktrue, sizeof(cktrue)}};

/* largest blobsize ever seen is about 5k (for 4096 mod bits RSA keys) */
#define blobsize   2048*4
#define MAX_APQN 256

/* wrap_key is used for importing keys */
char             wrap_key_name[16];
/* blob and blobsize of wrap key */
CK_BYTE  raw2key_wrap_blob[blobsize];
size_t   raw2key_wrap_blob_l = 0;

/* blob id for debugging */
static unsigned long long ep11_blobs = 0;

/* blobs are stored in attribute IBM_OPAQUE and this is the layout */
typedef struct {
	size_t	blob_size;
	size_t	blob_id;
	unsigned char blob[blobsize];
} ep11_opaque;

/* target list of adapters/domains, specified in a config file by user,
   tells the device driver which adapter/domain pairs should be used,
   they must have the same master key */
typedef struct {
	short format;
	short length;
	short apqns[2*MAX_APQN];
} __attribute__((packed)) ep11_target_t;


static ep11_target_t ep11_targets;

/* defined in the makefile, ep11 library can run standalone (without HW card),
   crypto algorithms are implemented in software then (no secure key) */
#ifdef EP11_STANDALONE
static unsigned long long ep11tok_target = 0x0000000100000008ull;
#else
static void* ep11tok_target = (void*) &ep11_targets;
#endif

/* */
static unsigned char *ep11_pin_blob = NULL;
static CK_ULONG ep11_pin_blob_len = 0;

/* mechanisms yet unknown by ock, but known by EP11 */
#define CKM_SHA224_RSA_PKCS       0x00000046
#define CKM_SHA224_RSA_PKCS_PSS   0x00000047
#define CKM_SHA384_RSA_PKCS_PSS   0x00000044
#define CKM_SHA512_RSA_PKCS_PSS   0x00000045
#define CKM_SHA224                0x00000255
#define CKM_SHA224_KEY_DERIVATION 0x00000396
#define CKM_SHA256_RSA_PKCS_PSS   0x00000043
#define CKM_SHA224_HMAC           0x00000256
#define CKM_SHA384_KEY_DERIVATION 0x00000394
#define CKM_SHA512_KEY_DERIVATION 0x00000395

static pthread_mutex_t ep11blob_lock = PTHREAD_MUTEX_INITIALIZER;

static CK_BBOOL ep11_initialized = FALSE;

static unsigned long long ep11_blobs_inc()
{
	unsigned long long count;

	pthread_mutex_lock(&ep11blob_lock);
	count = ep11_blobs++;
	pthread_mutex_unlock(&ep11blob_lock);
	return count;
}


static CK_RV
check_key_attributes(CK_KEY_TYPE kt, CK_OBJECT_CLASS kc, CK_ATTRIBUTE_PTR attrs,
		     CK_ULONG attrs_len, CK_ATTRIBUTE_PTR *p_attrs,
		     CK_ULONG *p_attrs_len) {

	CK_RV rc;
	CK_ULONG i;
	CK_BBOOL true = TRUE;
	CK_ULONG check_types_pub[] = {CKA_VERIFY, CKA_ENCRYPT, CKA_WRAP };
	CK_ULONG check_types_priv[] = {CKA_SIGN, CKA_DECRYPT, CKA_UNWRAP };
	CK_ULONG check_types_sec[] =
			{CKA_ENCRYPT, CKA_DECRYPT, CKA_WRAP, CKA_UNWRAP};
	CK_ULONG check_types_gen_sec[] =
			{CKA_SIGN, CKA_VERIFY, CKA_ENCRYPT, CKA_DECRYPT};
	CK_ULONG check_types_derive[] = {CKA_DERIVE};
	CK_ULONG *check_types = NULL;
	CK_BBOOL *check_values[] = { &true, &true, &true, &true };
	CK_ULONG attr_cnt = 0;

	/* check/add attributes for public key template */
	if ((rc = dup_attribute_array(attrs, attrs_len,
					p_attrs, p_attrs_len)))
		return rc;

	switch (kc) {
		case CKO_SECRET_KEY:
			if (kt == CKK_GENERIC_SECRET) {
				check_types = &check_types_gen_sec[0];
				attr_cnt = sizeof(check_types_gen_sec)/sizeof(CK_ULONG);
			} else {
				check_types = &check_types_sec[0];
				attr_cnt = sizeof(check_types_sec)/sizeof(CK_ULONG);
		}
		break;
		case CKO_PUBLIC_KEY:
			if ((kt == CKK_EC) || (kt == CKK_ECDSA) ||
			    (kt == CKK_DSA)) {
				check_types = &check_types_pub[0];
				attr_cnt = 1; /* only CKA_VERIFY */
			} else if (kt == CKK_RSA) {
				check_types = &check_types_pub[0];
				attr_cnt = sizeof(check_types_pub)/sizeof(CK_ULONG);
			}
			/* do nothing for CKM_DH_PKCS_KEY_PAIR_GEN
			   and CKM_DH_PKCS_PARAMETER_GEN */
		break;
		case CKO_PRIVATE_KEY:
			if ((kt == CKK_EC) || (kt == CKK_ECDSA) ||
			    (kt == CKK_DSA)) {
				check_types = &check_types_priv[0];
				attr_cnt = 1; /* only CKA_SIGN */
			} else if (kt == CKK_RSA) {
				check_types = &check_types_priv[0];
				attr_cnt = sizeof(check_types_priv)/sizeof(CK_ULONG);
			} else if (kt == CKK_DH) {
				check_types = &check_types_derive[0];
				attr_cnt = sizeof(check_types_derive)/sizeof(CK_ULONG);
			}
		break;
		default:
			return CKR_OK;
	}

	for (i = 0; i < attr_cnt; i++, check_types++) {
		CK_ATTRIBUTE_PTR attr = get_attribute_by_type(*p_attrs,
					*p_attrs_len, *check_types);
		if (!attr) {
			rc = add_to_attribute_array(p_attrs, p_attrs_len,
						*check_types,
						(CK_BYTE *) check_values[i],
						sizeof(*check_values[i]));
			if (rc)
				goto cleanup;
		}
	}
	return CKR_OK;
cleanup:
	if (rc) {
		free_attribute_array(*p_attrs, *p_attrs_len);
		*p_attrs = NULL;
		*p_attrs_len = 0;
	}
	return rc;
}

CK_RV
ber_encode_RSAPublicKey(CK_BBOOL length_only, CK_BYTE **data, CK_ULONG *data_len,
			CK_ATTRIBUTE *modulus, CK_ATTRIBUTE *publ_exp)
{
	CK_ULONG len, offset, total, total_len;
	CK_RV rc;
	CK_BYTE *buf = NULL;
	CK_BYTE *buf2 = NULL;
	CK_BYTE *buf3 = NULL;
	CK_BYTE *tmp = NULL;
	BerValue *val;
	BerElement *ber;

	offset = 0;
	rc = 0;
	total_len = ber_AlgIdRSAEncryptionLen;
	total = 0;

	rc |= ber_encode_INTEGER(TRUE, NULL, &len, NULL, modulus->ulValueLen);
	offset += len;
	rc |= ber_encode_INTEGER(TRUE, NULL, &len, NULL, publ_exp->ulValueLen);
	offset += len;

	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	}

	buf = (CK_BYTE *)malloc(offset);
	if (!buf) {
		OCK_LOG_ERR(ERR_HOST_MEMORY);
		return CKR_HOST_MEMORY;
	}
	offset = 0;
	rc = 0;

	rc = ber_encode_INTEGER(FALSE, &buf2, &len,
				(CK_BYTE *)modulus + sizeof(CK_ATTRIBUTE),
				modulus->ulValueLen);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_ENCODE_INT);
		return rc;
	}
	memcpy(buf+offset, buf2, len);
	offset += len;
	free(buf2);

	rc = ber_encode_INTEGER(FALSE, &buf2, &len,
				(CK_BYTE *)publ_exp + sizeof(CK_ATTRIBUTE),
				publ_exp->ulValueLen);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_ENCODE_INT);
		return rc;
	}
	memcpy(buf+offset, buf2, len);
	offset += len;
	free(buf2);

	rc = ber_encode_SEQUENCE(FALSE, &buf2, &len, buf, offset);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_ENCODE_SEQ);
		return rc;
	}

	/* length of outer sequence */
	rc = ber_encode_OCTET_STRING(TRUE, NULL, &total, buf2, len);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_ENCODE_OCTET);
		return rc;
	} else
		total_len += total + 1;

	/* mem for outer sequence */
	buf3 = (CK_BYTE *)malloc(total_len);
	if (!buf3) {
		OCK_LOG_ERR(ERR_HOST_MEMORY);
		return CKR_HOST_MEMORY;
	}
	total_len = 0;

	/* copy alg id */
	memcpy(buf3+total_len, ber_AlgIdRSAEncryption, ber_AlgIdRSAEncryptionLen);
	total_len += ber_AlgIdRSAEncryptionLen;

	/* need a bitstring */
	ber = ber_alloc_t(LBER_USE_DER);
	rc  = ber_put_bitstring(ber, buf2, len*8, 0x03);
	rc  = ber_flatten(ber, &val);
	memcpy(buf3+total_len, val->bv_val, val->bv_len);
	total_len += val->bv_len;

	rc = ber_encode_SEQUENCE(FALSE, data, data_len, buf3, total_len);
	if (rc != CKR_OK)
		OCK_LOG_ERR(ERR_ENCODE_SEQ);

	return rc;
}

/* get the public key from a SPKI
 *   SubjectPublicKeyInfo ::= SEQUENCE {
 *     algorithm         AlgorithmIdentifier,
 *     subjectPublicKey  BIT STRING
 *   }
 *
 *   AlgorithmIdentifier ::= SEQUENCE {
 *     algorithm   OBJECT IDENTIFIER,
 *     parameters  ANY DEFINED BY algorithm OPTIONAL
 *   }
 */
CK_RV
ep11_spki_key(CK_BYTE *spki, CK_BYTE **key, CK_ULONG *bit_str_len)
{
	CK_BYTE *out_seq,*id_seq,*bit_str;
	CK_BYTE *data;
	CK_ULONG data_len;
	CK_ULONG field_len;
	CK_ULONG key_len_bytes;
	CK_RV rc;
	CK_ULONG length_octets = 0;
	CK_ULONG len;

	*bit_str_len = 0;
	out_seq = spki;
	rc = ber_decode_SEQUENCE(out_seq, &data, &data_len, &field_len);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"ber_decode_SEQUENCE #1 failed rc=0x%lx", rc);
		return CKR_FUNCTION_FAILED;
	}

	id_seq = out_seq + field_len - data_len;
	/* get id seq length */
	rc = ber_decode_SEQUENCE(id_seq, &data, &data_len, &field_len);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"ber_decode_SEQUENCE #2 failed rc=0x%lx", rc);
		return CKR_FUNCTION_FAILED;
	}

	bit_str = id_seq + field_len;
	/* we should be at a bistring */
	if (bit_str[0] != 0x03) {
		EP11TOK_ELOG(1,"ber_decode no BITSTRING");
		return CKR_GENERAL_ERROR;
	}

	if ((bit_str[1] & 0x80) == 0) {
		key_len_bytes = 1;
		*bit_str_len = bit_str[1] & 0x7F;
	} else {
		key_len_bytes = 1 + (bit_str[1] & 0x7F);
	}

	*key = bit_str + key_len_bytes + 2; /* one 'unused bits' byte */

	if (*bit_str_len == 0) {
		length_octets = bit_str[1] & 0x7F;

		if (length_octets == 1) {
			len = bit_str[2];
		}

		if (length_octets == 2) {
			len = bit_str[2];
			len = len << 8;
			len |= bit_str[3];
		}

		if (length_octets == 3) {
			len = bit_str[2];
			len = len << 8;
			len |= bit_str[3];
			len = len << 8;
			len |= bit_str[4];
		}
		*bit_str_len = len;
	}

	return CKR_OK;
}


CK_RV 
ep11_get_keytype(CK_ATTRIBUTE *attrs, CK_ULONG attrs_len,
                 CK_MECHANISM_PTR mech, CK_ULONG *type, CK_ULONG *class)
{
	int i;
	CK_RV rc = CKR_TEMPLATE_INCONSISTENT;
  
	*type  = 0;
	*class = 0;
  
	for (i = 0; i < attrs_len; i++) {
		if (attrs[i].type == CKA_CLASS)
			*class = *(CK_ULONG *)attrs[i].pValue;
	}

	for (i = 0; i < attrs_len; i++) {
		if (attrs[i].type == CKA_KEY_TYPE) {
			*type = *(CK_ULONG *)attrs[i].pValue;
			return CKR_OK;
		}
	}
  
	/* no CKA_KEY_TYPE found, derive from mech */

	switch (mech->mechanism) {
	case CKM_DES_KEY_GEN:
		*type = CKK_DES;
		break;
    
	case CKM_DES3_KEY_GEN:
		*type = CKK_DES3;
		break;
    
	case CKM_CDMF_KEY_GEN:
		*type = CKK_CDMF;
		break;
    
	case CKM_AES_KEY_GEN:
		*type = CKK_AES;
		break;
    
	case CKM_RSA_PKCS_KEY_PAIR_GEN:
		*type = CKK_RSA;
		break;
    
	case CKM_EC_KEY_PAIR_GEN:
		*type = CKK_EC;
		break;
    
	case CKM_DSA_KEY_PAIR_GEN:
		*type = CKK_DSA;
		break;
    
	case CKM_DH_PKCS_KEY_PAIR_GEN:
		*type = CKK_DH;
		break;
    
	default:
		return CKR_MECHANISM_INVALID;
	}
  
	rc = CKR_OK;

error:
	return rc;
}

/* for logging, debugging */
static const char* ep11_get_ckm(CK_ULONG mechanism)
{
	switch(mechanism) {
	case CKM_RSA_PKCS_KEY_PAIR_GEN: return "CKM_RSA_PKCS_KEY_PAIR_GEN";
	case CKM_RSA_PKCS: return "CKM_RSA_PKCS";
	case CKM_RSA_9796: return "CKM_RSA_9796";
	case CKM_RSA_X_509: return "CKM_RSA_X_509";
	case CKM_MD2_RSA_PKCS: return "CKM_MD2_RSA_PKCS";
	case CKM_MD5_RSA_PKCS: return "CKM_MD5_RSA_PKCS";
	case CKM_SHA1_RSA_PKCS: return "CKM_SHA1_RSA_PKCS";
	case CKM_RIPEMD128_RSA_PKCS: return "CKM_RIPEMD128_RSA_PKCS";
	case CKM_RIPEMD160_RSA_PKCS: return "CKM_RIPEMD160_RSA_PKCS";
	case CKM_RSA_PKCS_OAEP: return "CKM_RSA_PKCS_OAEP";
	case CKM_RSA_X9_31_KEY_PAIR_GEN: return "CKM_RSA_X9_31_KEY_PAIR_GEN";
	case CKM_RSA_X9_31: return "CKM_RSA_X9_31";
	case CKM_SHA1_RSA_X9_31: return "CKM_SHA1_RSA_X9_31";
	case CKM_RSA_PKCS_PSS: return "CKM_RSA_PKCS_PSS";
	case CKM_SHA1_RSA_PKCS_PSS: return "CKM_SHA1_RSA_PKCS_PSS";
	case CKM_DSA_KEY_PAIR_GEN: return "CKM_DSA_KEY_PAIR_GEN";
	case CKM_DSA: return "CKM_DSA";
	case CKM_DSA_SHA1: return "CKM_DSA_SHA1";
	case CKM_DH_PKCS_KEY_PAIR_GEN: return "CKM_DH_PKCS_KEY_PAIR_GEN";
	case CKM_DH_PKCS_DERIVE: return "CKM_DH_PKCS_DERIVE";
	case CKM_X9_42_DH_KEY_PAIR_GEN: return "CKM_X9_42_DH_KEY_PAIR_GEN";
	case CKM_X9_42_DH_DERIVE: return "CKM_X9_42_DH_DERIVE";
	case CKM_X9_42_DH_HYBRID_DERIVE: return "CKM_X9_42_DH_HYBRID_DERIVE";
	case CKM_X9_42_MQV_DERIVE: return "CKM_X9_42_MQV_DERIVE";
	case CKM_SHA256_RSA_PKCS: return "CKM_SHA256_RSA_PKCS";
	case CKM_SHA384_RSA_PKCS: return "CKM_SHA384_RSA_PKCS";
	case CKM_SHA512_RSA_PKCS: return "CKM_SHA512_RSA_PKCS";
	case CKM_RC2_KEY_GEN: return "CKM_RC2_KEY_GEN";
	case CKM_RC2_ECB: return "CKM_RC2_ECB";
	case CKM_RC2_CBC: return "CKM_RC2_CBC";
	case CKM_RC2_MAC: return "CKM_RC2_MAC";
	case CKM_RC2_MAC_GENERAL: return "CKM_RC2_MAC_GENERAL";
	case CKM_RC2_CBC_PAD: return "CKM_RC2_CBC_PAD";
	case CKM_RC4_KEY_GEN: return "CKM_RC4_KEY_GEN";
	case CKM_RC4: return "CKM_RC4";
	case CKM_DES_KEY_GEN: return "CKM_DES_KEY_GEN";
	case CKM_DES_ECB: return "CKM_DES_ECB";
	case CKM_DES_CBC: return "CKM_DES_CBC";
	case CKM_DES_MAC: return "CKM_DES_MAC";
	case CKM_DES_MAC_GENERAL: return "CKM_DES_MAC_GENERAL";
	case CKM_DES_CBC_PAD: return "CKM_DES_CBC_PAD";
	case CKM_DES2_KEY_GEN: return "CKM_DES2_KEY_GEN";
	case CKM_DES3_KEY_GEN: return "CKM_DES3_KEY_GEN";
	case CKM_DES3_ECB: return "CKM_DES3_ECB";
	case CKM_DES3_CBC: return "CKM_DES3_CBC";
	case CKM_DES3_MAC: return "CKM_DES3_MAC";
	case CKM_DES3_MAC_GENERAL: return "CKM_DES3_MAC_GENERAL";
	case CKM_DES3_CBC_PAD: return "CKM_DES3_CBC_PAD";
	case CKM_CDMF_KEY_GEN: return "CKM_CDMF_KEY_GEN";
	case CKM_CDMF_ECB: return "CKM_CDMF_ECB";
	case CKM_CDMF_CBC: return "CKM_CDMF_CBC";
	case CKM_CDMF_MAC: return "CKM_CDMF_MAC";
	case CKM_CDMF_MAC_GENERAL: return "CKM_CDMF_MAC_GENERAL";
	case CKM_CDMF_CBC_PAD: return "CKM_CDMF_CBC_PAD";
	case CKM_MD2: return "CKM_MD2";
	case CKM_MD2_HMAC: return "CKM_MD2_HMAC";
	case CKM_MD2_HMAC_GENERAL: return "CKM_MD2_HMAC_GENERAL";
	case CKM_MD5: return "CKM_MD5";
	case CKM_MD5_HMAC: return "CKM_MD5_HMAC";
	case CKM_MD5_HMAC_GENERAL: return "CKM_MD5_HMAC_GENERAL";
	case CKM_SHA_1: return "CKM_SHA_1";
	case CKM_SHA_1_HMAC: return "CKM_SHA_1_HMAC";
	case CKM_SHA_1_HMAC_GENERAL: return "CKM_SHA_1_HMAC_GENERAL";
	case CKM_RIPEMD128: return "CKM_RIPEMD128";
	case CKM_RIPEMD128_HMAC: return "CKM_RIPEMD128_HMAC";
	case CKM_RIPEMD128_HMAC_GENERAL: return "CKM_RIPEMD128_HMAC_GENERAL";
	case CKM_RIPEMD160: return "CKM_RIPEMD160";
	case CKM_RIPEMD160_HMAC: return "CKM_RIPEMD160_HMAC";
	case CKM_RIPEMD160_HMAC_GENERAL: return "CKM_RIPEMD160_HMAC_GENERAL";
	case CKM_SHA256: return "CKM_SHA256";
	case CKM_SHA256_HMAC: return "CKM_SHA256_HMAC";
	case CKM_SHA256_HMAC_GENERAL: return "CKM_SHA256_HMAC_GENERAL";
	case CKM_SHA384: return "CKM_SHA384";
	case CKM_SHA384_HMAC: return "CKM_SHA384_HMAC";
	case CKM_SHA384_HMAC_GENERAL: return "CKM_SHA384_HMAC_GENERAL";
	case CKM_SHA512: return "CKM_SHA512";
	case CKM_SHA512_HMAC: return "CKM_SHA512_HMAC";
	case CKM_SHA512_HMAC_GENERAL: return "CKM_SHA512_HMAC_GENERAL";
	case CKM_CAST_KEY_GEN: return "CKM_CAST_KEY_GEN";
	case CKM_CAST_ECB: return "CKM_CAST_ECB";
	case CKM_CAST_CBC: return "CKM_CAST_CBC";
	case CKM_CAST_MAC: return "CKM_CAST_MAC";
	case CKM_CAST_MAC_GENERAL: return "CKM_CAST_MAC_GENERAL";
	case CKM_CAST_CBC_PAD: return "CKM_CAST_CBC_PAD";
	case CKM_CAST3_KEY_GEN: return "CKM_CAST3_KEY_GEN";
	case CKM_CAST3_ECB: return "CKM_CAST3_ECB";
	case CKM_CAST3_CBC: return "CKM_CAST3_CBC";
	case CKM_CAST3_MAC: return "CKM_CAST3_MAC";
	case CKM_CAST3_MAC_GENERAL: return "CKM_CAST3_MAC_GENERAL";
	case CKM_CAST3_CBC_PAD: return "CKM_CAST3_CBC_PAD";
	case CKM_CAST5_KEY_GEN: return "CKM_CAST5_KEY_GEN";
	case CKM_CAST5_ECB: return "CKM_CAST5_ECB";
	case CKM_CAST5_CBC: return "CKM_CAST5_CBC";
	case CKM_CAST5_MAC: return "CKM_CAST5_MAC";
	case CKM_CAST5_MAC_GENERAL: return "CKM_CAST5_MAC_GENERAL";
	case CKM_CAST5_CBC_PAD: return "CKM_CAST5_CBC_PAD";
	case CKM_RC5_KEY_GEN: return "CKM_RC5_KEY_GEN";
	case CKM_RC5_ECB: return "CKM_RC5_ECB";
	case CKM_RC5_CBC: return "CKM_RC5_CBC";
	case CKM_RC5_MAC: return "CKM_RC5_MAC";
	case CKM_RC5_MAC_GENERAL: return "CKM_RC5_MAC_GENERAL";
	case CKM_RC5_CBC_PAD: return "CKM_RC5_CBC_PAD";
	case CKM_IDEA_KEY_GEN: return "CKM_IDEA_KEY_GEN";
	case CKM_IDEA_ECB: return "CKM_IDEA_ECB";
	case CKM_IDEA_CBC: return "CKM_IDEA_CBC";
	case CKM_IDEA_MAC: return "CKM_IDEA_MAC";
	case CKM_IDEA_MAC_GENERAL: return "CKM_IDEA_MAC_GENERAL";
	case CKM_IDEA_CBC_PAD: return "CKM_IDEA_CBC_PAD";
	case CKM_GENERIC_SECRET_KEY_GEN: return "CKM_GENERIC_SECRET_KEY_GEN";
	case CKM_CONCATENATE_BASE_AND_KEY: return "CKM_CONCATENATE_BASE_AND_KEY";
	case CKM_CONCATENATE_BASE_AND_DATA: return "CKM_CONCATENATE_BASE_AND_DATA";
	case CKM_CONCATENATE_DATA_AND_BASE: return "CKM_CONCATENATE_DATA_AND_BASE";
	case CKM_XOR_BASE_AND_DATA: return "CKM_XOR_BASE_AND_DATA";
	case CKM_EXTRACT_KEY_FROM_KEY: return "CKM_EXTRACT_KEY_FROM_KEY";
	case CKM_SSL3_PRE_MASTER_KEY_GEN: return "CKM_SSL3_PRE_MASTER_KEY_GEN";
	case CKM_SSL3_MASTER_KEY_DERIVE: return "CKM_SSL3_MASTER_KEY_DERIVE";
	case CKM_SSL3_KEY_AND_MAC_DERIVE: return "CKM_SSL3_KEY_AND_MAC_DERIVE";
	case CKM_SSL3_MASTER_KEY_DERIVE_DH: return "CKM_SSL3_MASTER_KEY_DERIVE_DH";
	case CKM_TLS_PRE_MASTER_KEY_GEN: return "CKM_TLS_PRE_MASTER_KEY_GEN";
	case CKM_TLS_MASTER_KEY_DERIVE: return "CKM_TLS_MASTER_KEY_DERIVE";
	case CKM_TLS_KEY_AND_MAC_DERIVE: return "CKM_TLS_KEY_AND_MAC_DERIVE";
	case CKM_TLS_MASTER_KEY_DERIVE_DH: return "CKM_TLS_MASTER_KEY_DERIVE_DH";
	case CKM_SSL3_MD5_MAC: return "CKM_SSL3_MD5_MAC";
	case CKM_SSL3_SHA1_MAC: return "CKM_SSL3_SHA1_MAC";
	case CKM_MD5_KEY_DERIVATION: return "CKM_MD5_KEY_DERIVATION";
	case CKM_MD2_KEY_DERIVATION: return "CKM_MD2_KEY_DERIVATION";
	case CKM_SHA1_KEY_DERIVATION: return "CKM_SHA1_KEY_DERIVATION";
	case CKM_SHA256_KEY_DERIVATION: return "CKM_SHA256_KEY_DERIVATION";
	case CKM_PBE_MD2_DES_CBC: return "CKM_PBE_MD2_DES_CBC";
	case CKM_PBE_MD5_DES_CBC: return "CKM_PBE_MD5_DES_CBC";
	case CKM_PBE_MD5_CAST_CBC: return "CKM_PBE_MD5_CAST_CBC";
	case CKM_PBE_MD5_CAST3_CBC: return "CKM_PBE_MD5_CAST3_CBC";
	case CKM_PBE_MD5_CAST5_CBC: return "CKM_PBE_MD5_CAST5_CBC";
	case CKM_PBE_SHA1_CAST5_CBC: return "CKM_PBE_SHA1_CAST5_CBC";
	case CKM_PBE_SHA1_RC4_128: return "CKM_PBE_SHA1_RC4_128";
	case CKM_PBE_SHA1_RC4_40: return "CKM_PBE_SHA1_RC4_40";
	case CKM_PBE_SHA1_DES3_EDE_CBC: return "CKM_PBE_SHA1_DES3_EDE_CBC";
	case CKM_PBE_SHA1_DES2_EDE_CBC: return "CKM_PBE_SHA1_DES2_EDE_CBC";
	case CKM_PBE_SHA1_RC2_128_CBC: return "CKM_PBE_SHA1_RC2_128_CBC";
	case CKM_PBE_SHA1_RC2_40_CBC: return "CKM_PBE_SHA1_RC2_40_CBC";
	case CKM_PKCS5_PBKD2: return "CKM_PKCS5_PBKD2";
	case CKM_PBA_SHA1_WITH_SHA1_HMAC: return "CKM_PBA_SHA1_WITH_SHA1_HMAC";
	case CKM_KEY_WRAP_LYNKS: return "CKM_KEY_WRAP_LYNKS";
	case CKM_KEY_WRAP_SET_OAEP: return "CKM_KEY_WRAP_SET_OAEP";
	case CKM_SKIPJACK_KEY_GEN: return "CKM_SKIPJACK_KEY_GEN";
	case CKM_SKIPJACK_ECB64: return "CKM_SKIPJACK_ECB64";
	case CKM_SKIPJACK_CBC64: return "CKM_SKIPJACK_CBC64";
	case CKM_SKIPJACK_OFB64: return "CKM_SKIPJACK_OFB64";
	case CKM_SKIPJACK_CFB64: return "CKM_SKIPJACK_CFB64";
	case CKM_SKIPJACK_CFB32: return "CKM_SKIPJACK_CFB32";
	case CKM_SKIPJACK_CFB16: return "CKM_SKIPJACK_CFB16";
	case CKM_SKIPJACK_CFB8: return "CKM_SKIPJACK_CFB8";
	case CKM_SKIPJACK_WRAP: return "CKM_SKIPJACK_WRAP";
	case CKM_SKIPJACK_PRIVATE_WRAP: return "CKM_SKIPJACK_PRIVATE_WRAP";
	case CKM_SKIPJACK_RELAYX: return "CKM_SKIPJACK_RELAYX";
	case CKM_KEA_KEY_PAIR_GEN: return "CKM_KEA_KEY_PAIR_GEN";
	case CKM_KEA_KEY_DERIVE: return "CKM_KEA_KEY_DERIVE";
	case CKM_FORTEZZA_TIMESTAMP: return "CKM_FORTEZZA_TIMESTAMP";
	case CKM_BATON_KEY_GEN: return "CKM_BATON_KEY_GEN";
	case CKM_BATON_ECB128: return "CKM_BATON_ECB128";
	case CKM_BATON_ECB96: return "CKM_BATON_ECB96";
	case CKM_BATON_CBC128: return "CKM_BATON_CBC128";
	case CKM_BATON_COUNTER: return "CKM_BATON_COUNTER";
	case CKM_BATON_SHUFFLE: return "CKM_BATON_SHUFFLE";
	case CKM_BATON_WRAP: return "CKM_BATON_WRAP";
	case CKM_EC_KEY_PAIR_GEN: return "CKM_EC_KEY_PAIR_GEN";
	case CKM_ECDSA: return "CKM_ECDSA";
	case CKM_ECDSA_SHA1: return "CKM_ECDSA_SHA1";
	case CKM_ECDH1_DERIVE: return "CKM_ECDH1_DERIVE";
	case CKM_ECDH1_COFACTOR_DERIVE: return "CKM_ECDH1_COFACTOR_DERIVE";
	case CKM_ECMQV_DERIVE: return "CKM_ECMQV_DERIVE";
	case CKM_JUNIPER_KEY_GEN: return "CKM_JUNIPER_KEY_GEN";
	case CKM_JUNIPER_ECB128: return "CKM_JUNIPER_ECB128";
	case CKM_JUNIPER_CBC128: return "CKM_JUNIPER_CBC128";
	case CKM_JUNIPER_COUNTER: return "CKM_JUNIPER_COUNTER";
	case CKM_JUNIPER_SHUFFLE: return "CKM_JUNIPER_SHUFFLE";
	case CKM_JUNIPER_WRAP: return "CKM_JUNIPER_WRAP";
	case CKM_FASTHASH: return "CKM_FASTHASH";
	case CKM_AES_KEY_GEN: return "CKM_AES_KEY_GEN";
	case CKM_AES_ECB: return "CKM_AES_ECB";
	case CKM_AES_CBC: return "CKM_AES_CBC";
	case CKM_AES_MAC: return "CKM_AES_MAC";
	case CKM_AES_MAC_GENERAL: return "CKM_AES_MAC_GENERAL";
	case CKM_AES_CBC_PAD: return "CKM_AES_CBC_PAD";
	case CKM_AES_CTR: return "CKM_AES_CTR";
	case CKM_DSA_PARAMETER_GEN: return "CKM_DSA_PARAMETER_GEN";
	case CKM_DH_PKCS_PARAMETER_GEN: return "CKM_DH_PKCS_PARAMETER_GEN";
	case CKM_X9_42_DH_PARAMETER_GEN: return "CKM_X9_42_DH_PARAMETER_GEN";
	case CKM_VENDOR_DEFINED: return "CKM_VENDOR_DEFINED";
	case CKM_SHA256_RSA_PKCS_PSS : return "CKM_SHA256_RSA_PKCS_PSS";
	case CKM_SHA224_RSA_PKCS: return "CKM_SHA224_RSA_PKCS";
	case CKM_SHA224_RSA_PKCS_PSS: return "CKM_SHA224_RSA_PKCS_PSS";
	case CKM_SHA384_RSA_PKCS_PSS: return "CKM_SHA384_RSA_PKCS_PSS";
	case CKM_SHA512_RSA_PKCS_PSS: return "CKM_SHA512_RSA_PKCS_PSS";
	case CKM_SHA224: return "CKM_SHA224";
	case CKM_SHA224_KEY_DERIVATION: return "CKM_SHA224_KEY_DERIVATION";
	case CKM_SHA224_HMAC: return "CKM_SHA224_HMAC";
	case CKM_SHA384_KEY_DERIVATION: return "CKM_SHA384_KEY_DERIVATION";
	case CKM_SHA512_KEY_DERIVATION: return "CKM_SHA512_KEY_DERIVATION";
	case CKM_VENDOR_DEFINED + 0x20007: return "CKM_IBM_ECDH1_DERIVE_RAW";
	case CKR_VENDOR_DEFINED + 0x1000c: return "CKM_IBM_EC_MULTIPLY";
	case CKM_VENDOR_DEFINED + 0x20006: return "CKM_IBM_DH_PKCS_DERIVE_RAW";
	case CKM_VENDOR_DEFINED + 0x20004: return "CKM_IBM_ATTRIBUTEBOUND_WRAP";
	case CKM_VENDOR_DEFINED + 0x1000d: return "CKM_IBM_EAC";
	case CKM_VENDOR_DEFINED + 0x40001: return "CKM_IBM_RETAINKEY";
	case CKM_VENDOR_DEFINED + 0x10007: return "CKA_IBM_MACKEY";
	default: EP11TOK_LOG(1,"unknown mechanism %lx",mechanism); return "UNKNOWN";
	}
}

static CK_RV h_opaque_2_blob(CK_OBJECT_HANDLE handle,
                             CK_BYTE **blob, size_t *blob_len, OBJECT **kobj);

#define EP11_DEFAULT_CFG_FILE "ep11tok.conf"
#define EP11_CFG_FILE_SIZE 4096

/* error rc for reading the adapter config file */
static const int APQN_FILE_INV_0 = 1;
static const int APQN_FILE_INV_1 = 2;
static const int APQN_FILE_INV_2 = 3;
static const int APQN_FILE_INV_3 = 4;
static const int APQN_FILE_INV_FILE_SIZE = 5;
static const int APQN_FILE_FILE_ACCESS    = 6;
static const int APQN_FILE_SYNTAX_ERROR_0 = 7;
static const int APQN_FILE_SYNTAX_ERROR_1 = 8;
static const int APQN_FILE_SYNTAX_ERROR_2 = 9;
static const int APQN_FILE_SYNTAX_ERROR_3 = 10;
static const int APQN_FILE_SYNTAX_ERROR_4 = 11;
static const int APQN_FILE_SYNTAX_ERROR_5 = 12;
static const int APQN_FILE_NO_APQN_GIVEN = 13;
static const int APQN_FILE_NO_APQN_MODE = 14;

static int read_adapter_config_file(const char* conf_name);

/* import a DES/AES key, that is, make a blob for a DES/AES key
 * that was not created by EP11 hardware, encrypt the key by the wrap key,
 * unwrap it by the wrap key
 */
static CK_RV rawkey_2_blob(unsigned char *key, CK_ULONG ksize,
			   CK_KEY_TYPE ktype, unsigned char *blob,
			   size_t *blen, OBJECT *key_obj)
{
	char   cipher[blobsize];
	CK_ULONG clen = blobsize;
	char csum[64];
	CK_ULONG cslen = 64;
	CK_BYTE iv[AES_BLOCK_SIZE];
	CK_MECHANISM mech = { CKM_AES_CBC_PAD, iv, AES_BLOCK_SIZE };
	DL_NODE *node = key_obj->template->attribute_list;
	CK_RV rc;
	CK_ATTRIBUTE_PTR p_attrs = NULL;
	CK_ULONG attrs_len = 0;
	CK_ATTRIBUTE_PTR new_p_attrs = NULL;
	CK_ULONG new_attrs_len = 0;

	/* tell ep11 the attributes the user specified */
	node = key_obj->template->attribute_list;
	while (node != NULL) {
		CK_ATTRIBUTE_PTR a = node->data;

		/* ep11 handles this as 'read only' and reports
		 * an error if specified
		 */
		if (CKA_NEVER_EXTRACTABLE == a->type || CKA_MODIFIABLE == a->type
		    || CKA_LOCAL == a->type)
			;
		else {
			rc = add_to_attribute_array(&p_attrs, &attrs_len,
						    a->type, a->pValue,
						    a->ulValueLen);
			if (rc != CKR_OK) {
				EP11TOK_ELOG(1, "adding attribute failed type=0x%lx rc=0x%lx", a->type, rc);
				goto rawkey_2_blob_end;
			}
		}

		node = node->next;
	}

	memset(cipher, 0, blobsize);
	memcpy(iv, "1234567812345678", AES_BLOCK_SIZE);

	/*
	 * calls the ep11 lib (which in turns sends the request to the card),
	 * all m_ function are ep11 functions
	 */
	rc = m_EncryptSingle(raw2key_wrap_blob,raw2key_wrap_blob_l, &mech,
			     key, ksize, cipher, &clen, ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1, "encrypt ksize=0x%lx clen=0x%lx rc=0x%lx",
			     ksize, clen, rc);
		goto rawkey_2_blob_end;
	}
	EP11TOK_LOG(2, "encrypt ksize=0x%lx clen=0x%lx rc=0x%lx", ksize, clen, rc);

	rc = check_key_attributes(ktype, CKO_SECRET_KEY, p_attrs, attrs_len,
				  &new_p_attrs, &new_attrs_len);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"RSA / EC check private key attributes failed with rc=0x%lx",rc);
		return rc;
	}

	/* the encrypted key is decrypted and a blob is build,
	 * card accepts only blobs as keys
	 */
	rc = m_UnwrapKey(cipher, clen, raw2key_wrap_blob, raw2key_wrap_blob_l,
			 NULL, ~0, ep11_pin_blob, ep11_pin_blob_len, &mech,
			 new_p_attrs,new_attrs_len, blob, blen, csum, &cslen,
			 ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"unwrap blen=%d rc=0x%lx ep11_blobs=0x%llx",
			     *blen,rc,ep11_blobs);
	} else {
		EP11TOK_LOG(2,"unwrap blen=%d rc=0x%lx ep11_blobs=0x%llx",
			    *blen,rc,ep11_blobs);
	}

	rawkey_2_blob_end:
	if (p_attrs != NULL)
		free_attribute_array(p_attrs, attrs_len);
	if (new_p_attrs)
		free_attribute_array(new_p_attrs, new_attrs_len);
	return rc;
}


static const char* print_flags(CK_ULONG flags)
{
	switch(flags) {
	case CKF_ENCRYPT: return "ENCRYPT";
	case CKF_DECRYPT: return "DECRYPT";
	case CKF_DIGEST : return "DIGEST";
	case CKF_SIGN   : return "SIGN";
	case CKF_SIGN_RECOVER      : return "SIGN_RECOVER";
	case CKF_VERIFY            : return "VERIFY";
	case CKF_VERIFY_RECOVER    : return "VERIFY_RECOVER";
	case CKF_GENERATE          : return "GENERATE";
	case CKF_GENERATE_KEY_PAIR : return "GENERATE_KEY_PAIR";
	case CKF_WRAP              : return "WRAP";
	case CKF_UNWRAP            : return "UNWRAP";
	case CKF_DERIVE            : return "DERIVE";
	/* The following are new for v2.11 */
	case CKF_EC_F_P            : return "CKF_EC_F_P";
	case CKF_EC_F_2M           : return "CKF_EC_F_2M";
	case CKF_EC_ECPARAMETERS   : return "EC_ECPARAMETERS";
	case CKF_EC_NAMEDCURVE     : return "EC_NAMEDCURVE";
	case CKF_EC_UNCOMPRESS     : return "EC_UNCOMPRESS";
	case CKF_EC_COMPRESS       : return "EC_COMPRESS";
	default                    : return "UNKNOWN";
	}
}


static CK_RV print_mechanism(void)
{
	CK_MECHANISM_TYPE_PTR list = NULL;
	CK_ULONG count = 0;
	int i;
	CK_MECHANISM_INFO m_info;
	CK_RV rc;

	/* first call is just to fetch the count value */
	rc = token_specific_get_mechanism_list(list, &count);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"can't fetch mechanism list.");
		return rc;		
	}
	list = (CK_MECHANISM_TYPE_PTR)malloc(sizeof(CK_MECHANISM_TYPE) * count);
	if (!list) {
		EP11TOK_ELOG(1,"Memory allocation failed.");
		return CKR_HOST_MEMORY;
	}

	/* now really fill the list */
	rc = token_specific_get_mechanism_list(list, &count);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"can't fetch mechanism list!");
		free(list);
		return rc;		
	}

	EP11TOK_LOG(2,"EP11 token mechanism list, %lu entries:", count);
	for (i = 0; i < count; i++) {
		char strflags[1024];
		strflags[0] = 0;
		memset(&m_info, 0, sizeof(m_info));
		token_specific_get_mechanism_info(list[i], &m_info);
		if (m_info.flags) {
			CK_ULONG flag;
			for (flag = 1; flag < 0x80000000; flag = flag * 2) {
				if ((flag & m_info.flags) != 0) {
					strcat(strflags, ",");
					strcat(strflags, print_flags(flag & m_info.flags));
				}
			}
		}
		EP11TOK_LOG(2," %s {%lu,%lu%s}", ep11_get_ckm(list[i]),
			    m_info.ulMinKeySize, m_info.ulMaxKeySize, strflags);
	}

	free(list);
	return CKR_OK;
}


/* random number generator */
CK_RV token_specific_rng(CK_BYTE *output, CK_ULONG bytes)
{
	CK_RV rc = m_GenerateRandom(output,bytes,ep11tok_target);
	if (rc != CKR_OK)
		EP11TOK_ELOG(1,"output=%p bytes=%lu rc=0x%lx", output, bytes, rc);
	return rc;
}


/* not used by opencryptoki */
int tok_slot2local(CK_SLOT_ID snum)
{
	return snum;
}

  

/*
 * for importing keys we need to encrypt the keys and build the blob by
 * m_UnwrapKey, use one wrap key for this purpose, can be any key,
 * we use an AES key
 */
static CK_RV make_wrapblob(CK_ATTRIBUTE *tmpl_in, CK_ULONG tmpl_len)
{
	CK_MECHANISM mech = {CKM_AES_KEY_GEN, NULL_PTR, 0};
	unsigned char csum[64];
	size_t csum_l = 64;
	CK_RV rc;


	if (raw2key_wrap_blob_l != 0) {
		EP11TOK_LOG(2,"blob already exists raw2key_wrap_blob_l=0x%x",
			    raw2key_wrap_blob_l);
		return CKR_OK;
	}

	raw2key_wrap_blob_l = blobsize;
	rc = m_GenerateKey(&mech, tmpl_in, tmpl_len, NULL,0, raw2key_wrap_blob,
			   &raw2key_wrap_blob_l, csum, &csum_l, ep11tok_target);


	if (rc != CKR_OK) {
		EP11TOK_ELOG(1, "end raw2key_wrap_blob_l=0x%x rc=0x%lx",
			     raw2key_wrap_blob_l, rc);
	} else {
		EP11TOK_LOG(2, "end raw2key_wrap_blob_l=0x%x rc=0x%lx",
			    raw2key_wrap_blob_l, rc);
	}

	return rc;
}

CK_RV token_specific_init(CK_SLOT_ID SlotNumber, char *conf_name)
{
	CK_RV rc;
	void *lib_ep11;
	const char *env_loglevel = getenv("OCK_EP11_TOKEN_LOGLEVEL");
  
	WRAP_TEMPLATE;
  
	if (env_loglevel) {
		int loglevel = atoi(env_loglevel);
		if (loglevel > 0) {
			/* create the log file */
			char logfilename[PATH_MAX];
			sprintf(logfilename, EP11TOK_LOGFILEMASK,
				(unsigned) getpid());
			EP11Tok_logfile = fopen(logfilename, "w+");
			if (!EP11Tok_logfile) {
				fprintf(stderr, "ERROR: ock_ep11_token: can't open log file '%s' (errno=%d) !!!\n", logfilename, errno);
				/* however, continue here,
			         * do not return CKR_DEVICE_ERROR;
				 */
			} else {
				EP11Tok_loglevel = loglevel;
			}
		} else {
			/* environment variable is present but value
			 * is 0 or invalid
			 */
			EP11Tok_loglevel = -1;
		}
	}
	EP11TOK_LOG(1,"init running");

	/* read ep11 specific config file with user specified adapter/domain pairs, loglevel, ... */
	rc = read_adapter_config_file(conf_name);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"ep11 config file error rc=0x%lx", rc);
		return CKR_GENERAL_ERROR;
	}
  
	/* wrap key name */
	memset(wrap_key_name, 0, sizeof(wrap_key_name));
	memcpy(wrap_key_name, "EP11_wrapkey", sizeof("EP11_wrapkey"));

	/* dynamically load in the ep11 shared library */
	lib_ep11 = dlopen(EP11SHAREDLIB, RTLD_GLOBAL | RTLD_NOW);
	if (!lib_ep11) {
		EP11TOK_ELOG(1,"Error loading shared lib '%s' [%s]", EP11SHAREDLIB, dlerror());
		return CKR_FUNCTION_FAILED;
	}
	/* call ep11 shared lib init */
	if (m_init() < 0) {
		EP11TOK_ELOG(1,"ep11 lib init failed");
		return CKR_DEVICE_ERROR;
	}
  
#ifndef XCP_STANDALONE
	/* for real HW on Z-series, this would open the
	 * device driver file /dev/zcrypt.
	 */
	if (m_init() < 0) {
		EP11TOK_ELOG(1,"open of the zcrypt device driver failed");
		return CKR_DEVICE_ERROR;
	}
#endif
        
	/* print mechanismlist to log file */
	rc = print_mechanism();
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"failure on fetching mechanism list rc=0x%lx, maybe wrong config ?", rc);
		return CKR_GENERAL_ERROR;
	}
    
	/* create an AES key needed for importing keys
	 * (encrypt by wrap_key and m_UnwrapKey by wrap key)
	 */
	rc = make_wrapblob(wrap_tmpl, 8);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"make_wrapblob failed rc=0x%lx", rc);
		return CKR_GENERAL_ERROR;
	}
    
	EP11TOK_LOG(1,"init done successfully");
    
	return CKR_OK;
}

CK_RV token_specific_final()
{
	EP11TOK_LOG(1,"final running");

	if (EP11Tok_logfile) {
		fflush(EP11Tok_logfile);
		fclose(EP11Tok_logfile);
		EP11Tok_logfile = NULL;
	}

	CK_RV rc = CKR_OK;
	return rc;
}


/*
 * makes blobs for private imported RSA keys and
 * SPKIs for public imported RSA keys.
 * Similar to rawkey_2_blob, but keys must follow a standard BER encoding.
 */
static CK_RV import_RSA_key(OBJECT *rsa_key_obj, CK_BYTE *blob, size_t *blob_size)
{
	CK_RV rc;
	CK_ATTRIBUTE *attr = NULL;
	WRAP_TEMPLATE;
	CK_BYTE iv[AES_BLOCK_SIZE];
	CK_MECHANISM mech_w = {CKM_AES_CBC_PAD, iv, AES_BLOCK_SIZE};
	CK_BYTE cipher[blobsize];
	CK_ULONG cipher_l = blobsize;
	DL_NODE *node;
	CK_ATTRIBUTE_PTR p_attrs = NULL;
	CK_ULONG attrs_len = 0;
	CK_ATTRIBUTE_PTR new_p_attrs = NULL;
	CK_ULONG new_attrs_len = 0;
	char csum[blobsize];
	CK_ULONG cslen = blobsize;
	CK_OBJECT_CLASS class;
	CK_BYTE *data;
	CK_ULONG data_len;

	memcpy(iv, "1234567812345678", AES_BLOCK_SIZE);

	/* need class for private/public key info */
	if (!template_attribute_find(rsa_key_obj->template, CKA_CLASS, &attr)) {
		EP11TOK_ELOG(1,"no CKA_CLASS");
		return CKR_TEMPLATE_INCOMPLETE;
	}

	/* m_Unwrap builds key blob in the card,
	 * tell ep11 the attributes the user specified for that key.
	 */
	node = rsa_key_obj->template->attribute_list;
	while (node != NULL) {
		CK_ATTRIBUTE_PTR a = node->data;

		/* ep11 handles this as 'read only' */
		if (CKA_NEVER_EXTRACTABLE == a->type ||
		    CKA_MODIFIABLE == a->type || CKA_LOCAL == a->type)
			;
		else {
			rc = add_to_attribute_array(&p_attrs, &attrs_len,
						    a->type, a->pValue,
						    a->ulValueLen);
			if (rc != CKR_OK) {
				EP11TOK_ELOG(1, "adding attribute failed type=0x%lx rc=0x%lx", a->type, rc);
				goto import_RSA_key_end;
			}
		}
        
		node = node->next;
	}
    
	class = *(CK_OBJECT_CLASS *)attr->pValue;
    
	/* an imported public RSA key, we need a SPKI for it. */
	if (class != CKO_PRIVATE_KEY) {
		CK_ATTRIBUTE *modulus;
		CK_ATTRIBUTE *publ_exp;

		if (!template_attribute_find(rsa_key_obj->template,
		    CKA_MODULUS, &modulus)) {
			rc = CKR_TEMPLATE_INCOMPLETE;
			goto import_RSA_key_end;
		}
		if (!template_attribute_find(rsa_key_obj->template,
		    CKA_PUBLIC_EXPONENT, &publ_exp)) {
			rc = CKR_TEMPLATE_INCOMPLETE;
			goto import_RSA_key_end;
		}

		/* our contribution to asn1.c,
		 * builds the BER encoding that is a SPKI.
		 */
		rc = ber_encode_RSAPublicKey(0, &data, &data_len,
					     modulus, publ_exp);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"public key import class=0x%lx rc=0x%lx data_len=0x%lx",class,rc,data_len);
			goto import_RSA_key_end;
		} else {
			EP11TOK_LOG(2,"public key import class=0x%lx rc=0x%lx data_len=0x%lx",class,rc,data_len);
		}
        
		/* save the SPKI as blob although it is not a blob.
		 * The card expects SPKIs as public keys.
		 */
		memcpy(blob, data, data_len);
		*blob_size = data_len;
		goto import_RSA_key_end;
	}

	/* only imported private RSA keys go here */

	/* extract the secret data to be wrapped
	 * since this is AES_CBC_PAD, padding is done in mechanism.
	 */
	rc = rsa_priv_wrap_get_data(rsa_key_obj->template, FALSE,
				    &data, &data_len);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_RSA_WRAP_GETDATA);
		goto import_RSA_key_end;
	}

	/* encrypt */
	rc = m_EncryptSingle(raw2key_wrap_blob, raw2key_wrap_blob_l, &mech_w,
			     data, data_len, cipher, &cipher_l, ep11tok_target);

	/* done with data */
	if (data != NULL)
		free (data);

	EP11TOK_LOG(2,"wrapping wrap key rc=0x%lx cipher_l=0x%lx",rc,cipher_l);
    
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"wrapping wrap key rc=0x%lx cipher_l=0x%lx",
			     rc, cipher_l);
		goto import_RSA_key_end;
	}

	rc = check_key_attributes(CKK_RSA, CKO_PRIVATE_KEY, p_attrs, attrs_len,
					&new_p_attrs, &new_attrs_len);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"RSA / EC check private key attributes failed with rc=0x%lx",rc);
		return rc;
	}

	/* calls the card, it decrypts the private RSA key,
	 * reads its BER format and builds a blob.
	 */
	rc = m_UnwrapKey(cipher,cipher_l, raw2key_wrap_blob, raw2key_wrap_blob_l,
			 NULL, ~0, ep11_pin_blob,ep11_pin_blob_len, &mech_w,
			 new_p_attrs,new_attrs_len, blob, blob_size, csum, &cslen,
			 ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"wrapping unwrap key rc=0x%lx blob_size=0x%x",
			     rc, *blob_size);
	} else {
		EP11TOK_LOG(2,"wrapping unwrap key rc=0x%lx blob_size=0x%x",
			    rc, *blob_size);
	}
    
import_RSA_key_end:
	if (p_attrs != NULL)
		free_attribute_array(p_attrs, attrs_len);
	if (new_p_attrs)
		free_attribute_array(new_p_attrs, new_attrs_len);
	return rc;
}

CK_RV 
token_specific_object_add(OBJECT *obj)
{
	CK_KEY_TYPE keytype;
	CK_ATTRIBUTE *attr = NULL;
	ep11_opaque new_op;
	CK_RV rc;

	/* get key type */
	if (template_attribute_find(obj->template, CKA_KEY_TYPE, &attr) == FALSE) {
		/* not a key, so nothing to do. Just return. */
		return CKR_OK;
	}

	keytype = *(CK_KEY_TYPE *)attr->pValue;

	memset(&new_op, 0, sizeof(new_op));
	new_op.blob_size = blobsize;

	/* only these keys can be imported */
	switch(keytype) {
	case CKK_RSA:
		rc = import_RSA_key(obj,new_op.blob,&new_op.blob_size);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"import RSA key rc=0x%lx blob_size=0x%x",
				     rc, new_op.blob_size);
			return CKR_FUNCTION_FAILED;
		}
		EP11TOK_LOG(2,"import RSA key rc=0x%lx blob_size=0x%x",
			    rc, new_op.blob_size);
		break;

	case CKK_DES2:
	case CKK_DES3:
	case CKK_AES:
	case CKK_GENERIC_SECRET:
		/* get key value */
		if (template_attribute_find(obj->template, CKA_VALUE, &attr) == FALSE) {
			EP11TOK_ELOG(1,"token_specific_object_add incomplete template");
			return CKR_TEMPLATE_INCOMPLETE;
		}
		/* attr holds key value specified by user,
		 * import that key (make a blob)
		 */
		rc = rawkey_2_blob(attr->pValue, attr->ulValueLen, keytype,
				   new_op.blob, &new_op.blob_size, obj);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"rawkey_2_blob rc=0x%lx blob_size=0x%x",
				     rc, new_op.blob_size);
			return CKR_FUNCTION_FAILED;
		}

		EP11TOK_LOG(2,"rawkey_2_blob rc=0x%lx blob_size=0x%x",
			    rc, new_op.blob_size);

		break;
	default:
		return CKR_KEY_FUNCTION_NOT_PERMITTED;
	}

	new_op.blob_id = ep11_blobs_inc();
  
	/* store the blob in the key obj */
	rc = build_attribute(CKA_IBM_OPAQUE, (CK_BYTE *) &new_op,
			     sizeof(ep11_opaque), &attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		return rc;
	}
  
	rc = template_update_attribute(obj->template, attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
		return rc;
	}

	return CKR_OK;
}


CK_RV token_specific_generate_key(SESSION *session, CK_MECHANISM_PTR mech,
                                  CK_ATTRIBUTE_PTR attrs, CK_ULONG attrs_len,
                                  CK_OBJECT_HANDLE_PTR handle)
{
	ep11_opaque new_op;
	CK_BYTE csum[64];
	size_t csum_len = 64;
	CK_ATTRIBUTE *attr = NULL;
	OBJECT *key_obj = NULL;
	CK_ULONG ktype;
	CK_ULONG class;
	CK_ATTRIBUTE_PTR new_attrs = NULL;
	CK_ULONG new_attrs_len = 0;
	CK_RV rc;

	memset(&new_op, 0, sizeof(new_op));
	memset(csum, 0, sizeof(csum));
	new_op.blob_size = blobsize;

	/* Get the keytype to use when creating the key object */
	rc = ep11_get_keytype(attrs, attrs_len, mech, &ktype, &class);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"get_subclass failed with rc=0x%lx",rc);
		goto error;
	}

	rc = check_key_attributes(ktype, CKO_SECRET_KEY, attrs, attrs_len,
					&new_attrs, &new_attrs_len);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"check secret key attributes failed: rc=0x%lx",
			     rc);
		return rc;
	}

	rc = m_GenerateKey(mech, new_attrs, new_attrs_len, ep11_pin_blob,
				 ep11_pin_blob_len, new_op.blob,&new_op.blob_size,
				 csum,&csum_len, ep11tok_target);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"m_GenerateKey rc=0x%lx mech='%s' attrs_len=0x%lx",
			     rc, ep11_get_ckm(mech->mechanism), attrs_len);
		return rc;
	}

	EP11TOK_LOG(2,"m_GenerateKey rc=0x%lx mech='%s' attrs_len=0x%lx",
		    rc, ep11_get_ckm(mech->mechanism), attrs_len);
    
	/* Start creating the key object */
	rc = object_mgr_create_skel(session, new_attrs, new_attrs_len,
				    MODE_KEYGEN, CKO_SECRET_KEY, ktype,
				    &key_obj);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"object_mgr_create_skel failed with rc=0x%lx",rc);
		goto error;
	}
    
	rc = build_attribute(CKA_IBM_OPAQUE, (CK_BYTE *) &new_op,
			     sizeof(ep11_opaque), &attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto error;
	}
     
	rc = template_update_attribute(key_obj->template, attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
		goto error;
	}

	/* key should be fully constructed.
	 * Assign an object handle and store key
	 */
	rc = object_mgr_create_final(session, key_obj, handle);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"object_mgr_create_final with rc=0x%lx",rc);
		goto error;
	}
    
	goto done;
error:
	if (key_obj)
		object_free(key_obj);
	*handle = 0;
done:
	if (new_attrs)
		free_attribute_array(new_attrs, new_attrs_len);
	return rc;
}

CK_RV token_specific_sha_init(DIGEST_CONTEXT *c)
{
	CK_RV rc;
	CK_BYTE *state   = malloc(blobsize); /* freed by dig_mgr.c */
	if (!state) {
		EP11TOK_ELOG(1,"Memory allocation failed.");
		return CKR_HOST_MEMORY;
	}
	size_t state_len = blobsize;
	CK_MECHANISM mechanism = { CKM_SHA_1, NULL_PTR, 0 };

	rc = m_DigestInit (state, &state_len, &mechanism, ep11tok_target) ;

	if (rc != CKR_OK) {
		free(state);
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		/* DIGEST_CONTEXT will show up with following 
		 *  requests (sha_update), 'state' is build by the card
		 * and holds all to continue, even by another adapter
		 */
		c->mech = mechanism;
		c->context = state;
		c->context_len = state_len;
		
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_sha(DIGEST_CONTEXT *c, CK_BYTE *in_data,
			 CK_ULONG in_data_len, CK_BYTE *out_data,
			 CK_ULONG *out_data_len)
{
        CK_RV rc;
	
	rc = m_Digest(c->context, c->context_len, in_data, in_data_len,
		      out_data, out_data_len, ep11tok_target);
	
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}
	return rc;
}
	

CK_RV token_specific_sha_update(DIGEST_CONTEXT *c, CK_BYTE *in_data,
				CK_ULONG in_data_len)
{
	CK_RV rc;

	rc = m_DigestUpdate(c->context,c->context_len, in_data,in_data_len,
			    ep11tok_target) ;

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}
	return rc;
}


CK_RV token_specific_sha_final(DIGEST_CONTEXT *c, CK_BYTE *out_data,
				CK_ULONG *out_data_len)
{
	CK_RV rc;

	rc = m_DigestFinal(c->context,c->context_len, out_data,out_data_len,
			   ep11tok_target) ;

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_sha2_init(DIGEST_CONTEXT *c)
{
	CK_RV rc;
	CK_BYTE *state = malloc(blobsize);
	if (!state) {
		EP11TOK_ELOG(1,"Memory allocation failed.");
		return CKR_HOST_MEMORY;
	}
	size_t state_len = blobsize;
	CK_MECHANISM mechanism = { CKM_SHA256, NULL_PTR, 0 };

	rc = m_DigestInit (state, &state_len, &mechanism, ep11tok_target);

	if (rc != CKR_OK) {
		free(state);
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		c->mech = mechanism;
		c->context = state;
		c->context_len = state_len;
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}

CK_RV token_specific_sha3_init(DIGEST_CONTEXT *c)
{
	CK_RV rc;
	CK_BYTE *state = malloc(blobsize);
	if (!state) {
		EP11TOK_ELOG(1,"Memory allocation failed.");
		return CKR_HOST_MEMORY;
	}
	size_t state_len = blobsize;
	CK_MECHANISM mechanism = { CKM_SHA384, NULL_PTR, 0 };

	rc = m_DigestInit (state, &state_len, &mechanism, ep11tok_target) ;

	if (rc != CKR_OK) {
		free(state);
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		c->mech = mechanism;
		c->context = state;
		c->context_len = state_len;
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_sha5_init(DIGEST_CONTEXT *c)
{
	CK_RV rc;
	CK_BYTE *state = malloc(blobsize);
	if (!state) {
		EP11TOK_ELOG(1,"Memory allocation failed.");
		return CKR_HOST_MEMORY;
	}
	size_t state_len = blobsize;
	CK_MECHANISM mechanism = { CKM_SHA512, NULL_PTR, 0 };

	rc = m_DigestInit (state, &state_len, &mechanism, ep11tok_target) ;

	if (rc != CKR_OK) {
		free(state);
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		c->mech = mechanism;
		c->context = state;
		c->context_len = state_len;
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}

CK_RV token_specific_derive_key(SESSION *session, CK_MECHANISM_PTR mech,
				CK_OBJECT_HANDLE hBaseKey,
				CK_OBJECT_HANDLE_PTR handle,
				CK_ATTRIBUTE_PTR attrs, CK_ULONG attrs_len)
{
	CK_RV rc;
	unsigned char *blob;
	size_t blob_len = 0;
	ep11_opaque secret_op;
	char csum[blobsize];
	CK_ULONG cslen = blobsize;
	CK_ATTRIBUTE *opaque_attr = NULL;
	OBJECT *key_obj = NULL;
	CK_ULONG ktype;
	CK_ULONG class;
	CK_ATTRIBUTE_PTR new_attrs = NULL;
	CK_ULONG new_attrs_len = 0;

	memset(&secret_op, 0, sizeof(secret_op));
	secret_op.blob_size = blobsize;

	rc = h_opaque_2_blob(hBaseKey, &blob, &blob_len, &key_obj);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"FAIL hBaseKey=0x%lx",hBaseKey);
		return rc;
	}

	/* Get the keytype to use when creating the key object */
	rc = ep11_get_keytype(attrs, attrs_len, mech, &ktype, &class);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"get_subclass failed with rc=0x%lx", rc);
		goto error;
	}

	rc = check_key_attributes(ktype, class, attrs, attrs_len,
				&new_attrs, &new_attrs_len);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"Check key attributes for derived key failed with rc=0x%lx",rc);
		return rc;
	}

	rc = m_DeriveKey (mech, new_attrs, new_attrs_len, blob, blob_len, NULL,
			  0, ep11_pin_blob,ep11_pin_blob_len, secret_op.blob,
			  &secret_op.blob_size, csum, &cslen, ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"hBaseKey=0x%lx rc=0x%lx handle=0x%lx blob_size=0x%x", hBaseKey, rc, *handle, secret_op.blob_size);
		return rc;
	}
	EP11TOK_LOG(2,"hBaseKey=0x%lx rc=0x%lx handle=0x%lx blob_size=0x%x",
		    hBaseKey, rc, *handle, secret_op.blob_size);

	/* Start creating the key object */
	rc = object_mgr_create_skel(session, new_attrs, new_attrs_len,
				    MODE_DERIVE, class, ktype, &key_obj);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1, "object_mgr_create_skel failed with rc=0x%lx", rc);
		goto error;
	}
    
	rc = build_attribute(CKA_IBM_OPAQUE, (CK_BYTE *) &secret_op,
			     sizeof(ep11_opaque), &opaque_attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1, "build_attribute failed with rc=0x%lx", rc);
		goto error;
	}
     
	rc = template_update_attribute(key_obj->template, opaque_attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1, "template_update_attribute failed with rc=0x%lx", rc);
		goto error;
	}
    
	/* key should be fully constructed.
	 * Assign an object handle and store key
	 */
	rc = object_mgr_create_final(session, key_obj, handle);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1, "object_mgr_create_final with rc=0x%lx", rc);
		goto error;
	}
    
	return rc;

error:
	if (key_obj)
		object_free(key_obj);
	*handle = 0;
	if (new_attrs)
		free_attribute_array(new_attrs, new_attrs_len);
	return rc;
}


#define  CKA_IBM_STRUCT_PARAMS  (CKA_VENDOR_DEFINED +0x10009)

static CK_RV dh_generate_keypair(CK_MECHANISM_PTR pMechanism,
				 TEMPLATE *publ_tmpl, TEMPLATE *priv_tmpl,
				 CK_ATTRIBUTE_PTR pPublicKeyTemplate,
				 CK_ULONG ulPublicKeyAttributeCount,
				 CK_ATTRIBUTE_PTR pPrivateKeyTemplate,
				 CK_ULONG ulPrivateKeyAttributeCount,
				 CK_SESSION_HANDLE h)
{
	CK_RV  rc;
	ep11_opaque publ_op;
	ep11_opaque priv_op;
	CK_ATTRIBUTE *prime_attr = NULL;
	CK_ATTRIBUTE *base_attr = NULL;
	CK_ATTRIBUTE *opaque_attr = NULL;
	CK_ATTRIBUTE *value_attr = NULL;
	CK_ATTRIBUTE *attr = NULL;
	CK_ATTRIBUTE  *pPublicKeyTemplate_new = NULL;
	size_t p_len,g_len;
	int i,new_public_attr;
	CK_ULONG data_len;
	CK_ULONG field_len;
	CK_BYTE  *data;
	CK_BYTE  *y_start;
	int  ylen_bytes;
	CK_ULONG bit_str_len;

	/* ep11 accepts CKA_PRIME and CKA_BASE parameters/attributes
	 * only in this format
	 */
	struct {
		size_t pg_bytes; /* total size: 2*bytecount(P) */
		unsigned char *pg;
	} dh_pgs;

	memset(&publ_op, 0, sizeof(publ_op));
	memset(&priv_op, 0, sizeof(priv_op));
	publ_op.blob_size = blobsize;
	priv_op.blob_size = blobsize;

	/* card does not want CKA_PRIME/CKA_BASE in template but in dh_pgs */
	pPublicKeyTemplate_new = (CK_ATTRIBUTE *)malloc(sizeof(CK_ATTRIBUTE) * ulPublicKeyAttributeCount);
	if (!pPublicKeyTemplate_new) {
		EP11TOK_ELOG(1,"Memory allocation failed.");
		return CKR_HOST_MEMORY;
	}
	memset(pPublicKeyTemplate_new, 0, sizeof(CK_ATTRIBUTE) * ulPublicKeyAttributeCount);

	for (i = 0, new_public_attr = 0; i < ulPublicKeyAttributeCount; i++) {
		/* filter out CKA_PRIME/CKA_BASE,
		 * but remember where they can  be found
		 */
		switch(pPublicKeyTemplate[i].type) {
		case CKA_PRIME:
			prime_attr = &(pPublicKeyTemplate[i]);
			p_len = pPublicKeyTemplate[i].ulValueLen;
			break;
		case CKA_BASE:
			base_attr = &(pPublicKeyTemplate[i]);
			g_len = pPublicKeyTemplate[i].ulValueLen;
			break;
		default:
			/* copy all other attributes */
			memcpy(&pPublicKeyTemplate_new[new_public_attr],
			       &(pPublicKeyTemplate[i]), sizeof(CK_ATTRIBUTE));
			new_public_attr++;
		}
	}

	if (prime_attr == NULL || base_attr == NULL) {
		EP11TOK_ELOG(1,"incomplete template prime_attr=%p base_attr=%p", prime_attr, base_attr);
		rc = CKR_TEMPLATE_INCOMPLETE;
		goto dh_generate_keypair_end;
	}

	/* copy CKA_PRIME/CKA_BASE to private template */
	rc = build_attribute(CKA_PRIME, prime_attr->pValue,
			     prime_attr->ulValueLen, &attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto dh_generate_keypair_end;
	}
	rc = template_update_attribute(priv_tmpl, attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
		goto dh_generate_keypair_end;
	}
	rc = build_attribute(CKA_BASE, base_attr->pValue,
				base_attr->ulValueLen, &attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto dh_generate_keypair_end;
	}
	rc = template_update_attribute(priv_tmpl, attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
		goto dh_generate_keypair_end;
	}

	/* copy CKA_PRIME/CKA_BASE values */
	dh_pgs.pg = malloc(p_len*2);
	if (!dh_pgs.pg) {
		EP11TOK_ELOG(1,"Memory allocation failed.");
		return CKR_HOST_MEMORY;
	}
	memset(dh_pgs.pg,0,p_len*2);
	memcpy(dh_pgs.pg,prime_attr->pValue,p_len); /* copy CKA_PRIME value */
	/* copy CKA_BASE value, it must have leading zeros
	 * if it is shorter than CKA_PRIME
	 */
	memcpy(dh_pgs.pg + p_len + (p_len - g_len),base_attr->pValue,g_len);
	dh_pgs.pg_bytes = p_len * 2;

	EP11TOK_DUMP(2, "P:", &dh_pgs.pg[0], p_len);
	EP11TOK_DUMP(2, "G:", &dh_pgs.pg[p_len], p_len);

	/* add special attribute, do not add it to ock's pPublicKeyTemplate */
	CK_ATTRIBUTE pgs[] = { CKA_IBM_STRUCT_PARAMS, (CK_VOID_PTR) dh_pgs.pg,
				dh_pgs.pg_bytes };
	memcpy(&(pPublicKeyTemplate_new[new_public_attr]),
		&(pgs[0]), sizeof(CK_ATTRIBUTE));

	rc = m_GenerateKeyPair(pMechanism, pPublicKeyTemplate_new,
				new_public_attr+1, pPrivateKeyTemplate,
				ulPrivateKeyAttributeCount, ep11_pin_blob,
				ep11_pin_blob_len, priv_op.blob,
				&priv_op.blob_size, publ_op.blob,
				&publ_op.blob_size, ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"m_GenerateKeyPair failed rc=0x%lx", rc);
		goto dh_generate_keypair_end;
	}

	/* only debug */
	publ_op.blob_id = ep11_blobs_inc();
	priv_op.blob_id = ep11_blobs_inc();

	EP11TOK_LOG(2,"rc=0x%lx blobs1=0x%llx blobs2=0x%llx plen=%d pub.blob_size=0x%x priv.blob_size=0x%x",
		rc, ep11_blobs-1, ep11_blobs-2, p_len, publ_op.blob_size,
		priv_op.blob_size);

	/* store the blobs */
	rc = build_attribute(CKA_IBM_OPAQUE, (CK_BYTE *) &publ_op,
			     sizeof(ep11_opaque), &opaque_attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto dh_generate_keypair_end;
	}

	rc = template_update_attribute(publ_tmpl, opaque_attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
		goto dh_generate_keypair_end;
	}
    
	rc = build_attribute(CKA_IBM_OPAQUE, (CK_BYTE *) &priv_op,
			     sizeof(ep11_opaque), &opaque_attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto dh_generate_keypair_end;
	}
      
	rc = template_update_attribute(priv_tmpl, opaque_attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
		goto dh_generate_keypair_end;
	}

	/* only debug */
	EP11TOK_DUMP(2, "DH SPKI", publ_op.blob, publ_op.blob_size);

	/* CKA_VALUE of the public key must hold 'y' */
	rc = ep11_spki_key(publ_op.blob, &y_start, &bit_str_len);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"ber_decode SKPI failed rc=0x%lx", rc);
		rc = CKR_GENERAL_ERROR;
		goto dh_generate_keypair_end;
	}

	/* DHPublicKey ::= INTEGER -- public key, y = g^x mod p */
	rc = ber_decode_INTEGER(y_start, &data, &data_len, &field_len);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"ber_decode_INTEGER failed rc=0x%lx", rc);
		rc = CKR_GENERAL_ERROR;
		goto dh_generate_keypair_end;
	}

	EP11TOK_LOG(2,"DH SPKI decode INTEGER rc=0x%lx y_start=0x%x field_len=%lu data_len=%lu data=0x%hhx",
		    rc, y_start[1], field_len, data_len, data[0]);

	/* remove leading zero, a leading zero is needed
	 * (according to standard) if left most bit of first byte is 1,
	 * in order to indicate a positive number.
	 * ock, like many others, interpret 'y' always as positive number,
	 * a leading zero is not expected by ock.
	 */
	if (data[0] == 0) {
		data_len = data_len - 1;
		data = data + 1;
		EP11TOK_LOG(2,"DH SPKI removed leading zero rc=0x%lx y_start=0x%x field_len=%lu data_len=%lu data=0x%hhx",
			    rc, y_start[1], field_len, data_len, data[0]);
	}

	rc = build_attribute(CKA_VALUE,data, data_len, &value_attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto dh_generate_keypair_end;
	}

	rc = template_update_attribute(publ_tmpl, value_attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
	}

dh_generate_keypair_end:
	free(pPublicKeyTemplate_new);
	if (dh_pgs.pg != NULL)
		free(dh_pgs.pg);
	return rc;
}

static CK_RV dsa_generate_keypair(CK_MECHANISM_PTR pMechanism,
				  TEMPLATE *publ_tmpl, TEMPLATE *priv_tmpl,
				  CK_ATTRIBUTE_PTR pPublicKeyTemplate,
				  CK_ULONG ulPublicKeyAttributeCount,
				  CK_ATTRIBUTE_PTR pPrivateKeyTemplate,
				  CK_ULONG ulPrivateKeyAttributeCount,
				  CK_SESSION_HANDLE h)
{
	CK_RV  rc;
	ep11_opaque publ_op;
	ep11_opaque priv_op;
	CK_ATTRIBUTE *prime_attr = NULL;
	CK_ATTRIBUTE *sub_prime_attr = NULL;
	CK_ATTRIBUTE *base_attr = NULL;
	CK_ATTRIBUTE *opaque_attr = NULL;
	CK_ATTRIBUTE *value_attr = NULL;
	CK_ATTRIBUTE *attr = NULL;
	size_t p_len,q_len,g_len;
	int i,new_public_attr;
	CK_ATTRIBUTE *pPublicKeyTemplate_new = NULL;
	CK_BYTE *key;
	CK_BYTE *data;
	CK_ULONG data_len,field_len,bit_str_len;
	CK_ATTRIBUTE_PTR dsa_pPublicKeyTemplate = NULL;
	CK_ULONG dsa_ulPublicKeyAttributeCount = 0;
	CK_ATTRIBUTE_PTR dsa_pPrivateKeyTemplate = NULL;
	CK_ULONG dsa_ulPrivateKeyAttributeCount = 0;

	/* ep11 accepts CKA_PRIME,CKA_SUBPRIME,CKA_BASE only in this format */
	struct {
		size_t pqg_bytes;   /* total size: 3*bytecount(P) */
		unsigned char *pqg;
	} dsa_pqgs;

	memset(&publ_op, 0, sizeof(publ_op));
	memset(&priv_op, 0, sizeof(priv_op));
	publ_op.blob_size = blobsize;
	priv_op.blob_size = blobsize;

	/* card does not want CKA_PRIME/CKA_BASE/CKA_SUBPRIME
	 * in template but in dsa_pqgs
	 */
	pPublicKeyTemplate_new = (CK_ATTRIBUTE *)malloc(sizeof(CK_ATTRIBUTE) * ulPublicKeyAttributeCount);
	if (!pPublicKeyTemplate_new) {
		EP11TOK_ELOG(1,"Memory allocation failed.");
		return CKR_HOST_MEMORY;
	}
	 memset(pPublicKeyTemplate_new, 0,
		sizeof(CK_ATTRIBUTE) * ulPublicKeyAttributeCount);

	for (i = 0, new_public_attr = 0; i < ulPublicKeyAttributeCount; i++) {
		switch(pPublicKeyTemplate[i].type) {
		case CKA_PRIME:
			prime_attr = &(pPublicKeyTemplate[i]);
			p_len = pPublicKeyTemplate[i].ulValueLen;
			break;
		case CKA_SUBPRIME:
			sub_prime_attr = &(pPublicKeyTemplate[i]);
			q_len = pPublicKeyTemplate[i].ulValueLen;
			break;
		case CKA_BASE:
			base_attr = &(pPublicKeyTemplate[i]);
			g_len = pPublicKeyTemplate[i].ulValueLen;
			break;
		default:
			/* copy all other attributes */
			memcpy(&pPublicKeyTemplate_new[new_public_attr],
			       &(pPublicKeyTemplate[i]), sizeof(CK_ATTRIBUTE));
			new_public_attr++;
		}
	}

	if (prime_attr == NULL || sub_prime_attr == NULL || base_attr == NULL)
		return CKR_TEMPLATE_INCOMPLETE;

	/* copy CKA_PRIME/CKA_BASE/CKA_SUBPRIME to private template */
	rc = build_attribute(CKA_PRIME, prime_attr->pValue,
			     prime_attr->ulValueLen, &attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto dsa_generate_keypair_end;
	}

	rc = template_update_attribute( priv_tmpl, attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
		goto dsa_generate_keypair_end;
	}

	rc = build_attribute(CKA_BASE, base_attr->pValue,
			     base_attr->ulValueLen, &attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto dsa_generate_keypair_end;
	}

	rc = template_update_attribute(priv_tmpl, attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
		goto dsa_generate_keypair_end;
	}

	rc = build_attribute(CKA_PRIME, sub_prime_attr->pValue,
			     sub_prime_attr->ulValueLen, &attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto dsa_generate_keypair_end;
	}

	rc = template_update_attribute(priv_tmpl, attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
		goto dsa_generate_keypair_end;
	}

	/* if CKA_SUBPRIME,CKA_BASE are smaller than CKA_PRIME
	 * then they are extented by leading zeros till they have
	 * the size of CKA_PRIME
	 */
	dsa_pqgs.pqg = malloc(p_len*3);
	if (!dsa_pqgs.pqg) {
		EP11TOK_ELOG(1,"Memory allocation failed.");
		return CKR_HOST_MEMORY;
	}
	memset(dsa_pqgs.pqg, 0, p_len*3);
	memcpy(dsa_pqgs.pqg, prime_attr->pValue, p_len);
	memcpy(dsa_pqgs.pqg + p_len + (p_len - q_len),
		sub_prime_attr->pValue, q_len);
	memcpy(dsa_pqgs.pqg + 2*p_len + (p_len - g_len),
		base_attr->pValue, g_len);
	dsa_pqgs.pqg_bytes = p_len * 3;

	EP11TOK_DUMP(2, "P:", &dsa_pqgs.pqg[0], p_len);
	EP11TOK_DUMP(2, "Q:", &dsa_pqgs.pqg[p_len], p_len);
	EP11TOK_DUMP(2, "G:", &dsa_pqgs.pqg[2*p_len], p_len);

	CK_ATTRIBUTE pqgs[] = { CKA_IBM_STRUCT_PARAMS, (CK_VOID_PTR)dsa_pqgs.pqg,
                            dsa_pqgs.pqg_bytes };
	/* add special attribute, do not add it to ock's pPublicKeyTemplate */
	memcpy(&(pPublicKeyTemplate_new[new_public_attr]),
		&(pqgs[0]), sizeof(CK_ATTRIBUTE));

	rc = check_key_attributes(CKK_DSA, CKO_PUBLIC_KEY,
				pPublicKeyTemplate_new, new_public_attr+1,
				&dsa_pPublicKeyTemplate,
				&dsa_ulPublicKeyAttributeCount);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"RSA / EC check public key attributes failed with rc=0x%lx",rc);
		return rc;
	}

	rc = check_key_attributes(CKK_DSA, CKO_PRIVATE_KEY,
				pPrivateKeyTemplate, ulPrivateKeyAttributeCount,
				&dsa_pPrivateKeyTemplate,
				&dsa_ulPrivateKeyAttributeCount);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"RSA / EC check private key attributes failed with rc=0x%lx",rc);
		return rc;
	}

	rc = m_GenerateKeyPair(pMechanism, dsa_pPublicKeyTemplate,
			       dsa_ulPublicKeyAttributeCount,
			       dsa_pPrivateKeyTemplate,
			       dsa_ulPrivateKeyAttributeCount, ep11_pin_blob,
			       ep11_pin_blob_len, priv_op.blob,
			       &priv_op.blob_size, publ_op.blob,
			       &publ_op.blob_size, ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"m_GenerateKeyPair failed rc=0x%lx", rc);
		goto dsa_generate_keypair_end;
	}

	publ_op.blob_id = ep11_blobs_inc();
	priv_op.blob_id = ep11_blobs_inc();

	EP11TOK_LOG(2,"rc=0x%lx blobs1=0x%llx blobs2=0x%llx p_len=%d pub.blob_size=0x%x priv.blob_size=0x%x npattr=0x%x",
		    rc, ep11_blobs-1, ep11_blobs-2, p_len, publ_op.blob_size,
		    priv_op.blob_size, new_public_attr+1);

	rc = build_attribute(CKA_IBM_OPAQUE, (CK_BYTE *) &publ_op,
			     sizeof(ep11_opaque), &opaque_attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto dsa_generate_keypair_end;
	}

	rc = template_update_attribute(publ_tmpl, opaque_attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
		goto dsa_generate_keypair_end;
	}

	rc = build_attribute(CKA_IBM_OPAQUE, (CK_BYTE *) &priv_op,
			     sizeof(ep11_opaque), &opaque_attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto dsa_generate_keypair_end;
	}
    
	rc = template_update_attribute(priv_tmpl, opaque_attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
		goto dsa_generate_keypair_end;
	}

	/* set CKA_VALUE of the public key, first get key from SPKI */
	rc = ep11_spki_key(publ_op.blob, &key, &bit_str_len);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"reading DSA SPKI failed with rc=0x%lx",rc);
		goto dsa_generate_keypair_end;
	}

	/* key must be an integer */
	rc = ber_decode_INTEGER(key, &data, &data_len, &field_len);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"reading DSA public key failed with rc=0x%lx",rc);
		goto dsa_generate_keypair_end;
	}

	EP11TOK_DUMP(2, "dsa_generate_keypair public key", data, data_len);

	rc = build_attribute(CKA_VALUE, data, data_len, &value_attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto dsa_generate_keypair_end;
	}

	rc = template_update_attribute(publ_tmpl, value_attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
	}

dsa_generate_keypair_end:
	free(pPublicKeyTemplate_new);
	if(dsa_pqgs.pqg != NULL)
		free(dsa_pqgs.pqg);
	if (dsa_pPublicKeyTemplate)
		free_attribute_array(dsa_pPublicKeyTemplate,
				     dsa_ulPublicKeyAttributeCount);
	if (dsa_pPrivateKeyTemplate)
		free_attribute_array(dsa_pPrivateKeyTemplate,
				     dsa_ulPrivateKeyAttributeCount);
    return rc;
}

static CK_RV rsa_ec_generate_keypair(CK_MECHANISM_PTR pMechanism,
				     TEMPLATE *publ_tmpl, TEMPLATE *priv_tmpl,
				     CK_ATTRIBUTE_PTR pPublicKeyTemplate,
				     CK_ULONG ulPublicKeyAttributeCount,
				     CK_ATTRIBUTE_PTR pPrivateKeyTemplate,
				     CK_ULONG ulPrivateKeyAttributeCount,
				     CK_SESSION_HANDLE h)
{
	CK_RV rc;
	CK_ATTRIBUTE *attr = NULL;
	CK_ATTRIBUTE *n_attr = NULL;
	unsigned char privkey_blob[blobsize];
	unsigned char spki[blobsize];
	size_t privkey_blob_len = blobsize;
	size_t spki_len = blobsize;
	ep11_opaque publ_op;
	ep11_opaque priv_op;
	int i;
	CK_ULONG bit_str_len;
	CK_BYTE *key;
	CK_BYTE *data;
	CK_ULONG data_len;
	CK_ULONG field_len;
	CK_ATTRIBUTE_PTR new_pPublicKeyTemplate = NULL;
	CK_ULONG new_ulPublicKeyAttributeCount = 0;
	CK_ATTRIBUTE_PTR new_pPrivateKeyTemplate = NULL;
	CK_ULONG new_ulPrivateKeyAttributeCount = 0;
	CK_ULONG ktype;

	if (pMechanism->mechanism == CKM_EC_KEY_PAIR_GEN)
		ktype = CKK_EC;
	else if ((pMechanism->mechanism == CKM_RSA_PKCS_KEY_PAIR_GEN) ||
		 (pMechanism->mechanism == CKM_RSA_X9_31_KEY_PAIR_GEN))
		ktype = CKK_RSA;
	else {
		EP11TOK_ELOG(1,"Neither RSA nor EC mech type provided for RSA/EC_key_pair_gen");
		return CKR_MECHANISM_INVALID;
	}

	rc = check_key_attributes(ktype, CKO_PUBLIC_KEY,
				  pPublicKeyTemplate, ulPublicKeyAttributeCount,
				  &new_pPublicKeyTemplate,
				  &new_ulPublicKeyAttributeCount);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"RSA / EC check public key attributes failed with rc=0x%lx",rc);
		return rc;
	}

	rc = check_key_attributes(ktype, CKO_PRIVATE_KEY, pPrivateKeyTemplate,
				  ulPrivateKeyAttributeCount,
				  &new_pPrivateKeyTemplate,
				  &new_ulPrivateKeyAttributeCount);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"RSA / EC check private key attributes failed with rc=0x%lx",rc);
		goto error;
	}

	/* debug */
	for (i = 0; i < new_ulPrivateKeyAttributeCount; i++) {
		EP11TOK_LOG(2,"gen priv attr type=0x%lx valuelen=0x%lx attrcnt=0x%lx",
			    new_pPrivateKeyTemplate[i].type,
			    new_pPrivateKeyTemplate[i].ulValueLen,
			    new_ulPrivateKeyAttributeCount);
	}

	rc = m_GenerateKeyPair(pMechanism, new_pPublicKeyTemplate,
			       new_ulPublicKeyAttributeCount, new_pPrivateKeyTemplate,
			       new_ulPrivateKeyAttributeCount, ep11_pin_blob,
			       ep11_pin_blob_len, privkey_blob,
			       &privkey_blob_len, spki,&spki_len,
			       ep11tok_target);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"m_GenerateKeyPair rc=0x%lx spki_len=0x%x privkey_blob_len=0x%x"
			     " ep11_blobs=0x%llx ep11_blobs+1=0x%llx mech='%s'",
			     rc, spki_len, privkey_blob_len, ep11_blobs,
			     ep11_blobs+1, ep11_get_ckm(pMechanism->mechanism));
		goto error;
	}
	EP11TOK_LOG(2,"m_GenerateKeyPair rc=0x%lx spki_len=0x%x privkey_blob_len=0x%x"
		    " ep11_blobs=0x%llx ep11_blobs+1=0x%llx mech='%s'",
		    rc, spki_len, privkey_blob_len, ep11_blobs, ep11_blobs+1,
		    ep11_get_ckm(pMechanism->mechanism));

	if (spki_len > blobsize || privkey_blob_len > blobsize) {
		EP11TOK_ELOG(1,"blobsize error");
		rc = CKR_KEY_INDIGESTIBLE;
		goto error;
	}

	memset(&publ_op, 0, sizeof(publ_op));
	memset(&priv_op, 0, sizeof(priv_op));

	memcpy(publ_op.blob,spki,spki_len);
	publ_op.blob_size = spki_len;
	publ_op.blob_id = ep11_blobs_inc();

	memcpy(priv_op.blob, privkey_blob, privkey_blob_len);
	priv_op.blob_size = privkey_blob_len;
	priv_op.blob_id = ep11_blobs_inc();

	rc = build_attribute(CKA_IBM_OPAQUE, (CK_BYTE *) &publ_op,
			     sizeof(ep11_opaque), &attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto error;
	}
	rc = template_update_attribute(publ_tmpl, attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
		goto error;
	}

	rc = build_attribute(CKA_IBM_OPAQUE, (CK_BYTE *) &priv_op,
			     sizeof(ep11_opaque), &attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto error;
	}
	rc = template_update_attribute(priv_tmpl, attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
		goto error;
	}

	if (pMechanism->mechanism == CKM_EC_KEY_PAIR_GEN) {
		/* scan the SPKI for CKA_EC_POINT */

		EP11TOK_DUMP(2, "ec_generate_keypair spki", spki, spki_len);
		rc = ep11_spki_key(spki, &key, &bit_str_len);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"read key from SPKI failed with rc=0x%lx",rc);
			goto error;
		}

		/* 'key' is already EC point,
		 * SEC 1: Elliptic Curve Cryptography:
		 * The elliptic curve public key (a value of type ECPoint
		 * that is an OCTET STRING) is mapped to a subjectPublicKey
		 * (a value encoded as type BIT STRING) as follows: The most
		 * significant bit of the value of the OCTET STRING becomes
		 * the most significant bit of the value of the BIT STRING
		 * and so on with consecutive bits until the least significant
		 * bit of the OCTET STRING becomes the least significant bit
		 * of the BIT STRING.
		 */
		EP11TOK_LOG(1,"ecpoint length 0x%lx",bit_str_len);
		data_len = bit_str_len;
		data = key;

		EP11TOK_DUMP(2, "ec_generate_keypair ecpoint", data, data_len);

		/* build and add CKA_EC_POINT */
		rc = build_attribute(CKA_EC_POINT, data, data_len, &attr);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
			goto error;
		}
		rc = template_update_attribute(publ_tmpl, attr);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
			goto error;
		}

		/* copy CKA_EC_PARAMS/CKA_ECDSA_PARAMS to private template  */
		if (template_attribute_find(publ_tmpl, CKA_EC_PARAMS, &attr)) {
			rc = build_attribute(attr->type, attr->pValue,
					     attr->ulValueLen, &n_attr);
			if (rc != CKR_OK) {
				EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
				goto error;
			}

			rc = template_update_attribute(priv_tmpl, n_attr);
			if (rc != CKR_OK) {
				EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
				goto error;
			}
		}

		if (template_attribute_find(publ_tmpl, CKA_ECDSA_PARAMS, &attr)) {
			rc = build_attribute(attr->type, attr->pValue,
					     attr->ulValueLen, &n_attr);
			if (rc != CKR_OK) {
				EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
				goto error;
			}

			rc = template_update_attribute(priv_tmpl, n_attr);
			if (rc != CKR_OK) {
				EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
				goto error;
			}
		}
	} else {
		/* scan the SPKI for modulus and public exponent and
		 * set the public key attributes, a user would use the
		 * already built SPKI (in CKA_IBM_OPAQUE of the public key).
		 */
		CK_BYTE *modulus,*publ_exp;

		rc = ep11_spki_key(spki, &key, &bit_str_len);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"read key from SPKI failed with rc=0x%lx",rc);
			goto error;
		}

		/* key must be a sequence holding two integers,
		 * modulus and public exponent
		 */
		rc = ber_decode_SEQUENCE(key, &data, &data_len, &field_len);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"read sequence failed with rc=0x%lx",rc);
			goto error;
		}

		modulus = key + field_len - data_len;
		rc = ber_decode_INTEGER(modulus, &data, &data_len, &field_len);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"read modulus failed with rc=0x%lx",rc);
			goto error;
		}

		EP11TOK_DUMP(2, "rsa_generate_keypair modulus", data, data_len);

		/* build and add CKA_MODULUS */
		rc = build_attribute(CKA_MODULUS, data, data_len, &attr);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
			goto error;
		}
		rc = template_update_attribute(publ_tmpl, attr);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
			goto error;
		}

		/* read public exponent */
		publ_exp = modulus + field_len;
		rc = ber_decode_INTEGER(publ_exp, &data, &data_len, &field_len);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"read public exponent failed with rc=0x%lx",rc);
			goto error;
		}

		EP11TOK_DUMP(2, "rsa_generate_keypair public exponent", data, data_len);

		/* build and add CKA_PUBLIC_EXPONENT */
		rc = build_attribute(CKA_PUBLIC_EXPONENT, data, data_len, &attr);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
			goto error;
		}
		rc = template_update_attribute(publ_tmpl, attr);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
			goto error;
		}
	}

error:
	if (new_pPrivateKeyTemplate)
		free_attribute_array(new_pPrivateKeyTemplate,
				     new_ulPrivateKeyAttributeCount);
	if (new_pPublicKeyTemplate)
		free_attribute_array(new_pPublicKeyTemplate,
				     new_ulPublicKeyAttributeCount);
	return rc;
}


/* generic function to generate RSA,DH,EC and DSA key pairs */
CK_RV token_specific_generate_key_pair(SESSION * sess,
                                       CK_MECHANISM_PTR pMechanism,
                                       CK_ATTRIBUTE_PTR pPublicKeyTemplate,
                                       CK_ULONG ulPublicKeyAttributeCount,
                                       CK_ATTRIBUTE_PTR pPrivateKeyTemplate,
                                       CK_ULONG ulPrivateKeyAttributeCount,
                                       CK_OBJECT_HANDLE_PTR phPublicKey,
                                       CK_OBJECT_HANDLE_PTR phPrivateKey)
{
	CK_RV rc;
	OBJECT *public_key_obj = NULL;
	OBJECT *private_key_obj = NULL;
	CK_ULONG priv_ktype, publ_ktype;
	CK_ULONG class;
	CK_ATTRIBUTE *attr = NULL;
	CK_ATTRIBUTE *n_attr = NULL;
    
	/* Get the keytype to use when creating the key object */
	rc = ep11_get_keytype(pPrivateKeyTemplate, ulPrivateKeyAttributeCount,
				pMechanism, &priv_ktype, &class);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"get_keytype failed with rc=0x%lx",rc);
		goto error;
	}

	rc = ep11_get_keytype(pPublicKeyTemplate, ulPublicKeyAttributeCount,
				pMechanism, &publ_ktype, &class);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"get_keytype failed with rc=0x%lx",rc);
		goto error;
	}
    
	/* Now build the skeleton key. */
	rc = object_mgr_create_skel(sess, pPublicKeyTemplate,
				    ulPublicKeyAttributeCount, MODE_KEYGEN,
				    CKO_PUBLIC_KEY, publ_ktype,
				    &public_key_obj);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_OBJMGR_CREATE_SKEL);
		goto error;
	}
    
	rc = object_mgr_create_skel(sess, pPrivateKeyTemplate,
				    ulPrivateKeyAttributeCount, MODE_KEYGEN,
				    CKO_PRIVATE_KEY, priv_ktype,
				    &private_key_obj);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_OBJMGR_CREATE_SKEL);
		goto error;
	}
    
	switch(pMechanism->mechanism) {
	case CKM_DH_PKCS_KEY_PAIR_GEN:
		rc = dh_generate_keypair(pMechanism, public_key_obj->template,
					 private_key_obj->template,
					 pPublicKeyTemplate,
					 ulPublicKeyAttributeCount,
					 pPrivateKeyTemplate,
					 ulPrivateKeyAttributeCount,
					 sess->handle);
		break;

	case CKM_EC_KEY_PAIR_GEN:      /* takes same parameters as RSA */
	case CKM_RSA_PKCS_KEY_PAIR_GEN:
	case CKM_RSA_X9_31_KEY_PAIR_GEN:
		rc = rsa_ec_generate_keypair(pMechanism,
					     public_key_obj->template,
					     private_key_obj->template,
					     pPublicKeyTemplate,
					     ulPublicKeyAttributeCount,
					     pPrivateKeyTemplate,
					     ulPrivateKeyAttributeCount,
					     sess->handle);
		break;

	case CKM_DSA_PARAMETER_GEN:
	case CKM_DSA_KEY_PAIR_GEN:
		rc = dsa_generate_keypair(pMechanism, public_key_obj->template,
					  private_key_obj->template,
					  pPublicKeyTemplate,
					  ulPublicKeyAttributeCount,
					  pPrivateKeyTemplate,
					  ulPrivateKeyAttributeCount,
					  sess->handle);
		break;
	default:
		EP11TOK_ELOG(1,"invalid mech %s",
			     ep11_get_ckm(pMechanism->mechanism));
		rc = CKR_MECHANISM_INVALID;
		goto error;
	}

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx hpubkey=0x%lx hprivkey=0x%lx"
			" pub_name='%s' priv_name='%s' pub_obj=%p priv_obj=%p",
			rc, *phPublicKey, *phPrivateKey, public_key_obj->name,
			private_key_obj->name, public_key_obj, private_key_obj);
		goto error;
	} else {
		EP11TOK_LOG(2,"rc=0x%lx hpubkey=0x%lx hprivkey=0x%lx"
			" pub_name='%s' priv_name='%s' pub_obj=%p priv_obj=%p",
			rc, *phPublicKey, *phPrivateKey, public_key_obj->name,
			private_key_obj->name, public_key_obj, private_key_obj);
	}

	/* copy CKA_CLASS, CKA_KEY_TYPE to private template */
	if (template_attribute_find(public_key_obj->template, CKA_CLASS, &attr)) {
		rc = build_attribute(attr->type, attr->pValue,
					attr->ulValueLen, &n_attr);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
			goto error;
		}

		rc = template_update_attribute(private_key_obj->template, n_attr);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
			goto error;
		}
	}

	if (template_attribute_find(public_key_obj->template, CKA_KEY_TYPE, &attr)) {
		rc = build_attribute(attr->type, attr->pValue,
					attr->ulValueLen, &n_attr);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
			goto error;
		}

		rc = template_update_attribute(private_key_obj->template, n_attr);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
			goto error;
		}
	}

	/* Keys should be fully constructed,
	 * assign object handles and store keys.
	 */
	rc = object_mgr_create_final(sess, public_key_obj, phPublicKey);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_OBJMGR_CREATE_FINAL);
		goto error;
	}

	rc = object_mgr_create_final(sess, private_key_obj, phPrivateKey);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_OBJMGR_CREATE_FINAL);
		object_mgr_destroy_object(sess, *phPublicKey);
		public_key_obj = NULL;
		goto error;
	}
	return rc;

error:
	if (public_key_obj) object_free(public_key_obj);
	if (private_key_obj) object_free(private_key_obj);

	*phPublicKey = 0;
	*phPrivateKey = 0;

	return rc;
}


/* Returns a blob for a key (handle or key obj).
 * The blob is created if none was build yet.
 */
static CK_RV h_opaque_2_blob(CK_OBJECT_HANDLE handle,
                             CK_BYTE **blob, size_t *blob_len, OBJECT **kobj)
{
	OBJECT *key_obj;
	CK_ATTRIBUTE *attr = NULL;
	ep11_opaque *op;
	CK_RV rc;

	/* find the key obj by the key handle */
	rc = object_mgr_find_in_map1(handle,&key_obj);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"key 0x%lx not mapped", handle);
		return rc;
	}
    
	/* blob already exists */
	if (template_attribute_find(key_obj->template, CKA_IBM_OPAQUE, &attr) &&
				    (attr->ulValueLen > 0)) {
		op = attr->pValue;
		*blob = op->blob;
		*blob_len = op->blob_size;
		*kobj = key_obj;
		EP11TOK_LOG(2,"blob found blob_len=0x%x valuelen=0x%lx blob_id=0x%x", *blob_len, attr->ulValueLen, op->blob_id);
      
		return CKR_OK;
	} else {
    
		/* should not happen, imported key types not supported
		 * should cause a failing token_specific_object_add
		 */
		EP11TOK_ELOG(1,"no blob");
		return CKR_FUNCTION_FAILED;
	}
}

CK_RV token_specific_sign_init(SESSION *session, CK_MECHANISM *mech,
			       CK_BBOOL recover_mode, CK_OBJECT_HANDLE key)
{
	CK_BYTE *privkey_blob;
	size_t blob_len = 0;
	CK_RV rc;
	SIGN_VERIFY_CONTEXT *ctx = &session->sign_ctx;
	CK_BYTE *ep11_sign_state;
	size_t ep11_sign_state_l;
 	OBJECT *key_obj = NULL;

	ep11_sign_state_l = blobsize;
	ep11_sign_state = malloc(blobsize);
	if (!ep11_sign_state) {
		EP11TOK_ELOG(1,"Memory allocation failed.");
		return CKR_HOST_MEMORY;
	}

	rc = h_opaque_2_blob(key, &privkey_blob, &blob_len, &key_obj);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"no blob rc=0x%lx",rc);
		return rc;
	}

	rc = m_SignInit(ep11_sign_state, &ep11_sign_state_l,
			mech, privkey_blob, blob_len, ep11tok_target) ;

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx blob_len=0x%x key=0x%lx mech=0x%lx", rc, blob_len, key, mech->mechanism);
		free(ep11_sign_state);
	} else {
		/* SIGN_VERIFY_CONTEX holds all needed for continuing,
		 * also by another adapter (stateless requests)
		 */
		ctx->key = key;
		ctx->multi = FALSE;
		ctx->active = TRUE;
		ctx->context = ep11_sign_state;
		ctx->context_len = ep11_sign_state_l;
		
		EP11TOK_LOG(2,"rc=0x%lx blob_len=0x%x key=0x%lx mech=0x%lx",
			    rc, blob_len, key, mech->mechanism);
	}

	return rc;
}


CK_RV token_specific_sign(SESSION *session, CK_BBOOL length_only,
			  CK_BYTE *in_data, CK_ULONG in_data_len,
			  CK_BYTE *signature, CK_ULONG *sig_len)
{
	CK_RV rc;
	SIGN_VERIFY_CONTEXT *ctx = &session->sign_ctx;

	rc = m_Sign(ctx->context, ctx->context_len, in_data, in_data_len,
		    signature, sig_len, ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_sign_update(SESSION *session, CK_BYTE *in_data,
				 CK_ULONG in_data_len)
{
	CK_RV rc;
	SIGN_VERIFY_CONTEXT *ctx = &session->sign_ctx;

	rc = m_SignUpdate(ctx->context, ctx->context_len, in_data,
			  in_data_len, ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_sign_final(SESSION *session, CK_BBOOL length_only,
				CK_BYTE *signature, CK_ULONG *sig_len)
{
	CK_RV rc;
	SIGN_VERIFY_CONTEXT *ctx = &session->sign_ctx;

	rc = m_SignFinal(ctx->context, ctx->context_len, signature, sig_len,
			ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_verify_init(SESSION *session, CK_MECHANISM *mech,
				 CK_BBOOL recover_mode, CK_OBJECT_HANDLE key)
{
	CK_BYTE *spki;
	size_t spki_len = 0;
	CK_RV rc;
	SIGN_VERIFY_CONTEXT *ctx = &session->verify_ctx;
	CK_BYTE *ep11_sign_state;
	size_t ep11_sign_state_l;
	OBJECT *key_obj = NULL;

	ep11_sign_state_l = blobsize;
	ep11_sign_state = malloc(blobsize);
	if (!ep11_sign_state) {
		EP11TOK_ELOG(1,"Memory allocation failed.");
		return CKR_HOST_MEMORY;
	}

	rc = h_opaque_2_blob(key, &spki, &spki_len, &key_obj);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"no blob rc=0x%lx",rc);
		return rc;
	}

	rc = m_VerifyInit(ep11_sign_state, &ep11_sign_state_l, mech,
			  spki, spki_len, ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx spki_len=0x%x key=0x%lx ep11_sing_state_l=0x%x mech=0x%lx", rc, spki_len, key, ep11_sign_state_l, mech->mechanism);
	} else {
		ctx->key = key;
		ctx->multi = FALSE;
		ctx->active = TRUE;
		ctx->context = ep11_sign_state;
		ctx->context_len = ep11_sign_state_l;

		EP11TOK_LOG(2,"rc=0x%lx spki_len=0x%x key=0x%lx ep11_sing_state_l=0x%x mech=0x%lx", rc, spki_len, key, ep11_sign_state_l, mech->mechanism);
	}

	return rc;
}


CK_RV token_specific_verify(SESSION *session, CK_BYTE *in_data,
			    CK_ULONG in_data_len, CK_BYTE *signature,
			    CK_ULONG sig_len)
{
	CK_RV rc;
	SIGN_VERIFY_CONTEXT *ctx = &session->verify_ctx;

	rc = m_Verify(ctx->context, ctx->context_len, in_data, in_data_len,
			signature, sig_len, ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_verify_update(SESSION *session, CK_BYTE *in_data,
				   CK_ULONG in_data_len)
{
	CK_RV rc;
	SIGN_VERIFY_CONTEXT *ctx = &session->verify_ctx;

	rc = m_VerifyUpdate(ctx->context, ctx->context_len, in_data,
				in_data_len, ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_verify_final(SESSION *session, CK_BYTE *signature,
				  CK_ULONG sig_len)
{
	CK_RV rc;
	SIGN_VERIFY_CONTEXT *ctx = &session->verify_ctx;

	rc = m_VerifyFinal(ctx->context, ctx->context_len, signature,
			    sig_len, ep11tok_target);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_decrypt_final(SESSION *session, CK_BYTE_PTR output_part,
				   CK_ULONG_PTR p_output_part_len)
{
	CK_RV rc = CKR_OK;
	ENCR_DECR_CONTEXT *decr_ctx = &session->decr_ctx;

	rc = m_DecryptFinal(decr_ctx->context,decr_ctx->context_len,
			    output_part, p_output_part_len, ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_decrypt(SESSION *session, CK_BYTE_PTR input_data,
			     CK_ULONG input_data_len, CK_BYTE_PTR output_data,
			     CK_ULONG_PTR p_output_data_len)
{
	CK_RV rc = CKR_OK;
	ENCR_DECR_CONTEXT *decr_ctx = &session->decr_ctx;

	rc = m_Decrypt(decr_ctx->context,decr_ctx->context_len, input_data,
			input_data_len, output_data, p_output_data_len,
			ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_decrypt_update(SESSION *session, CK_BYTE_PTR input_part,
				    CK_ULONG input_part_len,
				    CK_BYTE_PTR output_part,
				    CK_ULONG_PTR p_output_part_len)
{
	CK_RV rc = CKR_OK;
	ENCR_DECR_CONTEXT *decr_ctx = &session->decr_ctx;

	rc = m_DecryptUpdate(decr_ctx->context,decr_ctx->context_len,
			     input_part, input_part_len, output_part,
			     p_output_part_len, ep11tok_target) ;

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_encrypt_final(SESSION *session, CK_BYTE_PTR output_part,
				   CK_ULONG_PTR p_output_part_len)
{
	CK_RV rc = CKR_OK;
	ENCR_DECR_CONTEXT *encr_ctx = &session->encr_ctx;

	rc = m_EncryptFinal(encr_ctx->context, encr_ctx->context_len,
			    output_part, p_output_part_len, ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_encrypt(SESSION *session, CK_BYTE_PTR input_data,
			     CK_ULONG input_data_len, CK_BYTE_PTR output_data,
			     CK_ULONG_PTR p_output_data_len)
{
	CK_RV rc = CKR_OK;
	ENCR_DECR_CONTEXT *encr_ctx = &session->encr_ctx;

	rc = m_Encrypt(encr_ctx->context, encr_ctx->context_len, input_data,
		       input_data_len, output_data, p_output_data_len,
		       ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_encrypt_update(SESSION *session, CK_BYTE_PTR input_part,
				    CK_ULONG input_part_len,
				    CK_BYTE_PTR output_part,
				    CK_ULONG_PTR p_output_part_len)
{
	CK_RV rc = CKR_OK;
	ENCR_DECR_CONTEXT *encr_ctx = &session->encr_ctx;

	rc = m_EncryptUpdate(encr_ctx->context, encr_ctx->context_len,
			     input_part, input_part_len, output_part,
			     p_output_part_len, ep11tok_target);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


static CK_RV ep11_ende_crypt_init(SESSION *session, CK_MECHANISM_PTR mech,
                                  CK_OBJECT_HANDLE key, int op)
{
	CK_RV rc = CKR_OK;
	ENCR_DECR_CONTEXT *decr_ctx = &session->decr_ctx;
	ENCR_DECR_CONTEXT *encr_ctx = &session->encr_ctx;
	CK_BYTE *ep11_state;
	size_t ep11_state_l;
	CK_BYTE *blob;
	size_t blob_len = 0;
	OBJECT *key_obj = NULL;

	ep11_state_l = blobsize;
	ep11_state = malloc(blobsize); /* freed by encr/decr_mgr.c */
	if (!ep11_state) {
		EP11TOK_ELOG(1,"Memory allocation failed.");
		return CKR_HOST_MEMORY;
	}

	rc = h_opaque_2_blob(key, &blob, &blob_len, &key_obj);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"no blob rc=0x%lx",rc);
		return rc;
	}

	if (op == DECRYPT) {
		rc = m_DecryptInit(ep11_state, &ep11_state_l, mech, blob,
				   blob_len, ep11tok_target);
		decr_ctx->key = key;
		decr_ctx->active = TRUE;
		decr_ctx->context = ep11_state;
		decr_ctx->context_len = ep11_state_l;
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"m_DecryptInit rc=0x%lx blob_len=0x%x mech=0x%lx",rc,blob_len,mech->mechanism);
		} else {
			EP11TOK_LOG(2,"m_DecryptInit rc=0x%lx blob_len=0x%x mech=0x%lx",rc,blob_len,mech->mechanism);
		}

		return rc;
	} else {
		rc = m_EncryptInit (ep11_state, &ep11_state_l, mech, blob,
				    blob_len, ep11tok_target);
		encr_ctx->key = key;
		encr_ctx->active = TRUE;
		encr_ctx->context = ep11_state;
		encr_ctx->context_len = ep11_state_l;
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"m_EncryptInit rc=0x%lx blob_len=0x%x mech=0x%lx",rc,blob_len,mech->mechanism);
		} else {
			EP11TOK_LOG(2,"m_EncryptInit rc=0x%lx blob_len=0x%x mech=0x%lx",rc,blob_len,mech->mechanism);
		}

		return rc;
	}
}


CK_RV token_specific_encrypt_init(SESSION *session, CK_MECHANISM_PTR mech,
				  CK_OBJECT_HANDLE key)
{
	CK_RV rc;

	EP11TOK_LOG(2,"key=0x%lx",key);

	rc = ep11_ende_crypt_init(session, mech, key, ENCRYPT);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_decrypt_init(SESSION *session, CK_MECHANISM_PTR mech,
				  CK_OBJECT_HANDLE key)
{
	CK_RV rc;

	EP11TOK_LOG(2,"key=0x%lx mech=0x%lx", key, mech->mechanism);

	rc = ep11_ende_crypt_init(session, mech, key, DECRYPT);

	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"rc=0x%lx",rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx",rc);
	}

	return rc;
}


CK_RV token_specific_wrap_key(SESSION *session, CK_MECHANISM_PTR mech,
			      CK_OBJECT_HANDLE wrapping_key,
			      CK_OBJECT_HANDLE key, CK_BYTE_PTR wrapped_key,
			      CK_ULONG_PTR p_wrapped_key_len)
{
	CK_RV rc;
	CK_BYTE *wrapping_blob;
	size_t wrapping_blob_len;
  
	CK_BYTE *wrap_target_blob;
	size_t wrap_target_blob_len;
	int size_querry = 0;
 	OBJECT *key_obj = NULL;
	CK_ATTRIBUTE *attr;
 
	/* ep11 weakness:
	 * it does not set *p_wrapped_key_len if wrapped_key == NULL
	 * (that is with a size query)
	 */
	if (wrapped_key == NULL) {
		size_querry = 1;
		*p_wrapped_key_len = blobsize;
		wrapped_key = malloc(blobsize);
		if (!wrapped_key) {
			EP11TOK_ELOG(1,"Memory allocation failed.");
			return CKR_HOST_MEMORY;
		}
	}
  
	/* the key that encrypts */
	rc = h_opaque_2_blob(wrapping_key, &wrapping_blob, &wrapping_blob_len, &key_obj);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"h_opaque_2_blob(wrapping_key) failed with rc=0x%lx", rc);
		if (size_querry) free(wrapped_key);
		return rc;
	}

	/* the key to be wrapped */
	rc = h_opaque_2_blob(key, &wrap_target_blob, &wrap_target_blob_len, &key_obj);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"h_opaque_2_blob(key) failed with rc=0x%lx", rc);
		if (size_querry) free(wrapped_key);
		return rc;
	}

	/* check if wrap mechanism is allowed for the key to be wrapped.
	 * AES_ECB and AES_CBC is only allowed to wrap secret keys.
	 */
	if (!template_attribute_find(key_obj->template, CKA_CLASS, &attr)) {
		EP11TOK_ELOG(1,"No CKA_CLASS attribute found in key template.");
		return CKR_TEMPLATE_INCOMPLETE;
	}

	if ((*(CK_OBJECT_CLASS *)attr->pValue != CKO_SECRET_KEY) &&
	    	((mech->mechanism == CKM_AES_ECB) ||
		 (mech->mechanism == CKM_AES_CBC))) {
		EP11TOK_ELOG(1,"Wrap mechanism does not match to target key type.");
                return CKR_KEY_NOT_WRAPPABLE;
	}

        /* debug */
        EP11TOK_LOG(2,"start wrapKey: mech=0x%lx wr_key=0x%lx",
			mech->mechanism, wrapping_key);

	/* the key to be wrapped is extracted from its blob by the card
	 * and a standard BER encoding is build which is encryted by
	 * the wrapping key (wrapping_blob).
	 * The wrapped key can be processed by any PKCS11 implementation.
	 */
	rc = m_WrapKey(wrap_target_blob,wrap_target_blob_len, wrapping_blob,
		       wrapping_blob_len, NULL, ~0, mech, wrapped_key,
		       p_wrapped_key_len, ep11tok_target);
  
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"m_WrapKey failed with rc=0x%lx", rc);
	} else {
		EP11TOK_LOG(2,"rc=0x%lx wr_key=%p wr_key_len=0x%lx",
			    rc, wrapped_key, *p_wrapped_key_len);
	}

	if (size_querry) free(wrapped_key);
	return rc;
}


CK_RV token_specific_unwrap_key(SESSION *session, CK_MECHANISM_PTR mech,
				CK_ATTRIBUTE_PTR attrs, CK_ULONG attrs_len,
				CK_BYTE_PTR wrapped_key,
				CK_ULONG wrapped_key_len,
                                CK_OBJECT_HANDLE wrapping_key,
                                CK_OBJECT_HANDLE_PTR p_key)
{
	CK_RV rc;
	CK_BYTE *wrapping_blob;
	size_t wrapping_blob_len;
	char csum[blobsize];
	CK_ULONG cslen = blobsize;
	OBJECT *key_obj = NULL;
	ep11_opaque op;
	CK_ATTRIBUTE *attr = NULL;
	int i = 0;
	DL_NODE  *node = NULL;
	CK_ULONG ktype;
	CK_ULONG class;
	CK_ULONG len;
	CK_ATTRIBUTE_PTR new_attrs = NULL;
	CK_ULONG new_attrs_len = 0;
	OBJECT *kobj = NULL;

	/* get wrapping key blob */
	rc = h_opaque_2_blob(wrapping_key, &wrapping_blob, &wrapping_blob_len, &kobj);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"h_opaque_2_blob(wrapping_key) failed with rc=0x%lx", rc);
		return rc;
	}
  
	/* debug */
	EP11TOK_LOG(2,"start unwrapKey:  mech=0x%lx attrs_len=0x%lx wr_key=0x%lx",
		    mech->mechanism, attrs_len, wrapping_key);
	for (i = 0; i < attrs_len; i++)
		EP11TOK_LOG(2,"attribute attrs.type=0x%lx", attrs[i].type);
  
	memset(&op, 0, sizeof(op));
	op.blob_size = blobsize;

	/*get key type of unwrapped key*/
	CK_ATTRIBUTE_PTR cla_attr = get_attribute_by_type(attrs, attrs_len, CKA_CLASS);
	CK_ATTRIBUTE_PTR keytype_attr = get_attribute_by_type(attrs, attrs_len, CKA_KEY_TYPE);
	if (!cla_attr || !keytype_attr) {
		EP11TOK_ELOG(1,"CKA_CLASS or CKA_KEY_CLASS attributes not found.");
		return CKR_FUNCTION_FAILED;
	}
	switch (*(CK_KEY_TYPE *)cla_attr->pValue) {
	case CKO_SECRET_KEY:
		rc = check_key_attributes(*(CK_KEY_TYPE *)keytype_attr->pValue,
					  CKO_SECRET_KEY, attrs,
					  attrs_len, &new_attrs,
					  &new_attrs_len);
		break;
	case CKO_PUBLIC_KEY:
		rc = check_key_attributes(*(CK_KEY_TYPE *)keytype_attr->pValue,
					  CKO_PUBLIC_KEY, attrs, attrs_len,
					  &new_attrs, &new_attrs_len);
		break;
	case CKO_PRIVATE_KEY:
		rc = check_key_attributes(*(CK_KEY_TYPE *)keytype_attr->pValue,
					  CKO_PRIVATE_KEY, attrs, attrs_len,
					  &new_attrs, &new_attrs_len);
		break;
	default:
		EP11TOK_ELOG(1,"Missing CKA_CLASS type of wrapped key.");
		return CKR_TEMPLATE_INCOMPLETE;
	}
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"check key attributes failed: rc=0x%lx",	rc);
		goto error;
	}

	/* check if unwrap mechanism is allowed for the key to be unwrapped.
	 * AES_ECB and AES_CBC only allowed to unwrap secret keys.
	 */
	if ( (*(CK_OBJECT_CLASS *)cla_attr->pValue != CKO_SECRET_KEY) &&  
		((mech->mechanism == CKM_AES_ECB) || 
		 (mech->mechanism == CKM_AES_CBC)))
		return CKR_ARGUMENTS_BAD;

	/* we need a blob for the new key created by unwrapping,
	 * the wrapped key comes in BER
	 */
	rc = m_UnwrapKey(wrapped_key, wrapped_key_len, wrapping_blob,
			 wrapping_blob_len, NULL, ~0, ep11_pin_blob,
			 ep11_pin_blob_len, mech, new_attrs, new_attrs_len,
			 op.blob, &(op.blob_size), csum, &cslen,
			 ep11tok_target);
  
	op.blob_id = ep11_blobs_inc();
  
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"m_UnwrapKey rc=0x%lx blob_size=0x%x mech=0x%lx ep11_blobs-1=%llx", rc, op.blob_size, mech->mechanism, ep11_blobs-1);
		goto error;
	}
	EP11TOK_LOG(2,"m_UnwrapKey rc=0x%lx blob_size=0x%x mech=0x%lx ep11_blobs-1=%llx", rc, op.blob_size, mech->mechanism, ep11_blobs-1);

	/* card provides length in csum bytes 4 - 7, big endian */
	len = csum[6] + 256*csum[5] + 256*256*csum[4] + 256*256*256*csum[3];
	len = len/8;  /* comes in bits */
	EP11TOK_LOG(2,"m_UnwrapKey length 0x%lx 0x%lx 0x%lx 0x%lx 0x%lx",
		    csum[3],csum[4],csum[5],csum[6],len);
  
	/* Get the keytype to use when creating the key object */
	rc = ep11_get_keytype(new_attrs, new_attrs_len, mech, &ktype, &class);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"get_subclass failed with rc=0x%lx",rc);
		goto error;
	}

	/* Start creating the key object */
	rc = object_mgr_create_skel(session, new_attrs, new_attrs_len,
				    MODE_UNWRAP, class, ktype, &key_obj);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"object_mgr_create_skel failed with rc=0x%lx",rc);
		goto error;
	}
  
	rc = build_attribute(CKA_IBM_OPAQUE, (CK_BYTE *) &op, sizeof(ep11_opaque), &attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto error;
	}
  
	rc = template_update_attribute(key_obj->template, attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
		goto error;
	}
  
	rc = build_attribute(CKA_VALUE_LEN, (CK_BYTE *) &len, sizeof(CK_ULONG), &attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"build_attribute failed with rc=0x%lx",rc);
		goto error;
	}

	rc = template_update_attribute(key_obj->template, attr);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"template_update_attribute failed with rc=0x%lx",rc);
		goto error;
	}

	/* key should be fully constructed.
	 * Assign an object handle and store key.
	 */
	rc = object_mgr_create_final(session, key_obj, p_key);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"object_mgr_create_final with rc=0x%lx",rc);
		goto error;
	}

	goto done;
  
error:
	if (key_obj) object_free(key_obj);
	*p_key = 0;
done:
	if (new_attrs)
		free_attribute_array(new_attrs, new_attrs_len);

	return rc;
}


/* use ep11 mech list */
MECH_LIST_ELEMENT mech_list[] = { };
CK_ULONG mech_list_len = (sizeof(mech_list) / sizeof(MECH_LIST_ELEMENT));

/* mechanisms ep11 reports but should be hidden because e.g.
   the EP11 card operates in a FIPS mode that forbides the mechanism,
   add here other mechanisms if required */
CK_MECHANISM_TYPE ep11_banned_mech_list[] =
{
#ifdef DEFENSIVE_MECHLIST
	CKM_DES_KEY_GEN,
	CKM_DES_ECB,
	CKM_DES_CBC,
	CKM_DES_CBC_PAD,
	CKM_GENERIC_SECRET_KEY_GEN,

	CKM_SHA224,
	CKM_SHA224_HMAC,
	CKM_SHA224_RSA_PKCS,
	CKM_SHA224_RSA_PKCS_PSS,
	CKM_SHA256_RSA_PKCS_PSS,
	CKM_SHA384_RSA_PKCS_PSS,
	CKM_SHA512_RSA_PKCS_PSS,
	CKM_SHA224_KEY_DERIVATION,
	CKM_SHA384_KEY_DERIVATION,
	CKM_SHA512_KEY_DERIVATION,
	/* Vendor specific */
	0x80020006,
	0x80020007,
	0x8001000C,
	0x80020004,
	0x8001000D,
	0x80040001,
	0x80010007,

#endif
};
CK_ULONG banned_mech_list_len = (sizeof(ep11_banned_mech_list) / sizeof(CK_MECHANISM_TYPE));


/* filtering out some mechanisms we do not want to provide
 * makes it complicated
 */
CK_RV token_specific_get_mechanism_list(CK_MECHANISM_TYPE_PTR pMechanismList,
                                        CK_ULONG_PTR pulCount)
{
	CK_RV rc = 0;
	CK_ULONG counter = 0;
	CK_MECHANISM_TYPE_PTR mlist = NULL;
	int i, j, banned;

	/* size querry */
	if (pMechanismList == NULL) {
		rc = m_GetMechanismList(0, pMechanismList, pulCount,
					ep11tok_target);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"bad rc=0x%lx from m_GetMechanismList()", rc);
			return rc;
		}

		/* adjust the size according to the ban list,
		 * for this we need to know what the card provides
		 */
		counter = *pulCount;
		mlist = (CK_MECHANISM_TYPE *)malloc(sizeof(CK_MECHANISM_TYPE) * counter);
		if (!mlist) {
			EP11TOK_ELOG(1,"Memory allocation failed.");
			return CKR_HOST_MEMORY;
		}
		rc = m_GetMechanismList(0, mlist, &counter, ep11tok_target);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"bad rc=0x%lx from m_GetMechanismList()", rc);
			free(mlist);
			return rc;
		}

		for (i = 0; i < counter; i++) {
			banned = 0;
			for (j = 0; j < banned_mech_list_len; j++) {
				if (mlist[i] == ep11_banned_mech_list[j]) {
					banned = 1;
					EP11TOK_LOG(2,"banned mech '%s'",
					ep11_get_ckm(ep11_banned_mech_list[j]));
				}
			}
			if (banned == 1) {
				/* banned mech found,
				 * decrement reported list size
				 */
				*pulCount = *pulCount - 1;
			}
		}
	} else {
		 /* 2. call, content request */

		/* find out size ep11 will report, cannot use the size
		 * that comes as parameter, this is a 'reduced size',
		 * ep11 would complain about insufficient list size
		 */
		rc = m_GetMechanismList(0,mlist,&counter,ep11tok_target);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"bad rc=0x%lx from m_GetMechanismList()", rc);
			return rc;
		}

		mlist = (CK_MECHANISM_TYPE *)malloc(sizeof(CK_MECHANISM_TYPE) * counter);
		if (!mlist) {
			EP11TOK_ELOG(1,"Memory allocation failed.");
			return CKR_HOST_MEMORY;
		}
		/* all the card has */
		rc = m_GetMechanismList(0, mlist, &counter, ep11tok_target);
		if (rc != CKR_OK) {
			EP11TOK_ELOG(1,"bad rc #4 rc=0x%lx", rc);
			free(mlist);
			return rc;
		}

		for (i = 0; i < counter; i++)
			EP11TOK_LOG(2,"raw mech list entry '%s'",ep11_get_ckm(mlist[i]));

			/* copy only mechanisms not banned */
			*pulCount = 0;
			for (i = 0; i < counter; i++) {
				banned = 0;
				for (j = 0; j < banned_mech_list_len; j++) {
					if (mlist[i] == ep11_banned_mech_list[j]) {
						banned = 1;
					}
				}
				if (banned == 0) {
					pMechanismList[*pulCount] = mlist[i];
					*pulCount = *pulCount + 1;
				} else {
					;
				} /* do not copy banned mech */
			}
	}

	if (mlist) free(mlist);
	return rc;
}


CK_RV token_specific_get_mechanism_info(CK_MECHANISM_TYPE type,
                                        CK_MECHANISM_INFO_PTR pInfo)
{
	CK_RV rc;
	int i;

	rc = m_GetMechanismInfo(0,type,pInfo,ep11tok_target);
	if (rc != CKR_OK) {
		EP11TOK_ELOG(1,"m_GetMechanismInfo(0x%lx) failed with rc=0x%lx", type, rc);
		return rc;
	}

	/* The card operates always in a FISP mode that requires stronger
	 * key sizes, but, in theory, can also operate with weaker key sizes.
	 * Customers are not interested in theory but in what mechanism
	 * they can use (mechanisms that are not rejected by the card).
         */
	for (i = 0; i < banned_mech_list_len; i++) {
		if (type == ep11_banned_mech_list[i])
			return CKR_MECHANISM_INVALID;
	}
#ifdef DEFENSIVE_MECHLIST
	if (rc == CKR_OK) {
		switch (type) {
		case CKM_RSA_PKCS:
		case CKM_RSA_PKCS_KEY_PAIR_GEN:
		case CKM_RSA_X9_31_KEY_PAIR_GEN:
		case CKM_RSA_PKCS_PSS:
		case CKM_SHA1_RSA_X9_31:
		case CKM_SHA1_RSA_PKCS:
		case CKM_SHA1_RSA_PKCS_PSS:
		case CKM_SHA256_RSA_PKCS:
		case CKM_SHA256_RSA_PKCS_PSS:
		case CKM_SHA224_RSA_PKCS:
		case CKM_SHA224_RSA_PKCS_PSS:
		case CKM_SHA384_RSA_PKCS:
		case CKM_SHA384_RSA_PKCS_PSS:
		case CKM_SHA512_RSA_PKCS:
		case CKM_SHA512_RSA_PKCS_PSS:
		case CKM_RSA_X_509:
		case CKM_RSA_X9_31:
			/* EP11 card always in a FIPS mode rejecting
			 * lower key sizes
			 */
			pInfo->ulMinKeySize = 1024;
			break;

		case CKM_SHA256_HMAC:
		case CKM_SHA224_HMAC:
		case CKM_SHA384_HMAC:
		case CKM_SHA512_HMAC:
		case CKM_DES3_ECB:
		case CKM_DES3_CBC:
		case CKM_DES3_CBC_PAD:
		case CKM_SHA_1_HMAC:
			/* EP11 card always in a FIPS mode rejecting
			 * lower key sizes < 80 bits.
			 */
			if (pInfo->ulMinKeySize == 8)
		                pInfo->ulMinKeySize = 16;
			break;

		default:
			; /* do not touch */
		}
	}
#endif /* DEFENSIVE_MECHLIST */

	if (rc != CKR_OK)
		EP11TOK_ELOG(1,"rc=0x%lx unsupported '%s'", rc, ep11_get_ckm(type));
	return rc;
}


/* used for reading in the adapter config file,
 * converts a 'token' to a number, returns 0 with success
 */
static inline short check_n(char *nptr, int j, int *apqn_i)
{
	char *endptr;
	long int num = strtol(nptr, &endptr, 10);

	if (*endptr != '\0') {
		EP11TOK_ELOG(1,"invalid number '%s' (%d)", nptr, j);
		return -1;
	}

	if (num < 0 || num > 255) {
		EP11TOK_ELOG(1,"invalid number '%s' %d(%d)", nptr, (int)num, j);
		return -1;
	} else if (*apqn_i < 0 || *apqn_i >= MAX_APQN*2) {
		EP11TOK_ELOG(1,"invalid amount of numbers %d(%d)", (int)num, j);
		return -1;
	} else {
		/* insert number into target variable */
		ep11_targets.apqns[*apqn_i] = (short)num;
		/* how many APQNs numbers so far */
		*apqn_i = *apqn_i + 1;
		return 0;
	}
}


static int read_adapter_config_file(const char* conf_name)
{
	FILE *ap_fp = NULL;       /* file pointer adapter config file */
	int ap_file_size = 0;     /* size adapter config file */
	char *token,*str;
	char filebuf[EP11_CFG_FILE_SIZE];
	char line[1024];
	int i,j;
	int blackmode = 0;
	int whitemode = 0;
	int anymode   = 0;
	int apqn_i = 0;     /* how many APQN numbers */
	char *conf_dir = getenv("OCK_EP11_TOKEN_DIR");
	char fname[PATH_MAX];
	int rc = 0;

	if (ep11_initialized) {
		return 0;
	}

	memset(fname,0,PATH_MAX);

	/* via envrionment variable it is possible to overwrite the
	 * directory where the ep11 token config file is searched.
	 */
	if (conf_dir) {
		if (conf_name && strlen(conf_name) > 0) {
			/* extract filename part from conf_name */
			for (i=strlen(conf_name)-1; i >= 0 && conf_name[i] != '/'; i--);

			snprintf(fname, sizeof(fname), "%s/%s", conf_dir, conf_name+i+1);
			fname[sizeof(fname)-1] = '\0';
			ap_fp = fopen(fname,"r");

			if (!ap_fp)
				EP11TOK_LOG(2, "fopen('%s') failed with errno %d",
					    fname, errno);
		}
		if (!ap_fp) {
			snprintf(fname, sizeof(fname), "%s/%s", conf_dir, EP11_DEFAULT_CFG_FILE);
			fname[sizeof(fname)-1] = '\0';
			ap_fp = fopen(fname,"r");
			if (!ap_fp)
				EP11TOK_LOG(2, "fopen('%s') failed with errno %d",
					    fname, errno);
		}
	} else {
		if (conf_name && strlen(conf_name) > 0) {
			strncpy(fname, conf_name, sizeof(fname));
			fname[sizeof(fname)-1] = '\0';
			ap_fp = fopen(fname,"r");
			if (!ap_fp) {
				EP11TOK_LOG(2,"fopen('%s') failed with errno %d", fname, errno);
				snprintf(fname, sizeof(fname), "%s/%s", OCK_CONFDIR, conf_name);
				fname[sizeof(fname)-1] = '\0';
				ap_fp = fopen(fname,"r");
				if (!ap_fp) EP11TOK_LOG(2,"fopen('%s') failed with errno %d", fname, errno);
			}
		} else {
			snprintf(fname, sizeof(fname), "%s/%s", OCK_CONFDIR, EP11_DEFAULT_CFG_FILE);
			fname[sizeof(fname)-1] = '\0';
			ap_fp = fopen(fname,"r");
			if (!ap_fp) EP11TOK_LOG(2,"fopen('%s') failed with errno %d", fname, errno);
		}
	}

	/* now we should really have an open ep11 token config file */
	if (!ap_fp) {
		EP11TOK_ELOG(1,"no valid EP 11 config file found");
		return APQN_FILE_INV_2;
	}

	EP11TOK_LOG(2,"EP 11 token config file is '%s'", fname);

	/* read config file line by line,
	 * ignore empty and # and copy rest into file buf
	 */
	memset(filebuf,0,EP11_CFG_FILE_SIZE);
	while (fgets((char *)line, sizeof(line), ap_fp)) {
		char *p;
		int len;
		/* skip over leading spaces */
		for (p=line; *p == ' ' || *p == '\t'; p++) ;
		/* if line is empty or starts with # skip line */
		len = strlen(p);
		if (*p != '#' && *p != '\n' && len > 0) {
			/* store line in buffer */
			if (ap_file_size + len < EP11_CFG_FILE_SIZE) {
				memcpy(filebuf+ap_file_size, p, len);
				ap_file_size += len;
			} else {
				EP11TOK_ELOG(1,"EP 11 config file filename too large");
				return  APQN_FILE_INV_FILE_SIZE;
			}
		}
	}

	ep11_targets.length = 0;

	for (i=0,j=0,str=filebuf; rc == 0; str=NULL) {
		/* strtok tokenizes the string,
		 * delimiters are newline and whitespace.
		 */
		token = strtok(str, "\n\t ");

		if (i == 0) {
			 /* expecting APQN_WHITELIST or APQN_BLACKLIST
			  * or APQN_ANY or LOGLEVEL or eof.
			  */
			if (token == NULL)
				break;
			if (strncmp(token,"APQN_WHITELIST",14) == 0) {
				whitemode = 1;
				i = 1;
			} else if (strncmp(token,"APQN_BLACKLIST",14) == 0) {
				blackmode = 1;
				i = 1;
			} else if (strncmp(token,"APQN_ANY",8) == 0) {
				anymode = 1;
				i = 0;
			} else if (strncmp(token,"LOGLEVEL",8) == 0)
				i = 3;
			else {
				/* syntax error */
				EP11TOK_ELOG(1,"Expected APQN_WHITELIST or"
				" APQN_BLACKLIST or APQN_ANY or LOGLEVEL"
				" keyword, found '%s' in configfile", token);
				rc = APQN_FILE_SYNTAX_ERROR_0;
				break;
			}
		} else if (i == 1) {
			/* expecting END or first number of a number
			 * pair (number range 0...255)
			 */
			if (strncmp(token,"END",3) == 0)
				i = 0;
			else {
				if (check_n(token, j, &apqn_i) < 0) {
					rc = APQN_FILE_SYNTAX_ERROR_1;
					break;
				}
				i = 2;
			}
		} else if (i == 2) {
			/* expecting second number of a number pair
			 * (number range 0...255)
			 */
			if (strncmp(token,"END",3) == 0) {
				EP11TOK_ELOG(1,"Expected 2nd number, found '%s' in configfile", token);
				rc = APQN_FILE_SYNTAX_ERROR_2;
				break;
			}
			if (check_n(token, j, &apqn_i) < 0) {
				rc = APQN_FILE_SYNTAX_ERROR_3;
				break;
			}
			ep11_targets.length++;
			if (ep11_targets.length > MAX_APQN) {
				EP11TOK_ELOG(1,"Too many APQNs in configfile (max %d)", (int) MAX_APQN);
				rc = APQN_FILE_SYNTAX_ERROR_4;
				break;
			}
			i = 1;
			j++;
		} else if (i == 3) {
			 /* expecting log level value
			  * (a number in the range 0...9)
			  */
			char *endptr;
			int loglevel  = strtol(token, &endptr, 10);
			if (*endptr != '\0' || loglevel < 0 || loglevel > 9) {
				EP11TOK_ELOG(1,"Invalid loglevel value '%s' in configfile", token);
				rc = APQN_FILE_SYNTAX_ERROR_5;
				break;
			}
			if (loglevel > 0 && EP11Tok_loglevel == 0) {
				if (!EP11Tok_logfile) {
					/* create the log file */
					char logfilename[PATH_MAX];
					sprintf(logfilename,
						EP11TOK_LOGFILEMASK,
						(unsigned) getpid());
					EP11Tok_logfile = fopen(logfilename, "w+");
				}
				EP11Tok_loglevel = loglevel;
			}
			i = 0;
		}
	}

	/* do some checks: */
	if (rc == 0) {
		if ( !(whitemode || blackmode || anymode)) {
			EP11TOK_ELOG(1,"At least one APQN mode needs to be present in configfile:"
				     " APQN_WHITEMODE or APQN_BLACKMODE or APQN_ANY");
			rc = APQN_FILE_NO_APQN_MODE;
		} else if (whitemode || blackmode) {
			/* at least one APQN needs to be defined */
			if (ep11_targets.length < 1) {
				EP11TOK_ELOG(1,"At least one APQN needs to be defined in the configfile");
				rc = APQN_FILE_NO_APQN_GIVEN;
			}
		}
	}

	/* log the white- or blacklist of APQNs */
	if (rc == 0 && (whitemode || blackmode)) {
		EP11TOK_LOG(2,"%s with %d APQNs defined:", blackmode ? "blacklist" : "whitelist", ep11_targets.length);
		for (i=0; i < ep11_targets.length; i++) {
			EP11TOK_LOG(2,"APQN %d: %d %d", i, ep11_targets.apqns[2*i], ep11_targets.apqns[2*i+1]);
		}
	}

	if (blackmode == 1)
		ep11_targets.length *= -1;

	ep11_initialized = TRUE;
	return rc;
}
