/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001          */
/* Modified for S390 by Robert Burroughs                             */


#include <pthread.h>
#include <string.h>            // for memcmp() et al
#include <strings.h>
#include <stdlib.h>

#ifndef NOAES
#include <openssl/aes.h>
#endif
#ifndef NODH
#include <openssl/dh.h>
#endif

#include "pkcs11types.h"
#include "p11util.h"
#include "defs.h"
#include "host_defs.h"
#include "h_extern.h"

#include "tok_specific.h"
#include "tok_struct.h"
#include "ica_specific.h"
#include "ica_api.h"
// declare the adapter open handle localy
ICA_ADAPTER_HANDLE adapter_handle;

// Linux really does not need these so we just dummy them up
// so the common code across platforms is usable...
#define KEYTYPE_MODEXPO   1
#define KEYTYPE_PKCSCRT   2

CK_CHAR manuf[] = "IBM Corp.";
CK_CHAR model[] = "IBM ICA     ";
CK_CHAR descr[] = "IBM PKCS#11 ICA token ";
CK_CHAR label[] = "IBM ICA  PKCS #11";



pthread_mutex_t  rngmtx = PTHREAD_MUTEX_INITIALIZER;
unsigned int  rnginitialized=0;



CK_RV
token_specific_rng(CK_BYTE *output, CK_ULONG bytes)
{
   unsigned int  rc;

      pthread_mutex_lock(&rngmtx);

      rc = ica_random_number_generate( (unsigned int) bytes, output);

      if (rc != 0) {
         pthread_mutex_unlock(&rngmtx);
         return CKR_GENERAL_ERROR;
         /* report error */
      }

      pthread_mutex_unlock(&rngmtx);
      return CKR_OK;

}

int
tok_slot2local(CK_SLOT_ID snum)
{
   return 1;
}

CK_RV
token_specific_init(CK_SLOT_ID  SlotNumber, char *conf_name)
{

   return ica_open_adapter(&adapter_handle);
}

CK_RV
token_specific_final()
{
   ica_close_adapter(adapter_handle);
   return CKR_OK;
}

// count_ones_in_byte: for use in adjust_des_key_parity_bits below
CK_BYTE 
count_ones_in_byte(CK_BYTE byte)
{  
   CK_BYTE and_mask,   // bit selector
           number_of_ones = 0;

   for (and_mask = 1; and_mask != 0; and_mask <<= 1) // for each bit,
      if (byte & and_mask) // if it's a one,                         
         ++number_of_ones; // count it

   return number_of_ones;
}

#define EVEN_PARITY TRUE
#define ODD_PARITY FALSE
 // adjust_des_key_parity_bits: to conform to NIST spec for DES and 3DES keys
void adjust_des_key_parity_bits(CK_BYTE *des_key, CK_ULONG key_size, CK_BBOOL parity)
{
   CK_BYTE *des_key_byte;

   for (des_key_byte = des_key; des_key_byte - des_key < key_size; ++des_key_byte)
         // look at each byte in the key
   {
      if ((count_ones_in_byte(*des_key_byte) % 2) ^ (parity == ODD_PARITY))
      {
         // if parity for this byte isn't what it should be,
         // flip the parity (least significant) bit
         *des_key_byte ^= 1;
      }
   }
}







CK_RV
token_specific_des_key_gen(CK_BYTE  *des_key, CK_ULONG len, CK_ULONG keysize)
{
      
   // Nothing different to do for DES or TDES here as this is just
   // random data...  Validation handles the rest
   // Only check for weak keys when DES.
        if (len == (3 * DES_KEY_SIZE)) {
                rng_generate(des_key,len);
        	adjust_des_key_parity_bits(des_key, len, ODD_PARITY);
	} else {
                do {
                        rng_generate(des_key, len);
        		adjust_des_key_parity_bits(des_key, len, ODD_PARITY);
                } while (des_check_weak_key(des_key) == TRUE);
        }

        
   // we really need to validate the key for parity etc...
   // we should do that here... The caller validates the single des keys
   // against the known and suspected poor keys..<<
        return CKR_OK;

}

CK_RV
token_specific_des_ecb(CK_BYTE * in_data,
                       CK_ULONG in_data_len,
                       CK_BYTE *out_data,
                       CK_ULONG *out_data_len,
                       OBJECT   *key,
                       CK_BYTE  encrypt)
{
   CK_RV rc;
   CK_ATTRIBUTE *attr = NULL;

   /*
    * checks for input and output data length and block sizes
    * are already being carried out in mech_des.c
    * so we skip those
    */

   if (template_attribute_find(key->template, CKA_VALUE, &attr) == FALSE) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      return CKR_FUNCTION_FAILED;
   }

   if ( encrypt) {
      rc = ica_des_encrypt(MODE_DES_ECB, (unsigned int) in_data_len, in_data,
                           NULL, (ica_des_key_single_t *)attr->pValue, out_data);
   } else {
      rc = ica_des_decrypt(MODE_DES_ECB, (unsigned int) in_data_len, in_data,
                           NULL, (ica_des_key_single_t *)attr->pValue, out_data);
   }

   if (rc != 0) {
      rc = CKR_FUNCTION_FAILED;
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
   }else {
      *out_data_len = in_data_len;
      rc = CKR_OK;
   }

   return rc;


}

CK_RV
token_specific_des_cbc(CK_BYTE * in_data,
                       CK_ULONG in_data_len,
                       CK_BYTE *out_data,
                       CK_ULONG *out_data_len,
                       OBJECT   *key, 
                       CK_BYTE *init_v,
                       CK_BYTE  encrypt)
{

   CK_RV rc;
   CK_ATTRIBUTE *attr = NULL;

   /*
    * checks for input and output data length and block sizes
    * are already being carried out in mech_des.c
    * so we skip those
    */

  // get the key value
  if (template_attribute_find(key->template, CKA_VALUE, &attr) == FALSE) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      return CKR_FUNCTION_FAILED;
   }

   if ( encrypt ){
      rc = ica_des_encrypt(MODE_DES_CBC, (unsigned int) in_data_len, in_data,
                           (ica_des_vector_t *) init_v,
			   (ica_des_key_single_t *) attr->pValue, out_data);
   } else {
      rc = ica_des_decrypt(MODE_DES_CBC, (unsigned int) in_data_len, in_data,
                           (ica_des_vector_t *) init_v,
			   (ica_des_key_single_t *) attr->pValue, out_data);
   }
   if (rc != 0) {
         OCK_LOG_ERR(ERR_FUNCTION_FAILED);
         rc = CKR_FUNCTION_FAILED;
   }else {
         *out_data_len = in_data_len;
         rc = CKR_OK;
   }

   return rc;
}

CK_RV
token_specific_tdes_ecb(CK_BYTE * in_data,
                       CK_ULONG in_data_len,
                       CK_BYTE *out_data,
                       CK_ULONG *out_data_len,
                       OBJECT  *key,
                       CK_BYTE  encrypt)
{
   CK_RV rc;
   CK_ATTRIBUTE *attr = NULL;
   CK_KEY_TYPE	keytype;
   CK_BYTE key_value[3*DES_KEY_SIZE];

   /*
    * checks for input and output data length and block sizes
    * are already being carried out in mech_des3.c
    * so we skip those
    */

   // get the key type
   rc = template_attribute_find(key->template, CKA_KEY_TYPE, &attr);
   if (rc == FALSE) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      return CKR_FUNCTION_FAILED;
   }
      keytype = *(CK_KEY_TYPE *)attr->pValue;

   // get the key value
   if (template_attribute_find(key->template, CKA_VALUE, &attr) == FALSE) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      return CKR_FUNCTION_FAILED;
   }
   if (keytype == CKK_DES2) {
      memcpy(key_value, attr->pValue, 2*DES_KEY_SIZE);
      memcpy(key_value + (2*DES_KEY_SIZE), attr->pValue, DES_KEY_SIZE);
   } else
      memcpy(key_value, attr->pValue, 3*DES_KEY_SIZE);

   if ( encrypt) {
      rc = ica_3des_encrypt(MODE_DES_ECB, (unsigned int) in_data_len, in_data,
                            NULL, (ica_des_key_triple_t *) key_value,
			    out_data);
   } else {
      rc = ica_3des_decrypt(MODE_DES_ECB, (unsigned int) in_data_len, in_data,
                            NULL, (ica_des_key_triple_t *) key_value,
			    out_data);
   }

   if (rc != 0) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      rc = CKR_FUNCTION_FAILED;
   }else {
      *out_data_len = in_data_len;
      rc = CKR_OK;
   }

   return rc;


}

CK_RV
token_specific_tdes_cbc(CK_BYTE * in_data,
                       CK_ULONG in_data_len,
                       CK_BYTE *out_data,
                       CK_ULONG *out_data_len,
                       OBJECT  *key, 
                       CK_BYTE *init_v,
                       CK_BYTE  encrypt)
{

   CK_RV rc;
   CK_ATTRIBUTE *attr = NULL;
   CK_KEY_TYPE	keytype;
   CK_BYTE key_value[3*DES_KEY_SIZE];

   /*
    * checks for input and output data length and block sizes
    * are already being carried out in mech_des3.c
    * so we skip those
    */

   // get the key type
   rc = template_attribute_find(key->template, CKA_KEY_TYPE, &attr);
   if (rc == FALSE) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      return CKR_FUNCTION_FAILED;
   }
      keytype = *(CK_KEY_TYPE *)attr->pValue;
   // get the key value
   if (template_attribute_find(key->template, CKA_VALUE, &attr) == FALSE) {
       OCK_LOG_ERR(ERR_FUNCTION_FAILED);
       return CKR_FUNCTION_FAILED;
   }
   if (keytype == CKK_DES2) {
      memcpy(key_value, attr->pValue, 2*DES_KEY_SIZE);
      memcpy(key_value + (2*DES_KEY_SIZE), attr->pValue, DES_KEY_SIZE);
   } else
      memcpy(key_value, attr->pValue, 3*DES_KEY_SIZE);

   if ( encrypt ){
   rc = ica_3des_encrypt(MODE_DES_CBC, (unsigned int) in_data_len, in_data,
                         (ica_des_vector_t  *) init_v, 
			 (ica_des_key_triple_t *) key_value, out_data);
   } else {
   rc = ica_3des_decrypt(MODE_DES_CBC, (unsigned int) in_data_len, in_data,
                         (ica_des_vector_t *) init_v,
			 (ica_des_key_triple_t *) key_value, out_data);
   }
   if (rc != 0) {
         OCK_LOG_ERR(ERR_FUNCTION_FAILED);
         rc = CKR_FUNCTION_FAILED;
   }else {
         *out_data_len = in_data_len;
         rc = CKR_OK;
   }

   return rc;
}

/*
 *
 * 0 Use the decrypt function.
 * 1 Use the encrypt function.
 */
CK_RV
token_specific_tdes_ofb(CK_BYTE *in_data, CK_BYTE *out_data, CK_ULONG data_len,
                        OBJECT *key, CK_BYTE *iv, uint_32 direction)
{
   CK_RV rc;
   CK_ATTRIBUTE *attr = NULL;

   if (template_attribute_find(key->template, CKA_VALUE, &attr) == FALSE) {
       OCK_LOG_ERR(ERR_FUNCTION_FAILED);
       return CKR_FUNCTION_FAILED;
    }

   rc = ica_3des_ofb(in_data, out_data, (unsigned int) data_len,
                   (const unsigned char *) attr->pValue, (unsigned char *) iv,
                   direction);

   if (rc != 0) {
         OCK_LOG_ERR(ERR_FUNCTION_FAILED);
         rc = CKR_FUNCTION_FAILED;
   }
   return rc;
}

/*
 * 0 Use the decrypt function.
 * 1 Use the encrypt function.
 */
CK_RV
token_specific_tdes_cfb(CK_BYTE *in_data, CK_BYTE *out_data, CK_ULONG data_len,
                        OBJECT *key, CK_BYTE *iv, uint_32 cfb_len,
                        uint_32 direction)
{
   CK_RV rc;
   CK_ATTRIBUTE *attr = NULL;

   if (template_attribute_find(key->template, CKA_VALUE, &attr) == FALSE) {
       OCK_LOG_ERR(ERR_FUNCTION_FAILED);
       return CKR_FUNCTION_FAILED;
    }

   rc = ica_3des_cfb(in_data, out_data, (unsigned int) data_len,
                   (const unsigned char *) attr->pValue, (unsigned char *) iv,
                    cfb_len, direction);

   if (rc != 0) {
         OCK_LOG_ERR(ERR_FUNCTION_FAILED);
         rc = CKR_FUNCTION_FAILED;
   }
   return rc;
}

CK_RV
token_specific_tdes_mac(CK_BYTE *message, CK_ULONG message_len, OBJECT *key,
                        CK_BYTE *mac)
{
   CK_RV rc;
   CK_ATTRIBUTE *attr = NULL;
   CK_KEY_TYPE  keytype;
   CK_BYTE key_value[3*DES_KEY_SIZE];

   // get the key type
   rc = template_attribute_find(key->template, CKA_KEY_TYPE, &attr);
   if (rc == FALSE) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      return CKR_FUNCTION_FAILED;
   }
      keytype = *(CK_KEY_TYPE *)attr->pValue;

   // get the key value
   if (template_attribute_find(key->template, CKA_VALUE, &attr) == FALSE) {
       OCK_LOG_ERR(ERR_FUNCTION_FAILED);
       return CKR_FUNCTION_FAILED;
   }
   if (keytype == CKK_DES2) {
      memcpy(key_value, attr->pValue, 2*DES_KEY_SIZE);
      memcpy(key_value + (2*DES_KEY_SIZE), attr->pValue, DES_KEY_SIZE);
   } else
      memcpy(key_value, attr->pValue, 3*DES_KEY_SIZE);

   rc = ica_3des_cmac_intermediate(message, (unsigned long) message_len,
                                          (const unsigned char *) key_value, mac);

   if (rc != 0) {
         OCK_LOG_ERR(ERR_FUNCTION_FAILED);
         rc = CKR_FUNCTION_FAILED;
   }
   return rc;
}

/**
 * Init SHA data structures
 */
CK_RV ica_sha_generic_init(DIGEST_CONTEXT *ctx, CK_MECHANISM_TYPE sha_type)
{
	unsigned int dev_ctx_size;
	struct oc_sha_ctx *sc;

	/* For the C_DigestInit, C_Digest case, we may have already 
	 * created ctx->context... - KEY */
	if (ctx->context) {
		sc = (struct oc_sha_ctx *)ctx->context;
		if(sc->dev_ctx)
			free(sc->dev_ctx);
		free(ctx->context);
	}
	/* The caller will check to see if ctx->context == NULL */
	ctx->context_len = sizeof(struct oc_sha_ctx);
	ctx->context = malloc(sizeof(struct oc_sha_ctx));
	if(ctx->context == NULL) {
                OCK_LOG_ERR(ERR_HOST_MEMORY);
		return CKR_HOST_MEMORY;
	}
	memset(ctx->context, 0, ctx->context_len);
	sc = (struct oc_sha_ctx *)ctx->context;

	switch (sha_type) {
	case CKM_SHA_1:
		sc->hash_len = SHA1_HASH_SIZE;
                dev_ctx_size = sizeof(sha_context_t);
		break;
	case CKM_SHA256:
		sc->hash_len = SHA2_HASH_SIZE;
                dev_ctx_size = sizeof(sha256_context_t);
		break;
	case CKM_SHA384:
		sc->hash_len = SHA3_HASH_SIZE;
                dev_ctx_size = sizeof(sha512_context_t);
		break;
	case CKM_SHA512:
		sc->hash_len = SHA5_HASH_SIZE;
                dev_ctx_size = sizeof(sha512_context_t);
		break;
	default:
		free(ctx->context);
		return CKR_MECHANISM_INVALID;
	}	
	sc->dev_ctx = malloc(dev_ctx_size);
	if(sc->dev_ctx == NULL){
		free(ctx->context);
                OCK_LOG_ERR(ERR_HOST_MEMORY);
		return CKR_HOST_MEMORY;
	}
	memset(sc->dev_ctx, 0, dev_ctx_size);
	sc->message_part = SHA_MSG_PART_ONLY;
	return CKR_OK;
}

CK_RV
token_specific_sha_init(DIGEST_CONTEXT *ctx)
{
	return ica_sha_generic_init(ctx, CKM_SHA_1);
}

CK_RV token_specific_sha2_init(DIGEST_CONTEXT *ctx)
{
	return ica_sha_generic_init(ctx, CKM_SHA256);
}

CK_RV token_specific_sha3_init(DIGEST_CONTEXT *ctx)
{
	return ica_sha_generic_init(ctx, CKM_SHA384);
}

CK_RV token_specific_sha5_init(DIGEST_CONTEXT *ctx)
{
	return ica_sha_generic_init(ctx, CKM_SHA512);
}

CK_RV ica_sha_generic(DIGEST_CONTEXT *ctx, CK_BYTE *in_data,
		      CK_ULONG in_data_len, CK_BYTE *out_data,
		      CK_ULONG *out_data_len, CK_ULONG hash_len)
{
	int rc;
	CK_RV rv = CKR_OK;
	unsigned int copy_len;
	struct oc_sha_ctx *oc_sha_ctx = (struct oc_sha_ctx *)ctx->context;
	
	if (!ctx)
		return CKR_OPERATION_NOT_INITIALIZED;

	if (!in_data || !out_data)
		return CKR_ARGUMENTS_BAD;

	if(*out_data_len < hash_len)
		return CKR_BUFFER_TOO_SMALL;

	oc_sha_ctx->message_part = SHA_MSG_PART_ONLY;
	oc_sha_ctx->hash_len = hash_len;

	switch (ctx->mech.mechanism) {
	case CKM_SHA_1:
	{	
        	sha_context_t *ica_sha_ctx = 
				(sha_context_t *) oc_sha_ctx->dev_ctx;

		rc = ica_sha1(oc_sha_ctx->message_part, in_data_len,
				in_data, ica_sha_ctx, oc_sha_ctx->hash);
		break;
	}
	case CKM_SHA256:
	{
        	sha256_context_t *ica_sha2_ctx =
				(sha256_context_t *)oc_sha_ctx->dev_ctx;
	
		rc = ica_sha256(oc_sha_ctx->message_part, in_data_len,
				in_data, ica_sha2_ctx, oc_sha_ctx->hash);
		break;
	}
	case CKM_SHA384:
	{
		sha512_context_t *ica_sha3_ctx =
				(sha512_context_t *)oc_sha_ctx->dev_ctx;

		rc = ica_sha384(oc_sha_ctx->message_part, in_data_len,
				in_data, ica_sha3_ctx, oc_sha_ctx->hash);
		break;
	}
	case CKM_SHA512:
	{
		sha512_context_t *ica_sha5_ctx =
				 (sha512_context_t *)oc_sha_ctx->dev_ctx;

		rc = ica_sha512(oc_sha_ctx->message_part, in_data_len,
				in_data, ica_sha5_ctx, oc_sha_ctx->hash);
		break;
	}
	default:
		return CKR_MECHANISM_INVALID;
	}

	if (rc == CKR_OK) {
		memcpy(out_data, oc_sha_ctx->hash, oc_sha_ctx->hash_len);
		*out_data_len = oc_sha_ctx->hash_len;
	} else
		rv = CKR_FUNCTION_FAILED;

        /* ctx->context is freed inside digest_mgr_cleanup - KEY */
	free(oc_sha_ctx->dev_ctx);
	
	return rv;
}

CK_RV token_specific_sha(DIGEST_CONTEXT *ctx, CK_BYTE *in_data,
			 CK_ULONG in_data_len, CK_BYTE *out_data,
			 CK_ULONG *out_data_len)
{
	return ica_sha_generic(ctx, in_data, in_data_len, out_data,
				out_data_len, SHA_HASH_LENGTH);
}

CK_RV token_specific_sha2(DIGEST_CONTEXT *ctx, CK_BYTE *in_data,
			 CK_ULONG in_data_len, CK_BYTE *out_data,
			 CK_ULONG *out_data_len)
{
	return ica_sha_generic(ctx, in_data, in_data_len, out_data,
				out_data_len, SHA256_HASH_LENGTH);
}

CK_RV token_specific_sha3(DIGEST_CONTEXT *ctx, CK_BYTE *in_data,
			 CK_ULONG in_data_len, CK_BYTE *out_data,
			 CK_ULONG *out_data_len)
{
	return ica_sha_generic(ctx, in_data, in_data_len, out_data,
				out_data_len, SHA384_HASH_LENGTH);
}

CK_RV token_specific_sha5(DIGEST_CONTEXT *ctx, CK_BYTE *in_data,
			 CK_ULONG in_data_len, CK_BYTE *out_data,
			 CK_ULONG *out_data_len)
{
	return ica_sha_generic(ctx, in_data, in_data_len, out_data,
				out_data_len, SHA512_HASH_LENGTH);
}

CK_RV token_specific_sha_update(DIGEST_CONTEXT *ctx, CK_BYTE *in_data,
				CK_ULONG in_data_len)
{
	unsigned int fill_size = 0;
	struct oc_sha_ctx *oc_sha_ctx = (struct oc_sha_ctx *)ctx->context;
        sha_context_t *ica_sha_ctx = (sha_context_t *) oc_sha_ctx->dev_ctx;

        oc_sha_ctx->hash_len = SHA_HASH_LENGTH;

	if (!ctx)
		return CKR_OPERATION_NOT_INITIALIZED;
	
	if (!in_data)
		return CKR_ARGUMENTS_BAD;
	
	if (oc_sha_ctx->tail_len == SHA1_BLOCK_SIZE) {
		/* Submit the filled out save buffer */
		if (ica_sha1((ica_sha_ctx->runningLength == 0 ?
		    SHA_MSG_PART_FIRST : SHA_MSG_PART_MIDDLE), SHA1_BLOCK_SIZE,
		    oc_sha_ctx->tail, ica_sha_ctx, oc_sha_ctx->hash))
			return CKR_FUNCTION_FAILED;

		oc_sha_ctx->tail_len = 0;

		/* adjust message part for next chunk of data to compute */
		oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;
	}

	/* libICA (and SHA1) demands that if this is a PART_FIRST or a 
	 * PART_MIDDLE operation, the amount of data passed in
	 * must be a multiple of the sha's blocksize in bytes. - KEY
	 */
	if (ica_sha_ctx->runningLength == 0 && oc_sha_ctx->tail_len == 0) {
		oc_sha_ctx->message_part = SHA_MSG_PART_FIRST;

		/* Just copying the last <64 bytes will not work in the case
		 * of a user who SHA's a large chunk of data in 64 byte
		 * pieces because we need to cache the last 64 bytes so that
		 * we're not stuck with 0 bytes when the MSG_PART_FINAL
		 * comes in. - KEY
		 */
		if (!(in_data_len % SHA1_BLOCK_SIZE)) {
			oc_sha_ctx->tail_len = SHA1_BLOCK_SIZE;
			memcpy(oc_sha_ctx->tail,
			       in_data + in_data_len - SHA1_BLOCK_SIZE,
			       SHA1_BLOCK_SIZE);
			in_data_len -= SHA1_BLOCK_SIZE;
		} else
			oc_sha_ctx->tail_len = in_data_len & SHA1_BLOCK_SIZE_MASK;
		if (oc_sha_ctx->tail_len < SHA1_BLOCK_SIZE) {
			in_data_len &= ~(SHA1_BLOCK_SIZE_MASK);	
			memcpy(oc_sha_ctx->tail, in_data + in_data_len, oc_sha_ctx->tail_len);
		}
	} else if (ica_sha_ctx->runningLength == 0 &&
		   oc_sha_ctx->tail_len > 0 ) {

		/* Here we need to fill out the temporary tail buffer until
		 * it has 64 bytes in it, then call ica_sha1 on that buffer.
		 * If there weren't enough bytes passed in to fill it out,
		 * just copy in what we can and return success without calling
		 * ica_sha1. - KEY
		 */

		fill_size = SHA1_BLOCK_SIZE - oc_sha_ctx->tail_len;
		if (fill_size < in_data_len) {
			memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len,
				in_data, fill_size);
			
			/* Submit the filled out save buffer */
			if (ica_sha1(SHA_MSG_PART_FIRST, SHA1_BLOCK_SIZE,
				     oc_sha_ctx->tail, ica_sha_ctx,
				     oc_sha_ctx->hash))
				return CKR_FUNCTION_FAILED;
			else
				oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;
		 } else {
			memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len,
				in_data, in_data_len);
			oc_sha_ctx->tail_len += in_data_len;

			return CKR_OK;
		}

		/* We had to use 'fill_size' bytes from in_data to
		 * fill out the empty part of save data, so adjust
		 * in_data_len
		 */
		in_data_len -= fill_size;
		oc_sha_ctx->tail_len = in_data_len & SHA1_BLOCK_SIZE_MASK;
		if (oc_sha_ctx->tail_len) {
			in_data_len &= ~(SHA1_BLOCK_SIZE_MASK);
			memcpy(oc_sha_ctx->tail, in_data + in_data_len
				+ fill_size, oc_sha_ctx->tail_len);
		}
	} else if (ica_sha_ctx->runningLength > 0) {
		oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;
		if (oc_sha_ctx->tail_len) {
			fill_size = SHA1_BLOCK_SIZE - oc_sha_ctx->tail_len;
			if (fill_size < in_data_len) {
				memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len, 
					in_data, fill_size);

				/* Submit the filled out save buffer */
				if (ica_sha1(oc_sha_ctx->message_part,
					     SHA1_BLOCK_SIZE, oc_sha_ctx->tail,
					     ica_sha_ctx, oc_sha_ctx->hash))
					return CKR_FUNCTION_FAILED;
			} else {
				memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len, in_data, in_data_len);
				oc_sha_ctx->tail_len += in_data_len;
				return CKR_OK;
			}

			/* We had to use some of the data from
			 * in_data to fill out the empty part of save
			 * data, so adjust in_data_len
			 */
			in_data_len -= fill_size;
			
			/* Save the _last_ oc_sha_ctx->tail_len bytes
			 * from in_data  Rajiv - 2009
			 */
			oc_sha_ctx->tail_len = in_data_len &
					       SHA1_BLOCK_SIZE_MASK;
			if (oc_sha_ctx->tail_len) {
				in_data_len &= ~(SHA1_BLOCK_SIZE_MASK);	
				memcpy(oc_sha_ctx->tail, in_data + fill_size
					+ in_data_len, oc_sha_ctx->tail_len);
			}
		} else {
			/* This is the odd case, where we need to go
			 * ahead and send the first X * SHA1_BLOCK_SIZE
			 * byte chunks in to be processed and copy the
			 * last <64 byte area into the tail. -KEY
			 */
			/* Just copying the last <64 bytes will not
			 * work in the case of a user who SHA's a large
			 * chunk of data in 64 byte pieces because we
			 * need to cache the last 64 bytes so that
			 * we're not stuck with 0 bytes when the
			 * MSG_PART_FINAL * comes in. - KEY
			 */
			if (!(in_data_len % SHA1_BLOCK_SIZE)) {
				oc_sha_ctx->tail_len = SHA1_BLOCK_SIZE; 
				memcpy(oc_sha_ctx->tail,
					in_data + in_data_len - SHA1_BLOCK_SIZE,
					SHA1_BLOCK_SIZE);
				in_data_len -= SHA1_BLOCK_SIZE;
			} else
				oc_sha_ctx->tail_len =
				     in_data_len & SHA1_BLOCK_SIZE_MASK;
			if (oc_sha_ctx->tail_len < SHA1_BLOCK_SIZE) {
				in_data_len &= ~(SHA1_BLOCK_SIZE_MASK);
				memcpy(oc_sha_ctx->tail, in_data + in_data_len,
					oc_sha_ctx->tail_len);
			}
		}
	}
	
        if (in_data_len) {
		if (ica_sha1(oc_sha_ctx->message_part, in_data_len,
			     in_data + fill_size, ica_sha_ctx,
			     oc_sha_ctx->hash))
			return CKR_FUNCTION_FAILED;
        }

	return CKR_OK;
}

CK_RV token_specific_sha2_update(DIGEST_CONTEXT *ctx, CK_BYTE *in_data,
				 CK_ULONG in_data_len)
{
	unsigned int fill_size = 0;
	CK_RV rv = CKR_OK;
	struct oc_sha_ctx *oc_sha_ctx = (struct oc_sha_ctx *)ctx->context;
        sha256_context_t *ica_sha2_ctx = (sha256_context_t *) oc_sha_ctx->dev_ctx;

        oc_sha_ctx->hash_len = SHA256_HASH_LENGTH;

	if (!ctx)
		return CKR_OPERATION_NOT_INITIALIZED;

	if (!in_data)
		return CKR_FUNCTION_FAILED;

	if (oc_sha_ctx->tail_len == SHA2_BLOCK_SIZE) {
		/* Submit the filled out save buffer */
		if (ica_sha256((ica_sha2_ctx->runningLength == 0 ?
		     SHA_MSG_PART_FIRST : SHA_MSG_PART_MIDDLE), SHA2_BLOCK_SIZE,
		     oc_sha_ctx->tail, ica_sha2_ctx, oc_sha_ctx->hash))
			return CKR_FUNCTION_FAILED;

		oc_sha_ctx->tail_len = 0;

		/* adjust message part for next chunk of data to compute */
		oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;
	}

	/* libICA and SHA256 demand that if this is a
	 * PART_FIRST or a PART_MIDDLE operation, the amount
	 * of data passed in must be a multiple of 64 bytes. -
	 * KEY */
	if (ica_sha2_ctx->runningLength == 0 && oc_sha_ctx->tail_len == 0) {
		oc_sha_ctx->message_part = SHA_MSG_PART_FIRST;
		/* Just copying the last <64 bytes will not
		 * work in the case of a user who SHA's a
		 * large chunk of data in 64 byte pieces
		 * because we need to cache the last 64 bytes
		 * so that we're not stuck with 0 bytes when
		 * the MSG_PART_FINAL comes in. - KEY
		 */
		if (!(in_data_len % SHA2_BLOCK_SIZE)) {
			oc_sha_ctx->tail_len = SHA2_BLOCK_SIZE;
			memcpy(oc_sha_ctx->tail,
				(in_data + in_data_len - SHA2_BLOCK_SIZE),
				SHA2_BLOCK_SIZE);
			in_data_len -= SHA2_BLOCK_SIZE;
		} else 
			oc_sha_ctx->tail_len = in_data_len & 0x3f;

		if (oc_sha_ctx->tail_len < SHA2_BLOCK_SIZE) {
			in_data_len &= ~(SHA2_BLOCK_SIZE_MASK);	
			memcpy(oc_sha_ctx->tail, (in_data + in_data_len),
			       oc_sha_ctx->tail_len);
		}
	} else if (ica_sha2_ctx->runningLength == 0 &&
		   oc_sha_ctx->tail_len > 0) {
		/* Here we need to fill out the temporary tail
		 * buffer until it has 64 bytes in it, then
		 * call ica_sha256 on that buffer.  If there
		 * weren't enough bytes passed in to fill it
		 * out, just copy in what we can and return
		 * success without calling ica_sha256. - KEY */
		fill_size = SHA2_BLOCK_SIZE - oc_sha_ctx->tail_len;
		if (fill_size < in_data_len) {
			memcpy((oc_sha_ctx->tail + oc_sha_ctx->tail_len),
			       in_data, fill_size);
			/* Submit the filled out save buffer */
			if (ica_sha256(SHA_MSG_PART_FIRST, SHA2_BLOCK_SIZE,
					oc_sha_ctx->tail,ica_sha2_ctx,
					oc_sha_ctx->hash))
				return CKR_FUNCTION_FAILED;
			else
				oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;
		} else {
			memcpy((oc_sha_ctx->tail + oc_sha_ctx->tail_len),
			       in_data, in_data_len);
			oc_sha_ctx->tail_len += in_data_len;
			return CKR_OK;
	}
		/* We had to use 'fill_size' bytes from
		 * in_data to fill out the empty part of save
		 * data, so adjust in_data_len
		 */
		in_data_len -= fill_size;
		oc_sha_ctx->tail_len = in_data_len & SHA2_BLOCK_SIZE_MASK;
		if (oc_sha_ctx->tail_len) {
			in_data_len &= ~(SHA2_BLOCK_SIZE_MASK);
			memcpy(oc_sha_ctx->tail, in_data + fill_size +
				in_data_len, oc_sha_ctx->tail_len);
		}
	} else if (ica_sha2_ctx->runningLength > 0) {
		oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;
		if (oc_sha_ctx->tail_len) {
			fill_size = SHA2_BLOCK_SIZE - oc_sha_ctx->tail_len;
			if (fill_size < in_data_len) {
				memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len, 
				       in_data, fill_size);
                       	        /* Submit the filled out save buffer */
				if (ica_sha256(oc_sha_ctx->message_part,
						SHA2_BLOCK_SIZE,
						oc_sha_ctx->tail, ica_sha2_ctx,
						oc_sha_ctx->hash))
					return CKR_FUNCTION_FAILED;
               	        } else {
				memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len,
				       in_data, in_data_len);
                                oc_sha_ctx->tail_len += in_data_len;
				return CKR_OK;
               	        }
			/* We had to use some of the data from
			 * in_data to fill out the empty part
			 * of save data, so adjust in_data_len
			 */
			in_data_len -= fill_size;
			oc_sha_ctx->tail_len = in_data_len &
					       SHA2_BLOCK_SIZE_MASK;
			if (oc_sha_ctx->tail_len) {
				in_data_len &= ~(SHA2_BLOCK_SIZE_MASK);	
				memcpy(oc_sha_ctx->tail, in_data + fill_size
					+ in_data_len, oc_sha_ctx->tail_len);
			}
		} else {
			/* This is the odd case, where we need
			 * to go ahead and send the first X *
			 * 64 byte chunks in to be processed
			 * and copy the last <64 byte area
			 * into the tail. -KEY */
			/* Just copying the last <64 bytes
			 * will not work in the case of a user
			 * who SHA's a large chunk of data in
			 * 64 byte pieces because we need to
			 * cache the last 64 bytes so that
			 * we're not stuck with 0 bytes when
			 * the MSG_PART_FINAL comes in. - KEY
			 */
		  	if (!(in_data_len % SHA2_BLOCK_SIZE)) {
				oc_sha_ctx->tail_len = SHA2_BLOCK_SIZE;
				memcpy(oc_sha_ctx->tail,
				      (in_data + in_data_len - SHA2_BLOCK_SIZE),
				      SHA2_BLOCK_SIZE);
				in_data_len -= SHA2_BLOCK_SIZE;
			} else
				oc_sha_ctx->tail_len =
					    in_data_len & SHA2_BLOCK_SIZE_MASK;

			if (oc_sha_ctx->tail_len < SHA2_BLOCK_SIZE) {
				in_data_len &= ~(SHA2_BLOCK_SIZE_MASK);
				memcpy(oc_sha_ctx->tail,(in_data + in_data_len),
					oc_sha_ctx->tail_len);
			}
		}
	}

	if (in_data_len) {
                if (ica_sha256(oc_sha_ctx->message_part, in_data_len,
				    in_data + fill_size, ica_sha2_ctx,
				    oc_sha_ctx->hash))
			return CKR_FUNCTION_FAILED;
	}

	return CKR_OK;
}

CK_RV token_specific_sha3_update(DIGEST_CONTEXT *ctx, CK_BYTE *in_data,
				 CK_ULONG in_data_len)
{
	unsigned int fill_size = 0;
	struct oc_sha_ctx *oc_sha_ctx = (struct oc_sha_ctx *)ctx->context;
        sha512_context_t *ica_sha3_ctx = (sha512_context_t *)oc_sha_ctx->dev_ctx;

        oc_sha_ctx->hash_len = SHA384_HASH_LENGTH;

	if (!ctx)
		return CKR_OPERATION_NOT_INITIALIZED;

	if (!in_data)
		return CKR_FUNCTION_FAILED;

	if (oc_sha_ctx->tail_len == SHA3_BLOCK_SIZE) {
		/* Submit the filled out save buffer */
		if (ica_sha384(((ica_sha3_ctx->runningLengthLow == 0 &&
				      ica_sha3_ctx->runningLengthHigh == 0) ?
				      SHA_MSG_PART_FIRST : SHA_MSG_PART_MIDDLE),
				      SHA3_BLOCK_SIZE, oc_sha_ctx->tail,
				      ica_sha3_ctx, oc_sha_ctx->hash))
			return CKR_FUNCTION_FAILED;

		oc_sha_ctx->tail_len = 0;
		/* adjust message part for next chunk of data to compute */
		oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;
	}

	/* libICA and SHA384 demand that if this is a
	 * PART_FIRST or a PART_MIDDLE operation, the amount
	 * of data passed in must be a multiple of
	 * SHA3_BLOCK_SIZE bytes.
	 */
	if (ica_sha3_ctx->runningLengthLow == 0
	    && ica_sha3_ctx->runningLengthHigh == 0
	    && oc_sha_ctx->tail_len == 0) {
		oc_sha_ctx->message_part = SHA_MSG_PART_FIRST;
		/* Just copying the last <SHA3_BLOCK_SIZE
		 * bytes will not work in the case of a user
		 * who SHA's a large chunk of data in
		 * SHA3_BLOCK_SIZE byte pieces because we need
		 * to cache the last SHA3_BLOCK_SIZE bytes so
		 * that we're not stuck with 0 bytes when the
		 * MSG_PART_FINAL comes in.
		 */
		if (!(in_data_len % SHA3_BLOCK_SIZE)) {
			oc_sha_ctx->tail_len = SHA3_BLOCK_SIZE;
			memcpy(oc_sha_ctx->tail,
			       (in_data + in_data_len - SHA3_BLOCK_SIZE),
			       SHA3_BLOCK_SIZE);
			in_data_len -= SHA3_BLOCK_SIZE;
		} else {
			oc_sha_ctx->tail_len = (in_data_len
						& SHA3_BLOCK_SIZE_MASK);
		}
		if (oc_sha_ctx->tail_len < SHA3_BLOCK_SIZE) {
			in_data_len &= ~(SHA3_BLOCK_SIZE_MASK);	
			memcpy(oc_sha_ctx->tail,
			       (in_data + in_data_len),
			       oc_sha_ctx->tail_len);
		}
	} else if (ica_sha3_ctx->runningLengthLow == 0
		   && ica_sha3_ctx->runningLengthHigh == 0
		   && oc_sha_ctx->tail_len > 0) {
		/* Here we need to fill out the temporary tail
		 * buffer until it has SHA3_BLOCK_SIZE bytes
		 * in it, then call ica_sha384 on that buffer.
		 * If there weren't enough bytes passed in to
		 * fill it out, just copy in what we can and
		 * return success without calling
		 * ica_sha384.
		 */
		fill_size = SHA3_BLOCK_SIZE - oc_sha_ctx->tail_len;
		if (fill_size < in_data_len) {
			memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len,
			       in_data, fill_size);
			/* Submit the filled out save buffer */
			if (ica_sha384(SHA_MSG_PART_FIRST, SHA3_BLOCK_SIZE,
					oc_sha_ctx->tail, ica_sha3_ctx,
					oc_sha_ctx->hash))
				return CKR_FUNCTION_FAILED;
			else
				oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;
		} else {
			memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len,
			       in_data, in_data_len);
			oc_sha_ctx->tail_len += in_data_len;
			return CKR_OK;
		}
		/* We had to use 'fill_size' bytes from
		 * in_data to fill out the empty part of save
		 * data, so adjust in_data_len
		 */
		in_data_len -= fill_size;
		oc_sha_ctx->tail_len = in_data_len & SHA3_BLOCK_SIZE_MASK;
		if (oc_sha_ctx->tail_len) {
			in_data_len &= ~(SHA3_BLOCK_SIZE_MASK);
			memcpy(oc_sha_ctx->tail, in_data + fill_size +
				in_data_len, oc_sha_ctx->tail_len);
		}
	} else if (ica_sha3_ctx->runningLengthLow > 0
		   || ica_sha3_ctx->runningLengthHigh > 0) {
		oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;
		if (oc_sha_ctx->tail_len) {
			fill_size = SHA3_BLOCK_SIZE - oc_sha_ctx->tail_len;
			if (fill_size < in_data_len) {
				memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len,
				       in_data, fill_size);
					/* Submit the filled out save buffer */
				if (ica_sha384(oc_sha_ctx->message_part,
						SHA3_BLOCK_SIZE,
						oc_sha_ctx->tail, ica_sha3_ctx,
						oc_sha_ctx->hash))
					return CKR_FUNCTION_FAILED;
               	        } else {
				memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len,
				       in_data, in_data_len);
                                oc_sha_ctx->tail_len += in_data_len;
				return CKR_OK;
               	        }
			/* We had to use some of the data from
			 * in_data to fill out the empty part
			 * of save data, so adjust in_data_len
			 */
			in_data_len -= fill_size;
			oc_sha_ctx->tail_len = in_data_len
						& SHA3_BLOCK_SIZE_MASK;
			if (oc_sha_ctx->tail_len) {
				in_data_len &= ~(SHA3_BLOCK_SIZE_MASK);
				memcpy(oc_sha_ctx->tail,
				       in_data + fill_size + in_data_len,
				       oc_sha_ctx->tail_len);
			}
		} else {
			/* This is the odd case, where we need
			 * to go ahead and send the first X *
			 * SHA3_BLOCK_SIZE byte chunks in to
			 * be processed and copy the last
			 * <SHA3_BLOCK_SIZE byte area into the
			 * tail.
			 *
			 * Just copying the last
			 * <SHA3_BLOCK_SIZE bytes will not
			 * work in the case of a user who
			 * SHA's a large chunk of data in
			 * SHA3_BLOCK_SIZE byte pieces because
			 * we need to cache the last
			 * SHA3_BLOCK_SIZE bytes so that we're
			 * not stuck with 0 bytes when the
			 * MSG_PART_FINAL comes in.
			 */
                       	if (!(in_data_len % SHA3_BLOCK_SIZE)) {
				oc_sha_ctx->tail_len = SHA3_BLOCK_SIZE;
				memcpy(oc_sha_ctx->tail,
				      (in_data + in_data_len - SHA3_BLOCK_SIZE),
				       SHA3_BLOCK_SIZE);
       	                        in_data_len -= SHA3_BLOCK_SIZE;
               	        } else {
				oc_sha_ctx->tail_len = in_data_len
							& SHA3_BLOCK_SIZE_MASK;
			}
			if (oc_sha_ctx->tail_len < SHA3_BLOCK_SIZE) {
				in_data_len &= ~(SHA3_BLOCK_SIZE_MASK);
				memcpy(oc_sha_ctx->tail,
				in_data + in_data_len, oc_sha_ctx->tail_len);
			}
		}
	}

	if (in_data_len) {
		if (ica_sha384(oc_sha_ctx->message_part, in_data_len,
				in_data + fill_size, ica_sha3_ctx,
				     oc_sha_ctx->hash))
			return CKR_FUNCTION_FAILED;
	}

	return CKR_OK;
}

CK_RV token_specific_sha5_update(DIGEST_CONTEXT *ctx, CK_BYTE *in_data,
				 CK_ULONG in_data_len)
{
	unsigned int fill_size = 0;
	struct oc_sha_ctx *oc_sha_ctx = (struct oc_sha_ctx *)ctx->context;
	SHA512_CONTEXT *ica_sha5_ctx=(SHA512_CONTEXT *)oc_sha_ctx->dev_ctx;

        oc_sha_ctx->hash_len = SHA512_HASH_LENGTH;

	if (!ctx)
		return CKR_OPERATION_NOT_INITIALIZED;

	if (!in_data)
		return CKR_FUNCTION_FAILED;

	if (oc_sha_ctx->tail_len == SHA5_BLOCK_SIZE) {
		/* Submit the filled out save buffer */
		if (ica_sha512(((ica_sha5_ctx->runningLengthLow == 0 &&
				      ica_sha5_ctx->runningLengthHigh == 0) ?
				      SHA_MSG_PART_FIRST : SHA_MSG_PART_MIDDLE),
				      SHA5_BLOCK_SIZE, oc_sha_ctx->tail,
				      ica_sha5_ctx, oc_sha_ctx->hash))
			return CKR_FUNCTION_FAILED;

		oc_sha_ctx->tail_len = 0;

		/* adjust message part for next chunk of data to compute */
		oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;
	}

	/* libICA and SHA512 demand that if this is a
	 * PART_FIRST or a PART_MIDDLE operation, the amount
	 * of data passed in must be a multiple of
	 * SHA5_BLOCK_SIZE bytes.
	 */
	if (ica_sha5_ctx->runningLengthLow == 0
	    && ica_sha5_ctx->runningLengthHigh == 0
	    && oc_sha_ctx->tail_len == 0) {
		oc_sha_ctx->message_part = SHA_MSG_PART_FIRST;
		/* Just copying the last <SHA5_BLOCK_SIZE
		 * bytes will not work in the case of a user
		 * who SHA's a large chunk of data in
		 * SHA5_BLOCK_SIZE byte pieces because we need
		 * to cache the last SHA5_BLOCK_SIZE bytes so
		 * that we're not stuck with 0 bytes when the
		 * MSG_PART_FINAL comes in. */
		if (!(in_data_len % SHA5_BLOCK_SIZE)) {
			oc_sha_ctx->tail_len = SHA5_BLOCK_SIZE;
			memcpy(oc_sha_ctx->tail,
			       in_data + in_data_len - SHA5_BLOCK_SIZE,
			       SHA5_BLOCK_SIZE);
			in_data_len -= SHA5_BLOCK_SIZE;
		} else {
			oc_sha_ctx->tail_len = in_data_len
						& SHA5_BLOCK_SIZE_MASK;
		}
		if (oc_sha_ctx->tail_len < SHA5_BLOCK_SIZE) {
			in_data_len &= ~(SHA5_BLOCK_SIZE_MASK);	
			memcpy(oc_sha_ctx->tail, in_data + in_data_len,
			       oc_sha_ctx->tail_len);
		}
	} else if (ica_sha5_ctx->runningLengthLow == 0
		   && ica_sha5_ctx->runningLengthHigh == 0
		   && oc_sha_ctx->tail_len > 0) {
		/* Here we need to fill out the temporary tail
		 * buffer until it has SHA5_BLOCK_SIZE bytes
		 * in it, then call ica_sha512 on that buffer.
		 * If there weren't enough bytes passed in to
		 * fill it out, just copy in what we can and
		 * return success without calling
		 * ica_sha512. */
		fill_size = SHA5_BLOCK_SIZE - oc_sha_ctx->tail_len;
		if (fill_size < in_data_len) {
			memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len,
			       in_data, fill_size);
			/* Submit the filled out save buffer */
			if (ica_sha512(SHA_MSG_PART_FIRST, SHA5_BLOCK_SIZE,
					oc_sha_ctx->tail, ica_sha5_ctx,
					oc_sha_ctx->hash))
				return CKR_FUNCTION_FAILED;
			else
				oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;
		} else {
			memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len,
			       in_data, in_data_len);
			oc_sha_ctx->tail_len += in_data_len;
			return CKR_OK;
		}
		/* We had to use 'fill_size' bytes from
		 * in_data to fill out the empty part of save
		 * data, so adjust in_data_len
		 */
		in_data_len -= fill_size;
		oc_sha_ctx->tail_len = in_data_len & SHA5_BLOCK_SIZE_MASK;
		if (oc_sha_ctx->tail_len) {
			in_data_len &= ~(SHA5_BLOCK_SIZE_MASK);
			memcpy(oc_sha_ctx->tail, in_data + fill_size
				+ in_data_len, oc_sha_ctx->tail_len);
		}
	} else if (ica_sha5_ctx->runningLengthLow > 0
		   || ica_sha5_ctx->runningLengthHigh > 0) {
		oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;
		if (oc_sha_ctx->tail_len) {
			fill_size = SHA5_BLOCK_SIZE - oc_sha_ctx->tail_len;
			if (fill_size < in_data_len) {
				memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len,
					in_data, fill_size);
				/* Submit the filled out save buffer */
				if (ica_sha512(oc_sha_ctx->message_part,
						SHA5_BLOCK_SIZE,
						oc_sha_ctx->tail, ica_sha5_ctx,
						oc_sha_ctx->hash))
					return CKR_FUNCTION_FAILED;
               	        } else {
				memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len,
				       in_data, in_data_len);
                                oc_sha_ctx->tail_len += in_data_len;
				return CKR_OK;
               	        }
			/* We had to use some of the data from
			 * in_data to fill out the empty part
			 * of save data, so adjust in_data_len */
			in_data_len -= fill_size;
			oc_sha_ctx->tail_len = (in_data_len
						& SHA5_BLOCK_SIZE_MASK);
			if (oc_sha_ctx->tail_len) {
				in_data_len &= ~(SHA5_BLOCK_SIZE_MASK);
				memcpy(oc_sha_ctx->tail, in_data + fill_size
					+ in_data_len, oc_sha_ctx->tail_len);
			}
		} else {
			/* This is the odd case, where we need
			 * to go ahead and send the first X *
			 * SHA5_BLOCK_SIZE byte chunks in to
			 * be processed and copy the last
			 * <SHA5_BLOCK_SIZE byte area into the
			 * tail.
			 *
			 * Just copying the last
			 * <SHA5_BLOCK_SIZE bytes will not
			 * work in the case of a user who
			 * SHA's a large chunk of data in
			 * SHA5_BLOCK_SIZE byte pieces because
			 * we need to cache the last
			 * SHA5_BLOCK_SIZE bytes so that we're
			 * not stuck with 0 bytes when the
			 * MSG_PART_FINAL comes in. */
                       	if (!(in_data_len % SHA5_BLOCK_SIZE)) {
                               	oc_sha_ctx->tail_len = SHA5_BLOCK_SIZE;
				memcpy(oc_sha_ctx->tail,
				      (in_data + in_data_len - SHA5_BLOCK_SIZE),
				       SHA5_BLOCK_SIZE);
				in_data_len -= SHA5_BLOCK_SIZE;
			} else {
				oc_sha_ctx->tail_len = in_data_len
							& SHA5_BLOCK_SIZE_MASK;
			}
			if (oc_sha_ctx->tail_len < SHA5_BLOCK_SIZE) {
				in_data_len &= ~(SHA5_BLOCK_SIZE_MASK);
				memcpy(oc_sha_ctx->tail, in_data + in_data_len,
					oc_sha_ctx->tail_len);
			}
		}
	}

	if (in_data_len) {
		if (ica_sha512(oc_sha_ctx->message_part, in_data_len,
				in_data + fill_size, ica_sha5_ctx,
				     oc_sha_ctx->hash))
			return CKR_FUNCTION_FAILED;
	}

	return CKR_OK;
}

CK_RV ica_sha_generic_final(DIGEST_CONTEXT *ctx, CK_BYTE *out_data,
			    CK_ULONG *out_data_len, CK_ULONG hash_len)
{
	int rc; 
	CK_RV rv = CKR_OK;
	struct oc_sha_ctx *oc_sha_ctx = (struct oc_sha_ctx *)ctx->context;

	oc_sha_ctx->message_part = SHA_MSG_PART_FINAL;

	if (!ctx)
		return CKR_OPERATION_NOT_INITIALIZED;

	if (!out_data)
		return CKR_ARGUMENTS_BAD;

	if (*out_data_len < hash_len)
		return CKR_BUFFER_TOO_SMALL;

	switch (ctx->mech.mechanism) {
	case CKM_SHA_1:
	{
		sha_context_t *ica_sha1_ctx =
				(sha_context_t *)oc_sha_ctx->dev_ctx;

		/* accommodate multi-part when input was so small
		 * that we never got to call into libica until final
		 */
		if (ica_sha1_ctx->runningLength == 0) 
			oc_sha_ctx->message_part = SHA_MSG_PART_ONLY;
		rc = ica_sha1(oc_sha_ctx->message_part, oc_sha_ctx->tail_len,
			     (unsigned char *)oc_sha_ctx->tail, ica_sha1_ctx,
			      oc_sha_ctx->hash);
		break;
	}
	case CKM_SHA256:
	{
		sha256_context_t *ica_sha2_ctx =
				(sha256_context_t *)oc_sha_ctx->dev_ctx;
	
		/* accommodate multi-part when input was so small
		 * that we never got to call into libica until final
		 */
		if (ica_sha2_ctx->runningLength == 0) 
			oc_sha_ctx->message_part = SHA_MSG_PART_ONLY;

		rc = ica_sha256(oc_sha_ctx->message_part, oc_sha_ctx->tail_len,
			      oc_sha_ctx->tail, ica_sha2_ctx, oc_sha_ctx->hash);
		break;
	}
	case CKM_SHA384:
	{
		sha512_context_t *ica_sha3_ctx =
				(sha512_context_t *)oc_sha_ctx->dev_ctx;

		/* accommodate multi-part when input was so small
		 * that we never got to call into libica until final
		 */
		if (ica_sha3_ctx->runningLengthLow == 0
		    && ica_sha3_ctx->runningLengthHigh == 0) 
			oc_sha_ctx->message_part = SHA_MSG_PART_ONLY;

		rc = ica_sha384(oc_sha_ctx->message_part, oc_sha_ctx->tail_len,
			      oc_sha_ctx->tail, ica_sha3_ctx, oc_sha_ctx->hash);
		break;
	}
	case CKM_SHA512:
	{
		sha512_context_t *ica_sha5_ctx =
				(sha512_context_t *)oc_sha_ctx->dev_ctx;

		/* accommodate multi-part when input was so small
		 * that we never got to call into libica until final
		 */
		if (ica_sha5_ctx->runningLengthLow == 0
		    && ica_sha5_ctx->runningLengthHigh == 0)
			oc_sha_ctx->message_part = SHA_MSG_PART_ONLY;

		rc = ica_sha512(oc_sha_ctx->message_part, oc_sha_ctx->tail_len,
			      oc_sha_ctx->tail, ica_sha5_ctx, oc_sha_ctx->hash);
		break;
	}
	default:
		return CKR_MECHANISM_INVALID;
	}

	if (rc != CKR_OK) {
		rv = CKR_FUNCTION_FAILED;
		goto out;
	}
	
	memcpy(out_data, oc_sha_ctx->hash, hash_len);
	*out_data_len = hash_len;

out:
	/* ctx->context is freed inside digest_mgr_cleanup - KEY */
	free(oc_sha_ctx->dev_ctx);
	return rv;
}

CK_RV token_specific_sha_final(DIGEST_CONTEXT *ctx, CK_BYTE *out_data,
				CK_ULONG *out_data_len)
{
	return ica_sha_generic_final(ctx, out_data, out_data_len,
				     SHA_HASH_LENGTH);
}

CK_RV token_specific_sha2_final(DIGEST_CONTEXT *ctx, CK_BYTE *out_data,
				CK_ULONG *out_data_len)
{
	return ica_sha_generic_final(ctx, out_data, out_data_len,
				 SHA256_HASH_LENGTH);
}

CK_RV token_specific_sha3_final(DIGEST_CONTEXT *ctx, CK_BYTE *out_data,
				CK_ULONG *out_data_len)
{
	return ica_sha_generic_final(ctx, out_data, out_data_len,
				 SHA384_HASH_LENGTH);
}

CK_RV token_specific_sha5_final(DIGEST_CONTEXT *ctx, CK_BYTE *out_data,
				CK_ULONG *out_data_len)
{
	return ica_sha_generic_final(ctx, out_data, out_data_len,
				 SHA512_HASH_LENGTH);
}

#ifndef LITE
#define LITE
#endif

/* Creates a libICA modulus+exponent key representation using
 * PKCS#11 attributes
 */
ica_rsa_key_mod_expo_t *
rsa_convert_mod_expo_key( CK_ATTRIBUTE * modulus,
                          CK_ATTRIBUTE * mod_bits,
                          CK_ATTRIBUTE * exponent)
{
   CK_BYTE                * ptr     = NULL;
   ica_rsa_key_mod_expo_t * modexpokey = NULL;

   /* We need at least the modulus and a (public|private) exponent */
   if (!modulus || !exponent) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      return NULL;
   }

   modexpokey = (ica_rsa_key_mod_expo_t *) calloc(1, sizeof(ica_rsa_key_mod_expo_t));
   if (modexpokey == NULL) {
      OCK_LOG_ERR(ERR_HOST_MEMORY);
      goto err;
   }

   /* We can't rely solely on CKA_MODULUS_BITS here since Private Keys
    * using the modulus + private exponent representation may also go
    * through this path. Use modulus length in bytes as key_length if
    * no mod_bits is present */
   if (mod_bits != NULL && mod_bits->ulValueLen && (*(CK_ULONG *)mod_bits->pValue)) {
      modexpokey->key_length = ((* (CK_ULONG *) mod_bits->pValue) + 7 ) / 8;
   }
   else {
      modexpokey->key_length = modulus->ulValueLen;
   }

   /* maybe I'm over-cautious here */
   if ( (modulus->ulValueLen > modexpokey->key_length) ||
        (exponent->ulValueLen > modexpokey->key_length)) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      goto err;
   }

   modexpokey->modulus = (unsigned char *) calloc(1, modexpokey->key_length);

   if (modexpokey->modulus == NULL) {
      OCK_LOG_ERR(ERR_HOST_MEMORY);
      goto err;
   }

   /* right-justified fields */
   ptr = modexpokey->modulus + modexpokey->key_length - modulus->ulValueLen;
   memcpy(ptr, modulus->pValue, modexpokey->key_length);

   modexpokey->exponent = (unsigned char *) calloc(1, modexpokey->key_length);
   if (modexpokey->exponent == NULL) {
      OCK_LOG_ERR(ERR_HOST_MEMORY);
      goto err;
   }

   ptr = modexpokey->exponent + modexpokey->key_length - exponent->ulValueLen;
   memcpy(ptr, exponent->pValue, exponent->ulValueLen);
   return modexpokey;

 err:
   free(modexpokey->modulus);
   free(modexpokey->exponent);
   free(modexpokey);
   return NULL;

}

/* Creates a libICA CRT key representation using
 * PKCS#11 attributes
 */
ica_rsa_key_crt_t *
rsa_convert_crt_key( CK_ATTRIBUTE * modulus,
                     CK_ATTRIBUTE * prime1,
                     CK_ATTRIBUTE * prime2,
                     CK_ATTRIBUTE * exp1,
                     CK_ATTRIBUTE * exp2,
                     CK_ATTRIBUTE * coeff)
{
   CK_BYTE           * ptr      = NULL;
   ica_rsa_key_crt_t * crtkey  = NULL;

   /* All the above params are required to build a CRT key
    * that can be used by libICA. Private Keys with modulus
    * and private exponent should use rsa_convert_mod_expo_key() */
   if (!modulus || !prime1 || !prime2 || !exp1 || !exp2 || !coeff ) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      return NULL;
   }
   else {
      crtkey = (ica_rsa_key_crt_t *) calloc(1, sizeof(ica_rsa_key_crt_t));
      if (crtkey == NULL) {
         OCK_LOG_ERR(ERR_HOST_MEMORY);
         return NULL;
      }
      /* use modulus length in bytes as key_length */
      crtkey->key_length = modulus->ulValueLen;

      /* buffers pointed by p, q, dp, dq and qInverse in struct
       * ica_rsa_key_crt_t must be of size key_legth/2 or larger.
       * p, dp and qInverse have an additional 8-byte padding. */

      /* need to allocate the buffers. Also, all fields are
       * right-aligned, thus the use for ptr */

      /* FIXME: if individual components lengths are bigger then
       * what we support in libICA then we're in trouble,
       * but maybe explicitly checking them is being over-zealous? */
      if ( (prime1->ulValueLen > (crtkey->key_length/2)) ||
           (prime2->ulValueLen > (crtkey->key_length/2)) ||
           (exp1->ulValueLen   > (crtkey->key_length/2)) ||
           (exp2->ulValueLen   > (crtkey->key_length/2)) ||
           (coeff->ulValueLen  > (crtkey->key_length/2)) ) {
         OCK_LOG_ERR(ERR_FUNCTION_FAILED);
         goto err_crtkey;
      }
      crtkey->p = (unsigned char *) calloc(1, (crtkey->key_length/2) + 8);
      if (crtkey->p == NULL) {
         OCK_LOG_ERR(ERR_HOST_MEMORY);
         goto err_crtkey;
      }
      ptr = crtkey->p + (crtkey->key_length/2) + 8 - prime1->ulValueLen;
      memcpy(ptr, prime1->pValue, prime1->ulValueLen);

      crtkey->q = (unsigned char *) calloc(1, crtkey->key_length/2);

      if (crtkey->q == NULL) {
         OCK_LOG_ERR(ERR_HOST_MEMORY);
         goto err_crtkey;
      }
      ptr = crtkey->q + (crtkey->key_length/2) - prime2->ulValueLen;
      memcpy(ptr, prime2->pValue, prime2->ulValueLen);

      crtkey->dp = (unsigned char *) calloc(1, (crtkey->key_length/2) + 8);
      if (crtkey->dp == NULL) {
         OCK_LOG_ERR(ERR_HOST_MEMORY);
         goto err_crtkey;
      }
      ptr = crtkey->dp + (crtkey->key_length/2) + 8 - exp1->ulValueLen;
      memcpy(ptr, exp1->pValue, exp1->ulValueLen);

      crtkey->dq = (unsigned char *) calloc(1, crtkey->key_length/2);
      if (crtkey->dq == NULL) {
         OCK_LOG_ERR(ERR_HOST_MEMORY);
         goto err_crtkey;
      }
      ptr = crtkey->dq + (crtkey->key_length/2) - exp2->ulValueLen;
      memcpy(ptr, exp2->pValue, exp2->ulValueLen);

      crtkey->qInverse = (unsigned char *) calloc(1, (crtkey->key_length/2) + 8);
      if (crtkey->qInverse == NULL) {
         OCK_LOG_ERR(ERR_HOST_MEMORY);
         goto err_crtkey;
      }
      ptr = crtkey->qInverse + (crtkey->key_length/2) + 8 - coeff->ulValueLen;
      memcpy(ptr, coeff->pValue, coeff->ulValueLen);

      return crtkey;
   }

 err_crtkey:
   free(crtkey->p);
   free(crtkey->q);
   free(crtkey->dp);
   free(crtkey->dq);
   free(crtkey->qInverse);
   free(crtkey);
   return NULL;

}


//
CK_RV
os_specific_rsa_keygen(TEMPLATE *publ_tmpl,  TEMPLATE *priv_tmpl)
{
   CK_ATTRIBUTE       * publ_exp = NULL;
   CK_ATTRIBUTE       * attr     = NULL;
   CK_BYTE            * ptr      = NULL;
   CK_ULONG             mod_bits;
   CK_BBOOL             flag;
   unsigned long        tmpsize;
   CK_RV                rc;
   ica_rsa_key_mod_expo_t * publKey = NULL;
   ica_rsa_key_crt_t      * privKey = NULL;

   flag = template_attribute_find( publ_tmpl, CKA_MODULUS_BITS, &attr );
   if (!flag) {
       OCK_LOG_ERR(ERR_TEMPLATE_INCOMPLETE);
       return CKR_TEMPLATE_INCOMPLETE;  // should never happen
   }
   mod_bits = *(CK_ULONG *)attr->pValue;

   flag = template_attribute_find( publ_tmpl, CKA_PUBLIC_EXPONENT, &publ_exp );
   if (!flag) {
        OCK_LOG_ERR(ERR_TEMPLATE_INCOMPLETE);
	return CKR_TEMPLATE_INCOMPLETE;
   }


   // FIXME: is this check really necessary?
   if (mod_bits < 512 || mod_bits > 4096) {
      OCK_LOG_ERR(ERR_KEY_SIZE_RANGE);
     return CKR_KEY_SIZE_RANGE;
   }

   /* libICA replicates the openSSL requirement that the public exponent
    * can't be larger than the size of an unsigned long
    */
   if (publ_exp->ulValueLen > sizeof (unsigned long)) {
      OCK_LOG_ERR(ERR_KEY_SIZE_RANGE);
     return CKR_KEY_SIZE_RANGE;
   }

   /* Build publKey:
    * The buffers in ica_rsa_key_mod_expo_t must be
    * allocated by the caller, with key_length size
    * use calloc() so that memory is zeroed (right alignment) */
   publKey = (ica_rsa_key_mod_expo_t *) calloc(1, sizeof(ica_rsa_key_mod_expo_t));
   if (publKey == NULL) {
      OCK_LOG_ERR(ERR_HOST_MEMORY);
      return CKR_HOST_MEMORY;
   }

   /* key_length is in terms of bytes */
   publKey->key_length = ((mod_bits + 7) / 8);

   publKey->modulus = (unsigned char *) calloc(1, publKey->key_length);
   if (publKey->modulus == NULL) {
      OCK_LOG_ERR(ERR_HOST_MEMORY);
      rc = CKR_HOST_MEMORY;
      goto pubkey_cleanup;
   }

   publKey->exponent = (unsigned char *) calloc(1, publKey->key_length);
   if (publKey->exponent == NULL) {
      OCK_LOG_ERR(ERR_HOST_MEMORY);
      rc = CKR_HOST_MEMORY;
      goto pubkey_cleanup;
   }

   /* Use the provided public exponent:
    * all fields must be right-aligned, so make
    * sure we only use the rightmost part */
   /* We know the pub_exp attribute has it's value in BIG ENDIAN        *
    * byte order, and we're assuming we're on s390(x) which is also     *
    * BIG ENDIAN, so no byte swapping required.                         *
    * FIXME: Will need to fix that if porting for little endian         */
   ptr = publKey->exponent + publKey->key_length - publ_exp->ulValueLen;
   memcpy(ptr, publ_exp->pValue, publ_exp->ulValueLen);

   /* If the public exponent is zero, libica will generate a random one *
    * If it is an even number, then we have a problem. Use ptr to cast  *
    * to unsigned int and check                                         */
   ptr = publKey->exponent + publKey->key_length - sizeof (unsigned long);
   if ( *( (unsigned long *)ptr) != 0 &&
        *( (unsigned long *)ptr) % 2 == 0 ) {
     OCK_LOG_ERR(ERR_TEMPLATE_INCONSISTENT);
     return CKR_TEMPLATE_INCONSISTENT;
   }


   /* Build privKey:
    * buffers pointed by p, q, dp, dq and qInverse in struct
    * ica_rsa_key_crt_t must be of size key_legth/2 or larger.
    * p, dp and qInverse have an additional 8-byte padding */
   privKey = (ica_rsa_key_crt_t *) calloc(1, sizeof(ica_rsa_key_crt_t));
   if (privKey == NULL) {
     OCK_LOG_ERR(ERR_HOST_MEMORY);
     rc = CKR_HOST_MEMORY;
     goto pubkey_cleanup;
   }

   /* modexpo and crt key lengths are always the same */
   privKey->key_length = publKey->key_length;

   privKey->p = (unsigned char *) calloc(1, (privKey->key_length/2) + 8);
   if (privKey->p == NULL) {
      OCK_LOG_ERR(ERR_HOST_MEMORY);
      rc = CKR_HOST_MEMORY;
      goto privkey_cleanup;
   }

   privKey->q = (unsigned char *) calloc(1, privKey->key_length/2);
   if (privKey->q == NULL) {
      OCK_LOG_ERR(ERR_HOST_MEMORY);
      rc = CKR_HOST_MEMORY;
      goto privkey_cleanup;
   }

   privKey->dp = (unsigned char *) calloc(1, (privKey->key_length/2) + 8);
   if (privKey->dp == NULL) {
      OCK_LOG_ERR(ERR_HOST_MEMORY);
      rc = CKR_HOST_MEMORY;
      goto privkey_cleanup;
   }

   privKey->dq = (unsigned char *) calloc(1, privKey->key_length/2);
   if (privKey->dq == NULL) {
      OCK_LOG_ERR(ERR_HOST_MEMORY);
      rc = CKR_HOST_MEMORY;
      goto privkey_cleanup;
   }

   privKey->qInverse = (unsigned char *) calloc(1, (privKey->key_length/2) + 8);
   if (privKey->qInverse == NULL) {
      OCK_LOG_ERR(ERR_HOST_MEMORY);
      rc = CKR_HOST_MEMORY;
      goto privkey_cleanup;
   }

   rc = ica_rsa_key_generate_crt(adapter_handle,
                                 (unsigned int)mod_bits,
                                 publKey,
                                 privKey);

   
   if(rc){
     OCK_LOG_ERR(ERR_FUNCTION_FAILED);
     rc = CKR_FUNCTION_FAILED;
     goto privkey_cleanup;
   }
   

   /* Build the PKCS#11 public key */
   // modulus: n
   //
   tmpsize = publKey->key_length;
   ptr = p11_bigint_trim(publKey->modulus, &tmpsize);
   if (tmpsize != publKey->key_length) {
      /* This is bad */
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      rc = CKR_FUNCTION_FAILED;
      goto privkey_cleanup;
   }
   rc = build_attribute( CKA_MODULUS, ptr,
                        tmpsize, &attr );
   if (rc != CKR_OK){
      OCK_LOG_ERR(ERR_BLD_ATTR);
      goto privkey_cleanup;
   }
   template_update_attribute( publ_tmpl, attr );

   // public exponent
   //
   tmpsize = publKey->key_length;
   ptr = p11_bigint_trim(publKey->exponent, &tmpsize);
   rc = build_attribute( CKA_PUBLIC_EXPONENT, ptr,
                        tmpsize, &attr);
   if (rc != CKR_OK){
      OCK_LOG_ERR(ERR_BLD_ATTR);
      goto privkey_cleanup;
   }
   template_update_attribute( publ_tmpl, attr );


   // local = TRUE
   //
   flag = TRUE;
   rc = build_attribute( CKA_LOCAL, &flag, sizeof(CK_BBOOL), &attr );
   if (rc != CKR_OK){
      OCK_LOG_ERR(ERR_BLD_ATTR);
      goto privkey_cleanup;
   }
   template_update_attribute( publ_tmpl, attr );

   //
   // now, do the private key
   //

   // public exponent: e
   //
   tmpsize = publKey->key_length;
   ptr = p11_bigint_trim(publKey->exponent, &tmpsize);
   rc = build_attribute( CKA_PUBLIC_EXPONENT, ptr, tmpsize, &attr );
   if (rc != CKR_OK) {
      OCK_LOG_ERR(ERR_BLD_ATTR);
      goto privkey_cleanup;
   }
   template_update_attribute( priv_tmpl, attr );

   // modulus: n
   //
   tmpsize = publKey->key_length;
   ptr = p11_bigint_trim(publKey->modulus, &tmpsize);
   if (tmpsize != publKey->key_length) {
      /* This is bad */
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      rc = CKR_FUNCTION_FAILED;
      goto privkey_cleanup;
   }
   rc = build_attribute( CKA_MODULUS, ptr,
                        tmpsize, &attr );
   if (rc != CKR_OK){
      OCK_LOG_ERR(ERR_BLD_ATTR);
      goto privkey_cleanup;
   }
   template_update_attribute( priv_tmpl, attr );

   // exponent 1: d mod(p-1)
   //
   tmpsize = privKey->key_length/2;
   ptr = p11_bigint_trim(privKey->dp + 8, &tmpsize);
   rc = build_attribute( CKA_EXPONENT_1, ptr,
                        tmpsize, &attr );
   if (rc != CKR_OK){
      OCK_LOG_ERR(ERR_BLD_ATTR);
      goto privkey_cleanup;
   }
   template_update_attribute( priv_tmpl, attr );

   // exponent 2: d mod(q-1)
   //
   tmpsize = privKey->key_length/2;
   ptr = p11_bigint_trim(privKey->dq, &tmpsize);
   rc = build_attribute( CKA_EXPONENT_2, ptr,
                        tmpsize, &attr );
   if (rc != CKR_OK){
      OCK_LOG_ERR(ERR_BLD_ATTR);
      goto privkey_cleanup;
   }
   template_update_attribute( priv_tmpl, attr );

   // prime #1: p
   //
   tmpsize = privKey->key_length/2;
   ptr = p11_bigint_trim(privKey->p + 8, &tmpsize);
   rc = build_attribute( CKA_PRIME_1, ptr,
                        tmpsize, &attr );
   if (rc != CKR_OK){
      OCK_LOG_ERR(ERR_BLD_ATTR);
      goto privkey_cleanup;
   }
   template_update_attribute( priv_tmpl, attr );


   // prime #2: q
   //
   tmpsize = privKey->key_length/2;
   ptr = p11_bigint_trim(privKey->q, &tmpsize);
   rc = build_attribute( CKA_PRIME_2, privKey->q,
                        privKey->key_length/2, &attr );
   if (rc != CKR_OK){
      OCK_LOG_ERR(ERR_BLD_ATTR);
      goto privkey_cleanup;
   }
   template_update_attribute( priv_tmpl, attr );


   // CRT coefficient:  q_inverse mod(p)
   //
   tmpsize = privKey->key_length/2;
   ptr = p11_bigint_trim(privKey->qInverse + 8, &tmpsize);
   rc = build_attribute( CKA_COEFFICIENT, ptr,
                        tmpsize, &attr );
   if (rc != CKR_OK){
      OCK_LOG_ERR(ERR_BLD_ATTR);
      goto privkey_cleanup;
   }
   template_update_attribute( priv_tmpl, attr );

 privkey_cleanup:
   free(privKey->p);
   free(privKey->q);
   free(privKey->dp);
   free(privKey->dq);
   free(privKey->qInverse);
   free(privKey);
 pubkey_cleanup:
   free(publKey->modulus);
   free(publKey->exponent);
   free(publKey);
   return rc;

}

CK_RV
token_specific_rsa_generate_keypair( TEMPLATE  * publ_tmpl,
                      TEMPLATE  * priv_tmpl )
{
   CK_RV                rc;

   rc = os_specific_rsa_keygen(publ_tmpl,priv_tmpl);
   if (rc != CKR_OK)
         OCK_LOG_ERR(ERR_KEYGEN);
   return rc;
}


//
//
CK_RV
os_specific_rsa_encrypt( CK_BYTE   * in_data,
                 CK_ULONG    in_data_len,
                 CK_BYTE   * out_data,
                 OBJECT    * key_obj )
{
   CK_ATTRIBUTE      * modulus = NULL;
   CK_ATTRIBUTE      * pub_exp = NULL;
   CK_ATTRIBUTE      * mod_bits = NULL;
   ica_rsa_key_mod_expo_t * publKey  = NULL;
   CK_RV               rc;

   /* mech_sra.c:ckm_rsa_encrypt accepts only CKO_PUBLIC_KEY */
   template_attribute_find( key_obj->template, CKA_MODULUS,          &modulus  );
   template_attribute_find( key_obj->template, CKA_MODULUS_BITS,     &mod_bits );
   template_attribute_find( key_obj->template, CKA_PUBLIC_EXPONENT,  &pub_exp  );

   publKey = rsa_convert_mod_expo_key(modulus, mod_bits, pub_exp);
   if (publKey == NULL) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      rc = CKR_FUNCTION_FAILED;
      goto done;
   }

   /* in_data must be in big endian format. 'in_data' size in bits must not
    * exceed the bit length of the key, and size in bytes must
    * be of the same length of the key */
   // FIXME: we're not cheking the size in bits of in_data - but how could we?
   if (publKey->key_length != in_data_len) {
      OCK_LOG_ERR(ERR_DATA_LEN_RANGE);
      rc = CKR_DATA_LEN_RANGE;
      goto cleanup_pubkey;
   }
   rc = ica_rsa_mod_expo(adapter_handle, in_data,
                         publKey, out_data);

   if (rc != 0) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      rc = CKR_FUNCTION_FAILED;
   } else {
      rc = CKR_OK;
   }

cleanup_pubkey:
   free(publKey->modulus);
   free(publKey->exponent);
   free(publKey);


done:
   return rc;
}

//
//
CK_RV
os_specific_rsa_decrypt( CK_BYTE   * in_data,
                 CK_ULONG    in_data_len,
                 CK_BYTE   * out_data,
                 OBJECT    * key_obj )
{
   CK_ATTRIBUTE      * modulus  = NULL;
   CK_ATTRIBUTE      * prime1   = NULL;
   CK_ATTRIBUTE      * prime2   = NULL;
   CK_ATTRIBUTE      * exp1     = NULL;
   CK_ATTRIBUTE      * exp2     = NULL;
   CK_ATTRIBUTE      * coeff    = NULL;
   CK_ATTRIBUTE           * priv_exp   = NULL;
   ica_rsa_key_crt_t      * crtKey     = NULL;
   ica_rsa_key_mod_expo_t * modexpoKey = NULL;
   CK_RV               rc;

   /* mech_rsa.c:ckm_rsa_decrypt accepts only CKO_PRIVATE_KEY,
    * but Private Key can have 2 representations (see PKCS#1):
    *  - Modulus + private exponent
    *  - p, q, dp, dq and qInv (CRT format)
    * The former should use ica_rsa_key_mod_expo_t and the latter
    * ica_rsa_key_crt_t. Detect what representation this
    * key_obj has and use the proper convert function */

   template_attribute_find( key_obj->template, CKA_MODULUS,          &modulus );
   template_attribute_find( key_obj->template, CKA_PRIVATE_EXPONENT, &priv_exp );
   template_attribute_find( key_obj->template, CKA_PRIME_1,          &prime1  );
   template_attribute_find( key_obj->template, CKA_PRIME_2,          &prime2  );
   template_attribute_find( key_obj->template, CKA_EXPONENT_1,       &exp1    );
   template_attribute_find( key_obj->template, CKA_EXPONENT_2,       &exp2    );
   template_attribute_find( key_obj->template, CKA_COEFFICIENT,      &coeff   );

   /* Need to check for CRT Key format *BEFORE* check for mod_expo key,
    * that's because opencryptoki *HAS* a CKA_PRIVATE_EXPONENT attribute
    * even in CRT keys (but with zero length) */
   // FIXME: Checking for non-zero lengths anyway (might be overkill)

   if (modulus && modulus->ulValueLen &&
       prime1  && prime1->ulValueLen  &&
       prime2  && prime2->ulValueLen  &&
       exp1    && exp1->ulValueLen    &&
       exp2    && exp2->ulValueLen    &&
       coeff   && coeff->ulValueLen     ) {
      /* ica_rsa_key_crt_t representation */
      crtKey = rsa_convert_crt_key(modulus, prime1, prime2, exp1, exp2, coeff);
      if (crtKey == NULL) {
         OCK_LOG_ERR(ERR_FUNCTION_FAILED);
         rc = CKR_FUNCTION_FAILED;
         goto done;
      }
      /* same check as above */
      if (crtKey->key_length != in_data_len) {
         OCK_LOG_ERR(ERR_DATA_LEN_RANGE);
         rc = CKR_ENCRYPTED_DATA_LEN_RANGE;
         goto crt_cleanup;
      }

      rc = ica_rsa_crt(adapter_handle, in_data,
                       crtKey, out_data);

      if (rc != 0) {
         OCK_LOG_ERR(ERR_FUNCTION_FAILED);
         rc = CKR_FUNCTION_FAILED;
      } else {
         rc = CKR_OK;
      }
      goto crt_cleanup;
   }
   else if (modulus  && modulus->ulValueLen &&
            priv_exp && priv_exp->ulValueLen  ) {
      /* ica_rsa_key_mod_expo_t representation */
      modexpoKey = rsa_convert_mod_expo_key(modulus, NULL, priv_exp);
      if (modexpoKey == NULL) {
         OCK_LOG_ERR(ERR_FUNCTION_FAILED);
         rc = CKR_FUNCTION_FAILED;
         goto done;
      }
      /* in_data must be in big endian format. Size in bits must not
       * exceed the bit length of the key, and size in bytes must
       * be the same */
      // FIXME: we're not cheking the size in bits of in_data - but how could we?
      if (modexpoKey->key_length != in_data_len) {
         OCK_LOG_ERR(ERR_DATA_LEN_RANGE);
         rc = CKR_ENCRYPTED_DATA_LEN_RANGE;
         goto modexpo_cleanup;
      }

      rc = ica_rsa_mod_expo(adapter_handle, in_data,
                            modexpoKey, out_data);

      if (rc != 0) {
         OCK_LOG_ERR(ERR_FUNCTION_FAILED);
         rc = CKR_FUNCTION_FAILED;
      } else {
         rc = CKR_OK;
      }
      goto modexpo_cleanup;
   }
   else {
      /* should never happen */
      OCK_LOG_ERR(ERR_MECHANISM_PARAM_INVALID);
      rc = CKR_MECHANISM_PARAM_INVALID;
      goto done;
   }

crt_cleanup:
   free(crtKey->p);
   free(crtKey->q);
   free(crtKey->dp);
   free(crtKey->dq);
   free(crtKey->qInverse);
   free(crtKey);
   goto done;

modexpo_cleanup:
   free(modexpoKey->modulus);
   free(modexpoKey->exponent);
   free(modexpoKey);

done:
   return rc;
}


CK_RV
token_specific_rsa_encrypt(CK_BYTE *in_data, CK_ULONG in_data_len,
			CK_BYTE *out_data, CK_ULONG *out_data_len,
			OBJECT *key_obj)
{
	CK_RV		rc;
	CK_BYTE		clear[MAX_RSA_KEYLEN], cipher[MAX_RSA_KEYLEN];
	CK_ULONG	modulus_bytes;
	CK_BBOOL	flag;
	CK_ATTRIBUTE	*attr = NULL;

	flag = template_attribute_find(key_obj->template, CKA_MODULUS, &attr);
	if (flag == FALSE) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	} else
		modulus_bytes = attr->ulValueLen;

	/* format the data */
	rc = rsa_format_block(in_data, in_data_len, clear, modulus_bytes, PKCS_BT_2);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_RSA_FORM_BLOCK);
		return rc;
	}

	rc = os_specific_rsa_encrypt(clear, modulus_bytes, cipher, key_obj);
	if (rc == CKR_OK) {
		memcpy(out_data, cipher, modulus_bytes);
		*out_data_len = modulus_bytes;
	} else
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);

	return rc;
}


CK_RV
token_specific_rsa_decrypt(CK_BYTE *in_data, CK_ULONG in_data_len,
			CK_BYTE *out_data, CK_ULONG *out_data_len,
			OBJECT *key_obj)
{
	CK_BYTE		out[MAX_RSA_KEYLEN];
	CK_RV		rc;

	rc = os_specific_rsa_decrypt(in_data, in_data_len, out, key_obj);

	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return rc;
	}

	rc = rsa_parse_block(out,in_data_len,out_data,out_data_len,PKCS_BT_2);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return rc;
	}

	/*
	 * For PKCS #1 v1.5 padding, out_data_len must be less
	 * than in_data_len (which is modulus_bytes) - 11.
	 */
	if (*out_data_len > (in_data_len - 11)) {
		OCK_LOG_ERR(ERR_ENCRYPTED_DATA_LEN_RANGE);
		rc = CKR_ENCRYPTED_DATA_LEN_RANGE;
	}

	return rc;
}

CK_RV
token_specific_rsa_sign(CK_BYTE *in_data, CK_ULONG in_data_len,
			CK_BYTE *out_data, CK_ULONG *out_data_len,
			OBJECT *key_obj)
{
	CK_ATTRIBUTE	*attr = NULL;
	CK_BBOOL	flag;
	CK_RV		rc;
	CK_BYTE		data[MAX_RSA_KEYLEN], sig[MAX_RSA_KEYLEN];
	CK_ULONG	modulus_bytes;

	flag = template_attribute_find(key_obj->template, CKA_MODULUS, &attr);
	if (flag == FALSE) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	} else
		modulus_bytes = attr->ulValueLen;

	rc = rsa_format_block(in_data, in_data_len, data, modulus_bytes, PKCS_BT_1);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_RSA_FORM_BLOCK);
		return rc;
	}

	/* signing is a private key operation --> decrypt  */
	rc = os_specific_rsa_decrypt(data, modulus_bytes, sig, key_obj);
	if (rc == CKR_OK) {
		memcpy( out_data, sig, modulus_bytes );
		*out_data_len = modulus_bytes;
	} else
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
	return rc;
}

CK_RV
token_specific_rsa_verify (CK_BYTE *in_data, CK_ULONG in_data_len,
			CK_BYTE *signature, CK_ULONG sig_len, OBJECT *key_obj)
{
	CK_RV		rc;
        CK_BYTE		out[MAX_RSA_KEYLEN], out_data[MAX_RSA_KEYLEN];
	CK_BBOOL	flag;
	CK_ATTRIBUTE	*attr = NULL;
	CK_ULONG	modulus_bytes, out_data_len;

	out_data_len = MAX_RSA_KEYLEN;
	flag = template_attribute_find(key_obj->template, CKA_MODULUS, &attr);
	if (flag == FALSE) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	} else
		modulus_bytes = attr->ulValueLen;

	rc = os_specific_rsa_encrypt(signature, modulus_bytes, out, key_obj);
	if (rc == CKR_OK) {
		rc = rsa_parse_block(out, modulus_bytes, out_data, &out_data_len, PKCS_BT_1);
		if (rc == CKR_OK) {
			if (in_data_len != out_data_len) {
				OCK_LOG_ERR(ERR_SIGNATURE_INVALID);
				return CKR_SIGNATURE_INVALID;
			}

			if (memcmp(in_data, out_data, out_data_len) != 0) {
				OCK_LOG_ERR(ERR_SIGNATURE_INVALID);
				return CKR_SIGNATURE_INVALID;
			}
		} else if (rc == CKR_ENCRYPTED_DATA_INVALID ) {
                        OCK_LOG_ERR(ERR_SIGNATURE_INVALID);
                        return CKR_SIGNATURE_INVALID;
		} else {
			OCK_LOG_ERR(ERR_FUNCTION_FAILED);
			return CKR_FUNCTION_FAILED;
		}
	} else
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);

	return rc;
}

CK_RV
token_specific_rsa_verify_recover(CK_BYTE *signature, CK_ULONG sig_len,
			CK_BYTE *out_data, CK_ULONG *out_data_len,
			OBJECT *key_obj)
{
	CK_RV		rc;
	CK_BYTE		out[MAX_RSA_KEYLEN];
	CK_BBOOL	flag;
	CK_ATTRIBUTE	*attr = NULL;
	CK_ULONG	modulus_bytes;

	flag = template_attribute_find(key_obj->template, CKA_MODULUS, &attr);
	if (flag == FALSE) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	} else
		modulus_bytes = attr->ulValueLen;

	rc = os_specific_rsa_encrypt(signature, modulus_bytes, out, key_obj);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return rc;
	}

	rc = rsa_parse_block(out, modulus_bytes, out_data, out_data_len, PKCS_BT_1);
	if (rc == CKR_ENCRYPTED_DATA_INVALID ) {
		OCK_LOG_ERR(ERR_SIGNATURE_INVALID);
		return CKR_SIGNATURE_INVALID;
	} else if (rc != CKR_OK)
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);

	return rc;
}

CK_RV
token_specific_rsa_x509_encrypt(CK_BYTE *in_data, CK_ULONG in_data_len,
				CK_BYTE *out_data, CK_ULONG *out_data_len,
				OBJECT *key_obj)
{
	CK_RV		rc;
	CK_BYTE		clear[MAX_RSA_KEYLEN], cipher[MAX_RSA_KEYLEN];
	CK_BBOOL	flag;
	CK_ATTRIBUTE	*attr = NULL;
	CK_ULONG	modulus_bytes;

	flag = template_attribute_find(key_obj->template, CKA_MODULUS, &attr);
	if (flag == FALSE) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	} else
		modulus_bytes = attr->ulValueLen;

	// prepad with zeros
	//
	memset(clear, 0x0, modulus_bytes - in_data_len);
	memcpy(&clear[modulus_bytes - in_data_len], in_data, in_data_len);

	rc = os_specific_rsa_encrypt(clear, modulus_bytes, cipher, key_obj);
	if (rc == CKR_OK) {
		memcpy(out_data, cipher, modulus_bytes);
		*out_data_len = modulus_bytes;
	} else
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);

	return rc;
}

CK_RV
token_specific_rsa_x509_decrypt(CK_BYTE *in_data, CK_ULONG in_data_len,
				CK_BYTE *out_data, CK_ULONG *out_data_len,
				OBJECT *key_obj)
{
	CK_RV		rc;
	CK_BYTE		out[MAX_RSA_KEYLEN];
	CK_BBOOL	flag;
	CK_ATTRIBUTE	*attr = NULL;
	CK_ULONG	modulus_bytes;

	flag = template_attribute_find(key_obj->template, CKA_MODULUS, &attr);
	if (flag == FALSE) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	} else
		modulus_bytes = attr->ulValueLen;

	rc = os_specific_rsa_decrypt(in_data, modulus_bytes, out, key_obj);
	if (rc == CKR_OK) {
		memcpy(out_data, out, modulus_bytes);
		*out_data_len = modulus_bytes;
	} else
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);

	return rc;
}

CK_RV
token_specific_rsa_x509_sign(CK_BYTE *in_data, CK_ULONG in_data_len,
			CK_BYTE *out_data, CK_ULONG *out_data_len,
			OBJECT *key_obj)
{
	CK_RV		rc;
	CK_BYTE		data[MAX_RSA_KEYLEN], sig[MAX_RSA_KEYLEN];
	CK_BBOOL	flag;
	CK_ATTRIBUTE	*attr = NULL;
	CK_ULONG	modulus_bytes;

	flag = template_attribute_find(key_obj->template, CKA_MODULUS, &attr);
	if (flag == FALSE) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	} else
		modulus_bytes = attr->ulValueLen;

	// prepad with zeros
	//
	memset(data, 0x0, modulus_bytes - in_data_len);
	memcpy(&data[modulus_bytes - in_data_len], in_data, in_data_len);

	rc = os_specific_rsa_decrypt(data, modulus_bytes, sig ,key_obj);
	if (rc == CKR_OK) {
		memcpy(out_data, sig, modulus_bytes);
		*out_data_len = modulus_bytes;
	} else
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
	return rc;
}


CK_RV
token_specific_rsa_x509_verify(CK_BYTE *in_data, CK_ULONG in_data_len,
				CK_BYTE *signature, CK_ULONG sig_len,
				OBJECT *key_obj)
{
	CK_RV		rc;
	CK_BYTE		out[MAX_RSA_KEYLEN];
	CK_BBOOL	flag;
	CK_ATTRIBUTE	*attr = NULL;
	CK_ULONG	modulus_bytes;

	flag = template_attribute_find(key_obj->template, CKA_MODULUS, &attr);
	if (flag == FALSE) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	} else
		modulus_bytes = attr->ulValueLen;

	rc = os_specific_rsa_encrypt(signature, modulus_bytes, out ,key_obj);
	if (rc == CKR_OK) {
		CK_ULONG pos1, pos2, len;

		// it should be noted that in_data_len is not necessarily
		// the same as the modulus length
		//
		for (pos1=0; pos1 < in_data_len; pos1++)
			if (in_data[pos1] != 0)
				break;

		for (pos2=0; pos2 < modulus_bytes; pos2++)
			if (out[pos2] != 0)

		// at this point, pos1 and pos2 point to the first non-zero
		// bytes in the input data and the decrypted signature
		// (the recovered data), respectively.
		//

		if ((in_data_len - pos1) != (modulus_bytes - pos2)) {
			OCK_LOG_ERR(ERR_SIGNATURE_INVALID);
			return CKR_SIGNATURE_INVALID;
		}
		len = in_data_len - pos1;

		if (memcmp(&in_data[pos1], &out[pos2], len) != 0) {
			OCK_LOG_ERR(ERR_SIGNATURE_INVALID);
			return CKR_SIGNATURE_INVALID;
		}
		return CKR_OK;
	} else
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);

	return rc;
}


CK_RV
token_specific_rsa_x509_verify_recover(CK_BYTE *signature, CK_ULONG sig_len,
			CK_BYTE *out_data, CK_ULONG *out_data_len,
			OBJECT *key_obj)
{
	CK_RV		rc;
	CK_BYTE		out[MAX_RSA_KEYLEN];
	CK_BBOOL	flag;
	CK_ATTRIBUTE	*attr = NULL;
	CK_ULONG	modulus_bytes;

	flag = template_attribute_find(key_obj->template, CKA_MODULUS, &attr);
	if (flag == FALSE) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	} else
		modulus_bytes = attr->ulValueLen;

	rc = os_specific_rsa_encrypt(signature, modulus_bytes, out, key_obj);
	if (rc == CKR_OK) {
		memcpy(out_data, out, modulus_bytes);
		*out_data_len = modulus_bytes;
	} else
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);

	return rc;
}

CK_RV token_specific_rsa_oaep_encrypt(ENCR_DECR_CONTEXT *ctx, CK_BYTE *in_data,
				      CK_ULONG in_data_len, CK_BYTE *out_data,
				      CK_ULONG *out_data_len, CK_BYTE *hash,
				      CK_ULONG hlen)
{
	CK_RV rc;
	CK_BYTE cipher[MAX_RSA_KEYLEN];
	CK_ULONG modulus_bytes;
	CK_BBOOL flag;
	CK_ATTRIBUTE *attr = NULL;
	CK_BYTE *em_data = NULL;
	OBJECT *key_obj = NULL;
	CK_RSA_PKCS_OAEP_PARAMS_PTR oaepParms = NULL;

	if (!in_data || !out_data || !hash) {
		OCK_LOG_ERR(ERR_ARGUMENTS_BAD);
		return CKR_ARGUMENTS_BAD;
	}

	oaepParms = (CK_RSA_PKCS_OAEP_PARAMS_PTR)ctx->mech.pParameter;
	
	rc = object_mgr_find_in_map1(ctx->key, &key_obj);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_OBJMGR_FIND_MAP);
		return rc;
	}

	flag = template_attribute_find(key_obj->template, CKA_MODULUS, &attr);
	if (flag == FALSE) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	} else
		modulus_bytes = attr->ulValueLen;

	/* pkcs1v2.2, section 7.1.1 Step 2:
	 * EME-OAEP encoding.
	 */
	em_data = (CK_BYTE *)malloc(modulus_bytes);
	if (em_data == NULL) {
		OCK_LOG_ERR(ERR_HOST_MEMORY);
		return CKR_HOST_MEMORY;
	}

	rc = encode_eme_oaep(in_data, in_data_len, em_data, modulus_bytes,
			     oaepParms->mgf, hash, hlen);
        if (rc != CKR_OK)
		goto done;

        rc = os_specific_rsa_encrypt(em_data, modulus_bytes, cipher, key_obj);
        if (rc == CKR_OK) {
                memcpy(out_data, cipher, modulus_bytes);
                *out_data_len = modulus_bytes;
        } else
                OCK_LOG_ERR(ERR_FUNCTION_FAILED);

done:
	if (em_data)
		free(em_data);
        return rc;
}

CK_RV token_specific_rsa_oaep_decrypt(ENCR_DECR_CONTEXT *ctx, CK_BYTE *in_data,
				      CK_ULONG in_data_len, CK_BYTE *out_data,
				      CK_ULONG *out_data_len, CK_BYTE *hash,
				      CK_ULONG hlen)
{
	CK_RV rc;
	CK_BYTE *decr_data = NULL;
	OBJECT *key_obj = NULL;
	CK_BBOOL flag;
	CK_ATTRIBUTE *attr = NULL;
	CK_RSA_PKCS_OAEP_PARAMS_PTR oaepParms = NULL;

	if (!in_data || !out_data || !hash) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	}

	oaepParms = (CK_RSA_PKCS_OAEP_PARAMS_PTR)ctx->mech.pParameter;

	rc = object_mgr_find_in_map1(ctx->key, &key_obj);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_OBJMGR_FIND_MAP);
		return rc;
	}

	flag = template_attribute_find(key_obj->template, CKA_MODULUS, &attr);
	if (flag == FALSE) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	} else
		*out_data_len = attr->ulValueLen;

	decr_data = (CK_BYTE *)malloc(in_data_len);
	if (decr_data == NULL) {
		OCK_LOG_ERR(ERR_HOST_MEMORY);
		return CKR_HOST_MEMORY;
	}

	rc = os_specific_rsa_decrypt(in_data, in_data_len, decr_data, key_obj);
	if (rc != CKR_OK)
		return rc;

	/* pkcs1v2.2, section 7.1.2 Step 2:
	 * EME-OAEP decoding.
	 */
	rc = decode_eme_oaep(decr_data, in_data_len, out_data, out_data_len,
				oaepParms->mgf, hash, hlen);

	if (decr_data)
		free(decr_data);
	return rc;
}

CK_RV token_specific_rsa_pss_sign(SIGN_VERIFY_CONTEXT *ctx, CK_BYTE *in_data,
				  CK_ULONG in_data_len, CK_BYTE *sig,
				  CK_ULONG *sig_len)
{
	CK_RV rc;
	CK_ULONG modbytes;
	CK_BBOOL flag;
	CK_ATTRIBUTE *attr = NULL;
	OBJECT *key_obj = NULL;
	CK_BYTE *emdata = NULL;
	CK_RSA_PKCS_PSS_PARAMS *pssParms = NULL;

	/* check the arguments */
	if (!in_data || !sig) {
		OCK_LOG_ERR(ERR_ARGUMENTS_BAD);
		return CKR_ARGUMENTS_BAD;
	}

	if (!ctx) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	}

	pssParms = (CK_RSA_PKCS_PSS_PARAMS *)ctx->mech.pParameter;

	/* get the key */
	rc = object_mgr_find_in_map1(ctx->key, &key_obj);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_OBJMGR_FIND_MAP);
		return rc;
	}

        flag = template_attribute_find(key_obj->template, CKA_MODULUS, &attr);
        if (flag == FALSE) {
                OCK_LOG_ERR(ERR_FUNCTION_FAILED);
                return CKR_FUNCTION_FAILED;
        } else
                modbytes = attr->ulValueLen;

	emdata = (CK_BYTE *)malloc(modbytes);
	if (emdata == NULL) {
		OCK_LOG_ERR(ERR_HOST_MEMORY);
		return CKR_HOST_MEMORY;
	}

	rc = emsa_pss_encode(pssParms, in_data, in_data_len, emdata, &modbytes);
	if (rc != CKR_OK)
		goto done;

	/* signing is a private key operation --> decrypt  */
	rc = os_specific_rsa_decrypt(emdata, modbytes, sig, key_obj);
	if (rc == CKR_OK)
		*sig_len = modbytes;
	else
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);

done:
	if (emdata)
		free(emdata);
	return rc;
}


CK_RV token_specific_rsa_pss_verify(SIGN_VERIFY_CONTEXT *ctx, CK_BYTE *in_data,
                                    CK_ULONG in_data_len, CK_BYTE *signature,
				    CK_ULONG sig_len)
{
	CK_RV rc;
	CK_ULONG modbytes;
	OBJECT *key_obj = NULL;
	CK_BBOOL flag;
	CK_ATTRIBUTE *attr = NULL;
	CK_BYTE out[MAX_RSA_KEYLEN];
	CK_RSA_PKCS_PSS_PARAMS *pssParms = NULL;

	/* check the arguments */
	if (!in_data || !signature) {
		OCK_LOG_ERR(ERR_ARGUMENTS_BAD);
		return CKR_ARGUMENTS_BAD;
	}

	if (!ctx) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	}

	pssParms = (CK_RSA_PKCS_PSS_PARAMS *)ctx->mech.pParameter;

	/* get the key */
	rc = object_mgr_find_in_map1(ctx->key, &key_obj);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_OBJMGR_FIND_MAP);
		return rc;
	}

	/* verify is a public key operation ... encrypt */
	rc = os_specific_rsa_encrypt(signature, sig_len, out, key_obj);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return rc;
	}

	flag = template_attribute_find(key_obj->template, CKA_MODULUS, &attr);
	if (flag == FALSE) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	} else
		modbytes = attr->ulValueLen;

	/* call the pss verify scheme */
	rc = emsa_pss_verify(pssParms, in_data, in_data_len, out, modbytes);
	return rc;
}

#ifndef NOAES

CK_RV
token_specific_aes_key_gen(CK_BYTE *key, CK_ULONG len, CK_ULONG keysize)
{
        return rng_generate(key, len);
}

CK_RV
token_specific_aes_ecb(CK_BYTE *in_data, CK_ULONG in_data_len,
		       CK_BYTE *out_data, CK_ULONG *out_data_len,
		       OBJECT *key, CK_BYTE encrypt)
{
	int rc = CKR_OK;
	CK_ATTRIBUTE *attr = NULL;

   /* 
    * checks for input and output data length and block sizes
    * are already being carried out in mech_aes.c
    * so we skip those
    */
	// get the key value
	rc = template_attribute_find(key->template, CKA_VALUE, &attr);
	if (rc == FALSE) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	}

        if (encrypt) {
        rc = ica_aes_encrypt(MODE_AES_ECB, (unsigned int) in_data_len,
                             in_data, NULL, (unsigned  int) attr->ulValueLen,
                             attr->pValue, out_data);
        } else {
        rc = ica_aes_decrypt(MODE_AES_ECB, (unsigned int) in_data_len,
                             in_data, NULL, (unsigned int) attr->ulValueLen,
                             attr->pValue, out_data);
        }
	if (rc != 0) {
        (*out_data_len) = 0;
		rc = CKR_FUNCTION_FAILED;
	} else {
		(*out_data_len) = in_data_len;
		rc = CKR_OK;
	}
        return rc;
}

CK_RV
token_specific_aes_cbc(CK_BYTE         *in_data,
		       CK_ULONG        in_data_len,
		       CK_BYTE         *out_data,
		       CK_ULONG        *out_data_len,
		       OBJECT          *key,
		       CK_BYTE         *init_v,
		       CK_BYTE         encrypt)
{
	CK_RV rc;
	CK_ATTRIBUTE *attr = NULL;

   /* 
    * checks for input and output data length and block sizes
    * are already being carried out in mech_aes.c
    * so we skip those
    */

	// get the key value
	if (template_attribute_find(key->template, CKA_VALUE, &attr) == FALSE) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	}

	if (encrypt) {
        rc = ica_aes_encrypt(MODE_AES_CBC, (unsigned int) in_data_len,
                             in_data, (ica_aes_vector_t *) init_v,
                             (unsigned int) attr->ulValueLen, attr->pValue,
                             out_data);
	} else {
        rc = ica_aes_decrypt(MODE_AES_CBC, (unsigned int) in_data_len,
                             in_data, (ica_aes_vector_t *) init_v,
                             (unsigned int) attr->ulValueLen, attr->pValue,
                             out_data);
	}
	if (rc != 0) {
        (*out_data_len) = 0;
		rc = CKR_FUNCTION_FAILED;
	} else {
		(*out_data_len) = in_data_len;
		rc = CKR_OK;
	}
	return rc;
}
CK_RV
token_specific_aes_ctr(CK_BYTE          *in_data,
		       CK_ULONG		 in_data_len,
		       CK_BYTE 		*out_data,
		       CK_ULONG		*out_data_len,
		       OBJECT		*key,
		       CK_BYTE          *counterblock,
		       CK_ULONG          counter_width,
		       CK_BYTE 		 encrypt)
{
   CK_RV rc;
   CK_ATTRIBUTE *attr = NULL;

   /*
    * checks for input and output data length and block sizes
    * are already being carried out in mech_aes.c
    * so we skip those
    */
  /* in libica for AES-Counter Mode if uses one function for both encrypt and decrypt
   * so they use variable direction to know if the data is to be encrypted or decrypted
   * 0 -- Decrypt
   * 1 -- Encrypt
   */

   // get the key value
   if (template_attribute_find(key->template, CKA_VALUE, &attr) == FALSE) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      return CKR_FUNCTION_FAILED;
   }

   if (encrypt){
      rc = ica_aes_ctr( in_data, out_data, (unsigned int) in_data_len,
                        attr->pValue, (unsigned int) attr->ulValueLen,
                        counterblock, (unsigned int ) counter_width,
		        1);
   }
   else{
      rc = ica_aes_ctr( in_data, out_data, (unsigned int) in_data_len,
                        attr->pValue, (unsigned int) attr->ulValueLen,
                        counterblock, (unsigned int ) counter_width,
                        0);
   }
   if( rc != 0){
     (*out_data_len) = 0;
     rc = CKR_FUNCTION_FAILED;
   }
   else
   {
     (*out_data_len) = in_data_len;
     rc = CKR_OK;
   }
   return rc;
}

/**
 * In libica for AES-OFB Mode it uses one function for both encrypt and decrypt
 * The variable direction is used as an indicator either for encrypt or decrypt
 * 0 -- Decrypt
 * 1 -- Encrypt
 */
CK_RV
token_specific_aes_ofb(CK_BYTE *in_data, CK_ULONG in_data_len,
		       CK_BYTE *out_data, OBJECT *key, CK_BYTE *init_v,
                       uint_32 direction)
{
   CK_RV rc;
   CK_ATTRIBUTE *attr = NULL;

   if (template_attribute_find(key->template, CKA_VALUE, &attr) == FALSE) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      return CKR_FUNCTION_FAILED;
   }

   rc = ica_aes_ofb(in_data, out_data, (unsigned long) in_data_len,
                    attr->pValue, (unsigned int) attr->ulValueLen,
		    init_v, direction);

   if (rc != 0) {
         OCK_LOG_ERR(ERR_FUNCTION_FAILED);
         rc = CKR_FUNCTION_FAILED;
   }
   return rc;
}

/**
 * In libica for AES-CFB Mode it uses one function for both encrypt and decrypt
 * The variable direction is used as an indicator either for encrypt or decrypt
 *  0 -- Decrypt
 *  1 -- Encrypt
 */
CK_RV
token_specific_aes_cfb(CK_BYTE *in_data, CK_ULONG in_data_len,
		       CK_BYTE *out_data, OBJECT *key, CK_BYTE *init_v,
                       uint_32 lcfb, uint_32 direction)
{
   CK_RV rc;
   CK_ATTRIBUTE *attr = NULL;

   if (template_attribute_find(key->template, CKA_VALUE, &attr) == FALSE) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      return CKR_FUNCTION_FAILED;
   }

   rc = ica_aes_cfb(in_data, out_data, (unsigned long) in_data_len,
                    attr->pValue, (unsigned int) attr->ulValueLen, init_v,
                    lcfb, direction);

   if (rc != 0) {
         OCK_LOG_ERR(ERR_FUNCTION_FAILED);
         rc = CKR_FUNCTION_FAILED;
   }
   return rc;
}

CK_RV
token_specific_aes_mac(CK_BYTE *message, CK_ULONG message_len, OBJECT *key,
                       CK_BYTE *mac)
{
   CK_RV rc;
   CK_ATTRIBUTE *attr = NULL;

   if (template_attribute_find(key->template, CKA_VALUE, &attr) == FALSE) {
      OCK_LOG_ERR(ERR_FUNCTION_FAILED);
      return CKR_FUNCTION_FAILED;
   }

   rc = ica_aes_cmac_intermediate(message, (unsigned long) message_len,
                   attr->pValue, (unsigned int) attr->ulValueLen, mac);

   if (rc != 0) {
         OCK_LOG_ERR(ERR_FUNCTION_FAILED);
         rc = CKR_FUNCTION_FAILED;
   }
   return rc;
}

#endif

#ifndef NODH 
// This computes DH shared secret, where:
//     Output: z is computed shared secret
//     Input:  y is other party's public key
//             x is private key
//             p is prime
// All length's are in number of bytes. All data comes in as Big Endian.
 
CK_RV
token_specific_dh_pkcs_derive( CK_BYTE   *z,
                               CK_ULONG  *z_len,
                               CK_BYTE   *y,
                               CK_ULONG  y_len,
                               CK_BYTE   *x,
                               CK_ULONG  x_len,
                               CK_BYTE   *p,
                               CK_ULONG  p_len)
{
     CK_RV  rc ;
     BIGNUM *bn_z, *bn_y, *bn_x, *bn_p ;
     BN_CTX *ctx;
 
     //  Create and Init the BIGNUM structures.
     bn_y = BN_new() ;
     bn_x = BN_new() ;
     bn_p = BN_new() ;
     bn_z = BN_new() ;

     if (bn_z == NULL || bn_p == NULL || bn_x == NULL || bn_y == NULL) {
	     if (bn_y) BN_free(bn_y);
	     if (bn_x) BN_free(bn_x);
	     if (bn_p) BN_free(bn_p);
	     if (bn_z) BN_free(bn_z);
	     OCK_LOG_ERR(ERR_HOST_MEMORY);
	     return CKR_HOST_MEMORY;
     }
     
     BN_init(bn_y) ;
     BN_init(bn_x) ;
     BN_init(bn_p) ;
 
     // Initialize context
     ctx=BN_CTX_new();
     if (ctx == NULL)
     {
        OCK_LOG_ERR(ERR_FUNCTION_FAILED);
        return CKR_FUNCTION_FAILED;
     }
 
     // Add data into these new BN structures
 
     BN_bin2bn((char *)y, y_len, bn_y);
     BN_bin2bn((char *)x, x_len, bn_x);
     BN_bin2bn((char *)p, p_len, bn_p);
 
     rc = BN_mod_exp(bn_z,bn_y,bn_x,bn_p,ctx);
     if (rc == 0)
     {
        BN_free(bn_z);
        BN_free(bn_y);
        BN_free(bn_x);
        BN_free(bn_p);
        BN_CTX_free(ctx);
 
        OCK_LOG_ERR(ERR_FUNCTION_FAILED);
        return CKR_FUNCTION_FAILED;
     }
 
     *z_len = BN_num_bytes(bn_z);
     BN_bn2bin(bn_z, z);
 
     BN_free(bn_z);
     BN_free(bn_y);
     BN_free(bn_x);
     BN_free(bn_p);
     BN_CTX_free(ctx);
 
     return CKR_OK;
 
} /* end token_specific_dh_pkcs_derive() */
 
// This computes DH key pair, where:
//     Output: priv_tmpl is generated private key
//             pub_tmpl is computed public key
//     Input:  pub_tmpl is public key (prime and generator)
// All length's are in number of bytes. All data comes in as Big Endian.

CK_RV
token_specific_dh_pkcs_key_pair_gen( TEMPLATE  * publ_tmpl,
                                     TEMPLATE  * priv_tmpl )
{
    CK_BBOOL           rc;
    CK_ATTRIBUTE       *prime_attr = NULL;
    CK_ATTRIBUTE       *base_attr = NULL;
    CK_ATTRIBUTE       *temp_attr = NULL ;
    CK_ATTRIBUTE       *value_bits_attr = NULL;
    CK_BYTE            *temp_byte;
    CK_ULONG           temp_bn_len ;
 
    DH                 *dh ;
    BIGNUM             *bn_p ;
    BIGNUM             *bn_g ;
    BIGNUM             *temp_bn ;
 
    rc  = template_attribute_find( publ_tmpl, CKA_PRIME, &prime_attr );
    rc &= template_attribute_find( publ_tmpl, CKA_BASE, &base_attr );
 
    if (rc == FALSE) {
        OCK_LOG_ERR(ERR_FUNCTION_FAILED);
        return CKR_FUNCTION_FAILED;
    }
 
    if ((prime_attr->ulValueLen > 256) || (prime_attr->ulValueLen < 64))
    {
        OCK_LOG_ERR(ERR_FUNCTION_FAILED);
        return CKR_FUNCTION_FAILED;
    }
 
    dh = DH_new() ;
    if (dh == NULL)
    {
        OCK_LOG_ERR(ERR_FUNCTION_FAILED);
        return CKR_FUNCTION_FAILED;
    }

    // Create and init BIGNUM structs to stick in the DH struct
    bn_p = BN_new();
    bn_g = BN_new();
    if (bn_g == NULL || bn_p == NULL) {
	if (bn_g) BN_free(bn_g);
	if (bn_p) BN_free(bn_p);
	OCK_LOG_ERR(ERR_HOST_MEMORY);
	return CKR_HOST_MEMORY;
    }
    BN_init(bn_p);
    BN_init(bn_g);
 
    // Convert from strings to BIGNUMs and stick them in the DH struct
    BN_bin2bn((char *)prime_attr->pValue, prime_attr->ulValueLen, bn_p);
    dh->p = bn_p;
    BN_bin2bn((char *)base_attr->pValue, base_attr->ulValueLen, bn_g);
    dh->g = bn_g;
 
    // Generate the DH Key
    if (!DH_generate_key(dh))
    {
        OCK_LOG_ERR(ERR_FUNCTION_FAILED);
        return CKR_FUNCTION_FAILED;
    }
 
    // Extract the public and private key components from the DH struct,
    // and insert them in the publ_tmpl and priv_tmpl
 
    //
    // pub_key
    //
    //temp_bn = BN_new();
    temp_bn = dh->pub_key;
    temp_bn_len = BN_num_bytes(temp_bn);
    temp_byte = malloc(temp_bn_len);
    temp_bn_len = BN_bn2bin(temp_bn, temp_byte);
    rc = build_attribute( CKA_VALUE, temp_byte, temp_bn_len, &temp_attr ); // in bytes
    if (rc != CKR_OK)
    {
        OCK_LOG_ERR(ERR_FUNCTION_FAILED);
        return CKR_FUNCTION_FAILED;
    }
    template_update_attribute( publ_tmpl, temp_attr );
    free(temp_byte);

    //
    // priv_key
    //
    //temp_bn = BN_new();
    temp_bn = dh->priv_key;
    temp_bn_len = BN_num_bytes(temp_bn);
    temp_byte = malloc(temp_bn_len);
    temp_bn_len = BN_bn2bin(temp_bn, temp_byte);
    rc = build_attribute( CKA_VALUE, temp_byte, temp_bn_len, &temp_attr ); // in bytes
    if (rc != CKR_OK)
    {
        OCK_LOG_ERR(ERR_FUNCTION_FAILED);
        return CKR_FUNCTION_FAILED;
    }
    template_update_attribute( priv_tmpl, temp_attr );
    free(temp_byte);
 
    // Update CKA_VALUE_BITS attribute in the private key
    value_bits_attr = (CK_ATTRIBUTE *)malloc( sizeof(CK_ATTRIBUTE) + sizeof(CK_ULONG) );
    value_bits_attr->type       = CKA_VALUE_BITS;
    value_bits_attr->ulValueLen = sizeof(CK_ULONG);
    value_bits_attr->pValue     = (CK_BYTE *)value_bits_attr + sizeof(CK_ATTRIBUTE);
    *(CK_ULONG *)value_bits_attr->pValue = 8*temp_bn_len;
    template_update_attribute( priv_tmpl, value_bits_attr );
 
    // Add prime and base to the private key template
    rc = build_attribute( CKA_PRIME,(char *)prime_attr->pValue,
                          prime_attr->ulValueLen, &temp_attr ); // in bytes
    if (rc != CKR_OK)
    {
        OCK_LOG_ERR(ERR_FUNCTION_FAILED);
        return CKR_FUNCTION_FAILED;
    }
    template_update_attribute( priv_tmpl, temp_attr );
 
    rc = build_attribute( CKA_BASE,(char *)base_attr->pValue,
                          base_attr->ulValueLen, &temp_attr ); // in bytes
    if (rc != CKR_OK)
    {
        OCK_LOG_ERR(ERR_FUNCTION_FAILED);
        return CKR_FUNCTION_FAILED;
    }
    template_update_attribute( priv_tmpl, temp_attr );

    // Cleanup DH key
    DH_free(dh) ;
 
    return CKR_OK ;
 
} /* end token_specific_dh_key_pair_gen() */

#endif /* #ifndef NODH */

REF_MECH_LIST_ELEMENT ref_mech_list[] = {

	{92, CKM_RSA_PKCS_KEY_PAIR_GEN, 512, 4096, CKF_HW|
						   CKF_GENERATE_KEY_PAIR },
#if !(NODSA)
//	{1, CKM_DSA_KEY_PAIR_GEN, 512, 1024, CKF_HW|CKF_GENERATE_KEY_PAIR},
#endif
#if !(NOCDMF)
//	{4, CKM_CDMF_KEY_GEN, 0, 0, CKF_HW|CKF_GENERATE},
#endif
	{80, CKM_DES_KEY_GEN, 8, 8, CKF_HW|CKF_GENERATE},

	{80, CKM_DES3_KEY_GEN, 24, 24, CKF_HW|CKF_GENERATE},

	{90, CKM_RSA_PKCS, 512, 4096, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
                                      CKF_WRAP|CKF_UNWRAP|CKF_SIGN|CKF_VERIFY|
                                      CKF_SIGN_RECOVER|CKF_VERIFY_RECOVER},

#if !(NOX509)
	{90, CKM_RSA_X_509, 512, 4096, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
                                       CKF_WRAP|CKF_UNWRAP|CKF_SIGN|CKF_VERIFY|
                                       CKF_SIGN_RECOVER|CKF_VERIFY_RECOVER},
#endif
	{90, CKM_RSA_PKCS_OAEP, 512, 4096, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
					   CKF_WRAP|CKF_UNWRAP},

	{90, CKM_RSA_PKCS_PSS, 512, 4096, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{107, CKM_MD2_RSA_PKCS, 512, 4096, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{108, CKM_MD5_RSA_PKCS, 512, 4096, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{190, CKM_SHA1_RSA_PKCS, 512, 4096, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{190, CKM_SHA256_RSA_PKCS, 512, 4096, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{190, CKM_SHA384_RSA_PKCS, 512, 4096, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{190, CKM_SHA512_RSA_PKCS, 512, 4096, CKF_HW|CKF_SIGN|CKF_VERIFY},

#if !(NODH)
//	{9, CKM_DH_PKCS_DERIVE, 512, 2048, CKF_HW|CKF_DERIVE},

//	{10, CKM_DH_PKCS_KEY_PAIR_GEN, 512, 2048, CKF_HW|CKF_GENERATE_KEY_PAIR},
#endif

	{20, CKM_DES_ECB, 8, 8, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
				CKF_WRAP|CKF_UNWRAP},

	{21, CKM_DES_CBC, 8, 8, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
				CKF_WRAP|CKF_UNWRAP},

	{21, CKM_DES_CBC_PAD, 8, 8, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
				    CKF_WRAP|CKF_UNWRAP},

//	{28, CKM_DES_MAC, 8, 8, CKF_HW|CKF_SIGN|CKF_VERIFY},

//	{28, CKM_DES_MAC_GENERAL, 8, 8, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{41, CKM_DES3_ECB, 24, 24, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
				   CKF_WRAP|CKF_UNWRAP},

	{42, CKM_DES3_CBC, 24, 24, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
				   CKF_WRAP|CKF_UNWRAP},

	{42, CKM_DES3_CBC_PAD, 24, 24, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
				       CKF_WRAP|CKF_UNWRAP},

	{49, CKM_DES3_MAC, 24, 24, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{49, CKM_DES3_MAC_GENERAL, 24, 24, CKF_HW|CKF_SIGN|CKF_VERIFY},

//	{23, CKM_DES_OFB8, 8, 8, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT},

	{24, CKM_DES_CFB8, 8, 8, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT},

	{44, CKM_DES_OFB64, 8, 8, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT},

	{45, CKM_DES_CFB64, 8, 8, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT},

	{01, CKM_SHA_1, 0, 0, CKF_HW|CKF_DIGEST},

	{01, CKM_SHA_1_HMAC, 0, 0, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{01, CKM_SHA_1_HMAC_GENERAL, 0, 0, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{03, CKM_SHA256, 0, 0, CKF_HW|CKF_DIGEST},

	{03, CKM_SHA256_HMAC, 0, 0, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{03, CKM_SHA256_HMAC_GENERAL, 0, 0, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{04, CKM_SHA384, 0, 0, CKF_HW|CKF_DIGEST},

	{04, CKM_SHA384_HMAC, 0, 0, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{04, CKM_SHA384_HMAC_GENERAL, 0, 0, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{05, CKM_SHA512, 0, 0, CKF_HW|CKF_DIGEST},


	{05, CKM_SHA512_HMAC, 0, 0, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{05, CKM_SHA512_HMAC_GENERAL, 0, 0, CKF_HW|CKF_SIGN|CKF_VERIFY},

#if !(NOMD5)
	{53, CKM_MD5, 0, 0, CKF_HW|CKF_DIGEST},

	{54, CKM_MD5_HMAC, 0, 0, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{55, CKM_MD5_HMAC_GENERAL, 0, 0, CKF_HW|CKF_SIGN|CKF_VERIFY},
#endif
#if !(NOAES)
	{80, CKM_AES_KEY_GEN, 16, 32, CKF_HW|CKF_GENERATE},

	{60, CKM_AES_ECB, 16, 32, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
				  CKF_WRAP|CKF_UNWRAP},

	{61, CKM_AES_CBC, 16, 32, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
				  CKF_WRAP|CKF_UNWRAP},

	{61, CKM_AES_CBC_PAD, 16, 32, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
				      CKF_WRAP|CKF_UNWRAP},

	{63, CKM_AES_OFB, 16, 32, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
				  CKF_WRAP|CKF_UNWRAP},

	{64, CKM_AES_CFB8, 16, 32, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
				   CKF_WRAP|CKF_UNWRAP},

	{64, CKM_AES_CFB64, 16, 32, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
				    CKF_WRAP|CKF_UNWRAP},

	{64, CKM_AES_CFB128, 16, 32, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
				     CKF_WRAP|CKF_UNWRAP},

	{65, CKM_AES_CTR, 16, 32, CKF_HW|CKF_ENCRYPT|CKF_DECRYPT|
				  CKF_WRAP|CKF_UNWRAP},

	{68, CKM_AES_MAC, 16, 32, CKF_HW|CKF_SIGN|CKF_VERIFY},

	{68, CKM_AES_MAC_GENERAL, 16, 32, CKF_HW|CKF_SIGN|CKF_VERIFY},
#endif
};

CK_ULONG ref_mech_list_len = (sizeof(ref_mech_list) / sizeof(MECH_LIST_ELEMENT));

/**
 * new ica-token mechanism table
 * this list will be initialized the first time
 * when ica_get_functionlist (from libica) is called.
 * (preinitialized with software only supported mechanisms)
 */
MECH_LIST_ELEMENT mech_list[] = {
	{CKM_MD5, 0, 0, CKF_DIGEST},
	{CKM_MD5_HMAC, 0, 0, CKF_SIGN | CKF_VERIFY},
	{CKM_MD5_HMAC_GENERAL, 0, 0, CKF_SIGN | CKF_VERIFY},
	{0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0},
	{0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0},
	{0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0},
	{0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0},
	{0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0},
	{0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0},
	{0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0},
	{0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0},
	{0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0},
	{0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0},
	{0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0},
	{0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0} };

CK_ULONG mech_list_len = 3;

CK_RV
token_specific_get_mechanism_list(CK_MECHANISM_TYPE_PTR pMechanismList,
				  CK_ULONG_PTR pulCount)
{
	CK_ULONG rc = CKR_OK;

	rc = ica_specific_get_mechanism_list(pMechanismList, pulCount);
	if (rc != CKR_OK) {
		return CKR_FUNCTION_FAILED;
	}

	return rc;
}

CK_RV
ica_specific_get_mechanism_list(CK_MECHANISM_TYPE_PTR pMechanismList,
				CK_ULONG_PTR pulCount)
{
	unsigned int i;
	CK_ULONG rc = CKR_OK;

	if (pulCount == NULL) {
		return CKR_ARGUMENTS_BAD;
	}

	if (!mech_list_ica_init) {
		rc = mech_list_ica_initialize();
		if (rc != CKR_OK) {
			OCK_LOG_ERR(ERR_FUNCTION_FAILED);
			return CKR_FUNCTION_FAILED;
		}
	}

	if (pMechanismList == NULL) {
		*pulCount = mech_list_len;
		return CKR_OK;
	}

	if ((*pulCount) < mech_list_len) {
		(*pulCount) = mech_list_len;
		OCK_LOG_ERR(ERR_BUFFER_TOO_SMALL);
		return CKR_BUFFER_TOO_SMALL;
	}

	/* copy mechanisms from the internal mech_ica_list */
	for (i=0; i < mech_list_len; i++) {
		pMechanismList[i] = mech_list[i].mech_type;
	}
	(*pulCount) = mech_list_len;

	return CKR_OK;
}

CK_RV
token_specific_get_mechanism_info(CK_MECHANISM_TYPE type,
				  CK_MECHANISM_INFO_PTR pInfo)
{
	CK_ULONG rc = CKR_OK;

	rc = ica_specific_get_mechanism_info(type, pInfo);
	return rc;
}

CK_RV ica_specific_get_mechanism_info (CK_MECHANISM_TYPE type,
				       CK_MECHANISM_INFO_PTR pInfo)
{
	int rc = CKR_OK;
	unsigned int i;
	CK_MECHANISM_TYPE_PTR pMechanismList = NULL;
	CK_ULONG_PTR pulCount;

	if (!mech_list_ica_init) {
		rc = mech_list_ica_initialize();
		if (rc != CKR_OK) {
			OCK_LOG_ERR(ERR_FUNCTION_FAILED);
			return CKR_FUNCTION_FAILED;
		}
	}

	/*
	 * find the requested mechanism and grab additional
	 * mechanism specific information (mech_info) from mech_list_ica
	 */
	for (i=0; i < mech_list_len; i++) {
		if (mech_list[i].mech_type == type) {
			pInfo->flags = mech_list[i].mech_info.flags;
			pInfo->ulMinKeySize = mech_list[i].mech_info.ulMinKeySize;
			pInfo->ulMaxKeySize = mech_list[i].mech_info.ulMaxKeySize;
			return CKR_OK;
		}
	}

	OCK_LOG_ERR(ERR_MECHANISM_INVALID);
	return CKR_MECHANISM_INVALID;
}

CK_RV
getRefListIdxfromId(CK_ULONG ica_idx, CK_ULONG_PTR pRefIdx)
{
	unsigned int n;

	for (n=*pRefIdx; n < ref_mech_list_len; n++) {
		if (ica_idx == ref_mech_list[n].lica_idx) {
			*pRefIdx =  n;
			return CKR_OK;
		}
	}
	return CKR_MECHANISM_INVALID;
}

CK_RV
getRefListIdxfromMech(CK_ULONG mech, CK_ULONG_PTR pRefIdx)
{
	unsigned int n;

	for (n=*pRefIdx; n < ref_mech_list_len; n++) {
		if (mech == ref_mech_list[n].mech_type) {
			*pRefIdx =  n;
			return CKR_OK;
		}
	}
	return CKR_MECHANISM_INVALID;
}

CK_BBOOL
isMechanismAvailable(CK_ULONG mechanism)
{
	unsigned int i;

	for (i = 0; i < mech_list_len; i++) {
		if (mech_list[i].mech_type == mechanism)
			return TRUE;
	}
	return FALSE;
}

CK_RV
addMechanismToList(CK_ULONG mechanism)
{
	CK_ULONG ret;
	CK_ULONG refIdx = 0;

	ret = getRefListIdxfromMech(mechanism, &refIdx);
	if (ret != CKR_OK) {
		return CKR_FUNCTION_FAILED;
	}
	mech_list[mech_list_len].mech_type  = ref_mech_list[refIdx].mech_type;
	mech_list[mech_list_len].mech_info.flags = (ref_mech_list[refIdx].mech_info.flags & 0xfffffffe);
	mech_list[mech_list_len].mech_info.ulMinKeySize = ref_mech_list[refIdx].mech_info.ulMinKeySize;
	mech_list[mech_list_len].mech_info.ulMaxKeySize = ref_mech_list[refIdx].mech_info.ulMaxKeySize;
	mech_list_len++;

	return CKR_OK;
}

/*
 * call libica to receive list of supported mechanisms
 * This method is called once per opencryptoki instance (application context)
 */
CK_RV
mech_list_ica_initialize(void)
{
	CK_ULONG ret, rc = CKR_OK;
	unsigned int i, n;
	unsigned int ica_specific_mech_list_len;
	CK_ULONG tmp, ulActMechCtr, ulPreDefMechCtr, refIdx;

	rc = ica_get_functionlist(NULL, &ica_specific_mech_list_len);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	}
	libica_func_list_element libica_func_list[ica_specific_mech_list_len];
	rc = ica_get_functionlist(libica_func_list, &ica_specific_mech_list_len);
	if (rc != CKR_OK) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	}

	/*
	 * grab the mechanism of the corresponding ID returned by libICA
	 * from the internel reference list put the mechanism ID and the
	 * HW support indication into an internel ica_mech_list and get
	 * additional flag information from the reference list
	 */
	ulPreDefMechCtr = mech_list_len;
	for (i=0; i < ica_specific_mech_list_len; i++) {
		// loop over libica supported list
		ulActMechCtr = -1;

		/* --- walk through the whole reflist and fetch all
		 * matching mechanism's (if present) ---
		 */
		refIdx = 0;
		while (refIdx >= 0) {
			ret = getRefListIdxfromId(libica_func_list[i].mech_mode_id, &refIdx);
			if (ret != CKR_OK) {
				// continue with the next libica mechanism
				break;
			}

			/* Loop over the predefined mechanism list and check
			 * if we have to overrule a software implemented
			 * mechanism from token by libica HW supported
			 * mechanism.
			 */
			for (n=0; n < ulPreDefMechCtr; n++) {
				if (mech_list[n].mech_type == ref_mech_list[refIdx].mech_type){
					ulActMechCtr = n;
					break;
				}
			}
			if (ulActMechCtr == -1) {
				/* add a new entry */
				mech_list[mech_list_len].mech_type  = ref_mech_list[refIdx].mech_type;
				mech_list[mech_list_len].mech_info.flags = (libica_func_list[i].flags & 0x01) | (ref_mech_list[refIdx].mech_info.flags & 0xfffffffe);
				mech_list[mech_list_len].mech_info.ulMinKeySize = ref_mech_list[refIdx].mech_info.ulMinKeySize;
				mech_list[mech_list_len].mech_info.ulMaxKeySize = ref_mech_list[refIdx].mech_info.ulMaxKeySize;
				mech_list_len++;
			} else {
				/* replace existing entry */
				mech_list[ulActMechCtr].mech_info.flags = (libica_func_list[i].flags & 0x01) | mech_list[ulActMechCtr].mech_info.flags ;
			}
			refIdx++;
		}
	}

	/*
	 * check if special combined mechanisms are supported
	 * if SHA1 and RSA is available   -> insert CKM_SHA1_RSA_PKCS
	 * if SHA256 and RSA is available -> insert CKM_SHA256_RSA_PKCS
	 * if MD2 and RSA is available    -> insert CKM_MD2_RSA_PKCS
	 * if MD5 and RSA is available    -> insert CKM_MD5_RSA_PKCS
	 */
	if (isMechanismAvailable(CKM_SHA_1) && isMechanismAvailable(CKM_RSA_PKCS))
		addMechanismToList(CKM_SHA1_RSA_PKCS);
	if (isMechanismAvailable(CKM_SHA256) && isMechanismAvailable(CKM_RSA_PKCS))
		addMechanismToList(CKM_SHA256_RSA_PKCS);
	if (isMechanismAvailable(CKM_SHA384) && isMechanismAvailable(CKM_RSA_PKCS))
		addMechanismToList(CKM_SHA384_RSA_PKCS);
	if (isMechanismAvailable(CKM_SHA512) && isMechanismAvailable(CKM_RSA_PKCS))
		addMechanismToList(CKM_SHA512_RSA_PKCS);
	if (isMechanismAvailable(CKM_MD2) && isMechanismAvailable(CKM_RSA_PKCS))
		addMechanismToList(CKM_MD2_RSA_PKCS);
	if (isMechanismAvailable(CKM_MD5) && isMechanismAvailable(CKM_RSA_PKCS))
		addMechanismToList(CKM_MD5_RSA_PKCS);

	/* sort the mech_list_ica by mechanism ID's (bubble sort)  */
	for(i=0;i < mech_list_len ; i++) {
		for (n=i; n < mech_list_len; n++) {
			if (mech_list[i].mech_type > mech_list[n].mech_type) {
				tmp = mech_list[i].mech_type;
				mech_list[i].mech_type = mech_list[n].mech_type;
				mech_list[n].mech_type = tmp;

				tmp = mech_list[i].mech_info.ulMinKeySize;
				mech_list[i].mech_info.ulMinKeySize = mech_list[n].mech_info.ulMinKeySize;
				mech_list[n].mech_info.ulMinKeySize = tmp;

				tmp = mech_list[i].mech_info.ulMaxKeySize;
				mech_list[i].mech_info.ulMaxKeySize = mech_list[n].mech_info.ulMaxKeySize;
				mech_list[n].mech_info.ulMaxKeySize = tmp;

				tmp = mech_list[i].mech_info.flags;
				mech_list[i].mech_info.flags = mech_list[n].mech_info.flags;
				mech_list[n].mech_info.flags = tmp;
			}
		}
	}
	mech_list_ica_init = TRUE;
	return rc;
}
