/*
 * $Header: /cvsroot/opencryptoki/opencryptoki/usr/lib/pkcs11/common/h_extern.h,v 1.10 2007/12/05 22:52:01 mhalcrow Exp $
 */


/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001,2002          */

/***************************************************************************
                          Change Log
                          ==========
       4/25/03    Kapil Sood (kapil@corrent.com)
                  Added DH key pair generation and DH shared key derivation
                  functions.
 
 
 
****************************************************************************/


#ifndef _H_EXTERN_H
#define _H_EXTERN_H

#include <stdio.h>
#include "msg.h"

#if (LEEDS_BUILD)
#pragma options align=packed
#endif



extern char * pk_dir;
// global variables
//
extern CK_BBOOL  initialized;
extern char *card_function_names[];
extern char *total_function_names[];

extern MECH_LIST_ELEMENT  mech_list[];
extern CK_ULONG           mech_list_len;

extern pthread_mutex_t  native_mutex;

extern MUTEX    pkcs_mutex, obj_list_mutex, sess_list_mutex, login_mutex;

extern struct btree sess_btree;
extern struct btree sess_obj_btree;
extern struct btree priv_token_obj_btree;
extern struct btree publ_token_obj_btree;
extern struct btree object_map_btree;

extern CK_BYTE master_key[MAX_KEY_SIZE];

extern CK_BYTE so_pin_md5[MD5_HASH_SIZE];
extern CK_BYTE user_pin_md5[MD5_HASH_SIZE];

extern CK_BYTE default_user_pin_sha[SHA1_HASH_SIZE];
extern CK_BYTE default_so_pin_sha[SHA1_HASH_SIZE];
extern CK_BYTE default_so_pin_md5[MD5_HASH_SIZE];

extern LW_SHM_TYPE *global_shm;

extern TOKEN_DATA        *nv_token_data;
extern CK_SLOT_INFO       slot_info;

// extern CK_ULONG next_object_handle;
// extern CK_ULONG next_session_handle;

extern CK_ULONG  ro_session_count;

extern CK_STATE  global_login_state;


extern CK_BYTE            ber_AlgIdRSAEncryption[];
extern CK_ULONG           ber_AlgIdRSAEncryptionLen;
extern CK_BYTE            ber_rsaEncryption[];
extern CK_ULONG           ber_rsaEncryptionLen;
extern CK_BYTE            ber_idDSA[];
extern CK_ULONG           ber_idDSALen;

extern CK_BYTE   ber_md2WithRSAEncryption[];
extern CK_ULONG  ber_md2WithRSAEncryptionLen;
extern CK_BYTE   ber_md4WithRSAEncryption[];
extern CK_ULONG  ber_md4WithRSAEncryptionLen;
extern CK_BYTE   ber_md5WithRSAEncryption[];
extern CK_ULONG  ber_md5WithRSAEncryptionLen;
extern CK_BYTE   ber_sha1WithRSAEncryption[];
extern CK_ULONG  ber_sha1WithRSAEncryptionLen;
extern CK_BYTE   ber_AlgMd2[];
extern CK_ULONG  ber_AlgMd2Len;
extern CK_BYTE   ber_AlgMd5[];
extern CK_ULONG  ber_AlgMd5Len;
extern CK_BYTE   ber_AlgSha1[];
extern CK_ULONG  ber_AlgSha1Len;
extern CK_BYTE   ber_AlgSha256[];
extern CK_ULONG  ber_AlgSha256Len;
extern CK_BYTE   ber_AlgSha384[];
extern CK_ULONG  ber_AlgSha384Len;
extern CK_BYTE   ber_AlgSha512[];
extern CK_ULONG  ber_AlgSha512Len;

extern CK_ULONG           des_weak_count;
extern CK_ULONG           des_semi_weak_count;
extern CK_ULONG           des_possibly_weak_count;
extern CK_BYTE            des_weak_keys[4][8];
extern CK_BYTE            des_semi_weak_keys[12][8];
extern CK_BYTE            des_possibly_weak_keys[48][8];

extern struct ST_FCN_LIST   function_list;

extern CK_C_INITIALIZE_ARGS cinit_args;

CK_ULONG long_reverse( CK_ULONG x );


// VACPP C runtime initialization/cleanup entry points
//
int  _CRT_init(void);
int  _CRT_term(void);


CK_RV DummyFunction( CK_SLOT_ID   slot_id, int arg );

// General-purpose functions
//
CK_RV C_Initialize          ( CK_VOID_PTR              pInitArgs           );
CK_RV C_Finalize            ( CK_VOID_PTR              pReserved           );
CK_RV C_GetInfo             ( CK_INFO_PTR              pInfo               );
CK_RV C_GetFunctionList     ( CK_FUNCTION_LIST_PTR_PTR ppFunctionList      );

// Slot and token management functions
//
CK_RV C_GetSlotList         ( CK_BBOOL                 tokenPresent,
                              CK_SLOT_ID_PTR           pSlotList,
                              CK_ULONG_PTR             pulCount            );

CK_RV C_GetSlotInfo         ( CK_SLOT_ID               slotID,
                              CK_SLOT_INFO_PTR         pInfo               );

CK_RV C_GetTokenInfo        ( CK_SLOT_ID               slotID,
                              CK_TOKEN_INFO_PTR        pInfo               );

CK_RV C_WaitForSlotEvent    ( CK_FLAGS                 flags,
                              CK_SLOT_ID_PTR           pSlot,
                              CK_VOID_PTR              pReserved           );

CK_RV C_GetMechanismList    ( CK_SLOT_ID               slotID,
                              CK_MECHANISM_TYPE_PTR    pMechanismList,
                              CK_ULONG_PTR             pulCount            );

CK_RV C_GetMechanismInfo    ( CK_SLOT_ID               slotID,
                              CK_MECHANISM_TYPE        type,
                              CK_MECHANISM_INFO_PTR    pInfo               );

CK_RV C_InitToken           ( CK_SLOT_ID               slotID,
                              CK_CHAR_PTR              pPin,
                              CK_ULONG                 ulPinLen,
                              CK_CHAR_PTR              pLabel              );

CK_RV C_InitPIN             ( CK_SESSION_HANDLE        hSession,
                              CK_CHAR_PTR              pPin,
                              CK_ULONG                 ulPinLen            );

CK_RV C_SetPIN              ( CK_SESSION_HANDLE        hSession,
                              CK_CHAR_PTR              pOldPin,
                              CK_ULONG                 ulOldLen,
                              CK_CHAR_PTR              pNewPin,
                              CK_ULONG                 ulNewLen            );

// Session management functions
//
CK_RV C_OpenSession         ( CK_SLOT_ID               slotID,
                              CK_FLAGS                 flags,
                              CK_VOID_PTR              pApplication,
                              CK_NOTIFY                Notify,
                              CK_SESSION_HANDLE_PTR    phSession            );

CK_RV C_CloseSession        ( CK_SESSION_HANDLE        hSession             );

CK_RV C_CloseAllSessions    ( CK_SLOT_ID               slotID               );

CK_RV C_GetSessionInfo      ( CK_SESSION_HANDLE        hSession,
                              CK_SESSION_INFO_PTR      pInfo                );

CK_RV C_GetOperationState   ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pOperationState,
                              CK_ULONG_PTR             pulOperationStateLen );

CK_RV C_SetOperationState   ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pOperationState,
                              CK_ULONG                 ulOperationStateLen,
                              CK_OBJECT_HANDLE         hEncryptionKey,
                              CK_OBJECT_HANDLE         hAuthenticationKey   );

CK_RV C_Login               ( CK_SESSION_HANDLE        hSession,
                              CK_USER_TYPE             userType,
                              CK_CHAR_PTR              pPin,
                              CK_ULONG                 uPinLen              );

CK_RV C_Logout              ( CK_SESSION_HANDLE        hSession             );


// Object management functions
//
CK_RV C_CreateObject        ( CK_SESSION_HANDLE        hSession,
                              CK_ATTRIBUTE_PTR         pTemplate,
                              CK_ULONG                 ulCount,
                              CK_OBJECT_HANDLE_PTR     phObject             );

CK_RV C_CopyObject          ( CK_SESSION_HANDLE        hSession,
                              CK_OBJECT_HANDLE         hObject,
                              CK_ATTRIBUTE_PTR         pTemplate,
                              CK_ULONG                 ulCount,
                              CK_OBJECT_HANDLE_PTR     phNewObject          );

CK_RV C_DestroyObject       ( CK_SESSION_HANDLE        hSession,
                              CK_OBJECT_HANDLE         hObject              );

CK_RV C_GetObjectSize       ( CK_SESSION_HANDLE        hSession,
                              CK_OBJECT_HANDLE         hObject,
                              CK_ULONG_PTR             pulSize              );

CK_RV C_GetAttributeValue   ( CK_SESSION_HANDLE        hSession,
                              CK_OBJECT_HANDLE         hObject,
                              CK_ATTRIBUTE_PTR         pTemplate,
                              CK_ULONG                 ulCount              );

CK_RV C_SetAttributeValue   ( CK_SESSION_HANDLE        hSession,
                              CK_OBJECT_HANDLE         hObject,
                              CK_ATTRIBUTE_PTR         pTemplate,
                              CK_ULONG                 ulCount              );

CK_RV C_FindObjectsInit     ( CK_SESSION_HANDLE        hSession,
                              CK_ATTRIBUTE_PTR         pTemplate,
                              CK_ULONG                 ulCount              );

CK_RV C_FindObjects         ( CK_SESSION_HANDLE        hSession,
                              CK_OBJECT_HANDLE_PTR     phObject,
                              CK_ULONG                 ulMaxObjectCount,
                              CK_ULONG_PTR             pulObjectCount       );

CK_RV C_FindObjectsFinal    ( CK_SESSION_HANDLE        hSession             );


// Encryption functions
//
CK_RV C_EncryptInit         ( CK_SESSION_HANDLE        hSession,
                              CK_MECHANISM_PTR         pMechanism,
                              CK_OBJECT_HANDLE         hKey                 );

CK_RV C_Encrypt             ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pData,
                              CK_ULONG                 ulDataLen,
                              CK_BYTE_PTR              pEncryptedData,
                              CK_ULONG_PTR             pulEncryptedDataLen  );

CK_RV C_EncryptUpdate       ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pPart,
                              CK_ULONG                 ulPartLen,
                              CK_BYTE_PTR              pEncryptedPart,
                              CK_ULONG_PTR             pulEncryptedPartLen  );

CK_RV C_EncryptFinal        ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pLastEncryptedPart,
                              CK_ULONG_PTR             pulLastEncryptedPartLen);


// Decryption functions
//
CK_RV C_DecryptInit         ( CK_SESSION_HANDLE        hSession,
                              CK_MECHANISM_PTR         pMechanism,
                              CK_OBJECT_HANDLE         hKey                 );

CK_RV C_Decrypt             ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pEncryptedData,
                              CK_ULONG                 ulEncryptedDataLen,
                              CK_BYTE_PTR              pData,
                              CK_ULONG_PTR             pulDataLen           );

CK_RV C_DecryptUpdate       ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pEncryptedPart,
                              CK_ULONG                 ulEncryptedPartLen,
                              CK_BYTE_PTR              pPart,
                              CK_ULONG_PTR             pulPartLen           );

CK_RV C_DecryptFinal        ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pLastPart,
                              CK_ULONG_PTR             pulLastPartLen       );


// Message digesting functions
//
CK_RV C_DigestInit          ( CK_SESSION_HANDLE        hSession,
                              CK_MECHANISM_PTR         pMechanism           );

CK_RV C_Digest              ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pData,
                              CK_ULONG                 ulDataLen,
                              CK_BYTE_PTR              pDigest,
                              CK_ULONG_PTR             pulDigestLen         );

CK_RV C_DigestUpdate        ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pPart,
                              CK_ULONG                 ulPartLen            );

CK_RV C_DigestKey           ( CK_SESSION_HANDLE        hSession,
                              CK_OBJECT_HANDLE         hKey                 );

CK_RV C_DigestFinal         ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pDigest,
                              CK_ULONG_PTR             pulDigestLen         );


// Signing and MAC functions
//
CK_RV C_SignInit            ( CK_SESSION_HANDLE        hSession,
                              CK_MECHANISM_PTR         pMechanism,
                              CK_OBJECT_HANDLE         hKey                 );

CK_RV C_Sign                ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pData,
                              CK_ULONG                 ulDataLen,
                              CK_BYTE_PTR              pSignature,
                              CK_ULONG_PTR             pulSignatureLen      );

CK_RV C_SignUpdate          ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pPart,
                              CK_ULONG                 ulPartLen            );

CK_RV C_SignFinal           ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pSignature,
                              CK_ULONG_PTR             pulSignatureLen      );

CK_RV C_SignRecoverInit     ( CK_SESSION_HANDLE        hSession,
                              CK_MECHANISM_PTR         pMechanism,
                              CK_OBJECT_HANDLE         hKey                 );

CK_RV C_SignRecover         ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pData,
                              CK_ULONG                 ulDataLen,
                              CK_BYTE_PTR              pSignature,
                              CK_ULONG_PTR             pulSignatureLen      );


// Signature/MAC verification functions
//
CK_RV C_VerifyInit          ( CK_SESSION_HANDLE        hSession,
                              CK_MECHANISM_PTR         pMechanism,
                              CK_OBJECT_HANDLE         hKey                 );

CK_RV C_Verify              ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pData,
                              CK_ULONG                 ulDataLen,
                              CK_BYTE_PTR              pSignature,
                              CK_ULONG                 ulSignatureLen      );

CK_RV C_VerifyUpdate        ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pPart,
                              CK_ULONG                 ulPartLen            );

CK_RV C_VerifyFinal         ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pSignature,
                              CK_ULONG                 ulSignatureLen       );

CK_RV C_VerifyRecoverInit   ( CK_SESSION_HANDLE        hSession,
                              CK_MECHANISM_PTR         pMechanism,
                              CK_OBJECT_HANDLE         hKey                 );

CK_RV C_VerifyRecover       ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pSignature,
                              CK_ULONG                 ulSignatureLen,
                              CK_BYTE_PTR              pData,
                              CK_ULONG_PTR             pulDataLen           );


// Dual-function cryptographics functions
//
CK_RV C_DigestEncryptUpdate ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pPart,
                              CK_ULONG                 ulPartLen,
                              CK_BYTE_PTR              pEncryptedPart,
                              CK_ULONG_PTR             pulEncryptedPartLen  );

CK_RV C_DecryptDigestUpdate ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pEncryptedPart,
                              CK_ULONG                 ulEncryptedPartLen,
                              CK_BYTE_PTR              pPart,
                              CK_ULONG_PTR             pulPartLen           );

CK_RV C_SignEncryptUpdate   ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pPart,
                              CK_ULONG                 ulPartLen,
                              CK_BYTE_PTR              pEncryptedPart,
                              CK_ULONG_PTR             pulEncryptedPartLen  );

CK_RV C_DecryptVerifyUpdate ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pEncryptedPart,
                              CK_ULONG                 ulEncryptedPartLen,
                              CK_BYTE_PTR              pPart,
                              CK_ULONG_PTR             pulPartLen           );


// Key management functions
//
CK_RV C_GenerateKey         ( CK_SESSION_HANDLE        hSession,
                              CK_MECHANISM_PTR         pMechanism,
                              CK_ATTRIBUTE_PTR         pTemplate,
                              CK_ULONG                 ulCount,
                              CK_OBJECT_HANDLE_PTR     phKey                );

CK_RV C_GenerateKeyPair     ( CK_SESSION_HANDLE        hSession,
                              CK_MECHANISM_PTR         pMechanism,
                              CK_ATTRIBUTE_PTR         pPublicKeyTemplate,
                              CK_ULONG                 ulPublicKeyAttributeCount,
                              CK_ATTRIBUTE_PTR         pPrivateKeyTemplate,
                              CK_ULONG                 ulPrivateKeyAttributeCount,
                              CK_OBJECT_HANDLE_PTR     phPublicKey,
                              CK_OBJECT_HANDLE_PTR     phPrivateKey         );

CK_RV C_WrapKey             ( CK_SESSION_HANDLE        hSession,
                              CK_MECHANISM_PTR         pMechanism,
                              CK_OBJECT_HANDLE         hWrappingKey,
                              CK_OBJECT_HANDLE         hKey,
                              CK_BYTE_PTR              pWrappedKey,
                              CK_ULONG_PTR             pulWrappedKeyLen     );

CK_RV C_UnwrapKey           ( CK_SESSION_HANDLE        hSession,
                              CK_MECHANISM_PTR         pMechanism,
                              CK_OBJECT_HANDLE         hUnwrappingKey,
                              CK_BYTE_PTR              pWrappedKey,
                              CK_ULONG                 ulWrappedKeyLen,
                              CK_ATTRIBUTE_PTR         pTemplate,
                              CK_ULONG                 ulAttributeCount,
                              CK_OBJECT_HANDLE_PTR     phKey                );

CK_RV C_DeriveKey           ( CK_SESSION_HANDLE        hSession,
                              CK_MECHANISM_PTR         pMechanism,
                              CK_OBJECT_HANDLE         hBaseKey,
                              CK_ATTRIBUTE_PTR         pTemplate,
                              CK_ULONG                 ulAttributeCount,
                              CK_OBJECT_HANDLE_PTR     phKey                );


// Random number generation functions
//
CK_RV C_SeedRandom          ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pSeed,
                              CK_ULONG                 ulSeedLen            );

CK_RV C_GenerateRandom      ( CK_SESSION_HANDLE        hSession,
                              CK_BYTE_PTR              pRandomData,
                              CK_ULONG                 ulRandomLen          );

// Parallel function management functions
//
CK_RV C_GetFunctionStatus   ( CK_SESSION_HANDLE        hSession             );

CK_RV C_CancelFunction      ( CK_SESSION_HANDLE        hSession             );


//
// internal routines are below this point
//
CK_RV clock_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV clock_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV clock_validate_attribute( TEMPLATE *tmpl, 
				CK_ATTRIBUTE *attr, 
				CK_ULONG mode);

CK_RV counter_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV counter_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV counter_validate_attribute( TEMPLATE *tmpl, 
				  CK_ATTRIBUTE *attr, 
				  CK_ULONG mode);

CK_RV dp_dsa_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode);
CK_RV dp_dsa_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV dp_dsa_validate_attribute( TEMPLATE *tmpl, 
				 CK_ATTRIBUTE *attr, 
				 CK_ULONG mode);

CK_RV dp_dh_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode);
CK_RV dp_dh_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV dp_dh_validate_attribute( TEMPLATE *tmpl, 
				CK_ATTRIBUTE *attr, 
				CK_ULONG mode);

CK_RV dp_x9dh_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode);
CK_RV dp_x9dh_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV dp_x9dh_validate_attribute( TEMPLATE *tmpl, 
				  CK_ATTRIBUTE *attr, 
				  CK_ULONG mode);

CK_RV communicate( CK_ULONG cmd_id,
                   CK_VOID_PTR pReq,   CK_ULONG     req_len,
                   CK_VOID_PTR pRep,   CK_ULONG_PTR repl_len,
                   CK_BYTE_PTR pOut,   CK_ULONG     out_len,
                   CK_BYTE_PTR pIn,    CK_ULONG     in_len );

CK_RV compute_next_token_obj_name( CK_BYTE *current, CK_BYTE *next );

CK_RV save_token_object        ( OBJECT *obj );
CK_RV save_public_token_object ( OBJECT *obj );
CK_RV save_private_token_object( OBJECT *obj );

CK_RV load_public_token_objects ( void );
CK_RV load_private_token_objects( void );

CK_RV reload_token_object( OBJECT *obj );

CK_RV restore_private_token_object( CK_BYTE  * data,
                                    CK_ULONG   len,
                                    OBJECT   * pObj );

CK_RV delete_token_object( OBJECT *ptr );
CK_RV delete_token_data();

CK_BYTE *get_pk_dir(char *);

CK_RV init_token_data(CK_SLOT_ID);
CK_RV load_token_data(CK_SLOT_ID);
CK_RV save_token_data(CK_SLOT_ID);

CK_RV load_masterkey_so  ( void );
CK_RV load_masterkey_user( void );
CK_RV save_masterkey_so  ( void );
CK_RV save_masterkey_user( void );

CK_RV generate_master_key(CK_BYTE *key);

CK_RV compute_md5( CK_BYTE *data, CK_ULONG len, CK_BYTE *hash );
CK_RV compute_sha( CK_BYTE *data, CK_ULONG len, CK_BYTE *hash );

CK_ULONG long_reverse( CK_ULONG x );

//CK_RV load_FCV( void );
//CK_RV save_FCV( FUNCTION_CTRL_VEC_RECORD *new_FCV );

//CK_RV update_tweak_values( void *attributes, CK_ULONG count );
//CK_RV query_tweak_values( CK_ATTRIBUTE_TYPE  * attributes,
//                          CK_ULONG             count,
//                          CK_BYTE           ** reply,
//                          CK_ULONG           * reply_len );

void  init_slotInfo(void);
void  init_tokenInfo(void);

CK_BYTE  parity_adjust( CK_BYTE b );
CK_RV    parity_is_odd( CK_BYTE b );

CK_RV build_attribute( CK_ATTRIBUTE_TYPE  type,
                       CK_BYTE           *data,
                       CK_ULONG           data_len,
                       CK_ATTRIBUTE       **attr );

CK_RV
find_bbool_attribute(CK_ATTRIBUTE *attrs, CK_ULONG attrs_len,
		     CK_ATTRIBUTE_TYPE type, CK_BBOOL *value);

CK_RV    add_pkcs_padding( CK_BYTE   * ptr,       // where to start appending
                           CK_ULONG    block_size,
                           CK_ULONG    data_len,
                           CK_ULONG    total_len );

CK_RV    strip_pkcs_padding( CK_BYTE  * ptr,
                             CK_ULONG   total_len,
                             CK_ULONG * data_len );


// RNG routines
//
CK_RV  rng_generate( CK_BYTE *output, CK_ULONG bytes );


// SSL3 routines
//
CK_RV  ssl3_mac_sign( SESSION *sess,  CK_BBOOL length_only,
                      SIGN_VERIFY_CONTEXT * ctx,
                      CK_BYTE             * in_data,
                      CK_ULONG              in_data_len,
                      CK_BYTE             * out_data,
                      CK_ULONG            * out_data_len );

CK_RV  ssl3_mac_sign_update( SESSION             * sess,
                             SIGN_VERIFY_CONTEXT * ctx,
                             CK_BYTE             * in_data,
                             CK_ULONG              in_data_len );

CK_RV  ssl3_mac_sign_final( SESSION *sess,  CK_BBOOL length_only,
                            SIGN_VERIFY_CONTEXT * ctx,
                            CK_BYTE             * out_data,
                            CK_ULONG            * out_data_len );

CK_RV  ssl3_mac_verify( SESSION             * sess,
                        SIGN_VERIFY_CONTEXT * ctx,
                        CK_BYTE             * in_data,
                        CK_ULONG              in_data_len,
                        CK_BYTE             * signature,
                        CK_ULONG              sig_len );

CK_RV  ssl3_mac_verify_update( SESSION             * sess,
                               SIGN_VERIFY_CONTEXT * ctx,
                               CK_BYTE             * in_data,
                               CK_ULONG              in_data_len );

CK_RV  ssl3_mac_verify_final( SESSION             * sess,
                              SIGN_VERIFY_CONTEXT * ctx,
                              CK_BYTE             * signature,
                              CK_ULONG              sig_len );

CK_RV  ssl3_master_key_derive( SESSION          * sess,
                               CK_MECHANISM     * mech,
                               CK_OBJECT_HANDLE   base_key,
                               CK_ATTRIBUTE     * attributes,
                               CK_ULONG           count,
                               CK_OBJECT_HANDLE * handle );

CK_RV  ssl3_key_and_mac_derive( SESSION          * sess,
                                CK_MECHANISM     * mech,
                                CK_OBJECT_HANDLE   base_key,
                                CK_ATTRIBUTE     * attributes,
                                CK_ULONG           count );

CK_RV  ckm_ssl3_pre_master_key_gen( TEMPLATE *tmpl, CK_MECHANISM *mech );


// RSA routines
//
CK_RV  rsa_pkcs_encrypt( SESSION           * sess,
                         CK_BBOOL            length_only,
                         ENCR_DECR_CONTEXT * ctx,
                         CK_BYTE           * in_data,
                         CK_ULONG            in_data_len,
                         CK_BYTE           * out_data,
                         CK_ULONG          * out_data_len );

CK_RV  rsa_pkcs_decrypt( SESSION           * sess,
                         CK_BBOOL            length_only,
                         ENCR_DECR_CONTEXT * ctx,
                         CK_BYTE           * in_data,
                         CK_ULONG            in_data_len,
                         CK_BYTE           * out_data,
                         CK_ULONG          * out_data_len );

CK_RV  rsa_pkcs_sign   ( SESSION             * sess,
                         CK_BBOOL              length_only,
                         SIGN_VERIFY_CONTEXT * ctx,
                         CK_BYTE             * in_data,
                         CK_ULONG              in_data_len,
                         CK_BYTE             * signature,
                         CK_ULONG            * sig_len );

CK_RV  rsa_pkcs_verify ( SESSION             * sess,
                         SIGN_VERIFY_CONTEXT * ctx,
                         CK_BYTE             * in_data,
                         CK_ULONG              in_data_len,
                         CK_BYTE             * signature,
                         CK_ULONG              sig_len );

CK_RV  rsa_pkcs_verify_recover ( SESSION             * sess,
                                 CK_BBOOL              length_only,
                                 SIGN_VERIFY_CONTEXT * ctx,
                                 CK_BYTE             * signature,
                                 CK_ULONG              sig_len,
                                 CK_BYTE             * out_data,
                                 CK_ULONG            * out_len );

CK_RV  rsa_x509_encrypt ( SESSION           * sess,
                          CK_BBOOL            length_only,
                          ENCR_DECR_CONTEXT * ctx,
                          CK_BYTE           * in_data,
                          CK_ULONG            in_data_len,
                          CK_BYTE           * out_data,
                          CK_ULONG          * out_data_len );

CK_RV  rsa_x509_decrypt ( SESSION           * sess,
                          CK_BBOOL            length_only,
                          ENCR_DECR_CONTEXT * ctx,
                          CK_BYTE           * in_data,
                          CK_ULONG            in_data_len,
                          CK_BYTE           * out_data,
                          CK_ULONG          * out_data_len );

CK_RV  rsa_x509_sign   ( SESSION             * sess,
                         CK_BBOOL              length_only,
                         SIGN_VERIFY_CONTEXT * ctx,
                         CK_BYTE             * in_data,
                         CK_ULONG              in_data_len,
                         CK_BYTE             * signature,
                         CK_ULONG            * sig_len );

CK_RV  rsa_x509_verify ( SESSION             * sess,
                         SIGN_VERIFY_CONTEXT * ctx,
                         CK_BYTE             * in_data,
                         CK_ULONG              in_data_len,
                         CK_BYTE             * signature,
                         CK_ULONG              sig_len );

CK_RV  rsa_x509_verify_recover( SESSION             * sess,
                                 CK_BBOOL              length_only,
                                 SIGN_VERIFY_CONTEXT * ctx,
                                 CK_BYTE             * signature,
                                 CK_ULONG              sig_len,
                                 CK_BYTE             * out_data,
                                 CK_ULONG            * out_len );

CK_RV  rsa_hash_pkcs_sign   ( SESSION             * sess,
                              CK_BBOOL              length_only,
                              SIGN_VERIFY_CONTEXT * ctx,
                              CK_BYTE             * in_data,
                              CK_ULONG              in_data_len,
                              CK_BYTE             * signature,
                              CK_ULONG            * sig_len );

CK_RV  rsa_hash_pkcs_verify ( SESSION             * sess,
                              SIGN_VERIFY_CONTEXT * ctx,
                              CK_BYTE             * in_data,
                              CK_ULONG              in_data_len,
                              CK_BYTE             * signature,
                              CK_ULONG              sig_len );

CK_RV  rsa_hash_pkcs_sign_update   ( SESSION             * sess,
                                     SIGN_VERIFY_CONTEXT * ctx,
                                     CK_BYTE             * in_data,
                                     CK_ULONG              in_data_len );

CK_RV  rsa_hash_pkcs_verify_update ( SESSION             * sess,
                                     SIGN_VERIFY_CONTEXT * ctx,
                                     CK_BYTE             * in_data,
                                     CK_ULONG              in_data_len );

CK_RV  rsa_hash_pkcs_sign_final   ( SESSION              * sess,
                                    CK_BBOOL               length_only,
                                    SIGN_VERIFY_CONTEXT  * ctx,
                                    CK_BYTE              * signature,
                                    CK_ULONG             * sig_len );

CK_RV  rsa_hash_pkcs_verify_final ( SESSION             * sess,
                                    SIGN_VERIFY_CONTEXT * ctx,
                                    CK_BYTE             * signature,
                                    CK_ULONG              sig_len );


// RSA mechanisms
//
CK_RV  ckm_rsa_key_pair_gen( TEMPLATE *publ_tmpl, TEMPLATE *priv_tmpl );

CK_RV  ckm_rsa_encrypt( CK_BYTE  * in_data,
                        CK_ULONG   in_data_len,
                        CK_BYTE  * out_data,
			CK_ULONG * out_data_len,
                        OBJECT   * key_obj );

CK_RV  ckm_rsa_decrypt( CK_BYTE  * in_data,
                        CK_ULONG   in_data_len,
                        CK_BYTE  * out_data,
                        CK_ULONG * out_data_len,
                        OBJECT   * key_obj );

CK_RV  ckm_rsa_compute_priv_exp( TEMPLATE *tmpl );

CK_RV  ckm_rsa_sign( CK_BYTE  * in_data,
                     CK_ULONG   in_data_len,
                     CK_BYTE  * out_data,
                     CK_ULONG * out_data_len,
                     OBJECT   * key_obj );

CK_RV  ckm_rsa_verify( CK_BYTE  * in_data,
                       CK_ULONG   in_data_len,
                       CK_BYTE  * out_data,
                       CK_ULONG   out_data_len,
                       OBJECT   * key_obj );

#ifndef NODSA
// DSA routines
//
CK_RV  dsa_sign   ( SESSION             * sess,
                    CK_BBOOL              length_only,
                    SIGN_VERIFY_CONTEXT * ctx,
                    CK_BYTE             * in_data,
                    CK_ULONG              in_data_len,
                    CK_BYTE             * signature,
                    CK_ULONG            * sig_len );

CK_RV  dsa_verify ( SESSION             * sess,
                    SIGN_VERIFY_CONTEXT * ctx,
                    CK_BYTE             * in_data,
                    CK_ULONG              in_data_len,
                    CK_BYTE             * signature,
                    CK_ULONG              sig_len );


// DSA mechanisms
//
CK_RV  ckm_dsa_key_pair_gen( TEMPLATE *publ_tmpl, TEMPLATE *priv_tmpl );

CK_RV  ckm_dsa_sign( CK_BYTE *in_data,      // must be 20 bytes
                     CK_BYTE *signature,    // must be 40 bytes
                     OBJECT  *priv_key );

CK_RV  ckm_dsa_verify( CK_BYTE *signature,  // must be 40 bytes
                       CK_BYTE *data,       // must be 20 bytes
                       OBJECT  *publ_key );

#endif
 
/* Begin code contributed by Corrent corp. */
// DH routines
//
#ifndef NODH
 
CK_RV
dh_pkcs_derive( SESSION           * sess,
                CK_MECHANISM      * mech,
                CK_OBJECT_HANDLE    base_key,
                CK_ATTRIBUTE      * pTemplate,
                CK_ULONG            ulCount,
                CK_OBJECT_HANDLE  * handle ) ;
 
// DH mechanisms
//
CK_RV
ckm_dh_pkcs_derive( CK_VOID_PTR        other_pubkey,
                    CK_ULONG           other_pubkey_len,
                    CK_OBJECT_HANDLE   base_key,
                    CK_BYTE            *secret,
                    CK_ULONG           *secret_len ) ;
 
CK_RV
ckm_dh_key_pair_gen( TEMPLATE *publ_tmpl,
                     TEMPLATE *priv_tmpl );
 
CK_RV
ckm_dh_pkcs_key_pair_gen( TEMPLATE  * publ_tmpl,
                          TEMPLATE  * priv_tmpl );
#endif
/* End code contributed by Corrent corp. */

// DES routines - I have to provide two different versions of these
//                because encryption routines are also used internally
//                so we can't assume that external-to-external buffering
//                will be possible and combining them into a single
//                function is messy.
//
CK_RV  pk_des_ecb_encrypt( SESSION  *sess,     CK_BBOOL  length_only,
                        ENCR_DECR_CONTEXT *context,
                        CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                        CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des_ecb_decrypt( SESSION  *sess,     CK_BBOOL  length_only,
                        ENCR_DECR_CONTEXT *context,
                        CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                        CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  pk_des_cbc_encrypt( SESSION  *sess,     CK_BBOOL  length_only,
                        ENCR_DECR_CONTEXT *context,
                        CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                        CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des_cbc_decrypt( SESSION  *sess,     CK_BBOOL  length_only,
                        ENCR_DECR_CONTEXT *context,
                        CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                        CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des_cbc_pad_encrypt( SESSION  *sess,     CK_BBOOL  length_only,
                            ENCR_DECR_CONTEXT *context,
                            CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                            CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des_cbc_pad_decrypt( SESSION  *sess,     CK_BBOOL  length_only,
                            ENCR_DECR_CONTEXT *context,
                            CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                            CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des_ecb_encrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                               ENCR_DECR_CONTEXT *context,
                               CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                               CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des_ecb_decrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                               ENCR_DECR_CONTEXT *context,
                               CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                               CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des_cbc_encrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                               ENCR_DECR_CONTEXT *context,
                               CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                               CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des_cbc_decrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                               ENCR_DECR_CONTEXT *context,
                               CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                               CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des_cbc_pad_encrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                                   ENCR_DECR_CONTEXT *context,
                                   CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                   CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des_cbc_pad_decrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                                   ENCR_DECR_CONTEXT *context,
                                   CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                   CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des_ecb_encrypt_final( SESSION *sess,      CK_BBOOL length_only,
                              ENCR_DECR_CONTEXT *context,
                              CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des_ecb_decrypt_final( SESSION *sess,      CK_BBOOL length_only,
                              ENCR_DECR_CONTEXT *context,
                              CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des_cbc_encrypt_final( SESSION *sess,      CK_BBOOL length_only,
                              ENCR_DECR_CONTEXT *context,
                              CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des_cbc_decrypt_final( SESSION *sess,      CK_BBOOL length_only,
                              ENCR_DECR_CONTEXT *context,
                              CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des_cbc_pad_encrypt_final( SESSION *sess,      CK_BBOOL length_only,
                                  ENCR_DECR_CONTEXT *context,
                                  CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des_cbc_pad_decrypt_final( SESSION *sess,      CK_BBOOL length_only,
                                  ENCR_DECR_CONTEXT *context,
                                  CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des_ecb_wrap_key( SESSION      *sess, CK_BBOOL  length_only,
                         CK_MECHANISM *mech,
                         OBJECT       *key,  OBJECT   *encr_key,
                         CK_BYTE      *data, CK_ULONG *data_len );


// DES mechanisms
//
CK_RV  ckm_des_key_gen ( TEMPLATE *tmpl );
CK_RV  ckm_cdmf_key_gen( TEMPLATE *tmpl );

CK_RV  ckm_des_ecb_encrypt( CK_BYTE *in_data,   CK_ULONG in_data_len,
                            CK_BYTE *out_data,  CK_ULONG *out_data_len,
                            OBJECT  *key );
CK_RV  ckm_des_ecb_decrypt( CK_BYTE *in_data,  CK_ULONG in_data_len,
                            CK_BYTE *out_data,  CK_ULONG *out_data_len,
                            OBJECT  *key );

CK_RV  ckm_des_cbc_encrypt( CK_BYTE *in_data,   CK_ULONG in_data_len,
                            CK_BYTE *out_data,  CK_ULONG *out_data_len,
                            CK_BYTE *init_v,
                            OBJECT  *key );
CK_RV  ckm_des_cbc_decrypt( CK_BYTE *in_data,   CK_ULONG in_data_len,
                            CK_BYTE *out_data,  CK_ULONG *out_data_len,
                            CK_BYTE *init_v,
                            OBJECT  *key );

CK_RV  ckm_des_wrap_format( CK_BBOOL length_only,
                            CK_BYTE  **data, CK_ULONG *data_len );


// DES3 routines
//
CK_RV  des3_ecb_encrypt( SESSION  *sess,     CK_BBOOL  length_only,
                         ENCR_DECR_CONTEXT *context,
                         CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                         CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des3_ecb_decrypt( SESSION  *sess,     CK_BBOOL  length_only,
                         ENCR_DECR_CONTEXT *context,
                         CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                         CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des3_cbc_encrypt( SESSION  *sess,     CK_BBOOL  length_only,
                         ENCR_DECR_CONTEXT *context,
                         CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                         CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des3_cbc_decrypt( SESSION  *sess,     CK_BBOOL  length_only,
                         ENCR_DECR_CONTEXT *context,
                         CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                         CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des3_cbc_pad_encrypt( SESSION  *sess,     CK_BBOOL  length_only,
                             ENCR_DECR_CONTEXT *context,
                             CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                             CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des3_cbc_pad_decrypt( SESSION  *sess,     CK_BBOOL  length_only,
                             ENCR_DECR_CONTEXT *context,
                             CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                             CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des3_ecb_encrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                                ENCR_DECR_CONTEXT *context,
                                CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des3_ecb_decrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                                ENCR_DECR_CONTEXT *context,
                                CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des3_cbc_encrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                                ENCR_DECR_CONTEXT *context,
                                CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des3_cbc_decrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                                ENCR_DECR_CONTEXT *context,
                                CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des3_cbc_pad_encrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                                    ENCR_DECR_CONTEXT *context,
                                    CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                    CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des3_cbc_pad_decrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                                    ENCR_DECR_CONTEXT *context,
                                    CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                    CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des3_ecb_encrypt_final( SESSION *sess,  CK_BBOOL length_only,
                               ENCR_DECR_CONTEXT *context,
                               CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des3_ecb_decrypt_final( SESSION *sess,  CK_BBOOL length_only,
                               ENCR_DECR_CONTEXT *context,
                               CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des3_cbc_encrypt_final( SESSION *sess,  CK_BBOOL length_only,
                               ENCR_DECR_CONTEXT *context,
                               CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des3_cbc_decrypt_final( SESSION *sess,  CK_BBOOL length_only,
                               ENCR_DECR_CONTEXT *context,
                               CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  des3_cbc_pad_encrypt_final( SESSION *sess,  CK_BBOOL length_only,
                                   ENCR_DECR_CONTEXT *context,
                                   CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  des3_cbc_pad_decrypt_final( SESSION *sess,  CK_BBOOL length_only,
                                   ENCR_DECR_CONTEXT *context,
                                   CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV des3_mac_sign( SESSION * sess, CK_BBOOL length_only,
                     SIGN_VERIFY_CONTEXT  * ctx,
                     CK_BYTE * in_data, CK_ULONG    in_data_len,
                     CK_BYTE * out_data, CK_ULONG * out_data_len);

CK_RV des3_mac_sign_update ( SESSION * sess,  SIGN_VERIFY_CONTEXT  * ctx,
                             CK_BYTE * in_data, CK_ULONG in_data_len );

CK_RV des3_mac_sign_final( SESSION * sess, CK_BBOOL length_only,
                           SIGN_VERIFY_CONTEXT  * ctx,
                           CK_BYTE * out_data, CK_ULONG * out_data_len);

CK_RV des3_mac_verify( SESSION * sess, SIGN_VERIFY_CONTEXT  * ctx,
                       CK_BYTE * in_data, CK_ULONG in_data_len,
                       CK_BYTE * out_data, CK_ULONG out_data_len);

CK_RV des3_mac_verify_update( SESSION * sess, SIGN_VERIFY_CONTEXT * ctx,
                              CK_BYTE * in_data, CK_ULONG in_data_len);

CK_RV des3_mac_verify_final( SESSION  * sess, SIGN_VERIFY_CONTEXT  * ctx,
                             CK_BYTE  * signature, CK_ULONG signature_len);

// DES3 mechanisms
//
CK_RV  ckm_des3_key_gen( TEMPLATE *tmpl );

CK_RV  ckm_des3_ecb_encrypt( CK_BYTE *in_data,   CK_ULONG    in_data_len,
                             CK_BYTE *out_data,  CK_ULONG   *out_data_len,
                             OBJECT *key );
CK_RV  ckm_des3_ecb_decrypt( CK_BYTE *in_data,   CK_ULONG    in_data_len,
                             CK_BYTE *out_data,  CK_ULONG   *out_data_len,
                             OBJECT *key );

CK_RV  ckm_des3_cbc_encrypt( CK_BYTE *in_data,   CK_ULONG    in_data_len,
                             CK_BYTE *out_data,  CK_ULONG   *out_data_len,
                             CK_BYTE *init_v,    OBJECT     *key );
CK_RV  ckm_des3_cbc_decrypt( CK_BYTE *in_data,   CK_ULONG    in_data_len,
                             CK_BYTE *out_data,  CK_ULONG   *out_data_len,
                             CK_BYTE *init_v,    OBJECT     *key );


// AES routines
//
CK_RV  aes_ecb_encrypt( SESSION  *sess,     CK_BBOOL  length_only,
                        ENCR_DECR_CONTEXT *context,
                        CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                        CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  aes_ecb_decrypt( SESSION  *sess,     CK_BBOOL  length_only,
                        ENCR_DECR_CONTEXT *context,
                        CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                        CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  aes_cbc_encrypt( SESSION  *sess,     CK_BBOOL  length_only,
                        ENCR_DECR_CONTEXT *context,
                        CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                        CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  aes_cbc_decrypt( SESSION  *sess,     CK_BBOOL  length_only,
                        ENCR_DECR_CONTEXT *context,
                        CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                        CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  aes_cbc_pad_encrypt( SESSION  *sess,     CK_BBOOL  length_only,
                            ENCR_DECR_CONTEXT *context,
                            CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                            CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  aes_cbc_pad_decrypt( SESSION  *sess,     CK_BBOOL  length_only,
                            ENCR_DECR_CONTEXT *context,
                            CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                            CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  aes_ctr_encrypt( SESSION  *sess,       CK_BBOOL length_only,
			ENCR_DECR_CONTEXT *context,
			CK_BYTE  *in_data,    CK_ULONG  in_data_len,
			CK_BYTE  *out_data,   CK_ULONG *out_data_len);

CK_RV  aes_ctr_decrypt( SESSION  *sess,       CK_BBOOL  length_only,
			ENCR_DECR_CONTEXT   *context,
			CK_BYTE  *in_data,    CK_ULONG  in_data_len,
			CK_BYTE  *out_data,   CK_ULONG *out_data_len);

CK_RV  aes_ecb_encrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                               ENCR_DECR_CONTEXT *context,
                               CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                               CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  aes_ecb_decrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                               ENCR_DECR_CONTEXT *context,
                               CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                               CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  aes_cbc_encrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                               ENCR_DECR_CONTEXT *context,
                               CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                               CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  aes_cbc_decrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                               ENCR_DECR_CONTEXT *context,
                               CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                               CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  aes_cbc_pad_encrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                                   ENCR_DECR_CONTEXT *context,
                                   CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                   CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  aes_cbc_pad_decrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                                   ENCR_DECR_CONTEXT *context,
                                   CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                   CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  aes_ctr_encrypt_update( SESSION *sess,    CK_BBOOL length_only,
			       ENCR_DECR_CONTEXT *context,
			       CK_BYTE *in_data, CK_ULONG in_data_len,
			       CK_BYTE *out_data,CK_ULONG *out_data_len );

CK_RV  aes_ctr_decrypt_update( SESSION *sess,    CK_BBOOL length_only,
			       ENCR_DECR_CONTEXT *context,
			       CK_BYTE *in_data, CK_ULONG in_data_len,
			       CK_BYTE *out_data,CK_ULONG *out_data_len );

CK_RV  aes_ecb_encrypt_final( SESSION *sess,  CK_BBOOL length_only,
                              ENCR_DECR_CONTEXT *context,
                              CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  aes_ecb_decrypt_final( SESSION *sess,  CK_BBOOL length_only,
                              ENCR_DECR_CONTEXT *context,
                              CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  aes_cbc_encrypt_final( SESSION *sess,  CK_BBOOL length_only,
                              ENCR_DECR_CONTEXT *context,
                              CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  aes_cbc_decrypt_final( SESSION *sess,  CK_BBOOL length_only,
                              ENCR_DECR_CONTEXT *context,
                              CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  aes_cbc_pad_encrypt_final( SESSION *sess,  CK_BBOOL length_only,
                                  ENCR_DECR_CONTEXT *context,
                                  CK_BYTE  *out_data, CK_ULONG *out_data_len );
CK_RV  aes_cbc_pad_decrypt_final( SESSION *sess,  CK_BBOOL length_only,
                                  ENCR_DECR_CONTEXT *context,
                                  CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  aes_ctr_encrypt_final( SESSION *sess,     CK_BBOOL length_only,
			      ENCR_DECR_CONTEXT  *context,
			      CK_BYTE *out_data, CK_ULONG *out_data_len );

CK_RV  aes_ctr_decrypt_final( SESSION *sess,     CK_BBOOL length_only,
			      ENCR_DECR_CONTEXT  *context,
			      CK_BYTE *out_data, CK_ULONG *out_data_len );

CK_RV aes_mac_sign( SESSION * sess, CK_BBOOL length_only,
                    SIGN_VERIFY_CONTEXT  * ctx,
                    CK_BYTE * in_data, CK_ULONG    in_data_len,
                    CK_BYTE * out_data, CK_ULONG * out_data_len);

CK_RV aes_mac_sign_update ( SESSION * sess,  SIGN_VERIFY_CONTEXT  * ctx,
                            CK_BYTE * in_data, CK_ULONG in_data_len );

CK_RV aes_mac_sign_final( SESSION * sess, CK_BBOOL length_only,
                          SIGN_VERIFY_CONTEXT  * ctx,
                          CK_BYTE * out_data, CK_ULONG * out_data_len);

CK_RV aes_mac_verify( SESSION * sess, SIGN_VERIFY_CONTEXT  * ctx,
                      CK_BYTE * in_data, CK_ULONG in_data_len,
                      CK_BYTE * out_data, CK_ULONG out_data_len);

CK_RV aes_mac_verify_update( SESSION * sess, SIGN_VERIFY_CONTEXT * ctx,
                             CK_BYTE * in_data, CK_ULONG in_data_len);

CK_RV aes_mac_verify_final( SESSION  * sess, SIGN_VERIFY_CONTEXT  * ctx,
                            CK_BYTE  * signature, CK_ULONG signature_len);


// AES mechanisms
//
CK_RV  ckm_aes_key_gen( TEMPLATE *tmpl );

CK_RV  ckm_aes_ecb_encrypt( CK_BYTE *in_data,   CK_ULONG    in_data_len,
                            CK_BYTE *out_data,  CK_ULONG   *out_data_len,
                            OBJECT  *key );
CK_RV  ckm_aes_ecb_decrypt( CK_BYTE *in_data,   CK_ULONG    in_data_len,
                            CK_BYTE *out_data,  CK_ULONG   *out_data_len,
                            OBJECT  *key );

CK_RV  ckm_aes_cbc_encrypt( CK_BYTE  *in_data,   CK_ULONG    in_data_len,
                            CK_BYTE  *out_data,  CK_ULONG   *out_data_len,
                            CK_BYTE  *init_v,    OBJECT     *key );
CK_RV  ckm_aes_cbc_decrypt( CK_BYTE  *in_data,   CK_ULONG    in_data_len,
                            CK_BYTE  *out_data,  CK_ULONG   *out_data_len,
                            CK_BYTE  *init_v,    OBJECT     *key );

CK_RV ckm_aes_ctr_encrypt( CK_BYTE *in_data,  CK_ULONG in_data_len,
			   CK_BYTE *out_data, CK_ULONG *out_data_len,
                           CK_BYTE *counterblock,CK_ULONG counter_width,
                           OBJECT  *key );

CK_RV ckm_aes_ctr_decrypt( CK_BYTE *in_data,  CK_ULONG in_data_len,
			   CK_BYTE *out_data, CK_ULONG *out_data_len,
                           CK_BYTE *counterblock,CK_ULONG counter_width,
                           OBJECT  *key );


CK_RV ckm_aes_wrap_format( CK_BBOOL    length_only,
			   CK_BYTE  ** data,
			   CK_ULONG  * data_len );

// SHA-1 mechanisms
//
CK_RV  sha1_hash( SESSION  *sess,     CK_BBOOL  length_only,
                  DIGEST_CONTEXT *ctx,
                  CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                  CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  sha1_hash_update( SESSION *sess,    DIGEST_CONTEXT *ctx,
                         CK_BYTE *in_data, CK_ULONG in_data_len );

CK_RV  sha1_hash_final( SESSION  *sess,     CK_BBOOL  length_only,
                        DIGEST_CONTEXT *ctx,
                        CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  sha1_hmac_sign( SESSION *sess,  CK_BBOOL length_only,
                       SIGN_VERIFY_CONTEXT * ctx,
                       CK_BYTE             * in_data,
                       CK_ULONG              in_data_len,
                       CK_BYTE             * out_data,
                       CK_ULONG            * out_data_len );

CK_RV  sha1_hmac_verify( SESSION             * sess,
                         SIGN_VERIFY_CONTEXT * ctx,
                         CK_BYTE             * in_data,
                         CK_ULONG              in_data_len,
                         CK_BYTE             * signature,
                         CK_ULONG              sig_len );

void   ckm_sha1_init( DIGEST_CONTEXT *ctx );

CK_RV  ckm_sha1_update( DIGEST_CONTEXT *ctx,
                        CK_BYTE      *in_data,  CK_ULONG in_data_len );

CK_RV  ckm_sha1_final( DIGEST_CONTEXT *ctx,
                       CK_BYTE      *out_data, CK_ULONG  *out_data_len );


// SHA-256 mechanisms
//
CK_RV  sha2_hash( SESSION  *sess,     CK_BBOOL  length_only,
                  DIGEST_CONTEXT *ctx,
                  CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                  CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  sha2_hash_update( SESSION *sess,    DIGEST_CONTEXT *ctx,
                         CK_BYTE *in_data, CK_ULONG in_data_len );

CK_RV  sha2_hash_final( SESSION  *sess,     CK_BBOOL  length_only,
                        DIGEST_CONTEXT *ctx,
                        CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  sha2_hmac_sign( SESSION *sess,  CK_BBOOL length_only,
                       SIGN_VERIFY_CONTEXT * ctx,
                       CK_BYTE             * in_data,
                       CK_ULONG              in_data_len,
                       CK_BYTE             * out_data,
                       CK_ULONG            * out_data_len );

CK_RV  sha2_hmac_verify( SESSION             * sess,
                         SIGN_VERIFY_CONTEXT * ctx,
                         CK_BYTE             * in_data,
                         CK_ULONG              in_data_len,
                         CK_BYTE             * signature,
                         CK_ULONG              sig_len );

void   ckm_sha2_init( DIGEST_CONTEXT *ctx );

CK_RV  ckm_sha2_update( DIGEST_CONTEXT *ctx,
                        CK_BYTE      *in_data,  CK_ULONG in_data_len );

CK_RV  ckm_sha2_final( DIGEST_CONTEXT *ctx,
                       CK_BYTE      *out_data, CK_ULONG  *out_data_len );

void   ckm_sha3_init( DIGEST_CONTEXT *ctx );

CK_RV  ckm_sha3_update( DIGEST_CONTEXT *ctx,
	               CK_BYTE      *in_data,  CK_ULONG in_data_len );

CK_RV  ckm_sha3_final( DIGEST_CONTEXT *ctx,
	              CK_BYTE      *out_data, CK_ULONG  *out_data_len );

void   ckm_sha5_init( DIGEST_CONTEXT *ctx );

CK_RV  ckm_sha5_update( DIGEST_CONTEXT *ctx,
                       CK_BYTE      *in_data,  CK_ULONG in_data_len );

CK_RV  ckm_sha5_final( DIGEST_CONTEXT *ctx,
                      CK_BYTE      *out_data, CK_ULONG  *out_data_len );

// MD2 mechanisms
//
CK_RV  md2_hash( SESSION  *sess,     CK_BBOOL  length_only,
                 DIGEST_CONTEXT *ctx,
                 CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                 CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  md2_hash_update( SESSION *sess,    DIGEST_CONTEXT *ctx,
                        CK_BYTE *in_data, CK_ULONG in_data_len );

CK_RV  md2_hash_final( SESSION  *sess,     CK_BBOOL  length_only,
                       DIGEST_CONTEXT *ctx,
                       CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  md2_hmac_sign( SESSION *sess,  CK_BBOOL length_only,
                      SIGN_VERIFY_CONTEXT * ctx,
                      CK_BYTE             * in_data,
                      CK_ULONG              in_data_len,
                      CK_BYTE             * out_data,
                      CK_ULONG            * out_data_len );

CK_RV  md2_hmac_verify( SESSION             * sess,
                        SIGN_VERIFY_CONTEXT * ctx,
                        CK_BYTE             * in_data,
                        CK_ULONG              in_data_len,
                        CK_BYTE             * signature,
                        CK_ULONG              sig_len );

CK_RV  ckm_md2_update( MD2_CONTEXT *context,
                       CK_BYTE     *in_data,  CK_ULONG in_data_len );

CK_RV  ckm_md2_final( MD2_CONTEXT  *context,
                      CK_BYTE      *out_data, CK_ULONG  out_data_len );

void   ckm_md2_transform( CK_BYTE *state, CK_BYTE *checksum, CK_BYTE *block );


// MD5 mechanisms
//
CK_RV  md5_hash( SESSION  *sess,     CK_BBOOL  length_only,
                 DIGEST_CONTEXT *ctx,
                 CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                 CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  md5_hash_update( SESSION *sess,    DIGEST_CONTEXT *ctx,
                        CK_BYTE *in_data, CK_ULONG in_data_len );

CK_RV  md5_hash_final( SESSION  *sess,     CK_BBOOL  length_only,
                       DIGEST_CONTEXT *ctx,
                       CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV  md5_hmac_sign( SESSION *sess,  CK_BBOOL length_only,
                      SIGN_VERIFY_CONTEXT * ctx,
                      CK_BYTE             * in_data,
                      CK_ULONG              in_data_len,
                      CK_BYTE             * out_data,
                      CK_ULONG            * out_data_len );

CK_RV  md5_hmac_verify( SESSION             * sess,
                        SIGN_VERIFY_CONTEXT * ctx,
                        CK_BYTE             * in_data,
                        CK_ULONG              in_data_len,
                        CK_BYTE             * signature,
                        CK_ULONG              sig_len );

void   ckm_md5_init( MD5_CONTEXT *context );

CK_RV  ckm_md5_update( MD5_CONTEXT *context,
                       CK_BYTE     *in_data,  CK_ULONG in_data_len );

CK_RV  ckm_md5_final( MD5_CONTEXT  *context,
                      CK_BYTE      *out_data, CK_ULONG  out_data_len );

void   ckm_md5_transform( CK_ULONG *buf, CK_ULONG *in );


// linked-list routines
//
DL_NODE * dlist_add_as_first( DL_NODE *list, void *data );
DL_NODE * dlist_add_as_last( DL_NODE *list, void *data );
DL_NODE * dlist_find( DL_NODE *list, void *data );
DL_NODE * dlist_get_first( DL_NODE *list );
DL_NODE * dlist_get_last( DL_NODE *list );
CK_ULONG  dlist_length( DL_NODE *list );
DL_NODE * dlist_next( DL_NODE *list );
DL_NODE * dlist_prev( DL_NODE *list );
void      dlist_purge( DL_NODE *list );
DL_NODE * dlist_remove_node( DL_NODE *list, DL_NODE *node );

CK_RV _CreateMutex( MUTEX *mutex );
CK_RV _DestroyMutex( MUTEX *mutex );
CK_RV _LockMutex( MUTEX *mutex );
CK_RV _UnlockMutex( MUTEX *mutex );

CK_RV attach_shm(CK_SLOT_ID slot_id, LW_SHM_TYPE **shmem);
CK_RV detach_shm(void);

// encryption manager routines
//
CK_RV     encr_mgr_init( SESSION           * sess,
                         ENCR_DECR_CONTEXT * ctx,
                         CK_ULONG            operation,
                         CK_MECHANISM      * mech,
                         CK_OBJECT_HANDLE    key_handle );

CK_RV     encr_mgr_cleanup( ENCR_DECR_CONTEXT *ctx );

CK_RV     encr_mgr_encrypt( SESSION  *sess,     CK_BBOOL  length_only,
                            ENCR_DECR_CONTEXT *ctx,
                            CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                            CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV     encr_mgr_encrypt_final( SESSION  *sess,     CK_BBOOL  length_only,
                                  ENCR_DECR_CONTEXT *ctx,
                                  CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV     encr_mgr_encrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                                   ENCR_DECR_CONTEXT *ctx,
                                   CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                   CK_BYTE  *out_data, CK_ULONG *out_data_len );

// decryption manager routines
//
CK_RV     decr_mgr_init( SESSION           * sess,
                         ENCR_DECR_CONTEXT * ctx,
                         CK_ULONG            operation,
                         CK_MECHANISM      * mech,
                         CK_OBJECT_HANDLE    key_handle );

CK_RV     decr_mgr_cleanup( ENCR_DECR_CONTEXT * ctx );

CK_RV     decr_mgr_decrypt( SESSION  *sess,     CK_BBOOL  length_only,
                            ENCR_DECR_CONTEXT * ctx,
                            CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                            CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV     decr_mgr_decrypt_final( SESSION  *sess,     CK_BBOOL  length_only,
                                  ENCR_DECR_CONTEXT * ctx,
                                  CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV     decr_mgr_decrypt_update( SESSION  *sess,     CK_BBOOL  length_only,
                                   ENCR_DECR_CONTEXT * ctx,
                                   CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                   CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV     decr_mgr_update_des_ecb( SESSION  *sess,     CK_BBOOL  length_only,
                                   ENCR_DECR_CONTEXT * ctx,
                                   CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                   CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV     decr_mgr_update_des_cbc( SESSION  *sess,     CK_BBOOL  length_only,
                                   ENCR_DECR_CONTEXT * ctx,
                                   CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                   CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV     decr_mgr_update_des3_ecb( SESSION  *sess,     CK_BBOOL  length_only,
                                    ENCR_DECR_CONTEXT * ctx,
                                    CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                    CK_BYTE  *out_data, CK_ULONG *out_data_len );

CK_RV     decr_mgr_update_des3_cbc( SESSION  *sess,     CK_BBOOL  length_only,
                                    ENCR_DECR_CONTEXT * ctx,
                                    CK_BYTE  *in_data,  CK_ULONG  in_data_len,
                                    CK_BYTE  *out_data, CK_ULONG *out_data_len );

// digest manager routines
//
CK_RV    digest_mgr_cleanup( DIGEST_CONTEXT *ctx );

CK_RV    digest_mgr_init( SESSION        *sess,
                          DIGEST_CONTEXT *ctx,
                          CK_MECHANISM   *mech );

CK_RV    digest_mgr_digest( SESSION        *sess, CK_BBOOL  length_only,
                            DIGEST_CONTEXT *ctx,
                            CK_BYTE        *data, CK_ULONG  data_len,
                            CK_BYTE        *hash, CK_ULONG *hash_len );

CK_RV    digest_mgr_digest_update( SESSION        *sess,
                                   DIGEST_CONTEXT *ctx,
                                   CK_BYTE        *data,  CK_ULONG data_len );

CK_RV    digest_mgr_digest_key( SESSION          *sess,
                                DIGEST_CONTEXT   *ctx,
                                CK_OBJECT_HANDLE  key_handle );

CK_RV    digest_mgr_digest_final( SESSION        *sess, CK_BBOOL  length_only,
                                  DIGEST_CONTEXT *ctx,
                                  CK_BYTE        *hash, CK_ULONG *hash_len );


// key manager routines
//
CK_RV     key_mgr_generate_key( SESSION *sess,
                                CK_MECHANISM *mech,
                                CK_ATTRIBUTE *pTemplate, CK_ULONG ulCount,
                                CK_OBJECT_HANDLE *key_handle );

CK_RV     key_mgr_generate_key_pair( SESSION *sess,
                                     CK_MECHANISM *mech,
                                     CK_ATTRIBUTE *publ_tmpl, CK_ULONG publ_count,
                                     CK_ATTRIBUTE *priv_tmpl, CK_ULONG priv_count,
                                     CK_OBJECT_HANDLE *publ_key_handle,
                                     CK_OBJECT_HANDLE *priv_key_handle );

CK_RV     key_mgr_get_private_key_type( CK_BYTE     *keydata,
                                        CK_ULONG     keylen,
                                        CK_KEY_TYPE *keytype );

CK_RV     key_mgr_derive_key( SESSION           * sess,
                              CK_MECHANISM      * mech,
                              CK_OBJECT_HANDLE    base_key,
                              CK_OBJECT_HANDLE  * derived_key,
                              CK_ATTRIBUTE      * pTemplate,
                              CK_ULONG            ulCount );

CK_RV     key_mgr_wrap_key( SESSION           *sess,
                            CK_BBOOL           length_only,
                            CK_MECHANISM      *mech,
                            CK_OBJECT_HANDLE   h_wrapping_key,
                            CK_OBJECT_HANDLE   h_key,
                            CK_BYTE           *wrapped_key,
                            CK_ULONG          *wrapped_key_len );

CK_RV     key_mgr_unwrap_key( SESSION          *sess,
                              CK_MECHANISM     *mech,
                              CK_ATTRIBUTE     *pTemplate,
                              CK_ULONG          ulCount,
                              CK_BYTE          *wrapped_key,
                              CK_ULONG          wrapped_key_len,
                              CK_OBJECT_HANDLE  unwrapping_key,
                              CK_OBJECT_HANDLE *unwrapped_key );

CK_RV     key_mgr_derive_prolog( SESSION              *sess,
                                 CK_ATTRIBUTE         *attributes,
                                 CK_ULONG              attrcount,
                                 CK_OBJECT_HANDLE      base_key,
                                 OBJECT               *base_key_obj,
                                 CK_BYTE              *base_key_value,
                                 CK_KEY_TYPE           base_key_type,
                                 ATTRIBUTE_PARSE_LIST *parselist,
                                 CK_ULONG              plcount );


// signature manager routines
//
CK_RV     sign_mgr_init( SESSION             * sess,
                         SIGN_VERIFY_CONTEXT * ctx,
                         CK_MECHANISM        * mech,
                         CK_BBOOL              recover_mode,
                         CK_OBJECT_HANDLE      key_handle );

CK_RV     sign_mgr_cleanup( SIGN_VERIFY_CONTEXT *ctx );

CK_RV     sign_mgr_sign( SESSION             * sess,
                         CK_BBOOL              length_only,
                         SIGN_VERIFY_CONTEXT * ctx,
                         CK_BYTE             * in_data,
                         CK_ULONG              in_data_len,
                         CK_BYTE             * out_data,
                         CK_ULONG            * out_data_len );

CK_RV     sign_mgr_sign_recover( SESSION             * sess,
                                 CK_BBOOL              length_only,
                                 SIGN_VERIFY_CONTEXT * ctx,
                                 CK_BYTE             * in_data,
                                 CK_ULONG              in_data_len,
                                 CK_BYTE             * out_data,
                                 CK_ULONG            * out_data_len );

CK_RV     sign_mgr_sign_final( SESSION             * sess,
                               CK_BBOOL              length_only,
                               SIGN_VERIFY_CONTEXT * ctx,
                               CK_BYTE             * out_data,
                               CK_ULONG            * out_data_len );

CK_RV     sign_mgr_sign_update( SESSION             * sess,
                                SIGN_VERIFY_CONTEXT * ctx,
                                CK_BYTE             * in_data,
                                CK_ULONG              in_data_len );

// signature verify manager routines
//
CK_RV     verify_mgr_init( SESSION             * sess,
                           SIGN_VERIFY_CONTEXT * ctx,
                           CK_MECHANISM        * mech,
                           CK_BBOOL              recover_mode,
                           CK_OBJECT_HANDLE      key_handle );

CK_RV     verify_mgr_cleanup( SIGN_VERIFY_CONTEXT *ctx );

CK_RV     verify_mgr_verify( SESSION             * sess,
                             SIGN_VERIFY_CONTEXT * ctx,
                             CK_BYTE             * in_data,
                             CK_ULONG              in_data_len,
                             CK_BYTE             * signature,
                             CK_ULONG              sig_len );

CK_RV     verify_mgr_verify_recover( SESSION             * sess,
                                     CK_BBOOL              length_only,
                                     SIGN_VERIFY_CONTEXT * ctx,
                                     CK_BYTE             * signature,
                                     CK_ULONG              sig_len,
                                     CK_BYTE             * out_data,
                                     CK_ULONG            * out_len );

CK_RV     verify_mgr_verify_update( SESSION             * sess,
                                    SIGN_VERIFY_CONTEXT * ctx,
                                    CK_BYTE             * in_data,
                                    CK_ULONG              in_data_len );

CK_RV     verify_mgr_verify_final( SESSION             * sess,
                                   SIGN_VERIFY_CONTEXT * ctx,
                                   CK_BYTE             * signature,
                                   CK_ULONG              sig_len );


// session manager routines
//
CK_RV  session_mgr_close_all_sessions( void );
CK_RV  session_mgr_close_session( CK_SESSION_HANDLE );
CK_RV  session_mgr_new( CK_ULONG flags, CK_SLOT_ID slot_id, CK_SESSION_HANDLE_PTR phSession );
SESSION * session_mgr_find( CK_SESSION_HANDLE handle );
CK_RV  session_mgr_login_all ( CK_USER_TYPE user_type );
CK_RV  session_mgr_logout_all( void );

CK_BBOOL  session_mgr_readonly_session_exists( void );
CK_BBOOL  session_mgr_so_session_exists    ( void );
CK_BBOOL  session_mgr_user_session_exists  ( void );
CK_BBOOL  session_mgr_public_session_exists( void );

CK_RV    session_mgr_get_op_state( SESSION *sess, CK_BBOOL  length_only,
                                   CK_BYTE *data, CK_ULONG *data_len );

CK_RV    session_mgr_set_op_state( SESSION          *sess,
                                   CK_OBJECT_HANDLE  encr_key, CK_OBJECT_HANDLE  auth_key,
                                   CK_BYTE          *data,     CK_ULONG          data_len );
CK_BBOOL pin_expired(CK_SESSION_INFO *, CK_FLAGS);
CK_BBOOL pin_locked(CK_SESSION_INFO *, CK_FLAGS);
void set_login_flags(CK_USER_TYPE, CK_FLAGS_32 *);


// object manager routines
//
CK_RV    object_mgr_add( SESSION          * sess,
                         CK_ATTRIBUTE     * pTemplate,
                         CK_ULONG           ulCount,
                         CK_OBJECT_HANDLE * handle );

CK_RV    object_mgr_add_to_map( SESSION          * sess,
                                OBJECT           * obj,
				unsigned long      obj_handle,
                                CK_OBJECT_HANDLE * handle );

void     object_mgr_add_to_shm  ( OBJECT *obj );
CK_RV    object_mgr_del_from_shm( OBJECT *obj );
CK_RV    object_mgr_check_shm   ( OBJECT *obj );
CK_RV    object_mgr_search_shm_for_obj( TOK_OBJ_ENTRY  * list,
                                        CK_ULONG         lo,
                                        CK_ULONG         hi,
                                        OBJECT         * obj,
                                        CK_ULONG       * index );
CK_RV    object_mgr_sort_priv_shm( void );
CK_RV    object_mgr_sort_publ_shm( void );
CK_RV    object_mgr_update_from_shm( void );
CK_RV    object_mgr_update_publ_tok_obj_from_shm();
CK_RV    object_mgr_update_priv_tok_obj_from_shm();

CK_RV    object_mgr_copy( SESSION          * sess,
                          CK_ATTRIBUTE     * pTemplate,
                          CK_ULONG           ulCount,
                          CK_OBJECT_HANDLE   old_obj,
                          CK_OBJECT_HANDLE * new_obj );

CK_RV    object_mgr_create_final( SESSION           *sess,
                                  OBJECT            *obj,
                                  CK_OBJECT_HANDLE  *handle );

CK_RV    object_mgr_create_skel( SESSION      * sess,
                                 CK_ATTRIBUTE * pTemplate,
                                 CK_ULONG       ulCount,
                                 CK_ULONG       mode,
                                 CK_ULONG       class,
                                 CK_ULONG       subclass,
                                 OBJECT      ** obj );

CK_RV    object_mgr_destroy_object( SESSION         * sess,
                                    CK_OBJECT_HANDLE  handle );

CK_RV    object_mgr_destroy_token_objects( void );

CK_RV    object_mgr_find_in_map_nocache( CK_OBJECT_HANDLE    handle,
					 OBJECT           ** ptr );

CK_RV    object_mgr_find_in_map1( CK_OBJECT_HANDLE   handle,
                                  OBJECT           ** ptr );

CK_RV    object_mgr_find_in_map2( OBJECT           * ptr,
                                  CK_OBJECT_HANDLE * handle );

CK_RV    object_mgr_find_init( SESSION      * sess,
                               CK_ATTRIBUTE * pTemplate,
                               CK_ULONG       ulCount );

CK_RV    object_mgr_find_build_list( SESSION       * sess,
                                     CK_ATTRIBUTE  * pTemplate,
                                     CK_ULONG        ulCount,
                                     DL_NODE       * obj_list,
                                     CK_BBOOL        public_only );

CK_RV    object_mgr_find_final( SESSION *sess );

CK_RV    object_mgr_get_attribute_values( SESSION           * sess,
                                          CK_OBJECT_HANDLE    handle,
                                          CK_ATTRIBUTE      * pTemplate,
                                          CK_ULONG            ulCount );

CK_RV    object_mgr_get_object_size( CK_OBJECT_HANDLE   handle,
                                     CK_ULONG         * size );

CK_BBOOL object_mgr_purge_session_objects( SESSION       * sess,
                                           SESS_OBJ_TYPE   type );

CK_BBOOL object_mgr_purge_token_objects( void );

CK_BBOOL object_mgr_purge_private_token_objects( void );

CK_RV    object_mgr_restore_obj( CK_BYTE *data, OBJECT *oldObj );

CK_RV    object_mgr_restore_obj_withSize( CK_BYTE *data, OBJECT *oldObj, int data_size );

CK_RV    object_mgr_set_attribute_values( SESSION          * sess,
                                          CK_OBJECT_HANDLE   handle,
                                          CK_ATTRIBUTE     * pTemplate,
                                          CK_ULONG           ulCount );

// SAB FIXME FIXME
CK_BBOOL object_mgr_purge_map( SESSION       * sess,
                               SESS_OBJ_TYPE   type );

/* structures used to hold arguments to callback functions triggered by either bt_for_each_node
 * or bt_node_free */
struct find_args
{
	int done;
	OBJECT *obj;
	CK_OBJECT_HANDLE map_handle;
};

struct find_by_name_args
{
	int done;
	char *name;
};

struct find_build_list_args
{
	CK_ATTRIBUTE *pTemplate;
	SESSION *sess;
	CK_ULONG ulCount;
	CK_BBOOL hw_feature;
	CK_BBOOL hidden_object;
	CK_BBOOL public_only;
};

struct purge_args
{
	SESSION *sess;
	SESS_OBJ_TYPE type;
};

struct update_tok_obj_args
{
	TOK_OBJ_ENTRY *entries;
	CK_ULONG_32 *num_entries;
	struct btree *t;
};


// object routines
//
CK_RV     object_create( CK_ATTRIBUTE  * pTemplate,
                         CK_ULONG        ulCount,
                         OBJECT       ** obj );

CK_RV     object_create_skel( CK_ATTRIBUTE * pTemplate,
                              CK_ULONG       ulCount,
                              CK_ULONG       mode,
                              CK_ULONG       class,
                              CK_ULONG       subclass,
                              OBJECT      ** key );

CK_RV     object_copy( CK_ATTRIBUTE * pTemplate,
                       CK_ULONG       ulCount,
                       OBJECT       * old_obj,
                       OBJECT      ** new_obj );

CK_RV     object_flatten( OBJECT    * obj,
                          CK_BYTE  ** data,
                          CK_ULONG  * len );

CK_BBOOL  object_free( OBJECT *obj );

CK_RV     object_get_attribute_values( OBJECT       * obj,
                                       CK_ATTRIBUTE * pTemplate,
                                       CK_ULONG       count );

CK_ULONG  object_get_size( OBJECT *obj );

CK_RV     object_restore( CK_BYTE  * data,
                          OBJECT  ** obj,
                          CK_BBOOL   replace );

CK_RV     object_restore_withSize( CK_BYTE  * data,
				   OBJECT  ** obj,
				   CK_BBOOL   replace,
				   int        data_size );

CK_RV     object_set_attribute_values( OBJECT       * obj,
                                       CK_ATTRIBUTE * pTemplate,
                                       CK_ULONG       ulCount );

CK_BBOOL  object_is_modifiable    ( OBJECT * obj );
CK_BBOOL  object_is_private       ( OBJECT * obj );
CK_BBOOL  object_is_public        ( OBJECT * obj );
CK_BBOOL  object_is_token_object  ( OBJECT * obj );
CK_BBOOL  object_is_session_object( OBJECT * obj );


// object attribute template routines
//

CK_RV     template_add_attributes( TEMPLATE     * tmpl,
                                   CK_ATTRIBUTE * attr,
                                   CK_ULONG       ulCount );

CK_RV     template_add_default_attributes( TEMPLATE * tmpl,
                                           TEMPLATE * basetmpl,
                                           CK_ULONG   class,
                                           CK_ULONG   subclass,
                                           CK_ULONG   mode );

CK_BBOOL  template_attribute_find( TEMPLATE           * tmpl,
                                   CK_ATTRIBUTE_TYPE    type,
                                   CK_ATTRIBUTE      ** attr);

void      template_attribute_find_multiple( TEMPLATE             *tmpl,
                                            ATTRIBUTE_PARSE_LIST *parselist,
                                            CK_ULONG              plcount );

CK_BBOOL  template_check_exportability( TEMPLATE *tmpl, CK_ATTRIBUTE_TYPE type );

CK_RV     template_check_required_attributes( TEMPLATE * tmpl,
                                              CK_ULONG   class,
                                              CK_ULONG   subclass,
                                              CK_ULONG   mode );

CK_RV     template_check_required_base_attributes( TEMPLATE * tmpl,
                                                   CK_ULONG   mode );

CK_BBOOL  template_compare( CK_ATTRIBUTE * t1,
                            CK_ULONG       ulCount,
                            TEMPLATE     * t2 );

CK_RV     template_copy( TEMPLATE * dest,
                         TEMPLATE * src );

CK_RV     template_flatten( TEMPLATE * tmpl,
                            CK_BYTE  * dest );

CK_RV     template_free( TEMPLATE *tmpl );

CK_BBOOL  template_get_class( TEMPLATE * tmpl,
                              CK_ULONG * class,
                              CK_ULONG * subclass );

CK_ULONG  template_get_count( TEMPLATE *tmpl );

CK_ULONG  template_get_size( TEMPLATE *tmpl );

CK_ULONG  template_get_compressed_size( TEMPLATE *tmpl );

CK_RV     template_set_default_common_attributes( TEMPLATE *tmpl );

CK_RV     template_merge( TEMPLATE *dest, TEMPLATE **src );

CK_RV     template_update_attribute( TEMPLATE * tmpl, CK_ATTRIBUTE * attr );

CK_RV     template_unflatten( TEMPLATE ** tmpl,
                              CK_BYTE   * data,
                              CK_ULONG    count );

CK_RV     template_unflatten_withSize( TEMPLATE ** new_tmpl,
				       CK_BYTE   * buf,
				       CK_ULONG    count,
				       int         buf_size );

CK_RV     template_validate_attribute( TEMPLATE     * tmpl,
                                       CK_ATTRIBUTE * attr,
                                       CK_ULONG       class,
                                       CK_ULONG       subclass,
                                       CK_ULONG       mode );

CK_RV     template_validate_attributes( TEMPLATE * tmpl,
                                        CK_ULONG   class,
                                        CK_ULONG   subclass,
                                        CK_ULONG   mode );

CK_RV     template_validate_base_attribute( TEMPLATE     * tmpl,
                                            CK_ATTRIBUTE * attr,
                                            CK_ULONG       mode );



// DATA OBJECT ROUTINES
//
CK_RV     data_object_check_required_attributes ( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     data_object_set_default_attributes    ( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     data_object_validate_attribute        ( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

// CERTIFICATE ROUTINES
//
CK_RV     cert_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     cert_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

CK_RV     cert_x509_check_required_attributes   ( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     cert_x509_set_default_attributes      ( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     cert_x509_validate_attribute          ( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );
CK_RV     cert_vendor_check_required_attributes ( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     cert_vendor_validate_attribute        ( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

//
// KEY ROUTINES
//

CK_RV     key_object_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     key_object_set_default_attributes   ( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     key_object_validate_attribute       ( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

CK_RV     publ_key_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     publ_key_set_default_attributes   ( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     publ_key_validate_attribute       ( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

CK_RV     priv_key_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     priv_key_set_default_attributes   ( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     priv_key_unwrap( TEMPLATE *tmpl, CK_ULONG keytype, CK_BYTE *data, CK_ULONG data_len, CK_BBOOL isopaque );
CK_RV     priv_key_validate_attribute       ( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

CK_BBOOL  secret_key_check_exportability( CK_ATTRIBUTE_TYPE type );
CK_RV     secret_key_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     secret_key_set_default_attributes   ( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     secret_key_unwrap( TEMPLATE *tmpl, CK_ULONG keytype, CK_BYTE *data, CK_ULONG data_len, CK_BBOOL fromend, CK_BBOOL isopaque );
CK_RV     secret_key_validate_attribute       ( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

// rsa routines
//
CK_RV     rsa_publ_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     rsa_publ_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );
CK_RV     rsa_publ_set_default_attributes( TEMPLATE *tmpl, TEMPLATE *basetmpl, CK_ULONG mode );
CK_BBOOL  rsa_priv_check_exportability( CK_ATTRIBUTE_TYPE type );
CK_RV     rsa_priv_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     rsa_priv_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     rsa_priv_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );
CK_RV     rsa_priv_wrap_get_data( TEMPLATE *tmpl, CK_BBOOL length_only, CK_BYTE **data, CK_ULONG *data_len );
CK_RV     rsa_priv_unwrap( TEMPLATE *tmpl, CK_BYTE *data, CK_ULONG data_len, CK_BBOOL isopaque );

// dsa routines
//
CK_RV     dsa_publ_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     dsa_publ_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     dsa_publ_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );
CK_BBOOL  dsa_priv_check_exportability( CK_ATTRIBUTE_TYPE type );
CK_RV     dsa_priv_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     dsa_priv_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     dsa_priv_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );
CK_RV     dsa_priv_wrap_get_data( TEMPLATE *tmpl, CK_BBOOL length_only, CK_BYTE **data, CK_ULONG *data_len );
CK_RV     dsa_priv_unwrap( TEMPLATE *tmpl, CK_BYTE *data, CK_ULONG data_len );

// ecdsa routines
//
CK_RV     ecdsa_publ_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     ecdsa_publ_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     ecdsa_publ_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );
CK_BBOOL  ecdsa_priv_check_exportability( CK_ATTRIBUTE_TYPE type );
CK_RV     ecdsa_priv_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     ecdsa_priv_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     ecdsa_priv_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

// diffie-hellman routines
//
CK_RV     dh_publ_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     dh_publ_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     dh_publ_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );
CK_BBOOL  dh_priv_check_exportability( CK_ATTRIBUTE_TYPE type );
CK_RV     dh_priv_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     dh_priv_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     dh_priv_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

// KEA routines
//
CK_RV     kea_publ_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     kea_publ_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     kea_publ_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );
CK_BBOOL  kea_priv_check_exportability( CK_ATTRIBUTE_TYPE type );
CK_RV     kea_priv_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     kea_priv_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     kea_priv_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );


// Generic secret key routines
CK_RV     generic_secret_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     generic_secret_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     generic_secret_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );
CK_RV     generic_secret_wrap_get_data( TEMPLATE *tmpl, CK_BBOOL length_only, CK_BYTE **data, CK_ULONG *data_len );
CK_RV     generic_secret_unwrap( TEMPLATE *tmpl, CK_BYTE *data, CK_ULONG data_len, CK_BBOOL fromend, CK_BBOOL isopaque );

// RC2 routines
CK_RV     rc2_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     rc2_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     rc2_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

// RC4 routines
CK_RV     rc4_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     rc4_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     rc4_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

// RC5 routines
CK_RV     rc5_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     rc5_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     rc5_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

// DES routines
CK_RV     des_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_BBOOL  des_check_weak_key( CK_BYTE *key );
CK_RV     des_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     des_unwrap( TEMPLATE *tmpl, CK_BYTE *data, CK_ULONG data_len, CK_BBOOL fromend, CK_BBOOL isopaque );
CK_RV     des_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );
CK_RV     des_wrap_get_data( TEMPLATE *tmpl, CK_BBOOL length_only, CK_BYTE **data, CK_ULONG *data_len );

// DES2 routines
CK_RV     des2_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     des2_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     des2_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

// DES3 routines
CK_RV     des3_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     des3_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     des3_unwrap( TEMPLATE *tmpl, CK_BYTE *data, CK_ULONG data_len, CK_BBOOL fromend, CK_BBOOL isopaque );
CK_RV     des3_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );
CK_RV     des3_wrap_get_data( TEMPLATE *tmpl, CK_BBOOL length_only, CK_BYTE **data, CK_ULONG *data_len );

// AES routines
CK_RV     aes_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     aes_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     aes_unwrap( TEMPLATE *tmpl, CK_BYTE *data, CK_ULONG data_len, CK_BBOOL fromend, CK_BBOOL isopaque );
CK_RV     aes_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );
CK_RV     aes_wrap_get_data( TEMPLATE *tmpl, CK_BBOOL length_only, CK_BYTE **data, CK_ULONG *data_len );

// CAST routines
CK_RV     cast_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     cast_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     cast_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

// CAST3 routines
CK_RV     cast3_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     cast3_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     cast3_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

// CAST5 routines
CK_RV     cast5_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     cast5_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     cast5_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

// IDEA routines
CK_RV     idea_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     idea_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     idea_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

// CDMF routines
CK_RV     cdmf_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     cdmf_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     cdmf_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

// SKIPJACK routines
CK_RV     skipjack_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     skipjack_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     skipjack_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

// BATON routines
CK_RV     baton_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     baton_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     baton_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );

// JUNIPER routines
CK_RV     juniper_check_required_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     juniper_set_default_attributes( TEMPLATE *tmpl, CK_ULONG mode );
CK_RV     juniper_validate_attribute( TEMPLATE *tmpl, CK_ATTRIBUTE *attr, CK_ULONG mode );


// modular math routines
//
CK_RV mp_subtract( CK_BYTE *bigint, CK_ULONG val, CK_ULONG len );

CK_RV mp_mult( CK_BYTE *bigint_a,  CK_ULONG a_len,
               CK_BYTE *bigint_b,  CK_ULONG b_len,
               CK_BYTE *bigint_c,  CK_ULONG c_len,
               CK_BYTE *result,    CK_ULONG *result_len );

CK_RV mp_exp( CK_BYTE *bigint_a,  CK_ULONG a_len,
              CK_BYTE *bigint_b,  CK_ULONG b_len,
              CK_BYTE *bigint_c,  CK_ULONG c_len,
              CK_BYTE *result,    CK_ULONG *result_len );

// ASN.1 routines
//
CK_ULONG ber_encode_INTEGER( CK_BBOOL    length_only,
                             CK_BYTE  ** ber_int,
                             CK_ULONG  * ber_int_len,
                             CK_BYTE   * data,
                             CK_ULONG    data_len );

CK_RV    ber_decode_INTEGER( CK_BYTE   * ber_int,
                             CK_BYTE  ** data,
                             CK_ULONG  * data_len,
                             CK_ULONG  * field_len );

CK_RV    ber_encode_OCTET_STRING( CK_BBOOL    length_only,
                                  CK_BYTE  ** str,
                                  CK_ULONG  * str_len,
                                  CK_BYTE   * data,
                                  CK_ULONG    data_len );

CK_RV    ber_decode_OCTET_STRING( CK_BYTE   * str,
                                  CK_BYTE  ** data,
                                  CK_ULONG  * data_len,
                                  CK_ULONG  * field_len );

CK_RV    ber_encode_SEQUENCE( CK_BBOOL    length_only,
                              CK_BYTE  ** seq,
                              CK_ULONG  * seq_len,
                              CK_BYTE   * data,
                              CK_ULONG    data_len );

CK_RV    ber_decode_SEQUENCE( CK_BYTE   * seq,
                              CK_BYTE  ** data,
                              CK_ULONG  * data_len,
                              CK_ULONG  * field_len );

CK_RV    ber_encode_PrivateKeyInfo( CK_BBOOL     length_only,
                                    CK_BYTE   ** data,
                                    CK_ULONG   * data_len,
                                    CK_BYTE    * algorithm_id,
                                    CK_ULONG     algorithm_id_len,
                                    CK_BYTE    * priv_key,
                                    CK_ULONG     priv_key_len );

CK_RV    ber_decode_PrivateKeyInfo( CK_BYTE    * data,
                                    CK_ULONG     data_len,
                                    CK_BYTE   ** algorithm_id,
                                    CK_ULONG   * alg_len,
                                    CK_BYTE   ** priv_key );

CK_RV    ber_encode_RSAPrivateKey( CK_BBOOL     length_only,
                                   CK_BYTE   ** data,
                                   CK_ULONG   * data_len,
                                   CK_ATTRIBUTE * modulus,
                                   CK_ATTRIBUTE * publ_exp,
                                   CK_ATTRIBUTE * priv_exp,
                                   CK_ATTRIBUTE * prime1,
                                   CK_ATTRIBUTE * prime2,
                                   CK_ATTRIBUTE * exponent1,
                                   CK_ATTRIBUTE * exponent2,
                                   CK_ATTRIBUTE * coeff,
                                   CK_ATTRIBUTE * opaque );

CK_RV    ber_decode_RSAPrivateKey( CK_BYTE     * data,
                                   CK_ULONG      data_len,
                                   CK_ATTRIBUTE ** modulus,
                                   CK_ATTRIBUTE ** publ_exp,
                                   CK_ATTRIBUTE ** priv_exp,
                                   CK_ATTRIBUTE ** prime1,
                                   CK_ATTRIBUTE ** prime2,
                                   CK_ATTRIBUTE ** exponent1,
                                   CK_ATTRIBUTE ** exponent2,
                                   CK_ATTRIBUTE ** coeff,
                                   CK_ATTRIBUTE ** opaque,
				   CK_BBOOL	   isopaque );


CK_RV    ber_encode_DSAPrivateKey( CK_BBOOL      length_only,
                                   CK_BYTE    ** data,
                                   CK_ULONG    * data_len,
                                   CK_ATTRIBUTE  * prime1,
                                   CK_ATTRIBUTE  * prime2,
                                   CK_ATTRIBUTE  * base,
                                   CK_ATTRIBUTE  * priv_key );

CK_RV    ber_decode_DSAPrivateKey( CK_BYTE     * data,
                                   CK_ULONG      data_len,
                                   CK_ATTRIBUTE ** prime,
                                   CK_ATTRIBUTE ** subprime,
                                   CK_ATTRIBUTE ** base,
                                   CK_ATTRIBUTE ** priv_key );


#include "tok_spec_struct.h"
extern token_spec_t token_specific;

#if (LEEDS_BUILD)
#pragma options align=full
#endif

/* logging */
void ock_err_log(int num, const char *layer, const char *file, int line);
void ock_logit(const char *fmt, ...);

#ifdef DEBUG
#define OCK_LOG_ERR(errnum)  ock_err_log(errnum, STDLL_NAME, __FILE__, __LINE__)
#define OCK_LOG_DEBUG(fmt, ...)           ock_logit("%s:%d " fmt, __FILE__, __LINE__, ##__VA_ARGS__)
void dump_shm(const char *);
#define DUMP_SHM(x)             dump_shm(x)

#else

#define OCK_LOG_ERR(errnum)
#define OCK_LOG_DEBUG(fmt, ...)
#define DUMP_SHM(x)

#endif

#define OCK_SYSLOG(priority, fmt, ...) \
        syslog(priority, "%s " fmt, __FILE__, ##__VA_ARGS__);


/* CKA_HIDDEN will be used to filter return results on a C_FindObjects call.
 * Used for objects internal to a token for management of that token */
#define CKA_HIDDEN              CKA_VENDOR_DEFINED + 0x01000000

#endif
