/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means:
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.

             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program.

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program.

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution.

             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.

             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.

             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations.

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.

             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive.

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.

             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation.


*/

/* (C) COPYRIGHT International Business Machines Corp. 2013          */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <openssl/hmac.h>
#include <openssl/evp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <grp.h>

#include "pkcs11types.h"
#include "defs.h"
#include "host_defs.h"
#include "h_extern.h"
#include "pbkdf.h"


CK_RV
get_randombytes(char *output, int bytes)
{
	int ranfd;
	int rlen;
	unsigned int totallen = 0;

	ranfd = open("/dev/urandom",O_RDONLY);
	if (ranfd >= 0 ) {
		do {
			rlen = read(ranfd, output+totallen, bytes-totallen);
			if (rlen == -1) {
				close(ranfd);
				OCK_LOG_DEBUG("read failed: %s\n", strerror(errno));
				return CKR_FUNCTION_FAILED;
			}
			totallen += rlen;
		} while( totallen < bytes);
		close(ranfd);
		return CKR_OK;
	} else
		return CKR_FUNCTION_FAILED;
}

CK_RV
set_perms(int file)
{
	struct group *grp;

	if (fchmod(file, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP) != 0) {
		OCK_LOG_DEBUG("fchmod failed: %s\n", strerror(errno));
		return CKR_FUNCTION_FAILED;
	}

	grp = getgrnam("pkcs11");
	if (grp) {
		if (fchown(file, -1, grp->gr_gid) != 0) {
			OCK_LOG_DEBUG("fchown failed: %s\n", strerror(errno));
			return CKR_FUNCTION_FAILED;
		}
	} else {
		OCK_LOG_DEBUG("getgrnam failed:%s\n", strerror(errno));
		return CKR_FUNCTION_FAILED;
	}

	return CKR_OK;
}

CK_RV
encrypt_aes(CK_BYTE *inbuf, int inbuflen, CK_BYTE *dkey,
		CK_BYTE *iv, CK_BYTE *outbuf, int *outbuflen)
{
	CK_ULONG_32 tmplen;
	EVP_CIPHER_CTX ctx;
	const EVP_CIPHER *cipher = EVP_aes_256_cbc();

	EVP_CIPHER_CTX_init(&ctx);

	EVP_EncryptInit_ex(&ctx, cipher, NULL, dkey, iv);
	if (!EVP_EncryptUpdate(&ctx, outbuf, outbuflen, inbuf, inbuflen)) {
		OCK_LOG_DEBUG("EVP_EncryptUpdate failed.\n");
		return CKR_FUNCTION_FAILED;
	}
	if (!EVP_EncryptFinal_ex(&ctx, outbuf+(*outbuflen), &tmplen)) {
		OCK_LOG_DEBUG("EVP_EncryptFinal failed.\n");
		return CKR_FUNCTION_FAILED;
	}

	*outbuflen = (*outbuflen) + tmplen;
	EVP_CIPHER_CTX_cleanup(&ctx);

	return CKR_OK;
}

CK_RV
decrypt_aes(CK_BYTE *inbuf, int inbuflen, CK_BYTE *dkey,
		 CK_BYTE *iv, CK_BYTE *outbuf, int *outbuflen)
{
	int size;
        EVP_CIPHER_CTX ctx;
        const EVP_CIPHER *cipher = EVP_aes_256_cbc();

        EVP_CIPHER_CTX_init(&ctx);

        EVP_DecryptInit_ex(&ctx, cipher, NULL, dkey, iv);
        if (!EVP_DecryptUpdate(&ctx, outbuf, outbuflen, inbuf, inbuflen)) {
                OCK_LOG_DEBUG("EVP_DecryptUpdate failed.\n");
                return CKR_FUNCTION_FAILED;
        }
        if (!EVP_DecryptFinal_ex(&ctx, outbuf+(*outbuflen), &size)) {
                OCK_LOG_DEBUG("EVP_DecryptFinal failed.\n");
                return CKR_FUNCTION_FAILED;
        }

        /* total length of the decrypted data */
        *outbuflen = (*outbuflen) + size;

	/* EVP_DecryptFinal removes any padding. The final length 
	 * is the length of the decrypted data without padding.
	 */     

	EVP_CIPHER_CTX_cleanup(&ctx);

	return CKR_OK;
}

CK_RV
get_masterkey(CK_BYTE *pin, CK_ULONG pinlen, CK_BYTE *fname, CK_BYTE *masterkey,
		int *len)
{
	struct stat statbuf;
	FILE *fp;
	CK_ULONG_32 totallen, datasize, readsize;
	int dkeysize;
	CK_BYTE salt[SALTSIZE];
	CK_BYTE dkey[AES_KEY_SIZE_256];
	CK_BYTE outbuf[ENCRYPT_SIZE];
	CK_RV rc = CKR_OK;
	size_t ret;

	/* see if the file exists */
	if ((stat(fname, &statbuf) < 0) && (errno = ENOENT)) {
		OCK_LOG_DEBUG("File does not exist.\n");
		return CKR_FUNCTION_FAILED;
	}

	/* open the file */
	fp = fopen(fname, "r");
	if (fp == NULL) {
		OCK_LOG_DEBUG("fopen failed\n");
		return CKR_FUNCTION_FAILED;
	}

	ret = fread(&totallen, sizeof(CK_ULONG_32), 1, fp);
	if (ret != 1) {
		fclose(fp);
		OCK_LOG_DEBUG("fread failed.\n");
		return CKR_FUNCTION_FAILED;
	}

        ret = fread(salt, SALTSIZE, 1, fp);
	if (ret != 1) {
		fclose(fp);
		OCK_LOG_DEBUG("fread failed.\n");
		return CKR_FUNCTION_FAILED;
	}

	/* get length of encryted data */
	datasize = totallen - SALTSIZE;
	readsize = fread(outbuf, datasize, 1, fp);
	if (readsize != 1) {
		OCK_LOG_DEBUG("Could not get encrypted data in %s.\n", fname);
		fclose(fp);
		return CKR_FUNCTION_FAILED;
	}

	fclose(fp);

	/* now derive the key using the salt and PIN */
	dkeysize = AES_KEY_SIZE_256;
	rc = pbkdf(pin, pinlen, salt, dkey, dkeysize);
	if (rc != CKR_OK) {
		OCK_LOG_DEBUG("Failed to derive a key.\n");
		return CKR_FUNCTION_FAILED;
	}

	/* decrypt the masterkey */
	/* re-use salt for iv */
	rc = decrypt_aes(outbuf, datasize, dkey, salt, masterkey, len);
	if (rc != CKR_OK) {
		OCK_LOG_DEBUG("Failed to decrypt the racf pwd.\n");
		return CKR_FUNCTION_FAILED;
	}

	/* make sure len is equal to our masterkey size. */
	if (*len != AES_KEY_SIZE_256) {
		OCK_LOG_DEBUG("Decrypted key is invalid.\n");
		return CKR_FUNCTION_FAILED;
	}

	return rc;
}

CK_RV
get_racf(CK_BYTE *masterkey, CK_ULONG mklen, CK_BYTE *racfpwd, int *racflen)
{
	struct stat statbuf;
	CK_BYTE outbuf[ENCRYPT_SIZE];
	CK_BYTE iv[AES_INIT_VECTOR_SIZE];
	int len, datasize, readsize;
	FILE *fp;
	CK_RV rc;

	/* see if the file exists ... */
	if ((stat(RACFFILE, &statbuf) < 0) && (errno = ENOENT)) {
		OCK_LOG_DEBUG("File does not exist.\n");
		return CKR_FUNCTION_FAILED;
	}

	/* if file exists, open it */
	fp = fopen(RACFFILE, "r");
	if (fp == NULL) {
		OCK_LOG_DEBUG("fopen failed\n");
		return CKR_FUNCTION_FAILED;
	}

	fread(&len, sizeof(CK_ULONG_32), 1, fp);
        fread(iv, AES_INIT_VECTOR_SIZE, 1, fp);

	/* get length of encryted data */
	datasize = len - AES_INIT_VECTOR_SIZE;
	readsize = fread(outbuf, datasize, 1, fp);
	if (readsize != 1) {
		OCK_LOG_DEBUG("Could not get encrypted data in %s.\n",RACFFILE);
		fclose(fp);
		return CKR_FUNCTION_FAILED;
	}
	fclose(fp);

	/* decrypt the data using the masterkey */
	rc = decrypt_aes(outbuf, datasize, masterkey, iv, racfpwd, racflen);

	/* terminate the decrypted string. */
	memset(racfpwd + (*racflen),0 , 1);

	if (rc != CKR_OK) {
		OCK_LOG_DEBUG("Failed to decrypt the racf pwd.\n");
		return CKR_FUNCTION_FAILED;
	}

	return CKR_OK;
}

CK_RV
pbkdf(CK_BYTE *password, CK_ULONG len, CK_BYTE *salt, CK_BYTE *dkey, CK_ULONG klen)
{

	unsigned char hash[SHA2_HASH_SIZE];
	unsigned char hash_block[SHA2_HASH_SIZE];
	unsigned char *result;
	unsigned int r, num_of_blocks;
	unsigned int count, hashlen;
	unsigned char *ret;
	CK_ULONG rc = CKR_OK;
	int i, j, k;

	/* check inputs */
	if (!password || !salt) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	}

	/* check length of key.. for now only 32 byte keys*/
	if (klen != DKEYLEN) {
		OCK_LOG_ERR(ERR_FUNCTION_FAILED);
		return CKR_FUNCTION_FAILED;
	}

	/* SP 800-132 recommends a minimum iteration count of 1000.
	 * so lets try that for now...
	 */
	count = 1000;

	hashlen = SHA2_HASH_SIZE;

	/* Calculate amount of blocks in klen.
	 * SP 800-132: len = [kLen / hLen] (rounded up).
	 * 	       r = kLen - (len - 1) * hLen;
	 */
	if (klen < SHA2_HASH_SIZE) {
		num_of_blocks = 1;
		r = klen;
	} else {
		num_of_blocks = klen/SHA2_HASH_SIZE;
		/* round up by adding another block if there is a modulus */
		if ((klen % SHA2_HASH_SIZE) != 0)
			num_of_blocks++;
		r = klen - (num_of_blocks - 1) * SHA2_HASH_SIZE;
	}

	/* SP 800-132: For i = 1 to len */
	for (i = 1; i <= num_of_blocks; i++) {

		/* SP 800-132: Ti = 0; */
		memset(hash_block, 0, SHA2_HASH_SIZE);

		/* SP 800-132: U0 = S || Int(i); */
		memset(hash, 0, SHA2_HASH_SIZE);
		memcpy(hash, salt, SALTSIZE);
		hash[SALTSIZE] = i;
		hashlen = SALTSIZE+1;

		/* SP 800-132: For j = 1 to C */
		for (j = 1; j <= count; j++) {
			/* SP 800-132: Uj = HMAC(P, U(j-1)); */
			result = HMAC(EVP_sha256(), password, len, hash, hashlen, NULL, NULL);
			if (result == NULL) {
				OCK_LOG_ERR(ERR_FUNCTION_FAILED);
				rc = CKR_FUNCTION_FAILED;
				goto out;
			}

			/* SP 800-132: Ti = Ti Exclusive_OR Uj; */
			for (k = 0; k < SHA2_HASH_SIZE; k++)
				hash_block[k] ^= hash[k];

			/* prep U(j-1) for next iteration */
			memcpy(hash, result, SHA2_HASH_SIZE);
			hashlen = SHA2_HASH_SIZE;
		}

	/* SP 800-132: derived_key =
	 *   hash_block(1)||hash_block(2)||hash_block(num_of_blocks)<0...r-1>
	 * This means num_of_blocks are needed to concatencate
	 * together to make the derived key.
	 * However, if the derived key length is not a multiple of the
	 * HASH_SIZE, then we only need some of the data in the last hash_block.
	 * So, if there is an r, then only copy r bytes from last hash_block
	 * to the derived_key.
	 */
		if ((i == num_of_blocks) && (r != 0))
			memcpy(dkey, hash_block, r);
		else
			memcpy(dkey, hash_block, SHA2_HASH_SIZE);

	}

out:
	return rc;
}

CK_RV
secure_racf(CK_BYTE *racf, CK_ULONG racflen, CK_BYTE *key, CK_ULONG keylen)
{
	CK_RV rc = CKR_OK;
	CK_BYTE iv[AES_INIT_VECTOR_SIZE];
	FILE *fp;
	CK_BYTE output[ENCRYPT_SIZE];
	CK_ULONG_32 totallen, outputlen;


	/* generate an iv... */
	if ((get_randombytes(iv, AES_INIT_VECTOR_SIZE)) != CKR_OK) {
		OCK_LOG_DEBUG("Could not generate an iv.\n");
		return CKR_FUNCTION_FAILED;
	}

	/* encrypt the racf passwd using the masterkey */
	rc = encrypt_aes(racf, racflen, key, iv, output, &outputlen);
	if (rc != 0) {
		OCK_LOG_DEBUG("Failed to encrypt racf pwd.\n");
		return CKR_FUNCTION_FAILED;
	}

	/* store the following in the RACF file:
	 * 1. total length = v + encrypted data
	 * 2. iv
	 * 3. encrypted data
	 */

	/* get the total length */
	totallen = outputlen + AES_INIT_VECTOR_SIZE;

	fp = fopen(RACFFILE, "w");
	if (!fp) {
		OCK_LOG_DEBUG("fopen failed: %s\n", strerror(errno));
		return CKR_FUNCTION_FAILED;
	}

	/* set permisions on the file */
	rc = set_perms(fileno(fp));
	if (rc != 0) {
		OCK_LOG_DEBUG("Failed to set permissions on RACF file.\n");
		return CKR_FUNCTION_FAILED;
	}

	/* write the info to the file */
	(void)fwrite(&totallen, sizeof(CK_ULONG_32), 1, fp);
	(void)fwrite(iv, AES_INIT_VECTOR_SIZE, 1, fp);
	(void)fwrite(output, outputlen, 1, fp);

	fclose(fp);

	return rc;
}

CK_RV
secure_masterkey(CK_BYTE *masterkey, CK_ULONG len, CK_BYTE *pin,
		 CK_ULONG pinlen, CK_BYTE *fname)
{
	CK_RV  rc = CKR_OK;
	CK_BYTE salt[SALTSIZE];
	CK_BYTE dkey[AES_KEY_SIZE_256];
	CK_ULONG_32 totallen, dkey_size;
	int outputlen;
	CK_BYTE output[ENCRYPT_SIZE];
	FILE *fp;

	memset(salt, 0, SALTSIZE);
	memset(dkey, 0, AES_KEY_SIZE_256);
	dkey_size = AES_KEY_SIZE_256;

	/* get a salt for the password based key derivation function. */
	if ((get_randombytes(salt, SALTSIZE)) != CKR_OK) {
		OCK_LOG_DEBUG("Could not get a salt for pbkdf.\n");
		return CKR_FUNCTION_FAILED;
	}

	/* get a 32 byte key */
	rc = pbkdf(pin, pinlen, salt, dkey, dkey_size);
	if (rc != 0) {
		OCK_LOG_DEBUG("Failed to derive a key for encryption.\n");
		return CKR_FUNCTION_FAILED;
	}

	/* encrypt the masterkey using the derived key */
	/* re-use the salt for the iv... */
	rc = encrypt_aes(masterkey, len, dkey, salt, output, &outputlen);
	if (rc != 0) {
		OCK_LOG_DEBUG("Failed to encrypt masterkey.\n");
		return CKR_FUNCTION_FAILED;
	}

	/* write the encrypted masterkey to named file */
	/* store the following:
	 * 1. total length = salt + encrypted data
	 * 2. salt (always SALTSIZE)
	 * 3. encrypted data
	 */

	/* get the total length */
	totallen = outputlen + SALTSIZE;

	fp = fopen(fname, "w");
	if (!fp) {
		OCK_LOG_DEBUG("fopen failed: %s\n", strerror(errno));
		return CKR_FUNCTION_FAILED;
	}

	/* set permisions on the file */
	rc = set_perms(fileno(fp));
	if (rc != 0) {
		OCK_LOG_DEBUG("Failed to set permissions on encrypted file.\n");
		return CKR_FUNCTION_FAILED;
	}

	/* write the info to the file */
	(void)fwrite(&totallen, sizeof(CK_ULONG_32), 1, fp);
	(void)fwrite(salt, SALTSIZE, 1, fp);
	(void)fwrite(output, outputlen, 1, fp);

	fclose(fp);

	return rc;
}
