/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001,2002          */

 
/***************************************************************************
                          Change Log
                          ==========
       4/25/03    Kapil Sood (kapil@corrent.com)
                  Added DH key pair generation and DH shared key derivation
                  functions.
 
 
 
****************************************************************************/

#define _GNU_SOURCE
#include <pthread.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <strings.h>
#include <errno.h>
#include <syslog.h>

#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <grp.h>
#include <pwd.h>

#include "pkcs11types.h"
#include "stdll.h"

#include "defs.h"
#include "host_defs.h"
#include "h_extern.h"
#include "tok_spec_struct.h"
#include "pkcs32.h"
#include "trace.h"

#include "../api/apiproto.h"

/* Declared in obj_mgr.c */
extern pthread_rwlock_t obj_list_rw_mutex;

void SC_SetFunctionList(void);

CK_ULONG  usage_count = 0;	/* track DLL usage */

void Fork_Initializer(void)
{

	/* Initialize spinlock. */
	XProcLock_Init();

	/* Force logout.  This cleans out the private session and list
	 * and cleans out the private object map
	 */
	session_mgr_logout_all();

	/* Clean out the public object map
	 * First parm is no longer used..
	 */
	object_mgr_purge_map((SESSION *)0xFFFF, PUBLIC);
	object_mgr_purge_map((SESSION *)0xFFFF, PRIVATE);

	/* This should clear the entire session list out */
	session_mgr_close_all_sessions();

	/* Clean out the global login state variable
	 * When implemented...  Although logout_all should clear this up.
	 */

	bt_destroy(&priv_token_obj_btree, call_free);
	bt_destroy(&publ_token_obj_btree, call_free);

	/* Need to do something to prevent the shared memory from
	 * having the objects loaded again.... The most likely place
	 * is in the obj_mgr file where the object is added to shared
	 * memory (object_mgr_add_to_shm) a query should be done to
	 * the appropriate object list....
	 */
}

/* verify that the mech specified is in the
 * mech list for this token...
 */
CK_RV valid_mech(CK_MECHANISM_PTR m, CK_FLAGS f)
{
	CK_RV rc;
	CK_MECHANISM_INFO info;

	if (m && token_specific.t_get_mechanism_info) {
		memset(&info, 0, sizeof(info));
		rc = token_specific.t_get_mechanism_info(m->mechanism, &info);
		if (rc != CKR_OK || !(info.flags & (f)))
			return CKR_MECHANISM_INVALID;
	}
	return CKR_OK;
}


/* In an STDLL this is called once for each card in the system
 * therefore the initialized only flags certain one time things.
 */
CK_RV ST_Initialize(void **FunctionList, CK_SLOT_ID SlotNumber, char *conf_name,
		    struct trace_handle_t t)
{
	CK_RV rc = CKR_OK;

	if ((rc = check_user_and_group()) != CKR_OK)
		return rc;

	/* assume that the upper API prevents multiple calls of initialize
	 * since that only happens on C_Initialize and that is the
	 * resonsibility of the upper layer..
	 */
	initialized = FALSE; /* So the rest of the code works correctly */

	/* If we're not already initialized, grab the mutex and do the
	 * initialization.  Check to see if another thread did so while we
	 * were waiting...
	 *
	 * One of the things we do during initialization is create the mutex
	 * for PKCS#11 operations; until we do so, we have to use the native
	 * mutex...
	 */
	if (pthread_mutex_lock(&native_mutex)) {
		rc = CKR_FUNCTION_FAILED;
		TRACE_ERROR("Failed to lock mutex.\n");
	}

	/* SAB need to call Fork_Initializer here
	 * instead of at the end of the loop...
	 * it may also need to call destroy of the following 3 mutexes..
	 * it may not matter...
	 */
	Fork_Initializer();

	/* set trace info */
	set_trace(t);

	MY_CreateMutex(&pkcs_mutex);
	MY_CreateMutex(&obj_list_mutex);
	if (pthread_rwlock_init(&obj_list_rw_mutex, NULL)) {
		TRACE_ERROR("Mutex lock failed.\n");
	}
	MY_CreateMutex(&sess_list_mutex);
	MY_CreateMutex(&login_mutex);

	/* Create lockfile */
	if (CreateXProcLock() != CKR_OK) {
		TRACE_ERROR("Process lock failed.\n");
		goto done;
	}

	init_data_store((char *)PK_DIR);

	/* Handle global initialization issues first if we have not
	 * been initialized.
	 */
	if (initialized == FALSE) {

		rc = attach_shm(SlotNumber, &global_shm);
		if (rc != CKR_OK) {
			TRACE_ERROR("Could not attach to shared memory.\n");
			goto done;
		}

		nv_token_data = &global_shm->nv_token_data;
		initialized = TRUE;
		SC_SetFunctionList();

		/* Always call the token_specific_init function.... */
		rc =  token_specific.t_init(SlotNumber, conf_name);
		if (rc != 0) {
			*FunctionList = NULL;
			TRACE_DEVEL("Token Specific Init failed.\n");
			goto done;
		}
	}

	rc = load_token_data(SlotNumber);
	if (rc != CKR_OK) {
		*FunctionList = NULL;
		TRACE_DEVEL("Failed to load token data.\n");
		goto done;
	}

	/* no need to return error here, we load the token data we can
	 * and syslog the rest
	 */
	load_public_token_objects();

	XProcLock();
	global_shm->publ_loaded = TRUE;
	XProcUnLock();

	init_slotInfo();

	usage_count++;
	(*FunctionList) = &function_list;

done:
	if (pthread_mutex_unlock(&native_mutex)) {
		TRACE_ERROR("Failed to unlock mutex.\n");
		rc = CKR_FUNCTION_FAILED;
	}
	return rc;
}

/* What does this really have to do in this new token...  probably
 * need to close the adapters that are opened, and clear the other
 * stuff
 */
CK_RV SC_Finalize(CK_SLOT_ID sid)
{
	CK_RV rc, rc_mutex;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		return CKR_CRYPTOKI_NOT_INITIALIZED;
	}

	rc = MY_LockMutex(&pkcs_mutex);
	if (rc != CKR_OK) {
		TRACE_ERROR("Mutex lock failed.\n");
		return rc;
	}

	/* If somebody else has taken care of things, leave... */
	if (initialized == FALSE) {
		MY_UnlockMutex(&pkcs_mutex);
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}
	usage_count--;
	if (usage_count == 0) {
		initialized = FALSE;
	}
	session_mgr_close_all_sessions();
	object_mgr_purge_token_objects();
	detach_shm();
	/* close spin lock file	*/
	CloseXProcLock();
	if (token_specific.t_final != NULL) {
		rc = token_specific.t_final();
		if (rc != CKR_OK) {
			TRACE_ERROR("Token specific final call failed.\n");
			goto done;
		}
	}

done:
	rc_mutex = MY_UnlockMutex(&pkcs_mutex);
	if (rc_mutex != CKR_OK) {
		TRACE_ERROR("Mutex unlock failed.\n");
		return rc_mutex;
	}
	return rc;
}

CK_RV SC_GetTokenInfo(CK_SLOT_ID sid, CK_TOKEN_INFO_PTR pInfo)
{
	CK_RV rc = CKR_OK;
	time_t now;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}
	if (!pInfo) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}
	if (sid > MAX_SLOT_ID) {
		TRACE_ERROR("%s\n", ock_err(ERR_SLOT_ID_INVALID));
		rc = CKR_SLOT_ID_INVALID;
		goto done;
	}
	copy_token_contents_sensibly(pInfo, nv_token_data);

	/* Set the time	*/
	now = time ((time_t *)NULL);
	strftime((char *)pInfo->utcTime, 16, "%X", localtime(&now));

done:
	TRACE_INFO("C_GetTokenInfo: rc = 0x%08lx\n", rc);
	return rc;
}

CK_RV SC_WaitForSlotEvent(CK_FLAGS flags, CK_SLOT_ID_PTR pSlot,
			  CK_VOID_PTR pReserved)
{
	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		return CKR_CRYPTOKI_NOT_INITIALIZED;
	}
	TRACE_ERROR("%s\n", ock_err(ERR_FUNCTION_NOT_SUPPORTED));
	return CKR_FUNCTION_NOT_SUPPORTED;
}

/*
 * Get the mechanism type list for the current token.
 */
CK_RV SC_GetMechanismList(CK_SLOT_ID sid, CK_MECHANISM_TYPE_PTR pMechList,
                          CK_ULONG_PTR count)
{
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto out;
	}
	if (count == NULL) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto out;
	}
	if (sid > MAX_SLOT_ID) {
		TRACE_ERROR("%s\n", ock_err(ERR_SLOT_ID_INVALID));
		rc = CKR_SLOT_ID_INVALID;
		goto out;
	}
	if (!token_specific.t_get_mechanism_list) {
		TRACE_ERROR("token specific GetMechanismList doesn't exist.\n");
		rc = CKR_GENERAL_ERROR;
		goto out;
	}
	rc = token_specific.t_get_mechanism_list(pMechList, count);
	if (rc == CKR_OK) {
		/* To accomodate certain special cases, we may need to
		 * make adjustments to the token's mechanism list.
		 */
		mechanism_list_transformations(pMechList, count);
	}
out:
	TRACE_INFO("C_GetMechanismList:  rc = 0x%08lx, # mechanisms: %lu\n",
		    rc, (count ? *count : 0));
	return rc;
}

/*
 * Get the mechanism info for the current type and token.
 */
CK_RV SC_GetMechanismInfo(CK_SLOT_ID sid, CK_MECHANISM_TYPE type,
                          CK_MECHANISM_INFO_PTR pInfo)
{
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto out;
	}
	if (pInfo == NULL) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto out;
	}
	if (sid > MAX_SLOT_ID) {
		TRACE_ERROR("%s\n", ock_err(ERR_SLOT_ID_INVALID));
		rc = CKR_SLOT_ID_INVALID;
		goto out;
	}
	if (!token_specific.t_get_mechanism_info) {
		TRACE_ERROR("token specific GetMechanismInfo doesn't exist.\n");
		rc = CKR_GENERAL_ERROR;
		goto out;
	}
	rc = token_specific.t_get_mechanism_info(type, pInfo);
out:
	TRACE_INFO("C_GetMechanismInfo: rc = 0x%08lx, mech type = 0x%08lx\n",
		     rc, type);
	
	return rc;
}

/*
 * This routine should only be called if no other processes are
 * attached to the token.  we need to somehow check that this is the
 * only process Meta API should prevent this since it knows session
 * states in the shared memory.
*/
CK_RV SC_InitToken(CK_SLOT_ID sid, CK_CHAR_PTR pPin, CK_ULONG ulPinLen,
		   CK_CHAR_PTR pLabel)
{
	CK_RV rc = CKR_OK;
	CK_BYTE hash_sha[SHA1_HASH_SIZE];

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}
	if (!pPin || !pLabel) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}
	if (nv_token_data->token_info.flags & CKF_SO_PIN_LOCKED) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_LOCKED));
		rc = CKR_PIN_LOCKED;
		goto done;
	}

	/* Check if token has a specific handler for this, otherwise fall back
	 * to default behaviour.
	 */
	if (token_specific.t_init_token) {
		rc = token_specific.t_init_token(sid, pPin, ulPinLen, pLabel);
		if (rc != CKR_OK) {
			TRACE_ERROR("%s\n", ock_err(ERR_PIN_INCORRECT));
			rc = CKR_PIN_INCORRECT;
		}
		goto done;
	}

	rc = compute_sha1(pPin, ulPinLen, hash_sha);
	if (memcmp(nv_token_data->so_pin_sha, hash_sha, SHA1_HASH_SIZE) != 0) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_INCORRECT));
		rc = CKR_PIN_INCORRECT;
		goto done;
	}

	/* Before we reconstruct all the data, we should delete the
	 * token objects from the filesystem.
	 */
	object_mgr_destroy_token_objects();
	delete_token_data();

	init_token_data(sid);
	init_slotInfo();
	memcpy(nv_token_data->so_pin_sha, hash_sha, SHA1_HASH_SIZE);
	nv_token_data->token_info.flags |= CKF_TOKEN_INITIALIZED;
	memcpy(nv_token_data->token_info.label, pLabel, 32);

	rc = save_token_data(sid);
	if (rc != CKR_OK) {
		TRACE_DEVEL("Failed to save token data.\n");
		goto done;
	}
done:
	TRACE_INFO("C_InitToken: rc = 0x%08lx\n", rc);
	return rc;
}


CK_RV SC_InitPIN(ST_SESSION_HANDLE *sSession, CK_CHAR_PTR pPin,
		 CK_ULONG ulPinLen)
{
	SESSION *sess = NULL;
	CK_BYTE hash_sha[SHA1_HASH_SIZE];
	CK_BYTE hash_md5[MD5_HASH_SIZE];
	CK_RV rc = CKR_OK;
	CK_FLAGS_32 *flags = NULL;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}
	if (!pPin) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}
	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}
	if (pin_locked(&sess->session_info, nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_LOCKED));
		rc = CKR_PIN_LOCKED;
		goto done;
	}
	if (sess->session_info.state != CKS_RW_SO_FUNCTIONS) {
		TRACE_ERROR("%s\n", ock_err(ERR_USER_NOT_LOGGED_IN));
		rc = CKR_USER_NOT_LOGGED_IN;
		goto done;
	}

	/* Check if token has a specific handler for this, otherwise fall back
	 * to default behaviour.
	 */
	if (token_specific.t_init_pin) {
		rc = token_specific.t_init_pin(sess, pPin, ulPinLen);
		if (rc == CKR_OK) {
			flags = &nv_token_data->token_info.flags;
			*flags &= ~(CKF_USER_PIN_LOCKED |
				  CKF_USER_PIN_FINAL_TRY |
			          CKF_USER_PIN_COUNT_LOW);

			rc = save_token_data(sess->session_info.slotID);
			if (rc != CKR_OK)
				TRACE_DEVEL("Failed to save token data.\n");
		}
		goto done;
	}

	if ((ulPinLen < MIN_PIN_LEN) || (ulPinLen > MAX_PIN_LEN)) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_LEN_RANGE));
		rc = CKR_PIN_LEN_RANGE;
		goto done;
	}
	/* compute the SHA and MD5 hashes of the user pin */
	rc  = compute_sha1(pPin, ulPinLen, hash_sha);
	rc |= compute_md5( pPin, ulPinLen, hash_md5 );
	if (rc != CKR_OK) {
		TRACE_ERROR("Failed to compute sha or md5 for user pin.\n");
		goto done;
	}
	rc = XProcLock();
	if (rc != CKR_OK) {
		TRACE_ERROR("Failed to get process lock.\n");
		goto done;
	}
	memcpy(nv_token_data->user_pin_sha, hash_sha, SHA1_HASH_SIZE);
	nv_token_data->token_info.flags |= CKF_USER_PIN_INITIALIZED;
	nv_token_data->token_info.flags &= ~(CKF_USER_PIN_TO_BE_CHANGED);
	nv_token_data->token_info.flags &= ~(CKF_USER_PIN_LOCKED);
	XProcUnLock();
	memcpy(user_pin_md5, hash_md5, MD5_HASH_SIZE);
	rc = save_token_data(sess->session_info.slotID);
	if (rc != CKR_OK) {
		TRACE_DEVEL("Failed to save token data.\n");
		goto done;
	}
	rc = save_masterkey_user();
	if (rc != CKR_OK)
		TRACE_DEVEL("Failed to save user's masterkey.\n");

done:
	TRACE_INFO("C_InitPin: rc = 0x%08lx, session = %lu\n",
		   rc, sSession->sessionh);
	return rc;
}

CK_RV SC_SetPIN(ST_SESSION_HANDLE *sSession, CK_CHAR_PTR pOldPin,
		CK_ULONG ulOldLen, CK_CHAR_PTR pNewPin, CK_ULONG ulNewLen)
{
	SESSION *sess = NULL;
	CK_BYTE old_hash_sha[SHA1_HASH_SIZE];
	CK_BYTE new_hash_sha[SHA1_HASH_SIZE];
	CK_BYTE hash_md5[MD5_HASH_SIZE];
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}
	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}
	if (pin_locked(&sess->session_info, 
		       nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_LOCKED));
		rc = CKR_PIN_LOCKED;
		goto done;
	}

	/* Check if token has a specific handler for this, otherwise fall back
	 * to default behaviour.
	 */
	if (token_specific.t_set_pin) {
		rc = token_specific.t_set_pin(sess, pOldPin, ulOldLen, pNewPin, ulNewLen);
		goto done;
	}

	if ((ulNewLen < MIN_PIN_LEN) || (ulNewLen > MAX_PIN_LEN)) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_LEN_RANGE));
		rc = CKR_PIN_LEN_RANGE;
		goto done;
	}
	rc = compute_sha1(pOldPin, ulOldLen, old_hash_sha);
	if (rc != CKR_OK) {
		TRACE_ERROR("Failed to compute sha for old pin.\n");
		goto done;
	}
	/* From the PKCS#11 2.20 spec: "C_SetPIN modifies the PIN of
	 * the user that is currently logged in, or the CKU_USER PIN
	 * if the session is not logged in."  A non R/W session fails
	 * with CKR_SESSION_READ_ONLY.
	 */
	if ((sess->session_info.state == CKS_RW_USER_FUNCTIONS) ||
	    (sess->session_info.state == CKS_RW_PUBLIC_SESSION)) {
		if (memcmp(nv_token_data->user_pin_sha, old_hash_sha, 
			   SHA1_HASH_SIZE) != 0) {
			TRACE_ERROR("%s\n", ock_err(ERR_PIN_INCORRECT));
			rc = CKR_PIN_INCORRECT;
			goto done;
		}
		rc  = compute_sha1(pNewPin, ulNewLen, new_hash_sha);
		rc |= compute_md5(pNewPin, ulNewLen, hash_md5);
		if (rc != CKR_OK) {
			TRACE_ERROR("Failed to compute hash for new pin.\n");
			goto done;
		}
		/* The old PIN matches, now make sure its different
		 * than the new and is not the default. */
		if ((memcmp(old_hash_sha, new_hash_sha, SHA1_HASH_SIZE) == 0) ||
		    (memcmp(new_hash_sha, default_user_pin_sha, SHA1_HASH_SIZE)
		     == 0)) {
			TRACE_ERROR("%s\n", ock_err(ERR_PIN_INVALID));
			rc = CKR_PIN_INVALID;
			goto done;
		}
		rc = XProcLock();
		if (rc != CKR_OK) {
			TRACE_DEVEL("Failed to get process lock.\n");
			goto done;
		}
		memcpy(nv_token_data->user_pin_sha, new_hash_sha,
		       SHA1_HASH_SIZE);
		memcpy(user_pin_md5, hash_md5, MD5_HASH_SIZE);
		nv_token_data->token_info.flags &=
			~(CKF_USER_PIN_TO_BE_CHANGED);
		XProcUnLock();
		rc = save_token_data(sess->session_info.slotID);
		if (rc != CKR_OK) {
			TRACE_DEVEL("Failed to save token data.\n");
			goto done;
		}
		rc = save_masterkey_user();
	} else if (sess->session_info.state == CKS_RW_SO_FUNCTIONS) {
		if (memcmp(nv_token_data->so_pin_sha, old_hash_sha, 
			   SHA1_HASH_SIZE) != 0) {
			rc = CKR_PIN_INCORRECT;
			TRACE_ERROR("%s\n", ock_err(ERR_PIN_INCORRECT));
			goto done;
		}
		rc = compute_sha1(pNewPin, ulNewLen, new_hash_sha);
		rc |= compute_md5(pNewPin, ulNewLen, hash_md5);
		if (rc != CKR_OK) {
			TRACE_ERROR("Failed to compute hash for new pin.\n");
			goto done;
		}
		/* The old PIN matches, now make sure its different
		 * than the new and is not the default.
		 */
		if ((memcmp(old_hash_sha, new_hash_sha, SHA1_HASH_SIZE) == 0) ||
		    (memcmp(new_hash_sha, default_so_pin_sha, SHA1_HASH_SIZE)
		     == 0)) {
			TRACE_ERROR("%s\n", ock_err(ERR_PIN_INVALID));
			rc = CKR_PIN_INVALID;
			goto done;
		}
		rc = XProcLock();
		if (rc != CKR_OK) {
			TRACE_DEVEL("Failed to get process lock.\n");
			goto done;
		}
		memcpy(nv_token_data->so_pin_sha, new_hash_sha, SHA1_HASH_SIZE);
		memcpy(so_pin_md5, hash_md5, MD5_HASH_SIZE);
		nv_token_data->token_info.flags &= ~(CKF_SO_PIN_TO_BE_CHANGED);
		XProcUnLock();
		rc = save_token_data(sess->session_info.slotID);
		if (rc != CKR_OK) {
			TRACE_DEVEL("Failed to save token data.\n");
			goto done;
		}
		rc = save_masterkey_so();
		if (rc != CKR_OK)
			TRACE_DEVEL("Failed to save SO's masterkey.\n");
	} else {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_READ_ONLY));
		rc = CKR_SESSION_READ_ONLY;
	}
done:
	TRACE_INFO("C_SetPin: rc = 0x%08lx, session = %lu\n",
		   rc, sSession->sessionh);
	return rc;
}

CK_RV SC_OpenSession(CK_SLOT_ID sid, CK_FLAGS flags,
		     CK_SESSION_HANDLE_PTR phSession)
{
	CK_BBOOL locked = FALSE;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}
	if (phSession == NULL) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}
	if (sid > MAX_SLOT_ID) {
		TRACE_ERROR("%s\n", ock_err(ERR_SLOT_ID_INVALID));
		rc = CKR_SLOT_ID_INVALID;
		goto done;
	}
	flags |= CKF_SERIAL_SESSION;
	if ((flags & CKF_RW_SESSION) == 0) {
		if (session_mgr_so_session_exists()) {
			TRACE_ERROR("%s\n", ock_err(ERR_SESSION_READ_WRITE_SO_EXISTS));
			rc = CKR_SESSION_READ_WRITE_SO_EXISTS;
			goto done;
		}
	}
	// Get the mutex because we may modify the pid_list
	rc = MY_LockMutex(&pkcs_mutex);
	if (rc != CKR_OK) {
		TRACE_ERROR("Failed to get mutex lock.\n");
		goto done;
	}
	locked = TRUE;
	MY_UnlockMutex(&pkcs_mutex);
	locked = FALSE;
	rc = session_mgr_new(flags, sid, phSession);
	if (rc != CKR_OK) {
		TRACE_DEVEL("session_mgr_new() failed\n");
		goto done;
	}
done:
	if (locked)
		MY_UnlockMutex(&pkcs_mutex);

	TRACE_INFO("C_OpenSession: rc = 0x%08lx\n", rc);
	return rc;
}

CK_RV SC_CloseSession(ST_SESSION_HANDLE *sSession)
{
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	rc = session_mgr_close_session(sSession->sessionh);
done:
	TRACE_INFO("C_CloseSession: rc = 0x%08lx  sess = %lu\n",
		   rc, sSession->sessionh);
	return rc;
}

CK_RV SC_CloseAllSessions(CK_SLOT_ID sid)
{
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}
	rc = session_mgr_close_all_sessions();
	if (rc != CKR_OK)
		TRACE_DEVEL("session_mgr_close_all_sessions() failed.\n");
done:
	TRACE_INFO("C_CloseAllSessions: rc = 0x%08lx slot = %lu\n", rc, sid);
	return rc;
}

CK_RV SC_GetSessionInfo(ST_SESSION_HANDLE *sSession, CK_SESSION_INFO_PTR pInfo)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pInfo) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	memcpy(pInfo, &sess->session_info, sizeof(CK_SESSION_INFO));

done:
	TRACE_INFO("C_GetSessionInfo: session = %lu\n", sSession->sessionh);
	return rc;
}

CK_RV SC_GetOperationState(ST_SESSION_HANDLE *sSession,
			   CK_BYTE_PTR pOperationState,
			   CK_ULONG_PTR pulOperationStateLen)
{
	SESSION *sess = NULL;
	CK_BBOOL length_only = FALSE;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pulOperationStateLen) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	if (!pOperationState)
		length_only = TRUE;

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	rc = session_mgr_get_op_state(sess, length_only, pOperationState,
				      pulOperationStateLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("session_mgr_get_op_state() failed.\n");
done:
	TRACE_INFO("C_GetOperationState: rc = 0x%08lx, session = %lu\n",
		   rc, sSession->sessionh);
	return rc;
}


CK_RV SC_SetOperationState(ST_SESSION_HANDLE *sSession,
			   CK_BYTE_PTR pOperationState,
			   CK_ULONG ulOperationStateLen,
			   CK_OBJECT_HANDLE hEncryptionKey,
			   CK_OBJECT_HANDLE hAuthenticationKey)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pOperationState || (ulOperationStateLen == 0)) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	rc = session_mgr_set_op_state(sess, hEncryptionKey, hAuthenticationKey,
				      pOperationState, ulOperationStateLen);

	if (rc != CKR_OK)
		TRACE_DEVEL("session_mgr_set_op_state() failed.\n");
done:
	TRACE_INFO("C_SetOperationState: rc = 0x%08lx, session = %lu\n",
		   rc, sSession->sessionh);
	return rc;
}


CK_RV SC_Login(ST_SESSION_HANDLE *sSession, CK_USER_TYPE userType,
	       CK_CHAR_PTR pPin, CK_ULONG ulPinLen)
{
	SESSION *sess = NULL;
	CK_FLAGS_32 *flags = NULL;
	CK_BYTE hash_sha[SHA1_HASH_SIZE];
	CK_RV rc = CKR_OK;

	/* In v2.11, logins should be exclusive, since token
	 * specific flags may need to be set for a bad login. - KEY
	 */
	rc = MY_LockMutex(&login_mutex);
	if (rc != CKR_OK) {
		TRACE_ERROR("Failed to get mutex lock.\n");
		return CKR_FUNCTION_FAILED;
	}
	  
	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}
	
	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}
	flags = &nv_token_data->token_info.flags;

	if (!pPin || ulPinLen > MAX_PIN_LEN) {
		set_login_flags(userType, flags);
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_INCORRECT));
		rc = CKR_PIN_INCORRECT;
		goto done;
	}
	
	/* PKCS #11 v2.01 requires that all sessions have the same login status:
	 * --> all sessions are public, all are SO or all are USER
	 */
	if (userType == CKU_USER) {
		if (session_mgr_so_session_exists()) {
			TRACE_ERROR("%s\n",
				   ock_err(ERR_USER_ANOTHER_ALREADY_LOGGED_IN));
			rc = CKR_USER_ANOTHER_ALREADY_LOGGED_IN;
		}
		if (session_mgr_user_session_exists()) {
			TRACE_ERROR("%s\n",ock_err(ERR_USER_ALREADY_LOGGED_IN));
			rc = CKR_USER_ALREADY_LOGGED_IN;
		}
	}
	else if (userType == CKU_SO) {
		if (session_mgr_user_session_exists()) {
			TRACE_ERROR("%s\n",
				   ock_err(ERR_USER_ANOTHER_ALREADY_LOGGED_IN));
			rc = CKR_USER_ANOTHER_ALREADY_LOGGED_IN;
		}
		if (session_mgr_so_session_exists()) {
			TRACE_ERROR("%s\n",ock_err(ERR_USER_ALREADY_LOGGED_IN));
			rc = CKR_USER_ALREADY_LOGGED_IN;
		}
		if (session_mgr_readonly_session_exists()) {
			TRACE_ERROR("%s\n",
				    ock_err(ERR_SESSION_READ_ONLY_EXISTS));
			rc = CKR_SESSION_READ_ONLY_EXISTS;
		}
	}
	else {
		rc = CKR_USER_TYPE_INVALID;
		TRACE_ERROR("%s\n", ock_err(ERR_USER_TYPE_INVALID));
	}
	if (rc != CKR_OK)
		goto done;


	if (userType == CKU_USER) {
		if (*flags & CKF_USER_PIN_LOCKED) {
			TRACE_ERROR("%s\n", ock_err(ERR_PIN_LOCKED));
			rc = CKR_PIN_LOCKED;
			goto done;
		}

		/* Check if token has a specific handler for this, otherwise 
		 * fall back to default behaviour.
		 */
		if (token_specific.t_login) {
			// call the pluggable login function here - KEY
			rc = token_specific.t_login(sess, userType, pPin,
						    ulPinLen);
			if (rc == CKR_OK) {
				*flags &= ~(CKF_USER_PIN_LOCKED |
				          CKF_USER_PIN_FINAL_TRY |
					  CKF_USER_PIN_COUNT_LOW);
			} else if (rc == CKR_PIN_INCORRECT) {
				set_login_flags(userType, flags);
			}
			goto done;
		}

		if (memcmp(nv_token_data->user_pin_sha,
			   "00000000000000000000", SHA1_HASH_SIZE) == 0) {
			TRACE_ERROR("%s\n",
				    ock_err(ERR_USER_PIN_NOT_INITIALIZED));
			rc = CKR_USER_PIN_NOT_INITIALIZED;
			goto done;
		}

		rc = compute_sha1(pPin, ulPinLen, hash_sha);
		if (memcmp(nv_token_data->user_pin_sha, hash_sha,
			   SHA1_HASH_SIZE) != 0) {
			set_login_flags(userType, flags);
			TRACE_ERROR("%s\n", ock_err(ERR_PIN_INCORRECT));
			rc = CKR_PIN_INCORRECT;
			goto done;
		}
		/* Successful login, clear flags */
		*flags &=	~(CKF_USER_PIN_LOCKED |
				  CKF_USER_PIN_FINAL_TRY |
				  CKF_USER_PIN_COUNT_LOW);

		compute_md5( pPin, ulPinLen, user_pin_md5 );
		memset( so_pin_md5, 0x0, MD5_HASH_SIZE );

		rc = load_masterkey_user();
		if (rc != CKR_OK){
			TRACE_DEVEL("Failed to load user's masterkey.\n");
			goto done;
		}

		/* no need to return error here, we load the token data
		 * we can and syslog the rest
		 */
		load_private_token_objects();

		XProcLock();
		global_shm->priv_loaded = TRUE;
		XProcUnLock();
	} else {
		if (*flags & CKF_SO_PIN_LOCKED) {
			TRACE_ERROR("%s\n", ock_err(ERR_PIN_LOCKED));
			rc = CKR_PIN_LOCKED;
			goto done;
		}

		/* Check if token has a specific handler for this, otherwise 
		 * fall back to default behaviour.
		 */
		if (token_specific.t_login) {
			/* call the pluggable login function here - KEY */
			rc = token_specific.t_login(sess, userType,
						    pPin, ulPinLen);
			if (rc == CKR_OK) {
				*flags &= ~(CKF_SO_PIN_LOCKED |
					  CKF_SO_PIN_FINAL_TRY |
					  CKF_SO_PIN_COUNT_LOW);
			} else if (rc == CKR_PIN_INCORRECT) {
				set_login_flags(userType, flags);
			}
			goto done;
		}

		rc = compute_sha1(pPin, ulPinLen, hash_sha);
		if (memcmp(nv_token_data->so_pin_sha, hash_sha, SHA1_HASH_SIZE) != 0) {
			set_login_flags(userType, flags);
			TRACE_ERROR("%s\n", ock_err(ERR_PIN_INCORRECT));
			rc = CKR_PIN_INCORRECT;
			goto done;
		}
		/* Successful login, clear flags */
		*flags &= ~(CKF_SO_PIN_LOCKED | CKF_SO_PIN_FINAL_TRY |
			    CKF_SO_PIN_COUNT_LOW);

		compute_md5(pPin, ulPinLen, so_pin_md5);
		memset(user_pin_md5, 0x0, MD5_HASH_SIZE);

		rc = load_masterkey_so();
		if (rc != CKR_OK)
			TRACE_DEVEL("Failed to load SO's masterkey.\n");
	}

done:
 	if (rc == CKR_OK) {
		rc = session_mgr_login_all(userType);
		if (rc != CKR_OK)
			TRACE_DEVEL("session_mgr_login_all failed.\n");
	}

	TRACE_INFO("C_Login: rc = 0x%08lx\n", rc);
	if (sess)
		save_token_data(sess->session_info.slotID);
	MY_UnlockMutex(&login_mutex);
	return rc;
}


CK_RV SC_Logout(ST_SESSION_HANDLE *sSession)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}
	
	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}
	
	/* all sessions have the same state so we just have to check one */
	if (session_mgr_public_session_exists()) {
		TRACE_ERROR("%s\n", ock_err(ERR_USER_NOT_LOGGED_IN));
		rc = CKR_USER_NOT_LOGGED_IN;
		goto done;
	}

	rc = session_mgr_logout_all();
	if (rc != CKR_OK)
		TRACE_DEVEL("session_mgr_logout_all failed.\n");

	/* Check if token has a specific handler for this, otherwise fall back
	 * to default behaviour.
	 */
	if (token_specific.t_logout) {
		rc = token_specific.t_logout();
		goto done;
	}

	memset(user_pin_md5, 0x0, MD5_HASH_SIZE);
	memset(so_pin_md5, 0x0, MD5_HASH_SIZE);
	
	object_mgr_purge_private_token_objects();
	
done:
	TRACE_INFO("C_Logout: rc = 0x%08lx\n", rc);
	return rc;
}


CK_RV SC_CreateObject(ST_SESSION_HANDLE *sSession, CK_ATTRIBUTE_PTR pTemplate,
		      CK_ULONG ulCount, CK_OBJECT_HANDLE_PTR phObject)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (pin_expired(&sess->session_info, nv_token_data->token_info.flags)) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}

	rc = object_mgr_add(sess, pTemplate, ulCount, phObject);
	if (rc != CKR_OK)
		TRACE_DEVEL("object_mgr_add() failed.\n");

done:
	TRACE_INFO("C_CreateObject: rc = 0x%08lx\n", rc);

#ifdef DEBUG
	int i;

	for (i = 0; i < ulCount; i++) {
		if (pTemplate[i].type == CKA_CLASS) {
			TRACE_DEBUG("Object Type:  0x%02lx\n",
				      *((CK_ULONG *) pTemplate[i].pValue));
		}
	}
	if (rc == CKR_OK)
		TRACE_DEBUG("Handle:  %lu\n", *phObject);
#endif

	return rc;
}


CK_RV  SC_CopyObject(ST_SESSION_HANDLE *sSession, CK_OBJECT_HANDLE hObject,
		     CK_ATTRIBUTE_PTR pTemplate, CK_ULONG ulCount,
		     CK_OBJECT_HANDLE_PTR phNewObject)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}
   
	if (pin_expired(&sess->session_info, nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}
   
	rc = object_mgr_copy(sess, pTemplate, ulCount, hObject, phNewObject);
	if (rc != CKR_OK)
		TRACE_DEVEL("object_mgr_copy() failed\n");

done:
	TRACE_INFO("C_CopyObject:rc = 0x%08lx,old handle = %lu,new handle = %lu\n",
		   rc, hObject, *phNewObject);
	return rc;
}


CK_RV SC_DestroyObject(ST_SESSION_HANDLE *sSession, CK_OBJECT_HANDLE hObject)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (pin_expired(&sess->session_info, nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}
   
	rc = object_mgr_destroy_object(sess, hObject);
	if (rc != CKR_OK)
		TRACE_DEVEL("object_mgr_destroy_object() failed\n");
done:
	TRACE_INFO("C_DestroyObject: rc = 0x%08lx, handle = %lu\n", rc, hObject);
	return rc;
}


CK_RV SC_GetObjectSize(ST_SESSION_HANDLE *sSession, CK_OBJECT_HANDLE hObject,
		       CK_ULONG_PTR pulSize)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	rc = object_mgr_get_object_size(hObject, pulSize);
	if (rc != CKR_OK)
		TRACE_ERROR("object_mgr_get_object_size() failed.\n");

done:
	TRACE_INFO("C_GetObjectSize: rc = 0x%08lx, handle = %lu\n", rc, hObject);
	return rc;
}


CK_RV SC_GetAttributeValue(ST_SESSION_HANDLE *sSession,
			   CK_OBJECT_HANDLE hObject, CK_ATTRIBUTE_PTR pTemplate,
			   CK_ULONG ulCount)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	rc = object_mgr_get_attribute_values(sess, hObject, pTemplate, ulCount);
	if (rc != CKR_OK)
		TRACE_DEVEL("object_mgr_get_attribute_value() failed.\n");

done:
	TRACE_INFO("C_GetAttributeValue: rc = 0x%08lx, handle = %lu\n",
		    rc, hObject);

#ifdef DEBUG
	CK_ATTRIBUTE *attr = NULL;
	CK_BYTE *ptr = NULL;
	int i;

	attr = pTemplate;
	for (i = 0; i < ulCount; i++, attr++) {
		ptr = (CK_BYTE *)attr->pValue;

		TRACE_DEBUG("%d: Attribute type: 0x%08lx, Value Length: %lu\n",
			    i, attr->type, attr->ulValueLen);

		if (attr->ulValueLen != (CK_ULONG)(-1) && (ptr != NULL))
			TRACE_DEBUG("First 4 bytes: %02x %02x %02x %02x\n",
				    ptr[0], ptr[1], ptr[2], ptr[3]);
	}
#endif
	return rc;
}


CK_RV SC_SetAttributeValue(ST_SESSION_HANDLE *sSession,
			   CK_OBJECT_HANDLE hObject, CK_ATTRIBUTE_PTR pTemplate,
			   CK_ULONG ulCount)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	rc = object_mgr_set_attribute_values(sess, hObject, pTemplate, ulCount);
	if (rc != CKR_OK)
		TRACE_DEVEL("object_mgr_set_attribute_values() failed.\n");

done:
	TRACE_INFO("C_SetAttributeValue: rc = 0x%08lx, handle = %lu\n",
		   rc, hObject);
#ifdef DEBUG
	CK_ATTRIBUTE *attr = NULL;
	int i;

	attr = pTemplate;
	for (i = 0; i < ulCount; i++, attr++) {
		CK_BYTE *ptr = (CK_BYTE *)attr->pValue;

		TRACE_DEBUG("%d: Attribute type: 0x%08lx, Value Length: %lu\n",
			     i, attr->type, attr->ulValueLen);

		if (attr->ulValueLen != (CK_ULONG)(-1) && (ptr != NULL))
			TRACE_DEBUG("First 4 bytes: %02x %02x %02x %02x\n",
				     ptr[0], ptr[1], ptr[2], ptr[3]);
	}
#endif

	return rc;
}


CK_RV SC_FindObjectsInit(ST_SESSION_HANDLE *sSession,
			 CK_ATTRIBUTE_PTR pTemplate, CK_ULONG ulCount)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (pin_expired(&sess->session_info, nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}
   
	if (sess->find_active == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_ACTIVE));
		rc = CKR_OPERATION_ACTIVE;
		goto done;
	}

	rc = object_mgr_find_init(sess, pTemplate, ulCount);

done:
	TRACE_INFO("C_FindObjectsInit:  rc = 0x%08lx\n", rc);

#ifdef DEBUG
	CK_ATTRIBUTE *attr = NULL;
	int i;

	attr = pTemplate;
	for (i = 0; i < ulCount; i++, attr++) {
		CK_BYTE *ptr = (CK_BYTE *)attr->pValue;

		TRACE_DEBUG("%d: Attribute type: 0x%08lx, Value Length: %lu\n",
			    i, attr->type, attr->ulValueLen);

		if (attr->ulValueLen != (CK_ULONG)(-1) && (ptr != NULL))
			TRACE_DEBUG("First 4 bytes: %02x %02x %02x %02x\n",
				    ptr[0], ptr[1], ptr[2], ptr[3]);
	}
#endif

	return rc;
}


CK_RV SC_FindObjects(ST_SESSION_HANDLE *sSession, CK_OBJECT_HANDLE_PTR phObject,
		     CK_ULONG ulMaxObjectCount, CK_ULONG_PTR pulObjectCount)
{
	SESSION *sess = NULL;
	CK_ULONG count = 0;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!phObject || !pulObjectCount) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->find_active == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		rc = CKR_OPERATION_NOT_INITIALIZED;
		goto done;
	}

	if (!sess->find_list) {
		TRACE_DEVEL("sess->find_list is NULL.\n");
		rc = CKR_FUNCTION_FAILED;
		goto done;
	}
	count = MIN(ulMaxObjectCount, (sess->find_count - sess->find_idx));

	memcpy(phObject, sess->find_list + sess->find_idx,
	       count * sizeof(CK_OBJECT_HANDLE));
	*pulObjectCount = count;

	sess->find_idx += count;
	rc = CKR_OK;

done:
	TRACE_INFO("C_FindObjects: rc = 0x%08lx, returned %lu objects\n",
		    rc, count);
	return rc;
}


CK_RV SC_FindObjectsFinal(ST_SESSION_HANDLE *sSession)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->find_active == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		rc = CKR_OPERATION_NOT_INITIALIZED;
		goto done;
	}

	if (sess->find_list)
		free(sess->find_list);

	sess->find_list = NULL;
	sess->find_len = 0;
	sess->find_idx = 0;
	sess->find_active = FALSE;

	rc = CKR_OK;

done:
	TRACE_INFO("C_FindObjectsFinal: rc = 0x%08lx\n", rc);
	return rc;
}


CK_RV SC_EncryptInit(ST_SESSION_HANDLE *sSession, CK_MECHANISM_PTR pMechanism,
		     CK_OBJECT_HANDLE hKey)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pMechanism) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	rc = valid_mech(pMechanism, CKF_ENCRYPT);
	if (rc != CKR_OK)
		goto done;

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (pin_expired(&sess->session_info, nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}

	if (sess->encr_ctx.active == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_ACTIVE));
		rc = CKR_OPERATION_ACTIVE;
		goto done;
	}

	rc = encr_mgr_init(sess, &sess->encr_ctx, OP_ENCRYPT_INIT,
			   pMechanism, hKey);
done:
	TRACE_INFO("C_EncryptInit: rc = 0x%08lx, sess = %ld, mech = 0x%lx\n",
		   rc, (sess == NULL) ? -1 : (CK_LONG)sess->handle,
		   (pMechanism ? pMechanism->mechanism : -1));

	return rc;
}


CK_RV SC_Encrypt(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pData,
		 CK_ULONG ulDataLen, CK_BYTE_PTR pEncryptedData,
		 CK_ULONG_PTR pulEncryptedDataLen)
{
	SESSION *sess = NULL;
	CK_BBOOL length_only = FALSE;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pData || !pulEncryptedDataLen) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->encr_ctx.active == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		rc = CKR_OPERATION_NOT_INITIALIZED;
		goto done;
	}

	if (!pEncryptedData)
		length_only = TRUE;

	rc = encr_mgr_encrypt(sess, length_only, &sess->encr_ctx, pData,
			      ulDataLen, pEncryptedData, pulEncryptedDataLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("encr_mgr_encrypt() failed.\n");

done:
	if (rc != CKR_BUFFER_TOO_SMALL && (rc != CKR_OK || length_only != TRUE))
		encr_mgr_cleanup( &sess->encr_ctx );

	TRACE_INFO("C_Encrypt: rc = 0x%08lx, sess = %ld, amount = %lu\n",
		   rc, (sess == NULL) ? -1 : (CK_LONG)sess->handle, ulDataLen);

	return rc;
}


CK_RV SC_EncryptUpdate(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pPart,
		       CK_ULONG ulPartLen, CK_BYTE_PTR pEncryptedPart,
		       CK_ULONG_PTR pulEncryptedPartLen)
{
	SESSION *sess = NULL;
	CK_BBOOL length_only = FALSE;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if ((!pPart && ulPartLen != 0) || !pulEncryptedPartLen) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->encr_ctx.active == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		rc = CKR_OPERATION_NOT_INITIALIZED;
		goto done;
	}

	if (!pEncryptedPart)
		length_only = TRUE;

	rc = encr_mgr_encrypt_update(sess, length_only, &sess->encr_ctx,
				     pPart, ulPartLen, pEncryptedPart,
				     pulEncryptedPartLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("encr_mgr_encrypt_update() failed.\n");

done:
	if (rc != CKR_OK && rc != CKR_BUFFER_TOO_SMALL && sess != NULL)
		encr_mgr_cleanup( &sess->encr_ctx );

	TRACE_INFO("C_EncryptUpdate: rc = 0x%08lx, sess = %ld, amount = %lu\n",
		   rc, (sess == NULL) ? -1 : (CK_LONG) sess->handle, ulPartLen);

	return rc;
}


/* I think RSA goofed when designing the specification for C_EncryptFinal.
 * This function is supposed to follow the Cryptoki standard that if
 * pLastEncryptedPart == NULL then the user is requesting only the length
 * of the output.
 *
 * But it's quite possible that no output will be returned (say the user
 * specifies a total of 64 bytes of input data throughout the multi-part
 * encryption).  The same thing can happen during an EncryptUpdate.
 *
 * ie:
 *
 *    1) user calls C_EncryptFinal to get the needed length
 *       --> we return "0 bytes required"
 *    2) user passes in a NULL pointer for pLastEncryptedPart
 *       --> we think the user is requesting the length again <--
 *
 * So the user needs to pass in a non-NULL pointer even though we're not
 * going to return anything in it.  It would have been cleaner if RSA would
 * have simply included a "give-me-the-length-only flag" as an argument.
 */
CK_RV SC_EncryptFinal(ST_SESSION_HANDLE *sSession,
		      CK_BYTE_PTR pLastEncryptedPart,
		      CK_ULONG_PTR pulLastEncryptedPartLen)
{
	SESSION *sess = NULL;
	CK_BBOOL length_only = FALSE;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pulLastEncryptedPartLen) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->encr_ctx.active == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		rc = CKR_OPERATION_NOT_INITIALIZED;
		goto done;
	}

	if (!pLastEncryptedPart)
		length_only = TRUE;

	rc = encr_mgr_encrypt_final(sess,length_only, &sess->encr_ctx,
				    pLastEncryptedPart,
				    pulLastEncryptedPartLen);
	if (rc != CKR_OK)
		TRACE_ERROR("encr_mgr_encrypt_final() failed.\n");

done:
	if (rc != CKR_BUFFER_TOO_SMALL && (rc != CKR_OK || length_only != TRUE))
		encr_mgr_cleanup( &sess->encr_ctx );

	TRACE_INFO("C_EncryptFinal: rc = 0x%08lx, sess = %ld\n",
		   rc, (sess == NULL) ? -1 : (CK_LONG) sess->handle);

	return rc;
}


CK_RV SC_DecryptInit(ST_SESSION_HANDLE *sSession, CK_MECHANISM_PTR pMechanism,
		     CK_OBJECT_HANDLE hKey)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pMechanism) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	rc = valid_mech(pMechanism, CKF_DECRYPT);
	if (rc != CKR_OK)
		goto done;

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (pin_expired(&sess->session_info, nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}

	if (sess->decr_ctx.active == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_ACTIVE));
		rc = CKR_OPERATION_ACTIVE;
		goto done;
	}

	rc = decr_mgr_init(sess, &sess->decr_ctx, OP_DECRYPT_INIT,
			   pMechanism, hKey);
	if (rc != CKR_OK)
		TRACE_DEVEL("decr_mgr_init() failed.\n");

done:
	TRACE_INFO("C_DecryptInit: rc = 0x%08lx, sess = %ld, mech = 0x%lx\n",
		   rc, (sess == NULL) ? -1 : (CK_LONG)sess->handle,
		   (pMechanism ? pMechanism->mechanism : -1));

	return rc;
}


CK_RV SC_Decrypt(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pEncryptedData,
		 CK_ULONG ulEncryptedDataLen, CK_BYTE_PTR pData,
		 CK_ULONG_PTR pulDataLen)
{
	SESSION *sess = NULL;
	CK_BBOOL length_only = FALSE;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pEncryptedData || !pulDataLen) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->decr_ctx.active == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		rc = CKR_OPERATION_NOT_INITIALIZED;
		goto done;
	}

	if (!pData)
		length_only = TRUE;

	rc = decr_mgr_decrypt(sess, length_only, &sess->decr_ctx,
			      pEncryptedData, ulEncryptedDataLen, pData,
			      pulDataLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("decr_mgr_decrypt() failed.\n");

done:
	if (rc != CKR_BUFFER_TOO_SMALL && (rc != CKR_OK || length_only != TRUE))
		decr_mgr_cleanup( &sess->decr_ctx );

	TRACE_INFO("C_Decrypt: rc = 0x%08lx, sess = %ld, amount = %lu\n",
		   rc, (sess == NULL) ? -1 : (CK_LONG)sess->handle,
		   ulEncryptedDataLen);

	return rc;
}


CK_RV SC_DecryptUpdate(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pEncryptedPart,
		       CK_ULONG ulEncryptedPartLen, CK_BYTE_PTR pPart,
		       CK_ULONG_PTR pulPartLen)
{
	SESSION *sess = NULL;
	CK_BBOOL length_only = FALSE;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if ((!pEncryptedPart && ulEncryptedPartLen != 0) || !pulPartLen) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->decr_ctx.active == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		rc = CKR_OPERATION_NOT_INITIALIZED;
		goto done;
	}

	if (!pPart)
		length_only = TRUE;

	rc = decr_mgr_decrypt_update(sess, length_only, &sess->decr_ctx,
				     pEncryptedPart,ulEncryptedPartLen,
				     pPart, pulPartLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("decr_mgr_decrypt_update() failed.\n");

done:
	if (rc != CKR_OK && rc != CKR_BUFFER_TOO_SMALL && sess != NULL)
		decr_mgr_cleanup( &sess->decr_ctx );

	TRACE_INFO("C_DecryptUpdate: rc = 0x%08lx, sess = %ld, amount = %lu\n",
		   rc, (sess == NULL) ? -1 : (CK_LONG)sess->handle,
		   ulEncryptedPartLen);

	return rc;
}


CK_RV SC_DecryptFinal(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pLastPart,
		      CK_ULONG_PTR pulLastPartLen)
{
	SESSION *sess = NULL;
	CK_BBOOL length_only = FALSE;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pulLastPartLen) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->decr_ctx.active == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		rc = CKR_OPERATION_NOT_INITIALIZED;
		goto done;
	}

	if (!pLastPart)
		length_only = TRUE;

	rc = decr_mgr_decrypt_final(sess, length_only, &sess->decr_ctx,
				    pLastPart, pulLastPartLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("decr_mgr_decrypt_final() failed.\n");
done:
	if (rc != CKR_BUFFER_TOO_SMALL && (rc != CKR_OK || length_only != TRUE))
		decr_mgr_cleanup( &sess->decr_ctx );

	TRACE_INFO("C_DecryptFinal:  rc = 0x%08lx, sess = %ld, amount = %lu\n",
		   rc, (sess == NULL) ? -1 : (CK_LONG)sess->handle,
		   (pulLastPartLen ? *pulLastPartLen : 0));

	return rc;
}


CK_RV SC_DigestInit(ST_SESSION_HANDLE *sSession, CK_MECHANISM_PTR pMechanism)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}
	if (!pMechanism) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	rc = valid_mech(pMechanism, CKF_DIGEST);
	if (rc != CKR_OK)
		goto done;

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (pin_expired(&sess->session_info, nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}
   
	if (sess->digest_ctx.active == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_ACTIVE));
		rc = CKR_OPERATION_ACTIVE;
		goto done;
	}

	rc = digest_mgr_init(sess, &sess->digest_ctx, pMechanism);
	if (rc != CKR_OK)
		TRACE_DEVEL("digest_mgr_init() failed.\n");

done:
	TRACE_INFO("C_DigestInit: rc = 0x%08lx, sess = %ld, mech = %lu\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle,
		   (pMechanism ? pMechanism->mechanism : -1));

	return rc;
}


CK_RV SC_Digest(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pData,
		CK_ULONG ulDataLen, CK_BYTE_PTR pDigest,
		CK_ULONG_PTR pulDigestLen)
{
	SESSION *sess = NULL;
	CK_BBOOL length_only = FALSE;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	/* Netscape has been known to pass a null pData to DigestUpdate
	 * but never for Digest.  It doesn't really make sense to allow it here
	 */
	if (!pData || !pulDigestLen) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->digest_ctx.active == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		rc = CKR_OPERATION_NOT_INITIALIZED;
		goto done;
	}

	if (!pDigest)
		length_only = TRUE;

	rc = digest_mgr_digest(sess, length_only, &sess->digest_ctx, pData,
			       ulDataLen, pDigest, pulDigestLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("digest_mgr_digest() failed.\n");

done:
	TRACE_INFO("C_Digest: rc = 0x%08lx, sess = %ld, datalen = %lu\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle, ulDataLen);

	return rc;
}


CK_RV SC_DigestUpdate(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pPart,
		      CK_ULONG ulPartLen)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pPart && ulPartLen != 0) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->digest_ctx.active == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		rc = CKR_OPERATION_NOT_INITIALIZED;
		goto done;
	}

	/* If there is data to hash, do so. */
	if (ulPartLen) {
		rc = digest_mgr_digest_update(sess, &sess->digest_ctx, pPart,
					      ulPartLen);
		if (rc != CKR_OK)
			TRACE_DEVEL("digest_mgr_digest_update() failed.\n");
	}
done:
	TRACE_INFO("C_DigestUpdate: rc = %08lx, sess = %ld, datalen = %lu\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle, ulPartLen);

	return rc;
}


CK_RV SC_DigestKey(ST_SESSION_HANDLE *sSession, CK_OBJECT_HANDLE hKey)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->digest_ctx.active == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		rc = CKR_OPERATION_NOT_INITIALIZED;
		goto done;
	}

	rc = digest_mgr_digest_key(sess, &sess->digest_ctx, hKey);
	if (rc != CKR_OK)
		TRACE_DEVEL("digest_mgr_digest_key() failed.\n");

done:
	TRACE_INFO("C_DigestKey: rc = %08lx, sess = %ld, key = %lu\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle, hKey);

	return rc;
}


CK_RV SC_DigestFinal(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pDigest,
		     CK_ULONG_PTR pulDigestLen)
{
	SESSION *sess = NULL;
	CK_BBOOL length_only = FALSE;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pulDigestLen) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->digest_ctx.active == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		rc = CKR_OPERATION_NOT_INITIALIZED;
		goto done;
	}

	if (!pDigest)
		length_only = TRUE;

	rc = digest_mgr_digest_final(sess, length_only, &sess->digest_ctx,
				     pDigest, pulDigestLen);
	if (rc != CKR_OK)
		TRACE_ERROR("digest_mgr_digest_final() failed.\n");

done:
	TRACE_INFO("C_DigestFinal: rc = %08lx, sess = %ld\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle);

	return rc;
}


CK_RV SC_SignInit(ST_SESSION_HANDLE *sSession, CK_MECHANISM_PTR pMechanism,
		  CK_OBJECT_HANDLE hKey)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pMechanism ) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	rc = valid_mech(pMechanism, CKF_SIGN);
	if (rc != CKR_OK)
		goto done;

	if (pin_expired(&sess->session_info, nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}
   
	if (sess->sign_ctx.active == TRUE) {
		rc = CKR_OPERATION_ACTIVE;
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_ACTIVE));
		goto done;
	}

	rc = sign_mgr_init(sess, &sess->sign_ctx, pMechanism, FALSE, hKey);
	if (rc != CKR_OK)
		TRACE_DEVEL("sign_mgr_init() failed.\n");

done:
	TRACE_INFO("C_SignInit: rc = %08lx, sess = %ld, mech = %lx\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle,
		   (pMechanism ? pMechanism->mechanism : -1));

	return rc;
}


CK_RV SC_Sign(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pData,
	      CK_ULONG ulDataLen, CK_BYTE_PTR pSignature,
	      CK_ULONG_PTR pulSignatureLen)
{
	SESSION *sess = NULL;
	CK_BBOOL length_only = FALSE;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pData || !pulSignatureLen) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->sign_ctx.active == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		rc = CKR_OPERATION_NOT_INITIALIZED;
		goto done;
	}

	if (!pSignature)
		length_only = TRUE;

	rc = sign_mgr_sign(sess, length_only, &sess->sign_ctx, pData,
			   ulDataLen, pSignature, pulSignatureLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("sign_mgr_sign() failed.\n");

done:
	if (rc != CKR_BUFFER_TOO_SMALL && (rc != CKR_OK || length_only != TRUE))
		sign_mgr_cleanup(&sess->sign_ctx);

	TRACE_INFO("C_Sign: rc = %08lx, sess = %ld, datalen = %lu\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle, ulDataLen);

	return rc;
}


CK_RV SC_SignUpdate(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pPart,
		    CK_ULONG ulPartLen)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pPart && ulPartLen != 0) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->sign_ctx.active == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		rc = CKR_OPERATION_NOT_INITIALIZED;
		goto done;
	}

	rc = sign_mgr_sign_update(sess, &sess->sign_ctx, pPart, ulPartLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("sign_mgr_sign_update() failed.\n");

done:
	if (rc != CKR_OK)
		sign_mgr_cleanup(&sess->sign_ctx);

	TRACE_INFO("C_SignUpdate: rc = %08lx, sess = %ld, datalen = %lu\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle, ulPartLen);

	return rc;
}


CK_RV SC_SignFinal(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pSignature,
		   CK_ULONG_PTR pulSignatureLen)
{
	SESSION *sess = NULL;
	CK_BBOOL length_only = FALSE;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pulSignatureLen) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->sign_ctx.active == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		rc = CKR_OPERATION_NOT_INITIALIZED;
		goto done;
	}

	if (!pSignature)
		length_only = TRUE;

	rc = sign_mgr_sign_final(sess, length_only, &sess->sign_ctx,
				 pSignature, pulSignatureLen);
	if (rc != CKR_OK)
		TRACE_ERROR("sign_mgr_sign_final() failed.\n");

done:
	if (rc != CKR_BUFFER_TOO_SMALL && (rc != CKR_OK || length_only != TRUE))
		sign_mgr_cleanup(&sess->sign_ctx);

	TRACE_INFO("C_SignFinal: rc = %08lx, sess = %ld\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle);

	return rc;
}


CK_RV SC_SignRecoverInit(ST_SESSION_HANDLE *sSession,
			 CK_MECHANISM_PTR pMechanism, CK_OBJECT_HANDLE hKey)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}
	if (!pMechanism ){
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	rc = valid_mech(pMechanism, CKF_SIGN_RECOVER);
	if (rc != CKR_OK)
		goto done;

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (pin_expired(&sess->session_info, nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}
   
	if (sess->sign_ctx.active == TRUE) {
		rc = CKR_OPERATION_ACTIVE;
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_ACTIVE));
		goto done;
	}

	rc = sign_mgr_init(sess, &sess->sign_ctx, pMechanism, TRUE, hKey);
	if (rc != CKR_OK)
		TRACE_DEVEL("sign_mgr_init() failed.\n");

done:
	TRACE_INFO("C_SignRecoverInit: rc = %08lx, sess = %ld, mech = %lx\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle,
		   (pMechanism ? pMechanism->mechanism : -1));

	return rc;
}


CK_RV SC_SignRecover(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pData,
		     CK_ULONG ulDataLen, CK_BYTE_PTR pSignature,
		     CK_ULONG_PTR pulSignatureLen)
{
	SESSION *sess = NULL;
	CK_BBOOL length_only = FALSE;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pData || !pulSignatureLen) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if ((sess->sign_ctx.active == FALSE) ||
	    (sess->sign_ctx.recover == FALSE)) {
		rc = CKR_OPERATION_NOT_INITIALIZED;
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		goto done;
	}

	if (!pSignature)
		length_only = TRUE;

	rc = sign_mgr_sign_recover(sess, length_only, &sess->sign_ctx, pData,
				   ulDataLen, pSignature, pulSignatureLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("sign_mgr_sign_recover() failed.\n");

done:
	if (rc != CKR_BUFFER_TOO_SMALL && (rc != CKR_OK || length_only != TRUE))
		sign_mgr_cleanup(&sess->sign_ctx);

	TRACE_INFO("C_SignRecover: rc = %08lx, sess = %ld, datalen = %lu\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle, ulDataLen);

	return rc;
}


CK_RV SC_VerifyInit(ST_SESSION_HANDLE *sSession, CK_MECHANISM_PTR pMechanism,
		    CK_OBJECT_HANDLE hKey)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}
	if (!pMechanism ) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	rc = valid_mech(pMechanism, CKF_VERIFY);
	if (rc != CKR_OK)
		goto done;

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (pin_expired(&sess->session_info,
	    nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}
   
	if (sess->verify_ctx.active == TRUE) {
		rc = CKR_OPERATION_ACTIVE;
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_ACTIVE));
		goto done;
	}

	rc = verify_mgr_init(sess, &sess->verify_ctx, pMechanism, FALSE, hKey);
	if (rc != CKR_OK)
		TRACE_DEVEL("verify_mgr_init() failed.\n");

done:
	TRACE_INFO("C_VerifyInit: rc = %08lx, sess = %ld, mech = %lx\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle,
		   (pMechanism ? pMechanism->mechanism : -1));

	return rc;
}


CK_RV SC_Verify(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pData,
		CK_ULONG ulDataLen, CK_BYTE_PTR pSignature,
		CK_ULONG ulSignatureLen)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pData || !pSignature) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->verify_ctx.active == FALSE) {
		rc = CKR_OPERATION_NOT_INITIALIZED;
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		goto done;
	}

	rc = verify_mgr_verify(sess, &sess->verify_ctx, pData, ulDataLen,
			       pSignature, ulSignatureLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("verify_mgr_verify() failed.\n");

done:
	verify_mgr_cleanup(&sess->verify_ctx);

	TRACE_INFO("C_Verify: rc = %08lx, sess = %ld, datalen = %lu\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle, ulDataLen);

	return rc;
}


CK_RV SC_VerifyUpdate(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pPart,
		      CK_ULONG ulPartLen)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pPart && ulPartLen != 0) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->verify_ctx.active == FALSE) {
		rc = CKR_OPERATION_NOT_INITIALIZED;
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		goto done;
	}

	rc = verify_mgr_verify_update(sess, &sess->verify_ctx, pPart,
				      ulPartLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("verify_mgr_verify_update() failed.\n");

done:
	if (rc != CKR_OK)
		verify_mgr_cleanup(&sess->verify_ctx);

	TRACE_INFO("C_VerifyUpdate: rc = %08lx, sess = %ld, datalen = %lu\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle, ulPartLen);

	return rc;
}


CK_RV SC_VerifyFinal(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pSignature,
		     CK_ULONG ulSignatureLen)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pSignature) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (sess->verify_ctx.active == FALSE) {
		rc = CKR_OPERATION_NOT_INITIALIZED;
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		goto done;
	}

	rc = verify_mgr_verify_final(sess, &sess->verify_ctx, pSignature,
				     ulSignatureLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("verify_mgr_verify_final() failed.\n");

 done:
	verify_mgr_cleanup(&sess->verify_ctx);

	TRACE_INFO("C_VerifyFinal: rc = %08lx, sess = %ld\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle);

	return rc;
}


CK_RV SC_VerifyRecoverInit(ST_SESSION_HANDLE *sSession,
			   CK_MECHANISM_PTR pMechanism, CK_OBJECT_HANDLE hKey)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}
	if (!pMechanism) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	rc = valid_mech(pMechanism, CKF_VERIFY_RECOVER);
	if (rc != CKR_OK)
		goto done;

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (pin_expired(&sess->session_info,
			nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}
   
	if (sess->verify_ctx.active == TRUE) {
		rc = CKR_OPERATION_ACTIVE;
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_ACTIVE));
		goto done;
	}

	rc = verify_mgr_init(sess, &sess->verify_ctx, pMechanism, TRUE, hKey);
	if (rc != CKR_OK)
		TRACE_DEVEL("verify_mgr_init() failed.\n");

done:
	TRACE_INFO("C_VerifyRecoverInit: rc = %08lx, sess = %ld, mech = %lx\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle,
		   (pMechanism ? pMechanism->mechanism : -1));

	return rc;
}


CK_RV SC_VerifyRecover(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pSignature,
		       CK_ULONG ulSignatureLen, CK_BYTE_PTR pData,
		       CK_ULONG_PTR pulDataLen)
{
	SESSION *sess = NULL;
	CK_BBOOL length_only = FALSE;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pSignature || !pulDataLen) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if ((sess->verify_ctx.active == FALSE) ||
	    (sess->verify_ctx.recover == FALSE)) {
		rc = CKR_OPERATION_NOT_INITIALIZED;
		TRACE_ERROR("%s\n", ock_err(ERR_OPERATION_NOT_INITIALIZED));
		goto done;
	}

	if (!pData)
		length_only = TRUE;

	rc = verify_mgr_verify_recover(sess, length_only, &sess->verify_ctx,
				       pSignature, ulSignatureLen, pData,
				       pulDataLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("verify_mgr_verify_recover() failed.\n");

done:
	if (rc != CKR_BUFFER_TOO_SMALL && (rc != CKR_OK || length_only != TRUE))
		verify_mgr_cleanup(&sess->verify_ctx);

	TRACE_INFO("C_VerifyRecover: rc = %08lx, sess = %ld, recover len = %lu, "
		   "length_only = %d\n", rc,
		   (sess == NULL)?-1:(CK_LONG)sess->handle, (pulDataLen ? *pulDataLen : 0),
		   length_only);

	return rc;
}


CK_RV SC_DigestEncryptUpdate(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pPart,
			     CK_ULONG ulPartLen, CK_BYTE_PTR pEncryptedPart,
			     CK_ULONG_PTR pulEncryptedPartLen)
{
	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		return CKR_CRYPTOKI_NOT_INITIALIZED;
	}
	TRACE_ERROR("%s\n", ock_err(ERR_FUNCTION_NOT_SUPPORTED));
	return CKR_FUNCTION_NOT_SUPPORTED;
}


CK_RV SC_DecryptDigestUpdate(ST_SESSION_HANDLE *sSession,
			     CK_BYTE_PTR pEncryptedPart,
			     CK_ULONG ulEncryptedPartLen, CK_BYTE_PTR pPart,
			     CK_ULONG_PTR pulPartLen)
{
	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		return CKR_CRYPTOKI_NOT_INITIALIZED;
	}

	TRACE_ERROR("%s\n", ock_err(ERR_FUNCTION_NOT_SUPPORTED));
	return CKR_FUNCTION_NOT_SUPPORTED;
}


CK_RV SC_SignEncryptUpdate(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pPart,
			   CK_ULONG ulPartLen, CK_BYTE_PTR pEncryptedPart,
			   CK_ULONG_PTR pulEncryptedPartLen)
{
	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		return CKR_CRYPTOKI_NOT_INITIALIZED;
	}
	TRACE_ERROR("%s\n", ock_err(ERR_FUNCTION_NOT_SUPPORTED));
	return CKR_FUNCTION_NOT_SUPPORTED;
}


CK_RV SC_DecryptVerifyUpdate(ST_SESSION_HANDLE *sSession,
			     CK_BYTE_PTR pEncryptedPart,
			     CK_ULONG ulEncryptedPartLen, CK_BYTE_PTR pPart,
			     CK_ULONG_PTR pulPartLen)
{
	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		return CKR_CRYPTOKI_NOT_INITIALIZED;
	}
	TRACE_ERROR("%s\n", ock_err(ERR_FUNCTION_NOT_SUPPORTED));
	return CKR_FUNCTION_NOT_SUPPORTED;
}


CK_RV SC_GenerateKey(ST_SESSION_HANDLE *sSession, CK_MECHANISM_PTR pMechanism,
		     CK_ATTRIBUTE_PTR pTemplate, CK_ULONG ulCount,
		     CK_OBJECT_HANDLE_PTR phKey)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pMechanism || !phKey || (pTemplate == NULL && ulCount != 0)) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	rc = valid_mech(pMechanism, CKF_GENERATE);
	if (rc != CKR_OK)
		goto done;

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (pin_expired(&sess->session_info,
				nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}

	rc = key_mgr_generate_key(sess, pMechanism, pTemplate, ulCount, phKey);
	if (rc != CKR_OK)
		TRACE_DEVEL("key_mgr_generate_key() failed.\n");

done:
	TRACE_INFO("C_GenerateKey: rc = %08lx, sess = %ld, mech = %lx\n", rc,
		    (sess == NULL) ? -1 : (CK_LONG) sess->handle,
		    (pMechanism ? pMechanism->mechanism : -1));

#ifdef DEBUG
	CK_ATTRIBUTE *attr = NULL;
	int i;

	attr = pTemplate;
	for (i = 0; i < ulCount; i++, attr++) {
		CK_BYTE *ptr = (CK_BYTE *) attr->pValue;
		TRACE_DEBUG("%d: Attribute type: 0x%08lx,Value Length: %lu\n",
			    i, attr->type, attr->ulValueLen);
		if (attr->ulValueLen != ((CK_ULONG) -1) && (ptr != NULL)) {
			TRACE_DEBUG("First 4 bytes: %02x %02x %02x %02x\n",
				    ptr[0], ptr[1], ptr[2], ptr[3]);
		}
	}
#endif

	return rc;
}


CK_RV SC_GenerateKeyPair(ST_SESSION_HANDLE *sSession,
			 CK_MECHANISM_PTR pMechanism,
			 CK_ATTRIBUTE_PTR pPublicKeyTemplate,
			 CK_ULONG ulPublicKeyAttributeCount,
			 CK_ATTRIBUTE_PTR pPrivateKeyTemplate,
			 CK_ULONG ulPrivateKeyAttributeCount,
			 CK_OBJECT_HANDLE_PTR phPublicKey,
			 CK_OBJECT_HANDLE_PTR phPrivateKey)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pMechanism || !phPublicKey || !phPrivateKey ||
	   (!pPublicKeyTemplate && (ulPublicKeyAttributeCount != 0)) ||
	   (!pPrivateKeyTemplate && (ulPrivateKeyAttributeCount != 0))) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	rc = valid_mech(pMechanism, CKF_GENERATE_KEY_PAIR);
	if (rc != CKR_OK)
		goto done;

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (pin_expired(&sess->session_info,
			nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}

	rc = key_mgr_generate_key_pair(sess, pMechanism, pPublicKeyTemplate,
				       ulPublicKeyAttributeCount,
				       pPrivateKeyTemplate,
				       ulPrivateKeyAttributeCount,
				       phPublicKey, phPrivateKey);
	if (rc != CKR_OK)
		TRACE_DEVEL("key_mgr_generate_key_pair() failed.\n");

done:
	TRACE_INFO("C_GenerateKeyPair: rc = %08lx, sess = %ld, mech = %lu\n",
		   rc, (sess == NULL) ? -1 : ((CK_LONG) sess->handle),
		   (pMechanism ? pMechanism->mechanism : -1));

#ifdef DEBUG
	CK_ATTRIBUTE *attr = NULL;
	int i;

	if (rc == CKR_OK) {
		TRACE_DEBUG("Public handle: %lu, Private handle: %lu\n",
			    *phPublicKey, *phPrivateKey);
	}

	TRACE_DEBUG("Public Template:\n");
	attr = pPublicKeyTemplate;
	for (i = 0; i < ulPublicKeyAttributeCount; i++, attr++) {
		CK_BYTE *ptr = (CK_BYTE *) attr->pValue;
		TRACE_DEBUG("%d: Attribute type: 0x%08lx, Value Length: %lu\n",
			    i, attr->type, attr->ulValueLen);
		if (attr->ulValueLen != ((CK_ULONG) -1) && (ptr != NULL))
			TRACE_DEBUG("First 4 bytes: %02x %02x %02x %02x\n",
				    ptr[0], ptr[1], ptr[2], ptr[3]);
	}

	TRACE_DEBUG("Private Template:\n");
	attr = pPublicKeyTemplate;
	for (i = 0; i < ulPublicKeyAttributeCount; i++, attr++) {
		CK_BYTE *ptr = (CK_BYTE *) attr->pValue;
		TRACE_DEBUG("%d: Attribute type: 0x%08lx, Value Length: %lu\n",
			    i, attr->type, attr->ulValueLen);
		if (attr->ulValueLen != (CK_ULONG)(-1) && (ptr != NULL))
			TRACE_DEBUG("First 4 bytes: %02x %02x %02x %02x\n",
				    ptr[0], ptr[1], ptr[2], ptr[3]);
	}
#endif
	return rc;
}


CK_RV SC_WrapKey(ST_SESSION_HANDLE *sSession, CK_MECHANISM_PTR pMechanism,
		 CK_OBJECT_HANDLE hWrappingKey, CK_OBJECT_HANDLE hKey,
		 CK_BYTE_PTR pWrappedKey, CK_ULONG_PTR pulWrappedKeyLen)
{
	SESSION *sess = NULL;
	CK_BBOOL length_only = FALSE;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pMechanism || !pulWrappedKeyLen) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	rc = valid_mech(pMechanism, CKF_WRAP);
	if (rc != CKR_OK)
		goto done;

	if (!pWrappedKey)
		length_only = TRUE;

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (pin_expired(&sess->session_info,
			nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}

	rc = key_mgr_wrap_key(sess, length_only, pMechanism, hWrappingKey,
			      hKey, pWrappedKey, pulWrappedKeyLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("key_mgr_wrap_key() failed.\n");

done:
	TRACE_INFO("C_WrapKey: rc = %08lx, sess = %ld, encrypting key = %lu, "
		   "wrapped key = %lu\n", rc,
		   (sess == NULL) ? -1 : (CK_LONG) sess->handle,
		   hWrappingKey, hKey);

	return rc;
}


CK_RV SC_UnwrapKey(ST_SESSION_HANDLE *sSession, CK_MECHANISM_PTR pMechanism,
		   CK_OBJECT_HANDLE hUnwrappingKey, CK_BYTE_PTR pWrappedKey,
		   CK_ULONG ulWrappedKeyLen, CK_ATTRIBUTE_PTR pTemplate,
		   CK_ULONG ulCount, CK_OBJECT_HANDLE_PTR phKey)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pMechanism || !pWrappedKey ||
	    (!pTemplate && ulCount != 0) || !phKey) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	rc = valid_mech(pMechanism, CKF_UNWRAP);
	if (rc != CKR_OK)
		goto done;

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (pin_expired(&sess->session_info,
			nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}

	rc = key_mgr_unwrap_key(sess, pMechanism, pTemplate, ulCount,
				pWrappedKey, ulWrappedKeyLen, hUnwrappingKey,
				phKey);
	if (rc != CKR_OK)
		TRACE_DEVEL("key_mgr_unwrap_key() failed.\n");

done:
	TRACE_INFO("C_UnwrapKey: rc = %08lx, sess = %ld, decrypting key = %lu,"
		   "unwrapped key = %lu\n", rc,
		   (sess == NULL) ? -1 : (CK_LONG) sess->handle,
		   hUnwrappingKey, (phKey ? *phKey : 0));

#ifdef DEBUG
	CK_ATTRIBUTE *attr = NULL;
	CK_BYTE *ptr = NULL;
	int i;

	attr = pTemplate;
	for (i = 0; i < ulCount; i++, attr++) {
		ptr = (CK_BYTE *)attr->pValue;
		TRACE_DEBUG("%d: Attribute type:  0x%08lx, Value Length: %lu\n",
			    i, attr->type, attr->ulValueLen);
		if (attr->ulValueLen != ((CK_ULONG) -1) && (ptr != NULL))
			TRACE_DEBUG("First 4 bytes:  %02x %02x %02x %02x\n",
				    ptr[0], ptr[1], ptr[2], ptr[3]);

	}
#endif
	return rc;
}


CK_RV SC_DeriveKey(ST_SESSION_HANDLE *sSession, CK_MECHANISM_PTR pMechanism,
		   CK_OBJECT_HANDLE hBaseKey, CK_ATTRIBUTE_PTR pTemplate,
		   CK_ULONG ulCount, CK_OBJECT_HANDLE_PTR phKey)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pMechanism || (!pTemplate && ulCount != 0)) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	rc = valid_mech(pMechanism, CKF_DERIVE);
	if (rc != CKR_OK)
		goto done;

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	if (pin_expired(&sess->session_info,
			nv_token_data->token_info.flags) == TRUE) {
		TRACE_ERROR("%s\n", ock_err(ERR_PIN_EXPIRED));
		rc = CKR_PIN_EXPIRED;
		goto done;
	}

	rc = key_mgr_derive_key(sess, pMechanism, hBaseKey, phKey, pTemplate,
				ulCount );
	if (rc != CKR_OK)
		TRACE_DEVEL("key_mgr_derive_key() failed.\n");

done:
	TRACE_INFO("C_DeriveKey: rc = %08lx, sess = %ld, mech = %lu\n",
		   rc, (sess == NULL)?-1:(CK_LONG)sess->handle,
		   (pMechanism ? pMechanism->mechanism : -1));
#ifdef DEBUG
	CK_ATTRIBUTE *attr = NULL;
	CK_BYTE *ptr = NULL;
	int i;

	if (rc == CKR_OK) {
		switch (pMechanism->mechanism) {
		case CKM_SSL3_KEY_AND_MAC_DERIVE:
		{
			CK_SSL3_KEY_MAT_PARAMS *pReq;
			CK_SSL3_KEY_MAT_OUT    *pPtr;
			pReq = (CK_SSL3_KEY_MAT_PARAMS *)pMechanism->pParameter;
			pPtr = pReq->pReturnedKeyMaterial;

			TRACE_DEBUG("Client MAC key: %lu, Server MAC key: %lu, "
				    "Client Key: %lu, Server Key: %lu\n",
				    pPtr->hClientMacSecret,
				    pPtr->hServerMacSecret, pPtr->hClientKey,
				    pPtr->hServerKey);
		}
		break;

		case CKM_DH_PKCS_DERIVE:
		{
			TRACE_DEBUG("DH Shared Secret:\n");
		}
		break ;

		default:
			TRACE_DEBUG("Derived key: %lu\n", *phKey);
		}
	}

	attr = pTemplate;
	for (i = 0; i < ulCount; i++, attr++) {
		ptr = (CK_BYTE *)attr->pValue;

		TRACE_DEBUG("%d: Attribute type: 0x%08lx, Value Length: %lu\n",
			    i, attr->type, attr->ulValueLen);

		if (attr->ulValueLen != (CK_ULONG)(-1) && (ptr != NULL))
			TRACE_DEBUG("First 4 bytes: %02x %02x %02x %02x\n",
				    ptr[0], ptr[1], ptr[2], ptr[3]);

	}

#endif /* DEBUG */

	return rc;
}


CK_RV SC_SeedRandom(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pSeed,
		    CK_ULONG ulSeedLen)
{
	if (initialized == FALSE){
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		return CKR_CRYPTOKI_NOT_INITIALIZED;
	}

	TRACE_ERROR("%s\n", ock_err(ERR_RANDOM_SEED_NOT_SUPPORTED));
	return CKR_RANDOM_SEED_NOT_SUPPORTED;
}


CK_RV SC_GenerateRandom(ST_SESSION_HANDLE *sSession, CK_BYTE_PTR pRandomData,
			CK_ULONG ulRandomLen)
{
	SESSION *sess = NULL;
	CK_RV rc = CKR_OK;

	if (initialized == FALSE) {
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		rc = CKR_CRYPTOKI_NOT_INITIALIZED;
		goto done;
	}

	if (!pRandomData && ulRandomLen != 0) {
		TRACE_ERROR("%s\n", ock_err(ERR_ARGUMENTS_BAD));
		rc = CKR_ARGUMENTS_BAD;
		goto done;
	}

	sess = session_mgr_find(sSession->sessionh);
	if (!sess) {
		TRACE_ERROR("%s\n", ock_err(ERR_SESSION_HANDLE_INVALID));
		rc = CKR_SESSION_HANDLE_INVALID;
		goto done;
	}

	rc = rng_generate(pRandomData, ulRandomLen);
	if (rc != CKR_OK)
		TRACE_DEVEL("rng_generate() failed.\n");

done:
	TRACE_INFO("C_GenerateRandom: rc = %08lx, %lu bytes\n", rc, ulRandomLen);
	return rc;
}


CK_RV SC_GetFunctionStatus(ST_SESSION_HANDLE *sSession)
{
	if (initialized == FALSE){
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		return CKR_CRYPTOKI_NOT_INITIALIZED;
	}
	TRACE_ERROR("%s\n", ock_err(ERR_FUNCTION_NOT_PARALLEL));
	return CKR_FUNCTION_NOT_PARALLEL;
}


CK_RV SC_CancelFunction(ST_SESSION_HANDLE *sSession)
{
	if (initialized == FALSE){
		TRACE_ERROR("%s\n", ock_err(ERR_CRYPTOKI_NOT_INITIALIZED));
		return CKR_CRYPTOKI_NOT_INITIALIZED;
	}
	TRACE_ERROR("%s\n", ock_err(ERR_FUNCTION_NOT_PARALLEL));
	return CKR_FUNCTION_NOT_PARALLEL;
}


void SC_SetFunctionList(void) {
	function_list.ST_Initialize          = (void *)ST_Initialize;
	function_list.ST_GetTokenInfo        = SC_GetTokenInfo;
	function_list.ST_GetMechanismList    = SC_GetMechanismList;
	function_list.ST_GetMechanismInfo    = SC_GetMechanismInfo;
	function_list.ST_InitToken           = SC_InitToken;
	function_list.ST_InitPIN             = SC_InitPIN;
	function_list.ST_SetPIN              = SC_SetPIN;
	function_list.ST_OpenSession         = SC_OpenSession;
	function_list.ST_CloseSession        = SC_CloseSession;
	function_list.ST_GetSessionInfo      = SC_GetSessionInfo;
	function_list.ST_GetOperationState   = SC_GetOperationState;
	function_list.ST_SetOperationState   = SC_SetOperationState;
	function_list.ST_Login               = SC_Login;
	function_list.ST_Logout              = SC_Logout;
	function_list.ST_CreateObject        = SC_CreateObject;
	function_list.ST_CopyObject          = SC_CopyObject;
	function_list.ST_DestroyObject       = SC_DestroyObject;
	function_list.ST_GetObjectSize       = SC_GetObjectSize;
	function_list.ST_GetAttributeValue   = SC_GetAttributeValue;
	function_list.ST_SetAttributeValue   = SC_SetAttributeValue;
	function_list.ST_FindObjectsInit     = SC_FindObjectsInit;
	function_list.ST_FindObjects         = SC_FindObjects;
	function_list.ST_FindObjectsFinal    = SC_FindObjectsFinal;
	function_list.ST_EncryptInit         = SC_EncryptInit;
	function_list.ST_Encrypt             = SC_Encrypt;
	function_list.ST_EncryptUpdate       = SC_EncryptUpdate;
	function_list.ST_EncryptFinal        = SC_EncryptFinal;
	function_list.ST_DecryptInit         = SC_DecryptInit;
	function_list.ST_Decrypt             = SC_Decrypt;
	function_list.ST_DecryptUpdate       = SC_DecryptUpdate;
	function_list.ST_DecryptFinal        = SC_DecryptFinal;
	function_list.ST_DigestInit          = SC_DigestInit;
	function_list.ST_Digest              = SC_Digest;
	function_list.ST_DigestUpdate        = SC_DigestUpdate;
	function_list.ST_DigestKey           = SC_DigestKey;
	function_list.ST_DigestFinal         = SC_DigestFinal;
	function_list.ST_SignInit            = SC_SignInit;
	function_list.ST_Sign                = SC_Sign;
	function_list.ST_SignUpdate          = SC_SignUpdate;
	function_list.ST_SignFinal           = SC_SignFinal;
	function_list.ST_SignRecoverInit     = SC_SignRecoverInit;
	function_list.ST_SignRecover         = SC_SignRecover;
	function_list.ST_VerifyInit          = SC_VerifyInit;
	function_list.ST_Verify              = SC_Verify;
	function_list.ST_VerifyUpdate        = SC_VerifyUpdate;
	function_list.ST_VerifyFinal         = SC_VerifyFinal;
	function_list.ST_VerifyRecoverInit   = SC_VerifyRecoverInit;
	function_list.ST_VerifyRecover       = SC_VerifyRecover;
	function_list.ST_DigestEncryptUpdate = NULL; // SC_DigestEncryptUpdate;
	function_list.ST_DecryptDigestUpdate = NULL; // SC_DecryptDigestUpdate;
	function_list.ST_SignEncryptUpdate   = NULL; //SC_SignEncryptUpdate;
	function_list.ST_DecryptVerifyUpdate = NULL; // SC_DecryptVerifyUpdate;
	function_list.ST_GenerateKey         = SC_GenerateKey;
	function_list.ST_GenerateKeyPair     = SC_GenerateKeyPair;
	function_list.ST_WrapKey             = SC_WrapKey;
	function_list.ST_UnwrapKey           = SC_UnwrapKey;
	function_list.ST_DeriveKey           = SC_DeriveKey;
	function_list.ST_SeedRandom          = SC_SeedRandom ;
	function_list.ST_GenerateRandom      = SC_GenerateRandom;
	function_list.ST_GetFunctionStatus   = NULL; // SC_GetFunctionStatus;
	function_list.ST_CancelFunction      = NULL; // SC_CancelFunction;
}
