/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/ProviderResultsXml/DefinitionObjectCollectionXml.h"
#include "Doc/DocXml/ProviderResultsXml/RequestIdentifierXml.h"
#include "Doc/DocXml/ProviderResultsXml/SchemaXml.h"

#include "Doc/ProviderResultsDoc/CCdifDoc.h"
#include "Doc/ProviderResultsDoc/CDefinitionObjectCollectionDoc.h"
#include "Doc/ProviderResultsDoc/CRequestIdentifierDoc.h"
#include "Doc/ProviderResultsDoc/CSchemaDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/ProviderResultsXml/CdifXml.h"

using namespace Caf;

void CdifXml::add(
	const SmartPtrCCdifDoc cdifDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("CdifXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(cdifDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const SmartPtrCRequestIdentifierDoc requestIdentifierVal =
			cdifDoc->getRequestIdentifier();
		CAF_CM_VALIDATE_SMARTPTR(requestIdentifierVal);

		const SmartPtrCXmlElement requestIdentifierXml =
			thisXml->createAndAddElement("requestIdentifier");
		RequestIdentifierXml::add(requestIdentifierVal, requestIdentifierXml);

		const SmartPtrCDefinitionObjectCollectionDoc definitionObjectCollectionVal =
			cdifDoc->getDefinitionObjectCollection();
		if (! definitionObjectCollectionVal.IsNull()) {
			const SmartPtrCXmlElement definitionObjectCollectionXml =
				thisXml->createAndAddElement("definitionObjectCollection");
			DefinitionObjectCollectionXml::add(definitionObjectCollectionVal, definitionObjectCollectionXml);
		}

		const SmartPtrCSchemaDoc schemaVal =
			cdifDoc->getSchema();
		CAF_CM_VALIDATE_SMARTPTR(schemaVal);

		const SmartPtrCXmlElement schemaXml =
			thisXml->createAndAddElement("schema");
		SchemaXml::add(schemaVal, schemaXml);
	}
	CAF_CM_EXIT;
}

SmartPtrCCdifDoc CdifXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("CdifXml", "parse");

	SmartPtrCCdifDoc cdifDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const SmartPtrCXmlElement requestIdentifierXml =
			thisXml->findRequiredChild("requestIdentifier");

		SmartPtrCRequestIdentifierDoc requestIdentifierVal;
		if (! requestIdentifierXml.IsNull()) {
			requestIdentifierVal = RequestIdentifierXml::parse(requestIdentifierXml);
		}

		const SmartPtrCXmlElement definitionObjectCollectionXml =
			thisXml->findOptionalChild("definitionObjectCollection");

		SmartPtrCDefinitionObjectCollectionDoc definitionObjectCollectionVal;
		if (! definitionObjectCollectionXml.IsNull()) {
			definitionObjectCollectionVal = DefinitionObjectCollectionXml::parse(definitionObjectCollectionXml);
		}

		const SmartPtrCXmlElement schemaXml =
			thisXml->findRequiredChild("schema");

		SmartPtrCSchemaDoc schemaVal;
		if (! schemaXml.IsNull()) {
			schemaVal = SchemaXml::parse(schemaXml);
		}

		cdifDoc.CreateInstance();
		cdifDoc->initialize(
			requestIdentifierVal,
			definitionObjectCollectionVal,
			schemaVal);
	}
	CAF_CM_EXIT;

	return cdifDoc;
}

