/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/CafCoreTypesXml/RequestXml.h"
#include "Doc/DocXml/MgmtRequestXml/MgmtRequestXml.h"

#include "Doc/MgmtRequestDoc/CMgmtRequestDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/MgmtRequestXml/MgmtRequestXmlRoots.h"

using namespace Caf;

std::string XmlRoots::saveMgmtRequestToString(
	const SmartPtrCMgmtRequestDoc mgmtRequestDoc) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "saveMgmtRequestToString");

	std::string rc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(mgmtRequestDoc);

		const std::string schemaNamespace = DocXmlUtils::getSchemaNamespace("fx");
		const std::string schemaLocation = DocXmlUtils::getSchemaLocation("fx/MgmtRequest.xsd");

		const SmartPtrCXmlElement rootXml = CXmlUtils::createRootElement(
			"mgmtRequest", schemaNamespace, schemaLocation);
		MgmtRequestXml::add(mgmtRequestDoc, rootXml);

		rc = rootXml->saveToString();
	}
	CAF_CM_EXIT;

	return rc;
}

SmartPtrCMgmtRequestDoc XmlRoots::parseMgmtRequestFromString(
	const std::string xml) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "parseMgmtRequestFromString");

	SmartPtrCMgmtRequestDoc mgmtRequestDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_STRING(xml);

		const SmartPtrCXmlElement rootXml = RequestXml::parseString(xml, "caf:mgmtRequest");
		mgmtRequestDoc = MgmtRequestXml::parse(rootXml);
	}
	CAF_CM_EXIT;

	return mgmtRequestDoc;
}

void XmlRoots::saveMgmtRequestToFile(
	const SmartPtrCMgmtRequestDoc mgmtRequestDoc,
	const std::string filePath) {
	CAF_CM_STATIC_FUNC_LOG_VALIDATE("XmlRoots", "saveMgmtRequestToFile");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(mgmtRequestDoc);
		CAF_CM_VALIDATE_STRING(filePath);

		CAF_CM_LOG_DEBUG_VA1("Saving to file - %s", filePath.c_str());

		const std::string mgmtRequestStr =
			saveMgmtRequestToString(mgmtRequestDoc);
		FileSystemUtils::saveTextFile(filePath, mgmtRequestStr);
	}
	CAF_CM_EXIT;
}

SmartPtrCMgmtRequestDoc XmlRoots::parseMgmtRequestFromFile(
	const std::string filePath) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "parseMgmtRequestFromFile");

	SmartPtrCMgmtRequestDoc mgmtRequestDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_STRING(filePath);

		const SmartPtrCXmlElement rootXml = RequestXml::parseFile(filePath, "caf:mgmtRequest");
		mgmtRequestDoc = MgmtRequestXml::parse(rootXml);
	}
	CAF_CM_EXIT;

	return mgmtRequestDoc;
}
