/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *
 */

#include "stdafx.h"

#include "Doc/SchemaTypesDoc/CActionClassDoc.h"
#include "Doc/SchemaTypesDoc/CDataClassDoc.h"
#include "Doc/SchemaTypesDoc/CLogicalRelationshipDoc.h"
#include "Doc/SchemaTypesDoc/CPhysicalRelationshipDoc.h"
#include "Doc/ProviderResultsDoc/CSchemaDoc.h"

using namespace Caf;

/// Set of elements describing the objects that can be generated by the provider
CSchemaDoc::CSchemaDoc() :
	_isInitialized(false) {}
CSchemaDoc::~CSchemaDoc() {}

/// Initializes the object with everything required by this
/// container. Once initialized, this object cannot
/// be changed (i.e. it is immutable).
void CSchemaDoc::initialize(
	const std::deque<SmartPtrCDataClassDoc> dataClassCollection,
	const std::deque<SmartPtrCActionClassDoc> actionClassCollection,
	const std::deque<SmartPtrCLogicalRelationshipDoc> logicalRelationshipCollection,
	const std::deque<SmartPtrCPhysicalRelationshipDoc> physicalRelationshipCollection) {
	if (! _isInitialized) {
		_dataClassCollection = dataClassCollection;
		_actionClassCollection = actionClassCollection;
		_logicalRelationshipCollection = logicalRelationshipCollection;
		_physicalRelationshipCollection = physicalRelationshipCollection;

		_isInitialized = true;
	}
}

/// Accessor for the DataClassCollection
std::deque<SmartPtrCDataClassDoc> CSchemaDoc::getDataClassCollection() const {
	return _dataClassCollection;
}

/// Accessor for the ActionClassCollection
std::deque<SmartPtrCActionClassDoc> CSchemaDoc::getActionClassCollection() const {
	return _actionClassCollection;
}

/// Accessor for the LogicalRelationshipCollection
std::deque<SmartPtrCLogicalRelationshipDoc> CSchemaDoc::getLogicalRelationshipCollection() const {
	return _logicalRelationshipCollection;
}

/// Accessor for the PhysicalRelationshipCollection
std::deque<SmartPtrCPhysicalRelationshipDoc> CSchemaDoc::getPhysicalRelationshipCollection() const {
	return _physicalRelationshipCollection;
}






