/*
 * Copyright (c) 2010-2011, Red Hat, Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RED HAT, INC. DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RED HAT, INC. BE LIABLE
 * FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Author: Jan Friesse <jfriesse@redhat.com>
 */

#ifndef _RSFUNC_H_
#define _RSFUNC_H_

#ifdef __cplusplus
extern "C" {
#endif

extern int	rs_poll_timeout(int unicast_socket, int multicast_socket, int timeout,
    struct timeval *old_tstamp);

extern ssize_t	rs_receive_msg(int sock, struct sockaddr_storage *from_addr, char *msg,
    size_t msg_len, uint8_t *ttl, struct timeval *timestamp);

extern ssize_t	rs_sendto(int sock, const char *msg, size_t msg_size,
    const struct sockaddr_storage *to);

#ifdef __cplusplus
}
#endif

#endif /* _RSFUNC_H_ */
